#ifndef AVIPLAY_AVIREADSTREAM_H
#define AVIPLAY_AVIREADSTREAM_H

#include "ReadStream.h"
#include "image.h"
//#include <stdio.h>

AVM_BEGIN_NAMESPACE;

class IVideoDecoder;
class VideoQueue;

class ReadStreamV : public ReadStream
{
public:
    ReadStreamV(IMediaReadStream* stream);
    virtual ~ReadStreamV();
    virtual bool Eof() const;
    virtual size_t GetBuffering(size_t* b = 0) const;
    virtual IVideoDecoder* GetVideoDecoder() const { return m_pVideodecoder; }
    virtual CImage* GetFrame(bool readframe = false);
    virtual size_t GetFrameSize() const;
    virtual framepos_t GetPos() const;
    virtual size_t GetOutputFormat(void* format = 0, size_t size = 0) const;
    virtual double GetTime(framepos_t frame = ERR) const;
    virtual size_t GetVideoFormat(void* format, size_t size) const;
    virtual bool IsStreaming() const { return (m_pVideodecoder != 0); }
    virtual int ReadDirect(void* buffer, size_t bufsize, size_t samples,
			   size_t& samples_read, size_t& bytes_read,
			   int* flags = 0);
    virtual int ReadFrame(bool render = true);
    virtual framepos_t SeekToKeyFrame(framepos_t pos);
    virtual double SeekTimeToKeyFrame(double pos);
    virtual int SetDirection(bool d);
    virtual int SetBuffering(size_t maxsz = 1, IImageAllocator* ia = 0);
    virtual int SetOutputFormat(void* bi, size_t size);
    virtual int StartStreaming(const char*);
    virtual int StopStreaming();

protected:
    /* flush all precached frames */
    virtual void Flush();
    void ResetBuffers();
    void Update()
    {
	if (m_pFrame)
	{
	    m_dVTime = (double)m_pFrame->m_lTimestamp / 1000000.;
	    m_uiVPos = m_pFrame->m_uiPosition;
            //printf("UpdateF %f  %d\n", m_dVTime, m_uiVPos);
	}
	else
	{
	    m_dVTime = m_dLastTime;
	    m_uiVPos = m_uiLastPos;
            //printf("UpdateL %f  %d\n", m_dVTime, m_uiVPos);
	}
    }
    IVideoDecoder* m_pVideodecoder;
    VideoQueue* m_pQueue;
    CImage* m_pFrame;
    IImageAllocator* m_pQueueAllocator;
    double m_dVTime;
    uint_t m_uiVPos;
    size_t m_uiQueueSize;
    int flip;
    bool m_bCapable16b;
    bool m_bHadKeyFrame;
};

AVM_END_NAMESPACE;

#endif // AVIPLAY_READSTREAM_H
