{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetPosition: TVector3;
    procedure SetPosition(const Value: TVector3);
    function GetFocalDistance: Single;
    procedure SetFocalDistance(const Value: Single);
    function GetNearDistance: Single;
    procedure SetNearDistance(const Value: Single);
    function GetFarDistance: Single;
    procedure SetFarDistance(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdPosition: TSFVec3f;
    { Internal wrapper for property @link(Position). This wrapper API may change, we advise to access simpler @link(Position) instead. }
    public property FdPosition: TSFVec3f read FFdPosition;
    {  }
    property Position: TVector3 read GetPosition write SetPosition;

    strict private FFdFocalDistance: TSFFloat;
    { Internal wrapper for property @link(FocalDistance). This wrapper API may change, we advise to access simpler @link(FocalDistance) instead. }
    public property FdFocalDistance: TSFFloat read FFdFocalDistance;
    {  }
    property FocalDistance: Single read GetFocalDistance write SetFocalDistance;

    strict private FFdNearDistance: TSFFloat;
    { Internal wrapper for property @link(NearDistance). This wrapper API may change, we advise to access simpler @link(NearDistance) instead. }
    public property FdNearDistance: TSFFloat read FFdNearDistance;
    { Ignored. Unknown extension to VRML 1.0 spec, found on models in http://www-vrl.umich.edu/sel_prj/EECS498/ . }
    property NearDistance: Single read GetNearDistance write SetNearDistance;

    strict private FFdFarDistance: TSFFloat;
    { Internal wrapper for property @link(FarDistance). This wrapper API may change, we advise to access simpler @link(FarDistance) instead. }
    public property FdFarDistance: TSFFloat read FFdFarDistance;
    { Ignored. Unknown extension to VRML 1.0 spec, found on models in http://www-vrl.umich.edu/sel_prj/EECS498/ . }
    property FarDistance: Single read GetFarDistance write SetFarDistance;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractCameraNode_1 ----------------------------------------------- }

function TAbstractCameraNode_1.GetPosition: TVector3;
begin
  Result := FdPosition.Value;
end;

procedure TAbstractCameraNode_1.SetPosition(const Value: TVector3);
begin
  FdPosition.Send(Value);
end;

function TAbstractCameraNode_1.GetFocalDistance: Single;
begin
  Result := FdFocalDistance.Value;
end;

procedure TAbstractCameraNode_1.SetFocalDistance(const Value: Single);
begin
  FdFocalDistance.Send(Value);
end;

function TAbstractCameraNode_1.GetNearDistance: Single;
begin
  Result := FdNearDistance.Value;
end;

procedure TAbstractCameraNode_1.SetNearDistance(const Value: Single);
begin
  FdNearDistance.Send(Value);
end;

function TAbstractCameraNode_1.GetFarDistance: Single;
begin
  Result := FdFarDistance.Value;
end;

procedure TAbstractCameraNode_1.SetFarDistance(const Value: Single);
begin
  FdFarDistance.Send(Value);
end;

class function TAbstractCameraNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TAbstractCameraNode_1.ClassX3DType: String;
begin
  Result := 'AbstractVrml1Camera';
end;

procedure TAbstractCameraNode_1.CreateNode;
begin
  inherited;

  FFdPosition := TSFVec3f.Create(Self, True, 'position', Vector3(0, 0, 1));
   FdPosition.ChangeAlways := chViewpointVectors;
  AddField(FFdPosition);

  FFdFocalDistance := TSFFloat.Create(Self, True, 'focalDistance', 5);
   FdFocalDistance.ChangeAlways := chVisibleNonGeometry;
   FdFocalDistance.MustBeNonnegative := true;
  AddField(FFdFocalDistance);

  FFdNearDistance := TSFFloat.Create(Self, True, 'nearDistance', 0);
   FdNearDistance.ChangeAlways := chViewpointVectors;
  AddField(FFdNearDistance);

  FFdFarDistance := TSFFloat.Create(Self, True, 'farDistance', 0);
   FdFarDistance.ChangeAlways := chViewpointVectors;
  AddField(FFdFarDistance);
end;

{$endif read_implementation}
