{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
{$ifndef CASTLE_SLIM_NODES}
    function GetFogCoord: TFogCoordinateNode;
    procedure SetFogCoord(const Value: TFogCoordinateNode);
{$endif not CASTLE_SLIM_NODES}
    function GetColorPerVertex: Boolean;
    procedure SetColorPerVertex(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventSet_colorIndex: TMFInt32Event;
    {  }
    public property EventSet_colorIndex: TMFInt32Event read FEventSet_colorIndex;

    strict private FEventSet_coordIndex: TMFInt32Event;
    {  }
    public property EventSet_coordIndex: TMFInt32Event read FEventSet_coordIndex;

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdAttrib: TMFNode;
    { Internal wrapper for property @link(Attrib). This wrapper API may change, we advise to access simpler @link(Attrib) instead. }
    public property FdAttrib: TMFNode read FFdAttrib;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    {  }
    procedure SetAttrib(const Value: array of TAbstractVertexAttributeNode);
{$endif not CASTLE_SLIM_NODES}

    strict private FFdColor: TSFNode;
    { Internal wrapper for property @link(Color). This wrapper API may change, we advise to access simpler @link(Color) instead. }
    public property FdColor: TSFNode read FFdColor;
    {  }
    property Color: TAbstractColorNode read GetColor write SetColor;

    strict private FFdCoord: TSFNode;
    { Internal wrapper for property @link(Coord). This wrapper API may change, we advise to access simpler @link(Coord) instead. }
    public property FdCoord: TSFNode read FFdCoord;
    {  }
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdFogCoord: TSFNode;
    { Internal wrapper for property @link(FogCoord). This wrapper API may change, we advise to access simpler @link(FogCoord) instead. }
    public property FdFogCoord: TSFNode read FFdFogCoord;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    {  }
    property FogCoord: TFogCoordinateNode read GetFogCoord write SetFogCoord;
{$endif not CASTLE_SLIM_NODES}

    strict private FFdColorIndex: TMFInt32;
    { Internal wrapper for property @link(ColorIndex). This wrapper API may change, we advise to access simpler @link(ColorIndex) instead. }
    public property FdColorIndex: TMFInt32 read FFdColorIndex;
    {  }
    procedure SetColorIndex(const Value: array of LongInt); overload;
    {  }
    procedure SetColorIndex(const Value: TLongIntList); overload;

    strict private FFdColorPerVertex: TSFBool;
    { Internal wrapper for property @link(ColorPerVertex). This wrapper API may change, we advise to access simpler @link(ColorPerVertex) instead. }
    public property FdColorPerVertex: TSFBool read FFdColorPerVertex;
    {  }
    property ColorPerVertex: Boolean read GetColorPerVertex write SetColorPerVertex;

    strict private FFdCoordIndex: TMFInt32;
    { Internal wrapper for property @link(CoordIndex). This wrapper API may change, we advise to access simpler @link(CoordIndex) instead. }
    public property FdCoordIndex: TMFInt32 read FFdCoordIndex;
    {  }
    procedure SetCoordIndex(const Value: array of LongInt); overload;
    {  }
    procedure SetCoordIndex(const Value: TLongIntList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TIndexedLineSetNode ----------------------------------------------- }

{$ifndef CASTLE_SLIM_NODES}
procedure TIndexedLineSetNode.SetAttrib(const Value: array of TAbstractVertexAttributeNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractVertexAttributeNode));
  FdAttrib.Send(A);
end;

{$endif not CASTLE_SLIM_NODES}
function TIndexedLineSetNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TIndexedLineSetNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

{$ifndef CASTLE_SLIM_NODES}
function TIndexedLineSetNode.GetFogCoord: TFogCoordinateNode;
begin
  if FdFogCoord.Value is TFogCoordinateNode then
    Result := TFogCoordinateNode(FdFogCoord.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetFogCoord(const Value: TFogCoordinateNode);
begin
  FdFogCoord.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
procedure TIndexedLineSetNode.SetColorIndex(const Value: array of LongInt);
begin
  FdColorIndex.Send(Value);
end;

procedure TIndexedLineSetNode.SetColorIndex(const Value: TLongIntList);
begin
  FdColorIndex.Send(Value);
end;

function TIndexedLineSetNode.GetColorPerVertex: Boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TIndexedLineSetNode.SetColorPerVertex(const Value: Boolean);
begin
  FdColorPerVertex.Send(Value);
end;

procedure TIndexedLineSetNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TIndexedLineSetNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

class function TIndexedLineSetNode.ClassX3DType: String;
begin
  Result := 'IndexedLineSet';
end;

procedure TIndexedLineSetNode.CreateNode;
begin
  inherited;

  FEventSet_colorIndex := TMFInt32Event.Create(Self, 'set_colorIndex', true);
  AddEvent(FEventSet_colorIndex);

  FEventSet_coordIndex := TMFInt32Event.Create(Self, 'set_coordIndex', true);
  AddEvent(FEventSet_coordIndex);

{$ifndef CASTLE_SLIM_NODES}
  FFdAttrib := TMFNode.Create(Self, True, 'attrib', [TAbstractVertexAttributeNode]);
   FdAttrib.ChangeAlways := chGeometry;
  AddField(FFdAttrib);
{$endif not CASTLE_SLIM_NODES}

  FFdColor := TSFNode.Create(Self, True, 'color', [TAbstractColorNode]);
   FdColor.ChangeAlways := chGeometry;
  AddField(FFdColor);

  FFdCoord := TSFNode.Create(Self, True, 'coord', [TAbstractCoordinateNode]);
   FdCoord.ChangeAlways := chGeometry;
  AddField(FFdCoord);

{$ifndef CASTLE_SLIM_NODES}
  FFdFogCoord := TSFNode.Create(Self, True, 'fogCoord', [TFogCoordinateNode]);
   FdFogCoord.ChangeAlways := chGeometry;
  AddField(FFdFogCoord);
{$endif not CASTLE_SLIM_NODES}

  FFdColorIndex := TMFInt32.Create(Self, False, 'colorIndex', []);
   FdColorIndex.ChangeAlways := chGeometry;
  AddField(FFdColorIndex);

  FFdColorPerVertex := TSFBool.Create(Self, False, 'colorPerVertex', true);
   FdColorPerVertex.ChangeAlways := chGeometry;
  AddField(FFdColorPerVertex);

  FFdCoordIndex := TMFInt32.Create(Self, False, 'coordIndex', []);
   FdCoordIndex.ChangeAlways := chGeometry;
  AddField(FFdCoordIndex);
end;

{$endif read_implementation}
