{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdStartIndex: TSFLong;
    { Internal wrapper for property @link(StartIndex). This wrapper API may change, we advise to access simpler @link(StartIndex) instead. }
    public property FdStartIndex: TSFLong read FFdStartIndex;

    strict private FFdNumPoints: TSFLong;
    { Internal wrapper for property @link(NumPoints). This wrapper API may change, we advise to access simpler @link(NumPoints) instead. }
    public property FdNumPoints: TSFLong read FFdNumPoints;

{$endif read_interface}

{$ifdef read_implementation}

{ TPointSetNode_1 ----------------------------------------------- }

class function TPointSetNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TPointSetNode_1.ClassX3DType: String;
begin
  Result := 'PointSet';
end;

procedure TPointSetNode_1.CreateNode;
begin
  inherited;

  FFdStartIndex := TSFLong.Create(Self, True, 'startIndex', 0);
   FdStartIndex.ChangeAlways := chGeometry;
  AddField(FFdStartIndex);

  FFdNumPoints := TSFLong.Create(Self, True, 'numPoints', -1);
   FdNumPoints.ChangeAlways := chGeometry;
  AddField(FFdNumPoints);
end;

{$endif read_implementation}
