{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetUpdate: TTextureUpdate;
    procedure SetUpdate(const Value: TTextureUpdate);
    function GetSize: Integer;
    procedure SetSize(const Value: Integer);
    function GetTextureProperties: TTexturePropertiesNode;
    procedure SetTextureProperties(const Value: TTexturePropertiesNode);
    function GetBias: TVector3;
    procedure SetBias(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdUpdate: TSFStringEnum;
    { Internal wrapper for property @code(Update). This wrapper API may change, we advise to access simpler @code(Update) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUpdate: TSFStringEnum read FFdUpdate;
    { When to update the texture contents. }
    property Update: TTextureUpdate read GetUpdate write SetUpdate;

    strict private FFdSize: TSFInt32;
    { Internal wrapper for property @code(Size). This wrapper API may change, we advise to access simpler @code(Size) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSize: TSFInt32 read FFdSize;
    {  }
    property Size: Integer read GetSize write SetSize;

    strict private FFdTextureProperties: TSFNode;
    { Internal wrapper for property @code(TextureProperties). This wrapper API may change, we advise to access simpler @code(TextureProperties) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTextureProperties: TSFNode read FFdTextureProperties;
    {  }
    property TextureProperties: TTexturePropertiesNode read GetTextureProperties write SetTextureProperties;

    strict private FFdBias: TSFVec3f;
    { Internal wrapper for property @code(Bias). This wrapper API may change, we advise to access simpler @code(Bias) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBias: TSFVec3f read FFdBias;
    { Bias from shape center to the point from which we generate a cubemap texture. TODO: for now in world space, should be in shape space. }
    property Bias: TVector3 read GetBias write SetBias;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeneratedCubeMapTextureNode ----------------------------------------------- }

function TGeneratedCubeMapTextureNode.GetUpdate: TTextureUpdate;
begin
  Result := TTextureUpdate(FdUpdate.EnumValue);
end;

procedure TGeneratedCubeMapTextureNode.SetUpdate(const Value: TTextureUpdate);
begin
  FdUpdate.SendEnumValue(Ord(Value));
end;

function TGeneratedCubeMapTextureNode.GetSize: Integer;
begin
  Result := FdSize.Value;
end;

procedure TGeneratedCubeMapTextureNode.SetSize(const Value: Integer);
begin
  FdSize.Send(Value);
end;

function TGeneratedCubeMapTextureNode.GetTextureProperties: TTexturePropertiesNode;
begin
  if FdTextureProperties.Value is TTexturePropertiesNode then
    Result := TTexturePropertiesNode(FdTextureProperties.Value)
  else
    Result := nil;
end;

procedure TGeneratedCubeMapTextureNode.SetTextureProperties(const Value: TTexturePropertiesNode);
begin
  FdTextureProperties.Send(Value);
end;

function TGeneratedCubeMapTextureNode.GetBias: TVector3;
begin
  Result := FdBias.Value;
end;

procedure TGeneratedCubeMapTextureNode.SetBias(const Value: TVector3);
begin
  FdBias.Send(Value);
end;

class function TGeneratedCubeMapTextureNode.ClassX3DType: String;
begin
  Result := 'GeneratedCubeMapTexture';
end;

procedure TGeneratedCubeMapTextureNode.CreateNode;
begin
  inherited;

  FFdUpdate := TSFStringEnum.Create(Self, True, 'update', @TextureUpdateNames, Ord(High(TextureUpdateNames)) + 1, Ord(upNone));
   FdUpdate.ChangeAlways := chRedisplay;
  AddField(FFdUpdate);

  FFdSize := TSFInt32.Create(Self, False, 'size', 128);
   FdSize.ChangeAlways := chTextureRendererProperties;
   FdSize.MustBeNonnegative := true;
  AddField(FFdSize);

  FFdTextureProperties := TSFNode.Create(Self, False, 'textureProperties', [TTexturePropertiesNode]);
   FdTextureProperties.ChangeAlways := chTextureRendererProperties;
  AddField(FFdTextureProperties);

  FFdBias := TSFVec3f.Create(Self, True, 'bias', Vector3(0, 0, 0));
   FdBias.ChangeAlways := chNone;
  AddField(FFdBias);
end;

{$endif read_implementation}
