/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <arch/header.ld>

/* SYSTEM_IMEM : 0x8600000 - 0x8607FFF */
#define SSRAM_START(addr) REGION_START(ssram, addr)
#define SSRAM_END(addr) REGION_END(ssram, addr)

/* BOOT_IMEM   : 0x8C00000 - 0x8D80000 */
#define BSRAM_START(addr) REGION_START(bsram, addr)
#define BSRAM_END(addr) REGION_END(bsram, addr)

SECTIONS
{
	SSRAM_START(0x8600000)
	SSRAM_END(0x8608000)

	BSRAM_START(0x8C00000)
	OVERLAP_VERSTAGE_ROMSTAGE(0x8C00000, 100K)
	REGION(fw_reserved2, 0x8C19000, 0x16000, 4096)
	BOOTBLOCK(0x8C2F000, 40K)
	TTB(0x8C39000, 56K)
	VBOOT2_WORK(0x8C47000, 12K)
	STACK(0x8C4B000, 16K)
	TIMESTAMP(0x8C4F000, 1K)
	PRERAM_CBMEM_CONSOLE(0x8C4F400, 32K)
	PRERAM_CBFS_CACHE(0x8C57400, 62K)
	CBFS_MCACHE(0x8C66C00, 8K)
	FMAP_CACHE(0x8C68C00, 2K)
	REGION(bsram_unused, 0x8C69400, 0xA1C00, 0x100)
	BSRAM_END(0x8D80000)

	DRAM_START(0x80000000)
	/* DDR Carveout for BL31 usage */
	REGION(dram_reserved, 0x85000000, 0x5100000, 4096)
	POSTRAM_CBFS_CACHE(0x9F800000, 384K)
	RAMSTAGE(0x9F860000, 2M)
}
