/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "globals.h"
#include <map>
#include <fstream>
#include <iostream>
#include "viewwin.h"
#include "ansi_color_codes.h"
using namespace std;

extern string APP_NAME;
extern int SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_DEPTH;

extern int SAMPLE_RATE;
extern float MIN_TONIC, MAX_TONIC;

extern string TUNING;
extern string INTERVALS_FILE;
extern int NUM_INTERVALS;
extern string FIRST_INTERVAL_NAME, LAST_INTERVAL_NAME;
extern map <string, float> INTERVALS;
extern vector<float> INTERVALS_SEQ;
extern map <string, int> NOTE_POS;

extern int NUM_VOLUMES, LAST_VOLUME;
extern float DELTA_VOLUME;

extern int NUM_MICROTONES;
extern int LEFT, BOTTOM, RIGHT, TOP, HEIGHT;

extern string SCALE;

extern int FPS, USLEEP;
extern double FPS_T;

extern float DELTA_BPM;

extern int DRONE_HANDLE_SIZE;

extern int NUM_OCTAVES;

void calc_volume_vars (int h) { // for microtonal keyboard
  NUM_VOLUMES = h + 1;
  DELTA_VOLUME = 1./ h;
  LAST_VOLUME = h;
}

bool load_globals::load_intervals (const string& fname) {

  extern string dotdin;
  ifstream file ((dotdin + fname).c_str(), ios::in);
  if (file) {

    INTERVALS_FILE = fname;

    file >> ignore >> NUM_INTERVALS;

    INTERVALS.clear ();
    INTERVALS_SEQ.clear ();

    for (int i = 0, last = NUM_INTERVALS - 1, pos = 0; i < NUM_INTERVALS; ++i, ++pos) {

      string note_name;
      float value;

      file >> note_name >> value;

      if (i == 0) FIRST_INTERVAL_NAME = note_name;
      else if (i == last) LAST_INTERVAL_NAME = note_name;

      INTERVALS [note_name] = value;
      NOTE_POS [note_name] = pos;

      INTERVALS_SEQ.push_back (value);

    }

    return true;


  } else return false;

}

load_globals::load_globals () {

  extern string dotdin;

  string fname = dotdin + "globals";

  ifstream file (fname.c_str(), ios::in);
  if (file) {
    cout << LOAD << "<<< loading globals";
    APP_NAME = "DIN Is Noise 5.2.1";
    file >> ignore >> SCREEN_WIDTH >> SCREEN_HEIGHT;
    file >> ignore >> INTERVALS_FILE;
    file >> ignore >> SCALE;
    file >> ignore >> LEFT >> BOTTOM;
    file >> ignore >> HEIGHT;
    file >> ignore >> NUM_MICROTONES;
    file >> ignore >> NUM_OCTAVES;
    file >> ignore >> viewport::handle_radius;
    cout << ", done >>>" << ENDL;
  } else {
    cout << "bad globals file, will use defaults " << endl;
    APP_NAME = "din";
    SCREEN_WIDTH = 640; SCREEN_HEIGHT = 480;
    INTERVALS_FILE = "et.tuning";
    SCALE = "minor";
    LEFT = 0; BOTTOM = 150; HEIGHT = 300;
    NUM_MICROTONES = 150;
  }

  load_intervals (INTERVALS_FILE);
  TOP = BOTTOM + HEIGHT;
  calc_volume_vars (HEIGHT);

}




