/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

add_task(async function() {
  const URI = "data:text/html;charset=utf-8,<iframe id='test-iframe'></iframe>";

  await BrowserTestUtils.withNewTab({ gBrowser, url: URI }, async function(
    browser
  ) {
    await SpecialPowers.spawn(browser, [], test_body);
  });
});

async function test_body() {
  let docshell = docShell;

  is(
    docshell.touchEventsOverride,
    Ci.nsIDocShell.TOUCHEVENTS_OVERRIDE_NONE,
    "touchEventsOverride flag should be initially set to NONE"
  );

  docshell.touchEventsOverride = Ci.nsIDocShell.TOUCHEVENTS_OVERRIDE_DISABLED;
  is(
    docshell.touchEventsOverride,
    Ci.nsIDocShell.TOUCHEVENTS_OVERRIDE_DISABLED,
    "touchEventsOverride flag should be changed to DISABLED"
  );

  let frameWin = content.document.querySelector("#test-iframe").contentWindow;
  docshell = frameWin.docShell;
  is(
    docshell.touchEventsOverride,
    Ci.nsIDocShell.TOUCHEVENTS_OVERRIDE_DISABLED,
    "touchEventsOverride flag should be passed on to frames."
  );

  let newFrame = content.document.createElement("iframe");
  content.document.body.appendChild(newFrame);

  let newFrameWin = newFrame.contentWindow;
  docshell = newFrameWin.docShell;
  is(
    docshell.touchEventsOverride,
    Ci.nsIDocShell.TOUCHEVENTS_OVERRIDE_DISABLED,
    "Newly created frames should use the new touchEventsOverride flag"
  );

  newFrameWin.location.reload();
  await ContentTaskUtils.waitForEvent(newFrameWin, "load");

  docshell = newFrameWin.docShell;
  is(
    docshell.touchEventsOverride,
    Ci.nsIDocShell.TOUCHEVENTS_OVERRIDE_DISABLED,
    "New touchEventsOverride flag should persist across reloads"
  );
}
