// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/retail/v2beta/catalog_service.proto

package retailpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for
// [CatalogService.ListCatalogs][google.cloud.retail.v2beta.CatalogService.ListCatalogs]
// method.
type ListCatalogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account resource name with an associated location.
	//
	// If the caller does not have permission to list
	// [Catalog][google.cloud.retail.v2beta.Catalog]s under this location,
	// regardless of whether or not this location exists, a PERMISSION_DENIED
	// error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of [Catalog][google.cloud.retail.v2beta.Catalog]s to return.
	// If unspecified, defaults to 50. The maximum allowed value is 1000. Values
	// above 1000 will be coerced to 1000.
	//
	// If this field is negative, an INVALID_ARGUMENT is returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token
	// [ListCatalogsResponse.next_page_token][google.cloud.retail.v2beta.ListCatalogsResponse.next_page_token],
	// received from a previous
	// [CatalogService.ListCatalogs][google.cloud.retail.v2beta.CatalogService.ListCatalogs]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [CatalogService.ListCatalogs][google.cloud.retail.v2beta.CatalogService.ListCatalogs]
	// must match the call that provided the page token. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCatalogsRequest) Reset() {
	*x = ListCatalogsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCatalogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCatalogsRequest) ProtoMessage() {}

func (x *ListCatalogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCatalogsRequest.ProtoReflect.Descriptor instead.
func (*ListCatalogsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListCatalogsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCatalogsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCatalogsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for
// [CatalogService.ListCatalogs][google.cloud.retail.v2beta.CatalogService.ListCatalogs]
// method.
type ListCatalogsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All the customer's [Catalog][google.cloud.retail.v2beta.Catalog]s.
	Catalogs []*Catalog `protobuf:"bytes,1,rep,name=catalogs,proto3" json:"catalogs,omitempty"`
	// A token that can be sent as
	// [ListCatalogsRequest.page_token][google.cloud.retail.v2beta.ListCatalogsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCatalogsResponse) Reset() {
	*x = ListCatalogsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCatalogsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCatalogsResponse) ProtoMessage() {}

func (x *ListCatalogsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCatalogsResponse.ProtoReflect.Descriptor instead.
func (*ListCatalogsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListCatalogsResponse) GetCatalogs() []*Catalog {
	if x != nil {
		return x.Catalogs
	}
	return nil
}

func (x *ListCatalogsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for
// [CatalogService.UpdateCatalog][google.cloud.retail.v2beta.CatalogService.UpdateCatalog]
// method.
type UpdateCatalogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [Catalog][google.cloud.retail.v2beta.Catalog] to update.
	//
	// If the caller does not have permission to update the
	// [Catalog][google.cloud.retail.v2beta.Catalog], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	//
	// If the [Catalog][google.cloud.retail.v2beta.Catalog] to update does not
	// exist, a NOT_FOUND error is returned.
	Catalog *Catalog `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
	// Indicates which fields in the provided
	// [Catalog][google.cloud.retail.v2beta.Catalog] to update.
	//
	// If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
	// is returned.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCatalogRequest) Reset() {
	*x = UpdateCatalogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCatalogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCatalogRequest) ProtoMessage() {}

func (x *UpdateCatalogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCatalogRequest.ProtoReflect.Descriptor instead.
func (*UpdateCatalogRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateCatalogRequest) GetCatalog() *Catalog {
	if x != nil {
		return x.Catalog
	}
	return nil
}

func (x *UpdateCatalogRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message to set a specified branch as new default_branch.
type SetDefaultBranchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full resource name of the catalog, such as
	// `projects/*/locations/global/catalogs/default_catalog`.
	Catalog string `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
	// The final component of the resource name of a branch.
	//
	// This field must be one of "0", "1" or "2". Otherwise, an INVALID_ARGUMENT
	// error is returned.
	//
	// If there are no sufficient active products in the targeted branch and
	// [force][google.cloud.retail.v2beta.SetDefaultBranchRequest.force] is not
	// set, a FAILED_PRECONDITION error is returned.
	BranchId string `protobuf:"bytes,2,opt,name=branch_id,json=branchId,proto3" json:"branch_id,omitempty"`
	// Some note on this request, this can be retrieved by
	// [CatalogService.GetDefaultBranch][google.cloud.retail.v2beta.CatalogService.GetDefaultBranch]
	// before next valid default branch set occurs.
	//
	// This field must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	Note string `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
	// If set to true, it permits switching to a branch with
	// [branch_id][google.cloud.retail.v2beta.SetDefaultBranchRequest.branch_id]
	// even if it has no sufficient active products.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *SetDefaultBranchRequest) Reset() {
	*x = SetDefaultBranchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetDefaultBranchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDefaultBranchRequest) ProtoMessage() {}

func (x *SetDefaultBranchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDefaultBranchRequest.ProtoReflect.Descriptor instead.
func (*SetDefaultBranchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{3}
}

func (x *SetDefaultBranchRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

func (x *SetDefaultBranchRequest) GetBranchId() string {
	if x != nil {
		return x.BranchId
	}
	return ""
}

func (x *SetDefaultBranchRequest) GetNote() string {
	if x != nil {
		return x.Note
	}
	return ""
}

func (x *SetDefaultBranchRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message to show which branch is currently the default branch.
type GetDefaultBranchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent catalog resource name, such as
	// `projects/*/locations/global/catalogs/default_catalog`.
	Catalog string `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
}

func (x *GetDefaultBranchRequest) Reset() {
	*x = GetDefaultBranchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDefaultBranchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDefaultBranchRequest) ProtoMessage() {}

func (x *GetDefaultBranchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDefaultBranchRequest.ProtoReflect.Descriptor instead.
func (*GetDefaultBranchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{4}
}

func (x *GetDefaultBranchRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

// Response message of
// [CatalogService.GetDefaultBranch][google.cloud.retail.v2beta.CatalogService.GetDefaultBranch].
type GetDefaultBranchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full resource name of the branch id currently set as default branch.
	Branch string `protobuf:"bytes,1,opt,name=branch,proto3" json:"branch,omitempty"`
	// The time when this branch is set to default.
	SetTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=set_time,json=setTime,proto3" json:"set_time,omitempty"`
	// This corresponds to
	// [SetDefaultBranchRequest.note][google.cloud.retail.v2beta.SetDefaultBranchRequest.note]
	// field, when this branch was set as default.
	Note string `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
}

func (x *GetDefaultBranchResponse) Reset() {
	*x = GetDefaultBranchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDefaultBranchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDefaultBranchResponse) ProtoMessage() {}

func (x *GetDefaultBranchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDefaultBranchResponse.ProtoReflect.Descriptor instead.
func (*GetDefaultBranchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetDefaultBranchResponse) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *GetDefaultBranchResponse) GetSetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SetTime
	}
	return nil
}

func (x *GetDefaultBranchResponse) GetNote() string {
	if x != nil {
		return x.Note
	}
	return ""
}

// Request for
// [CatalogService.GetCompletionConfig][google.cloud.retail.v2beta.CatalogService.GetCompletionConfig]
// method.
type GetCompletionConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full CompletionConfig resource name. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/completionConfig`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCompletionConfigRequest) Reset() {
	*x = GetCompletionConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCompletionConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCompletionConfigRequest) ProtoMessage() {}

func (x *GetCompletionConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCompletionConfigRequest.ProtoReflect.Descriptor instead.
func (*GetCompletionConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{6}
}

func (x *GetCompletionConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for
// [CatalogService.UpdateCompletionConfig][google.cloud.retail.v2beta.CatalogService.UpdateCompletionConfig]
// method.
type UpdateCompletionConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The
	// [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig] to update.
	//
	// If the caller does not have permission to update the
	// [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig], then a
	// PERMISSION_DENIED error is returned.
	//
	// If the [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig] to
	// update does not exist, a NOT_FOUND error is returned.
	CompletionConfig *CompletionConfig `protobuf:"bytes,1,opt,name=completion_config,json=completionConfig,proto3" json:"completion_config,omitempty"`
	// Indicates which fields in the provided
	// [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig] to update.
	// The following are the only supported fields:
	//
	// * [CompletionConfig.matching_order][google.cloud.retail.v2beta.CompletionConfig.matching_order]
	// * [CompletionConfig.max_suggestions][google.cloud.retail.v2beta.CompletionConfig.max_suggestions]
	// * [CompletionConfig.min_prefix_length][google.cloud.retail.v2beta.CompletionConfig.min_prefix_length]
	// * [CompletionConfig.auto_learning][google.cloud.retail.v2beta.CompletionConfig.auto_learning]
	//
	// If not set, all supported fields are updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCompletionConfigRequest) Reset() {
	*x = UpdateCompletionConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCompletionConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCompletionConfigRequest) ProtoMessage() {}

func (x *UpdateCompletionConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCompletionConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateCompletionConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateCompletionConfigRequest) GetCompletionConfig() *CompletionConfig {
	if x != nil {
		return x.CompletionConfig
	}
	return nil
}

func (x *UpdateCompletionConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for
// [CatalogService.GetAttributesConfig][google.cloud.retail.v2beta.CatalogService.GetAttributesConfig]
// method.
type GetAttributesConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full AttributesConfig resource name. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAttributesConfigRequest) Reset() {
	*x = GetAttributesConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAttributesConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAttributesConfigRequest) ProtoMessage() {}

func (x *GetAttributesConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAttributesConfigRequest.ProtoReflect.Descriptor instead.
func (*GetAttributesConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetAttributesConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for
// [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2beta.CatalogService.UpdateAttributesConfig]
// method.
type UpdateAttributesConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig] to update.
	AttributesConfig *AttributesConfig `protobuf:"bytes,1,opt,name=attributes_config,json=attributesConfig,proto3" json:"attributes_config,omitempty"`
	// Indicates which fields in the provided
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig] to update.
	// The following is the only supported field:
	//
	// * [AttributesConfig.catalog_attributes][google.cloud.retail.v2beta.AttributesConfig.catalog_attributes]
	//
	// If not set, all supported fields are updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAttributesConfigRequest) Reset() {
	*x = UpdateAttributesConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAttributesConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAttributesConfigRequest) ProtoMessage() {}

func (x *UpdateAttributesConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAttributesConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateAttributesConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateAttributesConfigRequest) GetAttributesConfig() *AttributesConfig {
	if x != nil {
		return x.AttributesConfig
	}
	return nil
}

func (x *UpdateAttributesConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for
// [CatalogService.AddCatalogAttribute][google.cloud.retail.v2beta.CatalogService.AddCatalogAttribute]
// method.
type AddCatalogAttributeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full AttributesConfig resource name. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
	AttributesConfig string `protobuf:"bytes,1,opt,name=attributes_config,json=attributesConfig,proto3" json:"attributes_config,omitempty"`
	// Required. The
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to add.
	CatalogAttribute *CatalogAttribute `protobuf:"bytes,2,opt,name=catalog_attribute,json=catalogAttribute,proto3" json:"catalog_attribute,omitempty"`
}

func (x *AddCatalogAttributeRequest) Reset() {
	*x = AddCatalogAttributeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddCatalogAttributeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddCatalogAttributeRequest) ProtoMessage() {}

func (x *AddCatalogAttributeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddCatalogAttributeRequest.ProtoReflect.Descriptor instead.
func (*AddCatalogAttributeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{10}
}

func (x *AddCatalogAttributeRequest) GetAttributesConfig() string {
	if x != nil {
		return x.AttributesConfig
	}
	return ""
}

func (x *AddCatalogAttributeRequest) GetCatalogAttribute() *CatalogAttribute {
	if x != nil {
		return x.CatalogAttribute
	}
	return nil
}

// Request for
// [CatalogService.RemoveCatalogAttribute][google.cloud.retail.v2beta.CatalogService.RemoveCatalogAttribute]
// method.
type RemoveCatalogAttributeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full AttributesConfig resource name. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
	AttributesConfig string `protobuf:"bytes,1,opt,name=attributes_config,json=attributesConfig,proto3" json:"attributes_config,omitempty"`
	// Required. The attribute name key of the
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to remove.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *RemoveCatalogAttributeRequest) Reset() {
	*x = RemoveCatalogAttributeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveCatalogAttributeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveCatalogAttributeRequest) ProtoMessage() {}

func (x *RemoveCatalogAttributeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveCatalogAttributeRequest.ProtoReflect.Descriptor instead.
func (*RemoveCatalogAttributeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{11}
}

func (x *RemoveCatalogAttributeRequest) GetAttributesConfig() string {
	if x != nil {
		return x.AttributesConfig
	}
	return ""
}

func (x *RemoveCatalogAttributeRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Request for
// [CatalogService.BatchRemoveCatalogAttributes][google.cloud.retail.v2beta.CatalogService.BatchRemoveCatalogAttributes]
// method.
type BatchRemoveCatalogAttributesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The attributes config resource shared by all catalog attributes
	// being deleted. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
	AttributesConfig string `protobuf:"bytes,1,opt,name=attributes_config,json=attributesConfig,proto3" json:"attributes_config,omitempty"`
	// Required. The attribute name keys of the
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute]s to delete.
	// A maximum of 1000 catalog attributes can be deleted in a batch.
	AttributeKeys []string `protobuf:"bytes,2,rep,name=attribute_keys,json=attributeKeys,proto3" json:"attribute_keys,omitempty"`
}

func (x *BatchRemoveCatalogAttributesRequest) Reset() {
	*x = BatchRemoveCatalogAttributesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRemoveCatalogAttributesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRemoveCatalogAttributesRequest) ProtoMessage() {}

func (x *BatchRemoveCatalogAttributesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRemoveCatalogAttributesRequest.ProtoReflect.Descriptor instead.
func (*BatchRemoveCatalogAttributesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{12}
}

func (x *BatchRemoveCatalogAttributesRequest) GetAttributesConfig() string {
	if x != nil {
		return x.AttributesConfig
	}
	return ""
}

func (x *BatchRemoveCatalogAttributesRequest) GetAttributeKeys() []string {
	if x != nil {
		return x.AttributeKeys
	}
	return nil
}

// Response of the
// [CatalogService.BatchRemoveCatalogAttributes][google.cloud.retail.v2beta.CatalogService.BatchRemoveCatalogAttributes].
type BatchRemoveCatalogAttributesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Catalog attributes that were deleted. Only pre-loaded [catalog
	// attributes][google.cloud.retail.v2beta.CatalogAttribute] that are
	// neither [in
	// use][google.cloud.retail.v2beta.CatalogAttribute.in_use] by
	// products nor predefined can be deleted.
	DeletedCatalogAttributes []string `protobuf:"bytes,1,rep,name=deleted_catalog_attributes,json=deletedCatalogAttributes,proto3" json:"deleted_catalog_attributes,omitempty"`
	// Catalog attributes that were reset. [Catalog
	// attributes][google.cloud.retail.v2beta.CatalogAttribute] that are either
	// [in use][google.cloud.retail.v2beta.CatalogAttribute.in_use] by products or
	// are predefined attributes cannot be deleted; however, their configuration
	// properties will reset to default values upon removal request.
	ResetCatalogAttributes []string `protobuf:"bytes,2,rep,name=reset_catalog_attributes,json=resetCatalogAttributes,proto3" json:"reset_catalog_attributes,omitempty"`
}

func (x *BatchRemoveCatalogAttributesResponse) Reset() {
	*x = BatchRemoveCatalogAttributesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRemoveCatalogAttributesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRemoveCatalogAttributesResponse) ProtoMessage() {}

func (x *BatchRemoveCatalogAttributesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRemoveCatalogAttributesResponse.ProtoReflect.Descriptor instead.
func (*BatchRemoveCatalogAttributesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{13}
}

func (x *BatchRemoveCatalogAttributesResponse) GetDeletedCatalogAttributes() []string {
	if x != nil {
		return x.DeletedCatalogAttributes
	}
	return nil
}

func (x *BatchRemoveCatalogAttributesResponse) GetResetCatalogAttributes() []string {
	if x != nil {
		return x.ResetCatalogAttributes
	}
	return nil
}

// Request for
// [CatalogService.ReplaceCatalogAttribute][google.cloud.retail.v2beta.CatalogService.ReplaceCatalogAttribute]
// method.
type ReplaceCatalogAttributeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full AttributesConfig resource name. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
	AttributesConfig string `protobuf:"bytes,1,opt,name=attributes_config,json=attributesConfig,proto3" json:"attributes_config,omitempty"`
	// Required. The updated
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute].
	CatalogAttribute *CatalogAttribute `protobuf:"bytes,2,opt,name=catalog_attribute,json=catalogAttribute,proto3" json:"catalog_attribute,omitempty"`
	// Indicates which fields in the provided
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to update.
	// The following are NOT supported:
	//
	// * [CatalogAttribute.key][google.cloud.retail.v2beta.CatalogAttribute.key]
	//
	// If not set, all supported fields are updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *ReplaceCatalogAttributeRequest) Reset() {
	*x = ReplaceCatalogAttributeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplaceCatalogAttributeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceCatalogAttributeRequest) ProtoMessage() {}

func (x *ReplaceCatalogAttributeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceCatalogAttributeRequest.ProtoReflect.Descriptor instead.
func (*ReplaceCatalogAttributeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP(), []int{14}
}

func (x *ReplaceCatalogAttributeRequest) GetAttributesConfig() string {
	if x != nil {
		return x.AttributesConfig
	}
	return ""
}

func (x *ReplaceCatalogAttributeRequest) GetCatalogAttribute() *CatalogAttribute {
	if x != nil {
		return x.CatalogAttribute
	}
	return nil
}

func (x *ReplaceCatalogAttributeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_cloud_retail_v2beta_catalog_service_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2beta_catalog_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x94, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x7f, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x52, 0x08, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x07,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc1, 0x01,
	0x0a, 0x17, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x07, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x07,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x3e, 0x0a, 0x09, 0x62, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x41, 0x1e, 0x0a,
	0x1c, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x08, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x22, 0x57, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x07,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa,
	0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x22, 0xa0, 0x01, 0x0a, 0x18, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x12, 0x35, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x73, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x22, 0x60, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xbc, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x5e, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x60,
	0x0a, 0x1a, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x0a, 0x26, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xbc, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5e, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xd9, 0x01, 0x0a, 0x1a, 0x41, 0x64, 0x64, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b,
	0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x11, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x1d,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a,
	0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x22, 0xae, 0x01, 0x0a, 0x23, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x11, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4b, 0x65,
	0x79, 0x73, 0x22, 0x9e, 0x01, 0x0a, 0x24, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x1a, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x18, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x22, 0x9a, 0x02, 0x0a, 0x1e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x11, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x32, 0xb3, 0x16, 0x0a, 0x0e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x12, 0xc7, 0x01, 0x0a, 0x0d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x22, 0x5f, 0xda, 0x41, 0x13, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x43, 0x3a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x32, 0x38, 0x2f, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x59, 0xda, 0x41, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x12, 0xd5, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x56, 0xda, 0x41, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0xcd, 0x01, 0x0a, 0x13, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x50, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0x92, 0x02, 0x0a, 0x16, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8e, 0x01,
	0xda, 0x41, 0x1d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x3a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x53, 0x2f, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0xcd,
	0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x50, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0x92,
	0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x8e, 0x01, 0xda, 0x41, 0x1d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x3a, 0x11, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x53,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x13, 0x41, 0x64, 0x64, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x67, 0x3a, 0x01, 0x2a, 0x22, 0x62, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a, 0x61, 0x64, 0x64,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x12, 0xf3, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x3a, 0x01, 0x2a, 0x22,
	0x65, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x99, 0x02, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x76, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x70, 0x3a, 0x01, 0x2a, 0x22, 0x6b, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0xf6, 0x01, 0x0a, 0x17, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x71, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6b,
	0x3a, 0x01, 0x2a, 0x22, 0x66, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x7d, 0x3a, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x1a, 0x49, 0xca, 0x41, 0x15,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd2, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x13, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49,
	0x4c, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02,
	0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x1d, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2beta_catalog_service_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2beta_catalog_service_proto_rawDescData = file_google_cloud_retail_v2beta_catalog_service_proto_rawDesc
)

func file_google_cloud_retail_v2beta_catalog_service_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2beta_catalog_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2beta_catalog_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2beta_catalog_service_proto_rawDescData)
	})
	return file_google_cloud_retail_v2beta_catalog_service_proto_rawDescData
}

var file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_retail_v2beta_catalog_service_proto_goTypes = []interface{}{
	(*ListCatalogsRequest)(nil),                  // 0: google.cloud.retail.v2beta.ListCatalogsRequest
	(*ListCatalogsResponse)(nil),                 // 1: google.cloud.retail.v2beta.ListCatalogsResponse
	(*UpdateCatalogRequest)(nil),                 // 2: google.cloud.retail.v2beta.UpdateCatalogRequest
	(*SetDefaultBranchRequest)(nil),              // 3: google.cloud.retail.v2beta.SetDefaultBranchRequest
	(*GetDefaultBranchRequest)(nil),              // 4: google.cloud.retail.v2beta.GetDefaultBranchRequest
	(*GetDefaultBranchResponse)(nil),             // 5: google.cloud.retail.v2beta.GetDefaultBranchResponse
	(*GetCompletionConfigRequest)(nil),           // 6: google.cloud.retail.v2beta.GetCompletionConfigRequest
	(*UpdateCompletionConfigRequest)(nil),        // 7: google.cloud.retail.v2beta.UpdateCompletionConfigRequest
	(*GetAttributesConfigRequest)(nil),           // 8: google.cloud.retail.v2beta.GetAttributesConfigRequest
	(*UpdateAttributesConfigRequest)(nil),        // 9: google.cloud.retail.v2beta.UpdateAttributesConfigRequest
	(*AddCatalogAttributeRequest)(nil),           // 10: google.cloud.retail.v2beta.AddCatalogAttributeRequest
	(*RemoveCatalogAttributeRequest)(nil),        // 11: google.cloud.retail.v2beta.RemoveCatalogAttributeRequest
	(*BatchRemoveCatalogAttributesRequest)(nil),  // 12: google.cloud.retail.v2beta.BatchRemoveCatalogAttributesRequest
	(*BatchRemoveCatalogAttributesResponse)(nil), // 13: google.cloud.retail.v2beta.BatchRemoveCatalogAttributesResponse
	(*ReplaceCatalogAttributeRequest)(nil),       // 14: google.cloud.retail.v2beta.ReplaceCatalogAttributeRequest
	(*Catalog)(nil),                              // 15: google.cloud.retail.v2beta.Catalog
	(*fieldmaskpb.FieldMask)(nil),                // 16: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                // 17: google.protobuf.Timestamp
	(*CompletionConfig)(nil),                     // 18: google.cloud.retail.v2beta.CompletionConfig
	(*AttributesConfig)(nil),                     // 19: google.cloud.retail.v2beta.AttributesConfig
	(*CatalogAttribute)(nil),                     // 20: google.cloud.retail.v2beta.CatalogAttribute
	(*emptypb.Empty)(nil),                        // 21: google.protobuf.Empty
}
var file_google_cloud_retail_v2beta_catalog_service_proto_depIdxs = []int32{
	15, // 0: google.cloud.retail.v2beta.ListCatalogsResponse.catalogs:type_name -> google.cloud.retail.v2beta.Catalog
	15, // 1: google.cloud.retail.v2beta.UpdateCatalogRequest.catalog:type_name -> google.cloud.retail.v2beta.Catalog
	16, // 2: google.cloud.retail.v2beta.UpdateCatalogRequest.update_mask:type_name -> google.protobuf.FieldMask
	17, // 3: google.cloud.retail.v2beta.GetDefaultBranchResponse.set_time:type_name -> google.protobuf.Timestamp
	18, // 4: google.cloud.retail.v2beta.UpdateCompletionConfigRequest.completion_config:type_name -> google.cloud.retail.v2beta.CompletionConfig
	16, // 5: google.cloud.retail.v2beta.UpdateCompletionConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 6: google.cloud.retail.v2beta.UpdateAttributesConfigRequest.attributes_config:type_name -> google.cloud.retail.v2beta.AttributesConfig
	16, // 7: google.cloud.retail.v2beta.UpdateAttributesConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 8: google.cloud.retail.v2beta.AddCatalogAttributeRequest.catalog_attribute:type_name -> google.cloud.retail.v2beta.CatalogAttribute
	20, // 9: google.cloud.retail.v2beta.ReplaceCatalogAttributeRequest.catalog_attribute:type_name -> google.cloud.retail.v2beta.CatalogAttribute
	16, // 10: google.cloud.retail.v2beta.ReplaceCatalogAttributeRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 11: google.cloud.retail.v2beta.CatalogService.ListCatalogs:input_type -> google.cloud.retail.v2beta.ListCatalogsRequest
	2,  // 12: google.cloud.retail.v2beta.CatalogService.UpdateCatalog:input_type -> google.cloud.retail.v2beta.UpdateCatalogRequest
	3,  // 13: google.cloud.retail.v2beta.CatalogService.SetDefaultBranch:input_type -> google.cloud.retail.v2beta.SetDefaultBranchRequest
	4,  // 14: google.cloud.retail.v2beta.CatalogService.GetDefaultBranch:input_type -> google.cloud.retail.v2beta.GetDefaultBranchRequest
	6,  // 15: google.cloud.retail.v2beta.CatalogService.GetCompletionConfig:input_type -> google.cloud.retail.v2beta.GetCompletionConfigRequest
	7,  // 16: google.cloud.retail.v2beta.CatalogService.UpdateCompletionConfig:input_type -> google.cloud.retail.v2beta.UpdateCompletionConfigRequest
	8,  // 17: google.cloud.retail.v2beta.CatalogService.GetAttributesConfig:input_type -> google.cloud.retail.v2beta.GetAttributesConfigRequest
	9,  // 18: google.cloud.retail.v2beta.CatalogService.UpdateAttributesConfig:input_type -> google.cloud.retail.v2beta.UpdateAttributesConfigRequest
	10, // 19: google.cloud.retail.v2beta.CatalogService.AddCatalogAttribute:input_type -> google.cloud.retail.v2beta.AddCatalogAttributeRequest
	11, // 20: google.cloud.retail.v2beta.CatalogService.RemoveCatalogAttribute:input_type -> google.cloud.retail.v2beta.RemoveCatalogAttributeRequest
	12, // 21: google.cloud.retail.v2beta.CatalogService.BatchRemoveCatalogAttributes:input_type -> google.cloud.retail.v2beta.BatchRemoveCatalogAttributesRequest
	14, // 22: google.cloud.retail.v2beta.CatalogService.ReplaceCatalogAttribute:input_type -> google.cloud.retail.v2beta.ReplaceCatalogAttributeRequest
	1,  // 23: google.cloud.retail.v2beta.CatalogService.ListCatalogs:output_type -> google.cloud.retail.v2beta.ListCatalogsResponse
	15, // 24: google.cloud.retail.v2beta.CatalogService.UpdateCatalog:output_type -> google.cloud.retail.v2beta.Catalog
	21, // 25: google.cloud.retail.v2beta.CatalogService.SetDefaultBranch:output_type -> google.protobuf.Empty
	5,  // 26: google.cloud.retail.v2beta.CatalogService.GetDefaultBranch:output_type -> google.cloud.retail.v2beta.GetDefaultBranchResponse
	18, // 27: google.cloud.retail.v2beta.CatalogService.GetCompletionConfig:output_type -> google.cloud.retail.v2beta.CompletionConfig
	18, // 28: google.cloud.retail.v2beta.CatalogService.UpdateCompletionConfig:output_type -> google.cloud.retail.v2beta.CompletionConfig
	19, // 29: google.cloud.retail.v2beta.CatalogService.GetAttributesConfig:output_type -> google.cloud.retail.v2beta.AttributesConfig
	19, // 30: google.cloud.retail.v2beta.CatalogService.UpdateAttributesConfig:output_type -> google.cloud.retail.v2beta.AttributesConfig
	19, // 31: google.cloud.retail.v2beta.CatalogService.AddCatalogAttribute:output_type -> google.cloud.retail.v2beta.AttributesConfig
	19, // 32: google.cloud.retail.v2beta.CatalogService.RemoveCatalogAttribute:output_type -> google.cloud.retail.v2beta.AttributesConfig
	13, // 33: google.cloud.retail.v2beta.CatalogService.BatchRemoveCatalogAttributes:output_type -> google.cloud.retail.v2beta.BatchRemoveCatalogAttributesResponse
	19, // 34: google.cloud.retail.v2beta.CatalogService.ReplaceCatalogAttribute:output_type -> google.cloud.retail.v2beta.AttributesConfig
	23, // [23:35] is the sub-list for method output_type
	11, // [11:23] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2beta_catalog_service_proto_init() }
func file_google_cloud_retail_v2beta_catalog_service_proto_init() {
	if File_google_cloud_retail_v2beta_catalog_service_proto != nil {
		return
	}
	file_google_cloud_retail_v2beta_catalog_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCatalogsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCatalogsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCatalogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetDefaultBranchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDefaultBranchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDefaultBranchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCompletionConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCompletionConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAttributesConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAttributesConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddCatalogAttributeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveCatalogAttributeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRemoveCatalogAttributesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRemoveCatalogAttributesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplaceCatalogAttributeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2beta_catalog_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_retail_v2beta_catalog_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2beta_catalog_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_retail_v2beta_catalog_service_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2beta_catalog_service_proto = out.File
	file_google_cloud_retail_v2beta_catalog_service_proto_rawDesc = nil
	file_google_cloud_retail_v2beta_catalog_service_proto_goTypes = nil
	file_google_cloud_retail_v2beta_catalog_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CatalogServiceClient is the client API for CatalogService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CatalogServiceClient interface {
	// Lists all the [Catalog][google.cloud.retail.v2beta.Catalog]s associated
	// with the project.
	ListCatalogs(ctx context.Context, in *ListCatalogsRequest, opts ...grpc.CallOption) (*ListCatalogsResponse, error)
	// Updates the [Catalog][google.cloud.retail.v2beta.Catalog]s.
	UpdateCatalog(ctx context.Context, in *UpdateCatalogRequest, opts ...grpc.CallOption) (*Catalog, error)
	// Set a specified branch id as default branch. API methods such as
	// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search],
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct],
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
	// will treat requests using "default_branch" to the actual branch id set as
	// default.
	//
	// For example, if `projects/*/locations/*/catalogs/*/branches/1` is set as
	// default, setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent
	// to setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/1`.
	//
	// Using multiple branches can be useful when developers would like
	// to have a staging branch to test and verify for future usage. When it
	// becomes ready, developers switch on the staging branch using this API while
	// keeping using `projects/*/locations/*/catalogs/*/branches/default_branch`
	// as [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch]
	// to route the traffic to this staging branch.
	//
	// CAUTION: If you have live predict/search traffic, switching the default
	// branch could potentially cause outages if the ID space of the new branch is
	// very different from the old one.
	//
	// More specifically:
	//
	//   - PredictionService will only return product IDs from branch {newBranch}.
	//   - SearchService will only return product IDs from branch {newBranch}
	//     (if branch is not explicitly set).
	//   - UserEventService will only join events with products from branch
	//     {newBranch}.
	SetDefaultBranch(ctx context.Context, in *SetDefaultBranchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get which branch is currently default branch set by
	// [CatalogService.SetDefaultBranch][google.cloud.retail.v2beta.CatalogService.SetDefaultBranch]
	// method under a specified parent catalog.
	GetDefaultBranch(ctx context.Context, in *GetDefaultBranchRequest, opts ...grpc.CallOption) (*GetDefaultBranchResponse, error)
	// Gets a [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig].
	GetCompletionConfig(ctx context.Context, in *GetCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error)
	// Updates the
	// [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig]s.
	UpdateCompletionConfig(ctx context.Context, in *UpdateCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error)
	// Gets an [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	GetAttributesConfig(ctx context.Context, in *GetAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Updates the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// The catalog attributes in the request will be updated in the catalog, or
	// inserted if they do not exist. Existing catalog attributes not included in
	// the request will remain unchanged. Attributes that are assigned to
	// products, but do not exist at the catalog level, are always included in the
	// response. The product attribute is assigned default values for missing
	// catalog attribute fields, e.g., searchable and dynamic facetable options.
	UpdateAttributesConfig(ctx context.Context, in *UpdateAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Adds the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// add already exists, an ALREADY_EXISTS error is returned.
	AddCatalogAttribute(ctx context.Context, in *AddCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Removes the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// remove does not exist, a NOT_FOUND error is returned.
	RemoveCatalogAttribute(ctx context.Context, in *RemoveCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Removes all specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute]s from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	BatchRemoveCatalogAttributes(ctx context.Context, in *BatchRemoveCatalogAttributesRequest, opts ...grpc.CallOption) (*BatchRemoveCatalogAttributesResponse, error)
	// Replaces the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] in the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig] by updating
	// the catalog attribute with the same
	// [CatalogAttribute.key][google.cloud.retail.v2beta.CatalogAttribute.key].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// replace does not exist, a NOT_FOUND error is returned.
	ReplaceCatalogAttribute(ctx context.Context, in *ReplaceCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
}

type catalogServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCatalogServiceClient(cc grpc.ClientConnInterface) CatalogServiceClient {
	return &catalogServiceClient{cc}
}

func (c *catalogServiceClient) ListCatalogs(ctx context.Context, in *ListCatalogsRequest, opts ...grpc.CallOption) (*ListCatalogsResponse, error) {
	out := new(ListCatalogsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/ListCatalogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateCatalog(ctx context.Context, in *UpdateCatalogRequest, opts ...grpc.CallOption) (*Catalog, error) {
	out := new(Catalog)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/UpdateCatalog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) SetDefaultBranch(ctx context.Context, in *SetDefaultBranchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/SetDefaultBranch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetDefaultBranch(ctx context.Context, in *GetDefaultBranchRequest, opts ...grpc.CallOption) (*GetDefaultBranchResponse, error) {
	out := new(GetDefaultBranchResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/GetDefaultBranch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetCompletionConfig(ctx context.Context, in *GetCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error) {
	out := new(CompletionConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/GetCompletionConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateCompletionConfig(ctx context.Context, in *UpdateCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error) {
	out := new(CompletionConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/UpdateCompletionConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetAttributesConfig(ctx context.Context, in *GetAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/GetAttributesConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateAttributesConfig(ctx context.Context, in *UpdateAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/UpdateAttributesConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) AddCatalogAttribute(ctx context.Context, in *AddCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/AddCatalogAttribute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) RemoveCatalogAttribute(ctx context.Context, in *RemoveCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/RemoveCatalogAttribute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) BatchRemoveCatalogAttributes(ctx context.Context, in *BatchRemoveCatalogAttributesRequest, opts ...grpc.CallOption) (*BatchRemoveCatalogAttributesResponse, error) {
	out := new(BatchRemoveCatalogAttributesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/BatchRemoveCatalogAttributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ReplaceCatalogAttribute(ctx context.Context, in *ReplaceCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.CatalogService/ReplaceCatalogAttribute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CatalogServiceServer is the server API for CatalogService service.
type CatalogServiceServer interface {
	// Lists all the [Catalog][google.cloud.retail.v2beta.Catalog]s associated
	// with the project.
	ListCatalogs(context.Context, *ListCatalogsRequest) (*ListCatalogsResponse, error)
	// Updates the [Catalog][google.cloud.retail.v2beta.Catalog]s.
	UpdateCatalog(context.Context, *UpdateCatalogRequest) (*Catalog, error)
	// Set a specified branch id as default branch. API methods such as
	// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search],
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct],
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
	// will treat requests using "default_branch" to the actual branch id set as
	// default.
	//
	// For example, if `projects/*/locations/*/catalogs/*/branches/1` is set as
	// default, setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent
	// to setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/1`.
	//
	// Using multiple branches can be useful when developers would like
	// to have a staging branch to test and verify for future usage. When it
	// becomes ready, developers switch on the staging branch using this API while
	// keeping using `projects/*/locations/*/catalogs/*/branches/default_branch`
	// as [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch]
	// to route the traffic to this staging branch.
	//
	// CAUTION: If you have live predict/search traffic, switching the default
	// branch could potentially cause outages if the ID space of the new branch is
	// very different from the old one.
	//
	// More specifically:
	//
	//   - PredictionService will only return product IDs from branch {newBranch}.
	//   - SearchService will only return product IDs from branch {newBranch}
	//     (if branch is not explicitly set).
	//   - UserEventService will only join events with products from branch
	//     {newBranch}.
	SetDefaultBranch(context.Context, *SetDefaultBranchRequest) (*emptypb.Empty, error)
	// Get which branch is currently default branch set by
	// [CatalogService.SetDefaultBranch][google.cloud.retail.v2beta.CatalogService.SetDefaultBranch]
	// method under a specified parent catalog.
	GetDefaultBranch(context.Context, *GetDefaultBranchRequest) (*GetDefaultBranchResponse, error)
	// Gets a [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig].
	GetCompletionConfig(context.Context, *GetCompletionConfigRequest) (*CompletionConfig, error)
	// Updates the
	// [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig]s.
	UpdateCompletionConfig(context.Context, *UpdateCompletionConfigRequest) (*CompletionConfig, error)
	// Gets an [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	GetAttributesConfig(context.Context, *GetAttributesConfigRequest) (*AttributesConfig, error)
	// Updates the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// The catalog attributes in the request will be updated in the catalog, or
	// inserted if they do not exist. Existing catalog attributes not included in
	// the request will remain unchanged. Attributes that are assigned to
	// products, but do not exist at the catalog level, are always included in the
	// response. The product attribute is assigned default values for missing
	// catalog attribute fields, e.g., searchable and dynamic facetable options.
	UpdateAttributesConfig(context.Context, *UpdateAttributesConfigRequest) (*AttributesConfig, error)
	// Adds the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// add already exists, an ALREADY_EXISTS error is returned.
	AddCatalogAttribute(context.Context, *AddCatalogAttributeRequest) (*AttributesConfig, error)
	// Removes the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// remove does not exist, a NOT_FOUND error is returned.
	RemoveCatalogAttribute(context.Context, *RemoveCatalogAttributeRequest) (*AttributesConfig, error)
	// Removes all specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute]s from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	BatchRemoveCatalogAttributes(context.Context, *BatchRemoveCatalogAttributesRequest) (*BatchRemoveCatalogAttributesResponse, error)
	// Replaces the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] in the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig] by updating
	// the catalog attribute with the same
	// [CatalogAttribute.key][google.cloud.retail.v2beta.CatalogAttribute.key].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// replace does not exist, a NOT_FOUND error is returned.
	ReplaceCatalogAttribute(context.Context, *ReplaceCatalogAttributeRequest) (*AttributesConfig, error)
}

// UnimplementedCatalogServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCatalogServiceServer struct {
}

func (*UnimplementedCatalogServiceServer) ListCatalogs(context.Context, *ListCatalogsRequest) (*ListCatalogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCatalogs not implemented")
}
func (*UnimplementedCatalogServiceServer) UpdateCatalog(context.Context, *UpdateCatalogRequest) (*Catalog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCatalog not implemented")
}
func (*UnimplementedCatalogServiceServer) SetDefaultBranch(context.Context, *SetDefaultBranchRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultBranch not implemented")
}
func (*UnimplementedCatalogServiceServer) GetDefaultBranch(context.Context, *GetDefaultBranchRequest) (*GetDefaultBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultBranch not implemented")
}
func (*UnimplementedCatalogServiceServer) GetCompletionConfig(context.Context, *GetCompletionConfigRequest) (*CompletionConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCompletionConfig not implemented")
}
func (*UnimplementedCatalogServiceServer) UpdateCompletionConfig(context.Context, *UpdateCompletionConfigRequest) (*CompletionConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCompletionConfig not implemented")
}
func (*UnimplementedCatalogServiceServer) GetAttributesConfig(context.Context, *GetAttributesConfigRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttributesConfig not implemented")
}
func (*UnimplementedCatalogServiceServer) UpdateAttributesConfig(context.Context, *UpdateAttributesConfigRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttributesConfig not implemented")
}
func (*UnimplementedCatalogServiceServer) AddCatalogAttribute(context.Context, *AddCatalogAttributeRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddCatalogAttribute not implemented")
}
func (*UnimplementedCatalogServiceServer) RemoveCatalogAttribute(context.Context, *RemoveCatalogAttributeRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveCatalogAttribute not implemented")
}
func (*UnimplementedCatalogServiceServer) BatchRemoveCatalogAttributes(context.Context, *BatchRemoveCatalogAttributesRequest) (*BatchRemoveCatalogAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRemoveCatalogAttributes not implemented")
}
func (*UnimplementedCatalogServiceServer) ReplaceCatalogAttribute(context.Context, *ReplaceCatalogAttributeRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplaceCatalogAttribute not implemented")
}

func RegisterCatalogServiceServer(s *grpc.Server, srv CatalogServiceServer) {
	s.RegisterService(&_CatalogService_serviceDesc, srv)
}

func _CatalogService_ListCatalogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCatalogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListCatalogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/ListCatalogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListCatalogs(ctx, req.(*ListCatalogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/UpdateCatalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateCatalog(ctx, req.(*UpdateCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_SetDefaultBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).SetDefaultBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/SetDefaultBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).SetDefaultBranch(ctx, req.(*SetDefaultBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetDefaultBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetDefaultBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/GetDefaultBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetDefaultBranch(ctx, req.(*GetDefaultBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetCompletionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCompletionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetCompletionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/GetCompletionConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetCompletionConfig(ctx, req.(*GetCompletionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateCompletionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCompletionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateCompletionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/UpdateCompletionConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateCompletionConfig(ctx, req.(*UpdateCompletionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetAttributesConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttributesConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetAttributesConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/GetAttributesConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetAttributesConfig(ctx, req.(*GetAttributesConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateAttributesConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttributesConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateAttributesConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/UpdateAttributesConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateAttributesConfig(ctx, req.(*UpdateAttributesConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_AddCatalogAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddCatalogAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).AddCatalogAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/AddCatalogAttribute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).AddCatalogAttribute(ctx, req.(*AddCatalogAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_RemoveCatalogAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveCatalogAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).RemoveCatalogAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/RemoveCatalogAttribute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).RemoveCatalogAttribute(ctx, req.(*RemoveCatalogAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_BatchRemoveCatalogAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRemoveCatalogAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).BatchRemoveCatalogAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/BatchRemoveCatalogAttributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).BatchRemoveCatalogAttributes(ctx, req.(*BatchRemoveCatalogAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ReplaceCatalogAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplaceCatalogAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ReplaceCatalogAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.CatalogService/ReplaceCatalogAttribute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ReplaceCatalogAttribute(ctx, req.(*ReplaceCatalogAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CatalogService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2beta.CatalogService",
	HandlerType: (*CatalogServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCatalogs",
			Handler:    _CatalogService_ListCatalogs_Handler,
		},
		{
			MethodName: "UpdateCatalog",
			Handler:    _CatalogService_UpdateCatalog_Handler,
		},
		{
			MethodName: "SetDefaultBranch",
			Handler:    _CatalogService_SetDefaultBranch_Handler,
		},
		{
			MethodName: "GetDefaultBranch",
			Handler:    _CatalogService_GetDefaultBranch_Handler,
		},
		{
			MethodName: "GetCompletionConfig",
			Handler:    _CatalogService_GetCompletionConfig_Handler,
		},
		{
			MethodName: "UpdateCompletionConfig",
			Handler:    _CatalogService_UpdateCompletionConfig_Handler,
		},
		{
			MethodName: "GetAttributesConfig",
			Handler:    _CatalogService_GetAttributesConfig_Handler,
		},
		{
			MethodName: "UpdateAttributesConfig",
			Handler:    _CatalogService_UpdateAttributesConfig_Handler,
		},
		{
			MethodName: "AddCatalogAttribute",
			Handler:    _CatalogService_AddCatalogAttribute_Handler,
		},
		{
			MethodName: "RemoveCatalogAttribute",
			Handler:    _CatalogService_RemoveCatalogAttribute_Handler,
		},
		{
			MethodName: "BatchRemoveCatalogAttributes",
			Handler:    _CatalogService_BatchRemoveCatalogAttributes_Handler,
		},
		{
			MethodName: "ReplaceCatalogAttribute",
			Handler:    _CatalogService_ReplaceCatalogAttribute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2beta/catalog_service.proto",
}
