// Code generated by smithy-go-codegen DO NOT EDIT.

package budgets

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/budgets/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateBudgetAction struct {
}

func (*validateOpCreateBudgetAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateBudgetAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateBudgetActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateBudgetActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateBudget struct {
}

func (*validateOpCreateBudget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateBudget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateBudgetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateBudgetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateNotification struct {
}

func (*validateOpCreateNotification) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateNotification) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateNotificationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateNotificationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateSubscriber struct {
}

func (*validateOpCreateSubscriber) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateSubscriber) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateSubscriberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateSubscriberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteBudgetAction struct {
}

func (*validateOpDeleteBudgetAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteBudgetAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteBudgetActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteBudgetActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteBudget struct {
}

func (*validateOpDeleteBudget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteBudget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteBudgetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteBudgetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteNotification struct {
}

func (*validateOpDeleteNotification) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteNotification) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteNotificationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteNotificationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteSubscriber struct {
}

func (*validateOpDeleteSubscriber) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteSubscriber) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteSubscriberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteSubscriberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudgetActionHistories struct {
}

func (*validateOpDescribeBudgetActionHistories) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudgetActionHistories) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetActionHistoriesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetActionHistoriesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudgetAction struct {
}

func (*validateOpDescribeBudgetAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudgetAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudgetActionsForAccount struct {
}

func (*validateOpDescribeBudgetActionsForAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudgetActionsForAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetActionsForAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetActionsForAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudgetActionsForBudget struct {
}

func (*validateOpDescribeBudgetActionsForBudget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudgetActionsForBudget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetActionsForBudgetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetActionsForBudgetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudget struct {
}

func (*validateOpDescribeBudget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudgetNotificationsForAccount struct {
}

func (*validateOpDescribeBudgetNotificationsForAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudgetNotificationsForAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetNotificationsForAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetNotificationsForAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudgetPerformanceHistory struct {
}

func (*validateOpDescribeBudgetPerformanceHistory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudgetPerformanceHistory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetPerformanceHistoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetPerformanceHistoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeBudgets struct {
}

func (*validateOpDescribeBudgets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeBudgets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeBudgetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeBudgetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeNotificationsForBudget struct {
}

func (*validateOpDescribeNotificationsForBudget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeNotificationsForBudget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeNotificationsForBudgetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeNotificationsForBudgetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeSubscribersForNotification struct {
}

func (*validateOpDescribeSubscribersForNotification) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeSubscribersForNotification) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeSubscribersForNotificationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeSubscribersForNotificationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpExecuteBudgetAction struct {
}

func (*validateOpExecuteBudgetAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpExecuteBudgetAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ExecuteBudgetActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpExecuteBudgetActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateBudgetAction struct {
}

func (*validateOpUpdateBudgetAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateBudgetAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateBudgetActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateBudgetActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateBudget struct {
}

func (*validateOpUpdateBudget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateBudget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateBudgetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateBudgetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateNotification struct {
}

func (*validateOpUpdateNotification) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateNotification) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateNotificationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateNotificationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateSubscriber struct {
}

func (*validateOpUpdateSubscriber) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateSubscriber) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateSubscriberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateSubscriberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateBudgetActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateBudgetAction{}, middleware.After)
}

func addOpCreateBudgetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateBudget{}, middleware.After)
}

func addOpCreateNotificationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateNotification{}, middleware.After)
}

func addOpCreateSubscriberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateSubscriber{}, middleware.After)
}

func addOpDeleteBudgetActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteBudgetAction{}, middleware.After)
}

func addOpDeleteBudgetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteBudget{}, middleware.After)
}

func addOpDeleteNotificationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteNotification{}, middleware.After)
}

func addOpDeleteSubscriberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteSubscriber{}, middleware.After)
}

func addOpDescribeBudgetActionHistoriesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudgetActionHistories{}, middleware.After)
}

func addOpDescribeBudgetActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudgetAction{}, middleware.After)
}

func addOpDescribeBudgetActionsForAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudgetActionsForAccount{}, middleware.After)
}

func addOpDescribeBudgetActionsForBudgetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudgetActionsForBudget{}, middleware.After)
}

func addOpDescribeBudgetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudget{}, middleware.After)
}

func addOpDescribeBudgetNotificationsForAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudgetNotificationsForAccount{}, middleware.After)
}

func addOpDescribeBudgetPerformanceHistoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudgetPerformanceHistory{}, middleware.After)
}

func addOpDescribeBudgetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeBudgets{}, middleware.After)
}

func addOpDescribeNotificationsForBudgetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeNotificationsForBudget{}, middleware.After)
}

func addOpDescribeSubscribersForNotificationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeSubscribersForNotification{}, middleware.After)
}

func addOpExecuteBudgetActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpExecuteBudgetAction{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateBudgetActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateBudgetAction{}, middleware.After)
}

func addOpUpdateBudgetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateBudget{}, middleware.After)
}

func addOpUpdateNotificationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateNotification{}, middleware.After)
}

func addOpUpdateSubscriberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateSubscriber{}, middleware.After)
}

func validateActionThreshold(v *types.ActionThreshold) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionThreshold"}
	if len(v.ActionThresholdType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ActionThresholdType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoAdjustData(v *types.AutoAdjustData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoAdjustData"}
	if len(v.AutoAdjustType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AutoAdjustType"))
	}
	if v.HistoricalOptions != nil {
		if err := validateHistoricalOptions(v.HistoricalOptions); err != nil {
			invalidParams.AddNested("HistoricalOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBudget(v *types.Budget) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Budget"}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.BudgetLimit != nil {
		if err := validateSpend(v.BudgetLimit); err != nil {
			invalidParams.AddNested("BudgetLimit", err.(smithy.InvalidParamsError))
		}
	}
	if v.PlannedBudgetLimits != nil {
		if err := validatePlannedBudgetLimits(v.PlannedBudgetLimits); err != nil {
			invalidParams.AddNested("PlannedBudgetLimits", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.TimeUnit) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TimeUnit"))
	}
	if v.CalculatedSpend != nil {
		if err := validateCalculatedSpend(v.CalculatedSpend); err != nil {
			invalidParams.AddNested("CalculatedSpend", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.BudgetType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetType"))
	}
	if v.AutoAdjustData != nil {
		if err := validateAutoAdjustData(v.AutoAdjustData); err != nil {
			invalidParams.AddNested("AutoAdjustData", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCalculatedSpend(v *types.CalculatedSpend) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CalculatedSpend"}
	if v.ActualSpend == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActualSpend"))
	} else if v.ActualSpend != nil {
		if err := validateSpend(v.ActualSpend); err != nil {
			invalidParams.AddNested("ActualSpend", err.(smithy.InvalidParamsError))
		}
	}
	if v.ForecastedSpend != nil {
		if err := validateSpend(v.ForecastedSpend); err != nil {
			invalidParams.AddNested("ForecastedSpend", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDefinition(v *types.Definition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Definition"}
	if v.IamActionDefinition != nil {
		if err := validateIamActionDefinition(v.IamActionDefinition); err != nil {
			invalidParams.AddNested("IamActionDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScpActionDefinition != nil {
		if err := validateScpActionDefinition(v.ScpActionDefinition); err != nil {
			invalidParams.AddNested("ScpActionDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if v.SsmActionDefinition != nil {
		if err := validateSsmActionDefinition(v.SsmActionDefinition); err != nil {
			invalidParams.AddNested("SsmActionDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHistoricalOptions(v *types.HistoricalOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HistoricalOptions"}
	if v.BudgetAdjustmentPeriod == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetAdjustmentPeriod"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIamActionDefinition(v *types.IamActionDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IamActionDefinition"}
	if v.PolicyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotification(v *types.Notification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Notification"}
	if len(v.NotificationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("NotificationType"))
	}
	if len(v.ComparisonOperator) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ComparisonOperator"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationWithSubscribers(v *types.NotificationWithSubscribers) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationWithSubscribers"}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if v.Subscribers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subscribers"))
	} else if v.Subscribers != nil {
		if err := validateSubscribers(v.Subscribers); err != nil {
			invalidParams.AddNested("Subscribers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationWithSubscribersList(v []types.NotificationWithSubscribers) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationWithSubscribersList"}
	for i := range v {
		if err := validateNotificationWithSubscribers(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePlannedBudgetLimits(v map[string]types.Spend) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PlannedBudgetLimits"}
	for key := range v {
		value := v[key]
		if err := validateSpend(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceTag(v *types.ResourceTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceTag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceTagList(v []types.ResourceTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceTagList"}
	for i := range v {
		if err := validateResourceTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScpActionDefinition(v *types.ScpActionDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScpActionDefinition"}
	if v.PolicyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyId"))
	}
	if v.TargetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSpend(v *types.Spend) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Spend"}
	if v.Amount == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Amount"))
	}
	if v.Unit == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Unit"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSsmActionDefinition(v *types.SsmActionDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SsmActionDefinition"}
	if len(v.ActionSubType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ActionSubType"))
	}
	if v.Region == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Region"))
	}
	if v.InstanceIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSubscriber(v *types.Subscriber) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Subscriber"}
	if len(v.SubscriptionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SubscriptionType"))
	}
	if v.Address == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Address"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSubscribers(v []types.Subscriber) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Subscribers"}
	for i := range v {
		if err := validateSubscriber(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateBudgetActionInput(v *CreateBudgetActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateBudgetActionInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if len(v.NotificationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("NotificationType"))
	}
	if len(v.ActionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ActionType"))
	}
	if v.ActionThreshold == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionThreshold"))
	} else if v.ActionThreshold != nil {
		if err := validateActionThreshold(v.ActionThreshold); err != nil {
			invalidParams.AddNested("ActionThreshold", err.(smithy.InvalidParamsError))
		}
	}
	if v.Definition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Definition"))
	} else if v.Definition != nil {
		if err := validateDefinition(v.Definition); err != nil {
			invalidParams.AddNested("Definition", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExecutionRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionRoleArn"))
	}
	if len(v.ApprovalModel) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ApprovalModel"))
	}
	if v.Subscribers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subscribers"))
	} else if v.Subscribers != nil {
		if err := validateSubscribers(v.Subscribers); err != nil {
			invalidParams.AddNested("Subscribers", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateBudgetInput(v *CreateBudgetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateBudgetInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.Budget == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Budget"))
	} else if v.Budget != nil {
		if err := validateBudget(v.Budget); err != nil {
			invalidParams.AddNested("Budget", err.(smithy.InvalidParamsError))
		}
	}
	if v.NotificationsWithSubscribers != nil {
		if err := validateNotificationWithSubscribersList(v.NotificationsWithSubscribers); err != nil {
			invalidParams.AddNested("NotificationsWithSubscribers", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateNotificationInput(v *CreateNotificationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateNotificationInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if v.Subscribers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subscribers"))
	} else if v.Subscribers != nil {
		if err := validateSubscribers(v.Subscribers); err != nil {
			invalidParams.AddNested("Subscribers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateSubscriberInput(v *CreateSubscriberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateSubscriberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if v.Subscriber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subscriber"))
	} else if v.Subscriber != nil {
		if err := validateSubscriber(v.Subscriber); err != nil {
			invalidParams.AddNested("Subscriber", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteBudgetActionInput(v *DeleteBudgetActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteBudgetActionInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.ActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteBudgetInput(v *DeleteBudgetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteBudgetInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteNotificationInput(v *DeleteNotificationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteNotificationInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteSubscriberInput(v *DeleteSubscriberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteSubscriberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if v.Subscriber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subscriber"))
	} else if v.Subscriber != nil {
		if err := validateSubscriber(v.Subscriber); err != nil {
			invalidParams.AddNested("Subscriber", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetActionHistoriesInput(v *DescribeBudgetActionHistoriesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetActionHistoriesInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.ActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetActionInput(v *DescribeBudgetActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetActionInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.ActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetActionsForAccountInput(v *DescribeBudgetActionsForAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetActionsForAccountInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetActionsForBudgetInput(v *DescribeBudgetActionsForBudgetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetActionsForBudgetInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetInput(v *DescribeBudgetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetNotificationsForAccountInput(v *DescribeBudgetNotificationsForAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetNotificationsForAccountInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetPerformanceHistoryInput(v *DescribeBudgetPerformanceHistoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetPerformanceHistoryInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeBudgetsInput(v *DescribeBudgetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeBudgetsInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeNotificationsForBudgetInput(v *DescribeNotificationsForBudgetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeNotificationsForBudgetInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeSubscribersForNotificationInput(v *DescribeSubscribersForNotificationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeSubscribersForNotificationInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpExecuteBudgetActionInput(v *ExecuteBudgetActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExecuteBudgetActionInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.ActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionId"))
	}
	if len(v.ExecutionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.ResourceTags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTags"))
	} else if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.ResourceTagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateBudgetActionInput(v *UpdateBudgetActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateBudgetActionInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.ActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionId"))
	}
	if v.ActionThreshold != nil {
		if err := validateActionThreshold(v.ActionThreshold); err != nil {
			invalidParams.AddNested("ActionThreshold", err.(smithy.InvalidParamsError))
		}
	}
	if v.Definition != nil {
		if err := validateDefinition(v.Definition); err != nil {
			invalidParams.AddNested("Definition", err.(smithy.InvalidParamsError))
		}
	}
	if v.Subscribers != nil {
		if err := validateSubscribers(v.Subscribers); err != nil {
			invalidParams.AddNested("Subscribers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateBudgetInput(v *UpdateBudgetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateBudgetInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.NewBudget == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NewBudget"))
	} else if v.NewBudget != nil {
		if err := validateBudget(v.NewBudget); err != nil {
			invalidParams.AddNested("NewBudget", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateNotificationInput(v *UpdateNotificationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateNotificationInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.OldNotification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OldNotification"))
	} else if v.OldNotification != nil {
		if err := validateNotification(v.OldNotification); err != nil {
			invalidParams.AddNested("OldNotification", err.(smithy.InvalidParamsError))
		}
	}
	if v.NewNotification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NewNotification"))
	} else if v.NewNotification != nil {
		if err := validateNotification(v.NewNotification); err != nil {
			invalidParams.AddNested("NewNotification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateSubscriberInput(v *UpdateSubscriberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateSubscriberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.BudgetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BudgetName"))
	}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if v.OldSubscriber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OldSubscriber"))
	} else if v.OldSubscriber != nil {
		if err := validateSubscriber(v.OldSubscriber); err != nil {
			invalidParams.AddNested("OldSubscriber", err.(smithy.InvalidParamsError))
		}
	}
	if v.NewSubscriber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NewSubscriber"))
	} else if v.NewSubscriber != nil {
		if err := validateSubscriber(v.NewSubscriber); err != nil {
			invalidParams.AddNested("NewSubscriber", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
