// Copyright (c) 2010-2024, Lawrence Livermore National Security, LLC. Produced
// at the Lawrence Livermore National Laboratory. All Rights reserved. See files
// LICENSE and NOTICE for details. LLNL-CODE-443271.
//
// This file is part of the GLVis visualization tool and library. For more
// information and source code availability see https://glvis.org.
//
// GLVis is free software; you can redistribute it and/or modify it under the
// terms of the BSD-3 license. We welcome feedback and contributions, see file
// CONTRIBUTING.md for details.

#include "palettes.hpp"
#include "gl/renderer.hpp"

#include <cmath>
#include <cstdio>
#include <cmath>
#include <iostream>
#include <iomanip>
#include <mutex>

using namespace std;

const int RGB_Palette_1_Size = 5;
double RGB_Palette_1[RGB_Palette_1_Size][3] =
{
   { 0, 0, 1 },
   { 0, 1, 1 },
   { 0, 1, 0 },
   { 1, 1, 0 },
   { 1, 0, 0 }
};

const int RGB_Palette_2_Size = 2;
double RGB_Palette_2[RGB_Palette_2_Size][3] =
{
   { 1.0, 0.0, 0.0 },
   { 1.0, 0.0, 0.0 }
};

const int RGB_Palette_3_Size = 65;
double RGB_Palette_3[RGB_Palette_3_Size][3] =
{
   {      0,      0, 0.5000 },
   {      0,      0, 0.5625 },
   {      0,      0, 0.6250 },
   {      0,      0, 0.6875 },
   {      0,      0, 0.7500 },
   {      0,      0, 0.8125 },
   {      0,      0, 0.8750 },
   {      0,      0, 0.9375 },
   {      0,      0, 1.0000 },
   {      0, 0.0625, 1.0000 },
   {      0, 0.1250, 1.0000 },
   {      0, 0.1875, 1.0000 },
   {      0, 0.2500, 1.0000 },
   {      0, 0.3125, 1.0000 },
   {      0, 0.3750, 1.0000 },
   {      0, 0.4375, 1.0000 },
   {      0, 0.5000, 1.0000 },
   {      0, 0.5625, 1.0000 },
   {      0, 0.6250, 1.0000 },
   {      0, 0.6875, 1.0000 },
   {      0, 0.7500, 1.0000 },
   {      0, 0.8125, 1.0000 },
   {      0, 0.8750, 1.0000 },
   {      0, 0.9375, 1.0000 },

#if 0
   // original
   {      0, 1.0000, 1.0000 },
   { 0.0625, 1.0000, 0.9375 },
   { 0.1250, 1.0000, 0.8750 },
   { 0.1875, 1.0000, 0.8125 },
   { 0.2500, 1.0000, 0.7500 },
   { 0.3125, 1.0000, 0.6875 },
   { 0.3750, 1.0000, 0.6250 },
   { 0.4375, 1.0000, 0.5625 },
   { 0.5000, 1.0000, 0.5000 },

   { 0.5625, 1.0000, 0.4375 },
   { 0.6250, 1.0000, 0.3750 },
   { 0.6875, 1.0000, 0.3125 },
   { 0.7500, 1.0000, 0.2500 },
   { 0.8125, 1.0000, 0.1875 },
   { 0.8750, 1.0000, 0.1250 },
   { 0.9375, 1.0000, 0.0625 },
   { 1.0000, 1.0000,      0 },
#else
   // modification
   {      0, 1.0000, 1.0000 },
   {      0, 0.9750, 0.8750 },
   {      0, 0.9500, 0.7500 },
   {      0, 0.9250, 0.6250 },
   {      0, 0.9000, 0.5000 },
   {      0, 0.8750, 0.3750 },
   {      0, 0.8500, 0.2500 },
   {      0, 0.8250, 0.1250 },
   {      0, 0.8000,      0 },

   // x=[1/8:1/8:1]
   // red=x.^(.6)
   { 0.2872, 0.8250,      0 },
   { 0.4353, 0.8500,      0 },
   { 0.5552, 0.8750,      0 },
   { 0.6598, 0.9000,      0 },
   { 0.7543, 0.9250,      0 },
   { 0.8415, 0.9500,      0 },
   { 0.9230, 0.9750,      0 },
   { 1.0000, 1.0000,      0 },
#endif

   { 1.0000, 0.9375,      0 },
   { 1.0000, 0.8750,      0 },
   { 1.0000, 0.8125,      0 },
   { 1.0000, 0.7500,      0 },
   { 1.0000, 0.6875,      0 },
   { 1.0000, 0.6250,      0 },
   { 1.0000, 0.5625,      0 },
   { 1.0000, 0.5000,      0 },
   { 1.0000, 0.4375,      0 },
   { 1.0000, 0.3750,      0 },
   { 1.0000, 0.3125,      0 },
   { 1.0000, 0.2500,      0 },
   { 1.0000, 0.1875,      0 },
   { 1.0000, 0.1250,      0 },
   { 1.0000, 0.0625,      0 },
   { 1.0000,      0,      0 },
   { 0.9375,      0,      0 },
   { 0.8750,      0,      0 },
   { 0.8125,      0,      0 },
   { 0.7500,      0,      0 },
   { 0.6875,      0,      0 },
   { 0.6250,      0,      0 },
   { 0.5625,      0,      0 },
   { 0.5000,      0,      0 }
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_4_Size = 11; // CBR_coldhot.rgb
double RGB_Palette_4[RGB_Palette_4_Size][3] =
{
   {0.019531, 0.187500, 0.378906},
   {0.128906, 0.398438, 0.671875},
   {0.261719, 0.574219, 0.761719},
   {0.570312, 0.769531, 0.867188},
   {0.816406, 0.894531, 0.937500},
   {0.964844, 0.964844, 0.964844},
   {0.992188, 0.855469, 0.777344},
   {0.953125, 0.644531, 0.507812},
   {0.835938, 0.375000, 0.300781},
   {0.695312, 0.093750, 0.167969},
   {0.402344, 0.000000, 0.121094}
};

const int RGB_Palette_5_Size = 64; // bone
double RGB_Palette_5[RGB_Palette_5_Size][3] =
{
   { 0, 0, 0.0052083333 },
   { 0.013888889, 0.013888889, 0.024305556 },
   { 0.027777778, 0.027777778, 0.043402778 },
   { 0.041666667, 0.041666667, 0.0625 },
   { 0.055555556, 0.055555556, 0.081597222 },
   { 0.069444444, 0.069444444, 0.10069444 },
   { 0.083333333, 0.083333333, 0.11979167 },
   { 0.097222222, 0.097222222, 0.13888889 },
   { 0.11111111, 0.11111111, 0.15798611 },
   { 0.125, 0.125, 0.17708333 },
   { 0.13888889, 0.13888889, 0.19618056 },
   { 0.15277778, 0.15277778, 0.21527778 },
   { 0.16666667, 0.16666667, 0.234375 },
   { 0.18055556, 0.18055556, 0.25347222 },
   { 0.19444444, 0.19444444, 0.27256944 },
   { 0.20833333, 0.20833333, 0.29166667 },
   { 0.22222222, 0.22222222, 0.31076389 },
   { 0.23611111, 0.23611111, 0.32986111 },
   { 0.25, 0.25, 0.34895833 },
   { 0.26388889, 0.26388889, 0.36805556 },
   { 0.27777778, 0.27777778, 0.38715278 },
   { 0.29166667, 0.29166667, 0.40625 },
   { 0.30555556, 0.30555556, 0.42534722 },
   { 0.31944444, 0.31944444, 0.44444444 },
   { 0.33333333, 0.33854167, 0.45833333 },
   { 0.34722222, 0.35763889, 0.47222222 },
   { 0.36111111, 0.37673611, 0.48611111 },
   { 0.375, 0.39583333, 0.5 },
   { 0.38888889, 0.41493056, 0.51388889 },
   { 0.40277778, 0.43402778, 0.52777778 },
   { 0.41666667, 0.453125, 0.54166667 },
   { 0.43055556, 0.47222222, 0.55555556 },
   { 0.44444444, 0.49131944, 0.56944444 },
   { 0.45833333, 0.51041667, 0.58333333 },
   { 0.47222222, 0.52951389, 0.59722222 },
   { 0.48611111, 0.54861111, 0.61111111 },
   { 0.5, 0.56770833, 0.625 },
   { 0.51388889, 0.58680556, 0.63888889 },
   { 0.52777778, 0.60590278, 0.65277778 },
   { 0.54166667, 0.625, 0.66666667 },
   { 0.55555556, 0.64409722, 0.68055556 },
   { 0.56944444, 0.66319444, 0.69444444 },
   { 0.58333333, 0.68229167, 0.70833333 },
   { 0.59722222, 0.70138889, 0.72222222 },
   { 0.61111111, 0.72048611, 0.73611111 },
   { 0.625, 0.73958333, 0.75 },
   { 0.63888889, 0.75868056, 0.76388889 },
   { 0.65277778, 0.77777778, 0.77777778 },
   { 0.67447917, 0.79166667, 0.79166667 },
   { 0.69618056, 0.80555556, 0.80555556 },
   { 0.71788194, 0.81944444, 0.81944444 },
   { 0.73958333, 0.83333333, 0.83333333 },
   { 0.76128472, 0.84722222, 0.84722222 },
   { 0.78298611, 0.86111111, 0.86111111 },
   { 0.8046875, 0.875, 0.875 },
   { 0.82638889, 0.88888889, 0.88888889 },
   { 0.84809028, 0.90277778, 0.90277778 },
   { 0.86979167, 0.91666667, 0.91666667 },
   { 0.89149306, 0.93055556, 0.93055556 },
   { 0.91319444, 0.94444444, 0.94444444 },
   { 0.93489583, 0.95833333, 0.95833333 },
   { 0.95659722, 0.97222222, 0.97222222 },
   { 0.97829861, 0.98611111, 0.98611111 },
   { 1, 1, 1 }
};

const int RGB_Palette_6_Size = 64; // hot
double RGB_Palette_6[RGB_Palette_6_Size][3] =
{
   { 0.041666667, 0, 0 },
   { 0.083333333, 0, 0 },
   { 0.125, 0, 0 },
   { 0.16666667, 0, 0 },
   { 0.20833333, 0, 0 },
   { 0.25, 0, 0 },
   { 0.29166667, 0, 0 },
   { 0.33333333, 0, 0 },
   { 0.375, 0, 0 },
   { 0.41666667, 0, 0 },
   { 0.45833333, 0, 0 },
   { 0.5, 0, 0 },
   { 0.54166667, 0, 0 },
   { 0.58333333, 0, 0 },
   { 0.625, 0, 0 },
   { 0.66666667, 0, 0 },
   { 0.70833333, 0, 0 },
   { 0.75, 0, 0 },
   { 0.79166667, 0, 0 },
   { 0.83333333, 0, 0 },
   { 0.875, 0, 0 },
   { 0.91666667, 0, 0 },
   { 0.95833333, 0, 0 },
   { 1, 0, 0 },
   { 1, 0.041666667, 0 },
   { 1, 0.083333333, 0 },
   { 1, 0.125, 0 },
   { 1, 0.16666667, 0 },
   { 1, 0.20833333, 0 },
   { 1, 0.25, 0 },
   { 1, 0.29166667, 0 },
   { 1, 0.33333333, 0 },
   { 1, 0.375, 0 },
   { 1, 0.41666667, 0 },
   { 1, 0.45833333, 0 },
   { 1, 0.5, 0 },
   { 1, 0.54166667, 0 },
   { 1, 0.58333333, 0 },
   { 1, 0.625, 0 },
   { 1, 0.66666667, 0 },
   { 1, 0.70833333, 0 },
   { 1, 0.75, 0 },
   { 1, 0.79166667, 0 },
   { 1, 0.83333333, 0 },
   { 1, 0.875, 0 },
   { 1, 0.91666667, 0 },
   { 1, 0.95833333, 0 },
   { 1, 1, 0 },
   { 1, 1, 0.0625 },
   { 1, 1, 0.125 },
   { 1, 1, 0.1875 },
   { 1, 1, 0.25 },
   { 1, 1, 0.3125 },
   { 1, 1, 0.375 },
   { 1, 1, 0.4375 },
   { 1, 1, 0.5 },
   { 1, 1, 0.5625 },
   { 1, 1, 0.625 },
   { 1, 1, 0.6875 },
   { 1, 1, 0.75 },
   { 1, 1, 0.8125 },
   { 1, 1, 0.875 },
   { 1, 1, 0.9375 },
   { 1, 1, 1 }
};

const int RGB_Palette_7_Size = 64; // pink
double RGB_Palette_7[RGB_Palette_7_Size][3] =
{
   { 0.11785113, 0, 0 },
   { 0.19585655, 0.1028689, 0.1028689 },
   { 0.2506605, 0.14547859, 0.14547859 },
   { 0.29546842, 0.17817416, 0.17817416 },
   { 0.33432392, 0.2057378, 0.2057378 },
   { 0.36911162, 0.23002185, 0.23002185 },
   { 0.40089186, 0.25197632, 0.25197632 },
   { 0.43033148, 0.27216553, 0.27216553 },
   { 0.45788217, 0.29095719, 0.29095719 },
   { 0.4838667, 0.3086067, 0.3086067 },
   { 0.5085252, 0.32530002, 0.32530002 },
   { 0.53204209, 0.34117754, 0.34117754 },
   { 0.5545626, 0.35634832, 0.35634832 },
   { 0.57620359, 0.37089909, 0.37089909 },
   { 0.5970607, 0.38490018, 0.38490018 },
   { 0.6172134, 0.39840954, 0.39840954 },
   { 0.63672858, 0.4114756, 0.4114756 },
   { 0.65566316, 0.42413934, 0.42413934 },
   { 0.67406608, 0.43643578, 0.43643578 },
   { 0.69197975, 0.44839514, 0.44839514 },
   { 0.70944124, 0.46004371, 0.46004371 },
   { 0.72648316, 0.47140452, 0.47140452 },
   { 0.74313436, 0.48249791, 0.48249791 },
   { 0.75942055, 0.49334191, 0.49334191 },
   { 0.76635604, 0.51754917, 0.50395263 },
   { 0.77322933, 0.54067369, 0.5143445 },
   { 0.78004206, 0.56284895, 0.52453053 },
   { 0.78679579, 0.58418305, 0.53452248 },
   { 0.79349205, 0.60476503, 0.54433105 },
   { 0.80013226, 0.62466922, 0.55396598 },
   { 0.80671783, 0.64395849, 0.56343617 },
   { 0.81325006, 0.66268653, 0.5727498 },
   { 0.81973024, 0.68089965, 0.58191437 },
   { 0.8261596, 0.69863813, 0.59093684 },
   { 0.8325393, 0.71593724, 0.59982361 },
   { 0.83887049, 0.73282811, 0.60858062 },
   { 0.84515425, 0.74933833, 0.6172134 },
   { 0.85139164, 0.76549254, 0.62572709 },
   { 0.85758366, 0.78131283, 0.63412649 },
   { 0.86373129, 0.79681907, 0.64241607 },
   { 0.86983548, 0.81202927, 0.65060005 },
   { 0.87589712, 0.82695975, 0.65868235 },
   { 0.8819171, 0.84162541, 0.66666667 },
   { 0.88789627, 0.85603985, 0.67455649 },
   { 0.89383544, 0.87021557, 0.68235509 },
   { 0.89973541, 0.88416403, 0.69006556 },
   { 0.90559694, 0.89789584, 0.69769082 },
   { 0.91142078, 0.91142078, 0.70523365 },
   { 0.91720763, 0.91720763, 0.72716562 },
   { 0.92295821, 0.92295821, 0.7484552 },
   { 0.92867317, 0.92867317, 0.76915572 },
   { 0.93435318, 0.93435318, 0.78931355 },
   { 0.93999887, 0.93999887, 0.80896923 },
   { 0.94561086, 0.94561086, 0.82815854 },
   { 0.95118973, 0.95118973, 0.84691316 },
   { 0.95673607, 0.95673607, 0.86526138 },
   { 0.96225045, 0.96225045, 0.88322851 },
   { 0.9677334, 0.9677334, 0.90083735 },
   { 0.97318546, 0.97318546, 0.91810853 },
   { 0.97860715, 0.97860715, 0.93506076 },
   { 0.98399897, 0.98399897, 0.95171107 },
   { 0.9893614, 0.9893614, 0.96807506 },
   { 0.99469492, 0.99469492, 0.98416699 },
   { 1, 1, 1 }
};

const int RGB_Palette_8_Size = 64; // cool
double RGB_Palette_8[RGB_Palette_8_Size][3] =
{
   { 0, 1, 1 },
   { 0.015873016, 0.98412698, 1 },
   { 0.031746032, 0.96825397, 1 },
   { 0.047619048, 0.95238095, 1 },
   { 0.063492063, 0.93650794, 1 },
   { 0.079365079, 0.92063492, 1 },
   { 0.095238095, 0.9047619, 1 },
   { 0.11111111, 0.88888889, 1 },
   { 0.12698413, 0.87301587, 1 },
   { 0.14285714, 0.85714286, 1 },
   { 0.15873016, 0.84126984, 1 },
   { 0.17460317, 0.82539683, 1 },
   { 0.19047619, 0.80952381, 1 },
   { 0.20634921, 0.79365079, 1 },
   { 0.22222222, 0.77777778, 1 },
   { 0.23809524, 0.76190476, 1 },
   { 0.25396825, 0.74603175, 1 },
   { 0.26984127, 0.73015873, 1 },
   { 0.28571429, 0.71428571, 1 },
   { 0.3015873, 0.6984127, 1 },
   { 0.31746032, 0.68253968, 1 },
   { 0.33333333, 0.66666667, 1 },
   { 0.34920635, 0.65079365, 1 },
   { 0.36507937, 0.63492063, 1 },
   { 0.38095238, 0.61904762, 1 },
   { 0.3968254, 0.6031746, 1 },
   { 0.41269841, 0.58730159, 1 },
   { 0.42857143, 0.57142857, 1 },
   { 0.44444444, 0.55555556, 1 },
   { 0.46031746, 0.53968254, 1 },
   { 0.47619048, 0.52380952, 1 },
   { 0.49206349, 0.50793651, 1 },
   { 0.50793651, 0.49206349, 1 },
   { 0.52380952, 0.47619048, 1 },
   { 0.53968254, 0.46031746, 1 },
   { 0.55555556, 0.44444444, 1 },
   { 0.57142857, 0.42857143, 1 },
   { 0.58730159, 0.41269841, 1 },
   { 0.6031746, 0.3968254, 1 },
   { 0.61904762, 0.38095238, 1 },
   { 0.63492063, 0.36507937, 1 },
   { 0.65079365, 0.34920635, 1 },
   { 0.66666667, 0.33333333, 1 },
   { 0.68253968, 0.31746032, 1 },
   { 0.6984127, 0.3015873, 1 },
   { 0.71428571, 0.28571429, 1 },
   { 0.73015873, 0.26984127, 1 },
   { 0.74603175, 0.25396825, 1 },
   { 0.76190476, 0.23809524, 1 },
   { 0.77777778, 0.22222222, 1 },
   { 0.79365079, 0.20634921, 1 },
   { 0.80952381, 0.19047619, 1 },
   { 0.82539683, 0.17460317, 1 },
   { 0.84126984, 0.15873016, 1 },
   { 0.85714286, 0.14285714, 1 },
   { 0.87301587, 0.12698413, 1 },
   { 0.88888889, 0.11111111, 1 },
   { 0.9047619, 0.095238095, 1 },
   { 0.92063492, 0.079365079, 1 },
   { 0.93650794, 0.063492063, 1 },
   { 0.95238095, 0.047619048, 1 },
   { 0.96825397, 0.031746032, 1 },
   { 0.98412698, 0.015873016, 1 },
   { 1, 0, 1 }
};

const int RGB_Palette_9_Size = 64; // summer
double RGB_Palette_9[RGB_Palette_9_Size][3] =
{
   { 0, 0.5, 0.4 },
   { 0.015873016, 0.50793651, 0.4 },
   { 0.031746032, 0.51587302, 0.4 },
   { 0.047619048, 0.52380952, 0.4 },
   { 0.063492063, 0.53174603, 0.4 },
   { 0.079365079, 0.53968254, 0.4 },
   { 0.095238095, 0.54761905, 0.4 },
   { 0.11111111, 0.55555556, 0.4 },
   { 0.12698413, 0.56349206, 0.4 },
   { 0.14285714, 0.57142857, 0.4 },
   { 0.15873016, 0.57936508, 0.4 },
   { 0.17460317, 0.58730159, 0.4 },
   { 0.19047619, 0.5952381, 0.4 },
   { 0.20634921, 0.6031746, 0.4 },
   { 0.22222222, 0.61111111, 0.4 },
   { 0.23809524, 0.61904762, 0.4 },
   { 0.25396825, 0.62698413, 0.4 },
   { 0.26984127, 0.63492063, 0.4 },
   { 0.28571429, 0.64285714, 0.4 },
   { 0.3015873, 0.65079365, 0.4 },
   { 0.31746032, 0.65873016, 0.4 },
   { 0.33333333, 0.66666667, 0.4 },
   { 0.34920635, 0.67460317, 0.4 },
   { 0.36507937, 0.68253968, 0.4 },
   { 0.38095238, 0.69047619, 0.4 },
   { 0.3968254, 0.6984127, 0.4 },
   { 0.41269841, 0.70634921, 0.4 },
   { 0.42857143, 0.71428571, 0.4 },
   { 0.44444444, 0.72222222, 0.4 },
   { 0.46031746, 0.73015873, 0.4 },
   { 0.47619048, 0.73809524, 0.4 },
   { 0.49206349, 0.74603175, 0.4 },
   { 0.50793651, 0.75396825, 0.4 },
   { 0.52380952, 0.76190476, 0.4 },
   { 0.53968254, 0.76984127, 0.4 },
   { 0.55555556, 0.77777778, 0.4 },
   { 0.57142857, 0.78571429, 0.4 },
   { 0.58730159, 0.79365079, 0.4 },
   { 0.6031746, 0.8015873, 0.4 },
   { 0.61904762, 0.80952381, 0.4 },
   { 0.63492063, 0.81746032, 0.4 },
   { 0.65079365, 0.82539683, 0.4 },
   { 0.66666667, 0.83333333, 0.4 },
   { 0.68253968, 0.84126984, 0.4 },
   { 0.6984127, 0.84920635, 0.4 },
   { 0.71428571, 0.85714286, 0.4 },
   { 0.73015873, 0.86507937, 0.4 },
   { 0.74603175, 0.87301587, 0.4 },
   { 0.76190476, 0.88095238, 0.4 },
   { 0.77777778, 0.88888889, 0.4 },
   { 0.79365079, 0.8968254, 0.4 },
   { 0.80952381, 0.9047619, 0.4 },
   { 0.82539683, 0.91269841, 0.4 },
   { 0.84126984, 0.92063492, 0.4 },
   { 0.85714286, 0.92857143, 0.4 },
   { 0.87301587, 0.93650794, 0.4 },
   { 0.88888889, 0.94444444, 0.4 },
   { 0.9047619, 0.95238095, 0.4 },
   { 0.92063492, 0.96031746, 0.4 },
   { 0.93650794, 0.96825397, 0.4 },
   { 0.95238095, 0.97619048, 0.4 },
   { 0.96825397, 0.98412698, 0.4 },
   { 0.98412698, 0.99206349, 0.4 },
   { 1, 1, 0.4 }
};

const int RGB_Palette_10_Size = 64; // hsv
double RGB_Palette_10[RGB_Palette_10_Size][3] =
{
   { 1, 0, 0 },
   { 1, 0.09375, 0 },
   { 1, 0.1875, 0 },
   { 1, 0.28125, 0 },
   { 1, 0.375, 0 },
   { 1, 0.46875, 0 },
   { 1, 0.5625, 0 },
   { 1, 0.65625, 0 },
   { 1, 0.75, 0 },
   { 1, 0.84375, 0 },
   { 1, 0.9375, 0 },
   { 0.96875, 1, 0 },
   { 0.875, 1, 0 },
   { 0.78125, 1, 0 },
   { 0.6875, 1, 0 },
   { 0.59375, 1, 0 },
   { 0.5, 1, 0 },
   { 0.40625, 1, 0 },
   { 0.3125, 1, 0 },
   { 0.21875, 1, 0 },
   { 0.125, 1, 0 },
   { 0.03125, 1, 0 },
   { 0, 1, 0.0625 },
   { 0, 1, 0.15625 },
   { 0, 1, 0.25 },
   { 0, 1, 0.34375 },
   { 0, 1, 0.4375 },
   { 0, 1, 0.53125 },
   { 0, 1, 0.625 },
   { 0, 1, 0.71875 },
   { 0, 1, 0.8125 },
   { 0, 1, 0.90625 },
   { 0, 1, 1 },
   { 0, 0.90625, 1 },
   { 0, 0.8125, 1 },
   { 0, 0.71875, 1 },
   { 0, 0.625, 1 },
   { 0, 0.53125, 1 },
   { 0, 0.4375, 1 },
   { 0, 0.34375, 1 },
   { 0, 0.25, 1 },
   { 0, 0.15625, 1 },
   { 0, 0.0625, 1 },
   { 0.03125, 0, 1 },
   { 0.125, 0, 1 },
   { 0.21875, 0, 1 },
   { 0.3125, 0, 1 },
   { 0.40625, 0, 1 },
   { 0.5, 0, 1 },
   { 0.59375, 0, 1 },
   { 0.6875, 0, 1 },
   { 0.78125, 0, 1 },
   { 0.875, 0, 1 },
   { 0.96875, 0, 1 },
   { 1, 0, 0.9375 },
   { 1, 0, 0.84375 },
   { 1, 0, 0.75 },
   { 1, 0, 0.65625 },
   { 1, 0, 0.5625 },
   { 1, 0, 0.46875 },
   { 1, 0, 0.375 },
   { 1, 0, 0.28125 },
   { 1, 0, 0.1875 },
   { 1, 0, 0.09375 }
};

const int RGB_Palette_11_Size = 64; // copper
double RGB_Palette_11[RGB_Palette_11_Size][3] =
{
   { 0, 0, 0 },
   { 0.01984127, 0.0124, 0.0078968254 },
   { 0.03968254, 0.0248, 0.015793651 },
   { 0.05952381, 0.0372, 0.023690476 },
   { 0.079365079, 0.0496, 0.031587302 },
   { 0.099206349, 0.062, 0.039484127 },
   { 0.11904762, 0.0744, 0.047380952 },
   { 0.13888889, 0.0868, 0.055277778 },
   { 0.15873016, 0.0992, 0.063174603 },
   { 0.17857143, 0.1116, 0.071071429 },
   { 0.1984127, 0.124, 0.078968254 },
   { 0.21825397, 0.1364, 0.086865079 },
   { 0.23809524, 0.1488, 0.094761905 },
   { 0.25793651, 0.1612, 0.10265873 },
   { 0.27777778, 0.1736, 0.11055556 },
   { 0.29761905, 0.186, 0.11845238 },
   { 0.31746032, 0.1984, 0.12634921 },
   { 0.33730159, 0.2108, 0.13424603 },
   { 0.35714286, 0.2232, 0.14214286 },
   { 0.37698413, 0.2356, 0.15003968 },
   { 0.3968254, 0.248, 0.15793651 },
   { 0.41666667, 0.2604, 0.16583333 },
   { 0.43650794, 0.2728, 0.17373016 },
   { 0.45634921, 0.2852, 0.18162698 },
   { 0.47619048, 0.2976, 0.18952381 },
   { 0.49603175, 0.31, 0.19742063 },
   { 0.51587302, 0.3224, 0.20531746 },
   { 0.53571429, 0.3348, 0.21321429 },
   { 0.55555556, 0.3472, 0.22111111 },
   { 0.57539683, 0.3596, 0.22900794 },
   { 0.5952381, 0.372, 0.23690476 },
   { 0.61507937, 0.3844, 0.24480159 },
   { 0.63492063, 0.3968, 0.25269841 },
   { 0.6547619, 0.4092, 0.26059524 },
   { 0.67460317, 0.4216, 0.26849206 },
   { 0.69444444, 0.434, 0.27638889 },
   { 0.71428571, 0.4464, 0.28428571 },
   { 0.73412698, 0.4588, 0.29218254 },
   { 0.75396825, 0.4712, 0.30007937 },
   { 0.77380952, 0.4836, 0.30797619 },
   { 0.79365079, 0.496, 0.31587302 },
   { 0.81349206, 0.5084, 0.32376984 },
   { 0.83333333, 0.5208, 0.33166667 },
   { 0.8531746, 0.5332, 0.33956349 },
   { 0.87301587, 0.5456, 0.34746032 },
   { 0.89285714, 0.558, 0.35535714 },
   { 0.91269841, 0.5704, 0.36325397 },
   { 0.93253968, 0.5828, 0.37115079 },
   { 0.95238095, 0.5952, 0.37904762 },
   { 0.97222222, 0.6076, 0.38694444 },
   { 0.99206349, 0.62, 0.39484127 },
   { 1, 0.6324, 0.4027381 },
   { 1, 0.6448, 0.41063492 },
   { 1, 0.6572, 0.41853175 },
   { 1, 0.6696, 0.42642857 },
   { 1, 0.682, 0.4343254 },
   { 1, 0.6944, 0.44222222 },
   { 1, 0.7068, 0.45011905 },
   { 1, 0.7192, 0.45801587 },
   { 1, 0.7316, 0.4659127 },
   { 1, 0.744, 0.47380952 },
   { 1, 0.7564, 0.48170635 },
   { 1, 0.7688, 0.48960317 },
   { 1, 0.7812, 0.4975 }
};

const int RGB_Palette_12_Size = 2;
double RGB_Palette_12[RGB_Palette_12_Size][3] =
{
   { 1.0, 1.0, 1.0 },
   { 1.0, 1.0, 1.0 }
};

/*
  const int RGB_Palette_13_Size = 6;
  double RGB_Palette_13[RGB_Palette_13_Size][3] =
  {
  { 0, 0, 1 },
  { 0, 1, 1 },
  { 0, 1, 0 },
  { 1, 1, 0 },
  { 1, 0, 0 },
  { 1, 0, 1 }
  };

  const int RGB_Palette_14_Size = 4;
  double RGB_Palette_14[RGB_Palette_14_Size][3] =
  {
  { 0, 0, 1 },
  { 0, 1, 0 },
  { 1, 1, 0 },
  { 1, 0, 0 }
  };

  const int RGB_Palette_15_Size = 7;
  double RGB_Palette_15[RGB_Palette_15_Size][3] =
  {
  { 0,   0, 1 },
  { 0,   1, 1 },
  { 0,   1, 0 },
  { 1,   1, 0 },
  { 1, 0.5, 0 },
  { 1,   0, 0 },
  { 1,   0, 1 }
  };

  const int RGB_Palette_16_Size = 8;
  double RGB_Palette_16[RGB_Palette_16_Size][3] =
  {
  { 0,   0, 1 },
  { 0,   1, 1 },
  { 0,   1, 0 },
  { 1,   1, 0 },
  { 1, 0.5, 0 },
  { 1,   0, 0 },
  { 1,   0, 1 },
  { 0.5, 0, 1 }
  };
*/

const int RGB_Palette_13_Size = (4*16+1); // vivid
double RGB_Palette_13[RGB_Palette_13_Size][3];

const int RGB_Palette_14_Size = 256; // gimp - BrushedAluminum
double RGB_Palette_14[RGB_Palette_14_Size][3] =
{
   { 0.42968750, 0.44531250, 0.41015625 },
   { 0.43750000, 0.44531250, 0.41406250 },
   { 0.44140625, 0.44921875, 0.41796875 },
   { 0.44531250, 0.45312500, 0.42187500 },
   { 0.44921875, 0.45703125, 0.42578125 },
   { 0.45312500, 0.46093750, 0.42968750 },
   { 0.45703125, 0.46484375, 0.43359375 },
   { 0.46093750, 0.46875000, 0.43750000 },
   { 0.46484375, 0.47265625, 0.44140625 },
   { 0.47656250, 0.48437500, 0.45312500 },
   { 0.48828125, 0.49609375, 0.46484375 },
   { 0.49609375, 0.50390625, 0.47265625 },
   { 0.49609375, 0.50781250, 0.47656250 },
   { 0.50000000, 0.51171875, 0.48046875 },
   { 0.50390625, 0.51171875, 0.48437500 },
   { 0.50390625, 0.51562500, 0.48437500 },
   { 0.50781250, 0.51562500, 0.48828125 },
   { 0.51171875, 0.51953125, 0.49218750 },
   { 0.51953125, 0.53125000, 0.50000000 },
   { 0.54687500, 0.55468750, 0.52734375 },
   { 0.54687500, 0.55859375, 0.53125000 },
   { 0.55078125, 0.55859375, 0.53125000 },
   { 0.55078125, 0.55859375, 0.53125000 },
   { 0.55078125, 0.55859375, 0.53515625 },
   { 0.55078125, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53906250 },
   { 0.55468750, 0.56250000, 0.53906250 },
   { 0.55468750, 0.56640625, 0.53906250 },
   { 0.55859375, 0.57031250, 0.54296875 },
   { 0.58203125, 0.58984375, 0.56640625 },
   { 0.59375000, 0.60156250, 0.57421875 },
   { 0.59765625, 0.60546875, 0.58203125 },
   { 0.60156250, 0.60937500, 0.58593750 },
   { 0.60546875, 0.61328125, 0.58984375 },
   { 0.61328125, 0.62109375, 0.59765625 },
   { 0.61718750, 0.62500000, 0.60156250 },
   { 0.62109375, 0.62890625, 0.60546875 },
   { 0.62500000, 0.63281250, 0.60937500 },
   { 0.62890625, 0.63671875, 0.61328125 },
   { 0.63281250, 0.64062500, 0.61718750 },
   { 0.63671875, 0.64453125, 0.62109375 },
   { 0.64062500, 0.64843750, 0.62890625 },
   { 0.64453125, 0.65234375, 0.63281250 },
   { 0.64843750, 0.65625000, 0.63671875 },
   { 0.65234375, 0.66015625, 0.64062500 },
   { 0.66015625, 0.66796875, 0.64843750 },
   { 0.66796875, 0.67578125, 0.65625000 },
   { 0.67578125, 0.68359375, 0.66406250 },
   { 0.68359375, 0.68750000, 0.67187500 },
   { 0.68359375, 0.69140625, 0.67187500 },
   { 0.68359375, 0.69140625, 0.67187500 },
   { 0.68750000, 0.69140625, 0.67578125 },
   { 0.68750000, 0.69531250, 0.67578125 },
   { 0.69140625, 0.69531250, 0.67968750 },
   { 0.69140625, 0.69921875, 0.67968750 },
   { 0.69531250, 0.69921875, 0.68359375 },
   { 0.69531250, 0.69921875, 0.68359375 },
   { 0.69531250, 0.70312500, 0.68750000 },
   { 0.69921875, 0.70312500, 0.68750000 },
   { 0.69921875, 0.70703125, 0.68750000 },
   { 0.70312500, 0.70703125, 0.69140625 },
   { 0.70312500, 0.70703125, 0.69140625 },
   { 0.70312500, 0.71093750, 0.69531250 },
   { 0.70703125, 0.71093750, 0.69531250 },
   { 0.70703125, 0.71484375, 0.69921875 },
   { 0.71093750, 0.71484375, 0.69921875 },
   { 0.71093750, 0.71484375, 0.69921875 },
   { 0.71093750, 0.71875000, 0.70312500 },
   { 0.73046875, 0.73437500, 0.71875000 },
   { 0.74609375, 0.75000000, 0.73437500 },
   { 0.74609375, 0.75000000, 0.73437500 },
   { 0.74609375, 0.75000000, 0.73437500 },
   { 0.74609375, 0.75000000, 0.73828125 },
   { 0.74609375, 0.75000000, 0.73828125 },
   { 0.74609375, 0.75000000, 0.73828125 },
   { 0.75000000, 0.75390625, 0.73828125 },
   { 0.75000000, 0.75390625, 0.74218750 },
   { 0.75000000, 0.75390625, 0.74218750 },
   { 0.75390625, 0.75781250, 0.74609375 },
   { 0.76171875, 0.76562500, 0.75390625 },
   { 0.77343750, 0.77734375, 0.76562500 },
   { 0.79296875, 0.79687500, 0.78906250 },
   { 0.80078125, 0.80078125, 0.79687500 },
   { 0.80468750, 0.80468750, 0.80078125 },
   { 0.80859375, 0.81250000, 0.80859375 },
   { 0.81640625, 0.81640625, 0.81250000 },
   { 0.82031250, 0.82421875, 0.81640625 },
   { 0.82812500, 0.82812500, 0.82421875 },
   { 0.83203125, 0.83203125, 0.82812500 },
   { 0.83593750, 0.83984375, 0.83203125 },
   { 0.83593750, 0.83593750, 0.82812500 },
   { 0.83203125, 0.83593750, 0.82421875 },
   { 0.82812500, 0.83203125, 0.81640625 },
   { 0.82812500, 0.82812500, 0.81250000 },
   { 0.82421875, 0.82421875, 0.80859375 },
   { 0.82031250, 0.82031250, 0.80078125 },
   { 0.81640625, 0.81640625, 0.79687500 },
   { 0.80859375, 0.80859375, 0.77734375 },
   { 0.80078125, 0.79687500, 0.76171875 },
   { 0.82421875, 0.82031250, 0.79296875 },
   { 0.83593750, 0.83203125, 0.80468750 },
   { 0.84375000, 0.84375000, 0.81640625 },
   { 0.85156250, 0.85156250, 0.82812500 },
   { 0.85937500, 0.85546875, 0.83593750 },
   { 0.86328125, 0.86328125, 0.84375000 },
   { 0.87109375, 0.86718750, 0.85156250 },
   { 0.87500000, 0.87109375, 0.85546875 },
   { 0.87890625, 0.87500000, 0.86328125 },
   { 0.88281250, 0.88281250, 0.86718750 },
   { 0.88671875, 0.88281250, 0.87109375 },
   { 0.89062500, 0.88671875, 0.87500000 },
   { 0.89453125, 0.89062500, 0.87890625 },
   { 0.89453125, 0.89453125, 0.88281250 },
   { 0.89843750, 0.89843750, 0.88671875 },
   { 0.90234375, 0.89843750, 0.89062500 },
   { 0.90234375, 0.90234375, 0.89453125 },
   { 0.90625000, 0.90625000, 0.89843750 },
   { 0.90625000, 0.90625000, 0.90234375 },
   { 0.91015625, 0.91015625, 0.90234375 },
   { 0.91015625, 0.91015625, 0.90625000 },
   { 0.91406250, 0.91406250, 0.91015625 },
   { 0.91796875, 0.91796875, 0.91406250 },
   { 0.92187500, 0.92187500, 0.91796875 },
   { 0.92578125, 0.92578125, 0.92187500 },
   { 0.92968750, 0.92578125, 0.92578125 },
   { 0.92968750, 0.92968750, 0.92968750 },
   { 0.92968750, 0.92968750, 0.92968750 },
   { 0.93359375, 0.92968750, 0.92968750 },
   { 0.93359375, 0.93359375, 0.93359375 },
   { 0.92968750, 0.92968750, 0.92968750 },
   { 0.92578125, 0.92578125, 0.92578125 },
   { 0.91406250, 0.91406250, 0.91406250 },
   { 0.90625000, 0.90625000, 0.90625000 },
   { 0.89453125, 0.89453125, 0.89453125 },
   { 0.87890625, 0.87890625, 0.87890625 },
   { 0.85937500, 0.85937500, 0.85937500 },
   { 0.83203125, 0.83203125, 0.83203125 },
   { 0.67968750, 0.67968750, 0.68359375 },
   { 0.73046875, 0.73046875, 0.73828125 },
   { 0.75390625, 0.75390625, 0.76562500 },
   { 0.76953125, 0.76953125, 0.78515625 },
   { 0.77734375, 0.77734375, 0.79296875 },
   { 0.78515625, 0.78515625, 0.79687500 },
   { 0.79687500, 0.79296875, 0.80078125 },
   { 0.80468750, 0.79687500, 0.80078125 },
   { 0.81250000, 0.80468750, 0.80468750 },
   { 0.81640625, 0.80468750, 0.80468750 },
   { 0.80859375, 0.80078125, 0.80078125 },
   { 0.80468750, 0.79296875, 0.79296875 },
   { 0.79687500, 0.78906250, 0.78906250 },
   { 0.79296875, 0.78515625, 0.78515625 },
   { 0.78515625, 0.77734375, 0.78125000 },
   { 0.78125000, 0.77343750, 0.77343750 },
   { 0.77343750, 0.76953125, 0.76953125 },
   { 0.76171875, 0.75781250, 0.76171875 },
   { 0.73828125, 0.73828125, 0.73828125 },
   { 0.72265625, 0.72656250, 0.72656250 },
   { 0.72265625, 0.73046875, 0.72656250 },
   { 0.72656250, 0.73437500, 0.72265625 },
   { 0.72656250, 0.73828125, 0.72265625 },
   { 0.72656250, 0.74218750, 0.72265625 },
   { 0.73046875, 0.74218750, 0.71875000 },
   { 0.73046875, 0.74609375, 0.71875000 },
   { 0.73046875, 0.75000000, 0.71875000 },
   { 0.73046875, 0.75390625, 0.71875000 },
   { 0.73046875, 0.75390625, 0.71875000 },
   { 0.71875000, 0.73828125, 0.70312500 },
   { 0.69921875, 0.71484375, 0.68359375 },
   { 0.67968750, 0.69531250, 0.66796875 },
   { 0.65234375, 0.66406250, 0.64062500 },
   { 0.62109375, 0.62890625, 0.61328125 },
   { 0.61718750, 0.62500000, 0.60937500 },
   { 0.61718750, 0.62109375, 0.60937500 },
   { 0.61328125, 0.62109375, 0.60546875 },
   { 0.60937500, 0.61718750, 0.60156250 },
   { 0.60546875, 0.61328125, 0.59765625 },
   { 0.60156250, 0.60546875, 0.59375000 },
   { 0.59375000, 0.59765625, 0.58984375 },
   { 0.58203125, 0.58984375, 0.57812500 },
   { 0.57031250, 0.57421875, 0.56640625 },
   { 0.54687500, 0.54687500, 0.54296875 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.51953125 },
   { 0.52343750, 0.51953125, 0.51953125 },
   { 0.51953125, 0.51953125, 0.51562500 },
   { 0.51562500, 0.51171875, 0.50390625 },
   { 0.50781250, 0.50390625, 0.49218750 },
   { 0.46484375, 0.45703125, 0.44921875 },
   { 0.50781250, 0.49218750, 0.49218750 },
   { 0.54296875, 0.51953125, 0.52734375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.50781250, 0.49609375 },
   { 0.50781250, 0.50781250, 0.49609375 },
   { 0.50390625, 0.50781250, 0.49218750 },
   { 0.50390625, 0.50390625, 0.49218750 },
   { 0.50000000, 0.50390625, 0.49218750 },
   { 0.50000000, 0.50000000, 0.48828125 },
   { 0.49609375, 0.49609375, 0.48828125 },
   { 0.49218750, 0.48828125, 0.48437500 },
   { 0.48437500, 0.48046875, 0.47656250 },
   { 0.47656250, 0.46875000, 0.46875000 },
   { 0.47656250, 0.46484375, 0.46875000 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.45703125, 0.46484375 },
   { 0.46875000, 0.45703125, 0.46093750 },
   { 0.46875000, 0.45703125, 0.46093750 },
   { 0.46875000, 0.45703125, 0.46093750 },
   { 0.46875000, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46875000, 0.45312500, 0.46093750 },
   { 0.47265625, 0.45703125, 0.46484375 },
   { 0.46875000, 0.45312500, 0.46093750 },
   { 0.47656250, 0.45703125, 0.46875000 },
   { 0.48437500, 0.46484375, 0.47656250 },
   { 0.48828125, 0.47265625, 0.48437500 },
   { 0.49609375, 0.48046875, 0.49218750 },
   { 0.50390625, 0.48828125, 0.50000000 },
   { 0.51171875, 0.49218750, 0.50390625 },
   { 0.51562500, 0.49609375, 0.51171875 },
   { 0.51953125, 0.50390625, 0.51562500 },
   { 0.52734375, 0.50781250, 0.52343750 },
   { 0.53125000, 0.51171875, 0.52734375 },
   { 0.53515625, 0.51953125, 0.53125000 },
   { 0.54296875, 0.52343750, 0.53906250 },
   { 0.54687500, 0.52734375, 0.54296875 },
   { 0.55468750, 0.53515625, 0.54687500 },
};

const int RGB_Palette_15_Size = 256; // gimp - Sunrise
double RGB_Palette_15[RGB_Palette_15_Size][3] =
{
   { 0.85937500, 0.85937500, 0.85937500 },
   { 0.85937500, 0.85937500, 0.85546875 },
   { 0.86328125, 0.86328125, 0.85546875 },
   { 0.86328125, 0.86328125, 0.85546875 },
   { 0.86328125, 0.86718750, 0.85546875 },
   { 0.86718750, 0.86718750, 0.85156250 },
   { 0.86718750, 0.87109375, 0.85156250 },
   { 0.87109375, 0.87109375, 0.85156250 },
   { 0.87109375, 0.87500000, 0.85156250 },
   { 0.87109375, 0.87500000, 0.84765625 },
   { 0.87500000, 0.87890625, 0.84765625 },
   { 0.87500000, 0.87890625, 0.84765625 },
   { 0.87890625, 0.88281250, 0.84765625 },
   { 0.87890625, 0.88281250, 0.84375000 },
   { 0.88281250, 0.88671875, 0.84375000 },
   { 0.88281250, 0.89062500, 0.84375000 },
   { 0.88281250, 0.89062500, 0.84375000 },
   { 0.88671875, 0.89453125, 0.83984375 },
   { 0.88671875, 0.89453125, 0.83984375 },
   { 0.89062500, 0.89843750, 0.83984375 },
   { 0.89062500, 0.89843750, 0.83984375 },
   { 0.89062500, 0.90234375, 0.83593750 },
   { 0.89453125, 0.90234375, 0.83593750 },
   { 0.89453125, 0.90625000, 0.83593750 },
   { 0.89843750, 0.90625000, 0.83593750 },
   { 0.89843750, 0.91015625, 0.83203125 },
   { 0.90234375, 0.91015625, 0.83203125 },
   { 0.90234375, 0.91406250, 0.83203125 },
   { 0.90625000, 0.91796875, 0.82812500 },
   { 0.91015625, 0.92187500, 0.82812500 },
   { 0.91406250, 0.92578125, 0.82421875 },
   { 0.91796875, 0.92968750, 0.82421875 },
   { 0.91796875, 0.93750000, 0.82031250 },
   { 0.92187500, 0.94140625, 0.82031250 },
   { 0.92578125, 0.94531250, 0.81640625 },
   { 0.92968750, 0.94921875, 0.81640625 },
   { 0.93359375, 0.95312500, 0.81250000 },
   { 0.93750000, 0.95703125, 0.81250000 },
   { 0.93750000, 0.96093750, 0.80859375 },
   { 0.94140625, 0.96484375, 0.80859375 },
   { 0.94531250, 0.95312500, 0.78906250 },
   { 0.94531250, 0.93750000, 0.77343750 },
   { 0.94531250, 0.92578125, 0.75781250 },
   { 0.94921875, 0.91406250, 0.74218750 },
   { 0.94921875, 0.89843750, 0.72265625 },
   { 0.95312500, 0.88671875, 0.70703125 },
   { 0.95312500, 0.87500000, 0.69140625 },
   { 0.95703125, 0.86328125, 0.67187500 },
   { 0.95703125, 0.84765625, 0.65625000 },
   { 0.95703125, 0.83593750, 0.64062500 },
   { 0.96093750, 0.82421875, 0.62500000 },
   { 0.96093750, 0.80859375, 0.60546875 },
   { 0.96484375, 0.79687500, 0.58984375 },
   { 0.96484375, 0.78515625, 0.57421875 },
   { 0.96484375, 0.76953125, 0.55859375 },
   { 0.96875000, 0.75781250, 0.53906250 },
   { 0.96875000, 0.74218750, 0.51953125 },
   { 0.97265625, 0.72265625, 0.49609375 },
   { 0.97265625, 0.70703125, 0.47265625 },
   { 0.97656250, 0.68750000, 0.44921875 },
   { 0.98046875, 0.67187500, 0.42578125 },
   { 0.98046875, 0.65234375, 0.40625000 },
   { 0.98437500, 0.63671875, 0.38281250 },
   { 0.98437500, 0.62109375, 0.35937500 },
   { 0.98828125, 0.60156250, 0.33593750 },
   { 0.98828125, 0.58593750, 0.31250000 },
   { 0.99218750, 0.56640625, 0.28906250 },
   { 0.99218750, 0.55078125, 0.26953125 },
   { 0.98828125, 0.53906250, 0.26562500 },
   { 0.98046875, 0.53125000, 0.26171875 },
   { 0.97265625, 0.52343750, 0.26171875 },
   { 0.96484375, 0.51562500, 0.25781250 },
   { 0.95703125, 0.50781250, 0.25781250 },
   { 0.94921875, 0.49609375, 0.25390625 },
   { 0.94140625, 0.48828125, 0.25390625 },
   { 0.93359375, 0.48046875, 0.25390625 },
   { 0.92578125, 0.47265625, 0.25000000 },
   { 0.91406250, 0.46484375, 0.25000000 },
   { 0.90625000, 0.45312500, 0.24609375 },
   { 0.89843750, 0.44531250, 0.24609375 },
   { 0.89062500, 0.43750000, 0.24218750 },
   { 0.88281250, 0.42968750, 0.24218750 },
   { 0.87500000, 0.42187500, 0.23828125 },
   { 0.86718750, 0.41015625, 0.23828125 },
   { 0.85937500, 0.40234375, 0.23437500 },
   { 0.85156250, 0.39453125, 0.23437500 },
   { 0.84375000, 0.38671875, 0.23046875 },
   { 0.83593750, 0.37890625, 0.23046875 },
   { 0.82812500, 0.36718750, 0.22656250 },
   { 0.82031250, 0.35937500, 0.22656250 },
   { 0.81250000, 0.35156250, 0.22265625 },
   { 0.80468750, 0.34375000, 0.22265625 },
   { 0.79687500, 0.33593750, 0.21875000 },
   { 0.78906250, 0.32812500, 0.21875000 },
   { 0.77734375, 0.31250000, 0.21484375 },
   { 0.75781250, 0.29296875, 0.21093750 },
   { 0.74218750, 0.27343750, 0.20703125 },
   { 0.72265625, 0.25000000, 0.20312500 },
   { 0.70312500, 0.23046875, 0.19921875 },
   { 0.68359375, 0.21093750, 0.19140625 },
   { 0.66406250, 0.19140625, 0.18750000 },
   { 0.64843750, 0.16796875, 0.18359375 },
   { 0.62890625, 0.14843750, 0.17968750 },
   { 0.60937500, 0.12890625, 0.17578125 },
   { 0.58984375, 0.10937500, 0.17187500 },
   { 0.57421875, 0.09375000, 0.16406250 },
   { 0.56250000, 0.09765625, 0.16015625 },
   { 0.55078125, 0.09765625, 0.15625000 },
   { 0.53906250, 0.10156250, 0.15234375 },
   { 0.52734375, 0.10546875, 0.14843750 },
   { 0.51562500, 0.10546875, 0.14062500 },
   { 0.50390625, 0.10937500, 0.13671875 },
   { 0.49218750, 0.10937500, 0.13281250 },
   { 0.48046875, 0.11328125, 0.12890625 },
   { 0.46875000, 0.11718750, 0.12500000 },
   { 0.45703125, 0.11718750, 0.11718750 },
   { 0.44531250, 0.12109375, 0.11328125 },
   { 0.43359375, 0.12109375, 0.10937500 },
   { 0.42187500, 0.12500000, 0.10546875 },
   { 0.41015625, 0.12890625, 0.09765625 },
   { 0.39843750, 0.12890625, 0.09375000 },
   { 0.38281250, 0.13281250, 0.08984375 },
   { 0.37109375, 0.13671875, 0.08203125 },
   { 0.35937500, 0.13671875, 0.07812500 },
   { 0.34375000, 0.14062500, 0.07421875 },
   { 0.33203125, 0.14453125, 0.06640625 },
   { 0.32031250, 0.14453125, 0.06250000 },
   { 0.30468750, 0.14843750, 0.05468750 },
   { 0.29296875, 0.15234375, 0.05078125 },
   { 0.28515625, 0.15625000, 0.05078125 },
   { 0.28515625, 0.16015625, 0.06640625 },
   { 0.28515625, 0.16406250, 0.07812500 },
   { 0.28906250, 0.16796875, 0.09375000 },
   { 0.28906250, 0.17578125, 0.10546875 },
   { 0.28906250, 0.17968750, 0.12109375 },
   { 0.28906250, 0.18359375, 0.13281250 },
   { 0.29296875, 0.18750000, 0.14843750 },
   { 0.29296875, 0.19531250, 0.16015625 },
   { 0.29296875, 0.19921875, 0.17578125 },
   { 0.29296875, 0.20312500, 0.18750000 },
   { 0.29296875, 0.20703125, 0.20312500 },
   { 0.29687500, 0.21484375, 0.21484375 },
   { 0.29687500, 0.21875000, 0.23046875 },
   { 0.29687500, 0.22265625, 0.24218750 },
   { 0.29687500, 0.22656250, 0.25781250 },
   { 0.30078125, 0.23437500, 0.26953125 },
   { 0.30078125, 0.23828125, 0.28515625 },
   { 0.30078125, 0.24218750, 0.29687500 },
   { 0.30078125, 0.25000000, 0.31250000 },
   { 0.30078125, 0.25390625, 0.32421875 },
   { 0.30468750, 0.25781250, 0.33984375 },
   { 0.30468750, 0.26171875, 0.35156250 },
   { 0.30468750, 0.26953125, 0.36718750 },
   { 0.30468750, 0.27343750, 0.37890625 },
   { 0.30859375, 0.27734375, 0.39453125 },
   { 0.30859375, 0.28125000, 0.40625000 },
   { 0.30859375, 0.28906250, 0.42187500 },
   { 0.30859375, 0.29687500, 0.44140625 },
   { 0.31250000, 0.30468750, 0.46484375 },
   { 0.31250000, 0.31250000, 0.48437500 },
   { 0.31250000, 0.32031250, 0.50781250 },
   { 0.31640625, 0.32812500, 0.53125000 },
   { 0.31640625, 0.33593750, 0.55078125 },
   { 0.32031250, 0.34375000, 0.57421875 },
   { 0.32031250, 0.35156250, 0.59375000 },
   { 0.32031250, 0.35937500, 0.61718750 },
   { 0.32421875, 0.36718750, 0.63671875 },
   { 0.32421875, 0.37500000, 0.66015625 },
   { 0.32421875, 0.38281250, 0.67968750 },
   { 0.32812500, 0.39062500, 0.70312500 },
   { 0.32812500, 0.39843750, 0.72265625 },
   { 0.32812500, 0.40625000, 0.74609375 },
   { 0.33203125, 0.41406250, 0.76562500 },
   { 0.33203125, 0.42187500, 0.78906250 },
   { 0.33593750, 0.42578125, 0.79687500 },
   { 0.34375000, 0.43359375, 0.80078125 },
   { 0.34765625, 0.44140625, 0.80078125 },
   { 0.35546875, 0.44531250, 0.80468750 },
   { 0.36328125, 0.45312500, 0.80468750 },
   { 0.36718750, 0.46093750, 0.80859375 },
   { 0.37500000, 0.46484375, 0.81250000 },
   { 0.37890625, 0.47265625, 0.81250000 },
   { 0.38671875, 0.48046875, 0.81640625 },
   { 0.39062500, 0.48828125, 0.81640625 },
   { 0.39843750, 0.49218750, 0.82031250 },
   { 0.40234375, 0.50000000, 0.82421875 },
   { 0.41015625, 0.50781250, 0.82421875 },
   { 0.41796875, 0.51171875, 0.82812500 },
   { 0.42187500, 0.51953125, 0.82812500 },
   { 0.42968750, 0.52734375, 0.83203125 },
   { 0.43359375, 0.53125000, 0.83593750 },
   { 0.44140625, 0.53906250, 0.83593750 },
   { 0.44531250, 0.54687500, 0.83984375 },
   { 0.45312500, 0.55078125, 0.83984375 },
   { 0.45703125, 0.55859375, 0.84375000 },
   { 0.46484375, 0.56640625, 0.84765625 },
   { 0.47265625, 0.57421875, 0.84765625 },
   { 0.47656250, 0.57812500, 0.85156250 },
   { 0.48437500, 0.58593750, 0.85156250 },
   { 0.48828125, 0.59375000, 0.85546875 },
   { 0.49609375, 0.59765625, 0.85937500 },
   { 0.50000000, 0.60546875, 0.85937500 },
   { 0.50781250, 0.61328125, 0.86328125 },
   { 0.51562500, 0.61718750, 0.86328125 },
   { 0.51953125, 0.62500000, 0.86718750 },
   { 0.52734375, 0.63281250, 0.87109375 },
   { 0.53125000, 0.63671875, 0.87109375 },
   { 0.53906250, 0.64453125, 0.87500000 },
   { 0.54296875, 0.65234375, 0.87500000 },
   { 0.55078125, 0.66015625, 0.87890625 },
   { 0.55468750, 0.66406250, 0.88281250 },
   { 0.56250000, 0.67187500, 0.88281250 },
   { 0.57031250, 0.67968750, 0.88671875 },
   { 0.57421875, 0.68359375, 0.88671875 },
   { 0.58203125, 0.69140625, 0.89062500 },
   { 0.58593750, 0.69921875, 0.89453125 },
   { 0.59375000, 0.70312500, 0.89453125 },
   { 0.60156250, 0.71093750, 0.89843750 },
   { 0.60546875, 0.71875000, 0.90234375 },
   { 0.61328125, 0.72656250, 0.90234375 },
   { 0.62109375, 0.73437500, 0.90625000 },
   { 0.62500000, 0.73828125, 0.91015625 },
   { 0.63281250, 0.74609375, 0.91015625 },
   { 0.63671875, 0.75390625, 0.91406250 },
   { 0.64453125, 0.76171875, 0.91406250 },
   { 0.65234375, 0.76953125, 0.91796875 },
   { 0.65625000, 0.77734375, 0.92187500 },
   { 0.66406250, 0.78125000, 0.92187500 },
   { 0.67187500, 0.78906250, 0.92578125 },
   { 0.67578125, 0.79687500, 0.92968750 },
   { 0.68359375, 0.80468750, 0.92968750 },
   { 0.69140625, 0.81250000, 0.93359375 },
   { 0.69531250, 0.81640625, 0.93750000 },
   { 0.70312500, 0.82421875, 0.93750000 },
   { 0.71093750, 0.83203125, 0.94140625 },
   { 0.71484375, 0.83984375, 0.94531250 },
   { 0.72265625, 0.84765625, 0.94531250 },
   { 0.73046875, 0.85156250, 0.94921875 },
   { 0.73437500, 0.85937500, 0.95312500 },
   { 0.74218750, 0.86718750, 0.95312500 },
   { 0.75000000, 0.87500000, 0.95703125 },
   { 0.75390625, 0.88281250, 0.95703125 },
   { 0.76171875, 0.88671875, 0.96093750 },
   { 0.76953125, 0.89453125, 0.96484375 },
   { 0.77343750, 0.90234375, 0.96484375 },
   { 0.78125000, 0.91015625, 0.96875000 },
   { 0.78906250, 0.91796875, 0.97265625 },
   { 0.79296875, 0.92187500, 0.97265625 },
   { 0.80078125, 0.92968750, 0.97656250 },
   { 0.80859375, 0.93750000, 0.98046875 },
   { 0.81250000, 0.94531250, 0.98046875 },
   { 0.82031250, 0.95312500, 0.98437500 },
   { 0.82812500, 0.95703125, 0.98828125 },
   { 0.83203125, 0.96484375, 0.98828125 },
   { 0.83984375, 0.97265625, 0.99218750 },
   { 0.84765625, 0.98046875, 0.99218750 },
};
const int RGB_Palette_16_Size = 256; // gimp - Horizon
double RGB_Palette_16[RGB_Palette_16_Size][3] =
{
   { 0.04687500, 0.35546875, 0.56640625 },
   { 0.05468750, 0.36328125, 0.57031250 },
   { 0.06250000, 0.36718750, 0.57421875 },
   { 0.07031250, 0.37109375, 0.57812500 },
   { 0.07812500, 0.37890625, 0.58203125 },
   { 0.08593750, 0.38281250, 0.58593750 },
   { 0.09375000, 0.38671875, 0.58984375 },
   { 0.10156250, 0.39453125, 0.59375000 },
   { 0.10937500, 0.39843750, 0.59765625 },
   { 0.11718750, 0.40234375, 0.59765625 },
   { 0.12500000, 0.41015625, 0.60156250 },
   { 0.13281250, 0.41406250, 0.60546875 },
   { 0.14062500, 0.41796875, 0.60937500 },
   { 0.14843750, 0.42578125, 0.61328125 },
   { 0.15625000, 0.42968750, 0.61718750 },
   { 0.16406250, 0.43359375, 0.62109375 },
   { 0.17187500, 0.44140625, 0.62500000 },
   { 0.17968750, 0.44531250, 0.62500000 },
   { 0.18750000, 0.44921875, 0.62890625 },
   { 0.19531250, 0.45703125, 0.63281250 },
   { 0.20312500, 0.46093750, 0.63671875 },
   { 0.21093750, 0.46484375, 0.64062500 },
   { 0.21875000, 0.47265625, 0.64453125 },
   { 0.22656250, 0.47656250, 0.64843750 },
   { 0.23437500, 0.48046875, 0.65234375 },
   { 0.24218750, 0.48828125, 0.65234375 },
   { 0.25000000, 0.49218750, 0.65625000 },
   { 0.25781250, 0.49609375, 0.66015625 },
   { 0.26562500, 0.50390625, 0.66406250 },
   { 0.27343750, 0.50781250, 0.66796875 },
   { 0.28125000, 0.51171875, 0.67187500 },
   { 0.28906250, 0.51953125, 0.67578125 },
   { 0.29687500, 0.52343750, 0.67968750 },
   { 0.30859375, 0.52734375, 0.67968750 },
   { 0.31640625, 0.53515625, 0.68359375 },
   { 0.32421875, 0.53906250, 0.68750000 },
   { 0.33203125, 0.54296875, 0.69140625 },
   { 0.33984375, 0.55078125, 0.69531250 },
   { 0.34765625, 0.55468750, 0.69921875 },
   { 0.35546875, 0.55859375, 0.70312500 },
   { 0.36328125, 0.56640625, 0.70703125 },
   { 0.37109375, 0.57031250, 0.70703125 },
   { 0.37890625, 0.57421875, 0.71093750 },
   { 0.38671875, 0.58203125, 0.71484375 },
   { 0.39453125, 0.58593750, 0.71875000 },
   { 0.40234375, 0.58984375, 0.72265625 },
   { 0.41015625, 0.59765625, 0.72656250 },
   { 0.41796875, 0.60156250, 0.73046875 },
   { 0.42578125, 0.60546875, 0.73437500 },
   { 0.43359375, 0.61328125, 0.73828125 },
   { 0.44140625, 0.61718750, 0.73828125 },
   { 0.44921875, 0.62109375, 0.74218750 },
   { 0.45703125, 0.62890625, 0.74609375 },
   { 0.46484375, 0.63281250, 0.75000000 },
   { 0.47265625, 0.63671875, 0.75390625 },
   { 0.48046875, 0.64453125, 0.75781250 },
   { 0.48828125, 0.64843750, 0.76171875 },
   { 0.49609375, 0.65234375, 0.76562500 },
   { 0.50390625, 0.66015625, 0.76562500 },
   { 0.51171875, 0.66406250, 0.76953125 },
   { 0.51953125, 0.66796875, 0.77343750 },
   { 0.52734375, 0.67187500, 0.77734375 },
   { 0.53515625, 0.67968750, 0.78125000 },
   { 0.54296875, 0.68359375, 0.78125000 },
   { 0.54687500, 0.68750000, 0.78515625 },
   { 0.55468750, 0.69140625, 0.78906250 },
   { 0.56250000, 0.69531250, 0.79296875 },
   { 0.57031250, 0.69921875, 0.79296875 },
   { 0.57421875, 0.70312500, 0.79687500 },
   { 0.58203125, 0.71093750, 0.80078125 },
   { 0.58984375, 0.71484375, 0.80468750 },
   { 0.59765625, 0.71875000, 0.80468750 },
   { 0.60156250, 0.72265625, 0.80859375 },
   { 0.60937500, 0.72656250, 0.81250000 },
   { 0.61718750, 0.73046875, 0.81640625 },
   { 0.62500000, 0.73437500, 0.81640625 },
   { 0.62890625, 0.74218750, 0.82031250 },
   { 0.63671875, 0.74609375, 0.82421875 },
   { 0.64453125, 0.75000000, 0.82812500 },
   { 0.65234375, 0.75390625, 0.83203125 },
   { 0.65625000, 0.75781250, 0.83203125 },
   { 0.66406250, 0.76171875, 0.83593750 },
   { 0.67187500, 0.76562500, 0.83984375 },
   { 0.67968750, 0.77343750, 0.84375000 },
   { 0.68359375, 0.77734375, 0.84375000 },
   { 0.69140625, 0.78125000, 0.84765625 },
   { 0.69921875, 0.78515625, 0.85156250 },
   { 0.70703125, 0.78906250, 0.85546875 },
   { 0.71093750, 0.79296875, 0.85546875 },
   { 0.71875000, 0.79687500, 0.85937500 },
   { 0.72656250, 0.80468750, 0.86328125 },
   { 0.73437500, 0.80859375, 0.86718750 },
   { 0.73828125, 0.81250000, 0.86718750 },
   { 0.74609375, 0.81640625, 0.87109375 },
   { 0.75390625, 0.82031250, 0.87500000 },
   { 0.76171875, 0.82421875, 0.87890625 },
   { 0.76562500, 0.82812500, 0.87890625 },
   { 0.77343750, 0.83593750, 0.88281250 },
   { 0.78125000, 0.83984375, 0.88671875 },
   { 0.78906250, 0.84375000, 0.89062500 },
   { 0.79296875, 0.84765625, 0.89062500 },
   { 0.80078125, 0.85156250, 0.89453125 },
   { 0.80859375, 0.85546875, 0.89843750 },
   { 0.81640625, 0.85937500, 0.90234375 },
   { 0.82031250, 0.86718750, 0.90234375 },
   { 0.82812500, 0.87109375, 0.90625000 },
   { 0.83593750, 0.87500000, 0.91015625 },
   { 0.83984375, 0.87890625, 0.91406250 },
   { 0.84765625, 0.88281250, 0.91406250 },
   { 0.85546875, 0.88671875, 0.91796875 },
   { 0.86328125, 0.89062500, 0.92187500 },
   { 0.86718750, 0.89843750, 0.92578125 },
   { 0.87500000, 0.90234375, 0.92578125 },
   { 0.88281250, 0.90625000, 0.92968750 },
   { 0.89062500, 0.91015625, 0.93359375 },
   { 0.89453125, 0.91406250, 0.93750000 },
   { 0.90234375, 0.91796875, 0.93750000 },
   { 0.91015625, 0.92187500, 0.94140625 },
   { 0.91796875, 0.92578125, 0.94531250 },
   { 0.92187500, 0.93359375, 0.94921875 },
   { 0.92968750, 0.93750000, 0.94921875 },
   { 0.93750000, 0.94140625, 0.95312500 },
   { 0.94531250, 0.94531250, 0.95703125 },
   { 0.94921875, 0.94921875, 0.96093750 },
   { 0.95703125, 0.95312500, 0.96093750 },
   { 0.96484375, 0.95703125, 0.96484375 },
   { 0.97265625, 0.96484375, 0.96875000 },
   { 0.97656250, 0.96875000, 0.97265625 },
   { 0.98437500, 0.97265625, 0.97265625 },
   { 0.99218750, 0.97656250, 0.97656250 },
   { 0.99218750, 0.98828125, 0.98828125 },
   { 0.98828125, 0.98046875, 0.97656250 },
   { 0.98437500, 0.97265625, 0.96484375 },
   { 0.98437500, 0.96484375, 0.95312500 },
   { 0.98046875, 0.95703125, 0.94531250 },
   { 0.97656250, 0.94921875, 0.93359375 },
   { 0.97265625, 0.94140625, 0.92578125 },
   { 0.97265625, 0.93359375, 0.91406250 },
   { 0.96875000, 0.92578125, 0.90625000 },
   { 0.96484375, 0.91796875, 0.89453125 },
   { 0.96484375, 0.91406250, 0.88671875 },
   { 0.96093750, 0.90625000, 0.87500000 },
   { 0.95703125, 0.89843750, 0.86718750 },
   { 0.95703125, 0.89062500, 0.85937500 },
   { 0.95312500, 0.88671875, 0.84765625 },
   { 0.94921875, 0.87890625, 0.83984375 },
   { 0.94921875, 0.87109375, 0.83203125 },
   { 0.94531250, 0.86328125, 0.82421875 },
   { 0.94140625, 0.85937500, 0.81250000 },
   { 0.94140625, 0.85156250, 0.80468750 },
   { 0.93750000, 0.84375000, 0.79687500 },
   { 0.93750000, 0.83984375, 0.78906250 },
   { 0.93359375, 0.83203125, 0.77734375 },
   { 0.92968750, 0.82421875, 0.76953125 },
   { 0.92578125, 0.81640625, 0.75781250 },
   { 0.92578125, 0.80859375, 0.74609375 },
   { 0.92187500, 0.80078125, 0.73828125 },
   { 0.91796875, 0.79296875, 0.72656250 },
   { 0.91406250, 0.78515625, 0.71484375 },
   { 0.91406250, 0.77734375, 0.70312500 },
   { 0.91015625, 0.76562500, 0.69140625 },
   { 0.90625000, 0.75781250, 0.68359375 },
   { 0.90234375, 0.75000000, 0.67187500 },
   { 0.89843750, 0.74218750, 0.66015625 },
   { 0.89843750, 0.73437500, 0.65234375 },
   { 0.89453125, 0.72656250, 0.64062500 },
   { 0.89062500, 0.71875000, 0.63281250 },
   { 0.89062500, 0.71484375, 0.62109375 },
   { 0.88671875, 0.70703125, 0.61328125 },
   { 0.88281250, 0.69921875, 0.60156250 },
   { 0.87890625, 0.69140625, 0.59375000 },
   { 0.87890625, 0.68359375, 0.58203125 },
   { 0.87500000, 0.67578125, 0.57031250 },
   { 0.87109375, 0.66796875, 0.56250000 },
   { 0.87109375, 0.66015625, 0.55078125 },
   { 0.87109375, 0.66015625, 0.55078125 },
   { 0.86718750, 0.66015625, 0.55078125 },
   { 0.86718750, 0.65625000, 0.54687500 },
   { 0.86718750, 0.65625000, 0.54687500 },
   { 0.86718750, 0.65625000, 0.54296875 },
   { 0.86718750, 0.65234375, 0.54296875 },
   { 0.86718750, 0.65234375, 0.54296875 },
   { 0.86718750, 0.65234375, 0.53906250 },
   { 0.86718750, 0.65234375, 0.53906250 },
   { 0.86718750, 0.64843750, 0.53515625 },
   { 0.86328125, 0.64843750, 0.53515625 },
   { 0.86328125, 0.64843750, 0.53515625 },
   { 0.86328125, 0.64453125, 0.53125000 },
   { 0.86328125, 0.64453125, 0.53125000 },
   { 0.86328125, 0.64453125, 0.53125000 },
   { 0.86328125, 0.64062500, 0.52734375 },
   { 0.86328125, 0.64062500, 0.52734375 },
   { 0.86328125, 0.64062500, 0.52343750 },
   { 0.86328125, 0.64062500, 0.52343750 },
   { 0.85937500, 0.63671875, 0.52343750 },
   { 0.85937500, 0.63671875, 0.51953125 },
   { 0.85937500, 0.63671875, 0.51953125 },
   { 0.85937500, 0.63281250, 0.51562500 },
   { 0.85937500, 0.63281250, 0.51562500 },
   { 0.85937500, 0.63281250, 0.51562500 },
   { 0.85937500, 0.63281250, 0.51171875 },
   { 0.85937500, 0.62890625, 0.51171875 },
   { 0.85937500, 0.62890625, 0.50781250 },
   { 0.85546875, 0.62890625, 0.50781250 },
   { 0.85546875, 0.62500000, 0.50781250 },
   { 0.85546875, 0.62500000, 0.50390625 },
   { 0.85546875, 0.62500000, 0.50390625 },
   { 0.85546875, 0.62109375, 0.50000000 },
   { 0.85546875, 0.62109375, 0.50000000 },
   { 0.85546875, 0.62109375, 0.50000000 },
   { 0.85546875, 0.62109375, 0.49609375 },
   { 0.85546875, 0.61718750, 0.49609375 },
   { 0.85156250, 0.61718750, 0.49609375 },
   { 0.85156250, 0.61718750, 0.49218750 },
   { 0.85156250, 0.61328125, 0.49218750 },
   { 0.85156250, 0.61328125, 0.48828125 },
   { 0.85156250, 0.61328125, 0.48828125 },
   { 0.85156250, 0.61328125, 0.48828125 },
   { 0.85156250, 0.60937500, 0.48437500 },
   { 0.85156250, 0.60937500, 0.48437500 },
   { 0.85156250, 0.60937500, 0.48046875 },
   { 0.84765625, 0.60546875, 0.48046875 },
   { 0.84765625, 0.60546875, 0.47656250 },
   { 0.84765625, 0.60156250, 0.47656250 },
   { 0.84765625, 0.60156250, 0.47265625 },
   { 0.84765625, 0.59765625, 0.46875000 },
   { 0.84765625, 0.59765625, 0.46875000 },
   { 0.84375000, 0.59765625, 0.46484375 },
   { 0.84375000, 0.59375000, 0.46484375 },
   { 0.84375000, 0.59375000, 0.46093750 },
   { 0.84375000, 0.58984375, 0.46093750 },
   { 0.84375000, 0.58984375, 0.45703125 },
   { 0.84375000, 0.58593750, 0.45703125 },
   { 0.83984375, 0.58593750, 0.45312500 },
   { 0.83984375, 0.58593750, 0.44921875 },
   { 0.83984375, 0.58203125, 0.44921875 },
   { 0.83984375, 0.58203125, 0.44531250 },
   { 0.83984375, 0.57812500, 0.44531250 },
   { 0.83984375, 0.57812500, 0.44140625 },
   { 0.83984375, 0.57421875, 0.44140625 },
   { 0.83593750, 0.57421875, 0.43750000 },
   { 0.83593750, 0.57421875, 0.43359375 },
   { 0.83593750, 0.57031250, 0.43359375 },
   { 0.83593750, 0.57031250, 0.42968750 },
   { 0.83593750, 0.56640625, 0.42968750 },
   { 0.83593750, 0.56640625, 0.42578125 },
   { 0.83203125, 0.56640625, 0.42578125 },
   { 0.83203125, 0.56250000, 0.42187500 },
   { 0.83203125, 0.56250000, 0.42187500 },
   { 0.83203125, 0.55859375, 0.41796875 },
   { 0.83203125, 0.55859375, 0.41406250 },
   { 0.83203125, 0.55468750, 0.41406250 },
   { 0.82812500, 0.55468750, 0.41015625 },
   { 0.82812500, 0.55468750, 0.41015625 },
   { 0.82812500, 0.55078125, 0.40625000 },
   { 0.82812500, 0.55078125, 0.40625000 },
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_17_Size = 254; // BlueYellowRed.rgb
double RGB_Palette_17[RGB_Palette_17_Size][3] =
{
   {0.019531, 0.136719, 0.312500},
   {0.019531, 0.144531, 0.324219},
   {0.019531, 0.152344, 0.335938},
   {0.019531, 0.156250, 0.347656},
   {0.019531, 0.164062, 0.359375},
   {0.023438, 0.171875, 0.371094},
   {0.023438, 0.179688, 0.382812},
   {0.023438, 0.187500, 0.390625},
   {0.023438, 0.191406, 0.402344},
   {0.023438, 0.199219, 0.414062},
   {0.023438, 0.207031, 0.425781},
   {0.023438, 0.214844, 0.437500},
   {0.023438, 0.222656, 0.449219},
   {0.027344, 0.230469, 0.460938},
   {0.027344, 0.234375, 0.472656},
   {0.027344, 0.242188, 0.484375},
   {0.027344, 0.250000, 0.496094},
   {0.027344, 0.257812, 0.507812},
   {0.027344, 0.265625, 0.519531},
   {0.027344, 0.269531, 0.531250},
   {0.027344, 0.277344, 0.539062},
   {0.027344, 0.285156, 0.550781},
   {0.031250, 0.292969, 0.562500},
   {0.031250, 0.300781, 0.574219},
   {0.031250, 0.304688, 0.585938},
   {0.031250, 0.320312, 0.609375},
   {0.039062, 0.328125, 0.617188},
   {0.046875, 0.339844, 0.621094},
   {0.058594, 0.347656, 0.628906},
   {0.066406, 0.359375, 0.636719},
   {0.074219, 0.367188, 0.640625},
   {0.082031, 0.378906, 0.648438},
   {0.093750, 0.386719, 0.656250},
   {0.101562, 0.398438, 0.660156},
   {0.109375, 0.406250, 0.667969},
   {0.117188, 0.417969, 0.675781},
   {0.128906, 0.425781, 0.679688},
   {0.136719, 0.437500, 0.687500},
   {0.144531, 0.445312, 0.695312},
   {0.152344, 0.453125, 0.699219},
   {0.160156, 0.464844, 0.707031},
   {0.171875, 0.472656, 0.710938},
   {0.179688, 0.484375, 0.718750},
   {0.187500, 0.492188, 0.726562},
   {0.195312, 0.503906, 0.730469},
   {0.207031, 0.511719, 0.738281},
   {0.214844, 0.523438, 0.746094},
   {0.222656, 0.531250, 0.750000},
   {0.230469, 0.542969, 0.757812},
   {0.242188, 0.550781, 0.765625},
   {0.257812, 0.570312, 0.777344},
   {0.265625, 0.574219, 0.781250},
   {0.269531, 0.582031, 0.781250},
   {0.277344, 0.585938, 0.785156},
   {0.281250, 0.593750, 0.785156},
   {0.289062, 0.597656, 0.789062},
   {0.296875, 0.605469, 0.789062},
   {0.300781, 0.609375, 0.792969},
   {0.308594, 0.613281, 0.796875},
   {0.316406, 0.621094, 0.796875},
   {0.320312, 0.625000, 0.800781},
   {0.328125, 0.632812, 0.800781},
   {0.332031, 0.636719, 0.804688},
   {0.339844, 0.644531, 0.808594},
   {0.347656, 0.648438, 0.808594},
   {0.351562, 0.652344, 0.812500},
   {0.359375, 0.660156, 0.812500},
   {0.363281, 0.664062, 0.816406},
   {0.371094, 0.671875, 0.816406},
   {0.378906, 0.675781, 0.820312},
   {0.382812, 0.679688, 0.824219},
   {0.390625, 0.687500, 0.824219},
   {0.398438, 0.691406, 0.828125},
   {0.402344, 0.699219, 0.828125},
   {0.410156, 0.703125, 0.832031},
   {0.414062, 0.710938, 0.832031},
   {0.421875, 0.714844, 0.835938},
   {0.429688, 0.718750, 0.839844},
   {0.441406, 0.726562, 0.839844},
   {0.449219, 0.730469, 0.843750},
   {0.460938, 0.738281, 0.843750},
   {0.468750, 0.742188, 0.847656},
   {0.476562, 0.750000, 0.851562},
   {0.488281, 0.753906, 0.851562},
   {0.496094, 0.757812, 0.855469},
   {0.503906, 0.765625, 0.859375},
   {0.515625, 0.769531, 0.859375},
   {0.523438, 0.777344, 0.863281},
   {0.535156, 0.781250, 0.863281},
   {0.542969, 0.789062, 0.867188},
   {0.550781, 0.792969, 0.871094},
   {0.562500, 0.796875, 0.871094},
   {0.570312, 0.804688, 0.875000},
   {0.582031, 0.808594, 0.875000},
   {0.589844, 0.816406, 0.878906},
   {0.597656, 0.820312, 0.882812},
   {0.609375, 0.824219, 0.882812},
   {0.617188, 0.832031, 0.886719},
   {0.625000, 0.835938, 0.890625},
   {0.636719, 0.843750, 0.890625},
   {0.644531, 0.847656, 0.894531},
   {0.664062, 0.859375, 0.898438},
   {0.671875, 0.863281, 0.902344},
   {0.679688, 0.867188, 0.906250},
   {0.687500, 0.871094, 0.910156},
   {0.695312, 0.875000, 0.914062},
   {0.699219, 0.878906, 0.917969},
   {0.707031, 0.882812, 0.921875},
   {0.714844, 0.886719, 0.925781},
   {0.722656, 0.890625, 0.929688},
   {0.730469, 0.894531, 0.933594},
   {0.738281, 0.898438, 0.937500},
   {0.746094, 0.902344, 0.941406},
   {0.753906, 0.906250, 0.945312},
   {0.761719, 0.910156, 0.949219},
   {0.765625, 0.910156, 0.949219},
   {0.773438, 0.914062, 0.953125},
   {0.781250, 0.917969, 0.957031},
   {0.789062, 0.921875, 0.960938},
   {0.796875, 0.925781, 0.964844},
   {0.804688, 0.929688, 0.968750},
   {0.812500, 0.933594, 0.972656},
   {0.820312, 0.937500, 0.976562},
   {0.824219, 0.941406, 0.980469},
   {0.832031, 0.945312, 0.984375},
   {0.839844, 0.949219, 0.988281},
   {0.855469, 0.957031, 0.996094},
   {0.996094, 0.996094, 0.781250},
   {0.996094, 0.992188, 0.769531},
   {0.996094, 0.988281, 0.753906},
   {0.996094, 0.984375, 0.742188},
   {0.996094, 0.980469, 0.730469},
   {0.996094, 0.976562, 0.718750},
   {0.996094, 0.972656, 0.703125},
   {0.996094, 0.968750, 0.691406},
   {0.996094, 0.964844, 0.679688},
   {0.996094, 0.960938, 0.667969},
   {0.996094, 0.957031, 0.652344},
   {0.996094, 0.953125, 0.640625},
   {0.996094, 0.949219, 0.628906},
   {0.996094, 0.949219, 0.617188},
   {0.996094, 0.945312, 0.601562},
   {0.996094, 0.941406, 0.589844},
   {0.996094, 0.937500, 0.578125},
   {0.996094, 0.933594, 0.562500},
   {0.996094, 0.929688, 0.550781},
   {0.996094, 0.925781, 0.539062},
   {0.996094, 0.921875, 0.527344},
   {0.996094, 0.917969, 0.511719},
   {0.996094, 0.914062, 0.500000},
   {0.996094, 0.910156, 0.488281},
   {0.996094, 0.906250, 0.476562},
   {0.996094, 0.898438, 0.449219},
   {0.996094, 0.894531, 0.441406},
   {0.992188, 0.886719, 0.433594},
   {0.992188, 0.882812, 0.425781},
   {0.988281, 0.878906, 0.421875},
   {0.988281, 0.875000, 0.414062},
   {0.984375, 0.867188, 0.406250},
   {0.984375, 0.863281, 0.398438},
   {0.980469, 0.859375, 0.390625},
   {0.980469, 0.855469, 0.382812},
   {0.976562, 0.847656, 0.378906},
   {0.976562, 0.843750, 0.371094},
   {0.972656, 0.839844, 0.363281},
   {0.972656, 0.835938, 0.355469},
   {0.968750, 0.828125, 0.347656},
   {0.968750, 0.824219, 0.339844},
   {0.964844, 0.820312, 0.332031},
   {0.964844, 0.812500, 0.328125},
   {0.960938, 0.808594, 0.320312},
   {0.960938, 0.804688, 0.312500},
   {0.957031, 0.800781, 0.304688},
   {0.957031, 0.792969, 0.296875},
   {0.953125, 0.789062, 0.289062},
   {0.953125, 0.785156, 0.285156},
   {0.949219, 0.781250, 0.277344},
   {0.945312, 0.769531, 0.261719},
   {0.945312, 0.757812, 0.253906},
   {0.941406, 0.746094, 0.246094},
   {0.941406, 0.734375, 0.242188},
   {0.937500, 0.722656, 0.234375},
   {0.937500, 0.710938, 0.226562},
   {0.933594, 0.699219, 0.218750},
   {0.933594, 0.687500, 0.210938},
   {0.929688, 0.675781, 0.207031},
   {0.929688, 0.664062, 0.199219},
   {0.925781, 0.652344, 0.191406},
   {0.925781, 0.640625, 0.183594},
   {0.921875, 0.628906, 0.175781},
   {0.921875, 0.621094, 0.171875},
   {0.921875, 0.609375, 0.164062},
   {0.917969, 0.597656, 0.156250},
   {0.917969, 0.585938, 0.148438},
   {0.914062, 0.574219, 0.140625},
   {0.914062, 0.562500, 0.132812},
   {0.910156, 0.550781, 0.128906},
   {0.910156, 0.539062, 0.121094},
   {0.906250, 0.527344, 0.113281},
   {0.906250, 0.515625, 0.105469},
   {0.902344, 0.503906, 0.097656},
   {0.902344, 0.492188, 0.093750},
   {0.898438, 0.480469, 0.085938},
   {0.898438, 0.468750, 0.078125},
   {0.894531, 0.460938, 0.074219},
   {0.890625, 0.453125, 0.070312},
   {0.886719, 0.445312, 0.070312},
   {0.878906, 0.437500, 0.066406},
   {0.875000, 0.429688, 0.062500},
   {0.871094, 0.421875, 0.058594},
   {0.867188, 0.417969, 0.058594},
   {0.863281, 0.410156, 0.054688},
   {0.859375, 0.402344, 0.050781},
   {0.851562, 0.394531, 0.046875},
   {0.847656, 0.386719, 0.046875},
   {0.843750, 0.378906, 0.042969},
   {0.839844, 0.371094, 0.039062},
   {0.835938, 0.363281, 0.035156},
   {0.832031, 0.355469, 0.031250},
   {0.828125, 0.347656, 0.031250},
   {0.820312, 0.339844, 0.027344},
   {0.816406, 0.332031, 0.023438},
   {0.812500, 0.324219, 0.019531},
   {0.808594, 0.320312, 0.019531},
   {0.804688, 0.312500, 0.015625},
   {0.800781, 0.304688, 0.011719},
   {0.792969, 0.296875, 0.007812},
   {0.789062, 0.289062, 0.007812},
   {0.781250, 0.273438, 0.000000},
   {0.773438, 0.269531, 0.003906},
   {0.761719, 0.265625, 0.007812},
   {0.753906, 0.261719, 0.011719},
   {0.742188, 0.253906, 0.015625},
   {0.734375, 0.250000, 0.015625},
   {0.722656, 0.246094, 0.019531},
   {0.714844, 0.242188, 0.023438},
   {0.703125, 0.238281, 0.027344},
   {0.695312, 0.234375, 0.031250},
   {0.683594, 0.226562, 0.035156},
   {0.675781, 0.222656, 0.039062},
   {0.664062, 0.218750, 0.042969},
   {0.656250, 0.214844, 0.046875},
   {0.644531, 0.210938, 0.046875},
   {0.636719, 0.207031, 0.050781},
   {0.625000, 0.203125, 0.054688},
   {0.617188, 0.195312, 0.058594},
   {0.605469, 0.191406, 0.062500},
   {0.597656, 0.187500, 0.066406},
   {0.585938, 0.183594, 0.070312},
   {0.578125, 0.179688, 0.074219},
   {0.566406, 0.175781, 0.074219},
   {0.558594, 0.167969, 0.078125},
   {0.546875, 0.164062, 0.082031},
   {0.527344, 0.156250, 0.089844}
};

// https://github.com/1313e/CMasher
const int RGB_Palette_18_Size = 256; // ocean
double RGB_Palette_18[RGB_Palette_18_Size][3] =
{
   {0.11036298, 0.00169078, 0.25302591},
   {0.11229459, 0.00603321, 0.25753772},
   {0.11418039, 0.01060839, 0.26205180},
   {0.11601976, 0.01542029, 0.26656554},
   {0.11781256, 0.02047271, 0.27107617},
   {0.11955872, 0.02576938, 0.27558127},
   {0.12125791, 0.03131406, 0.28007901},
   {0.12291032, 0.03711032, 0.28456726},
   {0.12451564, 0.04306596, 0.28904459},
   {0.12607398, 0.04880321, 0.29350935},
   {0.12758536, 0.05434134, 0.29796010},
   {0.12904948, 0.05971483, 0.30239578},
   {0.13046681, 0.06494994, 0.30681480},
   {0.13183678, 0.07006769, 0.31121644},
   {0.13315975, 0.07508463, 0.31559936},
   {0.13443582, 0.08001428, 0.31996246},
   {0.13566461, 0.08486802, 0.32430500},
   {0.13684632, 0.08965512, 0.32862590},
   {0.13798112, 0.09438344, 0.33292414},
   {0.13906902, 0.09905971, 0.33719884},
   {0.14010980, 0.10368981, 0.34144923},
   {0.14110359, 0.10827871, 0.34567440},
   {0.14205060, 0.11283068, 0.34987342},
   {0.14295089, 0.11734954, 0.35404547},
   {0.14380456, 0.12183862, 0.35818971},
   {0.14461171, 0.12630089, 0.36230534},
   {0.14537250, 0.13073893, 0.36639155},
   {0.14608708, 0.13515508, 0.37044756},
   {0.14675568, 0.13955140, 0.37447257},
   {0.14737854, 0.14392971, 0.37846582},
   {0.14795595, 0.14829167, 0.38242655},
   {0.14848823, 0.15263873, 0.38635403},
   {0.14897577, 0.15697221, 0.39024752},
   {0.14941899, 0.16129329, 0.39410632},
   {0.14981839, 0.16560300, 0.39792975},
   {0.15017448, 0.16990228, 0.40171715},
   {0.15048788, 0.17419196, 0.40546789},
   {0.15075895, 0.17847288, 0.40918140},
   {0.15098858, 0.18274564, 0.41285707},
   {0.15117765, 0.18701078, 0.41649434},
   {0.15132702, 0.19126881, 0.42009270},
   {0.15143729, 0.19552028, 0.42365170},
   {0.15150958, 0.19976554, 0.42717089},
   {0.15154514, 0.20400486, 0.43064985},
   {0.15154485, 0.20823862, 0.43408825},
   {0.15150992, 0.21246704, 0.43748576},
   {0.15144194, 0.21669026, 0.44084210},
   {0.15134177, 0.22090856, 0.44415707},
   {0.15121131, 0.22512197, 0.44743047},
   {0.15105189, 0.22933064, 0.45066217},
   {0.15086511, 0.23353464, 0.45385211},
   {0.15065279, 0.23773398, 0.45700024},
   {0.15041652, 0.24192875, 0.46010658},
   {0.15015834, 0.24611888, 0.46317121},
   {0.14988003, 0.25030442, 0.46619422},
   {0.14958370, 0.25448531, 0.46917580},
   {0.14927143, 0.25866151, 0.47211617},
   {0.14894527, 0.26283299, 0.47501556},
   {0.14860770, 0.26699964, 0.47787431},
   {0.14826061, 0.27116148, 0.48069273},
   {0.14790675, 0.27531836, 0.48347126},
   {0.14754834, 0.27947023, 0.48621032},
   {0.14718783, 0.28361704, 0.48891036},
   {0.14682792, 0.28775866, 0.49157193},
   {0.14647096, 0.29189507, 0.49419555},
   {0.14611965, 0.29602617, 0.49678180},
   {0.14577671, 0.30015187, 0.49933131},
   {0.14544466, 0.30427214, 0.50184468},
   {0.14512624, 0.30838691, 0.50432260},
   {0.14482421, 0.31249611, 0.50676574},
   {0.14454126, 0.31659970, 0.50917482},
   {0.14427999, 0.32069765, 0.51155052},
   {0.14404324, 0.32478990, 0.51389361},
   {0.14383368, 0.32887643, 0.51620483},
   {0.14365391, 0.33295724, 0.51848492},
   {0.14350657, 0.33703232, 0.52073465},
   {0.14339432, 0.34110164, 0.52295479},
   {0.14331970, 0.34516522, 0.52514612},
   {0.14328515, 0.34922308, 0.52730938},
   {0.14329311, 0.35327524, 0.52944536},
   {0.14334599, 0.35732173, 0.53155482},
   {0.14344605, 0.36136258, 0.53363854},
   {0.14359550, 0.36539784, 0.53569725},
   {0.14379638, 0.36942758, 0.53773169},
   {0.14405074, 0.37345185, 0.53974261},
   {0.14436051, 0.37747071, 0.54173074},
   {0.14472745, 0.38148424, 0.54369680},
   {0.14515323, 0.38549252, 0.54564147},
   {0.14563938, 0.38949565, 0.54756543},
   {0.14618737, 0.39349370, 0.54946937},
   {0.14679849, 0.39748677, 0.55135394},
   {0.14747394, 0.40147496, 0.55321979},
   {0.14821476, 0.40545839, 0.55506753},
   {0.14902183, 0.40943715, 0.55689775},
   {0.14989598, 0.41341137, 0.55871106},
   {0.15083789, 0.41738115, 0.56050803},
   {0.15184810, 0.42134661, 0.56228920},
   {0.15292704, 0.42530787, 0.56405511},
   {0.15407502, 0.42926506, 0.56580628},
   {0.15529223, 0.43321829, 0.56754318},
   {0.15657875, 0.43716769, 0.56926630},
   {0.15793461, 0.44111338, 0.57097610},
   {0.15935970, 0.44505549, 0.57267302},
   {0.16085384, 0.44899414, 0.57435748},
   {0.16241677, 0.45292945, 0.57602988},
   {0.16404815, 0.45686154, 0.57769062},
   {0.16574758, 0.46079053, 0.57934004},
   {0.16751459, 0.46471656, 0.58097850},
   {0.16934866, 0.46863973, 0.58260632},
   {0.17124925, 0.47256015, 0.58422382},
   {0.17321580, 0.47647795, 0.58583130},
   {0.17524768, 0.48039322, 0.58742905},
   {0.17734425, 0.48430608, 0.58901731},
   {0.17950488, 0.48821663, 0.59059635},
   {0.18172891, 0.49212496, 0.59216639},
   {0.18401567, 0.49603117, 0.59372765},
   {0.18636453, 0.49993535, 0.59528034},
   {0.18877485, 0.50383759, 0.59682463},
   {0.19124600, 0.50773796, 0.59836071},
   {0.19377738, 0.51163653, 0.59988874},
   {0.19636843, 0.51553338, 0.60140886},
   {0.19901859, 0.51942856, 0.60292121},
   {0.20172736, 0.52332213, 0.60442591},
   {0.20449428, 0.52721414, 0.60592309},
   {0.20731892, 0.53110462, 0.60741283},
   {0.21020090, 0.53499361, 0.60889524},
   {0.21313989, 0.53888113, 0.61037040},
   {0.21613558, 0.54276720, 0.61183834},
   {0.21918777, 0.54665182, 0.61329914},
   {0.22229631, 0.55053498, 0.61475288},
   {0.22546108, 0.55441667, 0.61619963},
   {0.22868205, 0.55829685, 0.61763942},
   {0.23195924, 0.56217550, 0.61907231},
   {0.23529267, 0.56605258, 0.62049821},
   {0.23868256, 0.56992800, 0.62191727},
   {0.24212914, 0.57380170, 0.62332955},
   {0.24563267, 0.57767357, 0.62473500},
   {0.24919352, 0.58154354, 0.62613362},
   {0.25281216, 0.58541146, 0.62752556},
   {0.25648909, 0.58927720, 0.62891076},
   {0.26022491, 0.59314062, 0.63028927},
   {0.26402031, 0.59700151, 0.63166124},
   {0.26787604, 0.60085972, 0.63302651},
   {0.27179297, 0.60471500, 0.63438542},
   {0.27577199, 0.60856714, 0.63573775},
   {0.27981416, 0.61241587, 0.63708388},
   {0.28392056, 0.61626091, 0.63842373},
   {0.28809239, 0.62010194, 0.63975752},
   {0.29233093, 0.62393864, 0.64108550},
   {0.29663759, 0.62777064, 0.64240764},
   {0.30101382, 0.63159754, 0.64372434},
   {0.30546117, 0.63541892, 0.64503589},
   {0.30998130, 0.63923432, 0.64634259},
   {0.31457598, 0.64304323, 0.64764481},
   {0.31924707, 0.64684514, 0.64894289},
   {0.32399647, 0.65063947, 0.65023744},
   {0.32882620, 0.65442561, 0.65152904},
   {0.33373835, 0.65820289, 0.65281838},
   {0.33873515, 0.66197064, 0.65410616},
   {0.34381881, 0.66572811, 0.65539330},
   {0.34899160, 0.66947452, 0.65668086},
   {0.35425586, 0.67320902, 0.65797005},
   {0.35961394, 0.67693076, 0.65926212},
   {0.36506831, 0.68063881, 0.66055847},
   {0.37062112, 0.68433222, 0.66186104},
   {0.37627487, 0.68800998, 0.66317142},
   {0.38203149, 0.69167107, 0.66449210},
   {0.38789330, 0.69531443, 0.66582512},
   {0.39386193, 0.69893900, 0.66717343},
   {0.39993898, 0.70254369, 0.66853995},
   {0.40612583, 0.70612744, 0.66992783},
   {0.41242330, 0.70968920, 0.67134073},
   {0.41883173, 0.71322799, 0.67278257},
   {0.42535095, 0.71674289, 0.67425759},
   {0.43198011, 0.72023305, 0.67577030},
   {0.43871767, 0.72369779, 0.67732549},
   {0.44556123, 0.72713656, 0.67892818},
   {0.45250758, 0.73054898, 0.68058357},
   {0.45955261, 0.73393492, 0.68229694},
   {0.46669130, 0.73729444, 0.68407356},
   {0.47391772, 0.74062788, 0.68591867},
   {0.48122519, 0.74393585, 0.68783723},
   {0.48860630, 0.74721920, 0.68983393},
   {0.49605306, 0.75047904, 0.69191302},
   {0.50355706, 0.75371673, 0.69407825},
   {0.51110961, 0.75693384, 0.69633279},
   {0.51870199, 0.76013211, 0.69867915},
   {0.52632555, 0.76331345, 0.70111918},
   {0.53397196, 0.76647982, 0.70365405},
   {0.54163332, 0.76963326, 0.70628425},
   {0.54930234, 0.77277581, 0.70900965},
   {0.55697237, 0.77590947, 0.71182953},
   {0.56463671, 0.77903637, 0.71474289},
   {0.57229081, 0.78215824, 0.71774790},
   {0.57992912, 0.78527710, 0.72084282},
   {0.58754828, 0.78839452, 0.72402527},
   {0.59514475, 0.79151213, 0.72729283},
   {0.60271552, 0.79463151, 0.73064297},
   {0.61025836, 0.79775402, 0.73407296},
   {0.61777160, 0.80088094, 0.73758006},
   {0.62525367, 0.80401348, 0.74116153},
   {0.63270387, 0.80715267, 0.74481460},
   {0.64012176, 0.81029943, 0.74853655},
   {0.64750659, 0.81345476, 0.75232480},
   {0.65485840, 0.81661944, 0.75617675},
   {0.66217728, 0.81979422, 0.76008994},
   {0.66946389, 0.82297967, 0.76406197},
   {0.67671761, 0.82617671, 0.76809057},
   {0.68393980, 0.82938567, 0.77217354},
   {0.69113094, 0.83260710, 0.77630879},
   {0.69829165, 0.83584151, 0.78049432},
   {0.70542264, 0.83908936, 0.78472824},
   {0.71252470, 0.84235106, 0.78900873},
   {0.71959870, 0.84562698, 0.79333408},
   {0.72664555, 0.84891744, 0.79770266},
   {0.73366565, 0.85222293, 0.80211288},
   {0.74066008, 0.85554371, 0.80656326},
   {0.74763018, 0.85887990, 0.81105246},
   {0.75457589, 0.86223209, 0.81557902},
   {0.76149887, 0.86560029, 0.82014175},
   {0.76839930, 0.86898498, 0.82473936},
   {0.77527874, 0.87238615, 0.82937078},
   {0.78213686, 0.87580444, 0.83403472},
   {0.78897545, 0.87923974, 0.83873025},
   {0.79579511, 0.88269234, 0.84345633},
   {0.80259581, 0.88616273, 0.84821182},
   {0.80937888, 0.88965094, 0.85299585},
   {0.81614498, 0.89315719, 0.85780751},
   {0.82289470, 0.89668175, 0.86264586},
   {0.82962861, 0.90022485, 0.86751000},
   {0.83634729, 0.90378676, 0.87239906},
   {0.84305129, 0.90736771, 0.87731217},
   {0.84974113, 0.91096796, 0.88224848},
   {0.85641734, 0.91458776, 0.88720714},
   {0.86308039, 0.91822735, 0.89218732},
   {0.86973073, 0.92188701, 0.89718817},
   {0.87636879, 0.92556701, 0.90220883},
   {0.88299495, 0.92926763, 0.90724844},
   {0.88960897, 0.93298940, 0.91230596},
   {0.89621156, 0.93673248, 0.91738058},
   {0.90280302, 0.94049718, 0.92247137},
   {0.90938335, 0.94428393, 0.92757732},
   {0.91595203, 0.94809341, 0.93269721},
   {0.92250973, 0.95192575, 0.93783015},
   {0.92905588, 0.95578166, 0.94297488},
   {0.93558995, 0.95966178, 0.94813012},
   {0.94211204, 0.96356654, 0.95329477},
   {0.94862035, 0.96749711, 0.95846718},
   {0.95511504, 0.97145390, 0.96364632},
   {0.96159359, 0.97543838, 0.96883050},
   {0.96805534, 0.97945125, 0.97401875},
   {0.97449688, 0.98349435, 0.97920966},
   {0.98091630, 0.98756881, 0.98440279},
   {0.98730941, 0.99167667, 0.98959791},
   {0.99367218, 0.99581976, 0.99479608},
   {1.00000000, 1.00000000, 1.00000000}
};

const int RGB_Palette_19_Size = 256; // gimp - PastelRainbow
double RGB_Palette_19[RGB_Palette_19_Size][3] =
{
   { 0.99609375, 0.74609375, 0.74609375 },
   { 0.99609375, 0.75000000, 0.74609375 },
   { 0.99609375, 0.75781250, 0.74609375 },
   { 0.99609375, 0.76171875, 0.74609375 },
   { 0.99609375, 0.76953125, 0.74609375 },
   { 0.99609375, 0.77343750, 0.74609375 },
   { 0.99609375, 0.78125000, 0.74609375 },
   { 0.99609375, 0.78515625, 0.74609375 },
   { 0.99609375, 0.79296875, 0.74609375 },
   { 0.99609375, 0.79687500, 0.74609375 },
   { 0.99609375, 0.80468750, 0.74609375 },
   { 0.99609375, 0.80859375, 0.74609375 },
   { 0.99609375, 0.81640625, 0.74609375 },
   { 0.99609375, 0.82031250, 0.74609375 },
   { 0.99609375, 0.82812500, 0.74609375 },
   { 0.99609375, 0.83203125, 0.74609375 },
   { 0.99609375, 0.83984375, 0.74609375 },
   { 0.99609375, 0.84375000, 0.74609375 },
   { 0.99609375, 0.85156250, 0.74609375 },
   { 0.99609375, 0.85546875, 0.74609375 },
   { 0.99609375, 0.86328125, 0.74609375 },
   { 0.99609375, 0.86718750, 0.74609375 },
   { 0.99609375, 0.87500000, 0.74609375 },
   { 0.99609375, 0.87890625, 0.74609375 },
   { 0.99609375, 0.88671875, 0.74609375 },
   { 0.99609375, 0.89062500, 0.74609375 },
   { 0.99609375, 0.89843750, 0.74609375 },
   { 0.99609375, 0.90234375, 0.74609375 },
   { 0.99609375, 0.91015625, 0.74609375 },
   { 0.99609375, 0.91406250, 0.74609375 },
   { 0.99609375, 0.92187500, 0.74609375 },
   { 0.99609375, 0.92578125, 0.74609375 },
   { 0.99609375, 0.93359375, 0.74609375 },
   { 0.99609375, 0.93750000, 0.74609375 },
   { 0.99609375, 0.94531250, 0.74609375 },
   { 0.99609375, 0.94921875, 0.74609375 },
   { 0.99609375, 0.95703125, 0.74609375 },
   { 0.99609375, 0.96093750, 0.74609375 },
   { 0.99609375, 0.96875000, 0.74609375 },
   { 0.99609375, 0.97265625, 0.74609375 },
   { 0.99609375, 0.98046875, 0.74609375 },
   { 0.99609375, 0.98437500, 0.74609375 },
   { 0.99609375, 0.99218750, 0.74609375 },
   { 0.99218750, 0.99609375, 0.74609375 },
   { 0.98437500, 0.99609375, 0.74609375 },
   { 0.98046875, 0.99609375, 0.74609375 },
   { 0.97265625, 0.99609375, 0.74609375 },
   { 0.96875000, 0.99609375, 0.74609375 },
   { 0.96093750, 0.99609375, 0.74609375 },
   { 0.95703125, 0.99609375, 0.74609375 },
   { 0.94921875, 0.99609375, 0.74609375 },
   { 0.94531250, 0.99609375, 0.74609375 },
   { 0.93750000, 0.99609375, 0.74609375 },
   { 0.93359375, 0.99609375, 0.74609375 },
   { 0.92578125, 0.99609375, 0.74609375 },
   { 0.92187500, 0.99609375, 0.74609375 },
   { 0.91406250, 0.99609375, 0.74609375 },
   { 0.91015625, 0.99609375, 0.74609375 },
   { 0.90234375, 0.99609375, 0.74609375 },
   { 0.89843750, 0.99609375, 0.74609375 },
   { 0.89062500, 0.99609375, 0.74609375 },
   { 0.88671875, 0.99609375, 0.74609375 },
   { 0.87890625, 0.99609375, 0.74609375 },
   { 0.87500000, 0.99609375, 0.74609375 },
   { 0.86718750, 0.99609375, 0.74609375 },
   { 0.86328125, 0.99609375, 0.74609375 },
   { 0.85546875, 0.99609375, 0.74609375 },
   { 0.85156250, 0.99609375, 0.74609375 },
   { 0.84375000, 0.99609375, 0.74609375 },
   { 0.83984375, 0.99609375, 0.74609375 },
   { 0.83203125, 0.99609375, 0.74609375 },
   { 0.82812500, 0.99609375, 0.74609375 },
   { 0.82031250, 0.99609375, 0.74609375 },
   { 0.81640625, 0.99609375, 0.74609375 },
   { 0.80859375, 0.99609375, 0.74609375 },
   { 0.80468750, 0.99609375, 0.74609375 },
   { 0.79687500, 0.99609375, 0.74609375 },
   { 0.79296875, 0.99609375, 0.74609375 },
   { 0.78515625, 0.99609375, 0.74609375 },
   { 0.78125000, 0.99609375, 0.74609375 },
   { 0.77343750, 0.99609375, 0.74609375 },
   { 0.76953125, 0.99609375, 0.74609375 },
   { 0.76171875, 0.99609375, 0.74609375 },
   { 0.75781250, 0.99609375, 0.74609375 },
   { 0.75000000, 0.99609375, 0.74609375 },
   { 0.74609375, 0.99609375, 0.74609375 },
   { 0.74609375, 0.99609375, 0.75000000 },
   { 0.74609375, 0.99609375, 0.75781250 },
   { 0.74609375, 0.99609375, 0.76171875 },
   { 0.74609375, 0.99609375, 0.76953125 },
   { 0.74609375, 0.99609375, 0.77343750 },
   { 0.74609375, 0.99609375, 0.78125000 },
   { 0.74609375, 0.99609375, 0.78515625 },
   { 0.74609375, 0.99609375, 0.79296875 },
   { 0.74609375, 0.99609375, 0.79687500 },
   { 0.74609375, 0.99609375, 0.80468750 },
   { 0.74609375, 0.99609375, 0.80859375 },
   { 0.74609375, 0.99609375, 0.81640625 },
   { 0.74609375, 0.99609375, 0.82031250 },
   { 0.74609375, 0.99609375, 0.82812500 },
   { 0.74609375, 0.99609375, 0.83203125 },
   { 0.74609375, 0.99609375, 0.83984375 },
   { 0.74609375, 0.99609375, 0.84375000 },
   { 0.74609375, 0.99609375, 0.85156250 },
   { 0.74609375, 0.99609375, 0.85546875 },
   { 0.74609375, 0.99609375, 0.86328125 },
   { 0.74609375, 0.99609375, 0.86718750 },
   { 0.74609375, 0.99609375, 0.87500000 },
   { 0.74609375, 0.99609375, 0.87890625 },
   { 0.74609375, 0.99609375, 0.88671875 },
   { 0.74609375, 0.99609375, 0.89062500 },
   { 0.74609375, 0.99609375, 0.89843750 },
   { 0.74609375, 0.99609375, 0.90234375 },
   { 0.74609375, 0.99609375, 0.91015625 },
   { 0.74609375, 0.99609375, 0.91406250 },
   { 0.74609375, 0.99609375, 0.92187500 },
   { 0.74609375, 0.99609375, 0.92578125 },
   { 0.74609375, 0.99609375, 0.93359375 },
   { 0.74609375, 0.99609375, 0.93750000 },
   { 0.74609375, 0.99609375, 0.94531250 },
   { 0.74609375, 0.99609375, 0.94921875 },
   { 0.74609375, 0.99609375, 0.95703125 },
   { 0.74609375, 0.99609375, 0.96093750 },
   { 0.74609375, 0.99609375, 0.96875000 },
   { 0.74609375, 0.99609375, 0.97265625 },
   { 0.74609375, 0.99609375, 0.98046875 },
   { 0.74609375, 0.99609375, 0.98437500 },
   { 0.74609375, 0.99609375, 0.99218750 },
   { 0.74609375, 0.99218750, 0.99609375 },
   { 0.74609375, 0.98437500, 0.99609375 },
   { 0.74609375, 0.98046875, 0.99609375 },
   { 0.74609375, 0.97265625, 0.99609375 },
   { 0.74609375, 0.96875000, 0.99609375 },
   { 0.74609375, 0.96093750, 0.99609375 },
   { 0.74609375, 0.95703125, 0.99609375 },
   { 0.74609375, 0.94921875, 0.99609375 },
   { 0.74609375, 0.94531250, 0.99609375 },
   { 0.74609375, 0.93750000, 0.99609375 },
   { 0.74609375, 0.93359375, 0.99609375 },
   { 0.74609375, 0.92578125, 0.99609375 },
   { 0.74609375, 0.92187500, 0.99609375 },
   { 0.74609375, 0.91406250, 0.99609375 },
   { 0.74609375, 0.91015625, 0.99609375 },
   { 0.74609375, 0.90234375, 0.99609375 },
   { 0.74609375, 0.89843750, 0.99609375 },
   { 0.74609375, 0.89062500, 0.99609375 },
   { 0.74609375, 0.88671875, 0.99609375 },
   { 0.74609375, 0.87890625, 0.99609375 },
   { 0.74609375, 0.87500000, 0.99609375 },
   { 0.74609375, 0.86718750, 0.99609375 },
   { 0.74609375, 0.86328125, 0.99609375 },
   { 0.74609375, 0.85546875, 0.99609375 },
   { 0.74609375, 0.85156250, 0.99609375 },
   { 0.74609375, 0.84375000, 0.99609375 },
   { 0.74609375, 0.83984375, 0.99609375 },
   { 0.74609375, 0.83203125, 0.99609375 },
   { 0.74609375, 0.82812500, 0.99609375 },
   { 0.74609375, 0.82031250, 0.99609375 },
   { 0.74609375, 0.81640625, 0.99609375 },
   { 0.74609375, 0.80859375, 0.99609375 },
   { 0.74609375, 0.80468750, 0.99609375 },
   { 0.74609375, 0.79687500, 0.99609375 },
   { 0.74609375, 0.79296875, 0.99609375 },
   { 0.74609375, 0.78515625, 0.99609375 },
   { 0.74609375, 0.78125000, 0.99609375 },
   { 0.74609375, 0.77343750, 0.99609375 },
   { 0.74609375, 0.76953125, 0.99609375 },
   { 0.74609375, 0.76171875, 0.99609375 },
   { 0.74609375, 0.75781250, 0.99609375 },
   { 0.74609375, 0.75000000, 0.99609375 },
   { 0.74609375, 0.74609375, 0.99609375 },
   { 0.75000000, 0.74609375, 0.99609375 },
   { 0.75781250, 0.74609375, 0.99609375 },
   { 0.76171875, 0.74609375, 0.99609375 },
   { 0.76953125, 0.74609375, 0.99609375 },
   { 0.77343750, 0.74609375, 0.99609375 },
   { 0.78125000, 0.74609375, 0.99609375 },
   { 0.78515625, 0.74609375, 0.99609375 },
   { 0.79296875, 0.74609375, 0.99609375 },
   { 0.79687500, 0.74609375, 0.99609375 },
   { 0.80468750, 0.74609375, 0.99609375 },
   { 0.80859375, 0.74609375, 0.99609375 },
   { 0.81640625, 0.74609375, 0.99609375 },
   { 0.82031250, 0.74609375, 0.99609375 },
   { 0.82812500, 0.74609375, 0.99609375 },
   { 0.83203125, 0.74609375, 0.99609375 },
   { 0.83984375, 0.74609375, 0.99609375 },
   { 0.84375000, 0.74609375, 0.99609375 },
   { 0.85156250, 0.74609375, 0.99609375 },
   { 0.85546875, 0.74609375, 0.99609375 },
   { 0.86328125, 0.74609375, 0.99609375 },
   { 0.86718750, 0.74609375, 0.99609375 },
   { 0.87500000, 0.74609375, 0.99609375 },
   { 0.87890625, 0.74609375, 0.99609375 },
   { 0.88671875, 0.74609375, 0.99609375 },
   { 0.89062500, 0.74609375, 0.99609375 },
   { 0.89843750, 0.74609375, 0.99609375 },
   { 0.90234375, 0.74609375, 0.99609375 },
   { 0.91015625, 0.74609375, 0.99609375 },
   { 0.91406250, 0.74609375, 0.99609375 },
   { 0.92187500, 0.74609375, 0.99609375 },
   { 0.92578125, 0.74609375, 0.99609375 },
   { 0.93359375, 0.74609375, 0.99609375 },
   { 0.93750000, 0.74609375, 0.99609375 },
   { 0.94531250, 0.74609375, 0.99609375 },
   { 0.94921875, 0.74609375, 0.99609375 },
   { 0.95703125, 0.74609375, 0.99609375 },
   { 0.96093750, 0.74609375, 0.99609375 },
   { 0.96875000, 0.74609375, 0.99609375 },
   { 0.97265625, 0.74609375, 0.99609375 },
   { 0.98046875, 0.74609375, 0.99609375 },
   { 0.98437500, 0.74609375, 0.99609375 },
   { 0.99218750, 0.74609375, 0.99609375 },
   { 0.99609375, 0.74609375, 0.99218750 },
   { 0.99609375, 0.74609375, 0.98437500 },
   { 0.99609375, 0.74609375, 0.98046875 },
   { 0.99609375, 0.74609375, 0.97265625 },
   { 0.99609375, 0.74609375, 0.96875000 },
   { 0.99609375, 0.74609375, 0.96093750 },
   { 0.99609375, 0.74609375, 0.95703125 },
   { 0.99609375, 0.74609375, 0.94921875 },
   { 0.99609375, 0.74609375, 0.94531250 },
   { 0.99609375, 0.74609375, 0.93750000 },
   { 0.99609375, 0.74609375, 0.93359375 },
   { 0.99609375, 0.74609375, 0.92578125 },
   { 0.99609375, 0.74609375, 0.92187500 },
   { 0.99609375, 0.74609375, 0.91406250 },
   { 0.99609375, 0.74609375, 0.91015625 },
   { 0.99609375, 0.74609375, 0.90234375 },
   { 0.99609375, 0.74609375, 0.89843750 },
   { 0.99609375, 0.74609375, 0.89062500 },
   { 0.99609375, 0.74609375, 0.88671875 },
   { 0.99609375, 0.74609375, 0.87890625 },
   { 0.99609375, 0.74609375, 0.87500000 },
   { 0.99609375, 0.74609375, 0.86718750 },
   { 0.99609375, 0.74609375, 0.86328125 },
   { 0.99609375, 0.74609375, 0.85546875 },
   { 0.99609375, 0.74609375, 0.85156250 },
   { 0.99609375, 0.74609375, 0.84375000 },
   { 0.99609375, 0.74609375, 0.83984375 },
   { 0.99609375, 0.74609375, 0.83203125 },
   { 0.99609375, 0.74609375, 0.82812500 },
   { 0.99609375, 0.74609375, 0.82031250 },
   { 0.99609375, 0.74609375, 0.81640625 },
   { 0.99609375, 0.74609375, 0.80859375 },
   { 0.99609375, 0.74609375, 0.80468750 },
   { 0.99609375, 0.74609375, 0.79687500 },
   { 0.99609375, 0.74609375, 0.79296875 },
   { 0.99609375, 0.74609375, 0.78515625 },
   { 0.99609375, 0.74609375, 0.78125000 },
   { 0.99609375, 0.74609375, 0.77343750 },
   { 0.99609375, 0.74609375, 0.76953125 },
   { 0.99609375, 0.74609375, 0.76171875 },
   { 0.99609375, 0.74609375, 0.75781250 },
   { 0.99609375, 0.74609375, 0.75000000 },
   { 0.99609375, 0.74609375, 0.74609375 },
};

const int RGB_Palette_20_Size = 256; // gimp - TropicalColors
double RGB_Palette_20[RGB_Palette_20_Size][3] =
{
   { 0.03515625, 0.15625000, 0.01171875 },
   { 0.03515625, 0.16015625, 0.01171875 },
   { 0.03125000, 0.16796875, 0.01171875 },
   { 0.03125000, 0.17187500, 0.01171875 },
   { 0.03125000, 0.17968750, 0.01171875 },
   { 0.03125000, 0.18359375, 0.01171875 },
   { 0.02734375, 0.18750000, 0.01171875 },
   { 0.02734375, 0.19531250, 0.00781250 },
   { 0.02734375, 0.19921875, 0.00781250 },
   { 0.02734375, 0.20312500, 0.00781250 },
   { 0.02343750, 0.21093750, 0.00781250 },
   { 0.02343750, 0.21484375, 0.00781250 },
   { 0.02343750, 0.21875000, 0.00781250 },
   { 0.01953125, 0.22656250, 0.00781250 },
   { 0.01953125, 0.23046875, 0.00390625 },
   { 0.01953125, 0.24218750, 0.00390625 },
   { 0.01562500, 0.25000000, 0.00390625 },
   { 0.01562500, 0.26171875, 0.00390625 },
   { 0.01171875, 0.26953125, 0.00000000 },
   { 0.01171875, 0.28125000, 0.00000000 },
   { 0.00781250, 0.28906250, 0.00000000 },
   { 0.00781250, 0.30078125, 0.00000000 },
   { 0.00781250, 0.30859375, 0.00000000 },
   { 0.01562500, 0.32031250, 0.00390625 },
   { 0.02343750, 0.32812500, 0.00390625 },
   { 0.02734375, 0.33984375, 0.00781250 },
   { 0.03515625, 0.34765625, 0.01171875 },
   { 0.04296875, 0.35937500, 0.01562500 },
   { 0.05078125, 0.36718750, 0.01953125 },
   { 0.05468750, 0.37890625, 0.01953125 },
   { 0.06250000, 0.38671875, 0.02343750 },
   { 0.07031250, 0.39843750, 0.02734375 },
   { 0.07812500, 0.40625000, 0.03125000 },
   { 0.08203125, 0.41796875, 0.03515625 },
   { 0.08984375, 0.42578125, 0.03515625 },
   { 0.09765625, 0.43750000, 0.03906250 },
   { 0.10546875, 0.44531250, 0.04296875 },
   { 0.10937500, 0.45703125, 0.04687500 },
   { 0.11718750, 0.46484375, 0.04687500 },
   { 0.12500000, 0.47265625, 0.05078125 },
   { 0.12890625, 0.48437500, 0.05468750 },
   { 0.13671875, 0.49218750, 0.05859375 },
   { 0.14453125, 0.50390625, 0.06250000 },
   { 0.15234375, 0.51171875, 0.06250000 },
   { 0.15625000, 0.51953125, 0.06640625 },
   { 0.16406250, 0.53125000, 0.07031250 },
   { 0.17187500, 0.53906250, 0.07421875 },
   { 0.17578125, 0.55078125, 0.07421875 },
   { 0.18359375, 0.55859375, 0.07812500 },
   { 0.19140625, 0.56640625, 0.08203125 },
   { 0.21484375, 0.57812500, 0.08593750 },
   { 0.25000000, 0.58593750, 0.08984375 },
   { 0.28515625, 0.59375000, 0.09765625 },
   { 0.32031250, 0.60156250, 0.10156250 },
   { 0.35546875, 0.60937500, 0.10546875 },
   { 0.39453125, 0.62109375, 0.11328125 },
   { 0.42968750, 0.62890625, 0.11718750 },
   { 0.46484375, 0.63671875, 0.12109375 },
   { 0.50000000, 0.64453125, 0.12890625 },
   { 0.53515625, 0.65234375, 0.13281250 },
   { 0.57031250, 0.66015625, 0.13671875 },
   { 0.60156250, 0.66796875, 0.14453125 },
   { 0.63671875, 0.67968750, 0.14843750 },
   { 0.66796875, 0.68750000, 0.15234375 },
   { 0.70312500, 0.69531250, 0.15625000 },
   { 0.73437500, 0.70312500, 0.16406250 },
   { 0.76953125, 0.71093750, 0.16796875 },
   { 0.80078125, 0.71875000, 0.17187500 },
   { 0.83593750, 0.72656250, 0.17578125 },
   { 0.86718750, 0.73437500, 0.18359375 },
   { 0.90234375, 0.74218750, 0.18750000 },
   { 0.91796875, 0.73828125, 0.18750000 },
   { 0.92187500, 0.71875000, 0.18750000 },
   { 0.92187500, 0.70312500, 0.18359375 },
   { 0.92187500, 0.68359375, 0.18359375 },
   { 0.92187500, 0.66406250, 0.17968750 },
   { 0.92578125, 0.64843750, 0.17968750 },
   { 0.92578125, 0.62890625, 0.17578125 },
   { 0.92578125, 0.61328125, 0.17578125 },
   { 0.92578125, 0.59375000, 0.17187500 },
   { 0.92968750, 0.57421875, 0.16796875 },
   { 0.92968750, 0.55859375, 0.16796875 },
   { 0.92968750, 0.53906250, 0.16406250 },
   { 0.93359375, 0.52343750, 0.16406250 },
   { 0.93359375, 0.50390625, 0.16015625 },
   { 0.93359375, 0.48437500, 0.16015625 },
   { 0.93359375, 0.46875000, 0.15625000 },
   { 0.93750000, 0.44921875, 0.15625000 },
   { 0.93750000, 0.43359375, 0.15234375 },
   { 0.93750000, 0.41406250, 0.15234375 },
   { 0.93750000, 0.39453125, 0.14843750 },
   { 0.94140625, 0.37890625, 0.14453125 },
   { 0.94140625, 0.35937500, 0.14453125 },
   { 0.94140625, 0.34375000, 0.14062500 },
   { 0.94531250, 0.32421875, 0.14062500 },
   { 0.94531250, 0.30468750, 0.13671875 },
   { 0.94531250, 0.28906250, 0.13671875 },
   { 0.94531250, 0.26953125, 0.13281250 },
   { 0.94921875, 0.25390625, 0.13281250 },
   { 0.94921875, 0.23828125, 0.12890625 },
   { 0.94140625, 0.23828125, 0.13281250 },
   { 0.93359375, 0.23828125, 0.13281250 },
   { 0.92578125, 0.24218750, 0.13671875 },
   { 0.92187500, 0.24218750, 0.13671875 },
   { 0.91406250, 0.24218750, 0.13671875 },
   { 0.90625000, 0.24609375, 0.14062500 },
   { 0.90234375, 0.24609375, 0.14062500 },
   { 0.89453125, 0.24609375, 0.14453125 },
   { 0.88671875, 0.25000000, 0.14453125 },
   { 0.87890625, 0.25000000, 0.14453125 },
   { 0.87500000, 0.25000000, 0.14843750 },
   { 0.86718750, 0.25390625, 0.14843750 },
   { 0.85937500, 0.25390625, 0.15234375 },
   { 0.85546875, 0.25390625, 0.15234375 },
   { 0.84765625, 0.25781250, 0.15625000 },
   { 0.83984375, 0.25781250, 0.15625000 },
   { 0.83203125, 0.25781250, 0.15625000 },
   { 0.82812500, 0.26171875, 0.16015625 },
   { 0.82031250, 0.26171875, 0.16015625 },
   { 0.81250000, 0.26171875, 0.16406250 },
   { 0.80859375, 0.26171875, 0.16406250 },
   { 0.80078125, 0.26562500, 0.16796875 },
   { 0.79296875, 0.26562500, 0.16796875 },
   { 0.78515625, 0.26562500, 0.16796875 },
   { 0.78125000, 0.26953125, 0.17187500 },
   { 0.77343750, 0.26953125, 0.17187500 },
   { 0.76562500, 0.26953125, 0.17578125 },
   { 0.75781250, 0.27343750, 0.17578125 },
   { 0.75390625, 0.27343750, 0.17578125 },
   { 0.74609375, 0.27343750, 0.17968750 },
   { 0.73828125, 0.27734375, 0.17968750 },
   { 0.72265625, 0.27734375, 0.18359375 },
   { 0.70703125, 0.28125000, 0.18750000 },
   { 0.68750000, 0.28515625, 0.19531250 },
   { 0.66796875, 0.28906250, 0.19921875 },
   { 0.64843750, 0.29296875, 0.20312500 },
   { 0.63281250, 0.29687500, 0.20703125 },
   { 0.61328125, 0.30078125, 0.21093750 },
   { 0.59375000, 0.30468750, 0.21484375 },
   { 0.57421875, 0.30859375, 0.22265625 },
   { 0.55859375, 0.30859375, 0.22656250 },
   { 0.53906250, 0.31250000, 0.23046875 },
   { 0.52734375, 0.31640625, 0.24218750 },
   { 0.52343750, 0.31640625, 0.26953125 },
   { 0.52343750, 0.31250000, 0.29687500 },
   { 0.51953125, 0.31250000, 0.32421875 },
   { 0.51562500, 0.31250000, 0.34765625 },
   { 0.51562500, 0.31250000, 0.37500000 },
   { 0.51171875, 0.31250000, 0.40234375 },
   { 0.51171875, 0.30859375, 0.42968750 },
   { 0.50781250, 0.30859375, 0.45703125 },
   { 0.50781250, 0.30859375, 0.48437500 },
   { 0.50390625, 0.30859375, 0.51171875 },
   { 0.50390625, 0.30859375, 0.53906250 },
   { 0.50000000, 0.30468750, 0.56250000 },
   { 0.50000000, 0.30468750, 0.58984375 },
   { 0.49609375, 0.30468750, 0.61718750 },
   { 0.49609375, 0.30468750, 0.64453125 },
   { 0.49218750, 0.30078125, 0.67187500 },
   { 0.49218750, 0.30078125, 0.69921875 },
   { 0.48828125, 0.30078125, 0.72656250 },
   { 0.48828125, 0.30078125, 0.75390625 },
   { 0.48437500, 0.30078125, 0.77734375 },
   { 0.48437500, 0.29687500, 0.80468750 },
   { 0.48046875, 0.29687500, 0.83203125 },
   { 0.48046875, 0.29687500, 0.85937500 },
   { 0.47656250, 0.29687500, 0.88671875 },
   { 0.47656250, 0.29687500, 0.91406250 },
   { 0.47265625, 0.29296875, 0.94140625 },
   { 0.47265625, 0.29296875, 0.96875000 },
   { 0.46875000, 0.29296875, 0.99218750 },
   { 0.47265625, 0.30468750, 0.99218750 },
   { 0.47656250, 0.32031250, 0.99218750 },
   { 0.47656250, 0.33203125, 0.99218750 },
   { 0.48046875, 0.34375000, 0.99218750 },
   { 0.48437500, 0.35546875, 0.99218750 },
   { 0.48828125, 0.37109375, 0.98828125 },
   { 0.49218750, 0.38281250, 0.98828125 },
   { 0.49218750, 0.39453125, 0.98828125 },
   { 0.49609375, 0.41015625, 0.98828125 },
   { 0.50000000, 0.42187500, 0.98828125 },
   { 0.50390625, 0.43359375, 0.98437500 },
   { 0.50781250, 0.44921875, 0.98437500 },
   { 0.51171875, 0.46093750, 0.98437500 },
   { 0.51171875, 0.47265625, 0.98437500 },
   { 0.51562500, 0.48828125, 0.98437500 },
   { 0.51953125, 0.50000000, 0.98046875 },
   { 0.52343750, 0.51171875, 0.98046875 },
   { 0.52734375, 0.52734375, 0.98046875 },
   { 0.52734375, 0.53906250, 0.98046875 },
   { 0.53125000, 0.55078125, 0.98046875 },
   { 0.53515625, 0.56250000, 0.97656250 },
   { 0.53906250, 0.57812500, 0.97656250 },
   { 0.54296875, 0.58984375, 0.97656250 },
   { 0.54296875, 0.60156250, 0.97656250 },
   { 0.54687500, 0.61718750, 0.97656250 },
   { 0.55078125, 0.62890625, 0.97265625 },
   { 0.55468750, 0.64062500, 0.97265625 },
   { 0.55859375, 0.66796875, 0.97265625 },
   { 0.56640625, 0.69140625, 0.96875000 },
   { 0.57421875, 0.71875000, 0.96875000 },
   { 0.57812500, 0.74218750, 0.96875000 },
   { 0.58593750, 0.76953125, 0.96484375 },
   { 0.58984375, 0.79687500, 0.96484375 },
   { 0.59765625, 0.82031250, 0.96093750 },
   { 0.60546875, 0.84765625, 0.96093750 },
   { 0.60937500, 0.87109375, 0.96093750 },
   { 0.61718750, 0.89843750, 0.95703125 },
   { 0.62109375, 0.92578125, 0.95703125 },
   { 0.62890625, 0.94921875, 0.95312500 },
   { 0.63671875, 0.97656250, 0.95312500 },
   { 0.63671875, 0.99218750, 0.94140625 },
   { 0.62500000, 0.98437500, 0.91015625 },
   { 0.61328125, 0.98046875, 0.87500000 },
   { 0.60156250, 0.97265625, 0.84375000 },
   { 0.58984375, 0.96875000, 0.80859375 },
   { 0.57812500, 0.96093750, 0.77734375 },
   { 0.56640625, 0.95312500, 0.74609375 },
   { 0.55468750, 0.94921875, 0.71093750 },
   { 0.54296875, 0.94140625, 0.67968750 },
   { 0.53515625, 0.93359375, 0.64453125 },
   { 0.51953125, 0.92968750, 0.60937500 },
   { 0.49609375, 0.91406250, 0.53906250 },
   { 0.47265625, 0.90234375, 0.46484375 },
   { 0.44531250, 0.88671875, 0.39453125 },
   { 0.42187500, 0.87500000, 0.32031250 },
   { 0.40625000, 0.86328125, 0.27343750 },
   { 0.40625000, 0.85937500, 0.26953125 },
   { 0.40234375, 0.85156250, 0.26562500 },
   { 0.40234375, 0.84375000, 0.26171875 },
   { 0.40234375, 0.83593750, 0.25390625 },
   { 0.40234375, 0.82812500, 0.24609375 },
   { 0.39843750, 0.81640625, 0.23828125 },
   { 0.39843750, 0.80468750, 0.23046875 },
   { 0.39843750, 0.79687500, 0.22265625 },
   { 0.39453125, 0.78515625, 0.21484375 },
   { 0.39453125, 0.77343750, 0.20703125 },
   { 0.39062500, 0.76171875, 0.19531250 },
   { 0.39062500, 0.75000000, 0.18750000 },
   { 0.39062500, 0.73437500, 0.17968750 },
   { 0.38671875, 0.72265625, 0.16796875 },
   { 0.38671875, 0.71093750, 0.16015625 },
   { 0.38281250, 0.69531250, 0.14843750 },
   { 0.38281250, 0.67968750, 0.13671875 },
   { 0.38281250, 0.66796875, 0.12500000 },
   { 0.37890625, 0.65234375, 0.11718750 },
   { 0.37890625, 0.63671875, 0.10546875 },
   { 0.37500000, 0.62500000, 0.09375000 },
   { 0.37500000, 0.60937500, 0.08203125 },
   { 0.37109375, 0.59375000, 0.07031250 },
   { 0.37109375, 0.57812500, 0.05859375 },
   { 0.36718750, 0.56250000, 0.04687500 },
   { 0.36718750, 0.54687500, 0.03515625 },
   { 0.36328125, 0.52734375, 0.02343750 },
   { 0.36328125, 0.51171875, 0.01171875 },
   { 0.35937500, 0.49609375, 0.00000000 },
};

const int RGB_Palette_21_Size = 256; // gimp - Wood2
double RGB_Palette_21[RGB_Palette_21_Size][3] =
{
   { 0.99609375, 0.69531250, 0.39843750 },
   { 0.98046875, 0.67578125, 0.36718750 },
   { 0.97656250, 0.66796875, 0.35937500 },
   { 0.97265625, 0.66015625, 0.35156250 },
   { 0.96875000, 0.65625000, 0.34375000 },
   { 0.96484375, 0.65234375, 0.33593750 },
   { 0.96093750, 0.64843750, 0.33203125 },
   { 0.96093750, 0.64453125, 0.32812500 },
   { 0.95703125, 0.64062500, 0.32421875 },
   { 0.95703125, 0.63671875, 0.32031250 },
   { 0.95312500, 0.63671875, 0.31640625 },
   { 0.95312500, 0.63281250, 0.31250000 },
   { 0.95312500, 0.62890625, 0.30859375 },
   { 0.94921875, 0.62890625, 0.30859375 },
   { 0.94921875, 0.62500000, 0.30468750 },
   { 0.94921875, 0.62500000, 0.30468750 },
   { 0.94531250, 0.62500000, 0.30078125 },
   { 0.94531250, 0.62109375, 0.29687500 },
   { 0.94531250, 0.62109375, 0.29687500 },
   { 0.94531250, 0.62109375, 0.29687500 },
   { 0.94140625, 0.61718750, 0.29296875 },
   { 0.94140625, 0.61718750, 0.29296875 },
   { 0.94140625, 0.61718750, 0.29296875 },
   { 0.94140625, 0.61718750, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28515625 },
   { 0.93750000, 0.61328125, 0.28515625 },
   { 0.93750000, 0.61328125, 0.28515625 },
   { 0.93750000, 0.61328125, 0.28515625 },
   { 0.80468750, 0.52343750, 0.24218750 },
   { 0.82812500, 0.53515625, 0.24609375 },
   { 0.83984375, 0.54296875, 0.24609375 },
   { 0.85156250, 0.54687500, 0.24609375 },
   { 0.85937500, 0.55468750, 0.24609375 },
   { 0.86328125, 0.55468750, 0.25000000 },
   { 0.87109375, 0.55859375, 0.25000000 },
   { 0.87500000, 0.56250000, 0.25000000 },
   { 0.87890625, 0.56640625, 0.25000000 },
   { 0.88671875, 0.56640625, 0.25000000 },
   { 0.89062500, 0.57031250, 0.25000000 },
   { 0.89062500, 0.57031250, 0.25000000 },
   { 0.89453125, 0.57421875, 0.25000000 },
   { 0.89843750, 0.57421875, 0.25000000 },
   { 0.90234375, 0.57812500, 0.25390625 },
   { 0.90234375, 0.57812500, 0.25390625 },
   { 0.90625000, 0.57812500, 0.25390625 },
   { 0.91015625, 0.58203125, 0.25390625 },
   { 0.91015625, 0.58203125, 0.25390625 },
   { 0.91406250, 0.58203125, 0.25390625 },
   { 0.91406250, 0.58203125, 0.25390625 },
   { 0.91406250, 0.58593750, 0.25390625 },
   { 0.91796875, 0.58593750, 0.25390625 },
   { 0.91796875, 0.58593750, 0.25390625 },
   { 0.91796875, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.82812500, 0.52734375, 0.22656250 },
   { 0.84375000, 0.53515625, 0.23046875 },
   { 0.85156250, 0.54296875, 0.23046875 },
   { 0.85937500, 0.54687500, 0.23046875 },
   { 0.86718750, 0.55078125, 0.23046875 },
   { 0.87109375, 0.55078125, 0.23437500 },
   { 0.87500000, 0.55468750, 0.23437500 },
   { 0.87890625, 0.55859375, 0.23437500 },
   { 0.88281250, 0.55859375, 0.23437500 },
   { 0.88671875, 0.56250000, 0.23437500 },
   { 0.89062500, 0.56250000, 0.23437500 },
   { 0.89062500, 0.56640625, 0.23828125 },
   { 0.89453125, 0.56640625, 0.23828125 },
   { 0.89843750, 0.56640625, 0.23828125 },
   { 0.89843750, 0.57031250, 0.23828125 },
   { 0.90234375, 0.57031250, 0.23828125 },
   { 0.90234375, 0.57031250, 0.23828125 },
   { 0.90625000, 0.57031250, 0.23828125 },
   { 0.90625000, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91406250, 0.57812500, 0.23828125 },
   { 0.91406250, 0.57812500, 0.23828125 },
   { 0.91406250, 0.57812500, 0.23828125 },
   { 0.91406250, 0.57812500, 0.24218750 },
   { 0.91406250, 0.57812500, 0.24218750 },
   { 0.91406250, 0.57812500, 0.24218750 },
   { 0.91796875, 0.57812500, 0.24218750 },
   { 0.91796875, 0.57812500, 0.24218750 },
   { 0.91796875, 0.57812500, 0.24218750 },
   { 0.78906250, 0.49609375, 0.20703125 },
   { 0.80859375, 0.50781250, 0.21093750 },
   { 0.82031250, 0.51953125, 0.21484375 },
   { 0.83203125, 0.52343750, 0.21484375 },
   { 0.83984375, 0.53125000, 0.21875000 },
   { 0.84765625, 0.53515625, 0.21875000 },
   { 0.85546875, 0.53906250, 0.22265625 },
   { 0.85937500, 0.54296875, 0.22265625 },
   { 0.86718750, 0.54687500, 0.22656250 },
   { 0.87109375, 0.54687500, 0.22656250 },
   { 0.87500000, 0.55078125, 0.22656250 },
   { 0.87890625, 0.55468750, 0.22656250 },
   { 0.88281250, 0.55468750, 0.23046875 },
   { 0.88671875, 0.55859375, 0.23046875 },
   { 0.89062500, 0.55859375, 0.23046875 },
   { 0.89453125, 0.56250000, 0.23046875 },
   { 0.89453125, 0.56250000, 0.23046875 },
   { 0.89843750, 0.56640625, 0.23046875 },
   { 0.89843750, 0.56640625, 0.23437500 },
   { 0.90234375, 0.56640625, 0.23437500 },
   { 0.90625000, 0.57031250, 0.23437500 },
   { 0.90625000, 0.57031250, 0.23437500 },
   { 0.90625000, 0.57031250, 0.23437500 },
   { 0.91015625, 0.57031250, 0.23437500 },
   { 0.91015625, 0.57421875, 0.23437500 },
   { 0.91015625, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.77343750, 0.48828125, 0.19921875 },
   { 0.77343750, 0.48828125, 0.19921875 },
   { 0.77343750, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.78125000, 0.49218750, 0.20312500 },
   { 0.78125000, 0.49218750, 0.20312500 },
   { 0.78125000, 0.49218750, 0.20312500 },
   { 0.78515625, 0.49218750, 0.20312500 },
   { 0.78515625, 0.49218750, 0.20312500 },
   { 0.78515625, 0.49609375, 0.20312500 },
   { 0.78906250, 0.49609375, 0.20312500 },
   { 0.78906250, 0.49609375, 0.20312500 },
   { 0.79296875, 0.50000000, 0.20312500 },
   { 0.79687500, 0.50000000, 0.20703125 },
   { 0.79687500, 0.50000000, 0.20703125 },
   { 0.80078125, 0.50390625, 0.20703125 },
   { 0.80468750, 0.50390625, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81640625, 0.51171875, 0.21093750 },
   { 0.82031250, 0.51562500, 0.21093750 },
   { 0.82421875, 0.51953125, 0.21093750 },
   { 0.82812500, 0.52343750, 0.21484375 },
   { 0.83593750, 0.52734375, 0.21484375 },
   { 0.84375000, 0.53125000, 0.21875000 },
   { 0.85156250, 0.53515625, 0.21875000 },
   { 0.86328125, 0.54296875, 0.22265625 },
   { 0.87890625, 0.55468750, 0.22656250 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.21093750 },
   { 0.80859375, 0.50781250, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81640625, 0.51171875, 0.21093750 },
   { 0.81640625, 0.51562500, 0.21093750 },
   { 0.81640625, 0.51562500, 0.21093750 },
   { 0.82031250, 0.51562500, 0.21093750 },
   { 0.82031250, 0.51562500, 0.21093750 },
   { 0.82421875, 0.51953125, 0.21093750 },
   { 0.82421875, 0.51953125, 0.21484375 },
   { 0.82812500, 0.51953125, 0.21484375 },
   { 0.83203125, 0.52343750, 0.21484375 },
   { 0.83203125, 0.52343750, 0.21484375 },
   { 0.83984375, 0.52734375, 0.21875000 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19140625 },
   { 0.74609375, 0.46875000, 0.19140625 },
   { 0.74609375, 0.46875000, 0.19140625 },
   { 0.74609375, 0.46875000, 0.19140625 },
   { 0.74218750, 0.46875000, 0.19140625 },
   { 0.74218750, 0.46875000, 0.19140625 },
   { 0.74218750, 0.46484375, 0.19140625 },
   { 0.73828125, 0.46484375, 0.19140625 },
   { 0.73828125, 0.46484375, 0.19140625 },
   { 0.73437500, 0.46484375, 0.19140625 },
   { 0.73437500, 0.46093750, 0.18750000 },
   { 0.73046875, 0.46093750, 0.18750000 },
   { 0.73046875, 0.45703125, 0.18750000 },
   { 0.72656250, 0.45703125, 0.18750000 },
   { 0.72265625, 0.45312500, 0.18750000 },
   { 0.71875000, 0.45312500, 0.18359375 },
   { 0.70703125, 0.44531250, 0.18359375 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
};

const int RGB_Palette_22_Size = 151; // Mars
double RGB_Palette_22[RGB_Palette_22_Size][3] =
{
   {0, 0, 0},
   {0, 0, 0},
   {0, 0, 0},
   {.00392156862745098039, 0, .00392156862745098039},
   {.01568627450980392156, .00784313725490196078, .01568627450980392156},
   {.02745098039215686274, .01568627450980392156, .02745098039215686274},
   {.03921568627450980392, .02745098039215686274, .03921568627450980392},
   {.05490196078431372549, .03137254901960784313, .05490196078431372549},
   {.08627450980392156862, .05490196078431372549, .09411764705882352941},
   {.13725490196078431372, .10588235294117647058, .16862745098039215686},
   {.19607843137254901960, .14901960784313725490, .24313725490196078431},
   {.25098039215686274509, .19607843137254901960, .31764705882352941176},
   {.30588235294117647058, .24313725490196078431, .39607843137254901960},
   {.32941176470588235294, .27058823529411764705, .45098039215686274509},
   {.32549019607843137254, .27843137254901960784, .48627450980392156862},
   {.32549019607843137254, .29019607843137254901, .52941176470588235294},
   {.31372549019607843137, .29411764705882352941, .56470588235294117647},
   {.30980392156862745098, .30196078431372549019, .60000000000000000000},
   {.30588235294117647058, .32156862745098039215, .63137254901960784313},
   {.29803921568627450980, .35294117647058823529, .65882352941176470588},
   {.29411764705882352941, .39215686274509803921, .68627450980392156862},
   {.28627450980392156862, .41960784313725490196, .70980392156862745098},
   {.27843137254901960784, .45098039215686274509, .72941176470588235294},
   {.26666666666666666666, .48627450980392156862, .75294117647058823529},
   {.25882352941176470588, .52549019607843137254, .78823529411764705882},
   {.24313725490196078431, .56078431372549019607, .80784313725490196078},
   {.23137254901960784313, .59215686274509803921, .83529411764705882352},
   {.22352941176470588235, .63137254901960784313, .85882352941176470588},
   {.21176470588235294117, .67058823529411764705, .83921568627450980392},
   {.21176470588235294117, .71764705882352941176, .77254901960784313725},
   {.21176470588235294117, .76078431372549019607, .70980392156862745098},
   {.21176470588235294117, .80784313725490196078, .64313725490196078431},
   {.21176470588235294117, .85098039215686274509, .57254901960784313725},
   {.21176470588235294117, .87058823529411764705, .51372549019607843137},
   {.21176470588235294117, .87450980392156862745, .45882352941176470588},
   {.21176470588235294117, .87058823529411764705, .40784313725490196078},
   {.21176470588235294117, .87450980392156862745, .34509803921568627450},
   {.21176470588235294117, .87058823529411764705, .29019607843137254901},
   {.23529411764705882352, .87058823529411764705, .25490196078431372549},
   {.27450980392156862745, .87450980392156862745, .24705882352941176470},
   {.31764705882352941176, .87058823529411764705, .23921568627450980392},
   {.36470588235294117647, .87450980392156862745, .22745098039215686274},
   {.40000000000000000000, .87058823529411764705, .21960784313725490196},
   {.46666666666666666666, .87058823529411764705, .19607843137254901960},
   {.56470588235294117647, .87450980392156862745, .16078431372549019607},
   {.64705882352941176470, .87058823529411764705, .12941176470588235294},
   {.73725490196078431372, .87450980392156862745, .09411764705882352941},
   {.82745098039215686274, .87058823529411764705, .05882352941176470588},
   {.87058823529411764705, .85490196078431372549, .04705882352941176470},
   {.87450980392156862745, .81176470588235294117, .05882352941176470588},
   {.87058823529411764705, .77647058823529411764, .07450980392156862745},
   {.87450980392156862745, .73725490196078431372, .08235294117647058823},
   {.87058823529411764705, .69803921568627450980, .09411764705882352941},
   {.87843137254901960784, .66666666666666666666, .11372549019607843137},
   {.89019607843137254901, .63137254901960784313, .13725490196078431372},
   {.90588235294117647058, .60392156862745098039, .16862745098039215686},
   {.91764705882352941176, .56862745098039215686, .18823529411764705882},
   {.92549019607843137254, .54117647058823529411, .21176470588235294117},
   {.93333333333333333333, .50196078431372549019, .22352941176470588235},
   {.93333333333333333333, .45490196078431372549, .21176470588235294117},
   {.94117647058823529411, .40784313725490196078, .20000000000000000000},
   {.93333333333333333333, .36470588235294117647, .18823529411764705882},
   {.93333333333333333333, .31764705882352941176, .17647058823529411764},
   {.93333333333333333333, .29803921568627450980, .19607843137254901960},
   {.93333333333333333333, .30980392156862745098, .23921568627450980392},
   {.94117647058823529411, .31764705882352941176, .27843137254901960784},
   {.93333333333333333333, .32941176470588235294, .32549019607843137254},
   {.93333333333333333333, .34117647058823529411, .37254901960784313725},
   {.92156862745098039215, .35294117647058823529, .40000000000000000000},
   {.89411764705882352941, .36078431372549019607, .41176470588235294117},
   {.87450980392156862745, .37254901960784313725, .43137254901960784313},
   {.84313725490196078431, .38039215686274509803, .44705882352941176470},
   {.82352941176470588235, .39607843137254901960, .46274509803921568627},
   {.80392156862745098039, .39607843137254901960, .45490196078431372549},
   {.78823529411764705882, .38823529411764705882, .43921568627450980392},
   {.77647058823529411764, .38431372549019607843, .41960784313725490196},
   {.76470588235294117647, .38039215686274509803, .40000000000000000000},
   {.74901960784313725490, .37254901960784313725, .37647058823529411764},
   {.72941176470588235294, .37254901960784313725, .36078431372549019607},
   {.70980392156862745098, .38431372549019607843, .35294117647058823529},
   {.68627450980392156862, .38823529411764705882, .34117647058823529411},
   {.65882352941176470588, .39607843137254901960, .32549019607843137254},
   {.63137254901960784313, .40000000000000000000, .30980392156862745098},
   {.61568627450980392156, .41176470588235294117, .30588235294117647058},
   {.60000000000000000000, .41960784313725490196, .30980392156862745098},
   {.59215686274509803921, .42745098039215686274, .31372549019607843137},
   {.57647058823529411764, .43921568627450980392, .30980392156862745098},
   {.56078431372549019607, .44705882352941176470, .30980392156862745098},
   {.54509803921568627450, .44705882352941176470, .30980392156862745098},
   {.53725490196078431372, .43529411764705882352, .30980392156862745098},
   {.52549019607843137254, .42352941176470588235, .31372549019607843137},
   {.50980392156862745098, .41176470588235294117, .30980392156862745098},
   {.50196078431372549019, .40784313725490196078, .30588235294117647058},
   {.49019607843137254901, .39607843137254901960, .30980392156862745098},
   {.47843137254901960784, .38823529411764705882, .31372549019607843137},
   {.47058823529411764705, .38823529411764705882, .32156862745098039215},
   {.45882352941176470588, .38431372549019607843, .32549019607843137254},
   {.44705882352941176470, .38039215686274509803, .32941176470588235294},
   {.44705882352941176470, .38039215686274509803, .34117647058823529411},
   {.45882352941176470588, .39215686274509803921, .35294117647058823529},
   {.47058823529411764705, .40000000000000000000, .36470588235294117647},
   {.47843137254901960784, .40784313725490196078, .37647058823529411764},
   {.49019607843137254901, .41568627450980392156, .39607843137254901960},
   {.49803921568627450980, .42745098039215686274, .40784313725490196078},
   {.50588235294117647058, .43921568627450980392, .41960784313725490196},
   {.52156862745098039215, .45098039215686274509, .43921568627450980392},
   {.52549019607843137254, .45882352941176470588, .45098039215686274509},
   {.53333333333333333333, .47058823529411764705, .47058823529411764705},
   {.54509803921568627450, .48627450980392156862, .48627450980392156862},
   {.55686274509803921568, .49803921568627450980, .49803921568627450980},
   {.56862745098039215686, .51764705882352941176, .51764705882352941176},
   {.57647058823529411764, .53333333333333333333, .53333333333333333333},
   {.58823529411764705882, .54509803921568627450, .54509803921568627450},
   {.59607843137254901960, .56078431372549019607, .56078431372549019607},
   {.60392156862745098039, .58039215686274509803, .58039215686274509803},
   {.61568627450980392156, .60000000000000000000, .60000000000000000000},
   {.62745098039215686274, .61568627450980392156, .61568627450980392156},
   {.63529411764705882352, .63529411764705882352, .63529411764705882352},
   {.64705882352941176470, .64705882352941176470, .64705882352941176470},
   {.65882352941176470588, .65882352941176470588, .65882352941176470588},
   {.66666666666666666666, .66666666666666666666, .66666666666666666666},
   {.67450980392156862745, .67450980392156862745, .67450980392156862745},
   {.68627450980392156862, .68627450980392156862, .68627450980392156862},
   {.69803921568627450980, .69803921568627450980, .69803921568627450980},
   {.70980392156862745098, .70980392156862745098, .70980392156862745098},
   {.71764705882352941176, .71764705882352941176, .71764705882352941176},
   {.73333333333333333333, .73333333333333333333, .73333333333333333333},
   {.73725490196078431372, .73725490196078431372, .73725490196078431372},
   {.74901960784313725490, .74901960784313725490, .74901960784313725490},
   {.76078431372549019607, .76078431372549019607, .76078431372549019607},
   {.76862745098039215686, .76862745098039215686, .76862745098039215686},
   {.77647058823529411764, .77647058823529411764, .77647058823529411764},
   {.78823529411764705882, .78823529411764705882, .78823529411764705882},
   {.80000000000000000000, .80000000000000000000, .80000000000000000000},
   {.80392156862745098039, .80392156862745098039, .80392156862745098039},
   {.81568627450980392156, .81568627450980392156, .81568627450980392156},
   {.82745098039215686274, .82745098039215686274, .82745098039215686274},
   {.83921568627450980392, .83921568627450980392, .83921568627450980392},
   {.84705882352941176470, .84705882352941176470, .84705882352941176470},
   {.85882352941176470588, .85882352941176470588, .85882352941176470588},
   {.86666666666666666666, .86666666666666666666, .86666666666666666666},
   {.87843137254901960784, .87843137254901960784, .87843137254901960784},
   {.89019607843137254901, .89019607843137254901, .89019607843137254901},
   {.90196078431372549019, .90196078431372549019, .90196078431372549019},
   {.90980392156862745098, .90980392156862745098, .90980392156862745098},
   {.92156862745098039215, .92156862745098039215, .92156862745098039215},
   {.93333333333333333333, .93333333333333333333, .93333333333333333333},
   {.94117647058823529411, .94117647058823529411, .94117647058823529411},
   {.94901960784313725490, .94901960784313725490, .94901960784313725490},
   {.94901960784313725490, .94901960784313725490, .94901960784313725490},
   {.94901960784313725490, .94901960784313725490, .94901960784313725490},
};

const int RGB_Palette_23_Size = 6*32+1; // rainbow
double RGB_Palette_23[RGB_Palette_23_Size][3];

const int RGB_Palette_24_Size = 31; // CMYK
double RGB_Palette_24[RGB_Palette_24_Size][3] =
{
   // 16 colors
   /*
     {0.300725, 0.680491, 0.901701}, {0.386403, 0.743518, 0.934237},
     {0.496414, 0.645794, 0.86504},  {0.604318, 0.51771,  0.780231},
     {0.699224, 0.432157, 0.70669},  {0.778582, 0.417821, 0.644854},
     {0.843122, 0.472052, 0.589251}, {0.893588, 0.572795, 0.538951},
     {0.928891, 0.68909,  0.500098}, {0.945344, 0.789625, 0.482689},
     {0.936608, 0.84884,  0.493779}, {0.894001, 0.850082, 0.529271},
     {0.806801, 0.785304, 0.566474}, {0.662204, 0.650797, 0.559579},
     {0.444557, 0.438462, 0.440244}, {0.133532, 0.122103, 0.125444}
   */
   // 31 colors
   {0.300725, 0.680491, 0.901701}, {0.343564, 0.712004, 0.917969},
   {0.386403, 0.743518, 0.934237}, {0.441409, 0.694656, 0.899639},
   {0.496414, 0.645794, 0.86504},  {0.550366, 0.581752, 0.822636},
   {0.604318, 0.51771,  0.780231}, {0.651771, 0.474934, 0.743461},
   {0.699224, 0.432157, 0.70669},  {0.738903, 0.424989, 0.675772},
   {0.778582, 0.417821, 0.644854}, {0.810852, 0.444937, 0.617053},
   {0.843122, 0.472052, 0.589251}, {0.868355, 0.522424, 0.564101},
   {0.893588, 0.572795, 0.538951}, {0.91124,  0.630943, 0.519525},
   {0.928891, 0.68909,  0.500098}, {0.937118, 0.739358, 0.491394},
   {0.945344, 0.789625, 0.482689}, {0.940976, 0.819233, 0.488234},
   {0.936608, 0.84884,  0.493779}, {0.915305, 0.849461, 0.511525},
   {0.894001, 0.850082, 0.529271}, {0.850401, 0.817693, 0.547873},
   {0.806801, 0.785304, 0.566474}, {0.734503, 0.71805,  0.563027},
   {0.662204, 0.650797, 0.559579}, {0.553381, 0.54463,  0.499912},
   {0.444557, 0.438462, 0.440244}, {0.289045, 0.280283, 0.282844},
   {0.133532, 0.122103, 0.125444}
};

const int RGB_Palette_25_Size = (4*16+1); // visit's calewhite
double RGB_Palette_25[RGB_Palette_25_Size][3];

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_26_Size = 32; // GMT_haxby.rgb
double RGB_Palette_26[RGB_Palette_26_Size][3] =
{
   {0.039216, 0.000000, 0.474510},
   {0.156863, 0.000000, 0.588235},
   {0.078431, 0.019608, 0.686275},
   {0.000000, 0.039216, 0.784314},
   {0.000000, 0.098039, 0.831373},
   {0.000000, 0.156863, 0.878431},
   {0.101961, 0.400000, 0.941176},
   {0.050980, 0.505882, 0.972549},
   {0.098039, 0.686275, 1.000000},
   {0.196078, 0.745098, 1.000000},
   {0.266667, 0.792157, 1.000000},
   {0.380392, 0.882353, 0.941176},
   {0.415686, 0.921569, 0.882353},
   {0.486275, 0.921569, 0.784314},
   {0.541176, 0.925490, 0.682353},
   {0.674510, 0.960784, 0.658824},
   {0.803922, 1.000000, 0.635294},
   {0.874510, 0.960784, 0.552941},
   {0.941176, 0.925490, 0.474510},
   {0.968627, 0.843137, 0.407843},
   {1.000000, 0.741176, 0.341176},
   {1.000000, 0.627451, 0.270588},
   {0.956863, 0.458824, 0.294118},
   {0.933333, 0.313725, 0.305882},
   {1.000000, 0.352941, 0.352941},
   {1.000000, 0.486275, 0.486275},
   {1.000000, 0.619608, 0.619608},
   {0.960784, 0.701961, 0.682353},
   {1.000000, 0.768627, 0.768627},
   {1.000000, 0.843137, 0.843137},
   {1.000000, 0.921569, 0.921569},
   {1.000000, 1.000000, 1.000000}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_27_Size = 256; // NCV_manga.rgb
double RGB_Palette_27[RGB_Palette_27_Size][3] =
{
   {0.183594, 0.214844, 0.621094},
   {0.167969, 0.203125, 0.625000},
   {0.128906, 0.167969, 0.632812},
   {0.082031, 0.125000, 0.636719},
   {0.042969, 0.089844, 0.644531},
   {0.019531, 0.070312, 0.648438},
   {0.007812, 0.062500, 0.656250},
   {0.000000, 0.058594, 0.660156},
   {0.000000, 0.062500, 0.664062},
   {0.000000, 0.062500, 0.664062},
   {0.000000, 0.062500, 0.664062},
   {0.000000, 0.062500, 0.648438},
   {0.000000, 0.062500, 0.617188},
   {0.000000, 0.058594, 0.562500},
   {0.000000, 0.050781, 0.488281},
   {0.000000, 0.046875, 0.429688},
   {0.000000, 0.046875, 0.410156},
   {0.000000, 0.050781, 0.445312},
   {0.000000, 0.062500, 0.519531},
   {0.000000, 0.074219, 0.601562},
   {0.000000, 0.085938, 0.664062},
   {0.000000, 0.093750, 0.703125},
   {0.000000, 0.101562, 0.726562},
   {0.000000, 0.105469, 0.738281},
   {0.000000, 0.113281, 0.746094},
   {0.003906, 0.121094, 0.753906},
   {0.011719, 0.128906, 0.757812},
   {0.027344, 0.148438, 0.761719},
   {0.058594, 0.175781, 0.765625},
   {0.105469, 0.222656, 0.769531},
   {0.167969, 0.277344, 0.777344},
   {0.218750, 0.320312, 0.781250},
   {0.234375, 0.339844, 0.785156},
   {0.210938, 0.324219, 0.789062},
   {0.156250, 0.285156, 0.792969},
   {0.097656, 0.242188, 0.796875},
   {0.054688, 0.214844, 0.800781},
   {0.027344, 0.199219, 0.804688},
   {0.011719, 0.195312, 0.808594},
   {0.007812, 0.195312, 0.812500},
   {0.007812, 0.203125, 0.816406},
   {0.007812, 0.207031, 0.816406},
   {0.007812, 0.214844, 0.808594},
   {0.007812, 0.214844, 0.792969},
   {0.007812, 0.210938, 0.757812},
   {0.007812, 0.199219, 0.695312},
   {0.007812, 0.187500, 0.625000},
   {0.007812, 0.171875, 0.566406},
   {0.007812, 0.175781, 0.550781},
   {0.011719, 0.195312, 0.593750},
   {0.015625, 0.226562, 0.667969},
   {0.019531, 0.261719, 0.746094},
   {0.023438, 0.289062, 0.804688},
   {0.027344, 0.312500, 0.839844},
   {0.031250, 0.328125, 0.859375},
   {0.031250, 0.343750, 0.867188},
   {0.039062, 0.359375, 0.875000},
   {0.046875, 0.375000, 0.878906},
   {0.058594, 0.394531, 0.882812},
   {0.082031, 0.417969, 0.886719},
   {0.121094, 0.449219, 0.890625},
   {0.179688, 0.496094, 0.890625},
   {0.250000, 0.542969, 0.894531},
   {0.304688, 0.582031, 0.898438},
   {0.320312, 0.597656, 0.902344},
   {0.292969, 0.593750, 0.906250},
   {0.238281, 0.578125, 0.906250},
   {0.183594, 0.562500, 0.910156},
   {0.148438, 0.558594, 0.914062},
   {0.128906, 0.562500, 0.914062},
   {0.125000, 0.574219, 0.917969},
   {0.128906, 0.589844, 0.917969},
   {0.136719, 0.605469, 0.921875},
   {0.148438, 0.621094, 0.917969},
   {0.156250, 0.628906, 0.910156},
   {0.160156, 0.632812, 0.890625},
   {0.164062, 0.617188, 0.847656},
   {0.160156, 0.585938, 0.785156},
   {0.156250, 0.542969, 0.710938},
   {0.152344, 0.511719, 0.656250},
   {0.160156, 0.519531, 0.644531},
   {0.179688, 0.566406, 0.691406},
   {0.214844, 0.640625, 0.765625},
   {0.246094, 0.718750, 0.843750},
   {0.277344, 0.781250, 0.894531},
   {0.304688, 0.824219, 0.929688},
   {0.328125, 0.855469, 0.945312},
   {0.347656, 0.878906, 0.953125},
   {0.367188, 0.898438, 0.957031},
   {0.390625, 0.914062, 0.960938},
   {0.414062, 0.929688, 0.960938},
   {0.445312, 0.945312, 0.964844},
   {0.488281, 0.960938, 0.964844},
   {0.542969, 0.964844, 0.960938},
   {0.597656, 0.968750, 0.953125},
   {0.640625, 0.968750, 0.949219},
   {0.660156, 0.972656, 0.945312},
   {0.652344, 0.972656, 0.937500},
   {0.640625, 0.972656, 0.929688},
   {0.628906, 0.976562, 0.921875},
   {0.632812, 0.976562, 0.914062},
   {0.640625, 0.976562, 0.906250},
   {0.660156, 0.980469, 0.902344},
   {0.675781, 0.980469, 0.898438},
   {0.695312, 0.976562, 0.894531},
   {0.714844, 0.972656, 0.890625},
   {0.726562, 0.964844, 0.878906},
   {0.726562, 0.937500, 0.859375},
   {0.707031, 0.894531, 0.816406},
   {0.667969, 0.828125, 0.757812},
   {0.621094, 0.750000, 0.691406},
   {0.589844, 0.699219, 0.644531},
   {0.597656, 0.695312, 0.644531},
   {0.652344, 0.746094, 0.695312},
   {0.734375, 0.820312, 0.769531},
   {0.808594, 0.890625, 0.839844},
   {0.867188, 0.941406, 0.894531},
   {0.906250, 0.968750, 0.925781},
   {0.929688, 0.984375, 0.945312},
   {0.945312, 0.988281, 0.957031},
   {0.957031, 0.992188, 0.964844},
   {0.968750, 0.992188, 0.972656},
   {0.976562, 0.992188, 0.976562},
   {0.980469, 0.992188, 0.984375},
   {0.988281, 0.992188, 0.988281},
   {0.992188, 0.992188, 0.992188},
   {0.992188, 0.992188, 0.992188},
   {0.992188, 0.992188, 0.992188},
   {0.992188, 0.992188, 0.992188},
   {0.992188, 0.992188, 0.992188},
   {0.992188, 0.992188, 0.992188},
   {0.988281, 0.992188, 0.988281},
   {0.984375, 0.992188, 0.980469},
   {0.976562, 0.992188, 0.976562},
   {0.972656, 0.992188, 0.968750},
   {0.964844, 0.992188, 0.957031},
   {0.957031, 0.988281, 0.945312},
   {0.945312, 0.984375, 0.929688},
   {0.925781, 0.968750, 0.906250},
   {0.894531, 0.941406, 0.867188},
   {0.839844, 0.890625, 0.808594},
   {0.769531, 0.820312, 0.734375},
   {0.695312, 0.746094, 0.652344},
   {0.644531, 0.695312, 0.597656},
   {0.644531, 0.699219, 0.589844},
   {0.691406, 0.750000, 0.621094},
   {0.757812, 0.828125, 0.667969},
   {0.816406, 0.894531, 0.707031},
   {0.859375, 0.937500, 0.726562},
   {0.878906, 0.964844, 0.726562},
   {0.890625, 0.972656, 0.714844},
   {0.894531, 0.976562, 0.695312},
   {0.898438, 0.980469, 0.675781},
   {0.902344, 0.980469, 0.660156},
   {0.906250, 0.976562, 0.640625},
   {0.914062, 0.976562, 0.632812},
   {0.921875, 0.976562, 0.628906},
   {0.929688, 0.972656, 0.640625},
   {0.937500, 0.972656, 0.652344},
   {0.945312, 0.972656, 0.660156},
   {0.949219, 0.968750, 0.640625},
   {0.953125, 0.968750, 0.597656},
   {0.960938, 0.964844, 0.542969},
   {0.964844, 0.960938, 0.488281},
   {0.964844, 0.945312, 0.445312},
   {0.960938, 0.929688, 0.414062},
   {0.960938, 0.914062, 0.390625},
   {0.957031, 0.898438, 0.367188},
   {0.953125, 0.878906, 0.347656},
   {0.945312, 0.855469, 0.328125},
   {0.929688, 0.824219, 0.304688},
   {0.894531, 0.781250, 0.277344},
   {0.843750, 0.718750, 0.246094},
   {0.765625, 0.640625, 0.214844},
   {0.691406, 0.566406, 0.179688},
   {0.644531, 0.519531, 0.160156},
   {0.656250, 0.511719, 0.152344},
   {0.710938, 0.542969, 0.156250},
   {0.785156, 0.585938, 0.160156},
   {0.847656, 0.617188, 0.164062},
   {0.890625, 0.632812, 0.160156},
   {0.910156, 0.628906, 0.156250},
   {0.917969, 0.621094, 0.148438},
   {0.921875, 0.605469, 0.136719},
   {0.917969, 0.589844, 0.128906},
   {0.917969, 0.574219, 0.125000},
   {0.914062, 0.562500, 0.128906},
   {0.914062, 0.558594, 0.148438},
   {0.910156, 0.562500, 0.183594},
   {0.906250, 0.578125, 0.238281},
   {0.906250, 0.593750, 0.292969},
   {0.902344, 0.597656, 0.320312},
   {0.898438, 0.582031, 0.304688},
   {0.894531, 0.542969, 0.250000},
   {0.890625, 0.496094, 0.179688},
   {0.890625, 0.449219, 0.121094},
   {0.886719, 0.417969, 0.082031},
   {0.882812, 0.394531, 0.058594},
   {0.878906, 0.375000, 0.046875},
   {0.875000, 0.359375, 0.039062},
   {0.867188, 0.343750, 0.031250},
   {0.859375, 0.328125, 0.031250},
   {0.839844, 0.312500, 0.027344},
   {0.804688, 0.289062, 0.023438},
   {0.746094, 0.261719, 0.019531},
   {0.667969, 0.226562, 0.015625},
   {0.593750, 0.195312, 0.011719},
   {0.550781, 0.175781, 0.007812},
   {0.566406, 0.171875, 0.007812},
   {0.625000, 0.187500, 0.007812},
   {0.695312, 0.199219, 0.007812},
   {0.757812, 0.210938, 0.007812},
   {0.792969, 0.214844, 0.007812},
   {0.808594, 0.214844, 0.007812},
   {0.816406, 0.207031, 0.007812},
   {0.816406, 0.203125, 0.007812},
   {0.812500, 0.195312, 0.007812},
   {0.808594, 0.195312, 0.011719},
   {0.804688, 0.199219, 0.027344},
   {0.800781, 0.214844, 0.054688},
   {0.796875, 0.242188, 0.097656},
   {0.792969, 0.285156, 0.156250},
   {0.789062, 0.324219, 0.210938},
   {0.785156, 0.339844, 0.234375},
   {0.781250, 0.320312, 0.218750},
   {0.777344, 0.277344, 0.167969},
   {0.769531, 0.222656, 0.105469},
   {0.765625, 0.175781, 0.058594},
   {0.761719, 0.148438, 0.027344},
   {0.757812, 0.128906, 0.011719},
   {0.753906, 0.121094, 0.003906},
   {0.746094, 0.113281, 0.000000},
   {0.738281, 0.105469, 0.000000},
   {0.726562, 0.101562, 0.000000},
   {0.703125, 0.093750, 0.000000},
   {0.664062, 0.085938, 0.000000},
   {0.601562, 0.074219, 0.000000},
   {0.519531, 0.062500, 0.000000},
   {0.445312, 0.050781, 0.000000},
   {0.410156, 0.046875, 0.000000},
   {0.429688, 0.046875, 0.000000},
   {0.488281, 0.050781, 0.000000},
   {0.562500, 0.058594, 0.000000},
   {0.617188, 0.062500, 0.000000},
   {0.648438, 0.062500, 0.000000},
   {0.664062, 0.062500, 0.000000},
   {0.664062, 0.062500, 0.000000},
   {0.664062, 0.062500, 0.000000},
   {0.660156, 0.058594, 0.000000},
   {0.656250, 0.062500, 0.007812},
   {0.648438, 0.070312, 0.019531},
   {0.644531, 0.089844, 0.042969},
   {0.636719, 0.125000, 0.082031},
   {0.632812, 0.167969, 0.128906},
   {0.625000, 0.203125, 0.167969},
   {0.621094, 0.214844, 0.183594}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_28_Size = 11; // CBR_drywet.rgb
double RGB_Palette_28[RGB_Palette_28_Size][3] =
{
   {0.328125, 0.187500, 0.019531},
   {0.546875, 0.316406, 0.039062},
   {0.746094, 0.503906, 0.175781},
   {0.871094, 0.757812, 0.488281},
   {0.960938, 0.906250, 0.761719},
   {0.957031, 0.957031, 0.957031},
   {0.777344, 0.914062, 0.894531},
   {0.500000, 0.800781, 0.753906},
   {0.207031, 0.589844, 0.558594},
   {0.003906, 0.398438, 0.371094},
   {0.000000, 0.234375, 0.187500}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_29_Size = 225; // nice_gfdl.rgb
double RGB_Palette_29[RGB_Palette_29_Size][3] =
{
   {0.996078, 0.984314, 0.964706},
   {0.925490, 0.929412, 0.945098},
   {0.905882, 0.909804, 0.925490},
   {0.862745, 0.882353, 0.901961},
   {0.835294, 0.854902, 0.874510},
   {0.811765, 0.823529, 0.858824},
   {0.784314, 0.796078, 0.831373},
   {0.749020, 0.772549, 0.811765},
   {0.729412, 0.749020, 0.788235},
   {0.694118, 0.717647, 0.768627},
   {0.670588, 0.690196, 0.741176},
   {0.639216, 0.666667, 0.725490},
   {0.611765, 0.639216, 0.698039},
   {0.580392, 0.607843, 0.666667},
   {0.560784, 0.588235, 0.647059},
   {0.517647, 0.560784, 0.623529},
   {0.490196, 0.537255, 0.596078},
   {0.462745, 0.517647, 0.576471},
   {0.435294, 0.490196, 0.545098},
   {0.400000, 0.447059, 0.525490},
   {0.384314, 0.431373, 0.509804},
   {0.352941, 0.407843, 0.486275},
   {0.325490, 0.380392, 0.458824},
   {0.294118, 0.356863, 0.443137},
   {0.270588, 0.329412, 0.415686},
   {0.247059, 0.301961, 0.396078},
   {0.223529, 0.282353, 0.372549},
   {0.196078, 0.254902, 0.360784},
   {0.168627, 0.223529, 0.325490},
   {0.133333, 0.203922, 0.301961},
   {0.113725, 0.180392, 0.274510},
   {0.094118, 0.149020, 0.250980},
   {0.074510, 0.125490, 0.227451},
   {0.050980, 0.109804, 0.203922},
   {0.047059, 0.105882, 0.196078},
   {0.050980, 0.117647, 0.203922},
   {0.062745, 0.129412, 0.219608},
   {0.074510, 0.141176, 0.235294},
   {0.086275, 0.156863, 0.254902},
   {0.094118, 0.176471, 0.258824},
   {0.105882, 0.188235, 0.274510},
   {0.121569, 0.207843, 0.298039},
   {0.133333, 0.219608, 0.309804},
   {0.137255, 0.243137, 0.325490},
   {0.145098, 0.254902, 0.337255},
   {0.160784, 0.270588, 0.356863},
   {0.176471, 0.286275, 0.372549},
   {0.180392, 0.301961, 0.380392},
   {0.196078, 0.313725, 0.396078},
   {0.203922, 0.325490, 0.407843},
   {0.219608, 0.341176, 0.423529},
   {0.223529, 0.360784, 0.427451},
   {0.247059, 0.384314, 0.450980},
   {0.247059, 0.396078, 0.458824},
   {0.262745, 0.415686, 0.478431},
   {0.282353, 0.439216, 0.490196},
   {0.290196, 0.447059, 0.498039},
   {0.298039, 0.462745, 0.513725},
   {0.309804, 0.478431, 0.529412},
   {0.313725, 0.501961, 0.533333},
   {0.329412, 0.517647, 0.549020},
   {0.333333, 0.529412, 0.560784},
   {0.349020, 0.549020, 0.580392},
   {0.356863, 0.564706, 0.592157},
   {0.372549, 0.580392, 0.607843},
   {0.392157, 0.603922, 0.631373},
   {0.403922, 0.615686, 0.643137},
   {0.403922, 0.631373, 0.643137},
   {0.423529, 0.654902, 0.666667},
   {0.431373, 0.662745, 0.674510},
   {0.447059, 0.678431, 0.694118},
   {0.454902, 0.698039, 0.705882},
   {0.474510, 0.717647, 0.725490},
   {0.482353, 0.725490, 0.733333},
   {0.501961, 0.749020, 0.756863},
   {0.505882, 0.772549, 0.752941},
   {0.517647, 0.788235, 0.764706},
   {0.525490, 0.807843, 0.784314},
   {0.541176, 0.819608, 0.800000},
   {0.549020, 0.839216, 0.811765},
   {0.564706, 0.858824, 0.831373},
   {0.580392, 0.874510, 0.847059},
   {0.596078, 0.894118, 0.862745},
   {0.596078, 0.905882, 0.862745},
   {0.596078, 0.905882, 0.862745},
   {0.576471, 0.890196, 0.819608},
   {0.564706, 0.878431, 0.811765},
   {0.549020, 0.866667, 0.760784},
   {0.541176, 0.858824, 0.752941},
   {0.529412, 0.847059, 0.729412},
   {0.517647, 0.835294, 0.713725},
   {0.498039, 0.827451, 0.662745},
   {0.478431, 0.807843, 0.643137},
   {0.470588, 0.803922, 0.607843},
   {0.454902, 0.784314, 0.588235},
   {0.443137, 0.776471, 0.556863},
   {0.431373, 0.764706, 0.545098},
   {0.415686, 0.749020, 0.501961},
   {0.407843, 0.741176, 0.494118},
   {0.392157, 0.729412, 0.458824},
   {0.380392, 0.713725, 0.447059},
   {0.368627, 0.701961, 0.415686},
   {0.352941, 0.682353, 0.400000},
   {0.345098, 0.678431, 0.360784},
   {0.329412, 0.662745, 0.345098},
   {0.317647, 0.647059, 0.325490},
   {0.305882, 0.635294, 0.313725},
   {0.282353, 0.623529, 0.270588},
   {0.274510, 0.615686, 0.262745},
   {0.262745, 0.592157, 0.223529},
   {0.258824, 0.584314, 0.215686},
   {0.247059, 0.576471, 0.180392},
   {0.243137, 0.572549, 0.176471},
   {0.270588, 0.584314, 0.149020},
   {0.282353, 0.600000, 0.160784},
   {0.313725, 0.619608, 0.117647},
   {0.329412, 0.639216, 0.129412},
   {0.372549, 0.654902, 0.098039},
   {0.384314, 0.666667, 0.109804},
   {0.419608, 0.686275, 0.070588},
   {0.435294, 0.701961, 0.086275},
   {0.478431, 0.721569, 0.023529},
   {0.494118, 0.741176, 0.050980},
   {0.529412, 0.756863, 0.000000},
   {0.545098, 0.772549, 0.000000},
   {0.588235, 0.788235, 0.000000},
   {0.603922, 0.807843, 0.000000},
   {0.635294, 0.811765, 0.000000},
   {0.658824, 0.835294, 0.000000},
   {0.698039, 0.850980, 0.000000},
   {0.721569, 0.874510, 0.000000},
   {0.756863, 0.878431, 0.000000},
   {0.780392, 0.905882, 0.000000},
   {0.823529, 0.909804, 0.000000},
   {0.847059, 0.933333, 0.000000},
   {0.878431, 0.945098, 0.000000},
   {0.901961, 0.968627, 0.000000},
   {0.933333, 0.972549, 0.000000},
   {0.960784, 1.000000, 0.000000},
   {1.000000, 1.000000, 0.000000},
   {1.000000, 1.000000, 0.000000},
   {1.000000, 0.984314, 0.000000},
   {1.000000, 0.972549, 0.000000},
   {1.000000, 0.921569, 0.000000},
   {1.000000, 0.905882, 0.000000},
   {1.000000, 0.862745, 0.000000},
   {1.000000, 0.847059, 0.000000},
   {1.000000, 0.803922, 0.000000},
   {1.000000, 0.788235, 0.000000},
   {1.000000, 0.749020, 0.000000},
   {1.000000, 0.733333, 0.000000},
   {1.000000, 0.694118, 0.000000},
   {1.000000, 0.678431, 0.000000},
   {1.000000, 0.631373, 0.000000},
   {1.000000, 0.619608, 0.000000},
   {1.000000, 0.580392, 0.000000},
   {1.000000, 0.568627, 0.000000},
   {1.000000, 0.529412, 0.000000},
   {1.000000, 0.509804, 0.000000},
   {1.000000, 0.466667, 0.000000},
   {1.000000, 0.458824, 0.000000},
   {1.000000, 0.431373, 0.000000},
   {1.000000, 0.407843, 0.000000},
   {1.000000, 0.376471, 0.000000},
   {0.980392, 0.360784, 0.000000},
   {0.952941, 0.333333, 0.000000},
   {0.929412, 0.313725, 0.000000},
   {0.909804, 0.290196, 0.000000},
   {0.886275, 0.270588, 0.000000},
   {0.862745, 0.243137, 0.000000},
   {0.843137, 0.231373, 0.000000},
   {0.819608, 0.203922, 0.000000},
   {0.792157, 0.184314, 0.000000},
   {0.772549, 0.160784, 0.000000},
   {0.749020, 0.145098, 0.000000},
   {0.725490, 0.121569, 0.023529},
   {0.721569, 0.117647, 0.019608},
   {0.686275, 0.125490, 0.023529},
   {0.674510, 0.117647, 0.011765},
   {0.631373, 0.117647, 0.035294},
   {0.627451, 0.117647, 0.031373},
   {0.603922, 0.109804, 0.031373},
   {0.592157, 0.101961, 0.023529},
   {0.549020, 0.105882, 0.035294},
   {0.545098, 0.101961, 0.031373},
   {0.505882, 0.101961, 0.027451},
   {0.501961, 0.098039, 0.023529},
   {0.474510, 0.101961, 0.035294},
   {0.466667, 0.098039, 0.031373},
   {0.431373, 0.094118, 0.039216},
   {0.427451, 0.090196, 0.035294},
   {0.392157, 0.094118, 0.039216},
   {0.388235, 0.090196, 0.035294},
   {0.360784, 0.086275, 0.039216},
   {0.349020, 0.078431, 0.031373},
   {0.313725, 0.086275, 0.047059},
   {0.301961, 0.078431, 0.043137},
   {0.290196, 0.078431, 0.043137},
   {0.278431, 0.070588, 0.039216},
   {0.239216, 0.074510, 0.039216},
   {0.235294, 0.070588, 0.039216},
   {0.215686, 0.066667, 0.043137},
   {0.207843, 0.062745, 0.039216},
   {0.180392, 0.062745, 0.043137},
   {0.160784, 0.050980, 0.031373},
   {0.141176, 0.054902, 0.035294},
   {0.137255, 0.050980, 0.031373},
   {0.113725, 0.050980, 0.035294},
   {0.101961, 0.043137, 0.023529},
   {0.082353, 0.043137, 0.031373},
   {0.070588, 0.031373, 0.019608},
   {0.058824, 0.031373, 0.023529},
   {0.058824, 0.031373, 0.023529},
   {0.054902, 0.031373, 0.019608},
   {0.050980, 0.031373, 0.015686},
   {0.047059, 0.023529, 0.019608},
   {0.050980, 0.027451, 0.023529},
   {0.043137, 0.027451, 0.019608},
   {0.039216, 0.015686, 0.000000},
   {0.035294, 0.019608, 0.015686},
   {0.031373, 0.011765, 0.000000},
   {0.023529, 0.015686, 0.000000},
   {0.023529, 0.015686, 0.000000},
   {0.000000, 0.000000, 0.000000},
   {0.000000, 0.000000, 0.000000}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_30_Size = 254; // WhiteBlueGreenYellowRed.rgb
double RGB_Palette_30[RGB_Palette_30_Size][3] =
{
   {0.996094, 0.996094, 0.996094},
   {0.984375, 0.992188, 0.996094},
   {0.976562, 0.988281, 0.996094},
   {0.964844, 0.984375, 0.992188},
   {0.953125, 0.980469, 0.992188},
   {0.945312, 0.976562, 0.992188},
   {0.933594, 0.972656, 0.992188},
   {0.921875, 0.968750, 0.988281},
   {0.914062, 0.964844, 0.988281},
   {0.902344, 0.960938, 0.988281},
   {0.894531, 0.957031, 0.988281},
   {0.882812, 0.953125, 0.988281},
   {0.871094, 0.949219, 0.984375},
   {0.863281, 0.945312, 0.984375},
   {0.851562, 0.941406, 0.984375},
   {0.839844, 0.937500, 0.984375},
   {0.832031, 0.933594, 0.984375},
   {0.820312, 0.929688, 0.980469},
   {0.808594, 0.925781, 0.980469},
   {0.800781, 0.921875, 0.980469},
   {0.789062, 0.917969, 0.980469},
   {0.777344, 0.914062, 0.976562},
   {0.769531, 0.910156, 0.976562},
   {0.757812, 0.906250, 0.976562},
   {0.746094, 0.902344, 0.976562},
   {0.738281, 0.898438, 0.976562},
   {0.726562, 0.894531, 0.972656},
   {0.714844, 0.890625, 0.972656},
   {0.707031, 0.886719, 0.972656},
   {0.695312, 0.882812, 0.972656},
   {0.687500, 0.878906, 0.972656},
   {0.675781, 0.875000, 0.968750},
   {0.664062, 0.871094, 0.968750},
   {0.656250, 0.867188, 0.968750},
   {0.644531, 0.863281, 0.968750},
   {0.632812, 0.859375, 0.964844},
   {0.613281, 0.851562, 0.964844},
   {0.605469, 0.843750, 0.960938},
   {0.593750, 0.835938, 0.957031},
   {0.585938, 0.828125, 0.949219},
   {0.578125, 0.820312, 0.945312},
   {0.570312, 0.812500, 0.941406},
   {0.558594, 0.804688, 0.937500},
   {0.550781, 0.796875, 0.929688},
   {0.542969, 0.789062, 0.925781},
   {0.531250, 0.781250, 0.921875},
   {0.523438, 0.769531, 0.917969},
   {0.515625, 0.761719, 0.914062},
   {0.503906, 0.753906, 0.906250},
   {0.496094, 0.746094, 0.902344},
   {0.488281, 0.738281, 0.898438},
   {0.480469, 0.730469, 0.894531},
   {0.468750, 0.722656, 0.890625},
   {0.460938, 0.714844, 0.882812},
   {0.453125, 0.707031, 0.878906},
   {0.441406, 0.699219, 0.875000},
   {0.433594, 0.691406, 0.871094},
   {0.425781, 0.683594, 0.863281},
   {0.414062, 0.675781, 0.859375},
   {0.406250, 0.667969, 0.855469},
   {0.398438, 0.660156, 0.851562},
   {0.390625, 0.652344, 0.847656},
   {0.378906, 0.644531, 0.839844},
   {0.371094, 0.636719, 0.835938},
   {0.363281, 0.625000, 0.832031},
   {0.351562, 0.617188, 0.828125},
   {0.343750, 0.609375, 0.824219},
   {0.335938, 0.601562, 0.816406},
   {0.324219, 0.593750, 0.812500},
   {0.316406, 0.585938, 0.808594},
   {0.308594, 0.578125, 0.804688},
   {0.300781, 0.570312, 0.796875},
   {0.281250, 0.554688, 0.789062},
   {0.281250, 0.558594, 0.773438},
   {0.281250, 0.562500, 0.761719},
   {0.281250, 0.566406, 0.746094},
   {0.281250, 0.570312, 0.734375},
   {0.281250, 0.574219, 0.718750},
   {0.281250, 0.578125, 0.707031},
   {0.281250, 0.582031, 0.691406},
   {0.281250, 0.585938, 0.675781},
   {0.281250, 0.589844, 0.664062},
   {0.281250, 0.597656, 0.648438},
   {0.281250, 0.601562, 0.636719},
   {0.281250, 0.605469, 0.621094},
   {0.281250, 0.609375, 0.609375},
   {0.281250, 0.613281, 0.593750},
   {0.281250, 0.617188, 0.578125},
   {0.281250, 0.621094, 0.566406},
   {0.281250, 0.625000, 0.550781},
   {0.281250, 0.628906, 0.539062},
   {0.285156, 0.632812, 0.523438},
   {0.285156, 0.636719, 0.511719},
   {0.285156, 0.640625, 0.496094},
   {0.285156, 0.644531, 0.484375},
   {0.285156, 0.648438, 0.468750},
   {0.285156, 0.652344, 0.453125},
   {0.285156, 0.656250, 0.441406},
   {0.285156, 0.660156, 0.425781},
   {0.285156, 0.664062, 0.414062},
   {0.285156, 0.671875, 0.398438},
   {0.285156, 0.675781, 0.386719},
   {0.285156, 0.679688, 0.371094},
   {0.285156, 0.683594, 0.355469},
   {0.285156, 0.687500, 0.343750},
   {0.285156, 0.691406, 0.328125},
   {0.285156, 0.695312, 0.316406},
   {0.285156, 0.699219, 0.300781},
   {0.285156, 0.707031, 0.273438},
   {0.304688, 0.710938, 0.277344},
   {0.324219, 0.718750, 0.277344},
   {0.339844, 0.722656, 0.281250},
   {0.359375, 0.730469, 0.281250},
   {0.378906, 0.734375, 0.285156},
   {0.398438, 0.738281, 0.289062},
   {0.414062, 0.746094, 0.289062},
   {0.433594, 0.750000, 0.292969},
   {0.453125, 0.753906, 0.292969},
   {0.472656, 0.761719, 0.296875},
   {0.492188, 0.765625, 0.300781},
   {0.507812, 0.773438, 0.300781},
   {0.527344, 0.777344, 0.304688},
   {0.546875, 0.781250, 0.304688},
   {0.566406, 0.789062, 0.308594},
   {0.585938, 0.792969, 0.312500},
   {0.601562, 0.796875, 0.312500},
   {0.621094, 0.804688, 0.316406},
   {0.640625, 0.808594, 0.316406},
   {0.660156, 0.816406, 0.320312},
   {0.675781, 0.820312, 0.320312},
   {0.695312, 0.824219, 0.324219},
   {0.714844, 0.832031, 0.328125},
   {0.734375, 0.835938, 0.328125},
   {0.753906, 0.839844, 0.332031},
   {0.769531, 0.847656, 0.332031},
   {0.789062, 0.851562, 0.335938},
   {0.808594, 0.859375, 0.339844},
   {0.828125, 0.863281, 0.339844},
   {0.847656, 0.867188, 0.343750},
   {0.863281, 0.875000, 0.343750},
   {0.882812, 0.878906, 0.347656},
   {0.902344, 0.882812, 0.351562},
   {0.921875, 0.890625, 0.351562},
   {0.937500, 0.894531, 0.355469},
   {0.957031, 0.902344, 0.355469},
   {0.976562, 0.906250, 0.359375},
   {0.976562, 0.894531, 0.355469},
   {0.976562, 0.878906, 0.347656},
   {0.976562, 0.867188, 0.343750},
   {0.972656, 0.851562, 0.335938},
   {0.972656, 0.839844, 0.332031},
   {0.972656, 0.828125, 0.328125},
   {0.972656, 0.812500, 0.320312},
   {0.972656, 0.800781, 0.316406},
   {0.972656, 0.785156, 0.312500},
   {0.972656, 0.773438, 0.304688},
   {0.972656, 0.761719, 0.300781},
   {0.968750, 0.746094, 0.292969},
   {0.968750, 0.734375, 0.289062},
   {0.968750, 0.718750, 0.285156},
   {0.968750, 0.707031, 0.277344},
   {0.968750, 0.695312, 0.273438},
   {0.968750, 0.679688, 0.269531},
   {0.968750, 0.667969, 0.261719},
   {0.964844, 0.652344, 0.257812},
   {0.964844, 0.640625, 0.250000},
   {0.964844, 0.625000, 0.246094},
   {0.964844, 0.613281, 0.242188},
   {0.964844, 0.601562, 0.234375},
   {0.964844, 0.585938, 0.230469},
   {0.964844, 0.574219, 0.226562},
   {0.960938, 0.558594, 0.218750},
   {0.960938, 0.546875, 0.214844},
   {0.960938, 0.535156, 0.207031},
   {0.960938, 0.519531, 0.203125},
   {0.960938, 0.507812, 0.199219},
   {0.960938, 0.492188, 0.191406},
   {0.960938, 0.480469, 0.187500},
   {0.960938, 0.468750, 0.183594},
   {0.957031, 0.453125, 0.175781},
   {0.957031, 0.441406, 0.171875},
   {0.957031, 0.414062, 0.160156},
   {0.953125, 0.406250, 0.160156},
   {0.949219, 0.398438, 0.160156},
   {0.945312, 0.390625, 0.160156},
   {0.941406, 0.382812, 0.160156},
   {0.937500, 0.375000, 0.160156},
   {0.933594, 0.367188, 0.160156},
   {0.933594, 0.359375, 0.160156},
   {0.929688, 0.351562, 0.160156},
   {0.925781, 0.343750, 0.160156},
   {0.921875, 0.335938, 0.160156},
   {0.917969, 0.328125, 0.160156},
   {0.914062, 0.320312, 0.160156},
   {0.910156, 0.312500, 0.160156},
   {0.906250, 0.304688, 0.160156},
   {0.902344, 0.296875, 0.160156},
   {0.898438, 0.289062, 0.160156},
   {0.894531, 0.281250, 0.160156},
   {0.890625, 0.273438, 0.160156},
   {0.890625, 0.261719, 0.156250},
   {0.886719, 0.253906, 0.156250},
   {0.882812, 0.246094, 0.156250},
   {0.878906, 0.238281, 0.156250},
   {0.875000, 0.230469, 0.156250},
   {0.871094, 0.222656, 0.156250},
   {0.867188, 0.214844, 0.156250},
   {0.863281, 0.207031, 0.156250},
   {0.859375, 0.199219, 0.156250},
   {0.855469, 0.191406, 0.156250},
   {0.851562, 0.183594, 0.156250},
   {0.847656, 0.175781, 0.156250},
   {0.847656, 0.167969, 0.156250},
   {0.843750, 0.160156, 0.156250},
   {0.839844, 0.152344, 0.156250},
   {0.835938, 0.144531, 0.156250},
   {0.832031, 0.136719, 0.156250},
   {0.824219, 0.121094, 0.156250},
   {0.816406, 0.121094, 0.156250},
   {0.808594, 0.117188, 0.152344},
   {0.804688, 0.117188, 0.152344},
   {0.796875, 0.117188, 0.148438},
   {0.789062, 0.117188, 0.148438},
   {0.781250, 0.113281, 0.148438},
   {0.777344, 0.113281, 0.144531},
   {0.769531, 0.113281, 0.144531},
   {0.761719, 0.113281, 0.140625},
   {0.753906, 0.109375, 0.140625},
   {0.750000, 0.109375, 0.140625},
   {0.742188, 0.109375, 0.136719},
   {0.734375, 0.105469, 0.136719},
   {0.726562, 0.105469, 0.132812},
   {0.722656, 0.105469, 0.132812},
   {0.714844, 0.105469, 0.132812},
   {0.707031, 0.101562, 0.128906},
   {0.699219, 0.101562, 0.128906},
   {0.695312, 0.101562, 0.125000},
   {0.687500, 0.101562, 0.125000},
   {0.679688, 0.097656, 0.121094},
   {0.671875, 0.097656, 0.121094},
   {0.667969, 0.097656, 0.121094},
   {0.660156, 0.097656, 0.117188},
   {0.652344, 0.093750, 0.117188},
   {0.644531, 0.093750, 0.113281},
   {0.640625, 0.093750, 0.113281},
   {0.632812, 0.089844, 0.113281},
   {0.625000, 0.089844, 0.109375},
   {0.617188, 0.089844, 0.109375},
   {0.613281, 0.089844, 0.105469},
   {0.605469, 0.085938, 0.105469},
   {0.597656, 0.085938, 0.105469},
   {0.589844, 0.085938, 0.101562},
   {0.585938, 0.085938, 0.101562},
   {0.570312, 0.082031, 0.097656}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_31_Size = 25; // StepSeq25.rgb
double RGB_Palette_31[RGB_Palette_31_Size][3] =
{
   {0.597656, 0.058594, 0.058594},
   {0.695312, 0.171875, 0.171875},
   {0.796875, 0.316406, 0.316406},
   {0.894531, 0.492188, 0.492188},
   {0.996094, 0.695312, 0.695312},
   {0.597656, 0.328125, 0.058594},
   {0.695312, 0.433594, 0.171875},
   {0.796875, 0.554688, 0.316406},
   {0.894531, 0.691406, 0.492188},
   {0.996094, 0.843750, 0.695312},
   {0.417969, 0.597656, 0.058594},
   {0.519531, 0.695312, 0.171875},
   {0.636719, 0.796875, 0.316406},
   {0.761719, 0.894531, 0.492188},
   {0.894531, 0.996094, 0.695312},
   {0.058594, 0.417969, 0.597656},
   {0.171875, 0.519531, 0.695312},
   {0.316406, 0.636719, 0.796875},
   {0.492188, 0.761719, 0.894531},
   {0.695312, 0.894531, 0.996094},
   {0.148438, 0.058594, 0.597656},
   {0.257812, 0.171875, 0.695312},
   {0.394531, 0.316406, 0.796875},
   {0.558594, 0.492188, 0.894531},
   {0.746094, 0.695312, 0.996094}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_32_Size = 128; // MPL_terrain.rgb
double RGB_Palette_32[RGB_Palette_32_Size][3] =
{
   {0.194771, 0.210458, 0.610458},
   {0.184314, 0.231373, 0.631373},
   {0.173856, 0.252288, 0.652288},
   {0.163399, 0.273203, 0.673203},
   {0.152941, 0.294118, 0.694118},
   {0.142484, 0.315033, 0.715033},
   {0.132026, 0.335948, 0.735948},
   {0.121569, 0.356863, 0.756863},
   {0.111111, 0.377778, 0.777778},
   {0.105882, 0.388235, 0.788235},
   {0.090196, 0.419608, 0.819608},
   {0.084967, 0.430065, 0.830065},
   {0.069281, 0.461438, 0.861438},
   {0.064052, 0.471895, 0.871895},
   {0.048366, 0.503268, 0.903268},
   {0.043137, 0.513725, 0.913725},
   {0.027451, 0.545098, 0.945098},
   {0.016993, 0.566013, 0.966013},
   {0.011765, 0.576471, 0.976471},
   {0.000000, 0.605882, 0.982353},
   {0.000000, 0.621569, 0.935294},
   {0.000000, 0.637255, 0.888235},
   {0.000000, 0.645098, 0.864706},
   {0.000000, 0.668627, 0.794118},
   {0.000000, 0.684314, 0.747059},
   {0.000000, 0.700000, 0.700000},
   {0.000000, 0.707843, 0.676471},
   {0.000000, 0.731373, 0.605882},
   {0.000000, 0.747059, 0.558824},
   {0.000000, 0.762745, 0.511765},
   {0.000000, 0.770588, 0.488235},
   {0.000000, 0.794118, 0.417647},
   {0.019608, 0.803922, 0.403922},
   {0.050980, 0.810196, 0.410196},
   {0.082353, 0.816471, 0.416471},
   {0.113725, 0.822745, 0.422745},
   {0.145098, 0.829020, 0.429020},
   {0.160784, 0.832157, 0.432157},
   {0.207843, 0.841569, 0.441569},
   {0.239216, 0.847843, 0.447843},
   {0.270588, 0.854118, 0.454118},
   {0.301961, 0.860392, 0.460392},
   {0.333333, 0.866667, 0.466667},
   {0.364706, 0.872941, 0.472941},
   {0.396078, 0.879216, 0.479216},
   {0.411765, 0.882353, 0.482353},
   {0.458824, 0.891765, 0.491765},
   {0.490196, 0.898039, 0.498039},
   {0.521569, 0.904314, 0.504314},
   {0.552941, 0.910588, 0.510588},
   {0.584314, 0.916863, 0.516863},
   {0.615686, 0.923137, 0.523137},
   {0.647059, 0.929412, 0.529412},
   {0.662745, 0.932549, 0.532549},
   {0.709804, 0.941961, 0.541961},
   {0.741176, 0.948235, 0.548235},
   {0.772549, 0.954510, 0.554510},
   {0.803922, 0.960784, 0.560784},
   {0.835294, 0.967059, 0.567059},
   {0.866667, 0.973333, 0.573333},
   {0.898039, 0.979608, 0.579608},
   {0.913725, 0.982745, 0.582745},
   {0.960784, 0.992157, 0.592157},
   {0.992157, 0.998431, 0.598431},
   {0.988235, 0.984941, 0.593647},
   {0.972549, 0.964863, 0.585176},
   {0.956863, 0.944784, 0.576706},
   {0.941176, 0.924706, 0.568235},
   {0.925490, 0.904627, 0.559765},
   {0.909804, 0.884549, 0.551294},
   {0.894118, 0.864471, 0.542824},
   {0.878431, 0.844392, 0.534353},
   {0.862745, 0.824314, 0.525882},
   {0.847059, 0.804235, 0.517412},
   {0.831373, 0.784157, 0.508941},
   {0.823529, 0.774118, 0.504706},
   {0.800000, 0.744000, 0.492000},
   {0.784314, 0.723922, 0.483529},
   {0.768627, 0.703843, 0.475059},
   {0.752941, 0.683765, 0.466588},
   {0.737255, 0.663686, 0.458118},
   {0.721569, 0.643608, 0.449647},
   {0.705882, 0.623529, 0.441176},
   {0.690196, 0.603451, 0.432706},
   {0.674510, 0.583373, 0.424235},
   {0.658824, 0.563294, 0.415765},
   {0.643137, 0.543216, 0.407294},
   {0.627451, 0.523137, 0.398824},
   {0.611765, 0.503059, 0.390353},
   {0.596078, 0.482980, 0.381882},
   {0.580392, 0.462902, 0.373412},
   {0.572549, 0.452863, 0.369176},
   {0.549020, 0.422745, 0.356471},
   {0.533333, 0.402667, 0.348000},
   {0.517647, 0.382588, 0.339529},
   {0.501961, 0.362510, 0.331059},
   {0.513725, 0.377569, 0.348392},
   {0.529412, 0.397647, 0.369412},
   {0.545098, 0.417725, 0.390431},
   {0.560784, 0.437804, 0.411451},
   {0.576471, 0.457882, 0.432471},
   {0.592157, 0.477961, 0.453490},
   {0.607843, 0.498039, 0.474510},
   {0.623529, 0.518118, 0.495529},
   {0.639216, 0.538196, 0.516549},
   {0.654902, 0.558275, 0.537569},
   {0.670588, 0.578353, 0.558588},
   {0.678431, 0.588392, 0.569098},
   {0.701961, 0.618510, 0.600627},
   {0.717647, 0.638588, 0.621647},
   {0.733333, 0.658667, 0.642667},
   {0.749020, 0.678745, 0.663686},
   {0.764706, 0.698824, 0.684706},
   {0.780392, 0.718902, 0.705725},
   {0.796078, 0.738980, 0.726745},
   {0.811765, 0.759059, 0.747765},
   {0.827451, 0.779137, 0.768784},
   {0.843137, 0.799216, 0.789804},
   {0.858824, 0.819294, 0.810824},
   {0.874510, 0.839373, 0.831843},
   {0.890196, 0.859451, 0.852863},
   {0.905882, 0.879529, 0.873882},
   {0.921569, 0.899608, 0.894902},
   {0.929412, 0.909647, 0.905412},
   {0.952941, 0.939765, 0.936941},
   {0.968627, 0.959843, 0.957961},
   {0.984314, 0.979922, 0.978980},
   {1.000000, 1.000000, 1.000000}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_33_Size = 254; // BlueWhiteOrangeRed.rgb
double RGB_Palette_33[RGB_Palette_33_Size][3] =
{
   {0.105469, 0.171875, 0.382812},
   {0.105469, 0.179688, 0.394531},
   {0.109375, 0.187500, 0.406250},
   {0.109375, 0.195312, 0.417969},
   {0.113281, 0.203125, 0.429688},
   {0.113281, 0.207031, 0.437500},
   {0.113281, 0.214844, 0.449219},
   {0.117188, 0.222656, 0.460938},
   {0.117188, 0.230469, 0.472656},
   {0.117188, 0.238281, 0.484375},
   {0.121094, 0.246094, 0.496094},
   {0.121094, 0.253906, 0.507812},
   {0.125000, 0.261719, 0.519531},
   {0.125000, 0.265625, 0.527344},
   {0.125000, 0.273438, 0.539062},
   {0.128906, 0.281250, 0.550781},
   {0.128906, 0.289062, 0.562500},
   {0.128906, 0.296875, 0.574219},
   {0.132812, 0.304688, 0.585938},
   {0.132812, 0.312500, 0.597656},
   {0.136719, 0.320312, 0.609375},
   {0.136719, 0.324219, 0.617188},
   {0.136719, 0.332031, 0.628906},
   {0.140625, 0.347656, 0.652344},
   {0.148438, 0.359375, 0.660156},
   {0.156250, 0.371094, 0.667969},
   {0.164062, 0.382812, 0.675781},
   {0.175781, 0.398438, 0.683594},
   {0.183594, 0.410156, 0.691406},
   {0.191406, 0.421875, 0.699219},
   {0.199219, 0.433594, 0.707031},
   {0.207031, 0.445312, 0.714844},
   {0.214844, 0.457031, 0.722656},
   {0.222656, 0.468750, 0.730469},
   {0.230469, 0.480469, 0.738281},
   {0.242188, 0.496094, 0.750000},
   {0.250000, 0.507812, 0.757812},
   {0.257812, 0.519531, 0.765625},
   {0.265625, 0.531250, 0.773438},
   {0.273438, 0.542969, 0.781250},
   {0.281250, 0.554688, 0.789062},
   {0.289062, 0.566406, 0.796875},
   {0.296875, 0.578125, 0.804688},
   {0.308594, 0.593750, 0.812500},
   {0.316406, 0.605469, 0.820312},
   {0.324219, 0.617188, 0.828125},
   {0.339844, 0.640625, 0.843750},
   {0.351562, 0.648438, 0.847656},
   {0.363281, 0.660156, 0.855469},
   {0.375000, 0.667969, 0.859375},
   {0.386719, 0.675781, 0.863281},
   {0.398438, 0.683594, 0.867188},
   {0.410156, 0.695312, 0.875000},
   {0.417969, 0.703125, 0.878906},
   {0.429688, 0.710938, 0.882812},
   {0.441406, 0.718750, 0.890625},
   {0.453125, 0.730469, 0.894531},
   {0.464844, 0.738281, 0.898438},
   {0.476562, 0.746094, 0.906250},
   {0.488281, 0.753906, 0.910156},
   {0.500000, 0.765625, 0.914062},
   {0.511719, 0.773438, 0.917969},
   {0.523438, 0.781250, 0.925781},
   {0.535156, 0.789062, 0.929688},
   {0.546875, 0.800781, 0.933594},
   {0.554688, 0.808594, 0.941406},
   {0.566406, 0.816406, 0.945312},
   {0.578125, 0.824219, 0.949219},
   {0.589844, 0.835938, 0.953125},
   {0.613281, 0.851562, 0.964844},
   {0.621094, 0.855469, 0.964844},
   {0.632812, 0.859375, 0.964844},
   {0.640625, 0.863281, 0.964844},
   {0.652344, 0.867188, 0.964844},
   {0.660156, 0.867188, 0.964844},
   {0.671875, 0.871094, 0.968750},
   {0.679688, 0.875000, 0.968750},
   {0.687500, 0.878906, 0.968750},
   {0.699219, 0.882812, 0.968750},
   {0.707031, 0.886719, 0.968750},
   {0.718750, 0.890625, 0.968750},
   {0.726562, 0.894531, 0.968750},
   {0.734375, 0.894531, 0.968750},
   {0.746094, 0.898438, 0.968750},
   {0.753906, 0.902344, 0.968750},
   {0.765625, 0.906250, 0.968750},
   {0.773438, 0.910156, 0.968750},
   {0.785156, 0.914062, 0.972656},
   {0.792969, 0.917969, 0.972656},
   {0.800781, 0.921875, 0.972656},
   {0.812500, 0.921875, 0.972656},
   {0.820312, 0.925781, 0.972656},
   {0.839844, 0.933594, 0.972656},
   {0.847656, 0.937500, 0.972656},
   {0.851562, 0.937500, 0.976562},
   {0.859375, 0.941406, 0.976562},
   {0.867188, 0.945312, 0.976562},
   {0.871094, 0.945312, 0.976562},
   {0.878906, 0.949219, 0.980469},
   {0.886719, 0.953125, 0.980469},
   {0.890625, 0.953125, 0.980469},
   {0.898438, 0.957031, 0.980469},
   {0.906250, 0.960938, 0.984375},
   {0.910156, 0.960938, 0.984375},
   {0.917969, 0.964844, 0.984375},
   {0.925781, 0.968750, 0.984375},
   {0.929688, 0.968750, 0.988281},
   {0.937500, 0.972656, 0.988281},
   {0.945312, 0.976562, 0.988281},
   {0.949219, 0.976562, 0.988281},
   {0.957031, 0.980469, 0.992188},
   {0.964844, 0.984375, 0.992188},
   {0.968750, 0.984375, 0.992188},
   {0.976562, 0.988281, 0.992188},
   {0.984375, 0.992188, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.996094, 0.996094},
   {0.996094, 0.992188, 0.980469},
   {0.996094, 0.988281, 0.964844},
   {0.996094, 0.988281, 0.949219},
   {0.996094, 0.984375, 0.929688},
   {0.992188, 0.980469, 0.914062},
   {0.992188, 0.976562, 0.898438},
   {0.992188, 0.972656, 0.882812},
   {0.992188, 0.968750, 0.867188},
   {0.992188, 0.968750, 0.851562},
   {0.992188, 0.964844, 0.832031},
   {0.992188, 0.960938, 0.816406},
   {0.992188, 0.957031, 0.800781},
   {0.988281, 0.953125, 0.785156},
   {0.988281, 0.949219, 0.769531},
   {0.988281, 0.949219, 0.753906},
   {0.988281, 0.945312, 0.734375},
   {0.988281, 0.941406, 0.718750},
   {0.988281, 0.937500, 0.703125},
   {0.988281, 0.933594, 0.687500},
   {0.988281, 0.929688, 0.671875},
   {0.984375, 0.929688, 0.656250},
   {0.984375, 0.925781, 0.636719},
   {0.984375, 0.917969, 0.605469},
   {0.984375, 0.910156, 0.589844},
   {0.984375, 0.898438, 0.570312},
   {0.984375, 0.890625, 0.554688},
   {0.984375, 0.878906, 0.539062},
   {0.984375, 0.871094, 0.519531},
   {0.988281, 0.859375, 0.503906},
   {0.988281, 0.851562, 0.484375},
   {0.988281, 0.839844, 0.468750},
   {0.988281, 0.832031, 0.453125},
   {0.988281, 0.820312, 0.433594},
   {0.988281, 0.812500, 0.417969},
   {0.988281, 0.804688, 0.402344},
   {0.988281, 0.792969, 0.382812},
   {0.988281, 0.785156, 0.367188},
   {0.988281, 0.773438, 0.347656},
   {0.988281, 0.765625, 0.332031},
   {0.988281, 0.753906, 0.316406},
   {0.992188, 0.746094, 0.296875},
   {0.992188, 0.734375, 0.281250},
   {0.992188, 0.726562, 0.265625},
   {0.992188, 0.714844, 0.246094},
   {0.992188, 0.707031, 0.230469},
   {0.992188, 0.687500, 0.195312},
   {0.992188, 0.675781, 0.195312},
   {0.988281, 0.664062, 0.191406},
   {0.988281, 0.652344, 0.191406},
   {0.988281, 0.640625, 0.191406},
   {0.984375, 0.628906, 0.187500},
   {0.984375, 0.621094, 0.187500},
   {0.980469, 0.609375, 0.183594},
   {0.980469, 0.597656, 0.183594},
   {0.980469, 0.585938, 0.183594},
   {0.976562, 0.574219, 0.179688},
   {0.976562, 0.562500, 0.179688},
   {0.976562, 0.550781, 0.179688},
   {0.972656, 0.539062, 0.175781},
   {0.972656, 0.527344, 0.175781},
   {0.968750, 0.515625, 0.171875},
   {0.968750, 0.503906, 0.171875},
   {0.968750, 0.492188, 0.171875},
   {0.964844, 0.484375, 0.167969},
   {0.964844, 0.472656, 0.167969},
   {0.964844, 0.460938, 0.167969},
   {0.960938, 0.449219, 0.164062},
   {0.960938, 0.437500, 0.164062},
   {0.957031, 0.414062, 0.160156},
   {0.953125, 0.402344, 0.160156},
   {0.945312, 0.390625, 0.160156},
   {0.941406, 0.378906, 0.160156},
   {0.933594, 0.367188, 0.160156},
   {0.929688, 0.351562, 0.160156},
   {0.925781, 0.339844, 0.160156},
   {0.917969, 0.328125, 0.160156},
   {0.914062, 0.316406, 0.160156},
   {0.906250, 0.304688, 0.160156},
   {0.902344, 0.292969, 0.160156},
   {0.894531, 0.281250, 0.160156},
   {0.890625, 0.269531, 0.160156},
   {0.886719, 0.253906, 0.156250},
   {0.878906, 0.242188, 0.156250},
   {0.875000, 0.230469, 0.156250},
   {0.867188, 0.218750, 0.156250},
   {0.863281, 0.207031, 0.156250},
   {0.859375, 0.195312, 0.156250},
   {0.851562, 0.183594, 0.156250},
   {0.847656, 0.171875, 0.156250},
   {0.839844, 0.156250, 0.156250},
   {0.835938, 0.144531, 0.156250},
   {0.824219, 0.121094, 0.156250},
   {0.812500, 0.121094, 0.152344},
   {0.804688, 0.117188, 0.152344},
   {0.792969, 0.117188, 0.148438},
   {0.781250, 0.113281, 0.148438},
   {0.769531, 0.113281, 0.144531},
   {0.761719, 0.113281, 0.140625},
   {0.750000, 0.109375, 0.140625},
   {0.738281, 0.109375, 0.136719},
   {0.730469, 0.105469, 0.132812},
   {0.718750, 0.105469, 0.132812},
   {0.707031, 0.101562, 0.128906},
   {0.699219, 0.101562, 0.128906},
   {0.687500, 0.101562, 0.125000},
   {0.675781, 0.097656, 0.121094},
   {0.664062, 0.097656, 0.121094},
   {0.656250, 0.093750, 0.117188},
   {0.644531, 0.093750, 0.113281},
   {0.632812, 0.093750, 0.113281},
   {0.625000, 0.089844, 0.109375},
   {0.613281, 0.089844, 0.109375},
   {0.601562, 0.085938, 0.105469},
   {0.589844, 0.085938, 0.101562},
   {0.570312, 0.082031, 0.097656}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_34_Size = 20; // rh_19lev.rgb
double RGB_Palette_34[RGB_Palette_34_Size][3] =
{
   {0.992188, 0.992188, 0.992188},
   {0.992188, 0.992188, 0.625000},
   {0.992188, 0.992188, 0.386719},
   {0.953125, 0.953125, 0.429688},
   {0.996094, 0.820312, 0.136719},
   {0.996094, 0.636719, 0.097656},
   {0.996094, 0.347656, 0.097656},
   {0.898438, 0.476562, 0.394531},
   {0.925781, 0.566406, 0.484375},
   {0.933594, 0.695312, 0.570312},
   {0.964844, 0.777344, 0.695312},
   {0.996094, 0.898438, 0.898438},
   {0.839844, 0.878906, 0.996094},
   {0.585938, 0.820312, 0.996094},
   {0.117188, 0.738281, 0.996094},
   {0.078125, 0.621094, 0.996094},
   {0.039062, 0.421875, 0.937500},
   {0.042969, 0.453125, 0.996094},
   {0.039062, 0.406250, 0.781250},
   {0.000000, 0.347656, 0.621094}
};

// http://www.ncl.ucar.edu/Document/Graphics/color_table_gallery.shtml
const int RGB_Palette_35_Size = 213; // lithology.rgb
double RGB_Palette_35[RGB_Palette_35_Size][3] =
{
   {0.988281, 0.953125, 0.246094},
   {0.996094, 0.996094, 0.535156},
   {0.996094, 0.824219, 0.269531},
   {0.996094, 0.792969, 0.136719},
   {0.996094, 0.996094, 0.832031},
   {0.921875, 0.703125, 0.000000},
   {0.996094, 0.976562, 0.910156},
   {0.996094, 0.976562, 0.781250},
   {0.996094, 0.996094, 0.714844},
   {0.976562, 0.929688, 0.476562},
   {0.953125, 0.933594, 0.890625},
   {0.941406, 0.894531, 0.871094},
   {0.890625, 0.812500, 0.742188},
   {0.890625, 0.843750, 0.742188},
   {0.996094, 0.960938, 0.847656},
   {0.875000, 0.769531, 0.617188},
   {0.875000, 0.820312, 0.703125},
   {0.855469, 0.796875, 0.660156},
   {0.957031, 0.878906, 0.738281},
   {0.875000, 0.687500, 0.617188},
   {0.808594, 0.730469, 0.558594},
   {0.878906, 0.886719, 0.761719},
   {0.894531, 0.855469, 0.699219},
   {0.859375, 0.832031, 0.703125},
   {0.824219, 0.789062, 0.621094},
   {0.785156, 0.742188, 0.535156},
   {0.734375, 0.683594, 0.421875},
   {0.746094, 0.652344, 0.261719},
   {0.820312, 0.757812, 0.484375},
   {0.996094, 0.929688, 0.746094},
   {0.996094, 0.894531, 0.613281},
   {0.996094, 0.871094, 0.519531},
   {0.992188, 0.898438, 0.437500},
   {0.992188, 0.882812, 0.343750},
   {0.992188, 0.855469, 0.179688},
   {0.964844, 0.949219, 0.628906},
   {0.996094, 0.808594, 0.503906},
   {0.996094, 0.796875, 0.597656},
   {0.996094, 0.886719, 0.535156},
   {0.996094, 0.855469, 0.402344},
   {0.570312, 0.859375, 0.714844},
   {0.847656, 0.988281, 0.824219},
   {0.808594, 0.933594, 0.871094},
   {0.832031, 0.898438, 0.796875},
   {0.750000, 0.812500, 0.750000},
   {0.671875, 0.890625, 0.781250},
   {0.855469, 0.992188, 0.734375},
   {0.730469, 0.996094, 0.863281},
   {0.878906, 0.937500, 0.843750},
   {0.835938, 0.992188, 0.601562},
   {0.582031, 0.996094, 0.789062},
   {0.800781, 0.996094, 0.847656},
   {0.648438, 0.984375, 0.664062},
   {0.792969, 0.933594, 0.804688},
   {0.601562, 0.804688, 0.992188},
   {0.410156, 0.808594, 0.609375},
   {0.738281, 0.855469, 0.941406},
   {0.718750, 0.914062, 0.761719},
   {0.562500, 0.644531, 0.394531},
   {0.714844, 0.847656, 0.796875},
   {0.652344, 0.726562, 0.523438},
   {0.644531, 0.664062, 0.675781},
   {0.550781, 0.742188, 0.800781},
   {0.730469, 0.750000, 0.769531},
   {0.335938, 0.875000, 0.984375},
   {0.261719, 0.683594, 0.972656},
   {0.417969, 0.761719, 0.996094},
   {0.218750, 0.703125, 0.691406},
   {0.375000, 0.796875, 0.746094},
   {0.746094, 0.886719, 0.859375},
   {0.800781, 0.867188, 0.996094},
   {0.003906, 0.609375, 0.800781},
   {0.601562, 0.746094, 0.750000},
   {0.750000, 0.679688, 0.710938},
   {0.722656, 0.582031, 0.593750},
   {0.847656, 0.757812, 0.636719},
   {0.507812, 0.000000, 0.253906},
   {0.429688, 0.285156, 0.035156},
   {0.996094, 0.714844, 0.867188},
   {0.996094, 0.761719, 0.890625},
   {0.996094, 0.816406, 0.914062},
   {0.996094, 0.761719, 0.968750},
   {0.996094, 0.894531, 0.949219},
   {0.996094, 0.875000, 0.867188},
   {0.972656, 0.824219, 0.824219},
   {0.996094, 0.949219, 0.785156},
   {0.996094, 0.933594, 0.847656},
   {0.996094, 0.894531, 0.761719},
   {0.996094, 0.832031, 0.613281},
   {0.996094, 0.632812, 0.152344},
   {0.996094, 0.753906, 0.433594},
   {0.953125, 0.542969, 0.000000},
   {0.992188, 0.859375, 0.492188},
   {0.992188, 0.796875, 0.406250},
   {0.992188, 0.773438, 0.164062},
   {0.992188, 0.800781, 0.671875},
   {0.992188, 0.714844, 0.523438},
   {0.992188, 0.625000, 0.375000},
   {0.992188, 0.527344, 0.210938},
   {0.992188, 0.457031, 0.093750},
   {0.917969, 0.375000, 0.003906},
   {0.785156, 0.320312, 0.003906},
   {0.691406, 0.281250, 0.003906},
   {0.574219, 0.234375, 0.003906},
   {0.921875, 0.832031, 0.773438},
   {0.863281, 0.699219, 0.589844},
   {0.824219, 0.613281, 0.472656},
   {0.773438, 0.500000, 0.312500},
   {0.660156, 0.394531, 0.214844},
   {0.757812, 0.253906, 0.000000},
   {0.371094, 0.222656, 0.121094},
   {0.519531, 0.308594, 0.167969},
   {0.625000, 0.207031, 0.000000},
   {0.429688, 0.144531, 0.000000},
   {0.984375, 0.429688, 0.484375},
   {0.996094, 0.753906, 0.714844},
   {0.996094, 0.878906, 0.906250},
   {0.890625, 0.343750, 0.566406},
   {0.996094, 0.933594, 0.949219},
   {0.863281, 0.160156, 0.445312},
   {0.996094, 0.816406, 0.859375},
   {0.996094, 0.503906, 0.621094},
   {0.996094, 0.660156, 0.613281},
   {0.906250, 0.109375, 0.000000},
   {0.996094, 0.199219, 0.089844},
   {0.835938, 0.000000, 0.000000},
   {0.972656, 0.707031, 0.730469},
   {0.968750, 0.742188, 0.679688},
   {0.996094, 0.699219, 0.769531},
   {0.996094, 0.433594, 0.417969},
   {0.984375, 0.320312, 0.382812},
   {0.910156, 0.472656, 0.648438},
   {0.984375, 0.710938, 0.710938},
   {0.996094, 0.652344, 0.734375},
   {0.953125, 0.234375, 0.421875},
   {0.980469, 0.136719, 0.218750},
   {0.953125, 0.101562, 0.527344},
   {0.996094, 0.386719, 0.531250},
   {0.996094, 0.152344, 0.351562},
   {0.671875, 0.000000, 0.000000},
   {0.996094, 0.433594, 0.355469},
   {0.886719, 0.464844, 0.675781},
   {0.925781, 0.652344, 0.789062},
   {0.910156, 0.574219, 0.742188},
   {0.996094, 0.835938, 0.816406},
   {0.996094, 0.746094, 0.804688},
   {0.996094, 0.582031, 0.679688},
   {0.996094, 0.433594, 0.566406},
   {0.996094, 0.105469, 0.316406},
   {0.906250, 0.000000, 0.214844},
   {0.804688, 0.000000, 0.191406},
   {0.687500, 0.000000, 0.164062},
   {0.753906, 0.003906, 0.039062},
   {0.578125, 0.000000, 0.136719},
   {0.636719, 0.003906, 0.035156},
   {0.457031, 0.003906, 0.027344},
   {0.652344, 0.652344, 0.996094},
   {0.914062, 0.683594, 0.996094},
   {0.804688, 0.613281, 0.996094},
   {0.640625, 0.285156, 0.996094},
   {0.503906, 0.011719, 0.996094},
   {0.273438, 0.000000, 0.546875},
   {0.000000, 0.359375, 0.000000},
   {0.488281, 0.996094, 0.488281},
   {0.785156, 0.996094, 0.785156},
   {0.898438, 0.800781, 0.996094},
   {0.621094, 0.996094, 0.621094},
   {0.910156, 0.996094, 0.910156},
   {0.000000, 0.000000, 0.996094},
   {0.996094, 0.339844, 0.996094},
   {0.996094, 0.550781, 0.996094},
   {0.996094, 0.652344, 0.996094},
   {0.992188, 0.402344, 0.000000},
   {0.996094, 0.000000, 0.000000},
   {0.722656, 0.230469, 0.406250},
   {0.527344, 0.167969, 0.296875},
   {0.785156, 0.332031, 0.492188},
   {0.000000, 0.500000, 0.000000},
   {0.703125, 0.808594, 0.890625},
   {0.855469, 0.855469, 0.902344},
   {0.925781, 0.925781, 0.949219},
   {0.750000, 0.750000, 0.750000},
   {0.691406, 0.691406, 0.691406},
   {0.789062, 0.789062, 0.859375},
   {0.632812, 0.632812, 0.750000},
   {0.710938, 0.710938, 0.804688},
   {0.585938, 0.585938, 0.585938},
   {0.636719, 0.214844, 0.988281},
   {0.921875, 0.835938, 0.992188},
   {0.875000, 0.734375, 0.992188},
   {0.832031, 0.640625, 0.992188},
   {0.781250, 0.523438, 0.992188},
   {0.796875, 0.714844, 0.996094},
   {0.699219, 0.582031, 0.996094},
   {0.562500, 0.386719, 0.996094},
   {0.621094, 0.000000, 0.789062},
   {0.480469, 0.000000, 0.609375},
   {0.414062, 0.000000, 0.414062},
   {0.515625, 0.378906, 0.242188},
   {0.812500, 0.792969, 0.687500},
   {0.687500, 0.652344, 0.468750},
   {0.531250, 0.496094, 0.312500},
   {0.671875, 0.496094, 0.312500},
   {0.425781, 0.312500, 0.199219},
   {0.390625, 0.007812, 0.042969},
   {0.531250, 0.496094, 0.312500},
   {0.996094, 0.996094, 0.996094},
   {0.597656, 0.796875, 0.996094},
   {0.996094, 0.832031, 0.613281},
   {0.996094, 0.816406, 0.859375},
   {0.519531, 0.308594, 0.167969},
   {0.417969, 0.761719, 0.996094},
   {0.625000, 0.207031, 0.000000}
};

const int RGB_Palette_36_Size = 64; // gray
double RGB_Palette_36[RGB_Palette_36_Size][3];

// https://ai.googleblog.com/2019/08/turbo-improved-rainbow-colormap-for.html
const int RGB_Palette_37_Size = 256; // turbo
double RGB_Palette_37[RGB_Palette_37_Size][3] =
{
   {0.18995000, 0.07176000, 0.23217000},
   {0.19483000, 0.08339000, 0.26149000},
   {0.19956000, 0.09498000, 0.29024000},
   {0.20415000, 0.10652000, 0.31844000},
   {0.20860000, 0.11802000, 0.34607000},
   {0.21291000, 0.12947000, 0.37314000},
   {0.21708000, 0.14087000, 0.39964000},
   {0.22111000, 0.15223000, 0.42558000},
   {0.22500000, 0.16354000, 0.45096000},
   {0.22875000, 0.17481000, 0.47578000},
   {0.23236000, 0.18603000, 0.50004000},
   {0.23582000, 0.19720000, 0.52373000},
   {0.23915000, 0.20833000, 0.54686000},
   {0.24234000, 0.21941000, 0.56942000},
   {0.24539000, 0.23044000, 0.59142000},
   {0.24830000, 0.24143000, 0.61286000},
   {0.25107000, 0.25237000, 0.63374000},
   {0.25369000, 0.26327000, 0.65406000},
   {0.25618000, 0.27412000, 0.67381000},
   {0.25853000, 0.28492000, 0.69300000},
   {0.26074000, 0.29568000, 0.71162000},
   {0.26280000, 0.30639000, 0.72968000},
   {0.26473000, 0.31706000, 0.74718000},
   {0.26652000, 0.32768000, 0.76412000},
   {0.26816000, 0.33825000, 0.78050000},
   {0.26967000, 0.34878000, 0.79631000},
   {0.27103000, 0.35926000, 0.81156000},
   {0.27226000, 0.36970000, 0.82624000},
   {0.27334000, 0.38008000, 0.84037000},
   {0.27429000, 0.39043000, 0.85393000},
   {0.27509000, 0.40072000, 0.86692000},
   {0.27576000, 0.41097000, 0.87936000},
   {0.27628000, 0.42118000, 0.89123000},
   {0.27667000, 0.43134000, 0.90254000},
   {0.27691000, 0.44145000, 0.91328000},
   {0.27701000, 0.45152000, 0.92347000},
   {0.27698000, 0.46153000, 0.93309000},
   {0.27680000, 0.47151000, 0.94214000},
   {0.27648000, 0.48144000, 0.95064000},
   {0.27603000, 0.49132000, 0.95857000},
   {0.27543000, 0.50115000, 0.96594000},
   {0.27469000, 0.51094000, 0.97275000},
   {0.27381000, 0.52069000, 0.97899000},
   {0.27273000, 0.53040000, 0.98461000},
   {0.27106000, 0.54015000, 0.98930000},
   {0.26878000, 0.54995000, 0.99303000},
   {0.26592000, 0.55979000, 0.99583000},
   {0.26252000, 0.56967000, 0.99773000},
   {0.25862000, 0.57958000, 0.99876000},
   {0.25425000, 0.58950000, 0.99896000},
   {0.24946000, 0.59943000, 0.99835000},
   {0.24427000, 0.60937000, 0.99697000},
   {0.23874000, 0.61931000, 0.99485000},
   {0.23288000, 0.62923000, 0.99202000},
   {0.22676000, 0.63913000, 0.98851000},
   {0.22039000, 0.64901000, 0.98436000},
   {0.21382000, 0.65886000, 0.97959000},
   {0.20708000, 0.66866000, 0.97423000},
   {0.20021000, 0.67842000, 0.96833000},
   {0.19326000, 0.68812000, 0.96190000},
   {0.18625000, 0.69775000, 0.95498000},
   {0.17923000, 0.70732000, 0.94761000},
   {0.17223000, 0.71680000, 0.93981000},
   {0.16529000, 0.72620000, 0.93161000},
   {0.15844000, 0.73551000, 0.92305000},
   {0.15173000, 0.74472000, 0.91416000},
   {0.14519000, 0.75381000, 0.90496000},
   {0.13886000, 0.76279000, 0.89550000},
   {0.13278000, 0.77165000, 0.88580000},
   {0.12698000, 0.78037000, 0.87590000},
   {0.12151000, 0.78896000, 0.86581000},
   {0.11639000, 0.79740000, 0.85559000},
   {0.11167000, 0.80569000, 0.84525000},
   {0.10738000, 0.81381000, 0.83484000},
   {0.10357000, 0.82177000, 0.82437000},
   {0.10026000, 0.82955000, 0.81389000},
   {0.09750000, 0.83714000, 0.80342000},
   {0.09532000, 0.84455000, 0.79299000},
   {0.09377000, 0.85175000, 0.78264000},
   {0.09287000, 0.85875000, 0.77240000},
   {0.09267000, 0.86554000, 0.76230000},
   {0.09320000, 0.87211000, 0.75237000},
   {0.09451000, 0.87844000, 0.74265000},
   {0.09662000, 0.88454000, 0.73316000},
   {0.09958000, 0.89040000, 0.72393000},
   {0.10342000, 0.89600000, 0.71500000},
   {0.10815000, 0.90142000, 0.70599000},
   {0.11374000, 0.90673000, 0.69651000},
   {0.12014000, 0.91193000, 0.68660000},
   {0.12733000, 0.91701000, 0.67627000},
   {0.13526000, 0.92197000, 0.66556000},
   {0.14391000, 0.92680000, 0.65448000},
   {0.15323000, 0.93151000, 0.64308000},
   {0.16319000, 0.93609000, 0.63137000},
   {0.17377000, 0.94053000, 0.61938000},
   {0.18491000, 0.94484000, 0.60713000},
   {0.19659000, 0.94901000, 0.59466000},
   {0.20877000, 0.95304000, 0.58199000},
   {0.22142000, 0.95692000, 0.56914000},
   {0.23449000, 0.96065000, 0.55614000},
   {0.24797000, 0.96423000, 0.54303000},
   {0.26180000, 0.96765000, 0.52981000},
   {0.27597000, 0.97092000, 0.51653000},
   {0.29042000, 0.97403000, 0.50321000},
   {0.30513000, 0.97697000, 0.48987000},
   {0.32006000, 0.97974000, 0.47654000},
   {0.33517000, 0.98234000, 0.46325000},
   {0.35043000, 0.98477000, 0.45002000},
   {0.36581000, 0.98702000, 0.43688000},
   {0.38127000, 0.98909000, 0.42386000},
   {0.39678000, 0.99098000, 0.41098000},
   {0.41229000, 0.99268000, 0.39826000},
   {0.42778000, 0.99419000, 0.38575000},
   {0.44321000, 0.99551000, 0.37345000},
   {0.45854000, 0.99663000, 0.36140000},
   {0.47375000, 0.99755000, 0.34963000},
   {0.48879000, 0.99828000, 0.33816000},
   {0.50362000, 0.99879000, 0.32701000},
   {0.51822000, 0.99910000, 0.31622000},
   {0.53255000, 0.99919000, 0.30581000},
   {0.54658000, 0.99907000, 0.29581000},
   {0.56026000, 0.99873000, 0.28623000},
   {0.57357000, 0.99817000, 0.27712000},
   {0.58646000, 0.99739000, 0.26849000},
   {0.59891000, 0.99638000, 0.26038000},
   {0.61088000, 0.99514000, 0.25280000},
   {0.62233000, 0.99366000, 0.24579000},
   {0.63323000, 0.99195000, 0.23937000},
   {0.64362000, 0.98999000, 0.23356000},
   {0.65394000, 0.98775000, 0.22835000},
   {0.66428000, 0.98524000, 0.22370000},
   {0.67462000, 0.98246000, 0.21960000},
   {0.68494000, 0.97941000, 0.21602000},
   {0.69525000, 0.97610000, 0.21294000},
   {0.70553000, 0.97255000, 0.21032000},
   {0.71577000, 0.96875000, 0.20815000},
   {0.72596000, 0.96470000, 0.20640000},
   {0.73610000, 0.96043000, 0.20504000},
   {0.74617000, 0.95593000, 0.20406000},
   {0.75617000, 0.95121000, 0.20343000},
   {0.76608000, 0.94627000, 0.20311000},
   {0.77591000, 0.94113000, 0.20310000},
   {0.78563000, 0.93579000, 0.20336000},
   {0.79524000, 0.93025000, 0.20386000},
   {0.80473000, 0.92452000, 0.20459000},
   {0.81410000, 0.91861000, 0.20552000},
   {0.82333000, 0.91253000, 0.20663000},
   {0.83241000, 0.90627000, 0.20788000},
   {0.84133000, 0.89986000, 0.20926000},
   {0.85010000, 0.89328000, 0.21074000},
   {0.85868000, 0.88655000, 0.21230000},
   {0.86709000, 0.87968000, 0.21391000},
   {0.87530000, 0.87267000, 0.21555000},
   {0.88331000, 0.86553000, 0.21719000},
   {0.89112000, 0.85826000, 0.21880000},
   {0.89870000, 0.85087000, 0.22038000},
   {0.90605000, 0.84337000, 0.22188000},
   {0.91317000, 0.83576000, 0.22328000},
   {0.92004000, 0.82806000, 0.22456000},
   {0.92666000, 0.82025000, 0.22570000},
   {0.93301000, 0.81236000, 0.22667000},
   {0.93909000, 0.80439000, 0.22744000},
   {0.94489000, 0.79634000, 0.22800000},
   {0.95039000, 0.78823000, 0.22831000},
   {0.95560000, 0.78005000, 0.22836000},
   {0.96049000, 0.77181000, 0.22811000},
   {0.96507000, 0.76352000, 0.22754000},
   {0.96931000, 0.75519000, 0.22663000},
   {0.97323000, 0.74682000, 0.22536000},
   {0.97679000, 0.73842000, 0.22369000},
   {0.98000000, 0.73000000, 0.22161000},
   {0.98289000, 0.72140000, 0.21918000},
   {0.98549000, 0.71250000, 0.21650000},
   {0.98781000, 0.70330000, 0.21358000},
   {0.98986000, 0.69382000, 0.21043000},
   {0.99163000, 0.68408000, 0.20706000},
   {0.99314000, 0.67408000, 0.20348000},
   {0.99438000, 0.66386000, 0.19971000},
   {0.99535000, 0.65341000, 0.19577000},
   {0.99607000, 0.64277000, 0.19165000},
   {0.99654000, 0.63193000, 0.18738000},
   {0.99675000, 0.62093000, 0.18297000},
   {0.99672000, 0.60977000, 0.17842000},
   {0.99644000, 0.59846000, 0.17376000},
   {0.99593000, 0.58703000, 0.16899000},
   {0.99517000, 0.57549000, 0.16412000},
   {0.99419000, 0.56386000, 0.15918000},
   {0.99297000, 0.55214000, 0.15417000},
   {0.99153000, 0.54036000, 0.14910000},
   {0.98987000, 0.52854000, 0.14398000},
   {0.98799000, 0.51667000, 0.13883000},
   {0.98590000, 0.50479000, 0.13367000},
   {0.98360000, 0.49291000, 0.12849000},
   {0.98108000, 0.48104000, 0.12332000},
   {0.97837000, 0.46920000, 0.11817000},
   {0.97545000, 0.45740000, 0.11305000},
   {0.97234000, 0.44565000, 0.10797000},
   {0.96904000, 0.43399000, 0.10294000},
   {0.96555000, 0.42241000, 0.09798000},
   {0.96187000, 0.41093000, 0.09310000},
   {0.95801000, 0.39958000, 0.08831000},
   {0.95398000, 0.38836000, 0.08362000},
   {0.94977000, 0.37729000, 0.07905000},
   {0.94538000, 0.36638000, 0.07461000},
   {0.94084000, 0.35566000, 0.07031000},
   {0.93612000, 0.34513000, 0.06616000},
   {0.93125000, 0.33482000, 0.06218000},
   {0.92623000, 0.32473000, 0.05837000},
   {0.92105000, 0.31489000, 0.05475000},
   {0.91572000, 0.30530000, 0.05134000},
   {0.91024000, 0.29599000, 0.04814000},
   {0.90463000, 0.28696000, 0.04516000},
   {0.89888000, 0.27824000, 0.04243000},
   {0.89298000, 0.26981000, 0.03993000},
   {0.88691000, 0.26152000, 0.03753000},
   {0.88066000, 0.25334000, 0.03521000},
   {0.87422000, 0.24526000, 0.03297000},
   {0.86760000, 0.23730000, 0.03082000},
   {0.86079000, 0.22945000, 0.02875000},
   {0.85380000, 0.22170000, 0.02677000},
   {0.84662000, 0.21407000, 0.02487000},
   {0.83926000, 0.20654000, 0.02305000},
   {0.83172000, 0.19912000, 0.02131000},
   {0.82399000, 0.19182000, 0.01966000},
   {0.81608000, 0.18462000, 0.01809000},
   {0.80799000, 0.17753000, 0.01660000},
   {0.79971000, 0.17055000, 0.01520000},
   {0.79125000, 0.16368000, 0.01387000},
   {0.78260000, 0.15693000, 0.01264000},
   {0.77377000, 0.15028000, 0.01148000},
   {0.76476000, 0.14374000, 0.01041000},
   {0.75556000, 0.13731000, 0.00942000},
   {0.74617000, 0.13098000, 0.00851000},
   {0.73661000, 0.12477000, 0.00769000},
   {0.72686000, 0.11867000, 0.00695000},
   {0.71692000, 0.11268000, 0.00629000},
   {0.70680000, 0.10680000, 0.00571000},
   {0.69650000, 0.10102000, 0.00522000},
   {0.68602000, 0.09536000, 0.00481000},
   {0.67535000, 0.08980000, 0.00449000},
   {0.66449000, 0.08436000, 0.00424000},
   {0.65345000, 0.07902000, 0.00408000},
   {0.64223000, 0.07380000, 0.00401000},
   {0.63082000, 0.06868000, 0.00401000},
   {0.61923000, 0.06367000, 0.00410000},
   {0.60746000, 0.05878000, 0.00427000},
   {0.59550000, 0.05399000, 0.00453000},
   {0.58336000, 0.04931000, 0.00486000},
   {0.57103000, 0.04474000, 0.00529000},
   {0.55852000, 0.04028000, 0.00579000},
   {0.54583000, 0.03593000, 0.00638000},
   {0.53295000, 0.03169000, 0.00705000},
   {0.51989000, 0.02756000, 0.00780000},
   {0.50664000, 0.02354000, 0.00863000},
   {0.49321000, 0.01963000, 0.00955000},
   {0.47960000, 0.01583000, 0.01055000}
};

// https://bids.github.io/colormap/
const int RGB_Palette_38_Size = 256; // viridis
double RGB_Palette_38[RGB_Palette_38_Size][3] =
{
   {0.267004, 0.004874, 0.329415},
   {0.268510, 0.009605, 0.335427},
   {0.269944, 0.014625, 0.341379},
   {0.271305, 0.019942, 0.347269},
   {0.272594, 0.025563, 0.353093},
   {0.273809, 0.031497, 0.358853},
   {0.274952, 0.037752, 0.364543},
   {0.276022, 0.044167, 0.370164},
   {0.277018, 0.050344, 0.375715},
   {0.277941, 0.056324, 0.381191},
   {0.278791, 0.062145, 0.386592},
   {0.279566, 0.067836, 0.391917},
   {0.280267, 0.073417, 0.397163},
   {0.280894, 0.078907, 0.402329},
   {0.281446, 0.084320, 0.407414},
   {0.281924, 0.089666, 0.412415},
   {0.282327, 0.094955, 0.417331},
   {0.282656, 0.100196, 0.422160},
   {0.282910, 0.105393, 0.426902},
   {0.283091, 0.110553, 0.431554},
   {0.283197, 0.115680, 0.436115},
   {0.283229, 0.120777, 0.440584},
   {0.283187, 0.125848, 0.444960},
   {0.283072, 0.130895, 0.449241},
   {0.282884, 0.135920, 0.453427},
   {0.282623, 0.140926, 0.457517},
   {0.282290, 0.145912, 0.461510},
   {0.281887, 0.150881, 0.465405},
   {0.281412, 0.155834, 0.469201},
   {0.280868, 0.160771, 0.472899},
   {0.280255, 0.165693, 0.476498},
   {0.279574, 0.170599, 0.479997},
   {0.278826, 0.175490, 0.483397},
   {0.278012, 0.180367, 0.486697},
   {0.277134, 0.185228, 0.489898},
   {0.276194, 0.190074, 0.493001},
   {0.275191, 0.194905, 0.496005},
   {0.274128, 0.199721, 0.498911},
   {0.273006, 0.204520, 0.501721},
   {0.271828, 0.209303, 0.504434},
   {0.270595, 0.214069, 0.507052},
   {0.269308, 0.218818, 0.509577},
   {0.267968, 0.223549, 0.512008},
   {0.266580, 0.228262, 0.514349},
   {0.265145, 0.232956, 0.516599},
   {0.263663, 0.237631, 0.518762},
   {0.262138, 0.242286, 0.520837},
   {0.260571, 0.246922, 0.522828},
   {0.258965, 0.251537, 0.524736},
   {0.257322, 0.256130, 0.526563},
   {0.255645, 0.260703, 0.528312},
   {0.253935, 0.265254, 0.529983},
   {0.252194, 0.269783, 0.531579},
   {0.250425, 0.274290, 0.533103},
   {0.248629, 0.278775, 0.534556},
   {0.246811, 0.283237, 0.535941},
   {0.244972, 0.287675, 0.537260},
   {0.243113, 0.292092, 0.538516},
   {0.241237, 0.296485, 0.539709},
   {0.239346, 0.300855, 0.540844},
   {0.237441, 0.305202, 0.541921},
   {0.235526, 0.309527, 0.542944},
   {0.233603, 0.313828, 0.543914},
   {0.231674, 0.318106, 0.544834},
   {0.229739, 0.322361, 0.545706},
   {0.227802, 0.326594, 0.546532},
   {0.225863, 0.330805, 0.547314},
   {0.223925, 0.334994, 0.548053},
   {0.221989, 0.339161, 0.548752},
   {0.220057, 0.343307, 0.549413},
   {0.218130, 0.347432, 0.550038},
   {0.216210, 0.351535, 0.550627},
   {0.214298, 0.355619, 0.551184},
   {0.212395, 0.359683, 0.551710},
   {0.210503, 0.363727, 0.552206},
   {0.208623, 0.367752, 0.552675},
   {0.206756, 0.371758, 0.553117},
   {0.204903, 0.375746, 0.553533},
   {0.203063, 0.379716, 0.553925},
   {0.201239, 0.383670, 0.554294},
   {0.199430, 0.387607, 0.554642},
   {0.197636, 0.391528, 0.554969},
   {0.195860, 0.395433, 0.555276},
   {0.194100, 0.399323, 0.555565},
   {0.192357, 0.403199, 0.555836},
   {0.190631, 0.407061, 0.556089},
   {0.188923, 0.410910, 0.556326},
   {0.187231, 0.414746, 0.556547},
   {0.185556, 0.418570, 0.556753},
   {0.183898, 0.422383, 0.556944},
   {0.182256, 0.426184, 0.557120},
   {0.180629, 0.429975, 0.557282},
   {0.179019, 0.433756, 0.557430},
   {0.177423, 0.437527, 0.557565},
   {0.175841, 0.441290, 0.557685},
   {0.174274, 0.445044, 0.557792},
   {0.172719, 0.448791, 0.557885},
   {0.171176, 0.452530, 0.557965},
   {0.169646, 0.456262, 0.558030},
   {0.168126, 0.459988, 0.558082},
   {0.166617, 0.463708, 0.558119},
   {0.165117, 0.467423, 0.558141},
   {0.163625, 0.471133, 0.558148},
   {0.162142, 0.474838, 0.558140},
   {0.160665, 0.478540, 0.558115},
   {0.159194, 0.482237, 0.558073},
   {0.157729, 0.485932, 0.558013},
   {0.156270, 0.489624, 0.557936},
   {0.154815, 0.493313, 0.557840},
   {0.153364, 0.497000, 0.557724},
   {0.151918, 0.500685, 0.557587},
   {0.150476, 0.504369, 0.557430},
   {0.149039, 0.508051, 0.557250},
   {0.147607, 0.511733, 0.557049},
   {0.146180, 0.515413, 0.556823},
   {0.144759, 0.519093, 0.556572},
   {0.143343, 0.522773, 0.556295},
   {0.141935, 0.526453, 0.555991},
   {0.140536, 0.530132, 0.555659},
   {0.139147, 0.533812, 0.555298},
   {0.137770, 0.537492, 0.554906},
   {0.136408, 0.541173, 0.554483},
   {0.135066, 0.544853, 0.554029},
   {0.133743, 0.548535, 0.553541},
   {0.132444, 0.552216, 0.553018},
   {0.131172, 0.555899, 0.552459},
   {0.129933, 0.559582, 0.551864},
   {0.128729, 0.563265, 0.551229},
   {0.127568, 0.566949, 0.550556},
   {0.126453, 0.570633, 0.549841},
   {0.125394, 0.574318, 0.549086},
   {0.124395, 0.578002, 0.548287},
   {0.123463, 0.581687, 0.547445},
   {0.122606, 0.585371, 0.546557},
   {0.121831, 0.589055, 0.545623},
   {0.121148, 0.592739, 0.544641},
   {0.120565, 0.596422, 0.543611},
   {0.120092, 0.600104, 0.542530},
   {0.119738, 0.603785, 0.541400},
   {0.119512, 0.607464, 0.540218},
   {0.119423, 0.611141, 0.538982},
   {0.119483, 0.614817, 0.537692},
   {0.119699, 0.618490, 0.536347},
   {0.120081, 0.622161, 0.534946},
   {0.120638, 0.625828, 0.533488},
   {0.121380, 0.629492, 0.531973},
   {0.122312, 0.633153, 0.530398},
   {0.123444, 0.636809, 0.528763},
   {0.124780, 0.640461, 0.527068},
   {0.126326, 0.644107, 0.525311},
   {0.128087, 0.647749, 0.523491},
   {0.130067, 0.651384, 0.521608},
   {0.132268, 0.655014, 0.519661},
   {0.134692, 0.658636, 0.517649},
   {0.137339, 0.662252, 0.515571},
   {0.140210, 0.665859, 0.513427},
   {0.143303, 0.669459, 0.511215},
   {0.146616, 0.673050, 0.508936},
   {0.150148, 0.676631, 0.506589},
   {0.153894, 0.680203, 0.504172},
   {0.157851, 0.683765, 0.501686},
   {0.162016, 0.687316, 0.499129},
   {0.166383, 0.690856, 0.496502},
   {0.170948, 0.694384, 0.493803},
   {0.175707, 0.697900, 0.491033},
   {0.180653, 0.701402, 0.488189},
   {0.185783, 0.704891, 0.485273},
   {0.191090, 0.708366, 0.482284},
   {0.196571, 0.711827, 0.479221},
   {0.202219, 0.715272, 0.476084},
   {0.208030, 0.718701, 0.472873},
   {0.214000, 0.722114, 0.469588},
   {0.220124, 0.725509, 0.466226},
   {0.226397, 0.728888, 0.462789},
   {0.232815, 0.732247, 0.459277},
   {0.239374, 0.735588, 0.455688},
   {0.246070, 0.738910, 0.452024},
   {0.252899, 0.742211, 0.448284},
   {0.259857, 0.745492, 0.444467},
   {0.266941, 0.748751, 0.440573},
   {0.274149, 0.751988, 0.436601},
   {0.281477, 0.755203, 0.432552},
   {0.288921, 0.758394, 0.428426},
   {0.296479, 0.761561, 0.424223},
   {0.304148, 0.764704, 0.419943},
   {0.311925, 0.767822, 0.415586},
   {0.319809, 0.770914, 0.411152},
   {0.327796, 0.773980, 0.406640},
   {0.335885, 0.777018, 0.402049},
   {0.344074, 0.780029, 0.397381},
   {0.352360, 0.783011, 0.392636},
   {0.360741, 0.785964, 0.387814},
   {0.369214, 0.788888, 0.382914},
   {0.377779, 0.791781, 0.377939},
   {0.386433, 0.794644, 0.372886},
   {0.395174, 0.797475, 0.367757},
   {0.404001, 0.800275, 0.362552},
   {0.412913, 0.803041, 0.357269},
   {0.421908, 0.805774, 0.351910},
   {0.430983, 0.808473, 0.346476},
   {0.440137, 0.811138, 0.340967},
   {0.449368, 0.813768, 0.335384},
   {0.458674, 0.816363, 0.329727},
   {0.468053, 0.818921, 0.323998},
   {0.477504, 0.821444, 0.318195},
   {0.487026, 0.823929, 0.312321},
   {0.496615, 0.826376, 0.306377},
   {0.506271, 0.828786, 0.300362},
   {0.515992, 0.831158, 0.294279},
   {0.525776, 0.833491, 0.288127},
   {0.535621, 0.835785, 0.281908},
   {0.545524, 0.838039, 0.275626},
   {0.555484, 0.840254, 0.269281},
   {0.565498, 0.842430, 0.262877},
   {0.575563, 0.844566, 0.256415},
   {0.585678, 0.846661, 0.249897},
   {0.595839, 0.848717, 0.243329},
   {0.606045, 0.850733, 0.236712},
   {0.616293, 0.852709, 0.230052},
   {0.626579, 0.854645, 0.223353},
   {0.636902, 0.856542, 0.216620},
   {0.647257, 0.858400, 0.209861},
   {0.657642, 0.860219, 0.203082},
   {0.668054, 0.861999, 0.196293},
   {0.678489, 0.863742, 0.189503},
   {0.688944, 0.865448, 0.182725},
   {0.699415, 0.867117, 0.175971},
   {0.709898, 0.868751, 0.169257},
   {0.720391, 0.870350, 0.162603},
   {0.730889, 0.871916, 0.156029},
   {0.741388, 0.873449, 0.149561},
   {0.751884, 0.874951, 0.143228},
   {0.762373, 0.876424, 0.137064},
   {0.772852, 0.877868, 0.131109},
   {0.783315, 0.879285, 0.125405},
   {0.793760, 0.880678, 0.120005},
   {0.804182, 0.882046, 0.114965},
   {0.814576, 0.883393, 0.110347},
   {0.824940, 0.884720, 0.106217},
   {0.835270, 0.886029, 0.102646},
   {0.845561, 0.887322, 0.099702},
   {0.855810, 0.888601, 0.097452},
   {0.866013, 0.889868, 0.095953},
   {0.876168, 0.891125, 0.095250},
   {0.886271, 0.892374, 0.095374},
   {0.896320, 0.893616, 0.096335},
   {0.906311, 0.894855, 0.098125},
   {0.916242, 0.896091, 0.100717},
   {0.926106, 0.897330, 0.104071},
   {0.935904, 0.898570, 0.108131},
   {0.945636, 0.899815, 0.112838},
   {0.955300, 0.901065, 0.118128},
   {0.964894, 0.902323, 0.123941},
   {0.974417, 0.903590, 0.130215},
   {0.983868, 0.904867, 0.136897},
   {0.993248, 0.906157, 0.143936}
};

// https://bids.github.io/colormap/
const int RGB_Palette_39_Size = 256; // plasma
double RGB_Palette_39[RGB_Palette_39_Size][3] =
{
   {0.050383, 0.029803, 0.527975},
   {0.063536, 0.028426, 0.533124},
   {0.075353, 0.027206, 0.538007},
   {0.086222, 0.026125, 0.542658},
   {0.096379, 0.025165, 0.547103},
   {0.105980, 0.024309, 0.551368},
   {0.115124, 0.023556, 0.555468},
   {0.123903, 0.022878, 0.559423},
   {0.132381, 0.022258, 0.563250},
   {0.140603, 0.021687, 0.566959},
   {0.148607, 0.021154, 0.570562},
   {0.156421, 0.020651, 0.574065},
   {0.164070, 0.020171, 0.577478},
   {0.171574, 0.019706, 0.580806},
   {0.178950, 0.019252, 0.584054},
   {0.186213, 0.018803, 0.587228},
   {0.193374, 0.018354, 0.590330},
   {0.200445, 0.017902, 0.593364},
   {0.207435, 0.017442, 0.596333},
   {0.214350, 0.016973, 0.599239},
   {0.221197, 0.016497, 0.602083},
   {0.227983, 0.016007, 0.604867},
   {0.234715, 0.015502, 0.607592},
   {0.241396, 0.014979, 0.610259},
   {0.248032, 0.014439, 0.612868},
   {0.254627, 0.013882, 0.615419},
   {0.261183, 0.013308, 0.617911},
   {0.267703, 0.012716, 0.620346},
   {0.274191, 0.012109, 0.622722},
   {0.280648, 0.011488, 0.625038},
   {0.287076, 0.010855, 0.627295},
   {0.293478, 0.010213, 0.629490},
   {0.299855, 0.009561, 0.631624},
   {0.306210, 0.008902, 0.633694},
   {0.312543, 0.008239, 0.635700},
   {0.318856, 0.007576, 0.637640},
   {0.325150, 0.006915, 0.639512},
   {0.331426, 0.006261, 0.641316},
   {0.337683, 0.005618, 0.643049},
   {0.343925, 0.004991, 0.644710},
   {0.350150, 0.004382, 0.646298},
   {0.356359, 0.003798, 0.647810},
   {0.362553, 0.003243, 0.649245},
   {0.368733, 0.002724, 0.650601},
   {0.374897, 0.002245, 0.651876},
   {0.381047, 0.001814, 0.653068},
   {0.387183, 0.001434, 0.654177},
   {0.393304, 0.001114, 0.655199},
   {0.399411, 0.000859, 0.656133},
   {0.405503, 0.000678, 0.656977},
   {0.411580, 0.000577, 0.657730},
   {0.417642, 0.000564, 0.658390},
   {0.423689, 0.000646, 0.658956},
   {0.429719, 0.000831, 0.659425},
   {0.435734, 0.001127, 0.659797},
   {0.441732, 0.001540, 0.660069},
   {0.447714, 0.002080, 0.660240},
   {0.453677, 0.002755, 0.660310},
   {0.459623, 0.003574, 0.660277},
   {0.465550, 0.004545, 0.660139},
   {0.471457, 0.005678, 0.659897},
   {0.477344, 0.006980, 0.659549},
   {0.483210, 0.008460, 0.659095},
   {0.489055, 0.010127, 0.658534},
   {0.494877, 0.011990, 0.657865},
   {0.500678, 0.014055, 0.657088},
   {0.506454, 0.016333, 0.656202},
   {0.512206, 0.018833, 0.655209},
   {0.517933, 0.021563, 0.654109},
   {0.523633, 0.024532, 0.652901},
   {0.529306, 0.027747, 0.651586},
   {0.534952, 0.031217, 0.650165},
   {0.540570, 0.034950, 0.648640},
   {0.546157, 0.038954, 0.647010},
   {0.551715, 0.043136, 0.645277},
   {0.557243, 0.047331, 0.643443},
   {0.562738, 0.051545, 0.641509},
   {0.568201, 0.055778, 0.639477},
   {0.573632, 0.060028, 0.637349},
   {0.579029, 0.064296, 0.635126},
   {0.584391, 0.068579, 0.632812},
   {0.589719, 0.072878, 0.630408},
   {0.595011, 0.077190, 0.627917},
   {0.600266, 0.081516, 0.625342},
   {0.605485, 0.085854, 0.622686},
   {0.610667, 0.090204, 0.619951},
   {0.615812, 0.094564, 0.617140},
   {0.620919, 0.098934, 0.614257},
   {0.625987, 0.103312, 0.611305},
   {0.631017, 0.107699, 0.608287},
   {0.636008, 0.112092, 0.605205},
   {0.640959, 0.116492, 0.602065},
   {0.645872, 0.120898, 0.598867},
   {0.650746, 0.125309, 0.595617},
   {0.655580, 0.129725, 0.592317},
   {0.660374, 0.134144, 0.588971},
   {0.665129, 0.138566, 0.585582},
   {0.669845, 0.142992, 0.582154},
   {0.674522, 0.147419, 0.578688},
   {0.679160, 0.151848, 0.575189},
   {0.683758, 0.156278, 0.571660},
   {0.688318, 0.160709, 0.568103},
   {0.692840, 0.165141, 0.564522},
   {0.697324, 0.169573, 0.560919},
   {0.701769, 0.174005, 0.557296},
   {0.706178, 0.178437, 0.553657},
   {0.710549, 0.182868, 0.550004},
   {0.714883, 0.187299, 0.546338},
   {0.719181, 0.191729, 0.542663},
   {0.723444, 0.196158, 0.538981},
   {0.727670, 0.200586, 0.535293},
   {0.731862, 0.205013, 0.531601},
   {0.736019, 0.209439, 0.527908},
   {0.740143, 0.213864, 0.524216},
   {0.744232, 0.218288, 0.520524},
   {0.748289, 0.222711, 0.516834},
   {0.752312, 0.227133, 0.513149},
   {0.756304, 0.231555, 0.509468},
   {0.760264, 0.235976, 0.505794},
   {0.764193, 0.240396, 0.502126},
   {0.768090, 0.244817, 0.498465},
   {0.771958, 0.249237, 0.494813},
   {0.775796, 0.253658, 0.491171},
   {0.779604, 0.258078, 0.487539},
   {0.783383, 0.262500, 0.483918},
   {0.787133, 0.266922, 0.480307},
   {0.790855, 0.271345, 0.476706},
   {0.794549, 0.275770, 0.473117},
   {0.798216, 0.280197, 0.469538},
   {0.801855, 0.284626, 0.465971},
   {0.805467, 0.289057, 0.462415},
   {0.809052, 0.293491, 0.458870},
   {0.812612, 0.297928, 0.455338},
   {0.816144, 0.302368, 0.451816},
   {0.819651, 0.306812, 0.448306},
   {0.823132, 0.311261, 0.444806},
   {0.826588, 0.315714, 0.441316},
   {0.830018, 0.320172, 0.437836},
   {0.833422, 0.324635, 0.434366},
   {0.836801, 0.329105, 0.430905},
   {0.840155, 0.333580, 0.427455},
   {0.843484, 0.338062, 0.424013},
   {0.846788, 0.342551, 0.420579},
   {0.850066, 0.347048, 0.417153},
   {0.853319, 0.351553, 0.413734},
   {0.856547, 0.356066, 0.410322},
   {0.859750, 0.360588, 0.406917},
   {0.862927, 0.365119, 0.403519},
   {0.866078, 0.369660, 0.400126},
   {0.869203, 0.374212, 0.396738},
   {0.872303, 0.378774, 0.393355},
   {0.875376, 0.383347, 0.389976},
   {0.878423, 0.387932, 0.386600},
   {0.881443, 0.392529, 0.383229},
   {0.884436, 0.397139, 0.379860},
   {0.887402, 0.401762, 0.376494},
   {0.890340, 0.406398, 0.373130},
   {0.893250, 0.411048, 0.369768},
   {0.896131, 0.415712, 0.366407},
   {0.898984, 0.420392, 0.363047},
   {0.901807, 0.425087, 0.359688},
   {0.904601, 0.429797, 0.356329},
   {0.907365, 0.434524, 0.352970},
   {0.910098, 0.439268, 0.349610},
   {0.912800, 0.444029, 0.346251},
   {0.915471, 0.448807, 0.342890},
   {0.918109, 0.453603, 0.339529},
   {0.920714, 0.458417, 0.336166},
   {0.923287, 0.463251, 0.332801},
   {0.925825, 0.468103, 0.329435},
   {0.928329, 0.472975, 0.326067},
   {0.930798, 0.477867, 0.322697},
   {0.933232, 0.482780, 0.319325},
   {0.935630, 0.487712, 0.315952},
   {0.937990, 0.492667, 0.312575},
   {0.940313, 0.497642, 0.309197},
   {0.942598, 0.502639, 0.305816},
   {0.944844, 0.507658, 0.302433},
   {0.947051, 0.512699, 0.299049},
   {0.949217, 0.517763, 0.295662},
   {0.951344, 0.522850, 0.292275},
   {0.953428, 0.527960, 0.288883},
   {0.955470, 0.533093, 0.285490},
   {0.957469, 0.538250, 0.282096},
   {0.959424, 0.543431, 0.278701},
   {0.961336, 0.548636, 0.275305},
   {0.963203, 0.553865, 0.271909},
   {0.965024, 0.559118, 0.268513},
   {0.966798, 0.564396, 0.265118},
   {0.968526, 0.569700, 0.261721},
   {0.970205, 0.575028, 0.258325},
   {0.971835, 0.580382, 0.254931},
   {0.973416, 0.585761, 0.251540},
   {0.974947, 0.591165, 0.248151},
   {0.976428, 0.596595, 0.244767},
   {0.977856, 0.602051, 0.241387},
   {0.979233, 0.607532, 0.238013},
   {0.980556, 0.613039, 0.234646},
   {0.981826, 0.618572, 0.231287},
   {0.983041, 0.624131, 0.227937},
   {0.984199, 0.629718, 0.224595},
   {0.985301, 0.635330, 0.221265},
   {0.986345, 0.640969, 0.217948},
   {0.987332, 0.646633, 0.214648},
   {0.988260, 0.652325, 0.211364},
   {0.989128, 0.658043, 0.208100},
   {0.989935, 0.663787, 0.204859},
   {0.990681, 0.669558, 0.201642},
   {0.991365, 0.675355, 0.198453},
   {0.991985, 0.681179, 0.195295},
   {0.992541, 0.687030, 0.192170},
   {0.993032, 0.692907, 0.189084},
   {0.993456, 0.698810, 0.186041},
   {0.993814, 0.704741, 0.183043},
   {0.994103, 0.710698, 0.180097},
   {0.994324, 0.716681, 0.177208},
   {0.994474, 0.722691, 0.174381},
   {0.994553, 0.728728, 0.171622},
   {0.994561, 0.734791, 0.168938},
   {0.994495, 0.740880, 0.166335},
   {0.994355, 0.746995, 0.163821},
   {0.994141, 0.753137, 0.161404},
   {0.993851, 0.759304, 0.159092},
   {0.993482, 0.765499, 0.156891},
   {0.993033, 0.771720, 0.154808},
   {0.992505, 0.777967, 0.152855},
   {0.991897, 0.784239, 0.151042},
   {0.991209, 0.790537, 0.149377},
   {0.990439, 0.796859, 0.147870},
   {0.989587, 0.803205, 0.146529},
   {0.988648, 0.809579, 0.145357},
   {0.987621, 0.815978, 0.144363},
   {0.986509, 0.822401, 0.143557},
   {0.985314, 0.828846, 0.142945},
   {0.984031, 0.835315, 0.142528},
   {0.982653, 0.841812, 0.142303},
   {0.981190, 0.848329, 0.142279},
   {0.979644, 0.854866, 0.142453},
   {0.977995, 0.861432, 0.142808},
   {0.976265, 0.868016, 0.143351},
   {0.974443, 0.874622, 0.144061},
   {0.972530, 0.881250, 0.144923},
   {0.970533, 0.887896, 0.145919},
   {0.968443, 0.894564, 0.147014},
   {0.966271, 0.901249, 0.148180},
   {0.964021, 0.907950, 0.149370},
   {0.961681, 0.914672, 0.150520},
   {0.959276, 0.921407, 0.151566},
   {0.956808, 0.928152, 0.152409},
   {0.954287, 0.934908, 0.152921},
   {0.951726, 0.941671, 0.152925},
   {0.949151, 0.948435, 0.152178},
   {0.946602, 0.955190, 0.150328},
   {0.944152, 0.961916, 0.146861},
   {0.941896, 0.968590, 0.140956},
   {0.940015, 0.975158, 0.131326}
};

// https://github.com/1313e/CMasher
const int RGB_Palette_40_Size = 511; // fusion
double RGB_Palette_40[RGB_Palette_40_Size][3] =
{
   {0.15269566, 0.01594210, 0.06988881},
   {0.15825218, 0.01698613, 0.07448610},
   {0.16381559, 0.01801391, 0.07904903},
   {0.16938824, 0.01902024, 0.08357670},
   {0.17497227, 0.02000000, 0.08806795},
   {0.18056933, 0.02094854, 0.09252115},
   {0.18618125, 0.02186079, 0.09693475},
   {0.19180964, 0.02273184, 0.10130694},
   {0.19745571, 0.02355734, 0.10563546},
   {0.20312086, 0.02433247, 0.10991812},
   {0.20880647, 0.02505241, 0.11415254},
   {0.21451331, 0.02571326, 0.11833582},
   {0.22024232, 0.02631087, 0.12246503},
   {0.22599426, 0.02684139, 0.12653697},
   {0.23176973, 0.02730126, 0.13054822},
   {0.23756918, 0.02768731, 0.13449511},
   {0.24339322, 0.02799614, 0.13837386},
   {0.24924171, 0.02822590, 0.14218023},
   {0.25511451, 0.02837495, 0.14590987},
   {0.26101189, 0.02844103, 0.14955835},
   {0.26693291, 0.02842451, 0.15312083},
   {0.27287751, 0.02832433, 0.15659247},
   {0.27884443, 0.02814220, 0.15996819},
   {0.28483274, 0.02787955, 0.16324286},
   {0.29084134, 0.02753849, 0.16641124},
   {0.29686854, 0.02712298, 0.16946810},
   {0.30291252, 0.02663769, 0.17240825},
   {0.30897122, 0.02608836, 0.17522660},
   {0.31504239, 0.02548174, 0.17791823},
   {0.32112348, 0.02482582, 0.18047848},
   {0.32721154, 0.02413013, 0.18290307},
   {0.33330350, 0.02340514, 0.18518817},
   {0.33939638, 0.02266162, 0.18733027},
   {0.34548643, 0.02191286, 0.18932678},
   {0.35157038, 0.02117156, 0.19117542},
   {0.35764438, 0.02045243, 0.19287499},
   {0.36370491, 0.01976980, 0.19442473},
   {0.36974824, 0.01913910, 0.19582493},
   {0.37577077, 0.01857585, 0.19707658},
   {0.38176904, 0.01809548, 0.19818146},
   {0.38773974, 0.01771347, 0.19914209},
   {0.39367973, 0.01744507, 0.19996177},
   {0.39958615, 0.01730503, 0.20064439},
   {0.40545640, 0.01730756, 0.20119435},
   {0.41128814, 0.01746625, 0.20161659},
   {0.41707934, 0.01779395, 0.20191636},
   {0.42282828, 0.01830274, 0.20209920},
   {0.42853351, 0.01900391, 0.20217081},
   {0.43419385, 0.01990800, 0.20213703},
   {0.43980839, 0.02102481, 0.20200373},
   {0.44537650, 0.02236329, 0.20177660},
   {0.45089772, 0.02393184, 0.20146133},
   {0.45637175, 0.02573832, 0.20106358},
   {0.46179860, 0.02778978, 0.20058845},
   {0.46717826, 0.03009310, 0.20004129},
   {0.47251097, 0.03265447, 0.19942678},
   {0.47779699, 0.03547995, 0.19874971},
   {0.48303675, 0.03857509, 0.19801427},
   {0.48823063, 0.04190477, 0.19722484},
   {0.49337920, 0.04533361, 0.19638501},
   {0.49848295, 0.04885560, 0.19549855},
   {0.50354245, 0.05246016, 0.19456891},
   {0.50855829, 0.05613794, 0.19359908},
   {0.51353106, 0.05988082, 0.19259203},
   {0.51846134, 0.06368175, 0.19155052},
   {0.52334968, 0.06753461, 0.19047725},
   {0.52819668, 0.07143406, 0.18937444},
   {0.53300287, 0.07537552, 0.18824429},
   {0.53776881, 0.07935505, 0.18708888},
   {0.54249498, 0.08336925, 0.18591011},
   {0.54718187, 0.08741520, 0.18470977},
   {0.55182995, 0.09149040, 0.18348952},
   {0.55643964, 0.09559271, 0.18225093},
   {0.56101135, 0.09972030, 0.18099554},
   {0.56554545, 0.10387162, 0.17972470},
   {0.57004228, 0.10804535, 0.17843965},
   {0.57450218, 0.11224039, 0.17714162},
   {0.57892543, 0.11645581, 0.17583175},
   {0.58331227, 0.12069081, 0.17451137},
   {0.58766296, 0.12494477, 0.17318140},
   {0.59197769, 0.12921716, 0.17184282},
   {0.59625664, 0.13350755, 0.17049678},
   {0.60049995, 0.13781560, 0.16914425},
   {0.60470775, 0.14214109, 0.16778605},
   {0.60888014, 0.14648377, 0.16642339},
   {0.61301718, 0.15084356, 0.16505701},
   {0.61711892, 0.15522035, 0.16368797},
   {0.62118537, 0.15961411, 0.16231725},
   {0.62521654, 0.16402486, 0.16094574},
   {0.62921239, 0.16845259, 0.15957459},
   {0.63317286, 0.17289743, 0.15820467},
   {0.63709789, 0.17735940, 0.15683719},
   {0.64098737, 0.18183867, 0.15547315},
   {0.64484118, 0.18633534, 0.15411376},
   {0.64865919, 0.19084955, 0.15276021},
   {0.65244121, 0.19538149, 0.15141373},
   {0.65618709, 0.19993128, 0.15007576},
   {0.65989658, 0.20449916, 0.14874755},
   {0.66356950, 0.20908526, 0.14743075},
   {0.66720557, 0.21368981, 0.14612684},
   {0.67080453, 0.21831301, 0.14483750},
   {0.67436611, 0.22295502, 0.14356461},
   {0.67788999, 0.22761609, 0.14230996},
   {0.68137585, 0.23229639, 0.14107563},
   {0.68482337, 0.23699614, 0.13986380},
   {0.68823217, 0.24171554, 0.13867669},
   {0.69160188, 0.24645478, 0.13751682},
   {0.69493213, 0.25121406, 0.13638677},
   {0.69822249, 0.25599358, 0.13528928},
   {0.70147255, 0.26079351, 0.13422734},
   {0.70468187, 0.26561404, 0.13320407},
   {0.70785001, 0.27045535, 0.13222275},
   {0.71097649, 0.27531759, 0.13128691},
   {0.71406086, 0.28020092, 0.13040026},
   {0.71710262, 0.28510549, 0.12956671},
   {0.72010127, 0.29003143, 0.12879035},
   {0.72305631, 0.29497887, 0.12807554},
   {0.72596723, 0.29994790, 0.12742676},
   {0.72883351, 0.30493864, 0.12684874},
   {0.73165462, 0.30995115, 0.12634639},
   {0.73443003, 0.31498551, 0.12592479},
   {0.73715922, 0.32004174, 0.12558920},
   {0.73984165, 0.32511988, 0.12534501},
   {0.74247679, 0.33021994, 0.12519777},
   {0.74506413, 0.33534188, 0.12515309},
   {0.74760315, 0.34048567, 0.12521671},
   {0.75009333, 0.34565125, 0.12539436},
   {0.75253419, 0.35083851, 0.12569182},
   {0.75492525, 0.35604733, 0.12611484},
   {0.75726603, 0.36127756, 0.12666908},
   {0.75955612, 0.36652901, 0.12736013},
   {0.76179510, 0.37180145, 0.12819340},
   {0.76398258, 0.37709464, 0.12917414},
   {0.76611821, 0.38240828, 0.13030734},
   {0.76820170, 0.38774203, 0.13159774},
   {0.77023277, 0.39309552, 0.13304977},
   {0.77221122, 0.39846833, 0.13466751},
   {0.77413687, 0.40386001, 0.13645469},
   {0.77600962, 0.40927004, 0.13841463},
   {0.77782945, 0.41469787, 0.14055024},
   {0.77959637, 0.42014290, 0.14286400},
   {0.78131049, 0.42560450, 0.14535795},
   {0.78297201, 0.43108193, 0.14803371},
   {0.78458119, 0.43657447, 0.15089242},
   {0.78613838, 0.44208132, 0.15393484},
   {0.78764406, 0.44760163, 0.15716125},
   {0.78909879, 0.45313449, 0.16057155},
   {0.79050321, 0.45867899, 0.16416524},
   {0.79185809, 0.46423414, 0.16794145},
   {0.79316437, 0.46979884, 0.17189894},
   {0.79442299, 0.47537209, 0.17603613},
   {0.79563505, 0.48095278, 0.18035117},
   {0.79680179, 0.48653975, 0.18484187},
   {0.79792464, 0.49213177, 0.18950575},
   {0.79900496, 0.49772771, 0.19434016},
   {0.80004432, 0.50332634, 0.19934218},
   {0.80104441, 0.50892642, 0.20450869},
   {0.80200701, 0.51452672, 0.20983640},
   {0.80293413, 0.52012589, 0.21532172},
   {0.80382766, 0.52572276, 0.22096109},
   {0.80468967, 0.53131609, 0.22675077},
   {0.80552232, 0.53690464, 0.23268687},
   {0.80632783, 0.54248721, 0.23876543},
   {0.80710851, 0.54806261, 0.24498237},
   {0.80786670, 0.55362968, 0.25133358},
   {0.80860481, 0.55918732, 0.25781488},
   {0.80932526, 0.56473444, 0.26442207},
   {0.81003050, 0.57027003, 0.27115092},
   {0.81072299, 0.57579311, 0.27799721},
   {0.81140518, 0.58130277, 0.28495673},
   {0.81207972, 0.58679806, 0.29202509},
   {0.81274908, 0.59227815, 0.29919806},
   {0.81341552, 0.59774241, 0.30647173},
   {0.81408137, 0.60319018, 0.31384208},
   {0.81474926, 0.60862071, 0.32130478},
   {0.81542167, 0.61403338, 0.32885569},
   {0.81610036, 0.61942795, 0.33649157},
   {0.81678817, 0.62480368, 0.34420784},
   {0.81748695, 0.63016037, 0.35200121},
   {0.81819885, 0.63549767, 0.35986798},
   {0.81892611, 0.64081526, 0.36780440},
   {0.81967060, 0.64611297, 0.37580716},
   {0.82043411, 0.65139072, 0.38387313},
   {0.82121909, 0.65664815, 0.39199823},
   {0.82202656, 0.66188554, 0.40018042},
   {0.82285870, 0.66710267, 0.40841599},
   {0.82371744, 0.67229949, 0.41670163},
   {0.82460384, 0.67747627, 0.42503525},
   {0.82551949, 0.68263309, 0.43341401},
   {0.82646594, 0.68777007, 0.44183516},
   {0.82744484, 0.69288728, 0.45029574},
   {0.82845747, 0.69798494, 0.45879337},
   {0.82950490, 0.70306338, 0.46732598},
   {0.83058837, 0.70812283, 0.47589127},
   {0.83170905, 0.71316357, 0.48448704},
   {0.83286801, 0.71818592, 0.49311119},
   {0.83406629, 0.72319019, 0.50176173},
   {0.83530503, 0.72817668, 0.51043647},
   {0.83658533, 0.73314569, 0.51913321},
   {0.83790779, 0.73809768, 0.52785070},
   {0.83927317, 0.74303306, 0.53658732},
   {0.84068221, 0.74795225, 0.54534156},
   {0.84213588, 0.75285557, 0.55411142},
   {0.84363540, 0.75774329, 0.56289444},
   {0.84518059, 0.76261608, 0.57169073},
   {0.84677218, 0.76747433, 0.58049871},
   {0.84841181, 0.77231818, 0.58931505},
   {0.85009872, 0.77714844, 0.59814098},
   {0.85183442, 0.78196527, 0.60697334},
   {0.85361898, 0.78676924, 0.61581180},
   {0.85545300, 0.79156074, 0.62465496},
   {0.85733708, 0.79634019, 0.63350137},
   {0.85927157, 0.80110804, 0.64235012},
   {0.86125682, 0.80586474, 0.65120031},
   {0.86329372, 0.81061062, 0.66004984},
   {0.86538175, 0.81534633, 0.66889970},
   {0.86752270, 0.82007195, 0.67774580},
   {0.86971583, 0.82478816, 0.68658960},
   {0.87196152, 0.82949538, 0.69543018},
   {0.87426133, 0.83419375, 0.70426386},
   {0.87661459, 0.83888389, 0.71309208},
   {0.87902177, 0.84356618, 0.72191377},
   {0.88148352, 0.84824093, 0.73072734},
   {0.88400075, 0.85290842, 0.73953068},
   {0.88657330, 0.85756911, 0.74832427},
   {0.88920173, 0.86222332, 0.75710696},
   {0.89188662, 0.86687134, 0.76587761},
   {0.89462859, 0.87151346, 0.77463504},
   {0.89742844, 0.87614990, 0.78337778},
   {0.90028705, 0.88078089, 0.79210422},
   {0.90320498, 0.88540665, 0.80081379},
   {0.90618322, 0.89002734, 0.80950508},
   {0.90922288, 0.89464305, 0.81817656},
   {0.91232527, 0.89925383, 0.82682655},
   {0.91549189, 0.90385964, 0.83545317},
   {0.91872454, 0.90846037, 0.84405428},
   {0.92202532, 0.91305582, 0.85262744},
   {0.92539674, 0.91764567, 0.86116973},
   {0.92884183, 0.92222945, 0.86967767},
   {0.93236418, 0.92680655, 0.87814698},
   {0.93596810, 0.93137619, 0.88657233},
   {0.93965884, 0.93593743, 0.89494635},
   {0.94344228, 0.94048919, 0.90326058},
   {0.94732508, 0.94503036, 0.91150406},
   {0.95131441, 0.94955998, 0.91966230},
   {0.95541703, 0.95407768, 0.92771676},
   {0.95963758, 0.95858437, 0.93564471},
   {0.96397569, 0.96308327, 0.94342013},
   {0.96842214, 0.96758121, 0.95101597},
   {0.97295466, 0.97208912, 0.95841520},
   {0.97753779, 0.97662151, 0.96561627},
   {0.98212842, 0.98119340, 0.97264191},
   {0.98668707, 0.98581600, 0.97953727},
   {0.99118833, 0.99049355, 0.98636053},
   {0.99562415, 0.99522369, 0.99316724},
   {1.00000000, 1.00000000, 1.00000000},
   {0.99286734, 0.99599371, 0.99614812},
   {0.98570140, 0.99201791, 0.99234019},
   {0.97850515, 0.98807093, 0.98857653},
   {0.97128081, 0.98415141, 0.98485747},
   {0.96403006, 0.98025821, 0.98118332},
   {0.95675420, 0.97639033, 0.97755440},
   {0.94945423, 0.97254691, 0.97397106},
   {0.94213095, 0.96872714, 0.97043361},
   {0.93478417, 0.96493058, 0.96694278},
   {0.92741484, 0.96115639, 0.96349871},
   {0.92002357, 0.95740386, 0.96010167},
   {0.91261066, 0.95367238, 0.95675205},
   {0.90517530, 0.94996172, 0.95345071},
   {0.89771808, 0.94627115, 0.95019787},
   {0.89023961, 0.94259997, 0.94699371},
   {0.88273889, 0.93894800, 0.94383920},
   {0.87521615, 0.93531462, 0.94073469},
   {0.86767223, 0.93169907, 0.93768025},
   {0.86010488, 0.92810149, 0.93467745},
   {0.85251625, 0.92452070, 0.93172572},
   {0.84490442, 0.92095675, 0.92882652},
   {0.83727062, 0.91740873, 0.92597970},
   {0.82961330, 0.91387653, 0.92318658},
   {0.82193388, 0.91035919, 0.92044693},
   {0.81423010, 0.90685681, 0.91776249},
   {0.80650377, 0.90336829, 0.91513282},
   {0.79875363, 0.89989342, 0.91255918},
   {0.79097948, 0.89643167, 0.91004225},
   {0.78318199, 0.89298227, 0.90758225},
   {0.77536055, 0.88954478, 0.90518014},
   {0.76751441, 0.88611881, 0.90283699},
   {0.75964444, 0.88270351, 0.90055296},
   {0.75175053, 0.87929829, 0.89832878},
   {0.74383262, 0.87590255, 0.89616521},
   {0.73589072, 0.87251564, 0.89406298},
   {0.72792492, 0.86913691, 0.89202278},
   {0.71993521, 0.86576571, 0.89004544},
   {0.71192219, 0.86240124, 0.88813142},
   {0.70388623, 0.85904276, 0.88628135},
   {0.69582754, 0.85568955, 0.88449599},
   {0.68774673, 0.85234079, 0.88277592},
   {0.67964457, 0.84899564, 0.88112162},
   {0.67152191, 0.84565322, 0.87953357},
   {0.66337974, 0.84231265, 0.87801219},
   {0.65521921, 0.83897298, 0.87655784},
   {0.64704068, 0.83563346, 0.87517148},
   {0.63884614, 0.83229298, 0.87385299},
   {0.63063758, 0.82895047, 0.87260229},
   {0.62241561, 0.82560511, 0.87142035},
   {0.61418307, 0.82225567, 0.87030656},
   {0.60594176, 0.81890115, 0.86926118},
   {0.59769403, 0.81554044, 0.86828407},
   {0.58944247, 0.81217242, 0.86737501},
   {0.58119025, 0.80879588, 0.86653338},
   {0.57293967, 0.80540980, 0.86575933},
   {0.56469499, 0.80201285, 0.86505150},
   {0.55645949, 0.79860391, 0.86440940},
   {0.54823663, 0.79518185, 0.86383250},
   {0.54003116, 0.79174538, 0.86331922},
   {0.53184747, 0.78829334, 0.86286840},
   {0.52369022, 0.78482455, 0.86247868},
   {0.51556437, 0.78133787, 0.86214854},
   {0.50747510, 0.77783215, 0.86187634},
   {0.49942800, 0.77430627, 0.86166013},
   {0.49142890, 0.77075916, 0.86149781},
   {0.48348378, 0.76718977, 0.86138716},
   {0.47559884, 0.76359711, 0.86132585},
   {0.46778040, 0.75998024, 0.86131146},
   {0.46003500, 0.75633830, 0.86134138},
   {0.45236936, 0.75267044, 0.86141286},
   {0.44479028, 0.74897593, 0.86152307},
   {0.43730459, 0.74525408, 0.86166912},
   {0.42991920, 0.74150429, 0.86184809},
   {0.42264101, 0.73772603, 0.86205698},
   {0.41547682, 0.73391885, 0.86229290},
   {0.40843352, 0.73008237, 0.86255277},
   {0.40151789, 0.72621630, 0.86283355},
   {0.39473655, 0.72232041, 0.86313228},
   {0.38809598, 0.71839456, 0.86344609},
   {0.38160250, 0.71443865, 0.86377213},
   {0.37526225, 0.71045270, 0.86410756},
   {0.36908114, 0.70643673, 0.86444972},
   {0.36306481, 0.70239086, 0.86479601},
   {0.35721866, 0.69831525, 0.86514393},
   {0.35154777, 0.69421011, 0.86549111},
   {0.34605694, 0.69007569, 0.86583531},
   {0.34075062, 0.68591227, 0.86617437},
   {0.33563291, 0.68172019, 0.86650626},
   {0.33070754, 0.67749978, 0.86682914},
   {0.32597787, 0.67325141, 0.86714125},
   {0.32144684, 0.66897547, 0.86744092},
   {0.31711700, 0.66467238, 0.86772661},
   {0.31299046, 0.66034252, 0.86799697},
   {0.30906887, 0.65598631, 0.86825072},
   {0.30535347, 0.65160416, 0.86848667},
   {0.30184500, 0.64719650, 0.86870371},
   {0.29854375, 0.64276372, 0.86890085},
   {0.29544956, 0.63830622, 0.86907725},
   {0.29256178, 0.63382438, 0.86923211},
   {0.28987929, 0.62931858, 0.86936472},
   {0.28740051, 0.62478917, 0.86947441},
   {0.28512341, 0.62023651, 0.86956060},
   {0.28304548, 0.61566092, 0.86962274},
   {0.28116383, 0.61106270, 0.86966040},
   {0.27947513, 0.60644214, 0.86967318},
   {0.27797569, 0.60179951, 0.86966073},
   {0.27666143, 0.59713504, 0.86962272},
   {0.27552793, 0.59244896, 0.86955888},
   {0.27457047, 0.58774146, 0.86946893},
   {0.27378405, 0.58301273, 0.86935267},
   {0.27316343, 0.57826292, 0.86920990},
   {0.27270315, 0.57349216, 0.86904042},
   {0.27239757, 0.56870055, 0.86884409},
   {0.27224091, 0.56388818, 0.86862073},
   {0.27222727, 0.55905510, 0.86837022},
   {0.27235069, 0.55420136, 0.86809242},
   {0.27260513, 0.54932696, 0.86778718},
   {0.27298455, 0.54443190, 0.86745438},
   {0.27348292, 0.53951613, 0.86709387},
   {0.27409422, 0.53457961, 0.86670552},
   {0.27481251, 0.52962225, 0.86628917},
   {0.27563190, 0.52464394, 0.86584466},
   {0.27654662, 0.51964457, 0.86537182},
   {0.27755099, 0.51462399, 0.86487045},
   {0.27863945, 0.50958201, 0.86434035},
   {0.27980659, 0.50451846, 0.86378130},
   {0.28104713, 0.49943311, 0.86319304},
   {0.28235594, 0.49432573, 0.86257530},
   {0.28372807, 0.48919605, 0.86192779},
   {0.28515870, 0.48404380, 0.86125019},
   {0.28664319, 0.47886866, 0.86054215},
   {0.28817706, 0.47367032, 0.85980329},
   {0.28975598, 0.46844842, 0.85903319},
   {0.29137580, 0.46320260, 0.85823140},
   {0.29303250, 0.45793246, 0.85739743},
   {0.29472223, 0.45263759, 0.85653076},
   {0.29644130, 0.44731755, 0.85563081},
   {0.29818615, 0.44197190, 0.85469698},
   {0.29995337, 0.43660014, 0.85372861},
   {0.30173966, 0.43120178, 0.85272499},
   {0.30354187, 0.42577630, 0.85168538},
   {0.30535698, 0.42032315, 0.85060895},
   {0.30718208, 0.41484175, 0.84949487},
   {0.30901435, 0.40933154, 0.84834220},
   {0.31085108, 0.40379189, 0.84714995},
   {0.31268965, 0.39822218, 0.84591709},
   {0.31452753, 0.39262176, 0.84464249},
   {0.31636229, 0.38698995, 0.84332498},
   {0.31819155, 0.38132607, 0.84196330},
   {0.32001300, 0.37562939, 0.84055611},
   {0.32182440, 0.36989919, 0.83910199},
   {0.32362357, 0.36413471, 0.83759945},
   {0.32540842, 0.35833516, 0.83604691},
   {0.32717680, 0.35249976, 0.83444267},
   {0.32892666, 0.34662771, 0.83278494},
   {0.33065594, 0.34071820, 0.83107184},
   {0.33236262, 0.33477038, 0.82930136},
   {0.33404470, 0.32878343, 0.82747138},
   {0.33570018, 0.32275648, 0.82557967},
   {0.33732703, 0.31668868, 0.82362385},
   {0.33892344, 0.31057909, 0.82160147},
   {0.34048732, 0.30442687, 0.81950987},
   {0.34201654, 0.29823123, 0.81734622},
   {0.34350900, 0.29199133, 0.81510757},
   {0.34496286, 0.28570623, 0.81279086},
   {0.34637591, 0.27937515, 0.81039277},
   {0.34774576, 0.27299746, 0.80790978},
   {0.34907049, 0.26657226, 0.80533828},
   {0.35034765, 0.26009898, 0.80267437},
   {0.35157477, 0.25357710, 0.79991393},
   {0.35274974, 0.24700593, 0.79705268},
   {0.35386957, 0.24038540, 0.79408603},
   {0.35493209, 0.23371498, 0.79100920},
   {0.35593417, 0.22699489, 0.78781709},
   {0.35687304, 0.22022524, 0.78450439},
   {0.35774590, 0.21340635, 0.78106545},
   {0.35854927, 0.20653923, 0.77749437},
   {0.35927989, 0.19962502, 0.77378495},
   {0.35993451, 0.19266520, 0.76993060},
   {0.36050928, 0.18566214, 0.76592451},
   {0.36100028, 0.17861881, 0.76175953},
   {0.36140342, 0.17153899, 0.75742820},
   {0.36171435, 0.16442749, 0.75292275},
   {0.36192848, 0.15729037, 0.74823513},
   {0.36204093, 0.15013519, 0.74335708},
   {0.36204673, 0.14297118, 0.73827997},
   {0.36194040, 0.13580989, 0.73299516},
   {0.36171608, 0.12866551, 0.72749406},
   {0.36136795, 0.12155514, 0.72176784},
   {0.36088975, 0.11449965, 0.71580795},
   {0.36027488, 0.10752429, 0.70960628},
   {0.35951665, 0.10065933, 0.70315520},
   {0.35860825, 0.09394083, 0.69644767},
   {0.35754257, 0.08741135, 0.68947827},
   {0.35631270, 0.08112040, 0.68224270},
   {0.35491188, 0.07512464, 0.67473859},
   {0.35333367, 0.06948733, 0.66696587},
   {0.35157216, 0.06427682, 0.65892725},
   {0.34962224, 0.05956371, 0.65062860},
   {0.34747984, 0.05541636, 0.64207929},
   {0.34514220, 0.05189493, 0.63329238},
   {0.34260814, 0.04904439, 0.62428467},
   {0.33987821, 0.04688785, 0.61507656},
   {0.33695485, 0.04542168, 0.60569166},
   {0.33384244, 0.04461402, 0.59615620},
   {0.33054719, 0.04440736, 0.58649826},
   {0.32707699, 0.04472460, 0.57674681},
   {0.32344118, 0.04547712, 0.56693081},
   {0.31965016, 0.04657302, 0.55707817},
   {0.31571506, 0.04792403, 0.54721501},
   {0.31164748, 0.04944885, 0.53736593},
   {0.30745900, 0.05107806, 0.52755208},
   {0.30316106, 0.05275303, 0.51779232},
   {0.29876453, 0.05442732, 0.50810188},
   {0.29427986, 0.05606322, 0.49849429},
   {0.28971686, 0.05763199, 0.48898038},
   {0.28508450, 0.05911251, 0.47956842},
   {0.28039092, 0.06048993, 0.47026435},
   {0.27564340, 0.06175448, 0.46107205},
   {0.27084884, 0.06289865, 0.45199509},
   {0.26601325, 0.06391846, 0.44303518},
   {0.26114211, 0.06481189, 0.43419322},
   {0.25623998, 0.06557967, 0.42546825},
   {0.25131127, 0.06622224, 0.41685990},
   {0.24635989, 0.06674117, 0.40836707},
   {0.24138922, 0.06713884, 0.39998800},
   {0.23640219, 0.06741821, 0.39172046},
   {0.23140135, 0.06758265, 0.38356178},
   {0.22638882, 0.06763578, 0.37550902},
   {0.22136723, 0.06757936, 0.36756094},
   {0.21633793, 0.06741776, 0.35971365},
   {0.21130262, 0.06715380, 0.35196469},
   {0.20626253, 0.06679084, 0.34431091},
   {0.20121936, 0.06633069, 0.33675064},
   {0.19617350, 0.06577759, 0.32927959},
   {0.19112598, 0.06513382, 0.32189534},
   {0.18607797, 0.06440103, 0.31459602},
   {0.18102995, 0.06358187, 0.30737861},
   {0.17598229, 0.06267883, 0.30024012},
   {0.17093544, 0.06169384, 0.29317803},
   {0.16588972, 0.06062873, 0.28618983},
   {0.16084537, 0.05948518, 0.27927302},
   {0.15580287, 0.05826412, 0.27242584},
   {0.15076217, 0.05696715, 0.26564568},
   {0.14572304, 0.05559583, 0.25892982},
   {0.14068532, 0.05415133, 0.25227586},
   {0.13564929, 0.05263380, 0.24568244},
   {0.13061484, 0.05104378, 0.23914760},
   {0.12558094, 0.04938293, 0.23266799},
   {0.12054835, 0.04764989, 0.22624353},
   {0.11551573, 0.04584618, 0.21987072},
   {0.11048325, 0.04397075, 0.21354882},
   {0.10544988, 0.04202398, 0.20727521},
   {0.10041564, 0.03999828, 0.20104928},
   {0.09537889, 0.03791701, 0.19486783}
};

// https://github.com/1313e/CMasher
const int RGB_Palette_41_Size = 511; // iceburn
double RGB_Palette_41[RGB_Palette_41_Size][3] =
{
   {5.78692840e-01, 9.47004534e-01, 9.53835089e-01},
   {5.73300958e-01, 9.42448134e-01, 9.52185844e-01},
   {5.67904138e-01, 9.37906186e-01, 9.50550251e-01},
   {5.62501828e-01, 9.33378441e-01, 9.48929504e-01},
   {5.57094001e-01, 9.28864700e-01, 9.47323254e-01},
   {5.51680262e-01, 9.24364725e-01, 9.45732234e-01},
   {5.46260408e-01, 9.19878293e-01, 9.44156633e-01},
   {5.40834283e-01, 9.15405185e-01, 9.42596495e-01},
   {5.35401418e-01, 9.10945148e-01, 9.41052774e-01},
   {5.29961833e-01, 9.06497972e-01, 9.39525036e-01},
   {5.24515168e-01, 9.02063412e-01, 9.38013919e-01},
   {5.19061153e-01, 8.97641224e-01, 9.36519804e-01},
   {5.13599714e-01, 8.93231185e-01, 9.35042546e-01},
   {5.08130514e-01, 8.88833041e-01, 9.33582712e-01},
   {5.02653292e-01, 8.84446544e-01, 9.32140656e-01},
   {4.97167970e-01, 8.80071461e-01, 9.30716251e-01},
   {4.91674325e-01, 8.75707544e-01, 9.29309753e-01},
   {4.86171948e-01, 8.71354522e-01, 9.27921902e-01},
   {4.80660799e-01, 8.67012158e-01, 9.26552467e-01},
   {4.75140686e-01, 8.62680199e-01, 9.25201622e-01},
   {4.69611394e-01, 8.58358385e-01, 9.23869585e-01},
   {4.64072657e-01, 8.54046451e-01, 9.22556718e-01},
   {4.58524236e-01, 8.49744130e-01, 9.21263293e-01},
   {4.52966030e-01, 8.45451166e-01, 9.19989242e-01},
   {4.47397837e-01, 8.41167290e-01, 9.18734745e-01},
   {4.41819459e-01, 8.36892232e-01, 9.17499973e-01},
   {4.36230702e-01, 8.32625718e-01, 9.16285085e-01},
   {4.30631373e-01, 8.28367471e-01, 9.15090231e-01},
   {4.25021288e-01, 8.24117213e-01, 9.13915551e-01},
   {4.19400262e-01, 8.19874661e-01, 9.12761172e-01},
   {4.13768119e-01, 8.15639529e-01, 9.11627211e-01},
   {4.08124687e-01, 8.11411529e-01, 9.10513772e-01},
   {4.02469802e-01, 8.07190370e-01, 9.09420950e-01},
   {3.96803304e-01, 8.02975757e-01, 9.08348825e-01},
   {3.91125045e-01, 7.98767391e-01, 9.07297464e-01},
   {3.85434884e-01, 7.94564972e-01, 9.06266924e-01},
   {3.79732689e-01, 7.90368192e-01, 9.05257244e-01},
   {3.74018344e-01, 7.86176744e-01, 9.04268451e-01},
   {3.68291742e-01, 7.81990315e-01, 9.03300558e-01},
   {3.62552792e-01, 7.77808588e-01, 9.02353560e-01},
   {3.56801422e-01, 7.73631242e-01, 9.01427436e-01},
   {3.51037448e-01, 7.69457933e-01, 9.00522481e-01},
   {3.45260887e-01, 7.65288338e-01, 8.99638516e-01},
   {3.39471788e-01, 7.61122132e-01, 8.98775317e-01},
   {3.33670169e-01, 7.56958978e-01, 8.97932792e-01},
   {3.27855879e-01, 7.52798495e-01, 8.97111369e-01},
   {3.22029122e-01, 7.48640355e-01, 8.96310603e-01},
   {3.16190082e-01, 7.44484220e-01, 8.95530166e-01},
   {3.10338662e-01, 7.40329674e-01, 8.94770632e-01},
   {3.04475280e-01, 7.36176394e-01, 8.94031249e-01},
   {2.98600109e-01, 7.32023987e-01, 8.93312085e-01},
   {2.92713429e-01, 7.27872062e-01, 8.92613085e-01},
   {2.86815720e-01, 7.23720253e-01, 8.91933779e-01},
   {2.80907351e-01, 7.19568136e-01, 8.91274268e-01},
   {2.74988962e-01, 7.15415329e-01, 8.90634084e-01},
   {2.69061237e-01, 7.11261425e-01, 8.90012916e-01},
   {2.63124858e-01, 7.07105970e-01, 8.89410864e-01},
   {2.57180924e-01, 7.02948593e-01, 8.88827028e-01},
   {2.51230430e-01, 6.98788826e-01, 8.88261402e-01},
   {2.45274625e-01, 6.94626213e-01, 8.87713728e-01},
   {2.39315083e-01, 6.90460341e-01, 8.87183219e-01},
   {2.33353507e-01, 6.86290746e-01, 8.86669459e-01},
   {2.27391881e-01, 6.82116958e-01, 8.86171983e-01},
   {2.21432481e-01, 6.77938476e-01, 8.85690423e-01},
   {2.15477996e-01, 6.73754829e-01, 8.85224061e-01},
   {2.09531518e-01, 6.69565533e-01, 8.84772141e-01},
   {2.03596591e-01, 6.65370084e-01, 8.84333945e-01},
   {1.97677299e-01, 6.61167973e-01, 8.83908683e-01},
   {1.91778351e-01, 6.56958680e-01, 8.83495480e-01},
   {1.85905169e-01, 6.52741636e-01, 8.83093687e-01},
   {1.80064006e-01, 6.48516336e-01, 8.82702059e-01},
   {1.74262029e-01, 6.44282242e-01, 8.82319418e-01},
   {1.68507468e-01, 6.40038815e-01, 8.81944496e-01},
   {1.62809859e-01, 6.35785434e-01, 8.81576365e-01},
   {1.57180072e-01, 6.31521552e-01, 8.81213460e-01},
   {1.51630475e-01, 6.27246648e-01, 8.80853939e-01},
   {1.46175578e-01, 6.22960017e-01, 8.80496851e-01},
   {1.40831375e-01, 6.18661207e-01, 8.80139636e-01},
   {1.35616639e-01, 6.14349529e-01, 8.79780903e-01},
   {1.30552271e-01, 6.10024426e-01, 8.79418327e-01},
   {1.25661794e-01, 6.05685341e-01, 8.79049446e-01},
   {1.20971707e-01, 6.01331668e-01, 8.78671861e-01},
   {1.16511563e-01, 5.96962778e-01, 8.78283072e-01},
   {1.12313402e-01, 5.92578135e-01, 8.77879944e-01},
   {1.08411955e-01, 5.88177194e-01, 8.77459198e-01},
   {1.04844299e-01, 5.83759401e-01, 8.77017401e-01},
   {1.01649143e-01, 5.79324204e-01, 8.76550875e-01},
   {9.88650977e-02, 5.74871174e-01, 8.76055248e-01},
   {9.65299433e-02, 5.70399900e-01, 8.75525883e-01},
   {9.46800608e-02, 5.65909873e-01, 8.74958273e-01},
   {9.33458797e-02, 5.61400868e-01, 8.74346664e-01},
   {9.25534686e-02, 5.56872508e-01, 8.73685607e-01},
   {9.23193790e-02, 5.52324723e-01, 8.72968423e-01},
   {9.26524359e-02, 5.47757391e-01, 8.72188384e-01},
   {9.35518714e-02, 5.43170516e-01, 8.71338162e-01},
   {9.50066950e-02, 5.38564305e-01, 8.70409626e-01},
   {9.69974085e-02, 5.33939078e-01, 8.69394153e-01},
   {9.94960176e-02, 5.29295411e-01, 8.68282281e-01},
   {1.02468098e-01, 5.24634109e-01, 8.67063874e-01},
   {1.05875414e-01, 5.19956133e-01, 8.65728330e-01},
   {1.09675761e-01, 5.15262814e-01, 8.64264188e-01},
   {1.13825799e-01, 5.10555737e-01, 8.62659495e-01},
   {1.18280497e-01, 5.05836943e-01, 8.60901548e-01},
   {1.22995807e-01, 5.01108771e-01, 8.58977360e-01},
   {1.27928180e-01, 4.96373991e-01, 8.56873612e-01},
   {1.33034952e-01, 4.91635812e-01, 8.54576873e-01},
   {1.38274606e-01, 4.86897881e-01, 8.52073885e-01},
   {1.43607170e-01, 4.82164234e-01, 8.49351901e-01},
   {1.48994245e-01, 4.77439269e-01, 8.46399020e-01},
   {1.54397994e-01, 4.72727808e-01, 8.43204529e-01},
   {1.59783445e-01, 4.68034774e-01, 8.39759425e-01},
   {1.65116349e-01, 4.63365350e-01, 8.36056706e-01},
   {1.70365215e-01, 4.58724648e-01, 8.32091774e-01},
   {1.75500824e-01, 4.54117670e-01, 8.27862671e-01},
   {1.80496667e-01, 4.49549147e-01, 8.23370253e-01},
   {1.85329435e-01, 4.45023391e-01, 8.18618195e-01},
   {1.89978991e-01, 4.40544209e-01, 8.13612915e-01},
   {1.94429078e-01, 4.36114753e-01, 8.08363251e-01},
   {1.98666394e-01, 4.31737576e-01, 8.02880303e-01},
   {2.02681886e-01, 4.27414456e-01, 7.97176723e-01},
   {2.06468728e-01, 4.23146613e-01, 7.91266744e-01},
   {2.10024161e-01, 4.18934517e-01, 7.85165130e-01},
   {2.13347437e-01, 4.14778131e-01, 7.78887270e-01},
   {2.16440070e-01, 4.10676919e-01, 7.72448643e-01},
   {2.19305491e-01, 4.06629916e-01, 7.65864489e-01},
   {2.21948709e-01, 4.02635810e-01, 7.59149540e-01},
   {2.24375980e-01, 3.98693013e-01, 7.52317815e-01},
   {2.26593924e-01, 3.94799781e-01, 7.45382836e-01},
   {2.28610197e-01, 3.90954195e-01, 7.38357023e-01},
   {2.30432432e-01, 3.87154276e-01, 7.31252161e-01},
   {2.32068926e-01, 3.83397966e-01, 7.24078812e-01},
   {2.33527523e-01, 3.79683233e-01, 7.16847009e-01},
   {2.34816084e-01, 3.76008051e-01, 7.09565901e-01},
   {2.35942398e-01, 3.72370426e-01, 7.02243776e-01},
   {2.36914105e-01, 3.68768412e-01, 6.94888104e-01},
   {2.37738643e-01, 3.65200126e-01, 6.87505580e-01},
   {2.38422282e-01, 3.61663789e-01, 6.80103136e-01},
   {2.38972594e-01, 3.58157636e-01, 6.72685501e-01},
   {2.39395009e-01, 3.54680041e-01, 6.65258749e-01},
   {2.39696225e-01, 3.51229407e-01, 6.57826776e-01},
   {2.39881773e-01, 3.47804242e-01, 6.50393943e-01},
   {2.39956943e-01, 3.44403123e-01, 6.42964150e-01},
   {2.39926779e-01, 3.41024699e-01, 6.35540879e-01},
   {2.39796090e-01, 3.37667689e-01, 6.28127227e-01},
   {2.39569444e-01, 3.34330882e-01, 6.20725937e-01},
   {2.39251183e-01, 3.31013128e-01, 6.13339431e-01},
   {2.38845424e-01, 3.27713344e-01, 6.05969844e-01},
   {2.38355808e-01, 3.24430499e-01, 5.98619437e-01},
   {2.37785799e-01, 3.21163615e-01, 5.91290231e-01},
   {2.37139189e-01, 3.17911780e-01, 5.83983238e-01},
   {2.36418594e-01, 3.14674104e-01, 5.76700831e-01},
   {2.35627508e-01, 3.11449771e-01, 5.69443559e-01},
   {2.34768626e-01, 3.08237993e-01, 5.62212823e-01},
   {2.33844361e-01, 3.05038009e-01, 5.55010144e-01},
   {2.32857559e-01, 3.01849126e-01, 5.47835919e-01},
   {2.31810546e-01, 2.98670665e-01, 5.40691084e-01},
   {2.30705538e-01, 2.95501982e-01, 5.33576454e-01},
   {2.29544644e-01, 2.92342466e-01, 5.26492728e-01},
   {2.28329868e-01, 2.89191531e-01, 5.19440505e-01},
   {2.27063120e-01, 2.86048621e-01, 5.12420289e-01},
   {2.25746215e-01, 2.82913203e-01, 5.05432497e-01},
   {2.24380878e-01, 2.79784770e-01, 4.98477470e-01},
   {2.22968752e-01, 2.76662836e-01, 4.91555475e-01},
   {2.21511396e-01, 2.73546937e-01, 4.84666715e-01},
   {2.20010239e-01, 2.70436621e-01, 4.77811461e-01},
   {2.18466444e-01, 2.67331436e-01, 4.70990359e-01},
   {2.16881625e-01, 2.64230995e-01, 4.64202867e-01},
   {2.15256985e-01, 2.61134895e-01, 4.57449146e-01},
   {2.13593418e-01, 2.58042718e-01, 4.50729909e-01},
   {2.11892450e-01, 2.54954135e-01, 4.44044228e-01},
   {2.10154732e-01, 2.51868737e-01, 4.37393064e-01},
   {2.08381656e-01, 2.48786217e-01, 4.30775450e-01},
   {2.06573793e-01, 2.45706187e-01, 4.24192274e-01},
   {2.04732430e-01, 2.42628362e-01, 4.17642496e-01},
   {2.02858067e-01, 2.39552372e-01, 4.11126922e-01},
   {2.00951756e-01, 2.36477929e-01, 4.04644823e-01},
   {1.99014302e-01, 2.33404731e-01, 3.98195962e-01},
   {1.97046147e-01, 2.30332431e-01, 3.91780945e-01},
   {1.95048234e-01, 2.27260766e-01, 3.85398932e-01},
   {1.93021210e-01, 2.24189441e-01, 3.79049751e-01},
   {1.90965676e-01, 2.21118165e-01, 3.72733244e-01},
   {1.88882068e-01, 2.18046628e-01, 3.66449615e-01},
   {1.86771070e-01, 2.14974566e-01, 3.60198266e-01},
   {1.84633214e-01, 2.11901701e-01, 3.53978926e-01},
   {1.82468982e-01, 2.08827751e-01, 3.47791363e-01},
   {1.80278832e-01, 2.05752438e-01, 3.41635323e-01},
   {1.78063194e-01, 2.02675486e-01, 3.35510539e-01},
   {1.75822472e-01, 1.99596616e-01, 3.29416728e-01},
   {1.73557047e-01, 1.96515552e-01, 3.23353592e-01},
   {1.71267273e-01, 1.93432015e-01, 3.17320821e-01},
   {1.68953481e-01, 1.90345728e-01, 3.11318090e-01},
   {1.66615979e-01, 1.87256408e-01, 3.05345062e-01},
   {1.64255048e-01, 1.84163774e-01, 2.99401390e-01},
   {1.61870950e-01, 1.81067539e-01, 2.93486714e-01},
   {1.59463922e-01, 1.77967413e-01, 2.87600662e-01},
   {1.57034176e-01, 1.74863103e-01, 2.81742854e-01},
   {1.54581876e-01, 1.71754305e-01, 2.75912999e-01},
   {1.52107134e-01, 1.68640705e-01, 2.70110883e-01},
   {1.49610173e-01, 1.65522006e-01, 2.64335837e-01},
   {1.47091119e-01, 1.62397894e-01, 2.58587437e-01},
   {1.44550070e-01, 1.59268044e-01, 2.52865249e-01},
   {1.41987011e-01, 1.56132104e-01, 2.47169165e-01},
   {1.39402031e-01, 1.52989740e-01, 2.41498612e-01},
   {1.36795217e-01, 1.49840614e-01, 2.35852930e-01},
   {1.34166545e-01, 1.46684356e-01, 2.30231753e-01},
   {1.31515885e-01, 1.43520568e-01, 2.24635009e-01},
   {1.28843336e-01, 1.40348896e-01, 2.19061687e-01},
   {1.26148778e-01, 1.37168927e-01, 2.13511466e-01},
   {1.23432032e-01, 1.33980228e-01, 2.07984146e-01},
   {1.20693111e-01, 1.30782396e-01, 2.02478680e-01},
   {1.17931726e-01, 1.27574952e-01, 1.96995048e-01},
   {1.15147777e-01, 1.24357446e-01, 1.91532377e-01},
   {1.12341037e-01, 1.21129384e-01, 1.86090147e-01},
   {1.09511209e-01, 1.17890242e-01, 1.80667973e-01},
   {1.06658103e-01, 1.14639504e-01, 1.75264889e-01},
   {1.03781280e-01, 1.11376578e-01, 1.69880751e-01},
   {1.00880520e-01, 1.08100903e-01, 1.64514367e-01},
   {9.79552928e-02, 1.04811822e-01, 1.59165616e-01},
   {9.50052857e-02, 1.01508706e-01, 1.53833276e-01},
   {9.20299100e-02, 9.81908332e-02, 1.48517042e-01},
   {8.90287064e-02, 9.48574837e-02, 1.43215838e-01},
   {8.60010553e-02, 9.15078661e-02, 1.37928993e-01},
   {8.29462963e-02, 8.81411436e-02, 1.32655723e-01},
   {7.98637948e-02, 8.47564453e-02, 1.27394821e-01},
   {7.67526386e-02, 8.13527897e-02, 1.22145928e-01},
   {7.36121083e-02, 7.79291923e-02, 1.16907471e-01},
   {7.04412107e-02, 7.44845475e-02, 1.11678639e-01},
   {6.72388963e-02, 7.10176749e-02, 1.06458404e-01},
   {6.40041036e-02, 6.75273224e-02, 1.01245258e-01},
   {6.07355301e-02, 6.40121018e-02, 9.60381728e-02},
   {5.74318124e-02, 6.04705226e-02, 9.08357274e-02},
   {5.40914827e-02, 5.69009698e-02, 8.56362070e-02},
   {5.07128356e-02, 5.33016572e-02, 8.04381104e-02},
   {4.72939791e-02, 4.96706236e-02, 7.52397997e-02},
   {4.38328995e-02, 4.60057289e-02, 7.00390473e-02},
   {4.03253250e-02, 4.23045858e-02, 6.48337039e-02},
   {3.68119799e-02, 3.85588031e-02, 5.96215760e-02},
   {3.34383800e-02, 3.49234868e-02, 5.43999018e-02},
   {3.02065532e-02, 3.14566306e-02, 4.91655596e-02},
   {2.71185916e-02, 2.81589142e-02, 4.39151506e-02},
   {2.41766866e-02, 2.50311454e-02, 3.86382927e-02},
   {2.13831525e-02, 2.20742794e-02, 3.36012698e-02},
   {1.87405026e-02, 1.92894533e-02, 2.89448430e-02},
   {1.62514037e-02, 1.66779945e-02, 2.46610222e-02},
   {1.39187470e-02, 1.42414639e-02, 2.07420804e-02},
   {1.17456978e-02, 1.19817007e-02, 1.71805773e-02},
   {9.73575395e-03, 9.90087988e-03, 1.39694399e-02},
   {7.89285303e-03, 8.00159702e-03, 1.11018863e-02},
   {6.22148215e-03, 6.28697637e-03, 8.57157164e-03},
   {4.72684477e-03, 4.76082980e-03, 6.37274354e-03},
   {3.41513042e-03, 3.42790180e-03, 4.50037440e-03},
   {2.29393772e-03, 2.29426270e-03, 2.95045739e-03},
   {1.37301685e-03, 1.36800262e-03, 1.72055651e-03},
   {6.65756539e-04, 6.60629159e-04, 8.10977578e-04},
   {1.92918273e-04, 1.90603023e-04, 2.27925431e-04},
   {0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
   {2.46147513e-04, 1.74022352e-04, 1.86778068e-04},
   {8.76505979e-04, 5.95218163e-04, 6.45816030e-04},
   {1.86026397e-03, 1.21726718e-03, 1.33402215e-03},
   {3.19002026e-03, 2.01788637e-03, 2.23163475e-03},
   {4.86438398e-03, 2.98218359e-03, 3.32571522e-03},
   {6.88465127e-03, 4.09899757e-03, 4.60663725e-03},
   {9.25360203e-03, 5.35941200e-03, 6.06669606e-03},
   {1.19749644e-02, 6.75599550e-03, 7.69941449e-03},
   {1.50531009e-02, 8.28237546e-03, 9.49915213e-03},
   {1.84928310e-02, 9.93296829e-03, 1.14608625e-02},
   {2.22993192e-02, 1.17027997e-02, 1.35799324e-02},
   {2.64780094e-02, 1.35873759e-02, 1.58520698e-02},
   {3.10345812e-02, 1.55825903e-02, 1.82732221e-02},
   {3.59748385e-02, 1.76846830e-02, 2.08395272e-02},
   {4.12852700e-02, 1.98901549e-02, 2.35472554e-02},
   {4.66368784e-02, 2.21957396e-02, 2.63927782e-02},
   {5.19582875e-02, 2.45983712e-02, 2.93725400e-02},
   {5.72533152e-02, 2.70951584e-02, 3.24830352e-02},
   {6.25252807e-02, 2.96833639e-02, 3.57207896e-02},
   {6.77770915e-02, 3.23603867e-02, 3.90823447e-02},
   {7.30113526e-02, 3.51237250e-02, 4.24978599e-02},
   {7.82303272e-02, 3.79710125e-02, 4.58514661e-02},
   {8.34360241e-02, 4.08909771e-02, 4.91545205e-02},
   {8.86302578e-02, 4.37692089e-02, 5.24087069e-02},
   {9.38146597e-02, 4.66043370e-02, 5.56155029e-02},
   {9.89907016e-02, 4.93982504e-02, 5.87762063e-02},
   {1.04159716e-01, 5.21526804e-02, 6.18919566e-02},
   {1.09323027e-01, 5.48691472e-02, 6.49637131e-02},
   {1.14481684e-01, 5.75491529e-02, 6.79923662e-02},
   {1.19636642e-01, 6.01940916e-02, 7.09786970e-02},
   {1.24788816e-01, 6.28052319e-02, 7.39233708e-02},
   {1.29939212e-01, 6.53836503e-02, 7.68268958e-02},
   {1.35088504e-01, 6.79305129e-02, 7.96897984e-02},
   {1.40237336e-01, 7.04469011e-02, 8.25125235e-02},
   {1.45386532e-01, 7.29336764e-02, 8.52953436e-02},
   {1.50536608e-01, 7.53918162e-02, 8.80385793e-02},
   {1.55688036e-01, 7.78222467e-02, 9.07424959e-02},
   {1.60841582e-01, 8.02256210e-02, 9.34071441e-02},
   {1.65997414e-01, 8.26029302e-02, 9.60327923e-02},
   {1.71156234e-01, 8.49547419e-02, 9.86193846e-02},
   {1.76318204e-01, 8.72819357e-02, 1.01167075e-01},
   {1.81483900e-01, 8.95850555e-02, 1.03675746e-01},
   {1.86653425e-01, 9.18649272e-02, 1.06145482e-01},
   {1.91827351e-01, 9.41220038e-02, 1.08576054e-01},
   {1.97005671e-01, 9.63571069e-02, 1.10967514e-01},
   {2.02188847e-01, 9.85706910e-02, 1.13319597e-01},
   {2.07376987e-01, 1.00763426e-01, 1.15632203e-01},
   {2.12570219e-01, 1.02935942e-01, 1.17905181e-01},
   {2.17768918e-01, 1.05088657e-01, 1.20138181e-01},
   {2.22973068e-01, 1.07222249e-01, 1.22331066e-01},
   {2.28182775e-01, 1.09337286e-01, 1.24483588e-01},
   {2.33398171e-01, 1.11434291e-01, 1.26595440e-01},
   {2.38619448e-01, 1.13513724e-01, 1.28666239e-01},
   {2.43846529e-01, 1.15576226e-01, 1.30695759e-01},
   {2.49079460e-01, 1.17622332e-01, 1.32683657e-01},
   {2.54318260e-01, 1.19652578e-01, 1.34629577e-01},
   {2.59562928e-01, 1.21667505e-01, 1.36533148e-01},
   {2.64813442e-01, 1.23667656e-01, 1.38393988e-01},
   {2.70069756e-01, 1.25653580e-01, 1.40211703e-01},
   {2.75331803e-01, 1.27625835e-01, 1.41985890e-01},
   {2.80599494e-01, 1.29584983e-01, 1.43716137e-01},
   {2.85872717e-01, 1.31531598e-01, 1.45402025e-01},
   {2.91151339e-01, 1.33466264e-01, 1.47043129e-01},
   {2.96435206e-01, 1.35389575e-01, 1.48639022e-01},
   {3.01724140e-01, 1.37302137e-01, 1.50189271e-01},
   {3.07017942e-01, 1.39204570e-01, 1.51693441e-01},
   {3.12316392e-01, 1.41097508e-01, 1.53151101e-01},
   {3.17619276e-01, 1.42981578e-01, 1.54561785e-01},
   {3.22926417e-01, 1.44857371e-01, 1.55924965e-01},
   {3.28237424e-01, 1.46725651e-01, 1.57240321e-01},
   {3.33551986e-01, 1.48587117e-01, 1.58507432e-01},
   {3.38869899e-01, 1.50442384e-01, 1.59725736e-01},
   {3.44190755e-01, 1.52292228e-01, 1.60894879e-01},
   {3.49514112e-01, 1.54137453e-01, 1.62014539e-01},
   {3.54839798e-01, 1.55978652e-01, 1.63084046e-01},
   {3.60167172e-01, 1.57816792e-01, 1.64103290e-01},
   {3.65495983e-01, 1.59652533e-01, 1.65071661e-01},
   {3.70825630e-01, 1.61486816e-01, 1.65988979e-01},
   {3.76155790e-01, 1.63320362e-01, 1.66854691e-01},
   {3.81485801e-01, 1.65154171e-01, 1.67668687e-01},
   {3.86815321e-01, 1.66988983e-01, 1.68430400e-01},
   {3.92143672e-01, 1.68825817e-01, 1.69139733e-01},
   {3.97470300e-01, 1.70665596e-01, 1.69796407e-01},
   {4.02794733e-01, 1.72509174e-01, 1.70400001e-01},
   {4.08116246e-01, 1.74357619e-01, 1.70950482e-01},
   {4.13434223e-01, 1.76211913e-01, 1.71447650e-01},
   {4.18748034e-01, 1.78073048e-01, 1.71891317e-01},
   {4.24057053e-01, 1.79942020e-01, 1.72281288e-01},
   {4.29360527e-01, 1.81819926e-01, 1.72617585e-01},
   {4.34657751e-01, 1.83707828e-01, 1.72900156e-01},
   {4.39947997e-01, 1.85606807e-01, 1.73128995e-01},
   {4.45230519e-01, 1.87517957e-01, 1.73304138e-01},
   {4.50504552e-01, 1.89442389e-01, 1.73425666e-01},
   {4.55769314e-01, 1.91381222e-01, 1.73493708e-01},
   {4.61024009e-01, 1.93335590e-01, 1.73508441e-01},
   {4.66267824e-01, 1.95306630e-01, 1.73470091e-01},
   {4.71499934e-01, 1.97295488e-01, 1.73378936e-01},
   {4.76719505e-01, 1.99303311e-01, 1.73235304e-01},
   {4.81925691e-01, 2.01331246e-01, 1.73039575e-01},
   {4.87117640e-01, 2.03380438e-01, 1.72792182e-01},
   {4.92294494e-01, 2.05452026e-01, 1.72493611e-01},
   {4.97455391e-01, 2.07547139e-01, 1.72144397e-01},
   {5.02599493e-01, 2.09666876e-01, 1.71745060e-01},
   {5.07725909e-01, 2.11812363e-01, 1.71296317e-01},
   {5.12833776e-01, 2.13984686e-01, 1.70798863e-01},
   {5.17922237e-01, 2.16184908e-01, 1.70253444e-01},
   {5.22990450e-01, 2.18414064e-01, 1.69660829e-01},
   {5.28037579e-01, 2.20673161e-01, 1.69021843e-01},
   {5.33062774e-01, 2.22963193e-01, 1.68337432e-01},
   {5.38065218e-01, 2.25285109e-01, 1.67608532e-01},
   {5.43044118e-01, 2.27639809e-01, 1.66836082e-01},
   {5.47998680e-01, 2.30028173e-01, 1.66021135e-01},
   {5.52928132e-01, 2.32451032e-01, 1.65164771e-01},
   {5.57831731e-01, 2.34909168e-01, 1.64268071e-01},
   {5.62708754e-01, 2.37403318e-01, 1.63332170e-01},
   {5.67558496e-01, 2.39934176e-01, 1.62358251e-01},
   {5.72380288e-01, 2.42502377e-01, 1.61347500e-01},
   {5.77173482e-01, 2.45108509e-01, 1.60301144e-01},
   {5.81937464e-01, 2.47753104e-01, 1.59220422e-01},
   {5.86671648e-01, 2.50436641e-01, 1.58106593e-01},
   {5.91375476e-01, 2.53159547e-01, 1.56960963e-01},
   {5.96048431e-01, 2.55922186e-01, 1.55784795e-01},
   {6.00690025e-01, 2.58724872e-01, 1.54579383e-01},
   {6.05299795e-01, 2.61567868e-01, 1.53346096e-01},
   {6.09877327e-01, 2.64451374e-01, 1.52086202e-01},
   {6.14422235e-01, 2.67375541e-01, 1.50801006e-01},
   {6.18934164e-01, 2.70340469e-01, 1.49491852e-01},
   {6.23412791e-01, 2.73346205e-01, 1.48160097e-01},
   {6.27857838e-01, 2.76392746e-01, 1.46806994e-01},
   {6.32269052e-01, 2.79480042e-01, 1.45433849e-01},
   {6.36646215e-01, 2.82607999e-01, 1.44041966e-01},
   {6.40989134e-01, 2.85776477e-01, 1.42632739e-01},
   {6.45297659e-01, 2.88985295e-01, 1.41207377e-01},
   {6.49571664e-01, 2.92234234e-01, 1.39767157e-01},
   {6.53811053e-01, 2.95523039e-01, 1.38313357e-01},
   {6.58015758e-01, 2.98851420e-01, 1.36847250e-01},
   {6.62185738e-01, 3.02219054e-01, 1.35370102e-01},
   {6.66320976e-01, 3.05625592e-01, 1.33883177e-01},
   {6.70421484e-01, 3.09070655e-01, 1.32387733e-01},
   {6.74487293e-01, 3.12553842e-01, 1.30885027e-01},
   {6.78518458e-01, 3.16074730e-01, 1.29376316e-01},
   {6.82515054e-01, 3.19632876e-01, 1.27862855e-01},
   {6.86477175e-01, 3.23227823e-01, 1.26345906e-01},
   {6.90404935e-01, 3.26859097e-01, 1.24826734e-01},
   {6.94298461e-01, 3.30526213e-01, 1.23306613e-01},
   {6.98157897e-01, 3.34228678e-01, 1.21786827e-01},
   {7.01983399e-01, 3.37965989e-01, 1.20268676e-01},
   {7.05775137e-01, 3.41737638e-01, 1.18753475e-01},
   {7.09533310e-01, 3.45543087e-01, 1.17242773e-01},
   {7.13258104e-01, 3.49381833e-01, 1.15737837e-01},
   {7.16949709e-01, 3.53253370e-01, 1.14239993e-01},
   {7.20608339e-01, 3.57157179e-01, 1.12750718e-01},
   {7.24234250e-01, 3.61092692e-01, 1.11271837e-01},
   {7.27827621e-01, 3.65059457e-01, 1.09804493e-01},
   {7.31388705e-01, 3.69056933e-01, 1.08350482e-01},
   {7.34917753e-01, 3.73084598e-01, 1.06911544e-01},
   {7.38414962e-01, 3.77141999e-01, 1.05489118e-01},
   {7.41880648e-01, 3.81228563e-01, 1.04085438e-01},
   {7.45314977e-01, 3.85343889e-01, 1.02701856e-01},
   {7.48718277e-01, 3.89487412e-01, 1.01340774e-01},
   {7.52090741e-01, 3.93658724e-01, 1.00003836e-01},
   {7.55432637e-01, 3.97857342e-01, 9.86932340e-02},
   {7.58744257e-01, 4.02082772e-01, 9.74113263e-02},
   {7.62025784e-01, 4.06334640e-01, 9.61599910e-02},
   {7.65277515e-01, 4.10612466e-01, 9.49417866e-02},
   {7.68499734e-01, 4.14915794e-01, 9.37592638e-02},
   {7.71692631e-01, 4.19244269e-01, 9.26146231e-02},
   {7.74856461e-01, 4.23597480e-01, 9.15104700e-02},
   {7.77991478e-01, 4.27975026e-01, 9.04494842e-02},
   {7.81097999e-01, 4.32376459e-01, 8.94346788e-02},
   {7.84176206e-01, 4.36801463e-01, 8.84685728e-02},
   {7.87226341e-01, 4.41249676e-01, 8.75540097e-02},
   {7.90248648e-01, 4.45720742e-01, 8.66938986e-02},
   {7.93243365e-01, 4.50214316e-01, 8.58911823e-02},
   {7.96210730e-01, 4.54730066e-01, 8.51488247e-02},
   {7.99150975e-01, 4.59267669e-01, 8.44697961e-02},
   {8.02064329e-01, 4.63826814e-01, 8.38570574e-02},
   {8.04951015e-01, 4.68407202e-01, 8.33135422e-02},
   {8.07811252e-01, 4.73008544e-01, 8.28421385e-02},
   {8.10645255e-01, 4.77630563e-01, 8.24456683e-02},
   {8.13453293e-01, 4.82272944e-01, 8.21270520e-02},
   {8.16235580e-01, 4.86935423e-01, 8.18889382e-02},
   {8.18992270e-01, 4.91617793e-01, 8.17336794e-02},
   {8.21723559e-01, 4.96319820e-01, 8.16636252e-02},
   {8.24429634e-01, 5.01041277e-01, 8.16809565e-02},
   {8.27110882e-01, 5.05781794e-01, 8.17882158e-02},
   {8.29767327e-01, 5.10541287e-01, 8.19867447e-02},
   {8.32399121e-01, 5.15319577e-01, 8.22780547e-02},
   {8.35006656e-01, 5.20116310e-01, 8.26640340e-02},
   {8.37589979e-01, 5.24931398e-01, 8.31454551e-02},
   {8.40149219e-01, 5.29764695e-01, 8.37230852e-02},
   {8.42684814e-01, 5.34615834e-01, 8.43981411e-02},
   {8.45196602e-01, 5.39484893e-01, 8.51702373e-02},
   {8.47685129e-01, 5.44371438e-01, 8.60403002e-02},
   {8.50150204e-01, 5.49275574e-01, 8.70074521e-02},
   {8.52592360e-01, 5.54196890e-01, 8.80720629e-02},
   {8.55011374e-01, 5.59135521e-01, 8.92327980e-02},
   {8.57407880e-01, 5.64090997e-01, 9.04897298e-02},
   {8.59781612e-01, 5.69063487e-01, 9.18410925e-02},
   {8.62132991e-01, 5.74052684e-01, 9.32861675e-02},
   {8.64462123e-01, 5.79058503e-01, 9.48235248e-02},
   {8.66769006e-01, 5.84080937e-01, 9.64514470e-02},
   {8.69054105e-01, 5.89119666e-01, 9.81687919e-02},
   {8.71317373e-01, 5.94174723e-01, 9.99735453e-02},
   {8.73558893e-01, 5.99246049e-01, 1.01863830e-01},
   {8.75778943e-01, 6.04333465e-01, 1.03837949e-01},
   {8.77977766e-01, 6.09436823e-01, 1.05894083e-01},
   {8.80155313e-01, 6.14556159e-01, 1.08030036e-01},
   {8.82311743e-01, 6.19691387e-01, 1.10243848e-01},
   {8.84447208e-01, 6.24842421e-01, 1.12533541e-01},
   {8.86561983e-01, 6.30009105e-01, 1.14897254e-01},
   {8.88656165e-01, 6.35191401e-01, 1.17332953e-01},
   {8.90729806e-01, 6.40389298e-01, 1.19838596e-01},
   {8.92783048e-01, 6.45602733e-01, 1.22412261e-01},
   {8.94816027e-01, 6.50831649e-01, 1.25052057e-01},
   {8.96828879e-01, 6.56075994e-01, 1.27756136e-01},
   {8.98821736e-01, 6.61335720e-01, 1.30522692e-01},
   {9.00794725e-01, 6.66610785e-01, 1.33349970e-01},
   {9.02747973e-01, 6.71901150e-01, 1.36236264e-01},
   {9.04681602e-01, 6.77206783e-01, 1.39179925e-01},
   {9.06595729e-01, 6.82527656e-01, 1.42179360e-01},
   {9.08490471e-01, 6.87863744e-01, 1.45233030e-01},
   {9.10365937e-01, 6.93215029e-01, 1.48339456e-01},
   {9.12222237e-01, 6.98581497e-01, 1.51497216e-01},
   {9.14059474e-01, 7.03963136e-01, 1.54704945e-01},
   {9.15877749e-01, 7.09359942e-01, 1.57961334e-01},
   {9.17677158e-01, 7.14771913e-01, 1.61265130e-01},
   {9.19457794e-01, 7.20199053e-01, 1.64615135e-01},
   {9.21219887e-01, 7.25641293e-01, 1.68010245e-01},
   {9.22963546e-01, 7.31098632e-01, 1.71449361e-01},
   {9.24688722e-01, 7.36571158e-01, 1.74931397e-01},
   {9.26395493e-01, 7.42058890e-01, 1.78455353e-01},
   {9.28083929e-01, 7.47561853e-01, 1.82020279e-01},
   {9.29754237e-01, 7.53080003e-01, 1.85625294e-01},
   {9.31406685e-01, 7.58613271e-01, 1.89269561e-01},
   {9.33041031e-01, 7.64161849e-01, 1.92952193e-01},
   {9.34657330e-01, 7.69725777e-01, 1.96672407e-01},
   {9.36255901e-01, 7.75304965e-01, 2.00429488e-01},
   {9.37836877e-01, 7.80899421e-01, 2.04222720e-01},
   {9.39399985e-01, 7.86509354e-01, 2.08051387e-01},
   {9.40945427e-01, 7.92134740e-01, 2.11914857e-01},
   {9.42473642e-01, 7.97775442e-01, 2.15812532e-01},
   {9.43984129e-01, 8.03431784e-01, 2.19743786e-01},
   {9.45477230e-01, 8.09103677e-01, 2.23708074e-01},
   {9.46953174e-01, 8.14791098e-01, 2.27704861e-01},
   {9.48411483e-01, 8.20494354e-01, 2.31733624e-01},
   {9.49852929e-01, 8.26213166e-01, 2.35793883e-01},
   {9.51276961e-01, 8.31947880e-01, 2.39885169e-01},
   {9.52683858e-01, 8.37698450e-01, 2.44007037e-01},
   {9.54073766e-01, 8.43464899e-01, 2.48159058e-01},
   {9.55446349e-01, 8.49247470e-01, 2.52340842e-01},
   {9.56802246e-01, 8.55045963e-01, 2.56551973e-01},
   {9.58140717e-01, 8.60860804e-01, 2.60792124e-01},
   {9.59462672e-01, 8.66691679e-01, 2.65060887e-01},
   {9.60767194e-01, 8.72539089e-01, 2.69357991e-01}
};

// https://github.com/1313e/CMasher
const int RGB_Palette_42_Size = 511; // viola
double RGB_Palette_42[RGB_Palette_42_Size][3] =
{
   {0.11138401, 0.02669949, 0.18994576},
   {0.11630584, 0.02843274, 0.19596041},
   {0.12122371, 0.03017008, 0.20200385},
   {0.12613965, 0.03190505, 0.20808061},
   {0.13105245, 0.03363619, 0.21418972},
   {0.13596355, 0.03535760, 0.22033503},
   {0.14087256, 0.03706639, 0.22651726},
   {0.14577938, 0.03875900, 0.23273789},
   {0.15068450, 0.04043075, 0.23899957},
   {0.15558810, 0.04203151, 0.24530468},
   {0.16048964, 0.04356923, 0.25165440},
   {0.16538900, 0.04504430, 0.25805096},
   {0.17028593, 0.04645678, 0.26449657},
   {0.17518003, 0.04780676, 0.27099345},
   {0.18007074, 0.04909437, 0.27754379},
   {0.18495762, 0.05031912, 0.28415040},
   {0.18984008, 0.05148049, 0.29081625},
   {0.19471647, 0.05258010, 0.29754239},
   {0.19958618, 0.05361678, 0.30433270},
   {0.20444751, 0.05459151, 0.31118919},
   {0.20929922, 0.05550376, 0.31811564},
   {0.21413882, 0.05635561, 0.32511367},
   {0.21896421, 0.05714769, 0.33218672},
   {0.22377274, 0.05788148, 0.33933794},
   {0.22856112, 0.05855955, 0.34657012},
   {0.23332527, 0.05918597, 0.35388549},
   {0.23806040, 0.05976622, 0.36128589},
   {0.24276170, 0.06030484, 0.36877533},
   {0.24742193, 0.06081291, 0.37635309},
   {0.25203344, 0.06130190, 0.38401992},
   {0.25658695, 0.06178750, 0.39177471},
   {0.26107122, 0.06229107, 0.39961346},
   {0.26547353, 0.06283783, 0.40753129},
   {0.26977818, 0.06346323, 0.41551642},
   {0.27396773, 0.06420866, 0.42355414},
   {0.27802236, 0.06512511, 0.43162229},
   {0.28192067, 0.06627120, 0.43969143},
   {0.28564067, 0.06771084, 0.44772416},
   {0.28916153, 0.06950790, 0.45567615},
   {0.29246553, 0.07171986, 0.46349748},
   {0.29554035, 0.07438845, 0.47113807},
   {0.29838062, 0.07753367, 0.47855166},
   {0.30098832, 0.08115027, 0.48570117},
   {0.30337211, 0.08520982, 0.49256135},
   {0.30554562, 0.08966644, 0.49911944},
   {0.30752549, 0.09446421, 0.50537395},
   {0.30932949, 0.09954425, 0.51133228},
   {0.31097525, 0.10484997, 0.51700784},
   {0.31247949, 0.11033024, 0.52241746},
   {0.31385726, 0.11594089, 0.52757996},
   {0.31512203, 0.12164498, 0.53251446},
   {0.31628568, 0.12741224, 0.53723953},
   {0.31735854, 0.13321839, 0.54177283},
   {0.31835001, 0.13904386, 0.54613054},
   {0.31926756, 0.14487382, 0.55032795},
   {0.32011852, 0.15069617, 0.55437862},
   {0.32090857, 0.15650214, 0.55829515},
   {0.32164315, 0.16228476, 0.56208877},
   {0.32232701, 0.16803883, 0.56576971},
   {0.32296429, 0.17376059, 0.56934720},
   {0.32355864, 0.17944737, 0.57282963},
   {0.32411325, 0.18509739, 0.57622458},
   {0.32463109, 0.19070950, 0.57953893},
   {0.32511520, 0.19628275, 0.58277894},
   {0.32556731, 0.20181740, 0.58595028},
   {0.32599029, 0.20731304, 0.58905819},
   {0.32638545, 0.21277047, 0.59210735},
   {0.32675517, 0.21818982, 0.59510216},
   {0.32710078, 0.22357199, 0.59804657},
   {0.32742372, 0.22891779, 0.60094423},
   {0.32772546, 0.23422805, 0.60379849},
   {0.32800753, 0.23950350, 0.60661251},
   {0.32827086, 0.24474529, 0.60938909},
   {0.32851655, 0.24995439, 0.61213087},
   {0.32874562, 0.25513180, 0.61484030},
   {0.32895901, 0.26027851, 0.61751963},
   {0.32915760, 0.26539554, 0.62017096},
   {0.32934219, 0.27048388, 0.62279622},
   {0.32951352, 0.27554451, 0.62539722},
   {0.32967230, 0.28057842, 0.62797564},
   {0.32981935, 0.28558646, 0.63053307},
   {0.32995511, 0.29056966, 0.63307091},
   {0.33008013, 0.29552896, 0.63559052},
   {0.33019492, 0.30046524, 0.63809313},
   {0.33030002, 0.30537937, 0.64057992},
   {0.33039611, 0.31027209, 0.64305205},
   {0.33048336, 0.31514436, 0.64551044},
   {0.33056217, 0.31999699, 0.64795602},
   {0.33063313, 0.32483066, 0.65038975},
   {0.33069649, 0.32964620, 0.65281239},
   {0.33075249, 0.33444438, 0.65522465},
   {0.33080168, 0.33922584, 0.65762731},
   {0.33084419, 0.34399134, 0.66002095},
   {0.33088029, 0.34874158, 0.66240616},
   {0.33091044, 0.35347713, 0.66478356},
   {0.33093467, 0.35819875, 0.66715355},
   {0.33095340, 0.36290697, 0.66951665},
   {0.33096677, 0.36760245, 0.67187325},
   {0.33097501, 0.37228577, 0.67422372},
   {0.33097842, 0.37695748, 0.67656841},
   {0.33097710, 0.38161819, 0.67890758},
   {0.33097139, 0.38626838, 0.68124155},
   {0.33096137, 0.39090862, 0.68357049},
   {0.33094738, 0.39553939, 0.68589463},
   {0.33092952, 0.40016122, 0.68821410},
   {0.33090807, 0.40477455, 0.69052904},
   {0.33088322, 0.40937987, 0.69283954},
   {0.33085521, 0.41397764, 0.69514566},
   {0.33082428, 0.41856828, 0.69744743},
   {0.33079066, 0.42315222, 0.69974485},
   {0.33075463, 0.42772987, 0.70203789},
   {0.33071647, 0.43230164, 0.70432650},
   {0.33067647, 0.43686790, 0.70661057},
   {0.33063497, 0.44142902, 0.70888999},
   {0.33059226, 0.44598538, 0.71116461},
   {0.33054882, 0.45053728, 0.71343427},
   {0.33050491, 0.45508511, 0.71569871},
   {0.33046115, 0.45962913, 0.71795776},
   {0.33041781, 0.46416971, 0.72021108},
   {0.33037561, 0.46870707, 0.72245843},
   {0.33033499, 0.47324154, 0.72469945},
   {0.33029663, 0.47777335, 0.72693378},
   {0.33026124, 0.48230276, 0.72916105},
   {0.33022942, 0.48683003, 0.73138079},
   {0.33020219, 0.49135531, 0.73359262},
   {0.33018021, 0.49587889, 0.73579597},
   {0.33016456, 0.50040091, 0.73799036},
   {0.33015640, 0.50492150, 0.74017529},
   {0.33015652, 0.50944094, 0.74235001},
   {0.33016648, 0.51395924, 0.74451405},
   {0.33018763, 0.51847654, 0.74666673},
   {0.33022112, 0.52299303, 0.74880723},
   {0.33026881, 0.52750870, 0.75093493},
   {0.33033245, 0.53202361, 0.75304905},
   {0.33041385, 0.53653780, 0.75514877},
   {0.33051483, 0.54105136, 0.75723312},
   {0.33063782, 0.54556419, 0.75930132},
   {0.33078520, 0.55007627, 0.76135243},
   {0.33095951, 0.55458753, 0.76338544},
   {0.33116353, 0.55909787, 0.76539934},
   {0.33140020, 0.56360719, 0.76739302},
   {0.33167268, 0.56811535, 0.76936532},
   {0.33198457, 0.57262211, 0.77131513},
   {0.33233962, 0.57712725, 0.77324124},
   {0.33274186, 0.58163048, 0.77514237},
   {0.33319562, 0.58613150, 0.77701722},
   {0.33370556, 0.59062994, 0.77886443},
   {0.33427662, 0.59512540, 0.78068255},
   {0.33491406, 0.59961743, 0.78247010},
   {0.33562372, 0.60410547, 0.78422564},
   {0.33641171, 0.60858894, 0.78594765},
   {0.33728457, 0.61306716, 0.78763459},
   {0.33824910, 0.61753946, 0.78928477},
   {0.33931249, 0.62200507, 0.79089643},
   {0.34048286, 0.62646302, 0.79246820},
   {0.34176815, 0.63091242, 0.79399821},
   {0.34317705, 0.63535220, 0.79548484},
   {0.34471872, 0.63978118, 0.79692655},
   {0.34640249, 0.64419817, 0.79832162},
   {0.34823828, 0.64860177, 0.79966860},
   {0.35023639, 0.65299050, 0.80096621},
   {0.35240696, 0.65736289, 0.80221273},
   {0.35476094, 0.66171715, 0.80340742},
   {0.35730905, 0.66605153, 0.80454930},
   {0.36006205, 0.67036412, 0.80563769},
   {0.36303051, 0.67465296, 0.80667226},
   {0.36622473, 0.67891598, 0.80765298},
   {0.36965449, 0.68315103, 0.80858050},
   {0.37332879, 0.68735594, 0.80945583},
   {0.37725565, 0.69152854, 0.81028057},
   {0.38144179, 0.69566668, 0.81105701},
   {0.38589243, 0.69976829, 0.81178814},
   {0.39061094, 0.70383141, 0.81247768},
   {0.39559867, 0.70785428, 0.81313008},
   {0.40085473, 0.71183537, 0.81375048},
   {0.40637584, 0.71577343, 0.81434474},
   {0.41215626, 0.71966756, 0.81491933},
   {0.41818783, 0.72351722, 0.81548120},
   {0.42446014, 0.72732228, 0.81603761},
   {0.43096069, 0.73108304, 0.81659606},
   {0.43767520, 0.73480020, 0.81716407},
   {0.44458799, 0.73847485, 0.81774903},
   {0.45168236, 0.74210845, 0.81835806},
   {0.45894105, 0.74570279, 0.81899783},
   {0.46634662, 0.74925990, 0.81967446},
   {0.47388188, 0.75278203, 0.82039341},
   {0.48153025, 0.75627154, 0.82115944},
   {0.48927559, 0.75973094, 0.82197684},
   {0.49710255, 0.76316282, 0.82284942},
   {0.50499805, 0.76656958, 0.82377935},
   {0.51294815, 0.76995391, 0.82476983},
   {0.52094213, 0.77331809, 0.82582191},
   {0.52896959, 0.77666450, 0.82693685},
   {0.53702081, 0.77999544, 0.82811581},
   {0.54508743, 0.78331310, 0.82935933},
   {0.55316270, 0.78661943, 0.83066727},
   {0.56124038, 0.78991633, 0.83203948},
   {0.56931446, 0.79320572, 0.83347602},
   {0.57738057, 0.79648922, 0.83497618},
   {0.58543520, 0.79976832, 0.83653902},
   {0.59347520, 0.80304444, 0.83816366},
   {0.60149600, 0.80631930, 0.83985030},
   {0.60949780, 0.80959366, 0.84159649},
   {0.61747594, 0.81286927, 0.84340291},
   {0.62543124, 0.81614675, 0.84526715},
   {0.63336132, 0.81942736, 0.84718888},
   {0.64126483, 0.82271216, 0.84916731},
   {0.64914193, 0.82600186, 0.85120091},
   {0.65699192, 0.82929734, 0.85328879},
   {0.66481429, 0.83259942, 0.85543006},
   {0.67260878, 0.83590887, 0.85762378},
   {0.68037529, 0.83922639, 0.85986905},
   {0.68811387, 0.84255265, 0.86216492},
   {0.69582471, 0.84588824, 0.86451049},
   {0.70350814, 0.84923374, 0.86690483},
   {0.71116455, 0.85258966, 0.86934706},
   {0.71879446, 0.85595650, 0.87183627},
   {0.72639742, 0.85933496, 0.87437213},
   {0.73397405, 0.86272548, 0.87695378},
   {0.74152578, 0.86612825, 0.87958001},
   {0.74905216, 0.86954396, 0.88225059},
   {0.75655360, 0.87297306, 0.88496491},
   {0.76403187, 0.87641559, 0.88772171},
   {0.77148527, 0.87987258, 0.89052147},
   {0.77891692, 0.88334365, 0.89336233},
   {0.78632472, 0.88682992, 0.89624501},
   {0.79371145, 0.89033111, 0.89916789},
   {0.80107621, 0.89384796, 0.90213114},
   {0.80841988, 0.89738070, 0.90513410},
   {0.81574379, 0.90092943, 0.90817593},
   {0.82304670, 0.90449497, 0.91125697},
   {0.83033023, 0.90807731, 0.91437629},
   {0.83759510, 0.91167669, 0.91753337},
   {0.84484145, 0.91529351, 0.92072797},
   {0.85206864, 0.91892841, 0.92396022},
   {0.85927824, 0.92258135, 0.92722925},
   {0.86647054, 0.92625267, 0.93053477},
   {0.87364582, 0.92994270, 0.93387654},
   {0.88080434, 0.93365179, 0.93725430},
   {0.88794635, 0.93738028, 0.94066779},
   {0.89507189, 0.94112856, 0.94411689},
   {0.90218116, 0.94489699, 0.94760135},
   {0.90927462, 0.94868582, 0.95112086},
   {0.91635237, 0.95249543, 0.95467523},
   {0.92341450, 0.95632620, 0.95826430},
   {0.93046101, 0.96017851, 0.96188789},
   {0.93749188, 0.96405279, 0.96554587},
   {0.94450698, 0.96794949, 0.96923810},
   {0.95150590, 0.97186913, 0.97296456},
   {0.95848829, 0.97581226, 0.97672516},
   {0.96545389, 0.97977938, 0.98051973},
   {0.97240208, 0.98377110, 0.98434820},
   {0.97933207, 0.98778813, 0.98821051},
   {0.98624277, 0.99183128, 0.99210660},
   {0.99313272, 0.99590152, 0.99603643},
   {1.00000000, 1.00000000, 1.00000000},
   {0.99651279, 0.99457267, 0.99605330},
   {0.99295334, 0.98919689, 0.99211967},
   {0.98932435, 0.98386929, 0.98822156},
   {0.98563710, 0.97858296, 0.98438205},
   {0.98190830, 0.97332938, 0.98061866},
   {0.97815979, 0.96809863, 0.97694203},
   {0.97441507, 0.96288076, 0.97335603},
   {0.97069299, 0.95766849, 0.96985624},
   {0.96700845, 0.95245638, 0.96643513},
   {0.96337244, 0.94724054, 0.96308497},
   {0.95978968, 0.94201980, 0.95979570},
   {0.95626344, 0.93679325, 0.95656031},
   {0.95279443, 0.93156093, 0.95337247},
   {0.94938114, 0.92632374, 0.95022607},
   {0.94602365, 0.92108154, 0.94711876},
   {0.94271865, 0.91583587, 0.94404559},
   {0.93946518, 0.91058689, 0.94100512},
   {0.93626095, 0.90533547, 0.93799495},
   {0.93310402, 0.90008221, 0.93501341},
   {0.92999326, 0.89482732, 0.93205984},
   {0.92692614, 0.88957170, 0.92913222},
   {0.92390249, 0.88431502, 0.92623104},
   {0.92091949, 0.87905837, 0.92335402},
   {0.91797763, 0.87380105, 0.92050229},
   {0.91507404, 0.86854419, 0.91767352},
   {0.91220953, 0.86328695, 0.91486902},
   {0.90938150, 0.85803032, 0.91208670},
   {0.90659062, 0.85277353, 0.90932766},
   {0.90383493, 0.84751726, 0.90659035},
   {0.90111453, 0.84226104, 0.90387522},
   {0.89842849, 0.83700500, 0.90118166},
   {0.89577587, 0.83174925, 0.89850906},
   {0.89315720, 0.82649314, 0.89585812},
   {0.89057044, 0.82123736, 0.89322714},
   {0.88801673, 0.81598094, 0.89061734},
   {0.88549454, 0.81072431, 0.88802744},
   {0.88300327, 0.80546743, 0.88545701},
   {0.88054402, 0.80020928, 0.88290716},
   {0.87811483, 0.79495059, 0.88037614},
   {0.87571567, 0.78969098, 0.87786399},
   {0.87334737, 0.78442958, 0.87537150},
   {0.87100825, 0.77916694, 0.87289716},
   {0.86869808, 0.77390280, 0.87044077},
   {0.86641783, 0.76863621, 0.86800316},
   {0.86416627, 0.76336745, 0.86558323},
   {0.86194295, 0.75809639, 0.86318050},
   {0.85974766, 0.75282271, 0.86079476},
   {0.85758121, 0.74754554, 0.85842661},
   {0.85544254, 0.74226507, 0.85607506},
   {0.85333129, 0.73698107, 0.85373967},
   {0.85124729, 0.73169321, 0.85142019},
   {0.84919036, 0.72640114, 0.84911633},
   {0.84716058, 0.72110440, 0.84682801},
   {0.84515800, 0.71580247, 0.84455512},
   {0.84318193, 0.71049530, 0.84229690},
   {0.84123219, 0.70518254, 0.84005301},
   {0.83930863, 0.69986380, 0.83782312},
   {0.83741109, 0.69453869, 0.83560689},
   {0.83553939, 0.68920682, 0.83340395},
   {0.83369338, 0.68386778, 0.83121390},
   {0.83187287, 0.67852116, 0.82903636},
   {0.83007770, 0.67316655, 0.82687091},
   {0.82830769, 0.66780353, 0.82471710},
   {0.82656264, 0.66243165, 0.82257448},
   {0.82484238, 0.65705050, 0.82044255},
   {0.82314670, 0.65165962, 0.81832083},
   {0.82147539, 0.64625857, 0.81620877},
   {0.81982831, 0.64084683, 0.81410588},
   {0.81820602, 0.63542346, 0.81201217},
   {0.81660754, 0.62998844, 0.80992647},
   {0.81503263, 0.62454131, 0.80784811},
   {0.81348102, 0.61908158, 0.80577642},
   {0.81195295, 0.61360845, 0.80371107},
   {0.81044872, 0.60812102, 0.80165175},
   {0.80896705, 0.60261944, 0.79959694},
   {0.80750784, 0.59710307, 0.79754597},
   {0.80607236, 0.59157031, 0.79549913},
   {0.80465854, 0.58602181, 0.79345426},
   {0.80326733, 0.58045616, 0.79141135},
   {0.80189818, 0.57487292, 0.78936925},
   {0.80055066, 0.56927159, 0.78732688},
   {0.79922505, 0.56365113, 0.78528362},
   {0.79792067, 0.55801115, 0.78323812},
   {0.79663727, 0.55235096, 0.78118929},
   {0.79537530, 0.54666931, 0.77913647},
   {0.79413326, 0.54096635, 0.77707762},
   {0.79291197, 0.53524054, 0.77501220},
   {0.79171097, 0.52949121, 0.77293875},
   {0.79052936, 0.52371801, 0.77085549},
   {0.78936697, 0.51792004, 0.76876103},
   {0.78822356, 0.51209640, 0.76665385},
   {0.78709931, 0.50624585, 0.76453263},
   {0.78599327, 0.50036798, 0.76239525},
   {0.78490498, 0.49446198, 0.76023983},
   {0.78383399, 0.48852703, 0.75806439},
   {0.78277976, 0.48256230, 0.75586683},
   {0.78174219, 0.47656663, 0.75364514},
   {0.78072052, 0.47053932, 0.75139686},
   {0.77971380, 0.46447985, 0.74911932},
   {0.77872116, 0.45838757, 0.74680980},
   {0.77774249, 0.45226120, 0.74446580},
   {0.77677689, 0.44610008, 0.74208428},
   {0.77582269, 0.43990422, 0.73966173},
   {0.77488027, 0.43367180, 0.73719540},
   {0.77394729, 0.42740341, 0.73468119},
   {0.77302307, 0.42109815, 0.73211556},
   {0.77210681, 0.41475523, 0.72949473},
   {0.77119639, 0.40837505, 0.72681422},
   {0.77029043, 0.40195737, 0.72406970},
   {0.76938735, 0.39550218, 0.72125655},
   {0.76848530, 0.38900973, 0.71836989},
   {0.76758217, 0.38248060, 0.71540459},
   {0.76667560, 0.37591567, 0.71235530},
   {0.76576298, 0.36931620, 0.70921645},
   {0.76484255, 0.36268265, 0.70598248},
   {0.76391008, 0.35601815, 0.70264727},
   {0.76296333, 0.34932397, 0.69920494},
   {0.76199799, 0.34260370, 0.69564932},
   {0.76101097, 0.33585991, 0.69197435},
   {0.75999801, 0.32909662, 0.68817393},
   {0.75895465, 0.32231841, 0.68424218},
   {0.75787635, 0.31553025, 0.68017342},
   {0.75675826, 0.30873782, 0.67596237},
   {0.75559539, 0.30194734, 0.67160418},
   {0.75438284, 0.29516537, 0.66709455},
   {0.75311490, 0.28839979, 0.66243012},
   {0.75178649, 0.28165822, 0.65760819},
   {0.75039239, 0.27494887, 0.65262711},
   {0.74892756, 0.26828019, 0.64748627},
   {0.74738705, 0.26166089, 0.64218628},
   {0.74576659, 0.25509928, 0.63672872},
   {0.74406206, 0.24860376, 0.63111651},
   {0.74226991, 0.24218234, 0.62535367},
   {0.74038720, 0.23584244, 0.61944523},
   {0.73841159, 0.22959089, 0.61339718},
   {0.73634138, 0.22343379, 0.60721632},
   {0.73417548, 0.21737647, 0.60091011},
   {0.73191343, 0.21142341, 0.59448655},
   {0.72955534, 0.20557825, 0.58795396},
   {0.72710185, 0.19984378, 0.58132089},
   {0.72455408, 0.19422203, 0.57459594},
   {0.72191353, 0.18871428, 0.56778764},
   {0.71918207, 0.18332113, 0.56090439},
   {0.71636182, 0.17804261, 0.55395435},
   {0.71345514, 0.17287823, 0.54694533},
   {0.71046452, 0.16782704, 0.53988482},
   {0.70739256, 0.16288778, 0.53277991},
   {0.70424194, 0.15805887, 0.52563728},
   {0.70101532, 0.15333854, 0.51846324},
   {0.69771539, 0.14872485, 0.51126365},
   {0.69434476, 0.14421578, 0.50404407},
   {0.69090599, 0.13980924, 0.49680957},
   {0.68740160, 0.13550312, 0.48956488},
   {0.68383396, 0.13129538, 0.48231439},
   {0.68020538, 0.12718398, 0.47506230},
   {0.67651804, 0.12316702, 0.46781232},
   {0.67277403, 0.11924270, 0.46056795},
   {0.66897531, 0.11540930, 0.45333258},
   {0.66512374, 0.11166532, 0.44610916},
   {0.66122104, 0.10800938, 0.43890055},
   {0.65726885, 0.10444028, 0.43170947},
   {0.65326868, 0.10095703, 0.42453832},
   {0.64922193, 0.09755882, 0.41738951},
   {0.64512991, 0.09424507, 0.41026521},
   {0.64099380, 0.09101541, 0.40316752},
   {0.63681472, 0.08786969, 0.39609844},
   {0.63259366, 0.08480802, 0.38905987},
   {0.62833154, 0.08183073, 0.38205363},
   {0.62402916, 0.07893840, 0.37508149},
   {0.61968727, 0.07613188, 0.36814517},
   {0.61530651, 0.07341226, 0.36124635},
   {0.61088745, 0.07078087, 0.35438670},
   {0.60643058, 0.06823934, 0.34756782},
   {0.60193631, 0.06578946, 0.34079141},
   {0.59740499, 0.06343336, 0.33405903},
   {0.59283687, 0.06117329, 0.32737240},
   {0.58823217, 0.05901171, 0.32073323},
   {0.58359100, 0.05695140, 0.31414312},
   {0.57891345, 0.05499505, 0.30760396},
   {0.57419952, 0.05314552, 0.30111757},
   {0.56944915, 0.05140588, 0.29468575},
   {0.56466224, 0.04977894, 0.28831055},
   {0.55983864, 0.04826751, 0.28199404},
   {0.55497814, 0.04687425, 0.27573840},
   {0.55008047, 0.04560157, 0.26954588},
   {0.54514535, 0.04445164, 0.26341884},
   {0.54017244, 0.04342599, 0.25735987},
   {0.53516140, 0.04252573, 0.25137164},
   {0.53011186, 0.04175134, 0.24545699},
   {0.52502344, 0.04110259, 0.23961888},
   {0.51989576, 0.04057848, 0.23386046},
   {0.51472846, 0.04017305, 0.22818504},
   {0.50952123, 0.03988862, 0.22259608},
   {0.50427376, 0.03972237, 0.21709714},
   {0.49898586, 0.03966871, 0.21169200},
   {0.49365742, 0.03972170, 0.20638454},
   {0.48828845, 0.03987500, 0.20117868},
   {0.48287908, 0.04012181, 0.19607839},
   {0.47742962, 0.04045479, 0.19108759},
   {0.47194057, 0.04085798, 0.18621023},
   {0.46641267, 0.04132655, 0.18145004},
   {0.46084684, 0.04185049, 0.17681050},
   {0.45524431, 0.04241927, 0.17229482},
   {0.44960653, 0.04302226, 0.16790577},
   {0.44393524, 0.04364857, 0.16364563},
   {0.43823240, 0.04428757, 0.15951608},
   {0.43250021, 0.04492881, 0.15551812},
   {0.42674110, 0.04556211, 0.15165204},
   {0.42095767, 0.04617782, 0.14791737},
   {0.41515258, 0.04676711, 0.14431283},
   {0.40932862, 0.04732177, 0.14083637},
   {0.40348860, 0.04783442, 0.13748522},
   {0.39763529, 0.04829855, 0.13425593},
   {0.39177139, 0.04870857, 0.13114443},
   {0.38589948, 0.04905982, 0.12814615},
   {0.38002216, 0.04934797, 0.12525607},
   {0.37414156, 0.04957039, 0.12246885},
   {0.36825982, 0.04972466, 0.11977893},
   {0.36237886, 0.04980896, 0.11718058},
   {0.35650045, 0.04982209, 0.11466802},
   {0.35062596, 0.04976376, 0.11223548},
   {0.34475674, 0.04963364, 0.10987725},
   {0.33889396, 0.04943184, 0.10758771},
   {0.33303856, 0.04915884, 0.10536139},
   {0.32719128, 0.04881541, 0.10319302},
   {0.32135268, 0.04840259, 0.10107755},
   {0.31552330, 0.04792126, 0.09901007},
   {0.30970366, 0.04737220, 0.09698582},
   {0.30389366, 0.04675731, 0.09500056},
   {0.29809379, 0.04607701, 0.09304982},
   {0.29230391, 0.04533292, 0.09112969},
   {0.28652391, 0.04452634, 0.08923639},
   {0.28075373, 0.04365829, 0.08736623},
   {0.27499325, 0.04272978, 0.08551573},
   {0.26924223, 0.04174182, 0.08368156},
   {0.26350036, 0.04069541, 0.08186061},
   {0.25776724, 0.03958238, 0.08004990},
   {0.25204242, 0.03842694, 0.07824664},
   {0.24632534, 0.03723743, 0.07644816},
   {0.24061554, 0.03601731, 0.07465184},
   {0.23491278, 0.03476951, 0.07285486},
   {0.22921589, 0.03349840, 0.07105533},
   {0.22352481, 0.03220647, 0.06925037},
   {0.21783824, 0.03089799, 0.06743829},
   {0.21215613, 0.02957523, 0.06561621},
   {0.20647710, 0.02824235, 0.06378257},
   {0.20080045, 0.02690234, 0.06193512},
   {0.19512565, 0.02555789, 0.06007140},
   {0.18945137, 0.02421263, 0.05818973},
   {0.18377664, 0.02286958, 0.05628802},
   {0.17810042, 0.02153175, 0.05436418},
   {0.17242157, 0.02020212, 0.05241613},
   {0.16673885, 0.01888366, 0.05044177},
   {0.16105095, 0.01757931, 0.04843897},
   {0.15535642, 0.01629201, 0.04640560}
};

// https://github.com/1313e/CMasher
const int RGB_Palette_43_Size = 511; // pride
double RGB_Palette_43[RGB_Palette_43_Size][3] =
{
   {0.08752792, 0.05445008, 0.15633391},
   {0.09204695, 0.05639320, 0.16203897},
   {0.09650895, 0.05829607, 0.16786880},
   {0.10090870, 0.06016328, 0.17382488},
   {0.10524039, 0.06200004, 0.17990780},
   {0.10949779, 0.06381198, 0.18611729},
   {0.11367403, 0.06560565, 0.19245137},
   {0.11776199, 0.06738816, 0.19890668},
   {0.12175433, 0.06916725, 0.20547828},
   {0.12564365, 0.07095122, 0.21215945},
   {0.12942267, 0.07274885, 0.21894186},
   {0.13308433, 0.07456920, 0.22581549},
   {0.13662198, 0.07642163, 0.23276864},
   {0.14002950, 0.07831532, 0.23978863},
   {0.14330141, 0.08025937, 0.24686136},
   {0.14643291, 0.08226244, 0.25397225},
   {0.14941998, 0.08433262, 0.26110614},
   {0.15225934, 0.08647727, 0.26824775},
   {0.15494847, 0.08870295, 0.27538192},
   {0.15748551, 0.09101525, 0.28249390},
   {0.15986928, 0.09341878, 0.28956951},
   {0.16209917, 0.09591718, 0.29659525},
   {0.16417504, 0.09851308, 0.30355858},
   {0.16609723, 0.10120815, 0.31044773},
   {0.16786643, 0.10400316, 0.31725196},
   {0.16948361, 0.10689806, 0.32396152},
   {0.17095007, 0.10989202, 0.33056744},
   {0.17226726, 0.11298355, 0.33706178},
   {0.17343684, 0.11617055, 0.34343746},
   {0.17446061, 0.11945041, 0.34968818},
   {0.17534051, 0.12282010, 0.35580842},
   {0.17607859, 0.12627622, 0.36179338},
   {0.17667704, 0.12981506, 0.36763888},
   {0.17713811, 0.13343270, 0.37334141},
   {0.17746410, 0.13712505, 0.37889811},
   {0.17765753, 0.14088788, 0.38430647},
   {0.17772085, 0.14471691, 0.38956469},
   {0.17765681, 0.14860777, 0.39467122},
   {0.17746800, 0.15255614, 0.39962515},
   {0.17715730, 0.15655769, 0.40442584},
   {0.17672775, 0.16060812, 0.40907299},
   {0.17618229, 0.16470324, 0.41356679},
   {0.17552411, 0.16883893, 0.41790767},
   {0.17475650, 0.17301117, 0.42209636},
   {0.17388287, 0.17721606, 0.42613389},
   {0.17290686, 0.18144976, 0.43002153},
   {0.17183216, 0.18570864, 0.43376083},
   {0.17066251, 0.18998919, 0.43735357},
   {0.16940200, 0.19428801, 0.44080170},
   {0.16805489, 0.19860183, 0.44410739},
   {0.16662536, 0.20292760, 0.44727300},
   {0.16511815, 0.20726230, 0.45030103},
   {0.16353786, 0.21160317, 0.45319416},
   {0.16188934, 0.21594754, 0.45595518},
   {0.16017794, 0.22029285, 0.45858702},
   {0.15840893, 0.22463672, 0.46109273},
   {0.15658782, 0.22897695, 0.46347542},
   {0.15472045, 0.23331142, 0.46573832},
   {0.15281289, 0.23763816, 0.46788473},
   {0.15087146, 0.24195534, 0.46991799},
   {0.14890271, 0.24626125, 0.47184151},
   {0.14691347, 0.25055433, 0.47365872},
   {0.14491106, 0.25483305, 0.47537315},
   {0.14290279, 0.25909612, 0.47698827},
   {0.14089618, 0.26334235, 0.47850753},
   {0.13889947, 0.26757056, 0.47993450},
   {0.13692086, 0.27177976, 0.48127266},
   {0.13496883, 0.27596907, 0.48252547},
   {0.13305232, 0.28013764, 0.48369643},
   {0.13118042, 0.28428476, 0.48478897},
   {0.12936216, 0.28840987, 0.48580637},
   {0.12760751, 0.29251232, 0.48675218},
   {0.12592585, 0.29659172, 0.48762958},
   {0.12432688, 0.30064769, 0.48844181},
   {0.12282043, 0.30467992, 0.48919206},
   {0.12141630, 0.30868816, 0.48988346},
   {0.12012416, 0.31267225, 0.49051910},
   {0.11895347, 0.31663207, 0.49110196},
   {0.11791336, 0.32056757, 0.49163494},
   {0.11701255, 0.32447876, 0.49212087},
   {0.11625924, 0.32836571, 0.49256249},
   {0.11566099, 0.33222853, 0.49296243},
   {0.11522492, 0.33606732, 0.49332344},
   {0.11495702, 0.33988228, 0.49364800},
   {0.11486213, 0.34367370, 0.49393834},
   {0.11494478, 0.34744177, 0.49419705},
   {0.11520786, 0.35118683, 0.49442624},
   {0.11565340, 0.35490919, 0.49462809},
   {0.11628239, 0.35860921, 0.49480473},
   {0.11709469, 0.36228726, 0.49495819},
   {0.11808882, 0.36594380, 0.49509011},
   {0.11926311, 0.36957912, 0.49520286},
   {0.12061397, 0.37319378, 0.49529773},
   {0.12213744, 0.37678822, 0.49537642},
   {0.12382885, 0.38036291, 0.49544055},
   {0.12568303, 0.38391827, 0.49549190},
   {0.12769383, 0.38745486, 0.49553160},
   {0.12985495, 0.39097318, 0.49556102},
   {0.13215972, 0.39447374, 0.49558142},
   {0.13460127, 0.39795707, 0.49559400},
   {0.13717257, 0.40142368, 0.49559986},
   {0.13986655, 0.40487412, 0.49560002},
   {0.14267615, 0.40830893, 0.49559543},
   {0.14559445, 0.41172862, 0.49558704},
   {0.14861463, 0.41513371, 0.49557582},
   {0.15172999, 0.41852479, 0.49556227},
   {0.15493410, 0.42190240, 0.49554701},
   {0.15822077, 0.42526707, 0.49553070},
   {0.16158414, 0.42861927, 0.49551431},
   {0.16501848, 0.43195963, 0.49549772},
   {0.16851844, 0.43528863, 0.49548162},
   {0.17207896, 0.43860678, 0.49546650},
   {0.17569522, 0.44191466, 0.49545222},
   {0.17936270, 0.44521270, 0.49543967},
   {0.18307720, 0.44850150, 0.49542829},
   {0.18683470, 0.45178148, 0.49541885},
   {0.19063154, 0.45505319, 0.49541097},
   {0.19446429, 0.45831712, 0.49540465},
   {0.19832966, 0.46157369, 0.49540031},
   {0.20222478, 0.46482343, 0.49539724},
   {0.20614689, 0.46806681, 0.49539538},
   {0.21009336, 0.47130421, 0.49539508},
   {0.21406195, 0.47453613, 0.49539550},
   {0.21805055, 0.47776300, 0.49539633},
   {0.22205719, 0.48098524, 0.49539725},
   {0.22608011, 0.48420325, 0.49539786},
   {0.23011762, 0.48741741, 0.49539800},
   {0.23416837, 0.49062812, 0.49539682},
   {0.23823107, 0.49383575, 0.49539374},
   {0.24230459, 0.49704067, 0.49538818},
   {0.24638792, 0.50024322, 0.49537945},
   {0.25048021, 0.50344372, 0.49536687},
   {0.25458073, 0.50664248, 0.49534967},
   {0.25868887, 0.50983982, 0.49532705},
   {0.26280416, 0.51303600, 0.49529816},
   {0.26692622, 0.51623130, 0.49526213},
   {0.27105469, 0.51942595, 0.49521840},
   {0.27518951, 0.52262020, 0.49516568},
   {0.27933064, 0.52581426, 0.49510297},
   {0.28347814, 0.52900834, 0.49502922},
   {0.28763217, 0.53220259, 0.49494334},
   {0.29179280, 0.53539718, 0.49484473},
   {0.29596043, 0.53859225, 0.49473212},
   {0.30013555, 0.54178792, 0.49460405},
   {0.30431866, 0.54498430, 0.49445941},
   {0.30851002, 0.54818143, 0.49429795},
   {0.31271059, 0.55137942, 0.49411748},
   {0.31692102, 0.55457829, 0.49391701},
   {0.32114182, 0.55777805, 0.49369614},
   {0.32537418, 0.56097873, 0.49345256},
   {0.32961865, 0.56418028, 0.49318613},
   {0.33387640, 0.56738267, 0.49289495},
   {0.33814830, 0.57058585, 0.49257816},
   {0.34243538, 0.57378975, 0.49223461},
   {0.34673877, 0.57699426, 0.49186297},
   {0.35105947, 0.58019927, 0.49146232},
   {0.35539867, 0.58340466, 0.49103141},
   {0.35975757, 0.58661028, 0.49056899},
   {0.36413716, 0.58981597, 0.49007450},
   {0.36853902, 0.59302156, 0.48954576},
   {0.37296371, 0.59622684, 0.48898352},
   {0.37741303, 0.59943162, 0.48838510},
   {0.38188799, 0.60263568, 0.48775010},
   {0.38638958, 0.60583879, 0.48707812},
   {0.39091937, 0.60904071, 0.48636723},
   {0.39547834, 0.61224120, 0.48561706},
   {0.40006746, 0.61544001, 0.48482731},
   {0.40468823, 0.61863685, 0.48399620},
   {0.40934175, 0.62183146, 0.48312299},
   {0.41402871, 0.62502358, 0.48220800},
   {0.41875042, 0.62821291, 0.48124980},
   {0.42350802, 0.63139917, 0.48024749},
   {0.42830248, 0.63458208, 0.47920045},
   {0.43313462, 0.63776134, 0.47810840},
   {0.43800511, 0.64093668, 0.47697128},
   {0.44291513, 0.64410781, 0.47578781},
   {0.44786547, 0.64727443, 0.47455752},
   {0.45285688, 0.65043626, 0.47327996},
   {0.45789008, 0.65359301, 0.47195472},
   {0.46296570, 0.65674441, 0.47058142},
   {0.46808433, 0.65989019, 0.46915974},
   {0.47324633, 0.66303010, 0.46768979},
   {0.47845245, 0.66616385, 0.46617069},
   {0.48370315, 0.66929119, 0.46460213},
   {0.48899883, 0.67241186, 0.46298382},
   {0.49433987, 0.67552562, 0.46131548},
   {0.49972657, 0.67863224, 0.45959684},
   {0.50515923, 0.68173147, 0.45782765},
   {0.51063806, 0.68482310, 0.45600765},
   {0.51616327, 0.68790691, 0.45413659},
   {0.52173499, 0.69098269, 0.45221420},
   {0.52735335, 0.69405024, 0.45024025},
   {0.53301842, 0.69710936, 0.44821445},
   {0.53873026, 0.70015988, 0.44613656},
   {0.54448886, 0.70320160, 0.44400627},
   {0.55029423, 0.70623437, 0.44182330},
   {0.55614598, 0.70925806, 0.43958801},
   {0.56204429, 0.71227248, 0.43729959},
   {0.56798909, 0.71527748, 0.43495760},
   {0.57398027, 0.71827292, 0.43256168},
   {0.58001770, 0.72125865, 0.43011141},
   {0.58610124, 0.72423455, 0.42760637},
   {0.59223071, 0.72720048, 0.42504609},
   {0.59840589, 0.73015634, 0.42243016},
   {0.60462588, 0.73310215, 0.41975946},
   {0.61089116, 0.73603767, 0.41703201},
   {0.61720154, 0.73896279, 0.41424719},
   {0.62355679, 0.74187742, 0.41140432},
   {0.62995669, 0.74478146, 0.40850267},
   {0.63640004, 0.74767501, 0.40554339},
   {0.64288738, 0.75055785, 0.40252410},
   {0.64941862, 0.75342984, 0.39944362},
   {0.65599353, 0.75629090, 0.39630098},
   {0.66261097, 0.75914117, 0.39309691},
   {0.66927108, 0.76198049, 0.38982957},
   {0.67597411, 0.76480867, 0.38649681},
   {0.68271984, 0.76762564, 0.38309731},
   {0.68950640, 0.77043173, 0.37963294},
   {0.69633514, 0.77322649, 0.37609915},
   {0.70320587, 0.77600985, 0.37249427},
   {0.71011710, 0.77878207, 0.36881911},
   {0.71706926, 0.78154293, 0.36507064},
   {0.72406277, 0.78429221, 0.36124564},
   {0.73109609, 0.78703020, 0.35734467},
   {0.73816957, 0.78975670, 0.35336444},
   {0.74528382, 0.79247145, 0.34930088},
   {0.75243681, 0.79517489, 0.34515515},
   {0.75962972, 0.79786659, 0.34092168},
   {0.76686259, 0.80054644, 0.33659700},
   {0.77413333, 0.80321494, 0.33218183},
   {0.78144402, 0.80587139, 0.32766798},
   {0.78879297, 0.80851618, 0.32305486},
   {0.79618046, 0.81114915, 0.31833738},
   {0.80360708, 0.81377001, 0.31350943},
   {0.81107072, 0.81637931, 0.30857037},
   {0.81857375, 0.81897625, 0.30350935},
   {0.82611350, 0.82156155, 0.29832601},
   {0.83369193, 0.82413452, 0.29300924},
   {0.84130759, 0.82669553, 0.28755484},
   {0.84896098, 0.82924432, 0.28195349},
   {0.85665198, 0.83178087, 0.27619635},
   {0.86437995, 0.83430528, 0.27027480},
   {0.87214576, 0.83681719, 0.26417549},
   {0.87994802, 0.83931699, 0.25788906},
   {0.88778819, 0.84180409, 0.25139755},
   {0.89566452, 0.84427902, 0.24468901},
   {0.90357867, 0.84674113, 0.23774045},
   {0.91152892, 0.84919093, 0.23053474},
   {0.91951673, 0.85162784, 0.22304277},
   {0.92754082, 0.85405223, 0.21523836},
   {0.93560204, 0.85646372, 0.20708390},
   {0.94369997, 0.85886238, 0.19853799},
   {0.95183441, 0.86124822, 0.18954940},
   {0.96000625, 0.86362083, 0.18005051},
   {0.96821377, 0.86598077, 0.16996509},
   {0.97645964, 0.86832697, 0.15917699},
   {0.97677870, 0.86238645, 0.15511138},
   {0.97705968, 0.85645921, 0.15107024},
   {0.97730297, 0.85054514, 0.14705473},
   {0.97750893, 0.84464413, 0.14306613},
   {0.97767793, 0.83875607, 0.13910578},
   {0.97781030, 0.83288087, 0.13517518},
   {0.97790635, 0.82701843, 0.13127592},
   {0.97796637, 0.82116867, 0.12740975},
   {0.97799065, 0.81533150, 0.12357856},
   {0.97797944, 0.80950686, 0.11978440},
   {0.97793300, 0.80369466, 0.11602949},
   {0.97785155, 0.79789486, 0.11231628},
   {0.97773531, 0.79210738, 0.10864740},
   {0.97758449, 0.78633217, 0.10502572},
   {0.97739927, 0.78056919, 0.10145437},
   {0.97717983, 0.77481839, 0.09793676},
   {0.97692633, 0.76907975, 0.09447657},
   {0.97663892, 0.76335321, 0.09107784},
   {0.97631776, 0.75763876, 0.08774490},
   {0.97596297, 0.75193638, 0.08448249},
   {0.97557467, 0.74624605, 0.08129571},
   {0.97515298, 0.74056775, 0.07819007},
   {0.97469800, 0.73490149, 0.07517148},
   {0.97421021, 0.72924703, 0.07224664},
   {0.97368951, 0.72360447, 0.06942221},
   {0.97313583, 0.71797393, 0.06670519},
   {0.97254922, 0.71235541, 0.06410312},
   {0.97192977, 0.70674892, 0.06162387},
   {0.97127752, 0.70115449, 0.05927557},
   {0.97059296, 0.69557187, 0.05706716},
   {0.96987609, 0.69000113, 0.05500703},
   {0.96912659, 0.68444251, 0.05310302},
   {0.96834452, 0.67889604, 0.05136321},
   {0.96753005, 0.67336167, 0.04979551},
   {0.96668384, 0.66783904, 0.04840818},
   {0.96580516, 0.66232866, 0.04720612},
   {0.96489405, 0.65683060, 0.04619447},
   {0.96395109, 0.65134452, 0.04537835},
   {0.96297618, 0.64587055, 0.04476016},
   {0.96196892, 0.64040903, 0.04433994},
   {0.96092979, 0.63495970, 0.04411823},
   {0.95985892, 0.62952254, 0.04409312},
   {0.95875575, 0.62409801, 0.04425943},
   {0.95762104, 0.61868564, 0.04461378},
   {0.95645441, 0.61328578, 0.04514863},
   {0.95525570, 0.60789861, 0.04585576},
   {0.95402572, 0.60252363, 0.04672868},
   {0.95276350, 0.59716162, 0.04775541},
   {0.95147004, 0.59181192, 0.04892886},
   {0.95014456, 0.58647519, 0.05023678},
   {0.94878769, 0.58115104, 0.05167074},
   {0.94739902, 0.57583985, 0.05321958},
   {0.94597896, 0.57054142, 0.05487459},
   {0.94452718, 0.56525606, 0.05662539},
   {0.94304413, 0.55998352, 0.05846422},
   {0.94152930, 0.55472430, 0.06038105},
   {0.93998345, 0.54947786, 0.06237007},
   {0.93840582, 0.54424492, 0.06442156},
   {0.93679717, 0.53902496, 0.06653078},
   {0.93515705, 0.53381842, 0.06869001},
   {0.93348553, 0.52862536, 0.07089355},
   {0.93178309, 0.52344548, 0.07313736},
   {0.93004922, 0.51827929, 0.07541504},
   {0.92828420, 0.51312666, 0.07772287},
   {0.92648828, 0.50798748, 0.08005753},
   {0.92466114, 0.50286212, 0.08241431},
   {0.92280285, 0.49775063, 0.08479007},
   {0.92091391, 0.49265267, 0.08718318},
   {0.91899396, 0.48756867, 0.08958983},
   {0.91704306, 0.48249869, 0.09200767},
   {0.91506128, 0.47744277, 0.09443465},
   {0.91304890, 0.47240075, 0.09686954},
   {0.91100584, 0.46737282, 0.09931027},
   {0.90893209, 0.46235912, 0.10175508},
   {0.90682772, 0.45735968, 0.10420269},
   {0.90469280, 0.45237454, 0.10665194},
   {0.90252741, 0.44740376, 0.10910180},
   {0.90033161, 0.44244738, 0.11155136},
   {0.89810556, 0.43750535, 0.11400006},
   {0.89584925, 0.43257782, 0.11644693},
   {0.89356273, 0.42766483, 0.11889128},
   {0.89124607, 0.42276645, 0.12133257},
   {0.88889935, 0.41788270, 0.12377033},
   {0.88652265, 0.41301363, 0.12620414},
   {0.88411603, 0.40815928, 0.12863364},
   {0.88167959, 0.40331967, 0.13105853},
   {0.87921338, 0.39849486, 0.13347855},
   {0.87671751, 0.39368487, 0.13589347},
   {0.87419208, 0.38888967, 0.13830329},
   {0.87163719, 0.38410930, 0.14070781},
   {0.86905287, 0.37934382, 0.14310682},
   {0.86643921, 0.37459325, 0.14550020},
   {0.86379630, 0.36985763, 0.14788787},
   {0.86112421, 0.36513695, 0.15026978},
   {0.85842305, 0.36043124, 0.15264587},
   {0.85569303, 0.35574032, 0.15501666},
   {0.85293413, 0.35106435, 0.15738168},
   {0.85014642, 0.34640335, 0.15974085},
   {0.84733000, 0.34175732, 0.16209419},
   {0.84448512, 0.33712603, 0.16444234},
   {0.84161173, 0.33250963, 0.16678479},
   {0.83870993, 0.32790816, 0.16912146},
   {0.83577992, 0.32332138, 0.17145295},
   {0.83282175, 0.31874937, 0.17377900},
   {0.82983545, 0.31419218, 0.17609933},
   {0.82682132, 0.30964946, 0.17841492},
   {0.82377927, 0.30512146, 0.18072487},
   {0.82070951, 0.30060793, 0.18302979},
   {0.81761212, 0.29610887, 0.18532952},
   {0.81448721, 0.29162419, 0.18762411},
   {0.81133489, 0.28715376, 0.18991373},
   {0.80815526, 0.28269753, 0.19219826},
   {0.80494843, 0.27825537, 0.19447783},
   {0.80171453, 0.27382715, 0.19675251},
   {0.79845361, 0.26941284, 0.19902204},
   {0.79516586, 0.26501213, 0.20128700},
   {0.79185130, 0.26062508, 0.20354673},
   {0.78851009, 0.25625139, 0.20580169},
   {0.78514233, 0.25189095, 0.20805178},
   {0.78174807, 0.24754365, 0.21029670},
   {0.77832746, 0.24320922, 0.21253675},
   {0.77488060, 0.23888748, 0.21477189},
   {0.77140755, 0.23457829, 0.21700180},
   {0.76790841, 0.23028144, 0.21922646},
   {0.76438329, 0.22599663, 0.22144601},
   {0.76083227, 0.22172363, 0.22366036},
   {0.75725543, 0.21746226, 0.22586922},
   {0.75365284, 0.21321223, 0.22807250},
   {0.75002458, 0.20897328, 0.23027008},
   {0.74637073, 0.20474512, 0.23246184},
   {0.74269134, 0.20052745, 0.23464762},
   {0.73898649, 0.19631995, 0.23682727},
   {0.73525623, 0.19212231, 0.23900059},
   {0.73150060, 0.18793417, 0.24116738},
   {0.72771966, 0.18375520, 0.24332741},
   {0.72391343, 0.17958503, 0.24548042},
   {0.72008196, 0.17542328, 0.24762616},
   {0.71622525, 0.17126956, 0.24976431},
   {0.71234333, 0.16712346, 0.25189456},
   {0.70843620, 0.16298456, 0.25401657},
   {0.70450387, 0.15885242, 0.25612995},
   {0.70054631, 0.15472658, 0.25823434},
   {0.69656352, 0.15060653, 0.26032965},
   {0.69255545, 0.14649183, 0.26241508},
   {0.68852207, 0.14238199, 0.26449015},
   {0.68446333, 0.13827647, 0.26655453},
   {0.68037914, 0.13417471, 0.26860782},
   {0.67626946, 0.13007624, 0.27064908},
   {0.67213418, 0.12598043, 0.27267811},
   {0.66797319, 0.12188673, 0.27469408},
   {0.66378640, 0.11779458, 0.27669629},
   {0.65957364, 0.11370335, 0.27868422},
   {0.65533480, 0.10961246, 0.28065688},
   {0.65106969, 0.10552128, 0.28261364},
   {0.64677815, 0.10142921, 0.28455363},
   {0.64245999, 0.09733565, 0.28647567},
   {0.63811495, 0.09323995, 0.28837938},
   {0.63374286, 0.08914155, 0.29026323},
   {0.62934346, 0.08503984, 0.29212617},
   {0.62491645, 0.08093428, 0.29396724},
   {0.62046156, 0.07682433, 0.29578524},
   {0.61597849, 0.07270954, 0.29757868},
   {0.61146692, 0.06858949, 0.29934622},
   {0.60692650, 0.06446386, 0.30108639},
   {0.60235686, 0.06033246, 0.30279764},
   {0.59775761, 0.05619524, 0.30447830},
   {0.59312836, 0.05205234, 0.30612660},
   {0.58846868, 0.04790419, 0.30774064},
   {0.58377813, 0.04375150, 0.30931842},
   {0.57905626, 0.03958633, 0.31085779},
   {0.57430258, 0.03553832, 0.31235659},
   {0.56951656, 0.03174353, 0.31381251},
   {0.56469777, 0.02819987, 0.31522280},
   {0.55984570, 0.02490543, 0.31658479},
   {0.55495972, 0.02185857, 0.31789598},
   {0.55003944, 0.01905721, 0.31915292},
   {0.54508421, 0.01649988, 0.32035290},
   {0.54009364, 0.01418450, 0.32149216},
   {0.53506707, 0.01210967, 0.32256769},
   {0.53000414, 0.01027322, 0.32357540},
   {0.52490435, 0.00867329, 0.32451159},
   {0.51976718, 0.00730801, 0.32537242},
   {0.51459232, 0.00617496, 0.32615352},
   {0.50937942, 0.00527169, 0.32685057},
   {0.50412820, 0.00459550, 0.32745912},
   {0.49883845, 0.00414334, 0.32797456},
   {0.49351007, 0.00391176, 0.32839217},
   {0.48814305, 0.00389685, 0.32870713},
   {0.48273750, 0.00409419, 0.32891454},
   {0.47729369, 0.00449875, 0.32900950},
   {0.47181202, 0.00510487, 0.32898709},
   {0.46629306, 0.00590618, 0.32884247},
   {0.46073754, 0.00689559, 0.32857092},
   {0.45514636, 0.00806527, 0.32816791},
   {0.44952072, 0.00940630, 0.32762900},
   {0.44386196, 0.01090904, 0.32695012},
   {0.43817160, 0.01256314, 0.32612757},
   {0.43245143, 0.01435711, 0.32515798},
   {0.42670346, 0.01627877, 0.32403846},
   {0.42092984, 0.01831523, 0.32276667},
   {0.41513297, 0.02045279, 0.32134077},
   {0.40931540, 0.02267720, 0.31975957},
   {0.40347984, 0.02497369, 0.31802247},
   {0.39762912, 0.02732722, 0.31612956},
   {0.39176619, 0.02972241, 0.31408155},
   {0.38589406, 0.03214387, 0.31187980},
   {0.38001576, 0.03457641, 0.30952634},
   {0.37413435, 0.03700496, 0.30702377},
   {0.36825293, 0.03941467, 0.30437522},
   {0.36237443, 0.04175651, 0.30158440},
   {0.35650177, 0.04396933, 0.29865545},
   {0.35063775, 0.04606145, 0.29559288},
   {0.34478506, 0.04803206, 0.29240158},
   {0.33894627, 0.04988081, 0.28908670},
   {0.33312376, 0.05160777, 0.28565358},
   {0.32731976, 0.05321341, 0.28210775},
   {0.32153630, 0.05469857, 0.27845479},
   {0.31577523, 0.05606435, 0.27470034},
   {0.31003845, 0.05731174, 0.27085009},
   {0.30432731, 0.05844262, 0.26690960},
   {0.29864314, 0.05945880, 0.26288435},
   {0.29298736, 0.06036170, 0.25877985},
   {0.28736075, 0.06115387, 0.25460122},
   {0.28176439, 0.06183698, 0.25035367},
   {0.27619895, 0.06241336, 0.24604208},
   {0.27066497, 0.06288536, 0.24167115},
   {0.26516295, 0.06325514, 0.23724543},
   {0.25969341, 0.06352471, 0.23276936},
   {0.25425646, 0.06369656, 0.22824696},
   {0.24885223, 0.06377292, 0.22368215},
   {0.24348079, 0.06375601, 0.21907864},
   {0.23814208, 0.06364801, 0.21443993},
   {0.23283608, 0.06345087, 0.20976941},
   {0.22756254, 0.06316678, 0.20507013},
   {0.22232111, 0.06279787, 0.20034494},
   {0.21711142, 0.06234614, 0.19559652},
   {0.21193335, 0.06181308, 0.19082768},
   {0.20678617, 0.06120095, 0.18604051},
   {0.20166950, 0.06051127, 0.18123735},
   {0.19658276, 0.05974580, 0.17642018},
   {0.19152541, 0.05890604, 0.17159096},
   {0.18649662, 0.05799375, 0.16675122},
   {0.18149606, 0.05700991, 0.16190292},
   {0.17652272, 0.05595626, 0.15704718},
   {0.17157588, 0.05483404, 0.15218535},
   {0.16665478, 0.05364437, 0.14731867},
   {0.16175869, 0.05238821, 0.14244829},
   {0.15688661, 0.05106677, 0.13757500},
   {0.15203766, 0.04968094, 0.13269961},
   {0.14721089, 0.04823157, 0.12782280},
   {0.14240530, 0.04671941, 0.12294513},
   {0.13761989, 0.04514511, 0.11806704},
   {0.13285355, 0.04350924, 0.11318884},
   {0.12810517, 0.04181228, 0.10831071},
   {0.12337357, 0.04004903, 0.10343270}
};

const int Num_RGB_Palettes = 43;
const int RGB_Palettes_Sizes[Num_RGB_Palettes] =
{
   RGB_Palette_1_Size, RGB_Palette_2_Size, RGB_Palette_3_Size,
   RGB_Palette_4_Size, RGB_Palette_5_Size, RGB_Palette_6_Size,
   RGB_Palette_7_Size, RGB_Palette_8_Size, RGB_Palette_9_Size,
   RGB_Palette_10_Size, RGB_Palette_11_Size, RGB_Palette_12_Size,
   RGB_Palette_13_Size, RGB_Palette_14_Size, RGB_Palette_15_Size,
   RGB_Palette_16_Size, RGB_Palette_17_Size, RGB_Palette_18_Size,
   RGB_Palette_19_Size, RGB_Palette_20_Size, RGB_Palette_21_Size,
   RGB_Palette_22_Size, RGB_Palette_23_Size, RGB_Palette_24_Size,
   RGB_Palette_25_Size, RGB_Palette_26_Size, RGB_Palette_27_Size,
   RGB_Palette_28_Size, RGB_Palette_29_Size, RGB_Palette_30_Size,
   RGB_Palette_31_Size, RGB_Palette_32_Size, RGB_Palette_33_Size,
   RGB_Palette_34_Size, RGB_Palette_35_Size, RGB_Palette_36_Size,
   RGB_Palette_37_Size, RGB_Palette_38_Size, RGB_Palette_39_Size,
   RGB_Palette_40_Size, RGB_Palette_41_Size, RGB_Palette_42_Size,
   RGB_Palette_43_Size
};

double *RGB_Palettes[Num_RGB_Palettes] =
{
   *RGB_Palette_1, *RGB_Palette_2, *RGB_Palette_3, *RGB_Palette_4,
   *RGB_Palette_5, *RGB_Palette_6, *RGB_Palette_7, *RGB_Palette_8,
   *RGB_Palette_9, *RGB_Palette_10, *RGB_Palette_11, *RGB_Palette_12,
   *RGB_Palette_13, *RGB_Palette_14, *RGB_Palette_15, *RGB_Palette_16,
   *RGB_Palette_17, *RGB_Palette_18, *RGB_Palette_19, *RGB_Palette_20,
   *RGB_Palette_21, *RGB_Palette_22, *RGB_Palette_23, *RGB_Palette_24,
   *RGB_Palette_25, *RGB_Palette_26, *RGB_Palette_27, *RGB_Palette_28,
   *RGB_Palette_29, *RGB_Palette_30, *RGB_Palette_31, *RGB_Palette_32,
   *RGB_Palette_33, *RGB_Palette_34, *RGB_Palette_35, *RGB_Palette_36,
   *RGB_Palette_37, *RGB_Palette_38, *RGB_Palette_39, *RGB_Palette_40,
   *RGB_Palette_41, *RGB_Palette_42, *RGB_Palette_43
};

const char *RGB_Palettes_Names[Num_RGB_Palettes] =
{
   //  0123456789
   "5-color   ", "red       ", "jet-like  ", "coldhot   ", "bone      ",
   "hot       ", "pink      ", "cool      ", "summer    ", "hsv       ",
   "copper    ", "white     ", "vivid     ", "aluminum  ", "sunrise   ",
   "horizon   ", "byr       ", "ocean     ", "pastel    ", "tropical  ",
   "wood      ", "mars      ", "rainbow   ", "cmyk      ", "calewhite ",
   "haxby     ", "manga     ", "drywet    ", "gfdl      ", "wbgyr     ",
   "seq25     ", "terrain   ", "bwor      ", "19-lev    ", "lithology ",
   "gray      ", "turbo     ", "viridis   ", "plasma    ", "fusion    ",
   "iceburn   ", "viola     ", "pride     "
};

double corr(double a, double x)
{
   return x / (1.0 + (a * a - 1.0) * (1.0 - x));
   //   return pow(x, a);
}

void Init_Visit_Calewhite_Palette()
{
   const int ns = 7;
   const double ts[ns] = { 0., 1./6., 2./6., 3./6., 4./6., 5./6., 1. };

   const double rs[ns] = { 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0 };
   const double gs[ns] = { 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0 };
   const double bs[ns] = { 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0 };
   const double rc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };
   const double gc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };
   const double bc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };

   for (int i = 0; i < RGB_Palette_25_Size; i++)
   {
      double t = double(i) / (RGB_Palette_25_Size-1), r, g, b;
      int k;
      for (k = 1; k < ns; k++)
         if (t >= ts[k-1] && t <= ts[k])
         {
            break;
         }
      t = (t - ts[k-1]) / (ts[k] - ts[k-1]);
      r = (1.0 - t) * corr(rc[k-1], rs[k-1]) + t * corr(rc[k-1], rs[k]);
      g = (1.0 - t) * corr(gc[k-1], gs[k-1]) + t * corr(gc[k-1], gs[k]);
      b = (1.0 - t) * corr(bc[k-1], bs[k-1]) + t * corr(bc[k-1], bs[k]);
      RGB_Palette_25[i][0] = corr(1./rc[k-1], r);
      RGB_Palette_25[i][1] = corr(1./gc[k-1], g);
      RGB_Palette_25[i][2] = corr(1./bc[k-1], b);
   }
}

void Init_Palettes()
{
   static bool first_init = true;
   if (first_init)
   {
      // init rainbow palette
      for (int i = 0; i < RGB_Palette_23_Size; i++)
      {
         double t = double(i) / (RGB_Palette_23_Size-1), s, r, g, b;
         // t *= 3.0; // red to red
         t *= 2.5; // red to purple
         if (t < 1.0)
         {
            s = sin(t * M_PI);
            if (t < 0.5)
            {
               r = 1.0;
               g = s;
            }
            else
            {
               r = s;
               g = 1.0;
            }
            b = 0.0;
         }
         else if (t < 2.0)
         {
            s = sin((t - 1.0) * M_PI);
            if (t < 1.5)
            {
               g = 1.0;
               b = s;
            }
            else
            {
               g = s;
               b = 1.0;
            }
            r = 0.0;
         }
         else
         {
            s = sin((t - 2.0) * M_PI);
            if (t < 2.5)
            {
               r = s;
               b = 1.0;
            }
            else
            {
               r = 1.0;
               b = s;
            }
            g = 0.0;
         }
         RGB_Palette_23[i][0] = r;
         RGB_Palette_23[i][1] = g;
         RGB_Palette_23[i][2] = b;
      }

      // init vivid palette
      const int ns = 7;
      const double ts[ns] = { 0., 3./16., 4./16., 1./2., 12./16., 13./16., 1. };

      const double rs[ns] = { 0.0, 0.0, 0.0, 1.0, 0.9, 1.0, 0.5 };
      const double gs[ns] = { 0.0, 1.0, 0.9, 1.0, 0.0, 0.0, 0.0 };
      const double bs[ns] = { 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0 };
      const double rc[ns-1] = { 1.0, 1.0, 1.3, 1.0, 1.0, 1.2 };
      const double gc[ns-1] = { 1.2, 1.0, 1.0, 1.4, 1.0, 1.0 };
      const double bc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.6, 1.0 };

      for (int i = 0; i < RGB_Palette_13_Size; i++)
      {
         double t = double(i) / (RGB_Palette_13_Size-1), r, g, b;
         int k;
         for (k = 1; k < ns; k++)
            if (t >= ts[k-1] && t <= ts[k])
            {
               break;
            }
         t = (t - ts[k-1]) / (ts[k] - ts[k-1]);
         r = (1.0 - t) * corr(rc[k-1], rs[k-1]) + t * corr(rc[k-1], rs[k]);
         g = (1.0 - t) * corr(gc[k-1], gs[k-1]) + t * corr(gc[k-1], gs[k]);
         b = (1.0 - t) * corr(bc[k-1], bs[k-1]) + t * corr(bc[k-1], bs[k]);
         RGB_Palette_13[i][0] = corr(1./rc[k-1], r);
         RGB_Palette_13[i][1] = corr(1./gc[k-1], g);
         RGB_Palette_13[i][2] = corr(1./bc[k-1], b);
      }

      Init_Visit_Calewhite_Palette();

      // init gray palette
      for (int i = 0; i < RGB_Palette_36_Size; i++)
      {
         double t = double(i) / (RGB_Palette_36_Size-1);
         RGB_Palette_36[i][0] = t;
         RGB_Palette_36[i][1] = t;
         RGB_Palette_36[i][2] = t;
      }
      first_init = false;
   }
}

int PaletteState::ChoosePalette()
{
   const int buflen = 256;
   char buffer[buflen];
   int pal;
   cout << "Choose a palette:\n";
   for (pal = 0; pal < Num_RGB_Palettes; pal++)
   {
      cout << setw(4) << pal+1 << ") " << RGB_Palettes_Names[pal];
      if ((pal+1)%5 == 0)
      {
         cout << '\n';
      }
   }
   cout << "\n ---> [" << curr_palette+1 << "] " << flush;

   cin.getline (buffer, buflen);
   cin.getline (buffer, buflen);

   if (buffer[0])
   {
      sscanf(buffer, "%i", &pal);
   }
   else
   {
      pal = curr_palette+1;
   }

   if (pal < 1)
   {
      pal = 1;
   }
   else if (pal > Num_RGB_Palettes)
   {
      pal = Num_RGB_Palettes;
   }

   return pal-1;
}


// Generates a discrete texture from the given palette.
void PaletteState::ToTextureDiscrete(double * palette, size_t plt_size,
                                     GLuint tex)
{
   vector<array<float,4>> texture_buf(plt_size);

   if (RepeatPaletteTimes > 0)
   {
      for (size_t i = 0; i < plt_size; i++)
      {
         texture_buf[i] =
         {
            (float) palette[3*i],
            (float) palette[3*i+1],
            (float) palette[3*i+2],
            1.0
         };
      }
   }
   else
   {
      for (size_t i = 0; i < plt_size; i++)
      {
         texture_buf[i] =
         {
            (float) palette[3*(plt_size-1-i)+0],
            (float) palette[3*(plt_size-1-i)+1],
            (float) palette[3*(plt_size-1-i)+2],
            1.0
         };
      }
   }
   if (PaletteNumColors > 1 && (plt_size > (size_t)PaletteNumColors))
   {
      texture_buf.resize(PaletteNumColors);
      for (int i = 0; i < PaletteNumColors; i++)
      {
         int plt_i = i * plt_size / (PaletteNumColors-1);
         if (i >= PaletteNumColors - 1)
         {
            plt_i = plt_size - 1;
         }
         if (RepeatPaletteTimes < 0)
         {
            plt_i = plt_size-1-plt_i;
         }
         texture_buf[i] =
         {
            (float) palette[3*plt_i],
            (float) palette[3*plt_i+1],
            (float) palette[3*plt_i+2],
            1.0
         };
      }
      plt_size = PaletteNumColors;
   }
   glBindTexture(GL_TEXTURE_2D, tex);
   glTexImage2D(GL_TEXTURE_2D,
                0,
                rgba_internal,
                plt_size,
                1,
                0,
                GL_RGBA,
                GL_FLOAT,
                texture_buf.data());

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
}

// Generates a smooth texture from the given palette.
void PaletteState::ToTextureSmooth(double * palette, size_t plt_size,
                                   GLuint tex)
{
   vector<array<float,4>> texture_buf(MaxTextureSize);
   glBindTexture(GL_TEXTURE_2D, tex);

   size_t textureSize = MaxTextureSize;
   if (plt_size * abs(RepeatPaletteTimes) <= textureSize)
   {
      int flip_start = RepeatPaletteTimes < 0;
      for (int rpt = 0; rpt < abs(RepeatPaletteTimes); rpt++)
      {
         for (size_t i = 0; i < plt_size; i++)
         {
            // flip = 0: p_i = i
            // flip = 1: p_i = plt_size-1-i
            int p_i = (flip_start + rpt) % 2 == 0 ? i : plt_size - 1 - i;
            texture_buf[i + plt_size * rpt] =
            {
               (float) palette[3*p_i],
               (float) palette[3*p_i + 1],
               (float) palette[3*p_i + 2],
               1.0
            };
         }
      }
      glTexImage2D(GL_TEXTURE_2D, 0, rgba_internal,
                   plt_size * abs(RepeatPaletteTimes), 1,
                   0, GL_RGBA, GL_FLOAT, texture_buf.data());
   }
   else
   {
      for (size_t i = 0; i < textureSize; i++)
      {
         double t = double(i) / textureSize - 1;
         t *= 0.999999999 * (plt_size - 1) * abs(RepeatPaletteTimes);
         int j = floor(t);
         t -= j;
         int p_i;
         if (((j / (plt_size-1)) % 2 == 0 && RepeatPaletteTimes > 0) ||
             ((j / (plt_size-1)) % 2 == 1 && RepeatPaletteTimes < 0))
         {
            p_i = j % (plt_size - 1);
         }
         else
         {
            p_i = plt_size - 2 - j % (plt_size - 1);
            t = 1.0 - t;
         }
         texture_buf[i] =
         {
            (float)((1.0-t) * palette[3*p_i] + t * palette[3*(p_i+1)]),
            (float)((1.0-t) * palette[3*p_i+1] + t * palette[3*(p_i+1)+1]),
            (float)((1.0-t) * palette[3*p_i+2] + t * palette[3*(p_i+1)+2]),
            1.0
         };
      }
      glTexImage2D(GL_TEXTURE_2D, 0, rgba_internal,
                   textureSize, 1,
                   0, GL_RGBA, GL_FLOAT, texture_buf.data());
   }

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
}

PaletteState::PaletteState()
   : palette_tex(Num_RGB_Palettes)
   , first_init(false)
{
}

static std::mutex init_mtx;

void PaletteState::Init()
{
   if (!first_init)
   {
      glGetIntegerv(GL_MAX_TEXTURE_SIZE, &MaxTextureSize);
      if (MaxTextureSize < 4096)
      {
         cerr << "Warning: GL_MAX_TEXTURE_SIZE is less than 4096." << endl;
      }
      MaxTextureSize = std::min(MaxTextureSize, 4096);
      {
         std::lock_guard<std::mutex> lk{init_mtx};
         Init_Palettes();
      }

      GLuint paletteTexIds[Num_RGB_Palettes][2];
      GLuint alphaTexId;

      glGenTextures(Num_RGB_Palettes * 2, &(paletteTexIds[0][0]));
      glGenTextures(1, &alphaTexId);

      for (int ipal = 0; ipal < Num_RGB_Palettes; ipal++)
      {
         palette_tex[ipal][0] = paletteTexIds[ipal][0];
         palette_tex[ipal][1] = paletteTexIds[ipal][1];
      }
      alpha_tex = alphaTexId;

      GLenum alpha_internal;
      if (gl3::GLDevice::useLegacyTextureFmts())
      {
         alpha_internal = GL_ALPHA;
         alpha_channel = GL_ALPHA;
         rgba_internal = GL_RGBA;
      }
      else
      {
         // WebGL 2 requires sized internal format for float texture
         alpha_internal = GL_R32F;
         alpha_channel = GL_RED;
         rgba_internal = GL_RGBA32F;
      }
      // set alpha texture to 1.0
      std::vector<float> alphaTexData(MaxTextureSize);
      std::fill(alphaTexData.begin(), alphaTexData.end(), 1.0f);
      glActiveTexture(GL_TEXTURE1);
      glBindTexture(GL_TEXTURE_2D, alpha_tex);
      glTexImage2D(GL_TEXTURE_2D, 0, alpha_internal, MaxTextureSize, 1, 0,
                   alpha_channel, GL_FLOAT, alphaTexData.data());
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

      glActiveTexture(GL_TEXTURE0);
      first_init = true;
   }

   for (int i = 0; i < Num_RGB_Palettes; i++)
   {
      ToTextureDiscrete(RGB_Palettes[i], RGB_Palettes_Sizes[i],
                        palette_tex[i][0]);
      ToTextureSmooth(RGB_Palettes[i], RGB_Palettes_Sizes[i],
                      palette_tex[i][1]);
   }
}



double PaletteState::GetColorCoord(double val, double min, double max)
{
   // static double eps = 1e-24;
   static const double eps = 0.0;
   if (use_logscale)
   {
      if (val < min)
      {
         val = min;
      }
      if (val > max)
      {
         val = max;
      }
      return log(fabs(val/(min+eps))) / (log(fabs(max/(min+eps)))+eps);
   }
   else
   {
      return ((val-min)/(max-min));
   }
}

void PaletteState::GetColorFromVal(double val, float * rgba)
{
   int palSize = RGB_Palettes_Sizes[curr_palette];
   const double* palData = RGB_Palettes[curr_palette];
   val *= 0.999999999 * ( palSize - 1 ) * abs(RepeatPaletteTimes);
   int i = (int) floor( val );
   double t = val - i;

   const double* pal;
   if (((i / (palSize-1)) % 2 == 0 && RepeatPaletteTimes > 0) ||
       ((i / (palSize-1)) % 2 == 1 && RepeatPaletteTimes < 0))
   {
      pal = palData + 3 * ( i % (palSize-1) );
   }
   else
   {
      pal = palData + 3 * ( (palSize-2) - i % (palSize-1) );
      t = 1.0 - t;
   }
   rgba[0] = (1.0 - t) * pal[0] + t * pal[3];
   rgba[1] = (1.0 - t) * pal[1] + t * pal[4];
   rgba[2] = (1.0 - t) * pal[2] + t * pal[5];
   rgba[3] = 1.f;
}

const double * PaletteState::GetData() const
{
   return RGB_Palettes[curr_palette];
}

int PaletteState::GetSize(int pal) const
{
   if (pal == -1)
   {
      return RGB_Palettes_Sizes[curr_palette];
   }
   return RGB_Palettes_Sizes[pal];
}

void PaletteState::GenerateAlphaTexture(float matAlpha, float matAlphaCenter)
{
   std::vector<float> alphaTexData(MaxTextureSize);
   if (matAlpha >= 1.0)
   {
      // transparency off
      std::fill(alphaTexData.begin(), alphaTexData.end(), 1.0f);
   }
   else
   {
      for (int i = 0; i < MaxTextureSize; i++)
      {
         double val = double(2*i + 1)/(2*MaxTextureSize); // midpoint of texel
         if (matAlphaCenter > 1.0)
         {
            alphaTexData[i] = matAlpha * std::exp(-(matAlphaCenter)*std::abs(val - 1.0));
         }
         else if (matAlphaCenter < 0.0)
         {
            alphaTexData[i] = matAlpha * std::exp((matAlphaCenter - 1.0)*std::abs(val));
         }
         else
         {
            alphaTexData[i] = matAlpha * std::exp(-std::abs(val - matAlphaCenter));
         }
      }
   }
   glActiveTexture(GL_TEXTURE1);
   glBindTexture(GL_TEXTURE_2D, alpha_tex);
   glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, MaxTextureSize, 1, alpha_channel,
                   GL_FLOAT, alphaTexData.data());
   glActiveTexture(GL_TEXTURE0);
}

void PaletteState::NextIndex()
{
   SetIndex((curr_palette + 1) % Num_RGB_Palettes);
}

void PaletteState::PrevIndex()
{
   SetIndex((curr_palette == 0) ? Num_RGB_Palettes - 1 :
            curr_palette - 1);
}

int PaletteState::SelectNewRGBPalette()
{
   int pal = ChoosePalette();

   SetIndex(pal);

   return pal;
}
