/* This is an example HY-PHY Batch File.



   It reads in a PHYLIP amino-acid dataset data/stewart.aa and estimates

   maximum ln-likelihood based on the tree contained in the data file,

   using Equal Input (proportional) model for amino-acids.

   

   Output is printed out as a Newick Style tree with branch lengths

   representing the number of expected substitutions per branch (which

   is the default setting for nucleotide models w/o rate variation).

   

   

   Sergei L. Kosakovsky Pond and Spencer V. Muse 

   December 1999. 

*/



/* 1. Read in the data and store the result in a DataSet variable.*/



DataSet 		aaSequences = ReadDataFile ("data/stewart.aa");

   

/* 2. Filter the data, specifying that all of the data is to be used

	  and that it is to be treated as amino-acids.*/

	  

DataSetFilter	filteredData = CreateFilter (aaSequences,1);



/* 3. Collect observed frequencies from the filtered data. observedFreq will store the vector of amino-acid frequencies. */



HarvestFrequencies (observedFreqs, filteredData, 1, 1, 1);



/* 4. Defines the rate matrix for the equal input model. */



EEAA = {20,20};  /* Create an empty 20x20 matrix named EEAA */



for (i=0; i<19;i=i+1)

{

	for (j=i+1; j<20; j=j+1)

	{

		EEAA[i][j]:=a;

		EEAA[j][i]:=a;			

	}

}



Model EqualInputModel = (EEAA, observedFreqs);



/*5.  Define the tree variable, using the tree from the data */

	  

Tree	theTree = DATAFILE_TREE;



/*6.  Since all the likelihood function ingredients (data, tree, equilibrium frequencies) have been defined we are ready to construct the likelihood function. */

	  

LikelihoodFunction  theLnLik = (filteredData, theTree);



/*7.  Maximize the likelihood function, storing parameter values in the matrix paramValues */



Optimize (paramValues, theLnLik);



/*8.  Print the tree with optimal branch lengths to the console. */



fprintf  (stdout, theLnLik);

		 

   

