/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_c_cs.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t5, t6, t8, t10, t11, t12;
  double t14, t15, t16, t17, t18, t19, t21, t23;
  double t29, t31, t36, t39, tzk0;


  t2 = POW_1_3(rho[0]);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 + 0.34899999999999999998e0 * t3;
  t6 = 0.1e1 / t5;
  t8 = exp(-0.2533e0 * t3);
  t10 = p->zeta_threshold * p->zeta_threshold;
  t11 = POW_1_3(p->zeta_threshold);
  t12 = t11 * t11;
  t14 = my_piecewise3(0.1e1 <= p->zeta_threshold, t12 * t10, 1);
  t15 = M_CBRT2;
  t16 = t14 * t15;
  t17 = t15 * t15;
  t18 = tau[0] * t17;
  t19 = t2 * t2;
  t21 = 0.1e1 / t19 / rho[0];
  t23 = lapl[0] * t17;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t19 / t29;
  t36 = t16 * (t18 * t21 - t23 * t21 / 0.8e1) / 0.4e1 - sigma[0] * t31 / 0.8e1 + lapl[0] * t21 / 0.8e1;
  t39 = 0.1e1 + 0.264e0 * t8 * t36;
  tzk0 = -0.4918e-1 * t6 * t39;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t5, t6, t8, t10, t11, t12;
  double t14, t15, t16, t17, t18, t19, t21, t23;
  double t29, t31, t36, t39, tzk0;

  double t42, t43, t44, t47, t49, t50, t60, t62;
  double t67, t70, tvrho0, t73, tvsigma0, t78, t79, tvlapl0;
  double t84, tvtau0;


  t2 = POW_1_3(rho[0]);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 + 0.34899999999999999998e0 * t3;
  t6 = 0.1e1 / t5;
  t8 = exp(-0.2533e0 * t3);
  t10 = p->zeta_threshold * p->zeta_threshold;
  t11 = POW_1_3(p->zeta_threshold);
  t12 = t11 * t11;
  t14 = my_piecewise3(0.1e1 <= p->zeta_threshold, t12 * t10, 1);
  t15 = M_CBRT2;
  t16 = t14 * t15;
  t17 = t15 * t15;
  t18 = tau[0] * t17;
  t19 = t2 * t2;
  t21 = 0.1e1 / t19 / rho[0];
  t23 = lapl[0] * t17;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t19 / t29;
  t36 = t16 * (t18 * t21 - t23 * t21 / 0.8e1) / 0.4e1 - sigma[0] * t31 / 0.8e1 + lapl[0] * t21 / 0.8e1;
  t39 = 0.1e1 + 0.264e0 * t8 * t36;
  tzk0 = -0.4918e-1 * t6 * t39;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = t5 * t5;
  t43 = 0.1e1 / t42;
  t44 = t3 * t43;
  t47 = rho[0] * t6;
  t49 = 0.1e1 / t2 / rho[0];
  t50 = t49 * t8;
  t60 = t29 * rho[0];
  t62 = 0.1e1 / t19 / t60;
  t67 = t16 * (-0.5e1 / 0.3e1 * t18 * t31 + 0.5e1 / 0.24e2 * t23 * t31) / 0.4e1 + sigma[0] * t62 / 0.3e1 - 0.5e1 / 0.24e2 * lapl[0] * t31;
  t70 = 0.222904e-1 * t50 * t36 + 0.264e0 * t8 * t67;
  tvrho0 = tzk0 - 0.57212733333333333332e-2 * t44 * t39 - 0.4918e-1 * t47 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t73 = t21 * t6;
  tvsigma0 = 0.162294e-2 * t73 * t8;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t78 = -t14 * t21 / 0.16e2 + t21 / 0.8e1;
  t79 = t8 * t78;
  tvlapl0 = -0.1298352e-1 * t47 * t79;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t84 = t8 * t14;
  tvtau0 = -0.649176e-2 / t19 * t6 * t84;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t5, t6, t8, t10, t11, t12;
  double t14, t15, t16, t17, t18, t19, t21, t23;
  double t29, t31, t36, t39, tzk0;

  double t42, t43, t44, t47, t49, t50, t60, t62;
  double t67, t70, tvrho0, t73, tvsigma0, t78, t79, tvlapl0;
  double t84, tvtau0;

  double t87, t93, t94, t100, t101, t104, t116, t118;
  double t123, t126, tv2rho20, t129, t132, t133, t136, tv2rhosigma0;
  double t139, t144, t150, t151, tv2rholapl0, t156, tv2rhotau0, tv2sigma20;
  double tv2sigmalapl0, tv2sigmatau0, tv2lapl20, tv2lapltau0, tv2tau20;


  t2 = POW_1_3(rho[0]);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 + 0.34899999999999999998e0 * t3;
  t6 = 0.1e1 / t5;
  t8 = exp(-0.2533e0 * t3);
  t10 = p->zeta_threshold * p->zeta_threshold;
  t11 = POW_1_3(p->zeta_threshold);
  t12 = t11 * t11;
  t14 = my_piecewise3(0.1e1 <= p->zeta_threshold, t12 * t10, 1);
  t15 = M_CBRT2;
  t16 = t14 * t15;
  t17 = t15 * t15;
  t18 = tau[0] * t17;
  t19 = t2 * t2;
  t21 = 0.1e1 / t19 / rho[0];
  t23 = lapl[0] * t17;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t19 / t29;
  t36 = t16 * (t18 * t21 - t23 * t21 / 0.8e1) / 0.4e1 - sigma[0] * t31 / 0.8e1 + lapl[0] * t21 / 0.8e1;
  t39 = 0.1e1 + 0.264e0 * t8 * t36;
  tzk0 = -0.4918e-1 * t6 * t39;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = t5 * t5;
  t43 = 0.1e1 / t42;
  t44 = t3 * t43;
  t47 = rho[0] * t6;
  t49 = 0.1e1 / t2 / rho[0];
  t50 = t49 * t8;
  t60 = t29 * rho[0];
  t62 = 0.1e1 / t19 / t60;
  t67 = t16 * (-0.5e1 / 0.3e1 * t18 * t31 + 0.5e1 / 0.24e2 * t23 * t31) / 0.4e1 + sigma[0] * t62 / 0.3e1 - 0.5e1 / 0.24e2 * lapl[0] * t31;
  t70 = 0.222904e-1 * t50 * t36 + 0.264e0 * t8 * t67;
  tvrho0 = tzk0 - 0.57212733333333333332e-2 * t44 * t39 - 0.4918e-1 * t47 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t73 = t21 * t6;
  tvsigma0 = 0.162294e-2 * t73 * t8;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t78 = -t14 * t21 / 0.16e2 + t21 / 0.8e1;
  t79 = t8 * t78;
  tvlapl0 = -0.1298352e-1 * t47 * t79;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t84 = t8 * t14;
  tvtau0 = -0.649176e-2 / t19 * t6 * t84;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t87 = t43 * t39;
  t93 = 0.1e1 / t42 / t5;
  t94 = t21 * t93;
  t100 = 0.1e1 / t2 / t29;
  t101 = t100 * t8;
  t104 = t31 * t8;
  t116 = t29 * t29;
  t118 = 0.1e1 / t19 / t116;
  t123 = t16 * (0.4e2 / 0.9e1 * t18 * t62 - 0.5e1 / 0.9e1 * t23 * t62) / 0.4e1 - 0.11e2 / 0.9e1 * sigma[0] * t118 + 0.5e1 / 0.9e1 * lapl[0] * t62;
  t126 = -0.29720533333333333333e-1 * t101 * t36 + 0.18820527733333333333e-2 * t104 * t36 + 0.445808e-1 * t50 * t67 + 0.264e0 * t8 * t123;
  tv2rho20 = -0.38141822222222222221e-2 * t87 * t49 - 0.9836e-1 * t6 * t70 - 0.13311495955555555555e-2 * t94 * t39 - 0.11442546666666666666e-1 * t44 * t70 - 0.4918e-1 * t47 * t126;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t129 = t31 * t6;
  t132 = 0.1e1 / t60;
  t133 = t132 * t43;
  t136 = t132 * t6;
  tv2rhosigma0 = -0.27049e-2 * t129 * t8 + 0.18880201999999999999e-3 * t133 * t8 + 0.137030234e-3 * t136 * t8;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t139 = t6 * t8;
  t144 = t3 * t6;
  t150 = 0.5e1 / 0.48e2 * t14 * t31 - 0.5e1 / 0.24e2 * t31;
  t151 = t8 * t150;
  tv2rholapl0 = -0.1298352e-1 * t139 * t78 - 0.151041616e-2 * t44 * t79 - 0.1096241872e-2 * t144 * t79 - 0.1298352e-1 * t47 * t151;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t156 = 0.1e1 / t29;
  tv2rhotau0 = 0.432784e-2 * t73 * t84 - 0.75520807999999999998e-3 * t156 * t43 * t84 - 0.548120936e-3 * t156 * t6 * t84;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t5, t6, t8, t10, t11, t12;
  double t14, t15, t16, t17, t18, t19, t21, t23;
  double t29, t31, t36, t39, tzk0;

  double t42, t43, t44, t47, t49, t50, t60, t62;
  double t67, t70, tvrho0, t73, tvsigma0, t78, t79, tvlapl0;
  double t84, tvtau0;

  double t87, t93, t94, t100, t101, t104, t116, t118;
  double t123, t126, tv2rho20, t129, t132, t133, t136, tv2rhosigma0;
  double t139, t144, t150, t151, tv2rholapl0, t156, tv2rhotau0, tv2sigma20;
  double tv2sigmalapl0, tv2sigmatau0, tv2lapl20, tv2lapltau0, tv2tau20;

  double t163, t166, t173, t174, t175, t183, t184, t187;
  double t192, t193, t207, t209, t214, t217, tv3rho30, t220;
  double t223, t226, t230, t231, t234, t237, tv3rho2sigma0, t240;
  double t244, t251, t263, t264, tv3rho2lapl0, tv3rho2tau0, tv3rhosigma20, tv3rhosigmalapl0;
  double tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, tv3rhotau20, tv3sigma30, tv3sigma2lapl0, tv3sigma2tau0, tv3sigmalapl20;
  double tv3sigmalapltau0, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;


  t2 = POW_1_3(rho[0]);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 + 0.34899999999999999998e0 * t3;
  t6 = 0.1e1 / t5;
  t8 = exp(-0.2533e0 * t3);
  t10 = p->zeta_threshold * p->zeta_threshold;
  t11 = POW_1_3(p->zeta_threshold);
  t12 = t11 * t11;
  t14 = my_piecewise3(0.1e1 <= p->zeta_threshold, t12 * t10, 1);
  t15 = M_CBRT2;
  t16 = t14 * t15;
  t17 = t15 * t15;
  t18 = tau[0] * t17;
  t19 = t2 * t2;
  t21 = 0.1e1 / t19 / rho[0];
  t23 = lapl[0] * t17;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t19 / t29;
  t36 = t16 * (t18 * t21 - t23 * t21 / 0.8e1) / 0.4e1 - sigma[0] * t31 / 0.8e1 + lapl[0] * t21 / 0.8e1;
  t39 = 0.1e1 + 0.264e0 * t8 * t36;
  tzk0 = -0.4918e-1 * t6 * t39;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = t5 * t5;
  t43 = 0.1e1 / t42;
  t44 = t3 * t43;
  t47 = rho[0] * t6;
  t49 = 0.1e1 / t2 / rho[0];
  t50 = t49 * t8;
  t60 = t29 * rho[0];
  t62 = 0.1e1 / t19 / t60;
  t67 = t16 * (-0.5e1 / 0.3e1 * t18 * t31 + 0.5e1 / 0.24e2 * t23 * t31) / 0.4e1 + sigma[0] * t62 / 0.3e1 - 0.5e1 / 0.24e2 * lapl[0] * t31;
  t70 = 0.222904e-1 * t50 * t36 + 0.264e0 * t8 * t67;
  tvrho0 = tzk0 - 0.57212733333333333332e-2 * t44 * t39 - 0.4918e-1 * t47 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t73 = t21 * t6;
  tvsigma0 = 0.162294e-2 * t73 * t8;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t78 = -t14 * t21 / 0.16e2 + t21 / 0.8e1;
  t79 = t8 * t78;
  tvlapl0 = -0.1298352e-1 * t47 * t79;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t84 = t8 * t14;
  tvtau0 = -0.649176e-2 / t19 * t6 * t84;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t87 = t43 * t39;
  t93 = 0.1e1 / t42 / t5;
  t94 = t21 * t93;
  t100 = 0.1e1 / t2 / t29;
  t101 = t100 * t8;
  t104 = t31 * t8;
  t116 = t29 * t29;
  t118 = 0.1e1 / t19 / t116;
  t123 = t16 * (0.4e2 / 0.9e1 * t18 * t62 - 0.5e1 / 0.9e1 * t23 * t62) / 0.4e1 - 0.11e2 / 0.9e1 * sigma[0] * t118 + 0.5e1 / 0.9e1 * lapl[0] * t62;
  t126 = -0.29720533333333333333e-1 * t101 * t36 + 0.18820527733333333333e-2 * t104 * t36 + 0.445808e-1 * t50 * t67 + 0.264e0 * t8 * t123;
  tv2rho20 = -0.38141822222222222221e-2 * t87 * t49 - 0.9836e-1 * t6 * t70 - 0.13311495955555555555e-2 * t94 * t39 - 0.11442546666666666666e-1 * t44 * t70 - 0.4918e-1 * t47 * t126;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t129 = t31 * t6;
  t132 = 0.1e1 / t60;
  t133 = t132 * t43;
  t136 = t132 * t6;
  tv2rhosigma0 = -0.27049e-2 * t129 * t8 + 0.18880201999999999999e-3 * t133 * t8 + 0.137030234e-3 * t136 * t8;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t139 = t6 * t8;
  t144 = t3 * t6;
  t150 = 0.5e1 / 0.48e2 * t14 * t31 - 0.5e1 / 0.24e2 * t31;
  t151 = t8 * t150;
  tv2rholapl0 = -0.1298352e-1 * t139 * t78 - 0.151041616e-2 * t44 * t79 - 0.1096241872e-2 * t144 * t79 - 0.1298352e-1 * t47 * t151;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t156 = 0.1e1 / t29;
  tv2rhotau0 = 0.432784e-2 * t73 * t84 - 0.75520807999999999998e-3 * t156 * t43 * t84 - 0.548120936e-3 * t156 * t6 * t84;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t163 = t93 * t39;
  t166 = t43 * t70;
  t173 = t42 * t42;
  t174 = 0.1e1 / t173;
  t175 = t132 * t174;
  t183 = 0.1e1 / t2 / t60;
  t184 = t183 * t8;
  t187 = t62 * t8;
  t192 = 0.1e1 / t116;
  t193 = t192 * t8;
  t207 = t116 * rho[0];
  t209 = 0.1e1 / t19 / t207;
  t214 = t16 * (-0.44e3 / 0.27e2 * t18 * t118 + 0.55e2 / 0.27e2 * t23 * t118) / 0.4e1 + 0.154e3 / 0.27e2 * sigma[0] * t209 - 0.55e2 / 0.27e2 * lapl[0] * t118;
  t217 = 0.6934791111111111111e-1 * t184 * t36 - 0.75282110933333333332e-2 * t187 * t36 - 0.891616e-1 * t101 * t67 + 0.15890798916177777777e-3 * t193 * t36 + 0.564615832e-2 * t104 * t67 + 0.668712e-1 * t50 * t123 + 0.264e0 * t8 * t214;
  tv3rho30 = 0.13311495955555555556e-2 * t163 * t31 - 0.11442546666666666666e-1 * t166 * t49 + 0.50855762962962962961e-2 * t87 * t100 - 0.14754e0 * t6 * t126 - 0.46457120884888888886e-3 * t175 * t39 - 0.39934487866666666664e-2 * t94 * t70 - 0.17163819999999999999e-1 * t44 * t126 - 0.4918e-1 * t47 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t220 = t62 * t6;
  t223 = t192 * t43;
  t226 = t192 * t6;
  t230 = 0.1e1 / t2 / t116;
  t231 = t230 * t93;
  t234 = t230 * t43;
  t237 = t230 * t6;
  tv3rho2sigma0 = 0.72130666666666666667e-2 * t220 * t8 - 0.88107609333333333329e-3 * t223 * t8 - 0.63947442533333333333e-3 * t226 * t8 + 0.4392793665333333333e-4 * t231 * t8 + 0.31882367777333333332e-4 * t234 * t8 + 0.11569919424066666667e-4 * t237 * t8;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t240 = t43 * t8;
  t244 = t6 * t49;
  t251 = t21 * t43;
  t263 = -0.5e1 / 0.18e2 * t14 * t62 + 0.5e1 / 0.9e1 * t62;
  t264 = t8 * t263;
  tv3rho2lapl0 = -0.10069441066666666667e-2 * t240 * t78 * t49 - 0.73082791466666666667e-3 * t244 * t79 - 0.2596704e-1 * t139 * t150 - 0.35142349322666666666e-3 * t94 * t79 - 0.25505894221866666666e-3 * t251 * t79 - 0.302083232e-2 * t44 * t151 - 0.92559355392533333333e-4 * t73 * t79 - 0.2192483744e-2 * t144 * t151 - 0.1298352e-1 * t47 * t264;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = -0.72130666666666666667e-2 * t129 * t84 + 0.20138882133333333333e-2 * t133 * t84 + 0.14616558293333333333e-2 * t136 * t84 - 0.17571174661333333332e-3 * t183 * t93 * t84 - 0.12752947110933333333e-3 * t183 * t43 * t84 - 0.46279677696266666666e-4 * t183 * t6 * t84;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t5, t6, t8, t10, t11, t12;
  double t14, t15, t16, t17, t18, t19, t21, t23;
  double t29, t31, t36, t39, tzk0;

  double t42, t43, t44, t47, t49, t50, t60, t62;
  double t67, t70, tvrho0, t73, tvsigma0, t78, t79, tvlapl0;
  double t84, tvtau0;

  double t87, t93, t94, t100, t101, t104, t116, t118;
  double t123, t126, tv2rho20, t129, t132, t133, t136, tv2rhosigma0;
  double t139, t144, t150, t151, tv2rholapl0, t156, tv2rhotau0, tv2sigma20;
  double tv2sigmalapl0, tv2sigmatau0, tv2lapl20, tv2lapltau0, tv2tau20;

  double t163, t166, t173, t174, t175, t183, t184, t187;
  double t192, t193, t207, t209, t214, t217, tv3rho30, t220;
  double t223, t226, t230, t231, t234, t237, tv3rho2sigma0, t240;
  double t244, t251, t263, t264, tv3rho2lapl0, tv3rho2tau0, tv3rhosigma20, tv3rhosigmalapl0;
  double tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, tv3rhotau20, tv3sigma30, tv3sigma2lapl0, tv3sigma2tau0, tv3sigmalapl20;
  double tv3sigmalapltau0, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  double t318, t327, t354, tv4rho40, t357, tv4rho3sigma0, tv4rho3lapl0, tv4rho3tau0;
  double tv4rho2sigma20, tv4rho2sigmalapl0, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20, tv4rhosigma30, tv4rhosigma2lapl0;
  double tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30;
  double tv4sigma40, tv4sigma3lapl0, tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0;
  double tv4sigmalapltau20, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30, tv4tau40;


  t2 = POW_1_3(rho[0]);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 + 0.34899999999999999998e0 * t3;
  t6 = 0.1e1 / t5;
  t8 = exp(-0.2533e0 * t3);
  t10 = p->zeta_threshold * p->zeta_threshold;
  t11 = POW_1_3(p->zeta_threshold);
  t12 = t11 * t11;
  t14 = my_piecewise3(0.1e1 <= p->zeta_threshold, t12 * t10, 1);
  t15 = M_CBRT2;
  t16 = t14 * t15;
  t17 = t15 * t15;
  t18 = tau[0] * t17;
  t19 = t2 * t2;
  t21 = 0.1e1 / t19 / rho[0];
  t23 = lapl[0] * t17;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t19 / t29;
  t36 = t16 * (t18 * t21 - t23 * t21 / 0.8e1) / 0.4e1 - sigma[0] * t31 / 0.8e1 + lapl[0] * t21 / 0.8e1;
  t39 = 0.1e1 + 0.264e0 * t8 * t36;
  tzk0 = -0.4918e-1 * t6 * t39;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t42 = t5 * t5;
  t43 = 0.1e1 / t42;
  t44 = t3 * t43;
  t47 = rho[0] * t6;
  t49 = 0.1e1 / t2 / rho[0];
  t50 = t49 * t8;
  t60 = t29 * rho[0];
  t62 = 0.1e1 / t19 / t60;
  t67 = t16 * (-0.5e1 / 0.3e1 * t18 * t31 + 0.5e1 / 0.24e2 * t23 * t31) / 0.4e1 + sigma[0] * t62 / 0.3e1 - 0.5e1 / 0.24e2 * lapl[0] * t31;
  t70 = 0.222904e-1 * t50 * t36 + 0.264e0 * t8 * t67;
  tvrho0 = tzk0 - 0.57212733333333333332e-2 * t44 * t39 - 0.4918e-1 * t47 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t73 = t21 * t6;
  tvsigma0 = 0.162294e-2 * t73 * t8;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t78 = -t14 * t21 / 0.16e2 + t21 / 0.8e1;
  t79 = t8 * t78;
  tvlapl0 = -0.1298352e-1 * t47 * t79;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t84 = t8 * t14;
  tvtau0 = -0.649176e-2 / t19 * t6 * t84;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t87 = t43 * t39;
  t93 = 0.1e1 / t42 / t5;
  t94 = t21 * t93;
  t100 = 0.1e1 / t2 / t29;
  t101 = t100 * t8;
  t104 = t31 * t8;
  t116 = t29 * t29;
  t118 = 0.1e1 / t19 / t116;
  t123 = t16 * (0.4e2 / 0.9e1 * t18 * t62 - 0.5e1 / 0.9e1 * t23 * t62) / 0.4e1 - 0.11e2 / 0.9e1 * sigma[0] * t118 + 0.5e1 / 0.9e1 * lapl[0] * t62;
  t126 = -0.29720533333333333333e-1 * t101 * t36 + 0.18820527733333333333e-2 * t104 * t36 + 0.445808e-1 * t50 * t67 + 0.264e0 * t8 * t123;
  tv2rho20 = -0.38141822222222222221e-2 * t87 * t49 - 0.9836e-1 * t6 * t70 - 0.13311495955555555555e-2 * t94 * t39 - 0.11442546666666666666e-1 * t44 * t70 - 0.4918e-1 * t47 * t126;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t129 = t31 * t6;
  t132 = 0.1e1 / t60;
  t133 = t132 * t43;
  t136 = t132 * t6;
  tv2rhosigma0 = -0.27049e-2 * t129 * t8 + 0.18880201999999999999e-3 * t133 * t8 + 0.137030234e-3 * t136 * t8;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t139 = t6 * t8;
  t144 = t3 * t6;
  t150 = 0.5e1 / 0.48e2 * t14 * t31 - 0.5e1 / 0.24e2 * t31;
  t151 = t8 * t150;
  tv2rholapl0 = -0.1298352e-1 * t139 * t78 - 0.151041616e-2 * t44 * t79 - 0.1096241872e-2 * t144 * t79 - 0.1298352e-1 * t47 * t151;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t156 = 0.1e1 / t29;
  tv2rhotau0 = 0.432784e-2 * t73 * t84 - 0.75520807999999999998e-3 * t156 * t43 * t84 - 0.548120936e-3 * t156 * t6 * t84;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t163 = t93 * t39;
  t166 = t43 * t70;
  t173 = t42 * t42;
  t174 = 0.1e1 / t173;
  t175 = t132 * t174;
  t183 = 0.1e1 / t2 / t60;
  t184 = t183 * t8;
  t187 = t62 * t8;
  t192 = 0.1e1 / t116;
  t193 = t192 * t8;
  t207 = t116 * rho[0];
  t209 = 0.1e1 / t19 / t207;
  t214 = t16 * (-0.44e3 / 0.27e2 * t18 * t118 + 0.55e2 / 0.27e2 * t23 * t118) / 0.4e1 + 0.154e3 / 0.27e2 * sigma[0] * t209 - 0.55e2 / 0.27e2 * lapl[0] * t118;
  t217 = 0.6934791111111111111e-1 * t184 * t36 - 0.75282110933333333332e-2 * t187 * t36 - 0.891616e-1 * t101 * t67 + 0.15890798916177777777e-3 * t193 * t36 + 0.564615832e-2 * t104 * t67 + 0.668712e-1 * t50 * t123 + 0.264e0 * t8 * t214;
  tv3rho30 = 0.13311495955555555556e-2 * t163 * t31 - 0.11442546666666666666e-1 * t166 * t49 + 0.50855762962962962961e-2 * t87 * t100 - 0.14754e0 * t6 * t126 - 0.46457120884888888886e-3 * t175 * t39 - 0.39934487866666666664e-2 * t94 * t70 - 0.17163819999999999999e-1 * t44 * t126 - 0.4918e-1 * t47 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t220 = t62 * t6;
  t223 = t192 * t43;
  t226 = t192 * t6;
  t230 = 0.1e1 / t2 / t116;
  t231 = t230 * t93;
  t234 = t230 * t43;
  t237 = t230 * t6;
  tv3rho2sigma0 = 0.72130666666666666667e-2 * t220 * t8 - 0.88107609333333333329e-3 * t223 * t8 - 0.63947442533333333333e-3 * t226 * t8 + 0.4392793665333333333e-4 * t231 * t8 + 0.31882367777333333332e-4 * t234 * t8 + 0.11569919424066666667e-4 * t237 * t8;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t240 = t43 * t8;
  t244 = t6 * t49;
  t251 = t21 * t43;
  t263 = -0.5e1 / 0.18e2 * t14 * t62 + 0.5e1 / 0.9e1 * t62;
  t264 = t8 * t263;
  tv3rho2lapl0 = -0.10069441066666666667e-2 * t240 * t78 * t49 - 0.73082791466666666667e-3 * t244 * t79 - 0.2596704e-1 * t139 * t150 - 0.35142349322666666666e-3 * t94 * t79 - 0.25505894221866666666e-3 * t251 * t79 - 0.302083232e-2 * t44 * t151 - 0.92559355392533333333e-4 * t73 * t79 - 0.2192483744e-2 * t144 * t151 - 0.1298352e-1 * t47 * t264;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = -0.72130666666666666667e-2 * t129 * t84 + 0.20138882133333333333e-2 * t133 * t84 + 0.14616558293333333333e-2 * t136 * t84 - 0.17571174661333333332e-3 * t183 * t93 * t84 - 0.12752947110933333333e-3 * t183 * t43 * t84 - 0.46279677696266666666e-4 * t183 * t6 * t84;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t318 = 0.1e1 / t207;
  t327 = 0.1e1 / t2 / t207;
  t354 = -0.2311597037037037037e0 * t230 * t8 * t36 + 0.3345871597037037037e-1 * t118 * t8 * t36 + 0.27739164444444444444e0 * t184 * t67 - 0.12712639132942222222e-2 * t318 * t8 * t36 - 0.30112844373333333333e-1 * t187 * t67 - 0.1783232e0 * t101 * t123 + 0.13417131218226103703e-4 * t327 * t8 * t36 + 0.6356319566471111111e-3 * t193 * t67 + 0.1129231664e-1 * t104 * t123 + 0.891616e-1 * t50 * t214 + 0.264e0 * t8 * (t16 * (0.616e4 / 0.81e2 * t18 * t209 - 0.77e3 / 0.81e2 * t23 * t209) / 0.4e1 - 0.2618e4 / 0.81e2 * sigma[0] / t19 / t116 / t29 + 0.77e3 / 0.81e2 * lapl[0] * t209);
  tv4rho40 = 0.18582848353955555555e-2 * t174 * t39 * t192 + 0.5324598382222222222e-2 * t93 * t70 * t31 - 0.236648816987654321e-2 * t163 * t62 - 0.22885093333333333333e-1 * t43 * t126 * t49 + 0.20342305185185185184e-1 * t166 * t100 - 0.11866344691358024691e-1 * t87 * t183 - 0.19672e0 * t6 * t217 - 0.21618046918434962961e-3 * t230 / t173 / t5 * t39 - 0.18582848353955555554e-2 * t175 * t70 - 0.79868975733333333327e-2 * t94 * t126 - 0.22885093333333333332e-1 * t44 * t217 - 0.4918e-1 * t47 * t354;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t357 = t118 * t6;
  tv4rho3sigma0 = -0.26447911111111111111e-1 * t357 * t8 + 0.43634244622222222221e-2 * t318 * t43 * t8 + 0.31669209635555555555e-2 * t318 * t6 * t8 - 0.39535142987999999997e-3 * t327 * t93 * t8 - 0.28694130999599999999e-3 * t327 * t43 * t8 - 0.1041292748166e-3 * t327 * t6 * t8 + 0.15330849892013333332e-4 * t209 * t174 * t8 + 0.11126946354289333332e-4 * t209 * t93 * t8 + 0.40379018789992666666e-5 * t209 * t43 * t8 + 0.97688686337202888891e-6 * t209 * t6 * t8;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = -0.1298352e-1 * t47 * t8 * (0.55e2 / 0.54e2 * t14 * t118 - 0.55e2 / 0.27e2 * t118) - 0.30208323199999999999e-2 * t240 * t150 * t49 + 0.35142349322666666665e-3 * t93 * t8 * t78 * t31 + 0.25505894221866666666e-3 * t43 * t31 * t79 - 0.2192483744e-2 * t244 * t151 + 0.92559355392533333334e-4 * t129 * t79 - 0.105427047968e-2 * t94 * t151 - 0.12264679913610666666e-3 * t175 * t79 - 0.89015570834314666663e-4 * t132 * t93 * t79 - 0.76517682665599999999e-3 * t251 * t151 - 0.32303215031994133332e-4 * t133 * t79 - 0.453124848e-2 * t44 * t264 - 0.2776780661776e-3 * t73 * t151 - 0.78150949069762311111e-5 * t136 * t79 - 0.3288725616e-2 * t144 * t264 - 0.3895056e-1 * t139 * t263 + 0.13425921422222222223e-2 * t240 * t78 * t100 + 0.97443721955555555556e-3 * t6 * t100 * t79;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.19234844444444444445e-1 * t220 * t84 - 0.68807847288888888888e-2 * t223 * t84 - 0.49939907502222222221e-2 * t226 * t84 + 0.10542704796799999999e-2 * t231 * t84 + 0.76517682665599999998e-3 * t234 * t84 + 0.2776780661776e-3 * t237 * t84 - 0.61323399568053333327e-4 * t118 * t174 * t84 - 0.44507785417157333331e-4 * t118 * t93 * t84 - 0.16151607515997066666e-4 * t118 * t43 * t84 - 0.39075474534881155555e-5 * t357 * t84;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rhosigma30 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4sigma40 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t8, t9, t10;
  double t12, t13, t14, t16, t17, t18, t19, t20;
  double t21, t22, t23, t24, t25, t26, t27, t29;
  double t30, t31, t32, t33, t35, t37, t39, t41;
  double t42, t43, t44, t45, t47, t48, t49, t50;
  double t52, t54, t56, t59, t60, t62, t64, t65;
  double t66, t67, t69, t70, t71, t72, t75, t78;
  double tzk0;


  t2 = rho[0] - rho[1];
  t3 = t2 * t2;
  t4 = rho[0] + rho[1];
  t5 = t4 * t4;
  t6 = 0.1e1 / t5;
  t8 = -t3 * t6 + 0.1e1;
  t9 = POW_1_3(t4);
  t10 = 0.1e1 / t9;
  t12 = 0.1e1 + 0.34899999999999999998e0 * t10;
  t13 = 0.1e1 / t12;
  t14 = t8 * t13;
  t16 = exp(-0.2533e0 * t10);
  t17 = 0.1e1 / t4;
  t18 = t2 * t17;
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = p->zeta_threshold * p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * t21;
  t25 = t19 * t19;
  t26 = POW_1_3(t19);
  t27 = t26 * t26;
  t29 = my_piecewise3(t20, t24, t27 * t25);
  t30 = M_CBRT2;
  t31 = t29 * t30;
  t32 = POW_1_3(rho[0]);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / rho[0];
  t37 = lapl[0] * t35;
  t39 = tau[0] * t35 - t37 / 0.8e1;
  t41 = 0.1e1 - t18;
  t42 = t41 <= p->zeta_threshold;
  t43 = t41 * t41;
  t44 = POW_1_3(t41);
  t45 = t44 * t44;
  t47 = my_piecewise3(t42, t24, t45 * t43);
  t48 = t47 * t30;
  t49 = POW_1_3(rho[1]);
  t50 = t49 * t49;
  t52 = 0.1e1 / t50 / rho[1];
  t54 = lapl[1] * t52;
  t56 = tau[1] * t52 - t54 / 0.8e1;
  t59 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t60 = t9 * t9;
  t62 = 0.1e1 / t60 / t5;
  t64 = t19 / 0.2e1;
  t65 = POW_1_3(t64);
  t66 = t65 * t65;
  t67 = t66 * t64;
  t69 = t41 / 0.2e1;
  t70 = POW_1_3(t69);
  t71 = t70 * t70;
  t72 = t71 * t69;
  t75 = t31 * t39 / 0.8e1 + t37 * t67 / 0.8e1 + t48 * t56 / 0.8e1 + t54 * t72 / 0.8e1 - t59 * t62 / 0.8e1;
  t78 = 0.1e1 + 0.264e0 * t16 * t75;
  tzk0 = -0.4918e-1 * t14 * t78;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t8, t9, t10;
  double t12, t13, t14, t16, t17, t18, t19, t20;
  double t21, t22, t23, t24, t25, t26, t27, t29;
  double t30, t31, t32, t33, t35, t37, t39, t41;
  double t42, t43, t44, t45, t47, t48, t49, t50;
  double t52, t54, t56, t59, t60, t62, t64, t65;
  double t66, t67, t69, t70, t71, t72, t75, t78;
  double tzk0;

  double t81, t82, t83, t84, t86, t87, t88, t91;
  double t92, t93, t94, t96, t97, t99, t100, t102;
  double t103, t104, t107, t108, t111, t113, t116, t118;
  double t121, t122, t125, t126, t130, t132, t135, t136;
  double t139, t140, t143, t146, t147, tvrho0, t151, t152;
  double t155, t158, t159, t162, t165, t166, t169, t171;
  double t174, t176, t179, t180, t185, t186, t189, t192;
  double t193, tvrho1, t197, t198, t199, t200, tvsigma0, tvsigma1;
  double tvsigma2, t201, t205, t206, tvlapl0, t209, t213, t214;
  double tvlapl1, t217, t218, t219, t220, tvtau0, t223, t224;
  double t225, tvtau1;


  t2 = rho[0] - rho[1];
  t3 = t2 * t2;
  t4 = rho[0] + rho[1];
  t5 = t4 * t4;
  t6 = 0.1e1 / t5;
  t8 = -t3 * t6 + 0.1e1;
  t9 = POW_1_3(t4);
  t10 = 0.1e1 / t9;
  t12 = 0.1e1 + 0.34899999999999999998e0 * t10;
  t13 = 0.1e1 / t12;
  t14 = t8 * t13;
  t16 = exp(-0.2533e0 * t10);
  t17 = 0.1e1 / t4;
  t18 = t2 * t17;
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = p->zeta_threshold * p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * t21;
  t25 = t19 * t19;
  t26 = POW_1_3(t19);
  t27 = t26 * t26;
  t29 = my_piecewise3(t20, t24, t27 * t25);
  t30 = M_CBRT2;
  t31 = t29 * t30;
  t32 = POW_1_3(rho[0]);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / rho[0];
  t37 = lapl[0] * t35;
  t39 = tau[0] * t35 - t37 / 0.8e1;
  t41 = 0.1e1 - t18;
  t42 = t41 <= p->zeta_threshold;
  t43 = t41 * t41;
  t44 = POW_1_3(t41);
  t45 = t44 * t44;
  t47 = my_piecewise3(t42, t24, t45 * t43);
  t48 = t47 * t30;
  t49 = POW_1_3(rho[1]);
  t50 = t49 * t49;
  t52 = 0.1e1 / t50 / rho[1];
  t54 = lapl[1] * t52;
  t56 = tau[1] * t52 - t54 / 0.8e1;
  t59 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t60 = t9 * t9;
  t62 = 0.1e1 / t60 / t5;
  t64 = t19 / 0.2e1;
  t65 = POW_1_3(t64);
  t66 = t65 * t65;
  t67 = t66 * t64;
  t69 = t41 / 0.2e1;
  t70 = POW_1_3(t69);
  t71 = t70 * t70;
  t72 = t71 * t69;
  t75 = t31 * t39 / 0.8e1 + t37 * t67 / 0.8e1 + t48 * t56 / 0.8e1 + t54 * t72 / 0.8e1 - t59 * t62 / 0.8e1;
  t78 = 0.1e1 + 0.264e0 * t16 * t75;
  tzk0 = -0.4918e-1 * t14 * t78;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t2 * t6;
  t82 = t5 * t4;
  t83 = 0.1e1 / t82;
  t84 = t3 * t83;
  t86 = -0.2e1 * t81 + 0.2e1 * t84;
  t87 = t4 * t86;
  t88 = t13 * t78;
  t91 = t10 * t8;
  t92 = t12 * t12;
  t93 = 0.1e1 / t92;
  t94 = t93 * t78;
  t96 = 0.57212733333333333332e-2 * t91 * t94;
  t97 = t4 * t8;
  t99 = 0.1e1 / t9 / t4;
  t100 = t99 * t16;
  t102 = 0.222904e-1 * t100 * t75;
  t103 = t27 * t19;
  t104 = t17 - t81;
  t107 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t104);
  t108 = t107 * t30;
  t111 = rho[0] * rho[0];
  t113 = 0.1e1 / t33 / t111;
  t116 = lapl[0] * t113;
  t118 = -0.5e1 / 0.3e1 * tau[0] * t113 + 0.5e1 / 0.24e2 * t116;
  t121 = t45 * t41;
  t122 = -t104;
  t125 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t122);
  t126 = t125 * t30;
  t130 = 0.1e1 / t60 / t82;
  t132 = t59 * t130 / 0.3e1;
  t135 = t104 / 0.2e1;
  t136 = t66 * t135;
  t139 = -t135;
  t140 = t71 * t139;
  t143 = t108 * t39 / 0.8e1 + t31 * t118 / 0.8e1 + t126 * t56 / 0.8e1 + t132 - 0.5e1 / 0.24e2 * t116 * t67 + 0.5e1 / 0.24e2 * t37 * t136 + 0.5e1 / 0.24e2 * t54 * t140;
  t146 = t102 + 0.264e0 * t16 * t143;
  t147 = t13 * t146;
  tvrho0 = tzk0 - 0.4918e-1 * t87 * t88 - t96 - 0.4918e-1 * t97 * t147;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t151 = 0.2e1 * t81 + 0.2e1 * t84;
  t152 = t4 * t151;
  t155 = -t17 - t81;
  t158 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t155);
  t159 = t158 * t30;
  t162 = -t155;
  t165 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t162);
  t166 = t165 * t30;
  t169 = rho[1] * rho[1];
  t171 = 0.1e1 / t50 / t169;
  t174 = lapl[1] * t171;
  t176 = -0.5e1 / 0.3e1 * tau[1] * t171 + 0.5e1 / 0.24e2 * t174;
  t179 = t155 / 0.2e1;
  t180 = t66 * t179;
  t185 = -t179;
  t186 = t71 * t185;
  t189 = t159 * t39 / 0.8e1 + t166 * t56 / 0.8e1 + t48 * t176 / 0.8e1 + t132 + 0.5e1 / 0.24e2 * t37 * t180 - 0.5e1 / 0.24e2 * t174 * t72 + 0.5e1 / 0.24e2 * t54 * t186;
  t192 = t102 + 0.264e0 * t16 * t189;
  t193 = t13 * t192;
  tvrho1 = tzk0 - 0.4918e-1 * t152 * t88 - t96 - 0.4918e-1 * t97 * t193;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t197 = 0.1e1 / t60 / t4;
  t198 = t197 * t8;
  t199 = t13 * t16;
  t200 = t198 * t199;
  tvsigma0 = 0.162294e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.324588e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t201 = t31 * t35;
  t205 = -t201 / 0.64e2 + t35 * t67 / 0.8e1;
  t206 = t199 * t205;
  tvlapl0 = -0.1298352e-1 * t97 * t206;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t209 = t48 * t52;
  t213 = -t209 / 0.64e2 + t52 * t72 / 0.8e1;
  t214 = t199 * t213;
  tvlapl1 = -0.1298352e-1 * t97 * t214;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t217 = t97 * t13;
  t218 = t16 * t29;
  t219 = t30 * t35;
  t220 = t218 * t219;
  tvtau0 = -0.162294e-2 * t217 * t220;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t223 = t16 * t47;
  t224 = t30 * t52;
  t225 = t223 * t224;
  tvtau1 = -0.162294e-2 * t217 * t225;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t8, t9, t10;
  double t12, t13, t14, t16, t17, t18, t19, t20;
  double t21, t22, t23, t24, t25, t26, t27, t29;
  double t30, t31, t32, t33, t35, t37, t39, t41;
  double t42, t43, t44, t45, t47, t48, t49, t50;
  double t52, t54, t56, t59, t60, t62, t64, t65;
  double t66, t67, t69, t70, t71, t72, t75, t78;
  double tzk0;

  double t81, t82, t83, t84, t86, t87, t88, t91;
  double t92, t93, t94, t96, t97, t99, t100, t102;
  double t103, t104, t107, t108, t111, t113, t116, t118;
  double t121, t122, t125, t126, t130, t132, t135, t136;
  double t139, t140, t143, t146, t147, tvrho0, t151, t152;
  double t155, t158, t159, t162, t165, t166, t169, t171;
  double t174, t176, t179, t180, t185, t186, t189, t192;
  double t193, tvrho1, t197, t198, t199, t200, tvsigma0, tvsigma1;
  double tvsigma2, t201, t205, t206, tvlapl0, t209, t213, t214;
  double tvlapl1, t217, t218, t219, t220, tvtau0, t223, t224;
  double t225, tvtau1;

  double t228, t229, t231, t232, t234, t235, t237, t238;
  double t239, t240, t241, t243, t244, t245, t248, t249;
  double t254, t255, t257, t258, t259, t262, t263, t265;
  double t266, t268, t269, t271, t274, t275, t279, t280;
  double t287, t290, t292, t295, t298, t302, t303, t307;
  double t309, t314, t315, t316, t319, t322, t323, t324;
  double t327, t328, t331, t334, t335, tv2rho20, t340, t341;
  double t343, t344, t347, t348, t354, t358, t359, t362;
  double t364, t367, t371, t372, t377, t380, t384, t385;
  double t392, t393, t396, t397, t402, t403, t406, t407;
  double t410, t413, t414, tv2rho21, t419, t420, t428, t431;
  double t432, t436, t437, t440, t443, t447, t448, t455;
  double t458, t460, t463, t464, t467, t474, t475, t478;
  double t479, t482, t485, t486, tv2rho22, t489, t490, t491;
  double t492, t493, t495, t496, t497, t498, t499, t500;
  double tv2rhosigma0, t501, t503, t504, tv2rhosigma1, tv2rhosigma2, t505, t506;
  double tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t509, t511, t514, t516, t518;
  double t519, t521, t525, t528, t529, tv2rholapl0, t532, t534;
  double t537, t539, t541, t542, t544, t547, t548, tv2rholapl1;
  double t553, t557, t558, tv2rholapl2, t563, t565, t571, t572;
  double tv2rholapl3, t575, t577, t578, t581, t583, t584, t586;
  double t587, t588, t591, t592, tv2rhotau0, t596, t600, t602;
  double t603, t604, tv2rhotau1, t607, t610, t611, tv2rhotau2, t616;
  double t617, t620, t621, tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20, tv2lapl21;
  double tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;


  t2 = rho[0] - rho[1];
  t3 = t2 * t2;
  t4 = rho[0] + rho[1];
  t5 = t4 * t4;
  t6 = 0.1e1 / t5;
  t8 = -t3 * t6 + 0.1e1;
  t9 = POW_1_3(t4);
  t10 = 0.1e1 / t9;
  t12 = 0.1e1 + 0.34899999999999999998e0 * t10;
  t13 = 0.1e1 / t12;
  t14 = t8 * t13;
  t16 = exp(-0.2533e0 * t10);
  t17 = 0.1e1 / t4;
  t18 = t2 * t17;
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = p->zeta_threshold * p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * t21;
  t25 = t19 * t19;
  t26 = POW_1_3(t19);
  t27 = t26 * t26;
  t29 = my_piecewise3(t20, t24, t27 * t25);
  t30 = M_CBRT2;
  t31 = t29 * t30;
  t32 = POW_1_3(rho[0]);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / rho[0];
  t37 = lapl[0] * t35;
  t39 = tau[0] * t35 - t37 / 0.8e1;
  t41 = 0.1e1 - t18;
  t42 = t41 <= p->zeta_threshold;
  t43 = t41 * t41;
  t44 = POW_1_3(t41);
  t45 = t44 * t44;
  t47 = my_piecewise3(t42, t24, t45 * t43);
  t48 = t47 * t30;
  t49 = POW_1_3(rho[1]);
  t50 = t49 * t49;
  t52 = 0.1e1 / t50 / rho[1];
  t54 = lapl[1] * t52;
  t56 = tau[1] * t52 - t54 / 0.8e1;
  t59 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t60 = t9 * t9;
  t62 = 0.1e1 / t60 / t5;
  t64 = t19 / 0.2e1;
  t65 = POW_1_3(t64);
  t66 = t65 * t65;
  t67 = t66 * t64;
  t69 = t41 / 0.2e1;
  t70 = POW_1_3(t69);
  t71 = t70 * t70;
  t72 = t71 * t69;
  t75 = t31 * t39 / 0.8e1 + t37 * t67 / 0.8e1 + t48 * t56 / 0.8e1 + t54 * t72 / 0.8e1 - t59 * t62 / 0.8e1;
  t78 = 0.1e1 + 0.264e0 * t16 * t75;
  tzk0 = -0.4918e-1 * t14 * t78;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t2 * t6;
  t82 = t5 * t4;
  t83 = 0.1e1 / t82;
  t84 = t3 * t83;
  t86 = -0.2e1 * t81 + 0.2e1 * t84;
  t87 = t4 * t86;
  t88 = t13 * t78;
  t91 = t10 * t8;
  t92 = t12 * t12;
  t93 = 0.1e1 / t92;
  t94 = t93 * t78;
  t96 = 0.57212733333333333332e-2 * t91 * t94;
  t97 = t4 * t8;
  t99 = 0.1e1 / t9 / t4;
  t100 = t99 * t16;
  t102 = 0.222904e-1 * t100 * t75;
  t103 = t27 * t19;
  t104 = t17 - t81;
  t107 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t104);
  t108 = t107 * t30;
  t111 = rho[0] * rho[0];
  t113 = 0.1e1 / t33 / t111;
  t116 = lapl[0] * t113;
  t118 = -0.5e1 / 0.3e1 * tau[0] * t113 + 0.5e1 / 0.24e2 * t116;
  t121 = t45 * t41;
  t122 = -t104;
  t125 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t122);
  t126 = t125 * t30;
  t130 = 0.1e1 / t60 / t82;
  t132 = t59 * t130 / 0.3e1;
  t135 = t104 / 0.2e1;
  t136 = t66 * t135;
  t139 = -t135;
  t140 = t71 * t139;
  t143 = t108 * t39 / 0.8e1 + t31 * t118 / 0.8e1 + t126 * t56 / 0.8e1 + t132 - 0.5e1 / 0.24e2 * t116 * t67 + 0.5e1 / 0.24e2 * t37 * t136 + 0.5e1 / 0.24e2 * t54 * t140;
  t146 = t102 + 0.264e0 * t16 * t143;
  t147 = t13 * t146;
  tvrho0 = tzk0 - 0.4918e-1 * t87 * t88 - t96 - 0.4918e-1 * t97 * t147;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t151 = 0.2e1 * t81 + 0.2e1 * t84;
  t152 = t4 * t151;
  t155 = -t17 - t81;
  t158 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t155);
  t159 = t158 * t30;
  t162 = -t155;
  t165 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t162);
  t166 = t165 * t30;
  t169 = rho[1] * rho[1];
  t171 = 0.1e1 / t50 / t169;
  t174 = lapl[1] * t171;
  t176 = -0.5e1 / 0.3e1 * tau[1] * t171 + 0.5e1 / 0.24e2 * t174;
  t179 = t155 / 0.2e1;
  t180 = t66 * t179;
  t185 = -t179;
  t186 = t71 * t185;
  t189 = t159 * t39 / 0.8e1 + t166 * t56 / 0.8e1 + t48 * t176 / 0.8e1 + t132 + 0.5e1 / 0.24e2 * t37 * t180 - 0.5e1 / 0.24e2 * t174 * t72 + 0.5e1 / 0.24e2 * t54 * t186;
  t192 = t102 + 0.264e0 * t16 * t189;
  t193 = t13 * t192;
  tvrho1 = tzk0 - 0.4918e-1 * t152 * t88 - t96 - 0.4918e-1 * t97 * t193;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t197 = 0.1e1 / t60 / t4;
  t198 = t197 * t8;
  t199 = t13 * t16;
  t200 = t198 * t199;
  tvsigma0 = 0.162294e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.324588e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t201 = t31 * t35;
  t205 = -t201 / 0.64e2 + t35 * t67 / 0.8e1;
  t206 = t199 * t205;
  tvlapl0 = -0.1298352e-1 * t97 * t206;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t209 = t48 * t52;
  t213 = -t209 / 0.64e2 + t52 * t72 / 0.8e1;
  t214 = t199 * t213;
  tvlapl1 = -0.1298352e-1 * t97 * t214;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t217 = t97 * t13;
  t218 = t16 * t29;
  t219 = t30 * t35;
  t220 = t218 * t219;
  tvtau0 = -0.162294e-2 * t217 * t220;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t223 = t16 * t47;
  t224 = t30 * t52;
  t225 = t223 * t224;
  tvtau1 = -0.162294e-2 * t217 * t225;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t228 = t86 * t13;
  t229 = t228 * t78;
  t231 = t8 * t93;
  t232 = t78 * t99;
  t234 = 0.38141822222222222221e-2 * t231 * t232;
  t235 = t14 * t146;
  t237 = 0.2e1 * t6;
  t238 = t2 * t83;
  t239 = 0.8e1 * t238;
  t240 = t5 * t5;
  t241 = 0.1e1 / t240;
  t243 = 0.6e1 * t3 * t241;
  t244 = -t237 + t239 - t243;
  t245 = t4 * t244;
  t248 = t10 * t86;
  t249 = t248 * t94;
  t254 = 0.1e1 / t92 / t12;
  t255 = t254 * t78;
  t257 = 0.13311495955555555555e-2 * t198 * t255;
  t258 = t93 * t146;
  t259 = t91 * t258;
  t262 = 0.1e1 / t9 / t5;
  t263 = t262 * t16;
  t265 = 0.29720533333333333333e-1 * t263 * t75;
  t266 = t62 * t16;
  t268 = 0.18820527733333333333e-2 * t266 * t75;
  t269 = t100 * t143;
  t271 = t104 * t104;
  t274 = -t6 + t238;
  t275 = 0.2e1 * t274;
  t279 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t27 * t271 + 0.8e1 / 0.3e1 * t103 * t275);
  t280 = t279 * t30;
  t287 = 0.1e1 / t33 / t111 / rho[0];
  t290 = lapl[0] * t287;
  t292 = 0.4e2 / 0.9e1 * tau[0] * t287 - 0.5e1 / 0.9e1 * t290;
  t295 = t122 * t122;
  t298 = -t275;
  t302 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t45 * t295 + 0.8e1 / 0.3e1 * t121 * t298);
  t303 = t302 * t30;
  t307 = 0.1e1 / t60 / t240;
  t309 = 0.11e2 / 0.9e1 * t59 * t307;
  t314 = 0.1e1 / t65;
  t315 = t135 * t135;
  t316 = t314 * t315;
  t319 = t66 * t274;
  t322 = 0.1e1 / t70;
  t323 = t139 * t139;
  t324 = t322 * t323;
  t327 = -t274;
  t328 = t71 * t327;
  t331 = t280 * t39 / 0.8e1 + t108 * t118 / 0.4e1 + t31 * t292 / 0.8e1 + t303 * t56 / 0.8e1 - t309 + 0.5e1 / 0.9e1 * t290 * t67 - 0.25e2 / 0.36e2 * t116 * t136 + 0.5e1 / 0.36e2 * t37 * t316 + 0.5e1 / 0.24e2 * t37 * t319 + 0.5e1 / 0.36e2 * t54 * t324 + 0.5e1 / 0.24e2 * t54 * t328;
  t334 = -t265 + t268 + 0.445808e-1 * t269 + 0.264e0 * t16 * t331;
  t335 = t13 * t334;
  tv2rho20 = -0.9836e-1 * t229 - t234 - 0.9836e-1 * t235 - 0.4918e-1 * t245 * t88 - 0.11442546666666666666e-1 * t249 - 0.9836e-1 * t87 * t147 - t257 - 0.11442546666666666666e-1 * t259 - 0.4918e-1 * t97 * t335;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t340 = t151 * t13;
  t341 = t340 * t78;
  t343 = t237 - t243;
  t344 = t4 * t343;
  t347 = t10 * t151;
  t348 = t347 * t94;
  t354 = t14 * t192;
  t358 = t93 * t192;
  t359 = t91 * t358;
  t362 = t100 * t189;
  t364 = t27 * t155;
  t367 = t103 * t2;
  t371 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t364 * t104 + 0.16e2 / 0.3e1 * t367 * t83);
  t372 = t371 * t30;
  t377 = t45 * t162;
  t380 = t121 * t2;
  t384 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t377 * t122 - 0.16e2 / 0.3e1 * t380 * t83);
  t385 = t384 * t30;
  t392 = t314 * t179;
  t393 = t392 * t135;
  t396 = t66 * t2;
  t397 = t396 * t83;
  t402 = t322 * t185;
  t403 = t402 * t139;
  t406 = t71 * t2;
  t407 = t406 * t83;
  t410 = t372 * t39 / 0.8e1 + t159 * t118 / 0.8e1 + t385 * t56 / 0.8e1 + t126 * t176 / 0.8e1 - t309 - 0.25e2 / 0.72e2 * t116 * t180 + 0.5e1 / 0.36e2 * t37 * t393 + 0.5e1 / 0.24e2 * t37 * t397 - 0.25e2 / 0.72e2 * t174 * t140 + 0.5e1 / 0.36e2 * t54 * t403 - 0.5e1 / 0.24e2 * t54 * t407;
  t413 = -t265 + t268 + 0.222904e-1 * t269 + 0.222904e-1 * t362 + 0.264e0 * t16 * t410;
  t414 = t13 * t413;
  tv2rho21 = -0.4918e-1 * t229 - t234 - 0.4918e-1 * t235 - 0.4918e-1 * t341 - 0.4918e-1 * t344 * t88 - 0.57212733333333333332e-2 * t348 - 0.4918e-1 * t152 * t147 - 0.57212733333333333332e-2 * t249 - t257 - 0.57212733333333333332e-2 * t259 - 0.4918e-1 * t354 - 0.4918e-1 * t87 * t193 - 0.57212733333333333332e-2 * t359 - 0.4918e-1 * t97 * t414;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t419 = -t237 - t239 - t243;
  t420 = t4 * t419;
  t428 = t155 * t155;
  t431 = t6 + t238;
  t432 = 0.2e1 * t431;
  t436 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t27 * t428 + 0.8e1 / 0.3e1 * t103 * t432);
  t437 = t436 * t30;
  t440 = t162 * t162;
  t443 = -t432;
  t447 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t45 * t440 + 0.8e1 / 0.3e1 * t121 * t443);
  t448 = t447 * t30;
  t455 = 0.1e1 / t50 / t169 / rho[1];
  t458 = lapl[1] * t455;
  t460 = 0.4e2 / 0.9e1 * tau[1] * t455 - 0.5e1 / 0.9e1 * t458;
  t463 = t179 * t179;
  t464 = t314 * t463;
  t467 = t66 * t431;
  t474 = t185 * t185;
  t475 = t322 * t474;
  t478 = -t431;
  t479 = t71 * t478;
  t482 = t437 * t39 / 0.8e1 + t448 * t56 / 0.8e1 + t166 * t176 / 0.4e1 + t48 * t460 / 0.8e1 - t309 + 0.5e1 / 0.36e2 * t37 * t464 + 0.5e1 / 0.24e2 * t37 * t467 + 0.5e1 / 0.9e1 * t458 * t72 - 0.25e2 / 0.36e2 * t174 * t186 + 0.5e1 / 0.36e2 * t54 * t475 + 0.5e1 / 0.24e2 * t54 * t479;
  t485 = -t265 + t268 + 0.445808e-1 * t362 + 0.264e0 * t16 * t482;
  t486 = t13 * t485;
  tv2rho22 = -0.9836e-1 * t341 - t234 - 0.9836e-1 * t354 - 0.4918e-1 * t420 * t88 - 0.11442546666666666666e-1 * t348 - 0.9836e-1 * t152 * t193 - t257 - 0.11442546666666666666e-1 * t359 - 0.4918e-1 * t97 * t486;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t489 = t62 * t8;
  t490 = t489 * t199;
  t491 = 0.27049e-2 * t490;
  t492 = t197 * t86;
  t493 = t492 * t199;
  t495 = t83 * t8;
  t496 = t93 * t16;
  t497 = t495 * t496;
  t498 = 0.18880201999999999999e-3 * t497;
  t499 = t495 * t199;
  t500 = 0.137030234e-3 * t499;
  tv2rhosigma0 = -t491 + 0.162294e-2 * t493 + t498 + t500;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t501 = 0.54098e-2 * t490;
  t503 = 0.37760403999999999999e-3 * t497;
  t504 = 0.274060468e-3 * t499;
  tv2rhosigma1 = -t501 + 0.324588e-2 * t493 + t503 + t504;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t505 = t197 * t151;
  t506 = t505 * t199;
  tv2rhosigma3 = -t491 + 0.162294e-2 * t506 + t498 + t500;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t501 + 0.324588e-2 * t506 + t503 + t504;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t509 = t16 * t205;
  t511 = 0.1298352e-1 * t14 * t509;
  t514 = t496 * t205;
  t516 = 0.151041616e-2 * t91 * t514;
  t518 = 0.1096241872e-2 * t91 * t206;
  t519 = t108 * t35;
  t521 = t31 * t113;
  t525 = t35 * t66;
  t528 = -t519 / 0.64e2 + 0.5e1 / 0.192e3 * t521 - 0.5e1 / 0.24e2 * t113 * t67 + 0.5e1 / 0.24e2 * t525 * t135;
  t529 = t199 * t528;
  tv2rholapl0 = -t511 - 0.1298352e-1 * t87 * t206 - t516 - t518 - 0.1298352e-1 * t97 * t529;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t532 = t16 * t213;
  t534 = 0.1298352e-1 * t14 * t532;
  t537 = t496 * t213;
  t539 = 0.151041616e-2 * t91 * t537;
  t541 = 0.1096241872e-2 * t91 * t214;
  t542 = t126 * t52;
  t544 = t52 * t71;
  t547 = -t542 / 0.64e2 + 0.5e1 / 0.24e2 * t544 * t139;
  t548 = t199 * t547;
  tv2rholapl1 = -t534 - 0.1298352e-1 * t87 * t214 - t539 - t541 - 0.1298352e-1 * t97 * t548;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t553 = t159 * t35;
  t557 = -t553 / 0.64e2 + 0.5e1 / 0.24e2 * t525 * t179;
  t558 = t199 * t557;
  tv2rholapl2 = -t511 - 0.1298352e-1 * t152 * t206 - t516 - t518 - 0.1298352e-1 * t97 * t558;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t563 = t166 * t52;
  t565 = t48 * t171;
  t571 = -t563 / 0.64e2 + 0.5e1 / 0.192e3 * t565 - 0.5e1 / 0.24e2 * t171 * t72 + 0.5e1 / 0.24e2 * t544 * t185;
  t572 = t199 * t571;
  tv2rholapl3 = -t534 - 0.1298352e-1 * t152 * t214 - t539 - t541 - 0.1298352e-1 * t97 * t572;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t575 = t14 * t16;
  t577 = 0.162294e-2 * t575 * t201;
  t578 = t87 * t13;
  t581 = t91 * t93;
  t583 = 0.18880201999999999999e-3 * t581 * t220;
  t584 = t91 * t13;
  t586 = 0.137030234e-3 * t584 * t220;
  t587 = t16 * t107;
  t588 = t587 * t219;
  t591 = t30 * t113;
  t592 = t218 * t591;
  tv2rhotau0 = -t577 - 0.162294e-2 * t578 * t220 - t583 - t586 - 0.162294e-2 * t217 * t588 + 0.27049e-2 * t217 * t592;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t596 = 0.162294e-2 * t575 * t209;
  t600 = 0.18880201999999999999e-3 * t581 * t225;
  t602 = 0.137030234e-3 * t584 * t225;
  t603 = t16 * t125;
  t604 = t603 * t224;
  tv2rhotau1 = -t596 - 0.162294e-2 * t578 * t225 - t600 - t602 - 0.162294e-2 * t217 * t604;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t607 = t152 * t13;
  t610 = t16 * t158;
  t611 = t610 * t219;
  tv2rhotau2 = -t577 - 0.162294e-2 * t607 * t220 - t583 - t586 - 0.162294e-2 * t217 * t611;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t616 = t16 * t165;
  t617 = t616 * t224;
  t620 = t30 * t171;
  t621 = t223 * t620;
  tv2rhotau3 = -t596 - 0.162294e-2 * t607 * t225 - t600 - t602 - 0.162294e-2 * t217 * t617 + 0.27049e-2 * t217 * t621;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t8, t9, t10;
  double t12, t13, t14, t16, t17, t18, t19, t20;
  double t21, t22, t23, t24, t25, t26, t27, t29;
  double t30, t31, t32, t33, t35, t37, t39, t41;
  double t42, t43, t44, t45, t47, t48, t49, t50;
  double t52, t54, t56, t59, t60, t62, t64, t65;
  double t66, t67, t69, t70, t71, t72, t75, t78;
  double tzk0;

  double t81, t82, t83, t84, t86, t87, t88, t91;
  double t92, t93, t94, t96, t97, t99, t100, t102;
  double t103, t104, t107, t108, t111, t113, t116, t118;
  double t121, t122, t125, t126, t130, t132, t135, t136;
  double t139, t140, t143, t146, t147, tvrho0, t151, t152;
  double t155, t158, t159, t162, t165, t166, t169, t171;
  double t174, t176, t179, t180, t185, t186, t189, t192;
  double t193, tvrho1, t197, t198, t199, t200, tvsigma0, tvsigma1;
  double tvsigma2, t201, t205, t206, tvlapl0, t209, t213, t214;
  double tvlapl1, t217, t218, t219, t220, tvtau0, t223, t224;
  double t225, tvtau1;

  double t228, t229, t231, t232, t234, t235, t237, t238;
  double t239, t240, t241, t243, t244, t245, t248, t249;
  double t254, t255, t257, t258, t259, t262, t263, t265;
  double t266, t268, t269, t271, t274, t275, t279, t280;
  double t287, t290, t292, t295, t298, t302, t303, t307;
  double t309, t314, t315, t316, t319, t322, t323, t324;
  double t327, t328, t331, t334, t335, tv2rho20, t340, t341;
  double t343, t344, t347, t348, t354, t358, t359, t362;
  double t364, t367, t371, t372, t377, t380, t384, t385;
  double t392, t393, t396, t397, t402, t403, t406, t407;
  double t410, t413, t414, tv2rho21, t419, t420, t428, t431;
  double t432, t436, t437, t440, t443, t447, t448, t455;
  double t458, t460, t463, t464, t467, t474, t475, t478;
  double t479, t482, t485, t486, tv2rho22, t489, t490, t491;
  double t492, t493, t495, t496, t497, t498, t499, t500;
  double tv2rhosigma0, t501, t503, t504, tv2rhosigma1, tv2rhosigma2, t505, t506;
  double tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t509, t511, t514, t516, t518;
  double t519, t521, t525, t528, t529, tv2rholapl0, t532, t534;
  double t537, t539, t541, t542, t544, t547, t548, tv2rholapl1;
  double t553, t557, t558, tv2rholapl2, t563, t565, t571, t572;
  double tv2rholapl3, t575, t577, t578, t581, t583, t584, t586;
  double t587, t588, t591, t592, tv2rhotau0, t596, t600, t602;
  double t603, t604, tv2rhotau1, t607, t610, t611, tv2rhotau2, t616;
  double t617, t620, t621, tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20, tv2lapl21;
  double tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t624, t625, t627, t628, t629, t631, t632, t633;
  double t636, t637, t639, t640, t642, t643, t645, t647;
  double t648, t650, t652, t653, t656, t659, t660, t661;
  double t665, t666, t673, t675, t678, t680, t683, t684;
  double t687, t690, t694, t695, t698, t700, t702, t712;
  double t713, t714, t717, t718, t721, t722, t726, t727;
  double t728, t731, t732, t735, t736, t739, t742, t743;
  double t746, t747, t748, t750, t751, t752, t757, t758;
  double t760, t762, t766, t767, t769, t770, t772, t773;
  double t775, t776, t778, t779, t781, t783, t785, tv3rho30;
  double t793, t794, t799, t801, t804, t811, t814, t819;
  double t822, t825, t828, t839, t840, t848, t851, t862;
  double t863, t870, t871, t874, t878, t881, t882, t885;
  double t889, t892, t893, t896, t897, t900, t901, t907;
  double t909, t910, t912, t913, t914, t916, t917, t918;
  double t919, t924, t926, t928, t929, t937, t939, t940;
  double t942, t944, t945, tv3rho31, t948, t950, t951, t955;
  double t956, t960, t961, t970, t972, t977, t982, t986;
  double t987, t992, t997, t1000, t1004, t1005, t1014, t1015;
  double t1018, t1019, t1024, t1025, t1029, t1030, t1039, t1040;
  double t1043, t1044, t1047, t1048, t1051, t1052, t1055, t1058;
  double t1059, t1064, t1065, t1067, t1069, t1071, t1078, tv3rho32;
  double t1082, t1087, t1088, t1092, t1093, t1096, t1101, t1105;
  double t1106, t1113, t1115, t1118, t1120, t1123, t1124, t1127;
  double t1130, t1131, t1142, t1143, t1146, t1149, t1150, t1153;
  double t1156, t1157, t1160, t1161, tv3rho33, t1179, t1180, t1181;
  double t1182, t1183, t1184, t1185, t1186, t1187, t1188, t1189;
  double t1190, t1192, t1193, t1195, t1196, t1198, t1199, t1200;
  double t1201, t1202, t1203, t1204, t1205, t1206, tv3rho2sigma0, t1207;
  double t1209, t1210, t1214, t1215, t1216, tv3rho2sigma1, tv3rho2sigma2, t1219;
  double t1221, t1222, t1224, t1225, t1227, tv3rho2sigma3, t1231, t1234;
  double tv3rho2sigma4, tv3rho2sigma5, t1236, t1237, tv3rho2sigma6, tv3rho2sigma7, tv3rho2sigma8, t1244;
  double t1246, t1248, t1250, t1251, t1252, t1256, t1258, t1262;
  double t1264, t1266, t1267, t1268, t1271, t1272, t1274, t1276;
  double t1278, t1282, t1285, t1290, t1291, tv3rho2lapl0, t1294, t1296;
  double t1298, t1300, t1301, t1302, t1306, t1308, t1312, t1314;
  double t1316, t1317, t1318, t1321, t1322, t1324, t1326, t1331;
  double t1332, tv3rho2lapl1, t1337, t1341, t1343, t1352, t1353, t1357;
  double t1358, t1360, t1362, t1364, t1368, t1373, t1374, t1377;
  double tv3rho2lapl2, t1380, t1384, t1386, t1395, t1396, t1400, t1401;
  double t1403, t1405, t1407, t1409, t1412, t1417, t1418, t1421;
  double tv3rho2lapl3, t1432, t1438, t1439, tv3rho2lapl4, t1452, t1454, t1456;
  double t1466, t1467, tv3rho2lapl5, t1472, t1474, t1476, t1479, t1480;
  double t1483, t1485, t1486, t1487, t1489, t1490, t1492, t1493;
  double t1498, t1499, t1501, t1502, t1504, t1506, t1508, t1509;
  double t1511, t1512, t1514, t1516, t1517, t1518, t1521, t1522;
  double t1524, tv3rho2tau0, t1526, t1528, t1529, t1531, t1533, t1534;
  double t1538, t1540, t1545, t1547, t1548, t1551, t1552, t1554;
  double t1555, tv3rho2tau1, t1560, t1565, t1566, t1569, t1571, t1573;
  double t1578, t1579, t1581, t1582, t1586, t1594, t1596, t1597;
  double t1599, tv3rho2tau2, t1600, t1602, t1606, t1607, t1610, t1612;
  double t1616, t1619, t1621, t1624, t1632, t1634, t1638, t1640;
  double tv3rho2tau3, t1643, t1652, t1653, tv3rho2tau4, t1658, t1661, t1662;
  double t1665, t1666, tv3rho2tau5, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double tv3rhosigma25, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0;
  double tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8;
  double tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4;
  double tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, tv3rholapl20;
  double tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2;
  double tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22;
  double tv3rhotau23, tv3rhotau24, tv3rhotau25, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22;
  double tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1;
  double tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9;
  double tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0;
  double tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;


  t2 = rho[0] - rho[1];
  t3 = t2 * t2;
  t4 = rho[0] + rho[1];
  t5 = t4 * t4;
  t6 = 0.1e1 / t5;
  t8 = -t3 * t6 + 0.1e1;
  t9 = POW_1_3(t4);
  t10 = 0.1e1 / t9;
  t12 = 0.1e1 + 0.34899999999999999998e0 * t10;
  t13 = 0.1e1 / t12;
  t14 = t8 * t13;
  t16 = exp(-0.2533e0 * t10);
  t17 = 0.1e1 / t4;
  t18 = t2 * t17;
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = p->zeta_threshold * p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * t21;
  t25 = t19 * t19;
  t26 = POW_1_3(t19);
  t27 = t26 * t26;
  t29 = my_piecewise3(t20, t24, t27 * t25);
  t30 = M_CBRT2;
  t31 = t29 * t30;
  t32 = POW_1_3(rho[0]);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / rho[0];
  t37 = lapl[0] * t35;
  t39 = tau[0] * t35 - t37 / 0.8e1;
  t41 = 0.1e1 - t18;
  t42 = t41 <= p->zeta_threshold;
  t43 = t41 * t41;
  t44 = POW_1_3(t41);
  t45 = t44 * t44;
  t47 = my_piecewise3(t42, t24, t45 * t43);
  t48 = t47 * t30;
  t49 = POW_1_3(rho[1]);
  t50 = t49 * t49;
  t52 = 0.1e1 / t50 / rho[1];
  t54 = lapl[1] * t52;
  t56 = tau[1] * t52 - t54 / 0.8e1;
  t59 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t60 = t9 * t9;
  t62 = 0.1e1 / t60 / t5;
  t64 = t19 / 0.2e1;
  t65 = POW_1_3(t64);
  t66 = t65 * t65;
  t67 = t66 * t64;
  t69 = t41 / 0.2e1;
  t70 = POW_1_3(t69);
  t71 = t70 * t70;
  t72 = t71 * t69;
  t75 = t31 * t39 / 0.8e1 + t37 * t67 / 0.8e1 + t48 * t56 / 0.8e1 + t54 * t72 / 0.8e1 - t59 * t62 / 0.8e1;
  t78 = 0.1e1 + 0.264e0 * t16 * t75;
  tzk0 = -0.4918e-1 * t14 * t78;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t2 * t6;
  t82 = t5 * t4;
  t83 = 0.1e1 / t82;
  t84 = t3 * t83;
  t86 = -0.2e1 * t81 + 0.2e1 * t84;
  t87 = t4 * t86;
  t88 = t13 * t78;
  t91 = t10 * t8;
  t92 = t12 * t12;
  t93 = 0.1e1 / t92;
  t94 = t93 * t78;
  t96 = 0.57212733333333333332e-2 * t91 * t94;
  t97 = t4 * t8;
  t99 = 0.1e1 / t9 / t4;
  t100 = t99 * t16;
  t102 = 0.222904e-1 * t100 * t75;
  t103 = t27 * t19;
  t104 = t17 - t81;
  t107 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t104);
  t108 = t107 * t30;
  t111 = rho[0] * rho[0];
  t113 = 0.1e1 / t33 / t111;
  t116 = lapl[0] * t113;
  t118 = -0.5e1 / 0.3e1 * tau[0] * t113 + 0.5e1 / 0.24e2 * t116;
  t121 = t45 * t41;
  t122 = -t104;
  t125 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t122);
  t126 = t125 * t30;
  t130 = 0.1e1 / t60 / t82;
  t132 = t59 * t130 / 0.3e1;
  t135 = t104 / 0.2e1;
  t136 = t66 * t135;
  t139 = -t135;
  t140 = t71 * t139;
  t143 = t108 * t39 / 0.8e1 + t31 * t118 / 0.8e1 + t126 * t56 / 0.8e1 + t132 - 0.5e1 / 0.24e2 * t116 * t67 + 0.5e1 / 0.24e2 * t37 * t136 + 0.5e1 / 0.24e2 * t54 * t140;
  t146 = t102 + 0.264e0 * t16 * t143;
  t147 = t13 * t146;
  tvrho0 = tzk0 - 0.4918e-1 * t87 * t88 - t96 - 0.4918e-1 * t97 * t147;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t151 = 0.2e1 * t81 + 0.2e1 * t84;
  t152 = t4 * t151;
  t155 = -t17 - t81;
  t158 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t155);
  t159 = t158 * t30;
  t162 = -t155;
  t165 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t162);
  t166 = t165 * t30;
  t169 = rho[1] * rho[1];
  t171 = 0.1e1 / t50 / t169;
  t174 = lapl[1] * t171;
  t176 = -0.5e1 / 0.3e1 * tau[1] * t171 + 0.5e1 / 0.24e2 * t174;
  t179 = t155 / 0.2e1;
  t180 = t66 * t179;
  t185 = -t179;
  t186 = t71 * t185;
  t189 = t159 * t39 / 0.8e1 + t166 * t56 / 0.8e1 + t48 * t176 / 0.8e1 + t132 + 0.5e1 / 0.24e2 * t37 * t180 - 0.5e1 / 0.24e2 * t174 * t72 + 0.5e1 / 0.24e2 * t54 * t186;
  t192 = t102 + 0.264e0 * t16 * t189;
  t193 = t13 * t192;
  tvrho1 = tzk0 - 0.4918e-1 * t152 * t88 - t96 - 0.4918e-1 * t97 * t193;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t197 = 0.1e1 / t60 / t4;
  t198 = t197 * t8;
  t199 = t13 * t16;
  t200 = t198 * t199;
  tvsigma0 = 0.162294e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.324588e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t201 = t31 * t35;
  t205 = -t201 / 0.64e2 + t35 * t67 / 0.8e1;
  t206 = t199 * t205;
  tvlapl0 = -0.1298352e-1 * t97 * t206;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t209 = t48 * t52;
  t213 = -t209 / 0.64e2 + t52 * t72 / 0.8e1;
  t214 = t199 * t213;
  tvlapl1 = -0.1298352e-1 * t97 * t214;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t217 = t97 * t13;
  t218 = t16 * t29;
  t219 = t30 * t35;
  t220 = t218 * t219;
  tvtau0 = -0.162294e-2 * t217 * t220;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t223 = t16 * t47;
  t224 = t30 * t52;
  t225 = t223 * t224;
  tvtau1 = -0.162294e-2 * t217 * t225;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t228 = t86 * t13;
  t229 = t228 * t78;
  t231 = t8 * t93;
  t232 = t78 * t99;
  t234 = 0.38141822222222222221e-2 * t231 * t232;
  t235 = t14 * t146;
  t237 = 0.2e1 * t6;
  t238 = t2 * t83;
  t239 = 0.8e1 * t238;
  t240 = t5 * t5;
  t241 = 0.1e1 / t240;
  t243 = 0.6e1 * t3 * t241;
  t244 = -t237 + t239 - t243;
  t245 = t4 * t244;
  t248 = t10 * t86;
  t249 = t248 * t94;
  t254 = 0.1e1 / t92 / t12;
  t255 = t254 * t78;
  t257 = 0.13311495955555555555e-2 * t198 * t255;
  t258 = t93 * t146;
  t259 = t91 * t258;
  t262 = 0.1e1 / t9 / t5;
  t263 = t262 * t16;
  t265 = 0.29720533333333333333e-1 * t263 * t75;
  t266 = t62 * t16;
  t268 = 0.18820527733333333333e-2 * t266 * t75;
  t269 = t100 * t143;
  t271 = t104 * t104;
  t274 = -t6 + t238;
  t275 = 0.2e1 * t274;
  t279 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t27 * t271 + 0.8e1 / 0.3e1 * t103 * t275);
  t280 = t279 * t30;
  t287 = 0.1e1 / t33 / t111 / rho[0];
  t290 = lapl[0] * t287;
  t292 = 0.4e2 / 0.9e1 * tau[0] * t287 - 0.5e1 / 0.9e1 * t290;
  t295 = t122 * t122;
  t298 = -t275;
  t302 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t45 * t295 + 0.8e1 / 0.3e1 * t121 * t298);
  t303 = t302 * t30;
  t307 = 0.1e1 / t60 / t240;
  t309 = 0.11e2 / 0.9e1 * t59 * t307;
  t314 = 0.1e1 / t65;
  t315 = t135 * t135;
  t316 = t314 * t315;
  t319 = t66 * t274;
  t322 = 0.1e1 / t70;
  t323 = t139 * t139;
  t324 = t322 * t323;
  t327 = -t274;
  t328 = t71 * t327;
  t331 = t280 * t39 / 0.8e1 + t108 * t118 / 0.4e1 + t31 * t292 / 0.8e1 + t303 * t56 / 0.8e1 - t309 + 0.5e1 / 0.9e1 * t290 * t67 - 0.25e2 / 0.36e2 * t116 * t136 + 0.5e1 / 0.36e2 * t37 * t316 + 0.5e1 / 0.24e2 * t37 * t319 + 0.5e1 / 0.36e2 * t54 * t324 + 0.5e1 / 0.24e2 * t54 * t328;
  t334 = -t265 + t268 + 0.445808e-1 * t269 + 0.264e0 * t16 * t331;
  t335 = t13 * t334;
  tv2rho20 = -0.9836e-1 * t229 - t234 - 0.9836e-1 * t235 - 0.4918e-1 * t245 * t88 - 0.11442546666666666666e-1 * t249 - 0.9836e-1 * t87 * t147 - t257 - 0.11442546666666666666e-1 * t259 - 0.4918e-1 * t97 * t335;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t340 = t151 * t13;
  t341 = t340 * t78;
  t343 = t237 - t243;
  t344 = t4 * t343;
  t347 = t10 * t151;
  t348 = t347 * t94;
  t354 = t14 * t192;
  t358 = t93 * t192;
  t359 = t91 * t358;
  t362 = t100 * t189;
  t364 = t27 * t155;
  t367 = t103 * t2;
  t371 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t364 * t104 + 0.16e2 / 0.3e1 * t367 * t83);
  t372 = t371 * t30;
  t377 = t45 * t162;
  t380 = t121 * t2;
  t384 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t377 * t122 - 0.16e2 / 0.3e1 * t380 * t83);
  t385 = t384 * t30;
  t392 = t314 * t179;
  t393 = t392 * t135;
  t396 = t66 * t2;
  t397 = t396 * t83;
  t402 = t322 * t185;
  t403 = t402 * t139;
  t406 = t71 * t2;
  t407 = t406 * t83;
  t410 = t372 * t39 / 0.8e1 + t159 * t118 / 0.8e1 + t385 * t56 / 0.8e1 + t126 * t176 / 0.8e1 - t309 - 0.25e2 / 0.72e2 * t116 * t180 + 0.5e1 / 0.36e2 * t37 * t393 + 0.5e1 / 0.24e2 * t37 * t397 - 0.25e2 / 0.72e2 * t174 * t140 + 0.5e1 / 0.36e2 * t54 * t403 - 0.5e1 / 0.24e2 * t54 * t407;
  t413 = -t265 + t268 + 0.222904e-1 * t269 + 0.222904e-1 * t362 + 0.264e0 * t16 * t410;
  t414 = t13 * t413;
  tv2rho21 = -0.4918e-1 * t229 - t234 - 0.4918e-1 * t235 - 0.4918e-1 * t341 - 0.4918e-1 * t344 * t88 - 0.57212733333333333332e-2 * t348 - 0.4918e-1 * t152 * t147 - 0.57212733333333333332e-2 * t249 - t257 - 0.57212733333333333332e-2 * t259 - 0.4918e-1 * t354 - 0.4918e-1 * t87 * t193 - 0.57212733333333333332e-2 * t359 - 0.4918e-1 * t97 * t414;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t419 = -t237 - t239 - t243;
  t420 = t4 * t419;
  t428 = t155 * t155;
  t431 = t6 + t238;
  t432 = 0.2e1 * t431;
  t436 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t27 * t428 + 0.8e1 / 0.3e1 * t103 * t432);
  t437 = t436 * t30;
  t440 = t162 * t162;
  t443 = -t432;
  t447 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t45 * t440 + 0.8e1 / 0.3e1 * t121 * t443);
  t448 = t447 * t30;
  t455 = 0.1e1 / t50 / t169 / rho[1];
  t458 = lapl[1] * t455;
  t460 = 0.4e2 / 0.9e1 * tau[1] * t455 - 0.5e1 / 0.9e1 * t458;
  t463 = t179 * t179;
  t464 = t314 * t463;
  t467 = t66 * t431;
  t474 = t185 * t185;
  t475 = t322 * t474;
  t478 = -t431;
  t479 = t71 * t478;
  t482 = t437 * t39 / 0.8e1 + t448 * t56 / 0.8e1 + t166 * t176 / 0.4e1 + t48 * t460 / 0.8e1 - t309 + 0.5e1 / 0.36e2 * t37 * t464 + 0.5e1 / 0.24e2 * t37 * t467 + 0.5e1 / 0.9e1 * t458 * t72 - 0.25e2 / 0.36e2 * t174 * t186 + 0.5e1 / 0.36e2 * t54 * t475 + 0.5e1 / 0.24e2 * t54 * t479;
  t485 = -t265 + t268 + 0.445808e-1 * t362 + 0.264e0 * t16 * t482;
  t486 = t13 * t485;
  tv2rho22 = -0.9836e-1 * t341 - t234 - 0.9836e-1 * t354 - 0.4918e-1 * t420 * t88 - 0.11442546666666666666e-1 * t348 - 0.9836e-1 * t152 * t193 - t257 - 0.11442546666666666666e-1 * t359 - 0.4918e-1 * t97 * t486;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t489 = t62 * t8;
  t490 = t489 * t199;
  t491 = 0.27049e-2 * t490;
  t492 = t197 * t86;
  t493 = t492 * t199;
  t495 = t83 * t8;
  t496 = t93 * t16;
  t497 = t495 * t496;
  t498 = 0.18880201999999999999e-3 * t497;
  t499 = t495 * t199;
  t500 = 0.137030234e-3 * t499;
  tv2rhosigma0 = -t491 + 0.162294e-2 * t493 + t498 + t500;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t501 = 0.54098e-2 * t490;
  t503 = 0.37760403999999999999e-3 * t497;
  t504 = 0.274060468e-3 * t499;
  tv2rhosigma1 = -t501 + 0.324588e-2 * t493 + t503 + t504;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t505 = t197 * t151;
  t506 = t505 * t199;
  tv2rhosigma3 = -t491 + 0.162294e-2 * t506 + t498 + t500;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t501 + 0.324588e-2 * t506 + t503 + t504;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t509 = t16 * t205;
  t511 = 0.1298352e-1 * t14 * t509;
  t514 = t496 * t205;
  t516 = 0.151041616e-2 * t91 * t514;
  t518 = 0.1096241872e-2 * t91 * t206;
  t519 = t108 * t35;
  t521 = t31 * t113;
  t525 = t35 * t66;
  t528 = -t519 / 0.64e2 + 0.5e1 / 0.192e3 * t521 - 0.5e1 / 0.24e2 * t113 * t67 + 0.5e1 / 0.24e2 * t525 * t135;
  t529 = t199 * t528;
  tv2rholapl0 = -t511 - 0.1298352e-1 * t87 * t206 - t516 - t518 - 0.1298352e-1 * t97 * t529;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t532 = t16 * t213;
  t534 = 0.1298352e-1 * t14 * t532;
  t537 = t496 * t213;
  t539 = 0.151041616e-2 * t91 * t537;
  t541 = 0.1096241872e-2 * t91 * t214;
  t542 = t126 * t52;
  t544 = t52 * t71;
  t547 = -t542 / 0.64e2 + 0.5e1 / 0.24e2 * t544 * t139;
  t548 = t199 * t547;
  tv2rholapl1 = -t534 - 0.1298352e-1 * t87 * t214 - t539 - t541 - 0.1298352e-1 * t97 * t548;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t553 = t159 * t35;
  t557 = -t553 / 0.64e2 + 0.5e1 / 0.24e2 * t525 * t179;
  t558 = t199 * t557;
  tv2rholapl2 = -t511 - 0.1298352e-1 * t152 * t206 - t516 - t518 - 0.1298352e-1 * t97 * t558;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t563 = t166 * t52;
  t565 = t48 * t171;
  t571 = -t563 / 0.64e2 + 0.5e1 / 0.192e3 * t565 - 0.5e1 / 0.24e2 * t171 * t72 + 0.5e1 / 0.24e2 * t544 * t185;
  t572 = t199 * t571;
  tv2rholapl3 = -t534 - 0.1298352e-1 * t152 * t214 - t539 - t541 - 0.1298352e-1 * t97 * t572;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t575 = t14 * t16;
  t577 = 0.162294e-2 * t575 * t201;
  t578 = t87 * t13;
  t581 = t91 * t93;
  t583 = 0.18880201999999999999e-3 * t581 * t220;
  t584 = t91 * t13;
  t586 = 0.137030234e-3 * t584 * t220;
  t587 = t16 * t107;
  t588 = t587 * t219;
  t591 = t30 * t113;
  t592 = t218 * t591;
  tv2rhotau0 = -t577 - 0.162294e-2 * t578 * t220 - t583 - t586 - 0.162294e-2 * t217 * t588 + 0.27049e-2 * t217 * t592;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t596 = 0.162294e-2 * t575 * t209;
  t600 = 0.18880201999999999999e-3 * t581 * t225;
  t602 = 0.137030234e-3 * t584 * t225;
  t603 = t16 * t125;
  t604 = t603 * t224;
  tv2rhotau1 = -t596 - 0.162294e-2 * t578 * t225 - t600 - t602 - 0.162294e-2 * t217 * t604;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t607 = t152 * t13;
  t610 = t16 * t158;
  t611 = t610 * t219;
  tv2rhotau2 = -t577 - 0.162294e-2 * t607 * t220 - t583 - t586 - 0.162294e-2 * t217 * t611;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t616 = t16 * t165;
  t617 = t616 * t224;
  t620 = t30 * t171;
  t621 = t223 * t620;
  tv2rhotau3 = -t596 - 0.162294e-2 * t607 * t225 - t600 - t602 - 0.162294e-2 * t217 * t617 + 0.27049e-2 * t217 * t621;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t624 = t254 * t146;
  t625 = t198 * t624;
  t627 = t92 * t92;
  t628 = 0.1e1 / t627;
  t629 = t628 * t78;
  t631 = 0.46457120884888888886e-3 * t495 * t629;
  t632 = t93 * t334;
  t633 = t91 * t632;
  t636 = 0.1e1 / t9 / t82;
  t637 = t636 * t16;
  t639 = 0.6934791111111111111e-1 * t637 * t75;
  t640 = t130 * t16;
  t642 = 0.75282110933333333332e-2 * t640 * t75;
  t643 = t263 * t143;
  t645 = t241 * t16;
  t647 = 0.15890798916177777777e-3 * t645 * t75;
  t648 = t266 * t143;
  t650 = t100 * t331;
  t652 = 0.1e1 / t26;
  t653 = t271 * t104;
  t656 = t27 * t104;
  t659 = t2 * t241;
  t660 = t83 - t659;
  t661 = 0.6e1 * t660;
  t665 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t652 * t653 + 0.4e2 / 0.3e1 * t656 * t275 + 0.8e1 / 0.3e1 * t103 * t661);
  t666 = t665 * t30;
  t673 = t111 * t111;
  t675 = 0.1e1 / t33 / t673;
  t678 = lapl[0] * t675;
  t680 = -0.44e3 / 0.27e2 * tau[0] * t675 + 0.55e2 / 0.27e2 * t678;
  t683 = 0.1e1 / t44;
  t684 = t295 * t122;
  t687 = t45 * t122;
  t690 = -t661;
  t694 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t683 * t684 + 0.4e2 / 0.3e1 * t687 * t298 + 0.8e1 / 0.3e1 * t121 * t690);
  t695 = t694 * t30;
  t698 = t240 * t4;
  t700 = 0.1e1 / t60 / t698;
  t702 = 0.154e3 / 0.27e2 * t59 * t700;
  t712 = 0.1e1 / t65 / t64;
  t713 = t315 * t135;
  t714 = t712 * t713;
  t717 = t314 * t135;
  t718 = t717 * t274;
  t721 = 0.3e1 * t660;
  t722 = t66 * t721;
  t726 = 0.1e1 / t70 / t69;
  t727 = t323 * t139;
  t728 = t726 * t727;
  t731 = t322 * t139;
  t732 = t731 * t327;
  t735 = -t721;
  t736 = t71 * t735;
  t739 = t666 * t39 / 0.8e1 + 0.3e1 / 0.8e1 * t280 * t118 + 0.3e1 / 0.8e1 * t108 * t292 + t31 * t680 / 0.8e1 + t695 * t56 / 0.8e1 + t702 - 0.55e2 / 0.27e2 * t678 * t67 + 0.25e2 / 0.9e1 * t290 * t136 - 0.25e2 / 0.36e2 * t116 * t316 - 0.25e2 / 0.24e2 * t116 * t319 - 0.5e1 / 0.108e3 * t37 * t714 + 0.5e1 / 0.12e2 * t37 * t718 + 0.5e1 / 0.24e2 * t37 * t722 - 0.5e1 / 0.108e3 * t54 * t728 + 0.5e1 / 0.12e2 * t54 * t732 + 0.5e1 / 0.24e2 * t54 * t736;
  t742 = t639 - t642 - 0.891616e-1 * t643 + t647 + 0.564615832e-2 * t648 + 0.668712e-1 * t650 + 0.264e0 * t16 * t739;
  t743 = t13 * t742;
  t746 = 0.12e2 * t83;
  t747 = 0.36e2 * t659;
  t748 = 0.1e1 / t698;
  t750 = 0.24e2 * t3 * t748;
  t751 = t746 - t747 + t750;
  t752 = t4 * t751;
  t757 = t10 * t244;
  t758 = t757 * t94;
  t760 = t248 * t258;
  t762 = t492 * t255;
  t766 = t86 * t93;
  t767 = t766 * t232;
  t769 = t146 * t99;
  t770 = t231 * t769;
  t772 = t8 * t254;
  t773 = t78 * t62;
  t775 = 0.13311495955555555556e-2 * t772 * t773;
  t776 = t14 * t334;
  t778 = t244 * t13;
  t779 = t778 * t78;
  t781 = t228 * t146;
  t783 = t78 * t262;
  t785 = 0.50855762962962962961e-2 * t231 * t783;
  tv3rho30 = -0.39934487866666666664e-2 * t625 - t631 - 0.17163819999999999999e-1 * t633 - 0.4918e-1 * t97 * t743 - 0.4918e-1 * t752 * t88 - 0.14754e0 * t245 * t147 - 0.17163819999999999999e-1 * t758 - 0.34327639999999999998e-1 * t760 - 0.39934487866666666664e-2 * t762 - 0.14754e0 * t87 * t335 - 0.11442546666666666666e-1 * t767 - 0.11442546666666666666e-1 * t770 + t775 - 0.14754e0 * t776 - 0.14754e0 * t779 - 0.29508e0 * t781 + t785;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t793 = t254 * t192;
  t794 = t198 * t793;
  t799 = t263 * t189;
  t801 = t266 * t189;
  t804 = 0.445808e-1 * t100 * t410;
  t811 = t392 * t274;
  t814 = t66 * t83;
  t819 = t402 * t327;
  t822 = t71 * t83;
  t825 = t652 * t155;
  t828 = t27 * t2;
  t839 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t825 * t271 + 0.16e3 / 0.9e1 * t828 * t83 * t104 + 0.4e2 / 0.9e1 * t364 * t275 + 0.16e2 / 0.3e1 * t103 * t83 - 0.16e2 * t367 * t241);
  t840 = t839 * t30;
  t848 = t683 * t162;
  t851 = t45 * t2;
  t862 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t848 * t295 - 0.16e3 / 0.9e1 * t851 * t83 * t122 + 0.4e2 / 0.9e1 * t377 * t298 - 0.16e2 / 0.3e1 * t121 * t83 + 0.16e2 * t380 * t241);
  t863 = t862 * t30;
  t870 = t54 * t322;
  t871 = t238 * t139;
  t874 = t406 * t241;
  t878 = t712 * t179 * t315;
  t881 = t37 * t314;
  t882 = t238 * t135;
  t885 = t396 * t241;
  t889 = t726 * t185 * t323;
  t892 = t159 * t292 / 0.8e1 + t863 * t56 / 0.8e1 + t303 * t176 / 0.8e1 - 0.25e2 / 0.72e2 * t174 * t328 + t702 - 0.5e1 / 0.18e2 * t870 * t871 + 0.5e1 / 0.8e1 * t54 * t874 - 0.5e1 / 0.108e3 * t37 * t878 + 0.5e1 / 0.18e2 * t881 * t882 - 0.5e1 / 0.8e1 * t37 * t885 - 0.5e1 / 0.108e3 * t54 * t889;
  t893 = 0.25e2 / 0.27e2 * t290 * t180 - 0.25e2 / 0.54e2 * t116 * t393 - 0.25e2 / 0.36e2 * t116 * t397 + 0.5e1 / 0.36e2 * t37 * t811 + 0.5e1 / 0.24e2 * t37 * t814 - 0.25e2 / 0.108e3 * t174 * t324 + 0.5e1 / 0.36e2 * t54 * t819 - 0.5e1 / 0.24e2 * t54 * t822 + t840 * t39 / 0.8e1 + t372 * t118 / 0.4e1 + t892;
  t896 = t639 - t642 - 0.59441066666666666666e-1 * t643 + t647 + 0.37641055466666666666e-2 * t648 + 0.222904e-1 * t650 - 0.29720533333333333333e-1 * t799 + 0.18820527733333333333e-2 * t801 + t804 + 0.264e0 * t16 * t893;
  t897 = t13 * t896;
  t900 = t192 * t99;
  t901 = t231 * t900;
  t907 = -0.57212733333333333332e-2 * t758 - 0.11442546666666666666e-1 * t760 - 0.2662299191111111111e-2 * t762 - 0.2662299191111111111e-2 * t625 - t631 - 0.57212733333333333332e-2 * t633 - 0.76283644444444444442e-2 * t767 - 0.76283644444444444442e-2 * t770 + t775 + t785 - 0.13311495955555555555e-2 * t794 - 0.4918e-1 * t97 * t897 - 0.38141822222222222221e-2 * t901 - 0.4918e-1 * t245 * t193 - 0.9836e-1 * t87 * t414;
  t909 = 0.11442546666666666666e-1 * t248 * t358;
  t910 = t93 * t413;
  t912 = 0.11442546666666666666e-1 * t91 * t910;
  t913 = t151 * t93;
  t914 = t913 * t232;
  t916 = 0.4e1 * t83;
  t917 = 0.12e2 * t659;
  t918 = -t916 - t917 + t750;
  t919 = t4 * t918;
  t924 = t10 * t343;
  t926 = 0.11442546666666666666e-1 * t924 * t94;
  t928 = 0.11442546666666666666e-1 * t347 * t258;
  t929 = t505 * t255;
  t937 = 0.9836e-1 * t228 * t192;
  t939 = 0.9836e-1 * t14 * t413;
  t940 = t343 * t13;
  t942 = 0.9836e-1 * t940 * t78;
  t944 = 0.9836e-1 * t340 * t146;
  t945 = -t909 - t912 - 0.38141822222222222221e-2 * t914 - 0.4918e-1 * t919 * t88 - 0.9836e-1 * t344 * t147 - t926 - t928 - 0.13311495955555555555e-2 * t929 - 0.4918e-1 * t152 * t335 - 0.4918e-1 * t776 - 0.4918e-1 * t779 - 0.9836e-1 * t781 - t937 - t939 - t942 - t944;
  tv3rho31 = t907 + t945;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t948 = t340 * t192;
  t950 = t419 * t13;
  t951 = t950 * t78;
  t955 = t10 * t419;
  t956 = t955 * t94;
  t960 = -t916 + t917 + t750;
  t961 = t4 * t960;
  t970 = t100 * t482;
  t972 = t652 * t428;
  t977 = t27 * t432;
  t982 = -0.2e1 * t83 - 0.6e1 * t659;
  t986 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t972 * t104 + 0.16e3 / 0.9e1 * t364 * t238 + 0.4e2 / 0.9e1 * t977 * t104 + 0.8e1 / 0.3e1 * t103 * t982);
  t987 = t986 * t30;
  t992 = t683 * t440;
  t997 = t45 * t443;
  t1000 = -t982;
  t1004 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t992 * t122 - 0.16e3 / 0.9e1 * t377 * t238 + 0.4e2 / 0.9e1 * t997 * t122 + 0.8e1 / 0.3e1 * t121 * t1000);
  t1005 = t1004 * t30;
  t1014 = t712 * t463;
  t1015 = t1014 * t135;
  t1018 = t179 * t2;
  t1019 = t1018 * t83;
  t1024 = t314 * t431;
  t1025 = t1024 * t135;
  t1029 = -t83 - 0.3e1 * t659;
  t1030 = t66 * t1029;
  t1039 = t726 * t474;
  t1040 = t1039 * t139;
  t1043 = t185 * t2;
  t1044 = t1043 * t83;
  t1047 = t322 * t478;
  t1048 = t1047 * t139;
  t1051 = -t1029;
  t1052 = t71 * t1051;
  t1055 = t987 * t39 / 0.8e1 + t437 * t118 / 0.8e1 + t1005 * t56 / 0.8e1 + t385 * t176 / 0.4e1 + t126 * t460 / 0.8e1 + t702 - 0.25e2 / 0.108e3 * t116 * t464 - 0.5e1 / 0.108e3 * t37 * t1015 + 0.5e1 / 0.18e2 * t881 * t1019 - 0.25e2 / 0.72e2 * t116 * t467 + 0.5e1 / 0.36e2 * t37 * t1025 + 0.5e1 / 0.24e2 * t37 * t1030 + 0.25e2 / 0.27e2 * t458 * t140 - 0.25e2 / 0.54e2 * t174 * t403 + 0.25e2 / 0.36e2 * t174 * t407 - 0.5e1 / 0.108e3 * t54 * t1040 - 0.5e1 / 0.18e2 * t870 * t1044 + 0.5e1 / 0.36e2 * t54 * t1048 + 0.5e1 / 0.24e2 * t54 * t1052;
  t1058 = t639 - t642 - 0.29720533333333333333e-1 * t643 + t647 + 0.18820527733333333333e-2 * t648 - 0.59441066666666666667e-1 * t799 + 0.37641055466666666667e-2 * t801 + t804 + 0.222904e-1 * t970 + 0.264e0 * t16 * t1055;
  t1059 = t13 * t1058;
  t1064 = t93 * t485;
  t1065 = t91 * t1064;
  t1067 = t347 * t358;
  t1069 = t14 * t485;
  t1071 = -0.13311495955555555555e-2 * t762 - 0.13311495955555555555e-2 * t625 - t631 - 0.9836e-1 * t948 - 0.4918e-1 * t951 - 0.9836e-1 * t152 * t414 - 0.57212733333333333332e-2 * t956 - 0.9836e-1 * t344 * t193 - 0.4918e-1 * t961 * t88 - 0.4918e-1 * t420 * t147 - 0.4918e-1 * t97 * t1059 - 0.4918e-1 * t87 * t486 - 0.57212733333333333332e-2 * t1065 - 0.11442546666666666666e-1 * t1067 - 0.4918e-1 * t1069;
  t1078 = -0.38141822222222222221e-2 * t767 - 0.38141822222222222221e-2 * t770 + t775 + t785 - 0.26622991911111111109e-2 * t794 - 0.7628364444444444444e-2 * t901 - t909 - t912 - 0.7628364444444444444e-2 * t914 - t926 - t928 - 0.26622991911111111109e-2 * t929 - t937 - t939 - t942 - t944;
  tv3rho32 = t1071 + t1078;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1082 = t428 * t155;
  t1087 = -t83 - t659;
  t1088 = 0.6e1 * t1087;
  t1092 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t652 * t1082 + 0.4e2 / 0.3e1 * t364 * t432 + 0.8e1 / 0.3e1 * t103 * t1088);
  t1093 = t1092 * t30;
  t1096 = t440 * t162;
  t1101 = -t1088;
  t1105 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t683 * t1096 + 0.4e2 / 0.3e1 * t377 * t443 + 0.8e1 / 0.3e1 * t121 * t1101);
  t1106 = t1105 * t30;
  t1113 = t169 * t169;
  t1115 = 0.1e1 / t50 / t1113;
  t1118 = lapl[1] * t1115;
  t1120 = -0.44e3 / 0.27e2 * tau[1] * t1115 + 0.55e2 / 0.27e2 * t1118;
  t1123 = t463 * t179;
  t1124 = t712 * t1123;
  t1127 = t392 * t431;
  t1130 = 0.3e1 * t1087;
  t1131 = t66 * t1130;
  t1142 = t474 * t185;
  t1143 = t726 * t1142;
  t1146 = t402 * t478;
  t1149 = -t1130;
  t1150 = t71 * t1149;
  t1153 = t1093 * t39 / 0.8e1 + t1106 * t56 / 0.8e1 + 0.3e1 / 0.8e1 * t448 * t176 + 0.3e1 / 0.8e1 * t166 * t460 + t48 * t1120 / 0.8e1 + t702 - 0.5e1 / 0.108e3 * t37 * t1124 + 0.5e1 / 0.12e2 * t37 * t1127 + 0.5e1 / 0.24e2 * t37 * t1131 - 0.55e2 / 0.27e2 * t1118 * t72 + 0.25e2 / 0.9e1 * t458 * t186 - 0.25e2 / 0.36e2 * t174 * t475 - 0.25e2 / 0.24e2 * t174 * t479 - 0.5e1 / 0.108e3 * t54 * t1143 + 0.5e1 / 0.12e2 * t54 * t1146 + 0.5e1 / 0.24e2 * t54 * t1150;
  t1156 = t639 - t642 - 0.891616e-1 * t799 + t647 + 0.564615832e-2 * t801 + 0.668712e-1 * t970 + 0.264e0 * t16 * t1153;
  t1157 = t13 * t1156;
  t1160 = t746 + t747 + t750;
  t1161 = t4 * t1160;
  tv3rho33 = -0.4918e-1 * t97 * t1157 - 0.4918e-1 * t1161 * t88 - 0.14754e0 * t420 * t193 - 0.14754e0 * t152 * t486 - 0.17163819999999999999e-1 * t1065 - 0.34327639999999999998e-1 * t1067 - 0.14754e0 * t1069 - 0.14754e0 * t951 - 0.17163819999999999999e-1 * t956 - 0.29508e0 * t948 - 0.39934487866666666664e-2 * t794 - 0.11442546666666666666e-1 * t901 - 0.11442546666666666666e-1 * t914 - 0.39934487866666666664e-2 * t929 - t631 + t775 + t785;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1179 = t130 * t8 * t199;
  t1180 = 0.72130666666666666667e-2 * t1179;
  t1181 = t62 * t86;
  t1182 = t1181 * t199;
  t1183 = 0.54098e-2 * t1182;
  t1184 = t241 * t8;
  t1185 = t1184 * t496;
  t1186 = 0.88107609333333333329e-3 * t1185;
  t1187 = t1184 * t199;
  t1188 = 0.63947442533333333333e-3 * t1187;
  t1189 = t197 * t244;
  t1190 = t1189 * t199;
  t1192 = t83 * t86;
  t1193 = t1192 * t496;
  t1195 = t1192 * t199;
  t1196 = 0.274060468e-3 * t1195;
  t1198 = 0.1e1 / t9 / t240;
  t1199 = t1198 * t8;
  t1200 = t254 * t16;
  t1201 = t1199 * t1200;
  t1202 = 0.4392793665333333333e-4 * t1201;
  t1203 = t1199 * t496;
  t1204 = 0.31882367777333333332e-4 * t1203;
  t1205 = t1199 * t199;
  t1206 = 0.11569919424066666667e-4 * t1205;
  tv3rho2sigma0 = t1180 - t1183 - t1186 - t1188 + 0.162294e-2 * t1190 + 0.37760403999999999998e-3 * t1193 + t1196 + t1202 + t1204 + t1206;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t1207 = 0.14426133333333333333e-1 * t1179;
  t1209 = 0.17621521866666666666e-2 * t1185;
  t1210 = 0.12789488506666666667e-2 * t1187;
  t1214 = 0.87855873306666666662e-4 * t1201;
  t1215 = 0.63764735554666666664e-4 * t1203;
  t1216 = 0.23139838848133333333e-4 * t1205;
  tv3rho2sigma1 = t1207 - 0.108196e-1 * t1182 - t1209 - t1210 + 0.324588e-2 * t1190 + 0.75520807999999999998e-3 * t1193 + 0.548120936e-3 * t1195 + t1214 + t1215 + t1216;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1219 = t62 * t151 * t199;
  t1221 = t197 * t343;
  t1222 = t1221 * t199;
  t1224 = t83 * t151;
  t1225 = t1224 * t496;
  t1227 = t1224 * t199;
  tv3rho2sigma3 = t1180 - 0.27049e-2 * t1182 - t1186 - t1188 - 0.27049e-2 * t1219 + 0.162294e-2 * t1222 + 0.18880201999999999999e-3 * t1225 + 0.137030234e-3 * t1227 + 0.18880201999999999999e-3 * t1193 + t1202 + t1204 + 0.137030234e-3 * t1195 + t1206;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t1231 = 0.54098e-2 * t1219;
  t1234 = 0.274060468e-3 * t1227;
  tv3rho2sigma4 = t1207 - t1183 - t1209 - t1210 - t1231 + 0.324588e-2 * t1222 + 0.37760403999999999999e-3 * t1225 + t1234 + 0.37760403999999999999e-3 * t1193 + t1214 + t1215 + t1196 + t1216;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1236 = t197 * t419;
  t1237 = t1236 * t199;
  tv3rho2sigma6 = t1180 - t1231 - t1186 - t1188 + 0.162294e-2 * t1237 + 0.37760403999999999998e-3 * t1225 + t1234 + t1202 + t1204 + t1206;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = t1207 - 0.108196e-1 * t1219 - t1209 - t1210 + 0.324588e-2 * t1237 + 0.75520807999999999998e-3 * t1225 + 0.548120936e-3 * t1227 + t1214 + t1215 + t1216;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1244 = t228 * t509;
  t1246 = t509 * t99;
  t1248 = 0.10069441066666666667e-2 * t231 * t1246;
  t1250 = 0.73082791466666666667e-3 * t14 * t1246;
  t1251 = t16 * t528;
  t1252 = t14 * t1251;
  t1256 = t248 * t514;
  t1258 = t248 * t206;
  t1262 = t1200 * t205;
  t1264 = 0.35142349322666666666e-3 * t198 * t1262;
  t1266 = 0.25505894221866666666e-3 * t198 * t514;
  t1267 = t496 * t528;
  t1268 = t91 * t1267;
  t1271 = 0.92559355392533333333e-4 * t198 * t206;
  t1272 = t91 * t529;
  t1274 = t280 * t35;
  t1276 = t108 * t113;
  t1278 = t31 * t287;
  t1282 = t113 * t66;
  t1285 = t35 * t314;
  t1290 = -t1274 / 0.64e2 + 0.5e1 / 0.96e2 * t1276 - 0.5e1 / 0.72e2 * t1278 + 0.5e1 / 0.9e1 * t287 * t67 - 0.25e2 / 0.36e2 * t1282 * t135 + 0.5e1 / 0.36e2 * t1285 * t315 + 0.5e1 / 0.24e2 * t525 * t274;
  t1291 = t199 * t1290;
  tv3rho2lapl0 = -0.2596704e-1 * t1244 - t1248 - t1250 - 0.2596704e-1 * t1252 - 0.1298352e-1 * t245 * t206 - 0.302083232e-2 * t1256 - 0.2192483744e-2 * t1258 - 0.2596704e-1 * t87 * t529 - t1264 - t1266 - 0.302083232e-2 * t1268 - t1271 - 0.2192483744e-2 * t1272 - 0.1298352e-1 * t97 * t1291;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1294 = t228 * t532;
  t1296 = t532 * t99;
  t1298 = 0.10069441066666666667e-2 * t231 * t1296;
  t1300 = 0.73082791466666666667e-3 * t14 * t1296;
  t1301 = t16 * t547;
  t1302 = t14 * t1301;
  t1306 = t248 * t537;
  t1308 = t248 * t214;
  t1312 = t1200 * t213;
  t1314 = 0.35142349322666666666e-3 * t198 * t1312;
  t1316 = 0.25505894221866666666e-3 * t198 * t537;
  t1317 = t496 * t547;
  t1318 = t91 * t1317;
  t1321 = 0.92559355392533333333e-4 * t198 * t214;
  t1322 = t91 * t548;
  t1324 = t303 * t52;
  t1326 = t52 * t322;
  t1331 = -t1324 / 0.64e2 + 0.5e1 / 0.36e2 * t1326 * t323 + 0.5e1 / 0.24e2 * t544 * t327;
  t1332 = t199 * t1331;
  tv3rho2lapl1 = -0.2596704e-1 * t1294 - t1298 - t1300 - 0.2596704e-1 * t1302 - 0.1298352e-1 * t245 * t214 - 0.302083232e-2 * t1306 - 0.2192483744e-2 * t1308 - 0.2596704e-1 * t87 * t548 - t1314 - t1316 - 0.302083232e-2 * t1318 - t1321 - 0.2192483744e-2 * t1322 - 0.1298352e-1 * t97 * t1332;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1337 = t340 * t509;
  t1341 = t347 * t514;
  t1343 = t347 * t206;
  t1352 = t16 * t557;
  t1353 = t14 * t1352;
  t1357 = t496 * t557;
  t1358 = t91 * t1357;
  t1360 = t91 * t558;
  t1362 = t372 * t35;
  t1364 = t159 * t113;
  t1368 = t179 * t135;
  t1373 = -t1362 / 0.64e2 + 0.5e1 / 0.192e3 * t1364 - 0.25e2 / 0.72e2 * t1282 * t179 + 0.5e1 / 0.36e2 * t1285 * t1368 + 0.5e1 / 0.24e2 * t525 * t238;
  t1374 = t199 * t1373;
  t1377 = -t1264 - t1266 - 0.151041616e-2 * t1268 - 0.1096241872e-2 * t1258 - t1271 - 0.1096241872e-2 * t1272 - 0.1298352e-1 * t1353 - 0.1298352e-1 * t87 * t558 - 0.151041616e-2 * t1358 - 0.1096241872e-2 * t1360 - 0.1298352e-1 * t97 * t1374;
  tv3rho2lapl2 = -0.1298352e-1 * t1244 - t1248 - t1250 - 0.1298352e-1 * t1252 - 0.1298352e-1 * t1337 - 0.1298352e-1 * t344 * t206 - 0.151041616e-2 * t1341 - 0.1096241872e-2 * t1343 - 0.1298352e-1 * t152 * t529 - 0.151041616e-2 * t1256 + t1377;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1380 = t340 * t532;
  t1384 = t347 * t537;
  t1386 = t347 * t214;
  t1395 = t16 * t571;
  t1396 = t14 * t1395;
  t1400 = t496 * t571;
  t1401 = t91 * t1400;
  t1403 = t91 * t572;
  t1405 = t385 * t52;
  t1407 = t126 * t171;
  t1409 = t171 * t71;
  t1412 = t185 * t139;
  t1417 = -t1405 / 0.64e2 + 0.5e1 / 0.192e3 * t1407 - 0.25e2 / 0.72e2 * t1409 * t139 + 0.5e1 / 0.36e2 * t1326 * t1412 - 0.5e1 / 0.24e2 * t544 * t238;
  t1418 = t199 * t1417;
  t1421 = -t1314 - t1316 - 0.151041616e-2 * t1318 - 0.1096241872e-2 * t1308 - t1321 - 0.1096241872e-2 * t1322 - 0.1298352e-1 * t1396 - 0.1298352e-1 * t87 * t572 - 0.151041616e-2 * t1401 - 0.1096241872e-2 * t1403 - 0.1298352e-1 * t97 * t1418;
  tv3rho2lapl3 = -0.1298352e-1 * t1294 - t1298 - t1300 - 0.1298352e-1 * t1302 - 0.1298352e-1 * t1380 - 0.1298352e-1 * t344 * t214 - 0.151041616e-2 * t1384 - 0.1096241872e-2 * t1386 - 0.1298352e-1 * t152 * t548 - 0.151041616e-2 * t1306 + t1421;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1432 = t437 * t35;
  t1438 = -t1432 / 0.64e2 + 0.5e1 / 0.36e2 * t1285 * t463 + 0.5e1 / 0.24e2 * t525 * t431;
  t1439 = t199 * t1438;
  tv3rho2lapl4 = -0.2596704e-1 * t1337 - t1248 - t1250 - 0.2596704e-1 * t1353 - 0.1298352e-1 * t420 * t206 - 0.302083232e-2 * t1341 - 0.2192483744e-2 * t1343 - 0.2596704e-1 * t152 * t558 - t1264 - t1266 - 0.302083232e-2 * t1358 - t1271 - 0.2192483744e-2 * t1360 - 0.1298352e-1 * t97 * t1439;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1452 = t448 * t52;
  t1454 = t166 * t171;
  t1456 = t48 * t455;
  t1466 = -t1452 / 0.64e2 + 0.5e1 / 0.96e2 * t1454 - 0.5e1 / 0.72e2 * t1456 + 0.5e1 / 0.9e1 * t455 * t72 - 0.25e2 / 0.36e2 * t1409 * t185 + 0.5e1 / 0.36e2 * t1326 * t474 + 0.5e1 / 0.24e2 * t544 * t478;
  t1467 = t199 * t1466;
  tv3rho2lapl5 = -0.2596704e-1 * t1380 - t1298 - t1300 - 0.2596704e-1 * t1396 - 0.1298352e-1 * t420 * t214 - 0.302083232e-2 * t1384 - 0.2192483744e-2 * t1386 - 0.2596704e-1 * t152 * t572 - t1314 - t1316 - 0.302083232e-2 * t1401 - t1321 - 0.2192483744e-2 * t1403 - 0.1298352e-1 * t97 * t1467;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1472 = t581 * t592;
  t1474 = t584 * t592;
  t1476 = t587 * t591;
  t1479 = t30 * t287;
  t1480 = t218 * t1479;
  t1483 = t575 * t521;
  t1485 = t231 * t16;
  t1486 = t35 * t99;
  t1487 = t31 * t1486;
  t1489 = 0.12586801333333333333e-3 * t1485 * t1487;
  t1490 = t14 * t99;
  t1492 = 0.91353489333333333333e-4 * t1490 * t220;
  t1493 = t245 * t13;
  t1498 = t248 * t93;
  t1499 = t1498 * t220;
  t1501 = t248 * t13;
  t1502 = t1501 * t220;
  t1504 = t581 * t588;
  t1506 = t198 * t254;
  t1508 = 0.4392793665333333333e-4 * t1506 * t220;
  t1509 = t198 * t93;
  t1511 = 0.31882367777333333332e-4 * t1509 * t220;
  t1512 = t584 * t588;
  t1514 = t198 * t13;
  t1516 = 0.11569919424066666667e-4 * t1514 * t220;
  t1517 = t16 * t279;
  t1518 = t1517 * t219;
  t1521 = t228 * t16;
  t1522 = t1521 * t201;
  t1524 = t575 * t519;
  tv3rho2tau0 = 0.54098e-2 * t578 * t592 + 0.62934006666666666664e-3 * t1472 + 0.45676744666666666666e-3 * t1474 + 0.54098e-2 * t217 * t1476 - 0.72130666666666666667e-2 * t217 * t1480 + 0.54098e-2 * t1483 - t1489 - t1492 - 0.162294e-2 * t1493 * t220 - 0.324588e-2 * t578 * t588 - 0.37760403999999999998e-3 * t1499 - 0.274060468e-3 * t1502 - 0.37760403999999999998e-3 * t1504 - t1508 - t1511 - 0.274060468e-3 * t1512 - t1516 - 0.162294e-2 * t217 * t1518 - 0.324588e-2 * t1522 - 0.324588e-2 * t1524;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1526 = t1521 * t209;
  t1528 = t52 * t99;
  t1529 = t48 * t1528;
  t1531 = 0.12586801333333333333e-3 * t1485 * t1529;
  t1533 = 0.91353489333333333333e-4 * t1490 * t225;
  t1534 = t575 * t542;
  t1538 = t1498 * t225;
  t1540 = t1501 * t225;
  t1545 = 0.4392793665333333333e-4 * t1506 * t225;
  t1547 = 0.31882367777333333332e-4 * t1509 * t225;
  t1548 = t581 * t604;
  t1551 = 0.11569919424066666667e-4 * t1514 * t225;
  t1552 = t584 * t604;
  t1554 = t16 * t302;
  t1555 = t1554 * t224;
  tv3rho2tau1 = -0.324588e-2 * t1526 - t1531 - t1533 - 0.324588e-2 * t1534 - 0.162294e-2 * t1493 * t225 - 0.37760403999999999998e-3 * t1538 - 0.274060468e-3 * t1540 - 0.324588e-2 * t578 * t604 - t1545 - t1547 - 0.37760403999999999998e-3 * t1548 - t1551 - 0.274060468e-3 * t1552 - 0.162294e-2 * t217 * t1555;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t1560 = t610 * t591;
  t1565 = t16 * t371;
  t1566 = t1565 * t219;
  t1569 = t581 * t611;
  t1571 = t584 * t611;
  t1573 = t344 * t13;
  t1578 = t347 * t93;
  t1579 = t1578 * t220;
  t1581 = t347 * t13;
  t1582 = t1581 * t220;
  t1586 = 0.27049e-2 * t607 * t592 + 0.27049e-2 * t217 * t1560 - 0.162294e-2 * t578 * t611 - 0.162294e-2 * t217 * t1566 - 0.18880201999999999999e-3 * t1569 - 0.137030234e-3 * t1571 - 0.162294e-2 * t1573 * t220 - 0.162294e-2 * t607 * t588 - 0.18880201999999999999e-3 * t1579 - 0.137030234e-3 * t1582 + 0.31467003333333333332e-3 * t1472 + 0.22838372333333333333e-3 * t1474 - t1489;
  t1594 = t575 * t553;
  t1596 = t340 * t16;
  t1597 = t1596 * t201;
  t1599 = -t1492 - 0.18880201999999999999e-3 * t1499 - 0.137030234e-3 * t1502 - 0.18880201999999999999e-3 * t1504 - t1508 - t1511 - 0.137030234e-3 * t1512 - t1516 + 0.27049e-2 * t1483 - 0.162294e-2 * t1522 - 0.162294e-2 * t1524 - 0.162294e-2 * t1594 - 0.162294e-2 * t1597;
  tv3rho2tau2 = t1586 + t1599;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t1600 = t1578 * t225;
  t1602 = t1581 * t225;
  t1606 = t16 * t384;
  t1607 = t1606 * t224;
  t1610 = t581 * t617;
  t1612 = t584 * t617;
  t1616 = t603 * t620;
  t1619 = t581 * t621;
  t1621 = t584 * t621;
  t1624 = -0.18880201999999999999e-3 * t1600 - 0.137030234e-3 * t1602 - 0.162294e-2 * t578 * t617 - 0.162294e-2 * t217 * t1607 - 0.18880201999999999999e-3 * t1610 - 0.137030234e-3 * t1612 + 0.27049e-2 * t578 * t621 + 0.27049e-2 * t217 * t1616 + 0.31467003333333333332e-3 * t1619 + 0.22838372333333333333e-3 * t1621 - t1545 - t1547 - 0.18880201999999999999e-3 * t1548;
  t1632 = t575 * t565;
  t1634 = t1596 * t209;
  t1638 = t575 * t563;
  t1640 = -t1551 - 0.137030234e-3 * t1552 - 0.162294e-2 * t1573 * t225 - 0.162294e-2 * t607 * t604 - t1531 - t1533 - 0.18880201999999999999e-3 * t1538 - 0.137030234e-3 * t1540 + 0.27049e-2 * t1632 - 0.162294e-2 * t1634 - 0.162294e-2 * t1526 - 0.162294e-2 * t1534 - 0.162294e-2 * t1638;
  tv3rho2tau3 = t1624 + t1640;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t1643 = t420 * t13;
  t1652 = t16 * t436;
  t1653 = t1652 * t219;
  tv3rho2tau4 = -0.324588e-2 * t1597 - t1489 - t1492 - 0.324588e-2 * t1594 - 0.162294e-2 * t1643 * t220 - 0.37760403999999999998e-3 * t1579 - 0.274060468e-3 * t1582 - 0.324588e-2 * t607 * t611 - t1508 - t1511 - 0.37760403999999999998e-3 * t1569 - t1516 - 0.274060468e-3 * t1571 - 0.162294e-2 * t217 * t1653;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t1658 = t616 * t620;
  t1661 = t30 * t455;
  t1662 = t223 * t1661;
  t1665 = t16 * t447;
  t1666 = t1665 * t224;
  tv3rho2tau5 = 0.54098e-2 * t607 * t621 + 0.54098e-2 * t217 * t1658 - 0.72130666666666666667e-2 * t217 * t1662 - 0.162294e-2 * t217 * t1666 - 0.162294e-2 * t1643 * t225 - 0.324588e-2 * t607 * t617 - 0.37760403999999999998e-3 * t1600 - 0.274060468e-3 * t1602 - 0.324588e-2 * t1638 - 0.37760403999999999998e-3 * t1610 - 0.274060468e-3 * t1612 + 0.54098e-2 * t1632 + 0.62934006666666666664e-3 * t1619 + 0.45676744666666666666e-3 * t1621 - 0.324588e-2 * t1634 - t1551 - t1531 - t1533 - t1545 - t1547;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t8, t9, t10;
  double t12, t13, t14, t16, t17, t18, t19, t20;
  double t21, t22, t23, t24, t25, t26, t27, t29;
  double t30, t31, t32, t33, t35, t37, t39, t41;
  double t42, t43, t44, t45, t47, t48, t49, t50;
  double t52, t54, t56, t59, t60, t62, t64, t65;
  double t66, t67, t69, t70, t71, t72, t75, t78;
  double tzk0;

  double t81, t82, t83, t84, t86, t87, t88, t91;
  double t92, t93, t94, t96, t97, t99, t100, t102;
  double t103, t104, t107, t108, t111, t113, t116, t118;
  double t121, t122, t125, t126, t130, t132, t135, t136;
  double t139, t140, t143, t146, t147, tvrho0, t151, t152;
  double t155, t158, t159, t162, t165, t166, t169, t171;
  double t174, t176, t179, t180, t185, t186, t189, t192;
  double t193, tvrho1, t197, t198, t199, t200, tvsigma0, tvsigma1;
  double tvsigma2, t201, t205, t206, tvlapl0, t209, t213, t214;
  double tvlapl1, t217, t218, t219, t220, tvtau0, t223, t224;
  double t225, tvtau1;

  double t228, t229, t231, t232, t234, t235, t237, t238;
  double t239, t240, t241, t243, t244, t245, t248, t249;
  double t254, t255, t257, t258, t259, t262, t263, t265;
  double t266, t268, t269, t271, t274, t275, t279, t280;
  double t287, t290, t292, t295, t298, t302, t303, t307;
  double t309, t314, t315, t316, t319, t322, t323, t324;
  double t327, t328, t331, t334, t335, tv2rho20, t340, t341;
  double t343, t344, t347, t348, t354, t358, t359, t362;
  double t364, t367, t371, t372, t377, t380, t384, t385;
  double t392, t393, t396, t397, t402, t403, t406, t407;
  double t410, t413, t414, tv2rho21, t419, t420, t428, t431;
  double t432, t436, t437, t440, t443, t447, t448, t455;
  double t458, t460, t463, t464, t467, t474, t475, t478;
  double t479, t482, t485, t486, tv2rho22, t489, t490, t491;
  double t492, t493, t495, t496, t497, t498, t499, t500;
  double tv2rhosigma0, t501, t503, t504, tv2rhosigma1, tv2rhosigma2, t505, t506;
  double tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t509, t511, t514, t516, t518;
  double t519, t521, t525, t528, t529, tv2rholapl0, t532, t534;
  double t537, t539, t541, t542, t544, t547, t548, tv2rholapl1;
  double t553, t557, t558, tv2rholapl2, t563, t565, t571, t572;
  double tv2rholapl3, t575, t577, t578, t581, t583, t584, t586;
  double t587, t588, t591, t592, tv2rhotau0, t596, t600, t602;
  double t603, t604, tv2rhotau1, t607, t610, t611, tv2rhotau2, t616;
  double t617, t620, t621, tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20, tv2lapl21;
  double tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t624, t625, t627, t628, t629, t631, t632, t633;
  double t636, t637, t639, t640, t642, t643, t645, t647;
  double t648, t650, t652, t653, t656, t659, t660, t661;
  double t665, t666, t673, t675, t678, t680, t683, t684;
  double t687, t690, t694, t695, t698, t700, t702, t712;
  double t713, t714, t717, t718, t721, t722, t726, t727;
  double t728, t731, t732, t735, t736, t739, t742, t743;
  double t746, t747, t748, t750, t751, t752, t757, t758;
  double t760, t762, t766, t767, t769, t770, t772, t773;
  double t775, t776, t778, t779, t781, t783, t785, tv3rho30;
  double t793, t794, t799, t801, t804, t811, t814, t819;
  double t822, t825, t828, t839, t840, t848, t851, t862;
  double t863, t870, t871, t874, t878, t881, t882, t885;
  double t889, t892, t893, t896, t897, t900, t901, t907;
  double t909, t910, t912, t913, t914, t916, t917, t918;
  double t919, t924, t926, t928, t929, t937, t939, t940;
  double t942, t944, t945, tv3rho31, t948, t950, t951, t955;
  double t956, t960, t961, t970, t972, t977, t982, t986;
  double t987, t992, t997, t1000, t1004, t1005, t1014, t1015;
  double t1018, t1019, t1024, t1025, t1029, t1030, t1039, t1040;
  double t1043, t1044, t1047, t1048, t1051, t1052, t1055, t1058;
  double t1059, t1064, t1065, t1067, t1069, t1071, t1078, tv3rho32;
  double t1082, t1087, t1088, t1092, t1093, t1096, t1101, t1105;
  double t1106, t1113, t1115, t1118, t1120, t1123, t1124, t1127;
  double t1130, t1131, t1142, t1143, t1146, t1149, t1150, t1153;
  double t1156, t1157, t1160, t1161, tv3rho33, t1179, t1180, t1181;
  double t1182, t1183, t1184, t1185, t1186, t1187, t1188, t1189;
  double t1190, t1192, t1193, t1195, t1196, t1198, t1199, t1200;
  double t1201, t1202, t1203, t1204, t1205, t1206, tv3rho2sigma0, t1207;
  double t1209, t1210, t1214, t1215, t1216, tv3rho2sigma1, tv3rho2sigma2, t1219;
  double t1221, t1222, t1224, t1225, t1227, tv3rho2sigma3, t1231, t1234;
  double tv3rho2sigma4, tv3rho2sigma5, t1236, t1237, tv3rho2sigma6, tv3rho2sigma7, tv3rho2sigma8, t1244;
  double t1246, t1248, t1250, t1251, t1252, t1256, t1258, t1262;
  double t1264, t1266, t1267, t1268, t1271, t1272, t1274, t1276;
  double t1278, t1282, t1285, t1290, t1291, tv3rho2lapl0, t1294, t1296;
  double t1298, t1300, t1301, t1302, t1306, t1308, t1312, t1314;
  double t1316, t1317, t1318, t1321, t1322, t1324, t1326, t1331;
  double t1332, tv3rho2lapl1, t1337, t1341, t1343, t1352, t1353, t1357;
  double t1358, t1360, t1362, t1364, t1368, t1373, t1374, t1377;
  double tv3rho2lapl2, t1380, t1384, t1386, t1395, t1396, t1400, t1401;
  double t1403, t1405, t1407, t1409, t1412, t1417, t1418, t1421;
  double tv3rho2lapl3, t1432, t1438, t1439, tv3rho2lapl4, t1452, t1454, t1456;
  double t1466, t1467, tv3rho2lapl5, t1472, t1474, t1476, t1479, t1480;
  double t1483, t1485, t1486, t1487, t1489, t1490, t1492, t1493;
  double t1498, t1499, t1501, t1502, t1504, t1506, t1508, t1509;
  double t1511, t1512, t1514, t1516, t1517, t1518, t1521, t1522;
  double t1524, tv3rho2tau0, t1526, t1528, t1529, t1531, t1533, t1534;
  double t1538, t1540, t1545, t1547, t1548, t1551, t1552, t1554;
  double t1555, tv3rho2tau1, t1560, t1565, t1566, t1569, t1571, t1573;
  double t1578, t1579, t1581, t1582, t1586, t1594, t1596, t1597;
  double t1599, tv3rho2tau2, t1600, t1602, t1606, t1607, t1610, t1612;
  double t1616, t1619, t1621, t1624, t1632, t1634, t1638, t1640;
  double tv3rho2tau3, t1643, t1652, t1653, tv3rho2tau4, t1658, t1661, t1662;
  double t1665, t1666, tv3rho2tau5, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double tv3rhosigma25, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0;
  double tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8;
  double tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4;
  double tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, tv3rholapl20;
  double tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2;
  double tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22;
  double tv3rhotau23, tv3rhotau24, tv3rhotau25, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22;
  double tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1;
  double tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9;
  double tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0;
  double tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  double t1682, t1684, t1687, t1689, t1691, t1694, t1696, t1698;
  double t1700, t1701, t1704, t1707, t1709, t1712, t1716, t1717;
  double t1718, t1721, t1724, t1726, t1728, t1732, t1735, t1736;
  double t1740, t1741, t1743, t1746, t1749, t1750, t1752, t1754;
  double t1758, t1759, t1768, t1769, t1770, t1791, t1792, t1798;
  double t1804, t1808, t1812, t1816, t1817, t1819, t1820, t1826;
  double t1835, t1845, t1847, t1848, t1856, t1863, t1865, t1866;
  double t1874, t1881, t1885, t1893, t1898, t1900, t1902, t1903;
  double t1904, t1906, t1914, t1918, t1919, tv4rho40, t1921, t1923;
  double t1925, t1927, t1929, t1931, t1937, t1940, t1942, t1944;
  double t1945, t1946, t1947, t1973, t1975, t2009, t2011, t2017;
  double t2027, t2046, t2064, t2071, t2085, t2086, t2093, t2103;
  double t2107, t2108, t2109, t2111, t2112, t2113, t2115, t2123;
  double t2128, t2129, t2131, t2132, t2135, t2136, t2138, t2139;
  double t2141, t2144, t2146, t2147, t2150, t2152, t2158, t2160;
  double t2165, t2167, t2175, t2177, t2178, t2179, t2182, t2183;
  double t2184, t2189, t2202, tv4rho41, t2210, t2211, t2214, t2216;
  double t2218, t2220, t2222, t2225, t2227, t2283, t2318, t2346;
  double t2379, t2387, t2391, t2393, t2395, t2408, t2414, t2418;
  double t2427, t2436, t2438, t2447, t2465, t2475, t2477, t2480;
  double t2482, t2484, t2486, t2488, tv4rho42, t2490, t2492, t2502;
  double t2505, t2509, t2518, t2535, t2555, t2559, t2585, t2618;
  double t2628, t2641, t2656, t2670, t2674, t2682, t2685, t2692;
  double t2701, t2703, t2711, tv4rho43, t2727, t2736, t2741, t2746;
  double t2747, t2751, t2755, t2760, t2769, t2781, t2784, t2789;
  double t2805, t2806, t2819, t2826, t2833, t2840, t2844, t2862;
  double tv4rho44, t2863, t2864, t2865, t2867, t2869, t2870, t2872;
  double t2874, t2875, t2877, t2879, t2881, t2882, t2883, t2884;
  double t2885, t2886, t2887, t2888, t2889, t2890, t2892, t2894;
  double t2895, t2896, t2897, t2898, t2900, t2902, t2903, t2905;
  double t2907, t2908, t2909, t2910, t2912, t2913, tv4rho3sigma0, t2914;
  double t2921, t2922, t2923, t2924, t2926, t2927, t2931, t2932;
  double t2933, tv4rho3sigma1, tv4rho3sigma2, t2935, t2937, t2938, t2940, t2943;
  double t2945, t2946, t2947, t2948, t2949, t2950, t2951, t2953;
  double t2955, t2958, t2959, t2963, t2964, t2966, t2968, t2969;
  double t2970, tv4rho3sigma3, t2971, t2972, t2973, t2975, t2976, t2978;
  double t2979, t2980, t2984, t2991, tv4rho3sigma4, tv4rho3sigma5, t2993, t2996;
  double t2998, t2999, t3001, t3004, t3011, tv4rho3sigma6, t3022, t3025;
  double tv4rho3sigma7, tv4rho3sigma8, t3027, tv4rho3sigma9, tv4rho3sigma10, tv4rho3sigma11, t3048, t3050;
  double t3052, t3054, t3055, t3056, t3059, t3064, t3066, t3068;
  double t3070, t3072, t3074, t3076, t3078, t3080, t3082, t3083;
  double t3085, t3087, t3089, t3100, t3103, t3108, t3116, t3123;
  double t3127, t3129, t3130, t3133, t3135, t3137, t3140, t3141;
  double t3143, t3146, t3148, tv4rho3lapl0, t3149, t3151, t3154, t3158;
  double t3160, t3162, t3163, t3165, t3167, t3169, t3170, t3172;
  double t3174, t3177, t3190, t3194, t3196, t3197, t3199, t3201;
  double t3203, t3205, t3208, t3209, t3211, t3214, t3219, t3221;
  double t3223, t3225, t3227, t3229, t3231, t3233, tv4rho3lapl1, t3235;
  double t3238, t3240, t3242, t3244, t3246, t3247, t3249, t3252;
  double t3253, t3280, t3284, t3285, t3287, t3289, t3295, t3297;
  double t3300, t3302, t3304, t3307, t3308, t3310, t3312, t3319;
  double t3320, t3333, t3342, tv4rho3lapl2, t3346, t3348, t3350, t3352;
  double t3358, t3360, t3362, t3365, t3366, t3372, t3392, t3393;
  double t3395, t3396, t3403, t3405, t3406, t3410, t3412, t3419;
  double t3421, t3423, t3424, t3426, t3428, t3431, t3437, t3449;
  double tv4rho3lapl3, t3451, t3454, t3456, t3460, t3462, t3489, t3491;
  double t3493, t3498, t3500, t3509, t3518, t3527, tv4rho3lapl4, t3529;
  double t3535, t3537, t3547, t3569, t3571, t3577, t3580, t3582;
  double t3584, t3591, t3600, t3608, t3610, tv4rho3lapl5, t3628, t3650;
  double tv4rho3lapl6, t3667, t3693, t3703, tv4rho3lapl7, t3704, t3706, t3708;
  double t3710, t3711, t3716, t3717, t3719, t3720, t3724, t3726;
  double t3732, t3734, t3735, t3737, t3739, t3741, t3743, t3745;
  double t3750, t3762, t3763, t3765, t3768, t3771, t3773, t3775;
  double t3777, t3782, t3783, t3785, t3786, t3788, t3789, t3791;
  double t3793, t3795, t3797, t3799, t3800, t3802, t3803, t3805;
  double t3806, t3807, t3809, t3811, t3812, t3815, t3817, t3821;
  double t3822, t3824, t3825, t3826, t3828, t3830, t3831, t3833;
  double t3835, t3837, t3839, t3841, tv4rho3tau0, t3846, t3848, t3850;
  double t3851, t3857, t3859, t3863, t3866, t3868, t3869, t3872;
  double t3873, t3875, t3877, t3879, t3881, t3886, t3888, t3889;
  double t3892, t3897, t3899, t3901, t3903, t3905, t3907, t3909;
  double t3911, t3913, t3915, tv4rho3tau1, t3926, t3928, t3929, t3931;
  double t3932, t3934, t3935, t3937, t3939, t3941, t3944, t3946;
  double t3947, t3949, t3954, t3956, t3957, t3959, t3963, t3965;
  double t3966, t3967, t3970, t3972, t3979, t3981, t3987, t3989;
  double t3995, t3997, t4005, t4024, t4038, t4040, t4042, t4044;
  double t4045, t4047, t4049, t4050, tv4rho3tau2, t4053, t4057, t4059;
  double t4066, t4068, t4075, t4077, t4078, t4080, t4082, t4085;
  double t4087, t4091, t4095, t4097, t4103, t4105, t4107, t4109;
  double t4112, t4114, t4115, t4117, t4119, t4126, t4128, t4129;
  double t4131, t4133, t4144, t4153, t4155, t4157, t4159, t4161;
  double t4166, t4167, tv4rho3tau3, t4173, t4175, t4181, t4183, t4185;
  double t4190, t4191, t4193, t4194, t4207, t4218, t4233, t4238;
  double t4240, t4242, t4243, t4245, tv4rho3tau4, t4251, t4253, t4259;
  double t4261, t4268, t4270, t4277, t4279, t4287, t4289, t4291;
  double t4296, t4298, t4310, t4323, t4331, t4333, t4335, t4337;
  double t4339, t4341, t4343, tv4rho3tau5, t4350, t4369, t4377, tv4rho3tau6;
  double t4407, t4421, t4434, t4441, tv4rho3tau7, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22;
  double tv4rho2sigma23, tv4rho2sigma24, tv4rho2sigma25, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210;
  double tv4rho2sigma211, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, tv4rho2sigmalapl0;
  double tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8;
  double tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16;
  double tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5, tv4rho2sigmatau6;
  double tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14;
  double tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21, tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24;
  double tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3;
  double tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11;
  double tv4rho2tau20, tv4rho2tau21, tv4rho2tau22, tv4rho2tau23, tv4rho2tau24, tv4rho2tau25, tv4rho2tau26, tv4rho2tau27;
  double tv4rho2tau28, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36;
  double tv4rhosigma37, tv4rhosigma38, tv4rhosigma39, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314;
  double tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2;
  double tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10;
  double tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18;
  double tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2;
  double tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10;
  double tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18;
  double tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22;
  double tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210;
  double tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0;
  double tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8;
  double tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16;
  double tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20;
  double tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28;
  double tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216;
  double tv4rhosigmatau217, tv4rholapl30, tv4rholapl31, tv4rholapl32, tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36;
  double tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6;
  double tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22;
  double tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210;
  double tv4rholapltau211, tv4rhotau30, tv4rhotau31, tv4rhotau32, tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36;
  double tv4rhotau37, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46;
  double tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, tv4sigma414;
  double tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7;
  double tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15;
  double tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3;
  double tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11;
  double tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19;
  double tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27;
  double tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215;
  double tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5;
  double tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13;
  double tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21;
  double tv4sigma2lapltau22, tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25;
  double tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213;
  double tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33;
  double tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311;
  double tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7;
  double tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15;
  double tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25;
  double tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213;
  double tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33;
  double tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311;
  double tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2;
  double tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22;
  double tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31;
  double tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37, tv4tau40, tv4tau41;
  double tv4tau42, tv4tau43, tv4tau44;


  t2 = rho[0] - rho[1];
  t3 = t2 * t2;
  t4 = rho[0] + rho[1];
  t5 = t4 * t4;
  t6 = 0.1e1 / t5;
  t8 = -t3 * t6 + 0.1e1;
  t9 = POW_1_3(t4);
  t10 = 0.1e1 / t9;
  t12 = 0.1e1 + 0.34899999999999999998e0 * t10;
  t13 = 0.1e1 / t12;
  t14 = t8 * t13;
  t16 = exp(-0.2533e0 * t10);
  t17 = 0.1e1 / t4;
  t18 = t2 * t17;
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = p->zeta_threshold * p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * t21;
  t25 = t19 * t19;
  t26 = POW_1_3(t19);
  t27 = t26 * t26;
  t29 = my_piecewise3(t20, t24, t27 * t25);
  t30 = M_CBRT2;
  t31 = t29 * t30;
  t32 = POW_1_3(rho[0]);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / rho[0];
  t37 = lapl[0] * t35;
  t39 = tau[0] * t35 - t37 / 0.8e1;
  t41 = 0.1e1 - t18;
  t42 = t41 <= p->zeta_threshold;
  t43 = t41 * t41;
  t44 = POW_1_3(t41);
  t45 = t44 * t44;
  t47 = my_piecewise3(t42, t24, t45 * t43);
  t48 = t47 * t30;
  t49 = POW_1_3(rho[1]);
  t50 = t49 * t49;
  t52 = 0.1e1 / t50 / rho[1];
  t54 = lapl[1] * t52;
  t56 = tau[1] * t52 - t54 / 0.8e1;
  t59 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t60 = t9 * t9;
  t62 = 0.1e1 / t60 / t5;
  t64 = t19 / 0.2e1;
  t65 = POW_1_3(t64);
  t66 = t65 * t65;
  t67 = t66 * t64;
  t69 = t41 / 0.2e1;
  t70 = POW_1_3(t69);
  t71 = t70 * t70;
  t72 = t71 * t69;
  t75 = t31 * t39 / 0.8e1 + t37 * t67 / 0.8e1 + t48 * t56 / 0.8e1 + t54 * t72 / 0.8e1 - t59 * t62 / 0.8e1;
  t78 = 0.1e1 + 0.264e0 * t16 * t75;
  tzk0 = -0.4918e-1 * t14 * t78;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t2 * t6;
  t82 = t5 * t4;
  t83 = 0.1e1 / t82;
  t84 = t3 * t83;
  t86 = -0.2e1 * t81 + 0.2e1 * t84;
  t87 = t4 * t86;
  t88 = t13 * t78;
  t91 = t10 * t8;
  t92 = t12 * t12;
  t93 = 0.1e1 / t92;
  t94 = t93 * t78;
  t96 = 0.57212733333333333332e-2 * t91 * t94;
  t97 = t4 * t8;
  t99 = 0.1e1 / t9 / t4;
  t100 = t99 * t16;
  t102 = 0.222904e-1 * t100 * t75;
  t103 = t27 * t19;
  t104 = t17 - t81;
  t107 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t104);
  t108 = t107 * t30;
  t111 = rho[0] * rho[0];
  t113 = 0.1e1 / t33 / t111;
  t116 = lapl[0] * t113;
  t118 = -0.5e1 / 0.3e1 * tau[0] * t113 + 0.5e1 / 0.24e2 * t116;
  t121 = t45 * t41;
  t122 = -t104;
  t125 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t122);
  t126 = t125 * t30;
  t130 = 0.1e1 / t60 / t82;
  t132 = t59 * t130 / 0.3e1;
  t135 = t104 / 0.2e1;
  t136 = t66 * t135;
  t139 = -t135;
  t140 = t71 * t139;
  t143 = t108 * t39 / 0.8e1 + t31 * t118 / 0.8e1 + t126 * t56 / 0.8e1 + t132 - 0.5e1 / 0.24e2 * t116 * t67 + 0.5e1 / 0.24e2 * t37 * t136 + 0.5e1 / 0.24e2 * t54 * t140;
  t146 = t102 + 0.264e0 * t16 * t143;
  t147 = t13 * t146;
  tvrho0 = tzk0 - 0.4918e-1 * t87 * t88 - t96 - 0.4918e-1 * t97 * t147;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t151 = 0.2e1 * t81 + 0.2e1 * t84;
  t152 = t4 * t151;
  t155 = -t17 - t81;
  t158 = my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t103 * t155);
  t159 = t158 * t30;
  t162 = -t155;
  t165 = my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t121 * t162);
  t166 = t165 * t30;
  t169 = rho[1] * rho[1];
  t171 = 0.1e1 / t50 / t169;
  t174 = lapl[1] * t171;
  t176 = -0.5e1 / 0.3e1 * tau[1] * t171 + 0.5e1 / 0.24e2 * t174;
  t179 = t155 / 0.2e1;
  t180 = t66 * t179;
  t185 = -t179;
  t186 = t71 * t185;
  t189 = t159 * t39 / 0.8e1 + t166 * t56 / 0.8e1 + t48 * t176 / 0.8e1 + t132 + 0.5e1 / 0.24e2 * t37 * t180 - 0.5e1 / 0.24e2 * t174 * t72 + 0.5e1 / 0.24e2 * t54 * t186;
  t192 = t102 + 0.264e0 * t16 * t189;
  t193 = t13 * t192;
  tvrho1 = tzk0 - 0.4918e-1 * t152 * t88 - t96 - 0.4918e-1 * t97 * t193;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t197 = 0.1e1 / t60 / t4;
  t198 = t197 * t8;
  t199 = t13 * t16;
  t200 = t198 * t199;
  tvsigma0 = 0.162294e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.324588e-2 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t201 = t31 * t35;
  t205 = -t201 / 0.64e2 + t35 * t67 / 0.8e1;
  t206 = t199 * t205;
  tvlapl0 = -0.1298352e-1 * t97 * t206;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t209 = t48 * t52;
  t213 = -t209 / 0.64e2 + t52 * t72 / 0.8e1;
  t214 = t199 * t213;
  tvlapl1 = -0.1298352e-1 * t97 * t214;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t217 = t97 * t13;
  t218 = t16 * t29;
  t219 = t30 * t35;
  t220 = t218 * t219;
  tvtau0 = -0.162294e-2 * t217 * t220;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t223 = t16 * t47;
  t224 = t30 * t52;
  t225 = t223 * t224;
  tvtau1 = -0.162294e-2 * t217 * t225;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t228 = t86 * t13;
  t229 = t228 * t78;
  t231 = t8 * t93;
  t232 = t78 * t99;
  t234 = 0.38141822222222222221e-2 * t231 * t232;
  t235 = t14 * t146;
  t237 = 0.2e1 * t6;
  t238 = t2 * t83;
  t239 = 0.8e1 * t238;
  t240 = t5 * t5;
  t241 = 0.1e1 / t240;
  t243 = 0.6e1 * t3 * t241;
  t244 = -t237 + t239 - t243;
  t245 = t4 * t244;
  t248 = t10 * t86;
  t249 = t248 * t94;
  t254 = 0.1e1 / t92 / t12;
  t255 = t254 * t78;
  t257 = 0.13311495955555555555e-2 * t198 * t255;
  t258 = t93 * t146;
  t259 = t91 * t258;
  t262 = 0.1e1 / t9 / t5;
  t263 = t262 * t16;
  t265 = 0.29720533333333333333e-1 * t263 * t75;
  t266 = t62 * t16;
  t268 = 0.18820527733333333333e-2 * t266 * t75;
  t269 = t100 * t143;
  t271 = t104 * t104;
  t274 = -t6 + t238;
  t275 = 0.2e1 * t274;
  t279 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t27 * t271 + 0.8e1 / 0.3e1 * t103 * t275);
  t280 = t279 * t30;
  t287 = 0.1e1 / t33 / t111 / rho[0];
  t290 = lapl[0] * t287;
  t292 = 0.4e2 / 0.9e1 * tau[0] * t287 - 0.5e1 / 0.9e1 * t290;
  t295 = t122 * t122;
  t298 = -t275;
  t302 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t45 * t295 + 0.8e1 / 0.3e1 * t121 * t298);
  t303 = t302 * t30;
  t307 = 0.1e1 / t60 / t240;
  t309 = 0.11e2 / 0.9e1 * t59 * t307;
  t314 = 0.1e1 / t65;
  t315 = t135 * t135;
  t316 = t314 * t315;
  t319 = t66 * t274;
  t322 = 0.1e1 / t70;
  t323 = t139 * t139;
  t324 = t322 * t323;
  t327 = -t274;
  t328 = t71 * t327;
  t331 = t280 * t39 / 0.8e1 + t108 * t118 / 0.4e1 + t31 * t292 / 0.8e1 + t303 * t56 / 0.8e1 - t309 + 0.5e1 / 0.9e1 * t290 * t67 - 0.25e2 / 0.36e2 * t116 * t136 + 0.5e1 / 0.36e2 * t37 * t316 + 0.5e1 / 0.24e2 * t37 * t319 + 0.5e1 / 0.36e2 * t54 * t324 + 0.5e1 / 0.24e2 * t54 * t328;
  t334 = -t265 + t268 + 0.445808e-1 * t269 + 0.264e0 * t16 * t331;
  t335 = t13 * t334;
  tv2rho20 = -0.9836e-1 * t229 - t234 - 0.9836e-1 * t235 - 0.4918e-1 * t245 * t88 - 0.11442546666666666666e-1 * t249 - 0.9836e-1 * t87 * t147 - t257 - 0.11442546666666666666e-1 * t259 - 0.4918e-1 * t97 * t335;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t340 = t151 * t13;
  t341 = t340 * t78;
  t343 = t237 - t243;
  t344 = t4 * t343;
  t347 = t10 * t151;
  t348 = t347 * t94;
  t354 = t14 * t192;
  t358 = t93 * t192;
  t359 = t91 * t358;
  t362 = t100 * t189;
  t364 = t27 * t155;
  t367 = t103 * t2;
  t371 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t364 * t104 + 0.16e2 / 0.3e1 * t367 * t83);
  t372 = t371 * t30;
  t377 = t45 * t162;
  t380 = t121 * t2;
  t384 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t377 * t122 - 0.16e2 / 0.3e1 * t380 * t83);
  t385 = t384 * t30;
  t392 = t314 * t179;
  t393 = t392 * t135;
  t396 = t66 * t2;
  t397 = t396 * t83;
  t402 = t322 * t185;
  t403 = t402 * t139;
  t406 = t71 * t2;
  t407 = t406 * t83;
  t410 = t372 * t39 / 0.8e1 + t159 * t118 / 0.8e1 + t385 * t56 / 0.8e1 + t126 * t176 / 0.8e1 - t309 - 0.25e2 / 0.72e2 * t116 * t180 + 0.5e1 / 0.36e2 * t37 * t393 + 0.5e1 / 0.24e2 * t37 * t397 - 0.25e2 / 0.72e2 * t174 * t140 + 0.5e1 / 0.36e2 * t54 * t403 - 0.5e1 / 0.24e2 * t54 * t407;
  t413 = -t265 + t268 + 0.222904e-1 * t269 + 0.222904e-1 * t362 + 0.264e0 * t16 * t410;
  t414 = t13 * t413;
  tv2rho21 = -0.4918e-1 * t229 - t234 - 0.4918e-1 * t235 - 0.4918e-1 * t341 - 0.4918e-1 * t344 * t88 - 0.57212733333333333332e-2 * t348 - 0.4918e-1 * t152 * t147 - 0.57212733333333333332e-2 * t249 - t257 - 0.57212733333333333332e-2 * t259 - 0.4918e-1 * t354 - 0.4918e-1 * t87 * t193 - 0.57212733333333333332e-2 * t359 - 0.4918e-1 * t97 * t414;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t419 = -t237 - t239 - t243;
  t420 = t4 * t419;
  t428 = t155 * t155;
  t431 = t6 + t238;
  t432 = 0.2e1 * t431;
  t436 = my_piecewise3(t20, 0, 0.4e2 / 0.9e1 * t27 * t428 + 0.8e1 / 0.3e1 * t103 * t432);
  t437 = t436 * t30;
  t440 = t162 * t162;
  t443 = -t432;
  t447 = my_piecewise3(t42, 0, 0.4e2 / 0.9e1 * t45 * t440 + 0.8e1 / 0.3e1 * t121 * t443);
  t448 = t447 * t30;
  t455 = 0.1e1 / t50 / t169 / rho[1];
  t458 = lapl[1] * t455;
  t460 = 0.4e2 / 0.9e1 * tau[1] * t455 - 0.5e1 / 0.9e1 * t458;
  t463 = t179 * t179;
  t464 = t314 * t463;
  t467 = t66 * t431;
  t474 = t185 * t185;
  t475 = t322 * t474;
  t478 = -t431;
  t479 = t71 * t478;
  t482 = t437 * t39 / 0.8e1 + t448 * t56 / 0.8e1 + t166 * t176 / 0.4e1 + t48 * t460 / 0.8e1 - t309 + 0.5e1 / 0.36e2 * t37 * t464 + 0.5e1 / 0.24e2 * t37 * t467 + 0.5e1 / 0.9e1 * t458 * t72 - 0.25e2 / 0.36e2 * t174 * t186 + 0.5e1 / 0.36e2 * t54 * t475 + 0.5e1 / 0.24e2 * t54 * t479;
  t485 = -t265 + t268 + 0.445808e-1 * t362 + 0.264e0 * t16 * t482;
  t486 = t13 * t485;
  tv2rho22 = -0.9836e-1 * t341 - t234 - 0.9836e-1 * t354 - 0.4918e-1 * t420 * t88 - 0.11442546666666666666e-1 * t348 - 0.9836e-1 * t152 * t193 - t257 - 0.11442546666666666666e-1 * t359 - 0.4918e-1 * t97 * t486;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t489 = t62 * t8;
  t490 = t489 * t199;
  t491 = 0.27049e-2 * t490;
  t492 = t197 * t86;
  t493 = t492 * t199;
  t495 = t83 * t8;
  t496 = t93 * t16;
  t497 = t495 * t496;
  t498 = 0.18880201999999999999e-3 * t497;
  t499 = t495 * t199;
  t500 = 0.137030234e-3 * t499;
  tv2rhosigma0 = -t491 + 0.162294e-2 * t493 + t498 + t500;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t501 = 0.54098e-2 * t490;
  t503 = 0.37760403999999999999e-3 * t497;
  t504 = 0.274060468e-3 * t499;
  tv2rhosigma1 = -t501 + 0.324588e-2 * t493 + t503 + t504;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t505 = t197 * t151;
  t506 = t505 * t199;
  tv2rhosigma3 = -t491 + 0.162294e-2 * t506 + t498 + t500;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t501 + 0.324588e-2 * t506 + t503 + t504;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t509 = t16 * t205;
  t511 = 0.1298352e-1 * t14 * t509;
  t514 = t496 * t205;
  t516 = 0.151041616e-2 * t91 * t514;
  t518 = 0.1096241872e-2 * t91 * t206;
  t519 = t108 * t35;
  t521 = t31 * t113;
  t525 = t35 * t66;
  t528 = -t519 / 0.64e2 + 0.5e1 / 0.192e3 * t521 - 0.5e1 / 0.24e2 * t113 * t67 + 0.5e1 / 0.24e2 * t525 * t135;
  t529 = t199 * t528;
  tv2rholapl0 = -t511 - 0.1298352e-1 * t87 * t206 - t516 - t518 - 0.1298352e-1 * t97 * t529;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t532 = t16 * t213;
  t534 = 0.1298352e-1 * t14 * t532;
  t537 = t496 * t213;
  t539 = 0.151041616e-2 * t91 * t537;
  t541 = 0.1096241872e-2 * t91 * t214;
  t542 = t126 * t52;
  t544 = t52 * t71;
  t547 = -t542 / 0.64e2 + 0.5e1 / 0.24e2 * t544 * t139;
  t548 = t199 * t547;
  tv2rholapl1 = -t534 - 0.1298352e-1 * t87 * t214 - t539 - t541 - 0.1298352e-1 * t97 * t548;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t553 = t159 * t35;
  t557 = -t553 / 0.64e2 + 0.5e1 / 0.24e2 * t525 * t179;
  t558 = t199 * t557;
  tv2rholapl2 = -t511 - 0.1298352e-1 * t152 * t206 - t516 - t518 - 0.1298352e-1 * t97 * t558;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t563 = t166 * t52;
  t565 = t48 * t171;
  t571 = -t563 / 0.64e2 + 0.5e1 / 0.192e3 * t565 - 0.5e1 / 0.24e2 * t171 * t72 + 0.5e1 / 0.24e2 * t544 * t185;
  t572 = t199 * t571;
  tv2rholapl3 = -t534 - 0.1298352e-1 * t152 * t214 - t539 - t541 - 0.1298352e-1 * t97 * t572;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t575 = t14 * t16;
  t577 = 0.162294e-2 * t575 * t201;
  t578 = t87 * t13;
  t581 = t91 * t93;
  t583 = 0.18880201999999999999e-3 * t581 * t220;
  t584 = t91 * t13;
  t586 = 0.137030234e-3 * t584 * t220;
  t587 = t16 * t107;
  t588 = t587 * t219;
  t591 = t30 * t113;
  t592 = t218 * t591;
  tv2rhotau0 = -t577 - 0.162294e-2 * t578 * t220 - t583 - t586 - 0.162294e-2 * t217 * t588 + 0.27049e-2 * t217 * t592;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t596 = 0.162294e-2 * t575 * t209;
  t600 = 0.18880201999999999999e-3 * t581 * t225;
  t602 = 0.137030234e-3 * t584 * t225;
  t603 = t16 * t125;
  t604 = t603 * t224;
  tv2rhotau1 = -t596 - 0.162294e-2 * t578 * t225 - t600 - t602 - 0.162294e-2 * t217 * t604;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t607 = t152 * t13;
  t610 = t16 * t158;
  t611 = t610 * t219;
  tv2rhotau2 = -t577 - 0.162294e-2 * t607 * t220 - t583 - t586 - 0.162294e-2 * t217 * t611;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t616 = t16 * t165;
  t617 = t616 * t224;
  t620 = t30 * t171;
  t621 = t223 * t620;
  tv2rhotau3 = -t596 - 0.162294e-2 * t607 * t225 - t600 - t602 - 0.162294e-2 * t217 * t617 + 0.27049e-2 * t217 * t621;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t624 = t254 * t146;
  t625 = t198 * t624;
  t627 = t92 * t92;
  t628 = 0.1e1 / t627;
  t629 = t628 * t78;
  t631 = 0.46457120884888888886e-3 * t495 * t629;
  t632 = t93 * t334;
  t633 = t91 * t632;
  t636 = 0.1e1 / t9 / t82;
  t637 = t636 * t16;
  t639 = 0.6934791111111111111e-1 * t637 * t75;
  t640 = t130 * t16;
  t642 = 0.75282110933333333332e-2 * t640 * t75;
  t643 = t263 * t143;
  t645 = t241 * t16;
  t647 = 0.15890798916177777777e-3 * t645 * t75;
  t648 = t266 * t143;
  t650 = t100 * t331;
  t652 = 0.1e1 / t26;
  t653 = t271 * t104;
  t656 = t27 * t104;
  t659 = t2 * t241;
  t660 = t83 - t659;
  t661 = 0.6e1 * t660;
  t665 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t652 * t653 + 0.4e2 / 0.3e1 * t656 * t275 + 0.8e1 / 0.3e1 * t103 * t661);
  t666 = t665 * t30;
  t673 = t111 * t111;
  t675 = 0.1e1 / t33 / t673;
  t678 = lapl[0] * t675;
  t680 = -0.44e3 / 0.27e2 * tau[0] * t675 + 0.55e2 / 0.27e2 * t678;
  t683 = 0.1e1 / t44;
  t684 = t295 * t122;
  t687 = t45 * t122;
  t690 = -t661;
  t694 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t683 * t684 + 0.4e2 / 0.3e1 * t687 * t298 + 0.8e1 / 0.3e1 * t121 * t690);
  t695 = t694 * t30;
  t698 = t240 * t4;
  t700 = 0.1e1 / t60 / t698;
  t702 = 0.154e3 / 0.27e2 * t59 * t700;
  t712 = 0.1e1 / t65 / t64;
  t713 = t315 * t135;
  t714 = t712 * t713;
  t717 = t314 * t135;
  t718 = t717 * t274;
  t721 = 0.3e1 * t660;
  t722 = t66 * t721;
  t726 = 0.1e1 / t70 / t69;
  t727 = t323 * t139;
  t728 = t726 * t727;
  t731 = t322 * t139;
  t732 = t731 * t327;
  t735 = -t721;
  t736 = t71 * t735;
  t739 = t666 * t39 / 0.8e1 + 0.3e1 / 0.8e1 * t280 * t118 + 0.3e1 / 0.8e1 * t108 * t292 + t31 * t680 / 0.8e1 + t695 * t56 / 0.8e1 + t702 - 0.55e2 / 0.27e2 * t678 * t67 + 0.25e2 / 0.9e1 * t290 * t136 - 0.25e2 / 0.36e2 * t116 * t316 - 0.25e2 / 0.24e2 * t116 * t319 - 0.5e1 / 0.108e3 * t37 * t714 + 0.5e1 / 0.12e2 * t37 * t718 + 0.5e1 / 0.24e2 * t37 * t722 - 0.5e1 / 0.108e3 * t54 * t728 + 0.5e1 / 0.12e2 * t54 * t732 + 0.5e1 / 0.24e2 * t54 * t736;
  t742 = t639 - t642 - 0.891616e-1 * t643 + t647 + 0.564615832e-2 * t648 + 0.668712e-1 * t650 + 0.264e0 * t16 * t739;
  t743 = t13 * t742;
  t746 = 0.12e2 * t83;
  t747 = 0.36e2 * t659;
  t748 = 0.1e1 / t698;
  t750 = 0.24e2 * t3 * t748;
  t751 = t746 - t747 + t750;
  t752 = t4 * t751;
  t757 = t10 * t244;
  t758 = t757 * t94;
  t760 = t248 * t258;
  t762 = t492 * t255;
  t766 = t86 * t93;
  t767 = t766 * t232;
  t769 = t146 * t99;
  t770 = t231 * t769;
  t772 = t8 * t254;
  t773 = t78 * t62;
  t775 = 0.13311495955555555556e-2 * t772 * t773;
  t776 = t14 * t334;
  t778 = t244 * t13;
  t779 = t778 * t78;
  t781 = t228 * t146;
  t783 = t78 * t262;
  t785 = 0.50855762962962962961e-2 * t231 * t783;
  tv3rho30 = -0.39934487866666666664e-2 * t625 - t631 - 0.17163819999999999999e-1 * t633 - 0.4918e-1 * t97 * t743 - 0.4918e-1 * t752 * t88 - 0.14754e0 * t245 * t147 - 0.17163819999999999999e-1 * t758 - 0.34327639999999999998e-1 * t760 - 0.39934487866666666664e-2 * t762 - 0.14754e0 * t87 * t335 - 0.11442546666666666666e-1 * t767 - 0.11442546666666666666e-1 * t770 + t775 - 0.14754e0 * t776 - 0.14754e0 * t779 - 0.29508e0 * t781 + t785;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t793 = t254 * t192;
  t794 = t198 * t793;
  t799 = t263 * t189;
  t801 = t266 * t189;
  t804 = 0.445808e-1 * t100 * t410;
  t811 = t392 * t274;
  t814 = t66 * t83;
  t819 = t402 * t327;
  t822 = t71 * t83;
  t825 = t652 * t155;
  t828 = t27 * t2;
  t839 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t825 * t271 + 0.16e3 / 0.9e1 * t828 * t83 * t104 + 0.4e2 / 0.9e1 * t364 * t275 + 0.16e2 / 0.3e1 * t103 * t83 - 0.16e2 * t367 * t241);
  t840 = t839 * t30;
  t848 = t683 * t162;
  t851 = t45 * t2;
  t862 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t848 * t295 - 0.16e3 / 0.9e1 * t851 * t83 * t122 + 0.4e2 / 0.9e1 * t377 * t298 - 0.16e2 / 0.3e1 * t121 * t83 + 0.16e2 * t380 * t241);
  t863 = t862 * t30;
  t870 = t54 * t322;
  t871 = t238 * t139;
  t874 = t406 * t241;
  t878 = t712 * t179 * t315;
  t881 = t37 * t314;
  t882 = t238 * t135;
  t885 = t396 * t241;
  t889 = t726 * t185 * t323;
  t892 = t159 * t292 / 0.8e1 + t863 * t56 / 0.8e1 + t303 * t176 / 0.8e1 - 0.25e2 / 0.72e2 * t174 * t328 + t702 - 0.5e1 / 0.18e2 * t870 * t871 + 0.5e1 / 0.8e1 * t54 * t874 - 0.5e1 / 0.108e3 * t37 * t878 + 0.5e1 / 0.18e2 * t881 * t882 - 0.5e1 / 0.8e1 * t37 * t885 - 0.5e1 / 0.108e3 * t54 * t889;
  t893 = 0.25e2 / 0.27e2 * t290 * t180 - 0.25e2 / 0.54e2 * t116 * t393 - 0.25e2 / 0.36e2 * t116 * t397 + 0.5e1 / 0.36e2 * t37 * t811 + 0.5e1 / 0.24e2 * t37 * t814 - 0.25e2 / 0.108e3 * t174 * t324 + 0.5e1 / 0.36e2 * t54 * t819 - 0.5e1 / 0.24e2 * t54 * t822 + t840 * t39 / 0.8e1 + t372 * t118 / 0.4e1 + t892;
  t896 = t639 - t642 - 0.59441066666666666666e-1 * t643 + t647 + 0.37641055466666666666e-2 * t648 + 0.222904e-1 * t650 - 0.29720533333333333333e-1 * t799 + 0.18820527733333333333e-2 * t801 + t804 + 0.264e0 * t16 * t893;
  t897 = t13 * t896;
  t900 = t192 * t99;
  t901 = t231 * t900;
  t907 = -0.57212733333333333332e-2 * t758 - 0.11442546666666666666e-1 * t760 - 0.2662299191111111111e-2 * t762 - 0.2662299191111111111e-2 * t625 - t631 - 0.57212733333333333332e-2 * t633 - 0.76283644444444444442e-2 * t767 - 0.76283644444444444442e-2 * t770 + t775 + t785 - 0.13311495955555555555e-2 * t794 - 0.4918e-1 * t97 * t897 - 0.38141822222222222221e-2 * t901 - 0.4918e-1 * t245 * t193 - 0.9836e-1 * t87 * t414;
  t909 = 0.11442546666666666666e-1 * t248 * t358;
  t910 = t93 * t413;
  t912 = 0.11442546666666666666e-1 * t91 * t910;
  t913 = t151 * t93;
  t914 = t913 * t232;
  t916 = 0.4e1 * t83;
  t917 = 0.12e2 * t659;
  t918 = -t916 - t917 + t750;
  t919 = t4 * t918;
  t924 = t10 * t343;
  t926 = 0.11442546666666666666e-1 * t924 * t94;
  t928 = 0.11442546666666666666e-1 * t347 * t258;
  t929 = t505 * t255;
  t937 = 0.9836e-1 * t228 * t192;
  t939 = 0.9836e-1 * t14 * t413;
  t940 = t343 * t13;
  t942 = 0.9836e-1 * t940 * t78;
  t944 = 0.9836e-1 * t340 * t146;
  t945 = -t909 - t912 - 0.38141822222222222221e-2 * t914 - 0.4918e-1 * t919 * t88 - 0.9836e-1 * t344 * t147 - t926 - t928 - 0.13311495955555555555e-2 * t929 - 0.4918e-1 * t152 * t335 - 0.4918e-1 * t776 - 0.4918e-1 * t779 - 0.9836e-1 * t781 - t937 - t939 - t942 - t944;
  tv3rho31 = t907 + t945;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t948 = t340 * t192;
  t950 = t419 * t13;
  t951 = t950 * t78;
  t955 = t10 * t419;
  t956 = t955 * t94;
  t960 = -t916 + t917 + t750;
  t961 = t4 * t960;
  t970 = t100 * t482;
  t972 = t652 * t428;
  t977 = t27 * t432;
  t982 = -0.2e1 * t83 - 0.6e1 * t659;
  t986 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t972 * t104 + 0.16e3 / 0.9e1 * t364 * t238 + 0.4e2 / 0.9e1 * t977 * t104 + 0.8e1 / 0.3e1 * t103 * t982);
  t987 = t986 * t30;
  t992 = t683 * t440;
  t997 = t45 * t443;
  t1000 = -t982;
  t1004 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t992 * t122 - 0.16e3 / 0.9e1 * t377 * t238 + 0.4e2 / 0.9e1 * t997 * t122 + 0.8e1 / 0.3e1 * t121 * t1000);
  t1005 = t1004 * t30;
  t1014 = t712 * t463;
  t1015 = t1014 * t135;
  t1018 = t179 * t2;
  t1019 = t1018 * t83;
  t1024 = t314 * t431;
  t1025 = t1024 * t135;
  t1029 = -t83 - 0.3e1 * t659;
  t1030 = t66 * t1029;
  t1039 = t726 * t474;
  t1040 = t1039 * t139;
  t1043 = t185 * t2;
  t1044 = t1043 * t83;
  t1047 = t322 * t478;
  t1048 = t1047 * t139;
  t1051 = -t1029;
  t1052 = t71 * t1051;
  t1055 = t987 * t39 / 0.8e1 + t437 * t118 / 0.8e1 + t1005 * t56 / 0.8e1 + t385 * t176 / 0.4e1 + t126 * t460 / 0.8e1 + t702 - 0.25e2 / 0.108e3 * t116 * t464 - 0.5e1 / 0.108e3 * t37 * t1015 + 0.5e1 / 0.18e2 * t881 * t1019 - 0.25e2 / 0.72e2 * t116 * t467 + 0.5e1 / 0.36e2 * t37 * t1025 + 0.5e1 / 0.24e2 * t37 * t1030 + 0.25e2 / 0.27e2 * t458 * t140 - 0.25e2 / 0.54e2 * t174 * t403 + 0.25e2 / 0.36e2 * t174 * t407 - 0.5e1 / 0.108e3 * t54 * t1040 - 0.5e1 / 0.18e2 * t870 * t1044 + 0.5e1 / 0.36e2 * t54 * t1048 + 0.5e1 / 0.24e2 * t54 * t1052;
  t1058 = t639 - t642 - 0.29720533333333333333e-1 * t643 + t647 + 0.18820527733333333333e-2 * t648 - 0.59441066666666666667e-1 * t799 + 0.37641055466666666667e-2 * t801 + t804 + 0.222904e-1 * t970 + 0.264e0 * t16 * t1055;
  t1059 = t13 * t1058;
  t1064 = t93 * t485;
  t1065 = t91 * t1064;
  t1067 = t347 * t358;
  t1069 = t14 * t485;
  t1071 = -0.13311495955555555555e-2 * t762 - 0.13311495955555555555e-2 * t625 - t631 - 0.9836e-1 * t948 - 0.4918e-1 * t951 - 0.9836e-1 * t152 * t414 - 0.57212733333333333332e-2 * t956 - 0.9836e-1 * t344 * t193 - 0.4918e-1 * t961 * t88 - 0.4918e-1 * t420 * t147 - 0.4918e-1 * t97 * t1059 - 0.4918e-1 * t87 * t486 - 0.57212733333333333332e-2 * t1065 - 0.11442546666666666666e-1 * t1067 - 0.4918e-1 * t1069;
  t1078 = -0.38141822222222222221e-2 * t767 - 0.38141822222222222221e-2 * t770 + t775 + t785 - 0.26622991911111111109e-2 * t794 - 0.7628364444444444444e-2 * t901 - t909 - t912 - 0.7628364444444444444e-2 * t914 - t926 - t928 - 0.26622991911111111109e-2 * t929 - t937 - t939 - t942 - t944;
  tv3rho32 = t1071 + t1078;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1082 = t428 * t155;
  t1087 = -t83 - t659;
  t1088 = 0.6e1 * t1087;
  t1092 = my_piecewise3(t20, 0, 0.8e2 / 0.27e2 * t652 * t1082 + 0.4e2 / 0.3e1 * t364 * t432 + 0.8e1 / 0.3e1 * t103 * t1088);
  t1093 = t1092 * t30;
  t1096 = t440 * t162;
  t1101 = -t1088;
  t1105 = my_piecewise3(t42, 0, 0.8e2 / 0.27e2 * t683 * t1096 + 0.4e2 / 0.3e1 * t377 * t443 + 0.8e1 / 0.3e1 * t121 * t1101);
  t1106 = t1105 * t30;
  t1113 = t169 * t169;
  t1115 = 0.1e1 / t50 / t1113;
  t1118 = lapl[1] * t1115;
  t1120 = -0.44e3 / 0.27e2 * tau[1] * t1115 + 0.55e2 / 0.27e2 * t1118;
  t1123 = t463 * t179;
  t1124 = t712 * t1123;
  t1127 = t392 * t431;
  t1130 = 0.3e1 * t1087;
  t1131 = t66 * t1130;
  t1142 = t474 * t185;
  t1143 = t726 * t1142;
  t1146 = t402 * t478;
  t1149 = -t1130;
  t1150 = t71 * t1149;
  t1153 = t1093 * t39 / 0.8e1 + t1106 * t56 / 0.8e1 + 0.3e1 / 0.8e1 * t448 * t176 + 0.3e1 / 0.8e1 * t166 * t460 + t48 * t1120 / 0.8e1 + t702 - 0.5e1 / 0.108e3 * t37 * t1124 + 0.5e1 / 0.12e2 * t37 * t1127 + 0.5e1 / 0.24e2 * t37 * t1131 - 0.55e2 / 0.27e2 * t1118 * t72 + 0.25e2 / 0.9e1 * t458 * t186 - 0.25e2 / 0.36e2 * t174 * t475 - 0.25e2 / 0.24e2 * t174 * t479 - 0.5e1 / 0.108e3 * t54 * t1143 + 0.5e1 / 0.12e2 * t54 * t1146 + 0.5e1 / 0.24e2 * t54 * t1150;
  t1156 = t639 - t642 - 0.891616e-1 * t799 + t647 + 0.564615832e-2 * t801 + 0.668712e-1 * t970 + 0.264e0 * t16 * t1153;
  t1157 = t13 * t1156;
  t1160 = t746 + t747 + t750;
  t1161 = t4 * t1160;
  tv3rho33 = -0.4918e-1 * t97 * t1157 - 0.4918e-1 * t1161 * t88 - 0.14754e0 * t420 * t193 - 0.14754e0 * t152 * t486 - 0.17163819999999999999e-1 * t1065 - 0.34327639999999999998e-1 * t1067 - 0.14754e0 * t1069 - 0.14754e0 * t951 - 0.17163819999999999999e-1 * t956 - 0.29508e0 * t948 - 0.39934487866666666664e-2 * t794 - 0.11442546666666666666e-1 * t901 - 0.11442546666666666666e-1 * t914 - 0.39934487866666666664e-2 * t929 - t631 + t775 + t785;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1179 = t130 * t8 * t199;
  t1180 = 0.72130666666666666667e-2 * t1179;
  t1181 = t62 * t86;
  t1182 = t1181 * t199;
  t1183 = 0.54098e-2 * t1182;
  t1184 = t241 * t8;
  t1185 = t1184 * t496;
  t1186 = 0.88107609333333333329e-3 * t1185;
  t1187 = t1184 * t199;
  t1188 = 0.63947442533333333333e-3 * t1187;
  t1189 = t197 * t244;
  t1190 = t1189 * t199;
  t1192 = t83 * t86;
  t1193 = t1192 * t496;
  t1195 = t1192 * t199;
  t1196 = 0.274060468e-3 * t1195;
  t1198 = 0.1e1 / t9 / t240;
  t1199 = t1198 * t8;
  t1200 = t254 * t16;
  t1201 = t1199 * t1200;
  t1202 = 0.4392793665333333333e-4 * t1201;
  t1203 = t1199 * t496;
  t1204 = 0.31882367777333333332e-4 * t1203;
  t1205 = t1199 * t199;
  t1206 = 0.11569919424066666667e-4 * t1205;
  tv3rho2sigma0 = t1180 - t1183 - t1186 - t1188 + 0.162294e-2 * t1190 + 0.37760403999999999998e-3 * t1193 + t1196 + t1202 + t1204 + t1206;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t1207 = 0.14426133333333333333e-1 * t1179;
  t1209 = 0.17621521866666666666e-2 * t1185;
  t1210 = 0.12789488506666666667e-2 * t1187;
  t1214 = 0.87855873306666666662e-4 * t1201;
  t1215 = 0.63764735554666666664e-4 * t1203;
  t1216 = 0.23139838848133333333e-4 * t1205;
  tv3rho2sigma1 = t1207 - 0.108196e-1 * t1182 - t1209 - t1210 + 0.324588e-2 * t1190 + 0.75520807999999999998e-3 * t1193 + 0.548120936e-3 * t1195 + t1214 + t1215 + t1216;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1219 = t62 * t151 * t199;
  t1221 = t197 * t343;
  t1222 = t1221 * t199;
  t1224 = t83 * t151;
  t1225 = t1224 * t496;
  t1227 = t1224 * t199;
  tv3rho2sigma3 = t1180 - 0.27049e-2 * t1182 - t1186 - t1188 - 0.27049e-2 * t1219 + 0.162294e-2 * t1222 + 0.18880201999999999999e-3 * t1225 + 0.137030234e-3 * t1227 + 0.18880201999999999999e-3 * t1193 + t1202 + t1204 + 0.137030234e-3 * t1195 + t1206;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t1231 = 0.54098e-2 * t1219;
  t1234 = 0.274060468e-3 * t1227;
  tv3rho2sigma4 = t1207 - t1183 - t1209 - t1210 - t1231 + 0.324588e-2 * t1222 + 0.37760403999999999999e-3 * t1225 + t1234 + 0.37760403999999999999e-3 * t1193 + t1214 + t1215 + t1196 + t1216;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1236 = t197 * t419;
  t1237 = t1236 * t199;
  tv3rho2sigma6 = t1180 - t1231 - t1186 - t1188 + 0.162294e-2 * t1237 + 0.37760403999999999998e-3 * t1225 + t1234 + t1202 + t1204 + t1206;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = t1207 - 0.108196e-1 * t1219 - t1209 - t1210 + 0.324588e-2 * t1237 + 0.75520807999999999998e-3 * t1225 + 0.548120936e-3 * t1227 + t1214 + t1215 + t1216;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1244 = t228 * t509;
  t1246 = t509 * t99;
  t1248 = 0.10069441066666666667e-2 * t231 * t1246;
  t1250 = 0.73082791466666666667e-3 * t14 * t1246;
  t1251 = t16 * t528;
  t1252 = t14 * t1251;
  t1256 = t248 * t514;
  t1258 = t248 * t206;
  t1262 = t1200 * t205;
  t1264 = 0.35142349322666666666e-3 * t198 * t1262;
  t1266 = 0.25505894221866666666e-3 * t198 * t514;
  t1267 = t496 * t528;
  t1268 = t91 * t1267;
  t1271 = 0.92559355392533333333e-4 * t198 * t206;
  t1272 = t91 * t529;
  t1274 = t280 * t35;
  t1276 = t108 * t113;
  t1278 = t31 * t287;
  t1282 = t113 * t66;
  t1285 = t35 * t314;
  t1290 = -t1274 / 0.64e2 + 0.5e1 / 0.96e2 * t1276 - 0.5e1 / 0.72e2 * t1278 + 0.5e1 / 0.9e1 * t287 * t67 - 0.25e2 / 0.36e2 * t1282 * t135 + 0.5e1 / 0.36e2 * t1285 * t315 + 0.5e1 / 0.24e2 * t525 * t274;
  t1291 = t199 * t1290;
  tv3rho2lapl0 = -0.2596704e-1 * t1244 - t1248 - t1250 - 0.2596704e-1 * t1252 - 0.1298352e-1 * t245 * t206 - 0.302083232e-2 * t1256 - 0.2192483744e-2 * t1258 - 0.2596704e-1 * t87 * t529 - t1264 - t1266 - 0.302083232e-2 * t1268 - t1271 - 0.2192483744e-2 * t1272 - 0.1298352e-1 * t97 * t1291;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1294 = t228 * t532;
  t1296 = t532 * t99;
  t1298 = 0.10069441066666666667e-2 * t231 * t1296;
  t1300 = 0.73082791466666666667e-3 * t14 * t1296;
  t1301 = t16 * t547;
  t1302 = t14 * t1301;
  t1306 = t248 * t537;
  t1308 = t248 * t214;
  t1312 = t1200 * t213;
  t1314 = 0.35142349322666666666e-3 * t198 * t1312;
  t1316 = 0.25505894221866666666e-3 * t198 * t537;
  t1317 = t496 * t547;
  t1318 = t91 * t1317;
  t1321 = 0.92559355392533333333e-4 * t198 * t214;
  t1322 = t91 * t548;
  t1324 = t303 * t52;
  t1326 = t52 * t322;
  t1331 = -t1324 / 0.64e2 + 0.5e1 / 0.36e2 * t1326 * t323 + 0.5e1 / 0.24e2 * t544 * t327;
  t1332 = t199 * t1331;
  tv3rho2lapl1 = -0.2596704e-1 * t1294 - t1298 - t1300 - 0.2596704e-1 * t1302 - 0.1298352e-1 * t245 * t214 - 0.302083232e-2 * t1306 - 0.2192483744e-2 * t1308 - 0.2596704e-1 * t87 * t548 - t1314 - t1316 - 0.302083232e-2 * t1318 - t1321 - 0.2192483744e-2 * t1322 - 0.1298352e-1 * t97 * t1332;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1337 = t340 * t509;
  t1341 = t347 * t514;
  t1343 = t347 * t206;
  t1352 = t16 * t557;
  t1353 = t14 * t1352;
  t1357 = t496 * t557;
  t1358 = t91 * t1357;
  t1360 = t91 * t558;
  t1362 = t372 * t35;
  t1364 = t159 * t113;
  t1368 = t179 * t135;
  t1373 = -t1362 / 0.64e2 + 0.5e1 / 0.192e3 * t1364 - 0.25e2 / 0.72e2 * t1282 * t179 + 0.5e1 / 0.36e2 * t1285 * t1368 + 0.5e1 / 0.24e2 * t525 * t238;
  t1374 = t199 * t1373;
  t1377 = -t1264 - t1266 - 0.151041616e-2 * t1268 - 0.1096241872e-2 * t1258 - t1271 - 0.1096241872e-2 * t1272 - 0.1298352e-1 * t1353 - 0.1298352e-1 * t87 * t558 - 0.151041616e-2 * t1358 - 0.1096241872e-2 * t1360 - 0.1298352e-1 * t97 * t1374;
  tv3rho2lapl2 = -0.1298352e-1 * t1244 - t1248 - t1250 - 0.1298352e-1 * t1252 - 0.1298352e-1 * t1337 - 0.1298352e-1 * t344 * t206 - 0.151041616e-2 * t1341 - 0.1096241872e-2 * t1343 - 0.1298352e-1 * t152 * t529 - 0.151041616e-2 * t1256 + t1377;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1380 = t340 * t532;
  t1384 = t347 * t537;
  t1386 = t347 * t214;
  t1395 = t16 * t571;
  t1396 = t14 * t1395;
  t1400 = t496 * t571;
  t1401 = t91 * t1400;
  t1403 = t91 * t572;
  t1405 = t385 * t52;
  t1407 = t126 * t171;
  t1409 = t171 * t71;
  t1412 = t185 * t139;
  t1417 = -t1405 / 0.64e2 + 0.5e1 / 0.192e3 * t1407 - 0.25e2 / 0.72e2 * t1409 * t139 + 0.5e1 / 0.36e2 * t1326 * t1412 - 0.5e1 / 0.24e2 * t544 * t238;
  t1418 = t199 * t1417;
  t1421 = -t1314 - t1316 - 0.151041616e-2 * t1318 - 0.1096241872e-2 * t1308 - t1321 - 0.1096241872e-2 * t1322 - 0.1298352e-1 * t1396 - 0.1298352e-1 * t87 * t572 - 0.151041616e-2 * t1401 - 0.1096241872e-2 * t1403 - 0.1298352e-1 * t97 * t1418;
  tv3rho2lapl3 = -0.1298352e-1 * t1294 - t1298 - t1300 - 0.1298352e-1 * t1302 - 0.1298352e-1 * t1380 - 0.1298352e-1 * t344 * t214 - 0.151041616e-2 * t1384 - 0.1096241872e-2 * t1386 - 0.1298352e-1 * t152 * t548 - 0.151041616e-2 * t1306 + t1421;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1432 = t437 * t35;
  t1438 = -t1432 / 0.64e2 + 0.5e1 / 0.36e2 * t1285 * t463 + 0.5e1 / 0.24e2 * t525 * t431;
  t1439 = t199 * t1438;
  tv3rho2lapl4 = -0.2596704e-1 * t1337 - t1248 - t1250 - 0.2596704e-1 * t1353 - 0.1298352e-1 * t420 * t206 - 0.302083232e-2 * t1341 - 0.2192483744e-2 * t1343 - 0.2596704e-1 * t152 * t558 - t1264 - t1266 - 0.302083232e-2 * t1358 - t1271 - 0.2192483744e-2 * t1360 - 0.1298352e-1 * t97 * t1439;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1452 = t448 * t52;
  t1454 = t166 * t171;
  t1456 = t48 * t455;
  t1466 = -t1452 / 0.64e2 + 0.5e1 / 0.96e2 * t1454 - 0.5e1 / 0.72e2 * t1456 + 0.5e1 / 0.9e1 * t455 * t72 - 0.25e2 / 0.36e2 * t1409 * t185 + 0.5e1 / 0.36e2 * t1326 * t474 + 0.5e1 / 0.24e2 * t544 * t478;
  t1467 = t199 * t1466;
  tv3rho2lapl5 = -0.2596704e-1 * t1380 - t1298 - t1300 - 0.2596704e-1 * t1396 - 0.1298352e-1 * t420 * t214 - 0.302083232e-2 * t1384 - 0.2192483744e-2 * t1386 - 0.2596704e-1 * t152 * t572 - t1314 - t1316 - 0.302083232e-2 * t1401 - t1321 - 0.2192483744e-2 * t1403 - 0.1298352e-1 * t97 * t1467;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1472 = t581 * t592;
  t1474 = t584 * t592;
  t1476 = t587 * t591;
  t1479 = t30 * t287;
  t1480 = t218 * t1479;
  t1483 = t575 * t521;
  t1485 = t231 * t16;
  t1486 = t35 * t99;
  t1487 = t31 * t1486;
  t1489 = 0.12586801333333333333e-3 * t1485 * t1487;
  t1490 = t14 * t99;
  t1492 = 0.91353489333333333333e-4 * t1490 * t220;
  t1493 = t245 * t13;
  t1498 = t248 * t93;
  t1499 = t1498 * t220;
  t1501 = t248 * t13;
  t1502 = t1501 * t220;
  t1504 = t581 * t588;
  t1506 = t198 * t254;
  t1508 = 0.4392793665333333333e-4 * t1506 * t220;
  t1509 = t198 * t93;
  t1511 = 0.31882367777333333332e-4 * t1509 * t220;
  t1512 = t584 * t588;
  t1514 = t198 * t13;
  t1516 = 0.11569919424066666667e-4 * t1514 * t220;
  t1517 = t16 * t279;
  t1518 = t1517 * t219;
  t1521 = t228 * t16;
  t1522 = t1521 * t201;
  t1524 = t575 * t519;
  tv3rho2tau0 = 0.54098e-2 * t578 * t592 + 0.62934006666666666664e-3 * t1472 + 0.45676744666666666666e-3 * t1474 + 0.54098e-2 * t217 * t1476 - 0.72130666666666666667e-2 * t217 * t1480 + 0.54098e-2 * t1483 - t1489 - t1492 - 0.162294e-2 * t1493 * t220 - 0.324588e-2 * t578 * t588 - 0.37760403999999999998e-3 * t1499 - 0.274060468e-3 * t1502 - 0.37760403999999999998e-3 * t1504 - t1508 - t1511 - 0.274060468e-3 * t1512 - t1516 - 0.162294e-2 * t217 * t1518 - 0.324588e-2 * t1522 - 0.324588e-2 * t1524;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1526 = t1521 * t209;
  t1528 = t52 * t99;
  t1529 = t48 * t1528;
  t1531 = 0.12586801333333333333e-3 * t1485 * t1529;
  t1533 = 0.91353489333333333333e-4 * t1490 * t225;
  t1534 = t575 * t542;
  t1538 = t1498 * t225;
  t1540 = t1501 * t225;
  t1545 = 0.4392793665333333333e-4 * t1506 * t225;
  t1547 = 0.31882367777333333332e-4 * t1509 * t225;
  t1548 = t581 * t604;
  t1551 = 0.11569919424066666667e-4 * t1514 * t225;
  t1552 = t584 * t604;
  t1554 = t16 * t302;
  t1555 = t1554 * t224;
  tv3rho2tau1 = -0.324588e-2 * t1526 - t1531 - t1533 - 0.324588e-2 * t1534 - 0.162294e-2 * t1493 * t225 - 0.37760403999999999998e-3 * t1538 - 0.274060468e-3 * t1540 - 0.324588e-2 * t578 * t604 - t1545 - t1547 - 0.37760403999999999998e-3 * t1548 - t1551 - 0.274060468e-3 * t1552 - 0.162294e-2 * t217 * t1555;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t1560 = t610 * t591;
  t1565 = t16 * t371;
  t1566 = t1565 * t219;
  t1569 = t581 * t611;
  t1571 = t584 * t611;
  t1573 = t344 * t13;
  t1578 = t347 * t93;
  t1579 = t1578 * t220;
  t1581 = t347 * t13;
  t1582 = t1581 * t220;
  t1586 = 0.27049e-2 * t607 * t592 + 0.27049e-2 * t217 * t1560 - 0.162294e-2 * t578 * t611 - 0.162294e-2 * t217 * t1566 - 0.18880201999999999999e-3 * t1569 - 0.137030234e-3 * t1571 - 0.162294e-2 * t1573 * t220 - 0.162294e-2 * t607 * t588 - 0.18880201999999999999e-3 * t1579 - 0.137030234e-3 * t1582 + 0.31467003333333333332e-3 * t1472 + 0.22838372333333333333e-3 * t1474 - t1489;
  t1594 = t575 * t553;
  t1596 = t340 * t16;
  t1597 = t1596 * t201;
  t1599 = -t1492 - 0.18880201999999999999e-3 * t1499 - 0.137030234e-3 * t1502 - 0.18880201999999999999e-3 * t1504 - t1508 - t1511 - 0.137030234e-3 * t1512 - t1516 + 0.27049e-2 * t1483 - 0.162294e-2 * t1522 - 0.162294e-2 * t1524 - 0.162294e-2 * t1594 - 0.162294e-2 * t1597;
  tv3rho2tau2 = t1586 + t1599;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t1600 = t1578 * t225;
  t1602 = t1581 * t225;
  t1606 = t16 * t384;
  t1607 = t1606 * t224;
  t1610 = t581 * t617;
  t1612 = t584 * t617;
  t1616 = t603 * t620;
  t1619 = t581 * t621;
  t1621 = t584 * t621;
  t1624 = -0.18880201999999999999e-3 * t1600 - 0.137030234e-3 * t1602 - 0.162294e-2 * t578 * t617 - 0.162294e-2 * t217 * t1607 - 0.18880201999999999999e-3 * t1610 - 0.137030234e-3 * t1612 + 0.27049e-2 * t578 * t621 + 0.27049e-2 * t217 * t1616 + 0.31467003333333333332e-3 * t1619 + 0.22838372333333333333e-3 * t1621 - t1545 - t1547 - 0.18880201999999999999e-3 * t1548;
  t1632 = t575 * t565;
  t1634 = t1596 * t209;
  t1638 = t575 * t563;
  t1640 = -t1551 - 0.137030234e-3 * t1552 - 0.162294e-2 * t1573 * t225 - 0.162294e-2 * t607 * t604 - t1531 - t1533 - 0.18880201999999999999e-3 * t1538 - 0.137030234e-3 * t1540 + 0.27049e-2 * t1632 - 0.162294e-2 * t1634 - 0.162294e-2 * t1526 - 0.162294e-2 * t1534 - 0.162294e-2 * t1638;
  tv3rho2tau3 = t1624 + t1640;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t1643 = t420 * t13;
  t1652 = t16 * t436;
  t1653 = t1652 * t219;
  tv3rho2tau4 = -0.324588e-2 * t1597 - t1489 - t1492 - 0.324588e-2 * t1594 - 0.162294e-2 * t1643 * t220 - 0.37760403999999999998e-3 * t1579 - 0.274060468e-3 * t1582 - 0.324588e-2 * t607 * t611 - t1508 - t1511 - 0.37760403999999999998e-3 * t1569 - t1516 - 0.274060468e-3 * t1571 - 0.162294e-2 * t217 * t1653;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t1658 = t616 * t620;
  t1661 = t30 * t455;
  t1662 = t223 * t1661;
  t1665 = t16 * t447;
  t1666 = t1665 * t224;
  tv3rho2tau5 = 0.54098e-2 * t607 * t621 + 0.54098e-2 * t217 * t1658 - 0.72130666666666666667e-2 * t217 * t1662 - 0.162294e-2 * t217 * t1666 - 0.162294e-2 * t1643 * t225 - 0.324588e-2 * t607 * t617 - 0.37760403999999999998e-3 * t1600 - 0.274060468e-3 * t1602 - 0.324588e-2 * t1638 - 0.37760403999999999998e-3 * t1610 - 0.274060468e-3 * t1612 + 0.54098e-2 * t1632 + 0.62934006666666666664e-3 * t1619 + 0.45676744666666666666e-3 * t1621 - 0.324588e-2 * t1634 - t1551 - t1531 - t1533 - t1545 - t1547;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t1682 = t14 * t742;
  t1684 = t778 * t146;
  t1687 = t751 * t13 * t78;
  t1689 = t228 * t334;
  t1691 = t489 * t624;
  t1694 = 0.18582848353955555555e-2 * t1184 * t629;
  t1696 = t99 * t86 * t258;
  t1698 = t1181 * t255;
  t1700 = t99 * t8;
  t1701 = t1700 * t632;
  t1704 = t198 * t254 * t334;
  t1707 = t495 * t628 * t146;
  t1709 = t1192 * t629;
  t1712 = t231 * t146 * t262;
  t1716 = 0.236648816987654321e-2 * t772 * t78 * t130;
  t1717 = -0.19672e0 * t1682 - 0.59016e0 * t1684 - 0.19672e0 * t1687 - 0.59016e0 * t1689 + 0.5324598382222222222e-2 * t1691 + t1694 - 0.45770186666666666665e-1 * t1696 + 0.5324598382222222222e-2 * t1698 - 0.22885093333333333333e-1 * t1701 - 0.79868975733333333327e-2 * t1704 - 0.18582848353955555554e-2 * t1707 - 0.18582848353955555554e-2 * t1709 + 0.20342305185185185184e-1 * t1712 - t1716;
  t1718 = t766 * t783;
  t1721 = t99 * t244 * t94;
  t1724 = t91 * t93 * t742;
  t1726 = t492 * t624;
  t1728 = t248 * t632;
  t1732 = 0.2311597037037037037e0 * t1198 * t16 * t75;
  t1735 = 0.3345871597037037037e-1 * t307 * t16 * t75;
  t1736 = t637 * t143;
  t1740 = 0.12712639132942222222e-2 * t748 * t16 * t75;
  t1741 = t640 * t143;
  t1743 = t263 * t331;
  t1746 = 0.1e1 / t9 / t698;
  t1749 = 0.13417131218226103703e-4 * t1746 * t16 * t75;
  t1750 = t645 * t143;
  t1752 = t266 * t331;
  t1754 = t100 * t739;
  t1758 = 0.1e1 / t33 / t673 / rho[0];
  t1759 = lapl[0] * t1758;
  t1768 = t2 * t748;
  t1769 = -t241 + t1768;
  t1770 = 0.12e2 * t1769;
  t1791 = 0.1e1 / t44 / t41;
  t1792 = t295 * t295;
  t1798 = t298 * t298;
  t1804 = -0.24e2 * t1769;
  t1808 = my_piecewise3(t42, 0, -0.8e2 / 0.81e2 * t1791 * t1792 + 0.16e3 / 0.9e1 * t683 * t295 * t298 + 0.4e2 / 0.3e1 * t45 * t1798 + 0.16e3 / 0.9e1 * t687 * t690 + 0.8e1 / 0.3e1 * t121 * t1804);
  t1812 = t240 * t5;
  t1816 = 0.2618e4 / 0.81e2 * t59 / t60 / t1812;
  t1817 = 0.77e3 / 0.81e2 * t1759 * t67 - 0.11e4 / 0.81e2 * t678 * t136 + 0.5e2 / 0.9e1 * t290 * t319 - 0.25e2 / 0.18e2 * t116 * t722 + 0.5e1 / 0.24e2 * t37 * t66 * t1770 - 0.5e1 / 0.24e2 * t54 * t71 * t1770 + t666 * t118 / 0.2e1 + 0.3e1 / 0.4e1 * t280 * t292 + t108 * t680 / 0.2e1 + t31 * (0.616e4 / 0.81e2 * tau[0] * t1758 - 0.77e3 / 0.81e2 * t1759) / 0.8e1 + t1808 * t30 * t56 / 0.8e1 - t1816;
  t1819 = 0.1e1 / t26 / t19;
  t1820 = t271 * t271;
  t1826 = t275 * t275;
  t1835 = my_piecewise3(t20, 0, -0.8e2 / 0.81e2 * t1819 * t1820 + 0.16e3 / 0.9e1 * t652 * t271 * t275 + 0.4e2 / 0.3e1 * t27 * t1826 + 0.16e3 / 0.9e1 * t656 * t661 - 0.8e1 / 0.3e1 * t103 * t1804);
  t1845 = t64 * t64;
  t1847 = 0.1e1 / t65 / t1845;
  t1848 = t315 * t315;
  t1856 = t274 * t274;
  t1863 = t69 * t69;
  t1865 = 0.1e1 / t70 / t1863;
  t1866 = t323 * t323;
  t1874 = t327 * t327;
  t1881 = t1835 * t30 * t39 / 0.8e1 + 0.1e3 / 0.27e2 * t290 * t316 + 0.25e2 / 0.81e2 * t116 * t714 - 0.25e2 / 0.9e1 * t116 * t718 + 0.5e1 / 0.81e2 * t37 * t1847 * t1848 - 0.5e1 / 0.18e2 * t37 * t712 * t315 * t274 + 0.5e1 / 0.12e2 * t37 * t314 * t1856 + 0.5e1 / 0.9e1 * t37 * t717 * t721 + 0.5e1 / 0.81e2 * t54 * t1865 * t1866 - 0.5e1 / 0.18e2 * t54 * t726 * t323 * t327 + 0.5e1 / 0.12e2 * t54 * t322 * t1874 + 0.5e1 / 0.9e1 * t54 * t731 * t735;
  t1885 = -t1732 + t1735 + 0.27739164444444444444e0 * t1736 - t1740 - 0.30112844373333333333e-1 * t1741 - 0.1783232e0 * t1743 + t1749 + 0.6356319566471111111e-3 * t1750 + 0.1129231664e-1 * t1752 + 0.891616e-1 * t1754 + 0.264e0 * t16 * (t1817 + t1881);
  t1893 = 0.21618046918434962961e-3 * t1199 / t627 / t12 * t78;
  t1898 = t757 * t258;
  t1900 = t1189 * t255;
  t1902 = 0.72e2 * t241;
  t1903 = 0.192e3 * t1768;
  t1904 = 0.1e1 / t1812;
  t1906 = 0.12e3 * t3 * t1904;
  t1914 = t10 * t751 * t94;
  t1918 = 0.11866344691358024691e-1 * t231 * t78 * t636;
  t1919 = 0.20342305185185185184e-1 * t1718 - 0.22885093333333333333e-1 * t1721 - 0.22885093333333333332e-1 * t1724 - 0.15973795146666666665e-1 * t1726 - 0.68655279999999999997e-1 * t1728 - 0.4918e-1 * t97 * t13 * t1885 - t1893 - 0.19672e0 * t87 * t743 - 0.29508e0 * t245 * t335 - 0.68655279999999999997e-1 * t1898 - 0.79868975733333333327e-2 * t1900 - 0.4918e-1 * t4 * (-t1902 + t1903 - t1906) * t88 - 0.19672e0 * t752 * t147 - 0.22885093333333333332e-1 * t1914 - t1918;
  tv4rho40 = t1717 + t1919;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1921 = t918 * t13 * t78;
  t1923 = t940 * t146;
  t1925 = t340 * t334;
  t1927 = t778 * t192;
  t1929 = t228 * t413;
  t1931 = t14 * t896;
  t1937 = t913 * t783;
  t1940 = t231 * t192 * t262;
  t1942 = t489 * t793;
  t1944 = t766 * t900;
  t1945 = 0.11442546666666666666e-1 * t1944;
  t1946 = -0.14754e0 * t1921 - 0.29508e0 * t1923 - 0.14754e0 * t1925 - 0.14754e0 * t1927 - 0.29508e0 * t1929 - 0.14754e0 * t1931 - 0.4918e-1 * t1682 - 0.14754e0 * t1684 - 0.4918e-1 * t1687 - 0.14754e0 * t1689 + 0.50855762962962962961e-2 * t1937 + 0.50855762962962962961e-2 * t1940 + 0.13311495955555555556e-2 * t1942 - t1945;
  t1947 = t637 * t189;
  t1973 = 0.64e2 * t367 * t748;
  t1975 = my_piecewise3(t20, 0, -0.8e2 / 0.81e2 * t1819 * t155 * t653 + 0.16e3 / 0.9e1 * t652 * t2 * t83 * t271 + 0.8e2 / 0.9e1 * t825 * t104 * t275 + 0.8e2 / 0.3e1 * t27 * t83 * t104 - 0.8e2 * t828 * t241 * t104 + 0.8e2 / 0.3e1 * t828 * t83 * t275 + 0.4e2 / 0.9e1 * t364 * t661 - 0.32e2 * t103 * t241 + t1973);
  t2009 = 0.64e2 * t380 * t748;
  t2011 = my_piecewise3(t42, 0, -0.8e2 / 0.81e2 * t1791 * t162 * t684 - 0.16e3 / 0.9e1 * t683 * t2 * t83 * t295 + 0.8e2 / 0.9e1 * t848 * t122 * t298 - 0.8e2 / 0.3e1 * t45 * t83 * t122 + 0.8e2 * t851 * t241 * t122 - 0.8e2 / 0.3e1 * t851 * t83 * t298 + 0.4e2 / 0.9e1 * t377 * t690 + 0.32e2 * t121 * t241 - t2009);
  t2017 = t54 * t726;
  t2027 = t116 * t314;
  t2046 = t1975 * t30 * t39 / 0.8e1 + 0.3e1 / 0.8e1 * t840 * t118 + 0.3e1 / 0.8e1 * t372 * t292 + t159 * t680 / 0.8e1 + t2011 * t30 * t56 / 0.8e1 + t695 * t176 / 0.8e1 - t1816 + 0.5e1 / 0.36e2 * t2017 * t238 * t323 + 0.5e1 / 0.4e1 * t870 * t659 * t139 - 0.5e1 / 0.4e1 * t881 * t659 * t135 - 0.25e2 / 0.18e2 * t2027 * t882 - 0.25e2 / 0.72e2 * t174 * t736 + 0.5e1 / 0.4e1 * t54 * t71 * t241 - 0.275e3 / 0.81e2 * t678 * t180 - 0.25e2 / 0.24e2 * t116 * t814 - 0.5e1 / 0.4e1 * t37 * t66 * t241 + 0.25e2 / 0.324e3 * t174 * t728 + 0.25e2 / 0.9e1 * t290 * t397;
  t2064 = 0.5e1 / 0.2e1 * t54 * t406 * t748;
  t2071 = 0.5e1 / 0.2e1 * t37 * t396 * t748;
  t2085 = t37 * t712;
  t2086 = t179 * t274;
  t2093 = t185 * t327;
  t2103 = -0.25e2 / 0.36e2 * t116 * t811 + 0.5e1 / 0.36e2 * t37 * t392 * t721 + 0.5e1 / 0.12e2 * t37 * t314 * t83 * t135 - 0.25e2 / 0.36e2 * t174 * t732 + 0.25e2 / 0.108e3 * t116 * t878 + 0.25e2 / 0.8e1 * t116 * t885 - t2064 + 0.5e1 / 0.81e2 * t37 * t1847 * t179 * t713 + t2071 + 0.5e1 / 0.81e2 * t54 * t1865 * t185 * t727 + 0.5e1 / 0.36e2 * t54 * t402 * t735 - 0.5e1 / 0.12e2 * t54 * t322 * t83 * t139 + 0.5e2 / 0.27e2 * t290 * t393 - 0.5e1 / 0.36e2 * t2085 * t2086 * t135 + 0.5e1 / 0.12e2 * t881 * t238 * t274 - 0.5e1 / 0.36e2 * t2017 * t2093 * t139 - 0.5e1 / 0.12e2 * t870 * t238 * t327 - 0.5e1 / 0.36e2 * t2085 * t238 * t315;
  t2107 = t263 * t410;
  t2108 = 0.891616e-1 * t2107;
  t2109 = t640 * t189;
  t2111 = t266 * t410;
  t2112 = 0.564615832e-2 * t2111;
  t2113 = t645 * t189;
  t2115 = t100 * t893;
  t2123 = 0.6934791111111111111e-1 * t1947 + 0.264e0 * t16 * (t2046 + t2103) - t2108 - 0.75282110933333333332e-2 * t2109 + t2112 + 0.15890798916177777777e-3 * t2113 + 0.668712e-1 * t2115 - t1732 + 0.47672396748533333332e-3 * t1750 + t1749 + 0.56461583199999999999e-2 * t1752 + 0.222904e-1 * t1754 + 0.20804373333333333333e0 * t1736 + t1735 - 0.2258463328e-1 * t1741 - t1740 - 0.89161599999999999999e-1 * t1743;
  t2128 = t231 * t413 * t99;
  t2129 = 0.11442546666666666666e-1 * t2128;
  t2131 = t343 * t93 * t232;
  t2132 = 0.11442546666666666666e-1 * t2131;
  t2135 = t492 * t793;
  t2136 = 0.39934487866666666664e-2 * t2135;
  t2138 = t198 * t254 * t413;
  t2139 = 0.39934487866666666664e-2 * t2138;
  t2141 = t495 * t628 * t192;
  t2144 = t91 * t93 * t896;
  t2146 = t913 * t769;
  t2147 = 0.11442546666666666666e-1 * t2146;
  t2150 = t757 * t358;
  t2152 = t248 * t910;
  t2158 = t924 * t258;
  t2160 = -0.4918e-1 * t97 * t13 * t2123 - t2129 - t2132 - 0.14754e0 * t87 * t897 - t2136 - t2139 - 0.46457120884888888886e-3 * t2141 - 0.17163819999999999999e-1 * t2144 - t2147 - 0.14754e0 * t245 * t414 - 0.17163819999999999999e-1 * t2150 - 0.34327639999999999998e-1 * t2152 - 0.4918e-1 * t752 * t193 - 0.14754e0 * t344 * t335 - 0.34327639999999999998e-1 * t2158;
  t2165 = t151 * t254 * t773;
  t2167 = 0.96e2 * t1768;
  t2175 = t10 * t918 * t94;
  t2177 = t505 * t624;
  t2178 = 0.39934487866666666664e-2 * t2177;
  t2179 = t1224 * t629;
  t2182 = t1221 * t255;
  t2183 = 0.39934487866666666664e-2 * t2182;
  t2184 = t347 * t632;
  t2189 = -0.4918e-1 * t152 * t743 + 0.13311495955555555556e-2 * t2165 - 0.4918e-1 * t4 * (t2167 - t1906) * t88 - 0.14754e0 * t919 * t147 - 0.17163819999999999999e-1 * t2175 - t2178 - 0.46457120884888888886e-3 * t2179 + 0.39934487866666666666e-2 * t1691 + t1694 - t2183 - 0.17163819999999999999e-1 * t2184 - 0.22885093333333333332e-1 * t1696 + 0.39934487866666666666e-2 * t1698 - 0.11442546666666666666e-1 * t1701;
  t2202 = -0.39934487866666666665e-2 * t1704 - 0.13937136265466666666e-2 * t1707 - 0.13937136265466666666e-2 * t1709 + 0.15256728888888888888e-1 * t1712 - t1716 + 0.15256728888888888888e-1 * t1718 - 0.11442546666666666666e-1 * t1721 - 0.57212733333333333332e-2 * t1724 - 0.79868975733333333329e-2 * t1726 - 0.17163819999999999999e-1 * t1728 - t1893 - 0.17163819999999999999e-1 * t1898 - 0.39934487866666666665e-2 * t1900 - 0.57212733333333333332e-2 * t1914 - t1918;
  tv4rho41 = t1946 + t2160 + t2189 + t2202;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t2210 = t99 * t151;
  t2211 = t2210 * t358;
  t2214 = t91 * t93 * t1058;
  t2216 = t1700 * t1064;
  t2218 = t248 * t1064;
  t2220 = t347 * t910;
  t2222 = t505 * t793;
  t2225 = t198 * t254 * t485;
  t2227 = t924 * t358;
  t2283 = -t1816 - 0.5e1 / 0.27e2 * t2085 * t1368 * t238 + 0.5e1 / 0.27e2 * t2017 * t1412 * t238 - 0.25e2 / 0.36e2 * t116 * t1030 + 0.25e2 / 0.27e2 * t458 * t328 + 0.5e2 / 0.81e2 * t458 * t324 + 0.25e2 / 0.36e2 * t174 * t822 + 0.5e2 / 0.81e2 * t290 * t464 + 0.25e2 / 0.27e2 * t290 * t467 + 0.5e1 / 0.18e2 * t37 * t314 * t1029 * t135 + 0.5e1 / 0.36e2 * t37 * t1024 * t274 - 0.25e2 / 0.54e2 * t174 * t819 - 0.5e1 / 0.108e3 * t54 * t1039 * t327 + 0.5e1 / 0.18e2 * t54 * t322 * t3 * t1904 + 0.5e1 / 0.18e2 * t54 * t322 * t1051 * t139 + 0.5e1 / 0.36e2 * t54 * t1047 * t327 + 0.25e2 / 0.162e3 * t116 * t1015 - 0.5e1 / 0.108e3 * t37 * t1014 * t274 - 0.25e2 / 0.54e2 * t116 * t1025 + 0.5e1 / 0.18e2 * t37 * t314 * t3 * t1904;
  t2318 = t174 * t322;
  t2346 = my_piecewise3(t20, 0, -0.8e2 / 0.81e2 * t1819 * t428 * t271 + 0.64e3 / 0.27e2 * t825 * t104 * t2 * t83 + 0.8e2 / 0.27e2 * t972 * t275 + 0.32e3 / 0.9e1 * t27 * t3 * t1904 + 0.16e3 / 0.9e1 * t364 * t83 - 0.16e3 / 0.3e1 * t364 * t659 + 0.8e2 / 0.27e2 * t652 * t432 * t271 + 0.8e2 / 0.9e1 * t27 * t982 * t104 + 0.4e2 / 0.9e1 * t977 * t275 + t1973);
  t2379 = my_piecewise3(t42, 0, -0.8e2 / 0.81e2 * t1791 * t440 * t295 - 0.64e3 / 0.27e2 * t848 * t122 * t2 * t83 + 0.8e2 / 0.27e2 * t992 * t298 + 0.32e3 / 0.9e1 * t45 * t3 * t1904 - 0.16e3 / 0.9e1 * t377 * t83 + 0.16e3 / 0.3e1 * t377 * t659 + 0.8e2 / 0.27e2 * t683 * t443 * t295 + 0.8e2 / 0.9e1 * t45 * t1000 * t122 + 0.4e2 / 0.9e1 * t997 * t298 - t2009);
  t2387 = 0.5e1 / 0.81e2 * t37 * t1847 * t463 * t315 + 0.5e1 / 0.18e2 * t37 * t392 * t83 - 0.5e1 / 0.108e3 * t37 * t712 * t431 * t315 + 0.25e2 / 0.162e3 * t174 * t889 - 0.25e2 / 0.12e2 * t174 * t874 + 0.5e1 / 0.81e2 * t54 * t1865 * t474 * t323 - 0.5e1 / 0.18e2 * t54 * t402 * t83 - 0.5e1 / 0.108e3 * t54 * t726 * t478 * t323 - t2064 + t2071 - 0.25e2 / 0.27e2 * t2027 * t1019 + 0.5e1 / 0.6e1 * t870 * t1043 * t241 - 0.5e1 / 0.6e1 * t881 * t1018 * t241 + 0.25e2 / 0.27e2 * t2318 * t871 + t2346 * t30 * t39 / 0.8e1 + t987 * t118 / 0.4e1 + t437 * t292 / 0.8e1 + t2379 * t30 * t56 / 0.8e1 + t863 * t176 / 0.4e1 + t303 * t460 / 0.8e1;
  t2391 = t100 * t1055;
  t2393 = t266 * t482;
  t2395 = t263 * t482;
  t2408 = 0.264e0 * t16 * (t2283 + t2387) + 0.445808e-1 * t2391 + 0.18820527733333333333e-2 * t2393 - 0.29720533333333333333e-1 * t2395 + 0.13869582222222222222e0 * t1947 - 0.11888213333333333333e0 * t2107 - 0.15056422186666666667e-1 * t2109 + 0.75282110933333333334e-2 * t2111 + 0.31781597832355555556e-3 * t2113 + 0.445808e-1 * t2115 - t1732 + 0.31781597832355555554e-3 * t1750 + t1749 + 0.18820527733333333333e-2 * t1752 + 0.13869582222222222222e0 * t1736 + t1735 - 0.15056422186666666666e-1 * t1741 - t1740 - 0.29720533333333333333e-1 * t1743;
  t2414 = -0.9836e-1 * t1921 - 0.19672e0 * t1923 - 0.9836e-1 * t1925 - 0.9836e-1 * t1927 - 0.19672e0 * t1929 - 0.9836e-1 * t1931 - 0.7628364444444444444e-2 * t2211 - 0.11442546666666666666e-1 * t2214 - 0.38141822222222222221e-2 * t2216 - 0.11442546666666666666e-1 * t2218 - 0.22885093333333333332e-1 * t2220 - 0.26622991911111111109e-2 * t2222 - 0.13311495955555555555e-2 * t2225 - 0.22885093333333333332e-1 * t2227 - 0.9836e-1 * t87 * t1059 - 0.4918e-1 * t97 * t13 * t2408 - 0.4918e-1 * t245 * t486;
  t2418 = t10 * t960 * t94;
  t2427 = t419 * t93 * t232;
  t2436 = t955 * t258;
  t2438 = t1236 * t255;
  t2447 = -0.9836e-1 * t961 * t147 - 0.11442546666666666666e-1 * t2418 - 0.4918e-1 * t420 * t335 - 0.9836e-1 * t919 * t193 - 0.19672e0 * t344 * t414 - 0.38141822222222222221e-2 * t2427 - 0.4918e-1 * t4 * (0.24e2 * t241 - t1906) * t88 - 0.9836e-1 * t152 * t897 - 0.11442546666666666666e-1 * t2436 - 0.13311495955555555555e-2 * t2438 + 0.10171152592592592592e-1 * t1937 + 0.10171152592592592592e-1 * t1940 + 0.26622991911111111109e-2 * t1942 - 0.15256728888888888888e-1 * t1944 - 0.15256728888888888888e-1 * t2128 - 0.15256728888888888888e-1 * t2131 - 0.53245983822222222218e-2 * t2135;
  t2465 = -0.53245983822222222218e-2 * t2138 - 0.92914241769777777768e-3 * t2141 - 0.11442546666666666666e-1 * t2144 - 0.15256728888888888888e-1 * t2146 - 0.11442546666666666666e-1 * t2150 - 0.22885093333333333332e-1 * t2152 - 0.22885093333333333332e-1 * t2158 + 0.26622991911111111109e-2 * t2165 - 0.11442546666666666666e-1 * t2175 - 0.53245983822222222218e-2 * t2177 - 0.92914241769777777768e-3 * t2179 + 0.26622991911111111112e-2 * t1691 + t1694 - 0.53245983822222222218e-2 * t2182 - 0.11442546666666666666e-1 * t2184 - 0.76283644444444444442e-2 * t1696 + 0.26622991911111111112e-2 * t1698;
  t2475 = t340 * t413;
  t2477 = t940 * t192;
  t2480 = t960 * t13 * t78;
  t2482 = t950 * t146;
  t2484 = t228 * t485;
  t2486 = t14 * t1058;
  t2488 = -0.38141822222222222221e-2 * t1701 - 0.13311495955555555555e-2 * t1704 - 0.92914241769777777772e-3 * t1707 - 0.92914241769777777772e-3 * t1709 + 0.10171152592592592592e-1 * t1712 - t1716 + 0.10171152592592592592e-1 * t1718 - 0.38141822222222222221e-2 * t1721 - 0.2662299191111111111e-2 * t1726 - t1893 - 0.13311495955555555555e-2 * t1900 - t1918 - 0.19672e0 * t2475 - 0.19672e0 * t2477 - 0.9836e-1 * t2480 - 0.9836e-1 * t2482 - 0.9836e-1 * t2484 - 0.9836e-1 * t2486;
  tv4rho42 = t2414 + t2447 + t2465 + t2488;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t2490 = t14 * t1156;
  t2492 = t340 * t485;
  t2502 = t950 * t192;
  t2505 = t1160 * t13 * t78;
  t2509 = -0.4918e-1 * t2490 - 0.14754e0 * t2492 - 0.22885093333333333333e-1 * t2211 - 0.17163819999999999999e-1 * t2214 - 0.11442546666666666667e-1 * t2216 - 0.17163819999999999999e-1 * t2218 - 0.34327639999999999998e-1 * t2220 - 0.79868975733333333326e-2 * t2222 - 0.39934487866666666663e-2 * t2225 - 0.34327639999999999998e-1 * t2227 - 0.14754e0 * t2502 - 0.4918e-1 * t2505 - 0.17163819999999999999e-1 * t2418 - 0.11442546666666666667e-1 * t2427;
  t2518 = -0.17163819999999999999e-1 * t2436 - 0.39934487866666666663e-2 * t2438 + 0.15256728888888888888e-1 * t1937 + 0.15256728888888888888e-1 * t1940 + 0.39934487866666666664e-2 * t1942 - t1945 - t2129 - t2132 - t2136 - t2139 - 0.13937136265466666665e-2 * t2141 - t2147 + 0.39934487866666666664e-2 * t2165 - t2178 - 0.13937136265466666665e-2 * t2179;
  t2535 = t100 * t1153;
  t2555 = 0.12e2 * t241 + 0.24e2 * t1768;
  t2559 = my_piecewise3(t20, 0, -0.8e2 / 0.81e2 * t1819 * t1082 * t104 + 0.16e3 / 0.9e1 * t972 * t238 + 0.8e2 / 0.9e1 * t825 * t432 * t104 + 0.8e2 / 0.3e1 * t828 * t83 * t432 + 0.4e2 / 0.3e1 * t364 * t982 + 0.4e2 / 0.9e1 * t27 * t1088 * t104 + 0.8e1 / 0.3e1 * t103 * t2555);
  t2585 = my_piecewise3(t42, 0, -0.8e2 / 0.81e2 * t1791 * t1096 * t122 - 0.16e3 / 0.9e1 * t992 * t238 + 0.8e2 / 0.9e1 * t848 * t443 * t122 - 0.8e2 / 0.3e1 * t851 * t83 * t443 + 0.4e2 / 0.3e1 * t377 * t1000 + 0.4e2 / 0.9e1 * t45 * t1101 * t122 - 0.8e1 / 0.3e1 * t121 * t2555);
  t2618 = -t1816 + t2559 * t30 * t39 / 0.8e1 + t1093 * t118 / 0.8e1 + t2585 * t30 * t56 / 0.8e1 + 0.3e1 / 0.8e1 * t1005 * t176 + 0.3e1 / 0.8e1 * t385 * t460 + t126 * t1120 / 0.8e1 + 0.5e1 / 0.36e2 * t54 * t322 * t1149 * t139 + 0.5e1 / 0.81e2 * t37 * t1847 * t1123 * t135 - 0.25e2 / 0.36e2 * t116 * t1127 + 0.5e1 / 0.12e2 * t37 * t392 * t1029 + 0.5e1 / 0.36e2 * t37 * t314 * t1130 * t135 + 0.5e2 / 0.27e2 * t458 * t403 - 0.25e2 / 0.9e1 * t458 * t407 + 0.25e2 / 0.108e3 * t174 * t1040;
  t2628 = t179 * t431;
  t2641 = t185 * t478;
  t2656 = -0.6e1 * t241 - 0.12e2 * t1768;
  t2670 = -0.25e2 / 0.36e2 * t174 * t1048 + 0.5e1 / 0.81e2 * t54 * t1865 * t1142 * t139 + 0.5e1 / 0.12e2 * t54 * t402 * t1051 - 0.5e1 / 0.36e2 * t2085 * t2628 * t135 + 0.5e1 / 0.12e2 * t881 * t238 * t431 + 0.25e2 / 0.18e2 * t2318 * t1044 + 0.5e1 / 0.36e2 * t2017 * t474 * t2 * t83 - 0.5e1 / 0.36e2 * t2017 * t2641 * t139 - 0.5e1 / 0.12e2 * t870 * t238 * t478 - 0.5e1 / 0.36e2 * t2085 * t463 * t2 * t83 - 0.25e2 / 0.24e2 * t174 * t1052 + 0.5e1 / 0.24e2 * t54 * t71 * t2656 - 0.5e1 / 0.24e2 * t37 * t66 * t2656 - 0.275e3 / 0.81e2 * t1118 * t140 - 0.25e2 / 0.72e2 * t116 * t1131 + 0.25e2 / 0.324e3 * t116 * t1124;
  t2674 = -t1732 + t1735 + 0.6934791111111111111e-1 * t1736 - t1740 - 0.75282110933333333332e-2 * t1741 + 0.20804373333333333333e0 * t1947 - 0.2258463328e-1 * t2109 - t2108 + t1749 + 0.15890798916177777777e-3 * t1750 + 0.47672396748533333333e-3 * t2113 + t2112 - 0.891616e-1 * t2395 + 0.564615832e-2 * t2393 + 0.668712e-1 * t2391 + 0.222904e-1 * t2535 + 0.264e0 * t16 * (t2618 + t2670);
  t2682 = 0.13311495955555555556e-2 * t1691 + t1694 - t2183 + 0.13311495955555555556e-2 * t1698 - 0.46457120884888888886e-3 * t1707 - 0.46457120884888888886e-3 * t1709 + 0.50855762962962962961e-2 * t1712 - t1716 + 0.50855762962962962961e-2 * t1718 - t1893 - t1918 - 0.4918e-1 * t97 * t13 * t2674 - 0.4918e-1 * t87 * t1157 - 0.14754e0 * t152 * t1059;
  t2685 = t955 * t358;
  t2692 = t91 * t93 * t1156;
  t2701 = t10 * t1160 * t94;
  t2703 = t347 * t1064;
  t2711 = -0.14754e0 * t344 * t486 - 0.1716382e-1 * t2685 - 0.14754e0 * t961 * t193 - 0.14754e0 * t420 * t414 - 0.57212733333333333332e-2 * t2692 - 0.4918e-1 * t4 * (-t2167 - t1906) * t88 - 0.4918e-1 * t1161 * t147 - 0.57212733333333333332e-2 * t2701 - 0.1716382e-1 * t2703 - 0.29508e0 * t2475 - 0.29508e0 * t2477 - 0.14754e0 * t2480 - 0.14754e0 * t2482 - 0.14754e0 * t2484 - 0.14754e0 * t2486;
  tv4rho43 = t2509 + t2518 + t2682 + t2711;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t2727 = -0.19672e0 * t2490 - 0.59016e0 * t2492 - 0.45770186666666666665e-1 * t2211 - 0.22885093333333333333e-1 * t2216 - 0.15973795146666666665e-1 * t2222 - 0.79868975733333333327e-2 * t2225 - 0.59016e0 * t2502 - 0.19672e0 * t2505 - 0.22885093333333333333e-1 * t2427 - 0.79868975733333333327e-2 * t2438 + 0.20342305185185185184e-1 * t1937 + 0.20342305185185185184e-1 * t1940 + 0.5324598382222222222e-2 * t1942 - 0.18582848353955555554e-2 * t2141;
  t2736 = t428 * t428;
  t2741 = t432 * t432;
  t2746 = t241 + t1768;
  t2747 = 0.24e2 * t2746;
  t2751 = my_piecewise3(t20, 0, -0.8e2 / 0.81e2 * t1819 * t2736 + 0.16e3 / 0.9e1 * t972 * t432 + 0.4e2 / 0.3e1 * t27 * t2741 + 0.16e3 / 0.9e1 * t364 * t1088 + 0.8e1 / 0.3e1 * t103 * t2747);
  t2755 = t440 * t440;
  t2760 = t443 * t443;
  t2769 = my_piecewise3(t42, 0, -0.8e2 / 0.81e2 * t1791 * t2755 + 0.16e3 / 0.9e1 * t992 * t443 + 0.4e2 / 0.3e1 * t45 * t2760 + 0.16e3 / 0.9e1 * t377 * t1101 - 0.8e1 / 0.3e1 * t121 * t2747);
  t2781 = 0.1e1 / t50 / t1113 / rho[1];
  t2784 = lapl[1] * t2781;
  t2789 = 0.12e2 * t2746;
  t2805 = t2751 * t30 * t39 / 0.8e1 + t2769 * t30 * t56 / 0.8e1 + t1106 * t176 / 0.2e1 + 0.3e1 / 0.4e1 * t448 * t460 + t166 * t1120 / 0.2e1 + t48 * (0.616e4 / 0.81e2 * tau[1] * t2781 - 0.77e3 / 0.81e2 * t2784) / 0.8e1 + 0.5e1 / 0.24e2 * t37 * t66 * t2789 + 0.77e3 / 0.81e2 * t2784 * t72 - 0.11e4 / 0.81e2 * t1118 * t186 + 0.5e2 / 0.9e1 * t458 * t479 - 0.25e2 / 0.18e2 * t174 * t1150 - 0.5e1 / 0.24e2 * t54 * t71 * t2789;
  t2806 = t431 * t431;
  t2819 = t474 * t474;
  t2826 = t478 * t478;
  t2833 = t463 * t463;
  t2840 = 0.5e1 / 0.12e2 * t37 * t314 * t2806 + 0.5e1 / 0.9e1 * t37 * t392 * t1130 + 0.1e3 / 0.27e2 * t458 * t475 + 0.25e2 / 0.81e2 * t174 * t1143 - 0.25e2 / 0.9e1 * t174 * t1146 + 0.5e1 / 0.81e2 * t54 * t1865 * t2819 - 0.5e1 / 0.18e2 * t54 * t1039 * t478 + 0.5e1 / 0.12e2 * t54 * t322 * t2826 + 0.5e1 / 0.9e1 * t54 * t402 * t1149 + 0.5e1 / 0.81e2 * t37 * t1847 * t2833 - 0.5e1 / 0.18e2 * t37 * t1014 * t431 - t1816;
  t2844 = -t1732 + t1735 + 0.27739164444444444444e0 * t1947 - t1740 - 0.30112844373333333333e-1 * t2109 - 0.1783232e0 * t2395 + t1749 + 0.6356319566471111111e-3 * t2113 + 0.1129231664e-1 * t2393 + 0.891616e-1 * t2535 + 0.264e0 * t16 * (t2805 + t2840);
  t2862 = 0.5324598382222222222e-2 * t2165 - 0.18582848353955555554e-2 * t2179 + t1694 - 0.4918e-1 * t97 * t13 * t2844 - 0.19672e0 * t152 * t1157 - t1716 - 0.29508e0 * t420 * t486 - 0.4918e-1 * t4 * (-t1902 - t1903 - t1906) * t88 - 0.19672e0 * t1161 * t193 - t1893 - t1918 - 0.68655279999999999997e-1 * t2685 - 0.22885093333333333332e-1 * t2692 - 0.22885093333333333332e-1 * t2701 - 0.68655279999999999997e-1 * t2703;
  tv4rho44 = t2727 + t2862;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2863 = t1746 * t8;
  t2864 = t2863 * t199;
  t2865 = 0.1041292748166e-3 * t2864;
  t2867 = t197 * t751 * t199;
  t2869 = t83 * t244;
  t2870 = t2869 * t496;
  t2872 = t2869 * t199;
  t2874 = t1198 * t86;
  t2875 = t2874 * t1200;
  t2877 = t2874 * t496;
  t2879 = t2874 * t199;
  t2881 = t700 * t8;
  t2882 = t628 * t16;
  t2883 = t2881 * t2882;
  t2884 = 0.15330849892013333332e-4 * t2883;
  t2885 = t2881 * t1200;
  t2886 = 0.11126946354289333332e-4 * t2885;
  t2887 = t2881 * t496;
  t2888 = 0.40379018789992666666e-5 * t2887;
  t2889 = t2881 * t199;
  t2890 = 0.97688686337202888891e-6 * t2889;
  t2892 = t130 * t86 * t199;
  t2894 = t748 * t8;
  t2895 = t2894 * t496;
  t2896 = 0.43634244622222222221e-2 * t2895;
  t2897 = t2894 * t199;
  t2898 = 0.31669209635555555555e-2 * t2897;
  t2900 = t62 * t244 * t199;
  t2902 = t241 * t86;
  t2903 = t2902 * t496;
  t2905 = t2902 * t199;
  t2907 = t2863 * t1200;
  t2908 = 0.39535142987999999997e-3 * t2907;
  t2909 = t2863 * t496;
  t2910 = 0.28694130999599999999e-3 * t2909;
  t2912 = t307 * t8 * t199;
  t2913 = 0.26447911111111111111e-1 * t2912;
  tv4rho3sigma0 = -t2865 + 0.162294e-2 * t2867 + 0.56640605999999999997e-3 * t2870 + 0.411090702e-3 * t2872 + 0.13178380995999999999e-3 * t2875 + 0.95647103331999999996e-4 * t2877 + 0.347097582722e-4 * t2879 + t2884 + t2886 + t2888 + t2890 + 0.216392e-1 * t2892 + t2896 + t2898 - 0.81147e-2 * t2900 - 0.26432282799999999998e-2 * t2903 - 0.1918423276e-2 * t2905 - t2908 - t2910 - t2913;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2914 = 0.2082585496332e-3 * t2864;
  t2921 = 0.30661699784026666664e-4 * t2883;
  t2922 = 0.22253892708578666666e-4 * t2885;
  t2923 = 0.8075803757998533333e-5 * t2887;
  t2924 = 0.19537737267440577777e-5 * t2889;
  t2926 = 0.87268489244444444441e-2 * t2895;
  t2927 = 0.63338419271111111112e-2 * t2897;
  t2931 = 0.79070285975999999995e-3 * t2907;
  t2932 = 0.57388261999199999998e-3 * t2909;
  t2933 = 0.52895822222222222221e-1 * t2912;
  tv4rho3sigma1 = -t2914 + 0.324588e-2 * t2867 + 0.113281212e-2 * t2870 + 0.822181404e-3 * t2872 + 0.26356761991999999998e-3 * t2875 + 0.19129420666399999999e-3 * t2877 + 0.69419516544399999999e-4 * t2879 + t2921 + t2922 + t2923 + t2924 + 0.432784e-1 * t2892 + t2926 + t2927 - 0.162294e-1 * t2900 - 0.52864565599999999998e-2 * t2903 - 0.3836846552e-2 * t2905 - t2931 - t2932 - t2933;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  tv4rho3sigma2 = tv4rho3sigma0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t2935 = t130 * t151 * t199;
  t2937 = t241 * t151;
  t2938 = t2937 * t496;
  t2940 = t2937 * t199;
  t2943 = t197 * t918 * t199;
  t2945 = t83 * t343;
  t2946 = t2945 * t496;
  t2947 = 0.37760403999999999998e-3 * t2946;
  t2948 = t2945 * t199;
  t2949 = 0.274060468e-3 * t2948;
  t2950 = t1198 * t151;
  t2951 = t2950 * t1200;
  t2953 = t2950 * t496;
  t2955 = t2950 * t199;
  t2958 = t62 * t343 * t199;
  t2959 = 0.54098e-2 * t2958;
  t2963 = 0.72130666666666666667e-2 * t2935 - 0.88107609333333333329e-3 * t2938 - 0.63947442533333333333e-3 * t2940 + 0.162294e-2 * t2943 + t2947 + t2949 + 0.4392793665333333333e-4 * t2951 + 0.31882367777333333332e-4 * t2953 + 0.11569919424066666667e-4 * t2955 - t2959 - t2865 + 0.18880201999999999999e-3 * t2870 + 0.137030234e-3 * t2872 + 0.8785587330666666666e-4 * t2875;
  t2964 = 0.63764735554666666664e-4 * t2877;
  t2966 = 0.14426133333333333333e-1 * t2892;
  t2968 = 0.17621521866666666666e-2 * t2903;
  t2969 = 0.12789488506666666667e-2 * t2905;
  t2970 = t2964 + 0.23139838848133333334e-4 * t2879 + t2884 + t2886 + t2888 + t2890 + t2966 + t2896 + t2898 - 0.27049e-2 * t2900 - t2968 - t2969 - t2908 - t2910 - t2913;
  tv4rho3sigma3 = t2963 + t2970;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  t2971 = 0.14426133333333333333e-1 * t2935;
  t2972 = 0.17621521866666666666e-2 * t2938;
  t2973 = 0.12789488506666666667e-2 * t2940;
  t2975 = 0.75520807999999999998e-3 * t2946;
  t2976 = 0.548120936e-3 * t2948;
  t2978 = 0.63764735554666666664e-4 * t2953;
  t2979 = 0.23139838848133333333e-4 * t2955;
  t2980 = 0.108196e-1 * t2958;
  t2984 = t2971 - t2972 - t2973 + 0.324588e-2 * t2943 + t2975 + t2976 + 0.87855873306666666662e-4 * t2951 + t2978 + t2979 - t2980 - t2914 + 0.37760403999999999999e-3 * t2870 + 0.274060468e-3 * t2872 + 0.17571174661333333332e-3 * t2875;
  t2991 = 0.12752947110933333333e-3 * t2877 + 0.46279677696266666666e-4 * t2879 + t2921 + t2922 + t2923 + t2924 + 0.28852266666666666666e-1 * t2892 + t2926 + t2927 - 0.54098e-2 * t2900 - 0.35243043733333333332e-2 * t2903 - 0.25578977013333333334e-2 * t2905 - t2931 - t2932 - t2933;
  tv4rho3sigma4 = t2984 + t2991;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  tv4rho3sigma5 = tv4rho3sigma3;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2993 = t62 * t419 * t199;
  t2996 = t197 * t960 * t199;
  t2998 = t83 * t419;
  t2999 = t2998 * t496;
  t3001 = t2998 * t199;
  t3004 = -0.27049e-2 * t2993 + 0.162294e-2 * t2996 + 0.18880201999999999999e-3 * t2999 + 0.137030234e-3 * t3001 + t2971 - t2972 - t2973 + t2947 + t2949 + 0.87855873306666666659e-4 * t2951 + t2978 + t2979 - t2959 - t2865;
  t3011 = 0.4392793665333333333e-4 * t2875 + 0.31882367777333333332e-4 * t2877 + 0.11569919424066666667e-4 * t2879 + t2884 + t2886 + t2888 + t2890 + 0.72130666666666666667e-2 * t2892 + t2896 + t2898 - 0.88107609333333333329e-3 * t2903 - 0.63947442533333333333e-3 * t2905 - t2908 - t2910 - t2913;
  tv4rho3sigma6 = t3004 + t3011;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  t3022 = -0.54098e-2 * t2993 + 0.324588e-2 * t2996 + 0.37760403999999999999e-3 * t2999 + 0.274060468e-3 * t3001 + 0.28852266666666666667e-1 * t2935 - 0.35243043733333333332e-2 * t2938 - 0.25578977013333333333e-2 * t2940 + t2975 + t2976 + 0.17571174661333333332e-3 * t2951 + 0.12752947110933333333e-3 * t2953 + 0.46279677696266666666e-4 * t2955 - t2980 - t2914;
  t3025 = 0.87855873306666666662e-4 * t2875 + t2964 + 0.23139838848133333333e-4 * t2879 + t2921 + t2922 + t2923 + t2924 + t2966 + t2926 + t2927 - t2968 - t2969 - t2931 - t2932 - t2933;
  tv4rho3sigma7 = t3022 + t3025;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  tv4rho3sigma8 = tv4rho3sigma6;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t3027 = t197 * t1160 * t199;
  tv4rho3sigma9 = 0.162294e-2 * t3027 - 0.81147e-2 * t2993 + 0.216392e-1 * t2935 + 0.56640605999999999997e-3 * t2999 + 0.411090702e-3 * t3001 - 0.26432282799999999998e-2 * t2938 - 0.1918423276e-2 * t2940 + 0.13178380995999999999e-3 * t2951 + 0.95647103331999999996e-4 * t2953 + 0.347097582722e-4 * t2955 - t2865 + t2884 + t2886 + t2888 + t2890 + t2896 + t2898 - t2908 - t2910 - t2913;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.324588e-2 * t3027 - 0.162294e-1 * t2993 + 0.432784e-1 * t2935 + 0.113281212e-2 * t2999 + 0.822181404e-3 * t3001 - 0.52864565599999999998e-2 * t2938 - 0.3836846552e-2 * t2940 + 0.26356761991999999998e-3 * t2951 + 0.19129420666399999999e-3 * t2953 + 0.69419516544399999999e-4 * t2955 - t2914 + t2921 + t2922 + t2923 + t2924 + t2926 + t2927 - t2931 - t2932 - t2933;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  tv4rho3sigma11 = tv4rho3sigma9;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t3048 = t91 * t1291;
  t3050 = t509 * t62;
  t3052 = 0.35142349322666666665e-3 * t772 * t3050;
  t3054 = 0.25505894221866666666e-3 * t231 * t3050;
  t3055 = t100 * t528;
  t3056 = t14 * t3055;
  t3059 = 0.92559355392533333334e-4 * t14 * t3050;
  t3064 = t757 * t514;
  t3066 = t757 * t206;
  t3068 = t248 * t1267;
  t3070 = t492 * t1262;
  t3072 = t492 * t514;
  t3074 = t248 * t529;
  t3076 = t492 * t206;
  t3078 = t766 * t1246;
  t3080 = t228 * t1246;
  t3082 = -0.3288725616e-2 * t3048 + t3052 + t3054 - 0.2192483744e-2 * t3056 + t3059 - 0.1298352e-1 * t752 * t206 - 0.3895056e-1 * t245 * t529 - 0.453124848e-2 * t3064 - 0.3288725616e-2 * t3066 - 0.90624969599999999999e-2 * t3068 - 0.105427047968e-2 * t3070 - 0.76517682665599999999e-3 * t3072 - 0.6577451232e-2 * t3074 - 0.2776780661776e-3 * t3076 - 0.30208323199999999999e-2 * t3078 - 0.2192483744e-2 * t3080;
  t3083 = t231 * t3055;
  t3085 = t509 * t262;
  t3087 = 0.13425921422222222223e-2 * t231 * t3085;
  t3089 = 0.97443721955555555556e-3 * t14 * t3085;
  t3100 = t287 * t66;
  t3103 = t113 * t314;
  t3108 = t35 * t712;
  t3116 = -t666 * t35 / 0.64e2 + 0.5e1 / 0.64e2 * t280 * t113 - 0.5e1 / 0.24e2 * t108 * t287 + 0.55e2 / 0.216e3 * t31 * t675 - 0.55e2 / 0.27e2 * t675 * t67 + 0.25e2 / 0.9e1 * t3100 * t135 - 0.25e2 / 0.36e2 * t3103 * t315 - 0.25e2 / 0.24e2 * t1282 * t274 - 0.5e1 / 0.108e3 * t3108 * t713 + 0.5e1 / 0.12e2 * t1285 * t135 * t274 + 0.5e1 / 0.24e2 * t525 * t721;
  t3123 = t198 * t1200 * t528;
  t3127 = 0.12264679913610666666e-3 * t495 * t2882 * t205;
  t3129 = 0.89015570834314666663e-4 * t495 * t1262;
  t3130 = t198 * t1267;
  t3133 = 0.32303215031994133332e-4 * t495 * t514;
  t3135 = t91 * t496 * t1290;
  t3137 = t198 * t529;
  t3140 = 0.78150949069762311111e-5 * t495 * t206;
  t3141 = t778 * t509;
  t3143 = t228 * t1251;
  t3146 = t14 * t16 * t1290;
  t3148 = -0.30208323199999999999e-2 * t3083 + t3087 + t3089 - 0.1298352e-1 * t97 * t199 * t3116 - 0.3895056e-1 * t87 * t1291 - 0.105427047968e-2 * t3123 - t3127 - t3129 - 0.76517682665599999999e-3 * t3130 - t3133 - 0.453124848e-2 * t3135 - 0.2776780661776e-3 * t3137 - t3140 - 0.3895056e-1 * t3141 - 0.7790112e-1 * t3143 - 0.3895056e-1 * t3146;
  tv4rho3lapl0 = t3082 + t3148;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t3149 = t778 * t532;
  t3151 = t228 * t1301;
  t3154 = t14 * t16 * t1331;
  t3158 = t766 * t1296;
  t3160 = t228 * t1296;
  t3162 = t1301 * t99;
  t3163 = t231 * t3162;
  t3165 = t532 * t62;
  t3167 = 0.35142349322666666665e-3 * t772 * t3165;
  t3169 = 0.25505894221866666666e-3 * t231 * t3165;
  t3170 = t532 * t262;
  t3172 = 0.13425921422222222223e-2 * t231 * t3170;
  t3174 = 0.97443721955555555556e-3 * t14 * t3170;
  t3177 = t52 * t726;
  t3190 = t198 * t1200 * t547;
  t3194 = 0.12264679913610666666e-3 * t495 * t2882 * t213;
  t3196 = 0.89015570834314666663e-4 * t495 * t1312;
  t3197 = t198 * t1317;
  t3199 = -0.3895056e-1 * t3149 - 0.7790112e-1 * t3151 - 0.3895056e-1 * t3154 - 0.3895056e-1 * t87 * t1332 - 0.30208323199999999999e-2 * t3158 - 0.2192483744e-2 * t3160 - 0.30208323199999999999e-2 * t3163 + t3167 + t3169 + t3172 + t3174 - 0.1298352e-1 * t97 * t199 * (-t695 * t52 / 0.64e2 - 0.5e1 / 0.108e3 * t3177 * t727 + 0.5e1 / 0.12e2 * t1326 * t139 * t327 + 0.5e1 / 0.24e2 * t544 * t735) - 0.105427047968e-2 * t3190 - t3194 - t3196 - 0.76517682665599999999e-3 * t3197;
  t3201 = 0.32303215031994133332e-4 * t495 * t537;
  t3203 = t91 * t496 * t1331;
  t3205 = t198 * t548;
  t3208 = 0.78150949069762311111e-5 * t495 * t214;
  t3209 = t91 * t1332;
  t3211 = t14 * t3162;
  t3214 = 0.92559355392533333334e-4 * t14 * t3165;
  t3219 = t757 * t537;
  t3221 = t757 * t214;
  t3223 = t248 * t1317;
  t3225 = t492 * t1312;
  t3227 = t492 * t537;
  t3229 = t248 * t548;
  t3231 = t492 * t214;
  t3233 = -t3201 - 0.453124848e-2 * t3203 - 0.2776780661776e-3 * t3205 - t3208 - 0.3288725616e-2 * t3209 - 0.2192483744e-2 * t3211 + t3214 - 0.1298352e-1 * t752 * t214 - 0.3895056e-1 * t245 * t548 - 0.453124848e-2 * t3219 - 0.3288725616e-2 * t3221 - 0.90624969599999999999e-2 * t3223 - 0.105427047968e-2 * t3225 - 0.76517682665599999999e-3 * t3227 - 0.6577451232e-2 * t3229 - 0.2776780661776e-3 * t3231;
  tv4rho3lapl1 = t3199 + t3233;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t3235 = 0.2596704e-1 * t228 * t1352;
  t3238 = 0.2596704e-1 * t14 * t16 * t1373;
  t3240 = 0.2596704e-1 * t940 * t509;
  t3242 = 0.2596704e-1 * t340 * t1251;
  t3244 = 0.2192483744e-2 * t924 * t206;
  t3246 = 0.302083232e-2 * t347 * t1267;
  t3247 = t505 * t1262;
  t3249 = t505 * t514;
  t3252 = 0.2192483744e-2 * t347 * t529;
  t3253 = t505 * t206;
  t3280 = -t840 * t35 / 0.64e2 + 0.5e1 / 0.96e2 * t372 * t113 - 0.5e1 / 0.72e2 * t159 * t287 + 0.25e2 / 0.27e2 * t3100 * t179 - 0.25e2 / 0.54e2 * t3103 * t1368 - 0.25e2 / 0.36e2 * t1282 * t238 - 0.5e1 / 0.108e3 * t3108 * t179 * t315 + 0.5e1 / 0.18e2 * t1285 * t882 + 0.5e1 / 0.36e2 * t1285 * t2086 + 0.5e1 / 0.24e2 * t525 * t83 - 0.5e1 / 0.8e1 * t525 * t659;
  t3284 = t1352 * t99;
  t3285 = t231 * t3284;
  t3287 = t14 * t3284;
  t3289 = -t3235 - t3238 - t3240 - t3242 - t3244 - t3246 - 0.35142349322666666666e-3 * t3247 - 0.25505894221866666666e-3 * t3249 - t3252 - 0.92559355392533333333e-4 * t3253 - 0.1298352e-1 * t152 * t1291 - 0.1298352e-1 * t97 * t199 * t3280 - 0.10069441066666666667e-2 * t3285 - 0.73082791466666666667e-3 * t3287;
  t3295 = 0.302083232e-2 * t248 * t1357;
  t3297 = 0.2192483744e-2 * t248 * t558;
  t3300 = 0.302083232e-2 * t91 * t496 * t1373;
  t3302 = t198 * t1200 * t557;
  t3304 = t198 * t1357;
  t3307 = 0.2192483744e-2 * t91 * t1374;
  t3308 = t198 * t558;
  t3310 = t913 * t1246;
  t3312 = t340 * t1246;
  t3319 = 0.302083232e-2 * t924 * t514;
  t3320 = -0.1298352e-1 * t245 * t558 - 0.2596704e-1 * t87 * t1374 - t3295 - t3297 - t3300 - 0.35142349322666666666e-3 * t3302 - 0.25505894221866666666e-3 * t3304 - t3307 - 0.92559355392533333333e-4 * t3308 - 0.10069441066666666667e-2 * t3310 - 0.73082791466666666667e-3 * t3312 - 0.1298352e-1 * t919 * t206 - 0.2596704e-1 * t344 * t529 - t3319;
  t3333 = -0.1096241872e-2 * t3048 + t3052 + t3054 - 0.14616558293333333334e-2 * t3056 + t3059 - 0.151041616e-2 * t3064 - 0.1096241872e-2 * t3066 - 0.302083232e-2 * t3068 - 0.70284698645333333332e-3 * t3070 - 0.51011788443733333332e-3 * t3072 - 0.2192483744e-2 * t3074 - 0.18511871078506666667e-3 * t3076 - 0.20138882133333333334e-2 * t3078 - 0.14616558293333333334e-2 * t3080;
  t3342 = -0.20138882133333333334e-2 * t3083 + t3087 + t3089 - 0.70284698645333333332e-3 * t3123 - t3127 - t3129 - 0.51011788443733333332e-3 * t3130 - t3133 - 0.151041616e-2 * t3135 - 0.18511871078506666667e-3 * t3137 - t3140 - 0.1298352e-1 * t3141 - 0.2596704e-1 * t3143 - 0.1298352e-1 * t3146;
  tv4rho3lapl2 = t3289 + t3320 + t3333 + t3342;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t3346 = 0.2596704e-1 * t14 * t16 * t1417;
  t3348 = 0.2596704e-1 * t940 * t532;
  t3350 = 0.2596704e-1 * t340 * t1301;
  t3352 = 0.2596704e-1 * t228 * t1395;
  t3358 = 0.302083232e-2 * t91 * t496 * t1417;
  t3360 = t198 * t1200 * t571;
  t3362 = t198 * t1400;
  t3365 = 0.2192483744e-2 * t91 * t1418;
  t3366 = t198 * t572;
  t3372 = t171 * t322;
  t3392 = t1395 * t99;
  t3393 = t231 * t3392;
  t3395 = -t3346 - t3348 - t3350 - t3352 - 0.1298352e-1 * t3149 - 0.2596704e-1 * t3151 - 0.1298352e-1 * t3154 - t3358 - 0.35142349322666666666e-3 * t3360 - 0.25505894221866666666e-3 * t3362 - t3365 - 0.92559355392533333333e-4 * t3366 - 0.1298352e-1 * t97 * t199 * (-t863 * t52 / 0.64e2 + 0.5e1 / 0.192e3 * t303 * t171 - 0.25e2 / 0.108e3 * t3372 * t323 - 0.25e2 / 0.72e2 * t1409 * t327 - 0.5e1 / 0.108e3 * t3177 * t185 * t323 - 0.5e1 / 0.18e2 * t1326 * t871 + 0.5e1 / 0.36e2 * t1326 * t2093 - 0.5e1 / 0.24e2 * t544 * t83 + 0.5e1 / 0.8e1 * t544 * t659) - 0.10069441066666666667e-2 * t3393;
  t3396 = t14 * t3392;
  t3403 = 0.302083232e-2 * t248 * t1400;
  t3405 = 0.2192483744e-2 * t248 * t572;
  t3406 = t505 * t214;
  t3410 = t913 * t1296;
  t3412 = t340 * t1296;
  t3419 = 0.302083232e-2 * t924 * t537;
  t3421 = 0.2192483744e-2 * t924 * t214;
  t3423 = 0.302083232e-2 * t347 * t1317;
  t3424 = -0.73082791466666666667e-3 * t3396 - 0.1298352e-1 * t245 * t572 - 0.2596704e-1 * t87 * t1418 - t3403 - t3405 - 0.92559355392533333333e-4 * t3406 - 0.1298352e-1 * t152 * t1332 - 0.10069441066666666667e-2 * t3410 - 0.73082791466666666667e-3 * t3412 - 0.1298352e-1 * t919 * t214 - 0.2596704e-1 * t344 * t548 - t3419 - t3421 - t3423;
  t3426 = t505 * t1312;
  t3428 = t505 * t537;
  t3431 = 0.2192483744e-2 * t347 * t548;
  t3437 = -0.35142349322666666666e-3 * t3426 - 0.25505894221866666666e-3 * t3428 - t3431 - 0.20138882133333333334e-2 * t3158 - 0.14616558293333333334e-2 * t3160 - 0.20138882133333333334e-2 * t3163 + t3167 + t3169 + t3172 + t3174 - 0.70284698645333333332e-3 * t3190 - t3194 - t3196 - 0.51011788443733333332e-3 * t3197;
  t3449 = -t3201 - 0.151041616e-2 * t3203 - 0.18511871078506666667e-3 * t3205 - t3208 - 0.1096241872e-2 * t3209 - 0.14616558293333333334e-2 * t3211 + t3214 - 0.151041616e-2 * t3219 - 0.1096241872e-2 * t3221 - 0.302083232e-2 * t3223 - 0.70284698645333333332e-3 * t3225 - 0.51011788443733333332e-3 * t3227 - 0.2192483744e-2 * t3229 - 0.18511871078506666667e-3 * t3231;
  tv4rho3lapl3 = t3395 + t3424 + t3437 + t3449;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t3451 = t950 * t509;
  t3454 = t14 * t16 * t1438;
  t3456 = t340 * t1352;
  t3460 = t955 * t514;
  t3462 = t955 * t206;
  t3489 = t91 * t496 * t1438;
  t3491 = t91 * t1439;
  t3493 = -0.1298352e-1 * t3451 - 0.1298352e-1 * t3454 - 0.2596704e-1 * t3456 - t3235 - t3238 - t3240 - t3242 - 0.1298352e-1 * t420 * t529 - 0.151041616e-2 * t3460 - 0.1096241872e-2 * t3462 - 0.1298352e-1 * t87 * t1439 - 0.1298352e-1 * t97 * t199 * (-t987 * t35 / 0.64e2 + 0.5e1 / 0.192e3 * t437 * t113 - 0.25e2 / 0.108e3 * t3103 * t463 - 0.5e1 / 0.108e3 * t3108 * t463 * t135 + 0.5e1 / 0.18e2 * t1285 * t1019 - 0.25e2 / 0.72e2 * t1282 * t431 + 0.5e1 / 0.36e2 * t1285 * t431 * t135 + 0.5e1 / 0.24e2 * t525 * t1029) - 0.151041616e-2 * t3489 - 0.1096241872e-2 * t3491;
  t3498 = t347 * t1357;
  t3500 = t347 * t558;
  t3509 = -0.2596704e-1 * t344 * t558 - 0.2596704e-1 * t152 * t1374 - 0.30208323199999999999e-2 * t3498 - 0.2192483744e-2 * t3500 - 0.1298352e-1 * t961 * t206 - t3244 - t3246 - 0.70284698645333333331e-3 * t3247 - 0.51011788443733333333e-3 * t3249 - t3252 - 0.18511871078506666667e-3 * t3253 - 0.20138882133333333332e-2 * t3285 - 0.14616558293333333333e-2 * t3287 - t3295;
  t3518 = -t3297 - t3300 - 0.70284698645333333331e-3 * t3302 - 0.51011788443733333333e-3 * t3304 - t3307 - 0.18511871078506666667e-3 * t3308 - 0.20138882133333333332e-2 * t3310 - 0.14616558293333333333e-2 * t3312 - t3319 + t3052 + t3054 - 0.73082791466666666667e-3 * t3056 + t3059 - 0.35142349322666666666e-3 * t3070;
  t3527 = -0.25505894221866666666e-3 * t3072 - 0.92559355392533333333e-4 * t3076 - 0.10069441066666666667e-2 * t3078 - 0.73082791466666666667e-3 * t3080 - 0.10069441066666666667e-2 * t3083 + t3087 + t3089 - 0.35142349322666666666e-3 * t3123 - t3127 - t3129 - 0.25505894221866666666e-3 * t3130 - t3133 - 0.92559355392533333333e-4 * t3137 - t3140;
  tv4rho3lapl4 = t3493 + t3509 + t3518 + t3527;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t3529 = t347 * t572;
  t3535 = t955 * t537;
  t3537 = t955 * t214;
  t3547 = t455 * t71;
  t3569 = t91 * t496 * t1466;
  t3571 = t91 * t1467;
  t3577 = t347 * t1400;
  t3580 = t14 * t16 * t1466;
  t3582 = t340 * t1395;
  t3584 = -0.2192483744e-2 * t3529 - 0.1298352e-1 * t961 * t214 - 0.1298352e-1 * t420 * t548 - 0.151041616e-2 * t3535 - 0.1096241872e-2 * t3537 - 0.1298352e-1 * t87 * t1467 - 0.1298352e-1 * t97 * t199 * (-t1005 * t52 / 0.64e2 + 0.5e1 / 0.96e2 * t385 * t171 - 0.5e1 / 0.72e2 * t126 * t455 + 0.25e2 / 0.27e2 * t3547 * t139 - 0.25e2 / 0.54e2 * t3372 * t1412 + 0.25e2 / 0.36e2 * t1409 * t238 - 0.5e1 / 0.108e3 * t3177 * t474 * t139 - 0.5e1 / 0.18e2 * t1326 * t1044 + 0.5e1 / 0.36e2 * t1326 * t478 * t139 + 0.5e1 / 0.24e2 * t544 * t1051) - 0.151041616e-2 * t3569 - 0.1096241872e-2 * t3571 - 0.2596704e-1 * t344 * t572 - 0.2596704e-1 * t152 * t1418 - 0.30208323199999999999e-2 * t3577 - 0.1298352e-1 * t3580 - 0.2596704e-1 * t3582;
  t3591 = -t3346 - t3348 - t3350 - t3352 - t3358 - 0.70284698645333333331e-3 * t3360 - 0.51011788443733333333e-3 * t3362 - t3365 - 0.18511871078506666667e-3 * t3366 - 0.20138882133333333332e-2 * t3393 - 0.14616558293333333333e-2 * t3396 - t3403 - t3405 - 0.18511871078506666667e-3 * t3406;
  t3600 = -0.20138882133333333332e-2 * t3410 - 0.14616558293333333333e-2 * t3412 - t3419 - t3421 - t3423 - 0.70284698645333333331e-3 * t3426 - 0.51011788443733333333e-3 * t3428 - t3431 - 0.10069441066666666667e-2 * t3158 - 0.73082791466666666667e-3 * t3160 - 0.10069441066666666667e-2 * t3163 + t3167 + t3169 + t3172;
  t3608 = t950 * t532;
  t3610 = t3174 - 0.35142349322666666666e-3 * t3190 - t3194 - t3196 - 0.25505894221866666666e-3 * t3197 - t3201 - 0.92559355392533333333e-4 * t3205 - t3208 - 0.73082791466666666667e-3 * t3211 + t3214 - 0.35142349322666666666e-3 * t3225 - 0.25505894221866666666e-3 * t3227 - 0.92559355392533333333e-4 * t3231 - 0.1298352e-1 * t3608;
  tv4rho3lapl5 = t3584 + t3591 + t3600 + t3610;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t3628 = -0.3895056e-1 * t3451 - 0.3895056e-1 * t3454 - 0.7790112e-1 * t3456 - 0.453124848e-2 * t3460 - 0.3288725616e-2 * t3462 - 0.453124848e-2 * t3489 - 0.3288725616e-2 * t3491 - 0.90624969599999999999e-2 * t3498 - 0.6577451232e-2 * t3500 - 0.105427047968e-2 * t3247 - 0.76517682665599999999e-3 * t3249 - 0.2776780661776e-3 * t3253 - 0.30208323199999999999e-2 * t3285 - 0.2192483744e-2 * t3287 - 0.105427047968e-2 * t3302 - 0.76517682665599999999e-3 * t3304;
  t3650 = -0.2776780661776e-3 * t3308 - 0.30208323199999999999e-2 * t3310 - 0.2192483744e-2 * t3312 + t3052 + t3054 + t3059 + t3087 + t3089 - t3127 - t3129 - t3133 - t3140 - 0.1298352e-1 * t97 * t199 * (-t1093 * t35 / 0.64e2 - 0.5e1 / 0.108e3 * t3108 * t1123 + 0.5e1 / 0.12e2 * t1285 * t2628 + 0.5e1 / 0.24e2 * t525 * t1130) - 0.3895056e-1 * t152 * t1439 - 0.1298352e-1 * t1161 * t206 - 0.3895056e-1 * t420 * t558;
  tv4rho3lapl6 = t3628 + t3650;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t3667 = -0.6577451232e-2 * t3529 - 0.453124848e-2 * t3535 - 0.3288725616e-2 * t3537 - 0.453124848e-2 * t3569 - 0.3288725616e-2 * t3571 - 0.90624969599999999999e-2 * t3577 - 0.3895056e-1 * t3580 - 0.7790112e-1 * t3582 - 0.105427047968e-2 * t3360 - 0.76517682665599999999e-3 * t3362 - 0.2776780661776e-3 * t3366 - 0.30208323199999999999e-2 * t3393 - 0.2192483744e-2 * t3396 - 0.2776780661776e-3 * t3406 - 0.30208323199999999999e-2 * t3410 - 0.2192483744e-2 * t3412;
  t3693 = -t1106 * t52 / 0.64e2 + 0.5e1 / 0.64e2 * t448 * t171 - 0.5e1 / 0.24e2 * t166 * t455 + 0.55e2 / 0.216e3 * t48 * t1115 - 0.55e2 / 0.27e2 * t1115 * t72 + 0.25e2 / 0.9e1 * t3547 * t185 - 0.25e2 / 0.36e2 * t3372 * t474 - 0.25e2 / 0.24e2 * t1409 * t478 - 0.5e1 / 0.108e3 * t3177 * t1142 + 0.5e1 / 0.12e2 * t1326 * t2641 + 0.5e1 / 0.24e2 * t544 * t1149;
  t3703 = -0.105427047968e-2 * t3426 - 0.76517682665599999999e-3 * t3428 + t3167 + t3169 + t3172 + t3174 - t3194 - t3196 - t3201 - t3208 + t3214 - 0.3895056e-1 * t3608 - 0.1298352e-1 * t97 * t199 * t3693 - 0.3895056e-1 * t152 * t1467 - 0.1298352e-1 * t1161 * t214 - 0.3895056e-1 * t420 * t572;
  tv4rho3lapl7 = t3667 + t3703;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t3704 = t1490 * t592;
  t3706 = t1490 * t588;
  t3708 = t14 * t62;
  t3710 = 0.11569919424066666668e-4 * t3708 * t220;
  t3711 = t752 * t13;
  t3716 = t757 * t93;
  t3717 = t3716 * t220;
  t3719 = t757 * t13;
  t3720 = t3719 * t220;
  t3724 = t1498 * t588;
  t3726 = t1501 * t588;
  t3732 = t1498 * t592;
  t3734 = 0.45676744666666666667e-3 * t3704 - 0.274060468e-3 * t3706 + t3710 - 0.162294e-2 * t3711 * t220 - 0.486882e-2 * t1493 * t588 - 0.56640605999999999997e-3 * t3717 - 0.411090702e-3 * t3720 - 0.486882e-2 * t578 * t1518 - 0.113281212e-2 * t3724 - 0.822181404e-3 * t3726 + 0.81147e-2 * t1493 * t592 + 0.162294e-1 * t578 * t1476 + 0.18880201999999999999e-2 * t3732;
  t3735 = t1501 * t592;
  t3737 = t581 * t1476;
  t3739 = t1506 * t592;
  t3741 = t1509 * t592;
  t3743 = t584 * t1476;
  t3745 = t1514 * t592;
  t3750 = t584 * t1480;
  t3762 = 0.16782401777777777777e-3 * t1485 * t31 * t35 * t262;
  t3763 = t14 * t262;
  t3765 = 0.12180465244444444444e-3 * t3763 * t220;
  t3768 = 0.137030234e-2 * t3735 + 0.18880201999999999999e-2 * t3737 + 0.21963968326666666665e-3 * t3739 + 0.15941183888666666666e-3 * t3741 + 0.137030234e-2 * t3743 + 0.57849597120333333334e-4 * t3745 + 0.81147e-2 * t217 * t1517 * t591 - 0.18270697866666666666e-2 * t3750 - 0.216392e-1 * t217 * t587 * t1479 + 0.26447911111111111111e-1 * t217 * t218 * t30 * t675 + t3762 + t3765 - 0.216392e-1 * t578 * t1480;
  t3771 = t1700 * t93 * t592;
  t3773 = t581 * t1480;
  t3775 = t495 * t13;
  t3777 = 0.97688686337202888891e-6 * t3775 * t220;
  t3782 = t492 * t254;
  t3783 = t3782 * t220;
  t3785 = t492 * t93;
  t3786 = t3785 * t220;
  t3788 = t492 * t13;
  t3789 = t3788 * t220;
  t3791 = t581 * t1518;
  t3793 = t1506 * t588;
  t3795 = t1509 * t588;
  t3797 = t495 * t628;
  t3799 = 0.15330849892013333332e-4 * t3797 * t220;
  t3800 = t495 * t254;
  t3802 = 0.11126946354289333332e-4 * t3800 * t220;
  t3803 = t495 * t93;
  t3805 = 0.40379018789992666666e-5 * t3803 * t220;
  t3806 = 0.62934006666666666666e-3 * t3771 - 0.25173602666666666666e-2 * t3773 - t3777 - 0.162294e-2 * t217 * t16 * t665 * t219 - 0.13178380995999999999e-3 * t3783 - 0.95647103331999999996e-4 * t3786 - 0.347097582722e-4 * t3789 - 0.56640605999999999997e-3 * t3791 - 0.13178380995999999999e-3 * t3793 - 0.95647103331999999996e-4 * t3795 - t3799 - t3802 - t3805;
  t3807 = t584 * t1518;
  t3809 = t1514 * t588;
  t3811 = t766 * t16;
  t3812 = t3811 * t1487;
  t3815 = t1485 * t108 * t1486;
  t3817 = t772 * t16;
  t3821 = 0.43927936653333333329e-4 * t3817 * t31 * t35 * t62;
  t3822 = t231 * t62;
  t3824 = 0.31882367777333333333e-4 * t3822 * t220;
  t3825 = t228 * t99;
  t3826 = t3825 * t220;
  t3828 = t575 * t1274;
  t3830 = t778 * t16;
  t3831 = t3830 * t201;
  t3833 = t1521 * t519;
  t3835 = t1521 * t521;
  t3837 = t575 * t1276;
  t3839 = t575 * t1278;
  t3841 = -0.411090702e-3 * t3807 - 0.347097582722e-4 * t3809 - 0.37760403999999999999e-3 * t3812 - 0.37760403999999999999e-3 * t3815 + t3821 + t3824 - 0.274060468e-3 * t3826 - 0.486882e-2 * t3828 - 0.486882e-2 * t3831 - 0.973764e-2 * t3833 + 0.162294e-1 * t3835 + 0.162294e-1 * t3837 - 0.216392e-1 * t3839;
  tv4rho3tau0 = t3734 + t3768 + t3806 + t3841;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t3846 = 0.16782401777777777777e-3 * t1485 * t48 * t52 * t262;
  t3848 = 0.12180465244444444444e-3 * t3763 * t225;
  t3850 = 0.97688686337202888891e-6 * t3775 * t225;
  t3851 = t584 * t1555;
  t3857 = t1501 * t604;
  t3859 = t3788 * t225;
  t3863 = t1506 * t604;
  t3866 = 0.15330849892013333332e-4 * t3797 * t225;
  t3868 = 0.11126946354289333332e-4 * t3800 * t225;
  t3869 = t1509 * t604;
  t3872 = 0.40379018789992666666e-5 * t3803 * t225;
  t3873 = t581 * t1555;
  t3875 = t1514 * t604;
  t3877 = t3825 * t225;
  t3879 = t3846 + t3848 - t3850 - 0.411090702e-3 * t3851 - 0.162294e-2 * t217 * t16 * t694 * t224 - 0.822181404e-3 * t3857 - 0.347097582722e-4 * t3859 - 0.486882e-2 * t578 * t1555 - 0.13178380995999999999e-3 * t3863 - t3866 - t3868 - 0.95647103331999999996e-4 * t3869 - t3872 - 0.56640605999999999997e-3 * t3873 - 0.347097582722e-4 * t3875 - 0.274060468e-3 * t3877;
  t3881 = t1485 * t126 * t1528;
  t3886 = 0.43927936653333333329e-4 * t3817 * t48 * t52 * t62;
  t3888 = 0.31882367777333333333e-4 * t3822 * t225;
  t3889 = t1490 * t604;
  t3892 = 0.11569919424066666668e-4 * t3708 * t225;
  t3897 = t3716 * t225;
  t3899 = t3719 * t225;
  t3901 = t1498 * t604;
  t3903 = t3782 * t225;
  t3905 = t3785 * t225;
  t3907 = t3811 * t1529;
  t3909 = t3830 * t209;
  t3911 = t1521 * t542;
  t3913 = t575 * t1324;
  t3915 = -0.37760403999999999999e-3 * t3881 + t3886 + t3888 - 0.274060468e-3 * t3889 + t3892 - 0.162294e-2 * t3711 * t225 - 0.486882e-2 * t1493 * t604 - 0.56640605999999999997e-3 * t3897 - 0.411090702e-3 * t3899 - 0.113281212e-2 * t3901 - 0.13178380995999999999e-3 * t3903 - 0.95647103331999999996e-4 * t3905 - 0.37760403999999999999e-3 * t3907 - 0.486882e-2 * t3909 - 0.973764e-2 * t3911 - 0.486882e-2 * t3913;
  tv4rho3tau1 = t3879 + t3915;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t3926 = t581 * t1560;
  t3928 = t505 * t254;
  t3929 = t3928 * t220;
  t3931 = t505 * t93;
  t3932 = t3931 * t220;
  t3934 = t505 * t13;
  t3935 = t3934 * t220;
  t3937 = t1506 * t611;
  t3939 = t1509 * t611;
  t3941 = t1514 * t611;
  t3944 = t913 * t16 * t1487;
  t3946 = t340 * t99;
  t3947 = t3946 * t220;
  t3949 = t919 * t13;
  t3954 = t924 * t93;
  t3956 = 0.37760403999999999998e-3 * t3954 * t220;
  t3957 = t924 * t13;
  t3959 = 0.274060468e-3 * t3957 * t220;
  t3963 = 0.37760403999999999998e-3 * t1578 * t588;
  t3965 = 0.274060468e-3 * t1581 * t588;
  t3966 = -0.72130666666666666667e-2 * t607 * t1480 - 0.72130666666666666667e-2 * t217 * t610 * t1479 + 0.54098e-2 * t578 * t1560 + 0.54098e-2 * t217 * t1565 * t591 + 0.62934006666666666664e-3 * t3926 - 0.4392793665333333333e-4 * t3929 - 0.31882367777333333332e-4 * t3932 - 0.11569919424066666667e-4 * t3935 - 0.4392793665333333333e-4 * t3937 - 0.31882367777333333332e-4 * t3939 - 0.11569919424066666667e-4 * t3941 - 0.12586801333333333333e-3 * t3944 - 0.91353489333333333333e-4 * t3947 - 0.162294e-2 * t3949 * t220 - 0.324588e-2 * t1573 * t588 - t3956 - t3959 - 0.162294e-2 * t607 * t1518 - t3963 - t3965;
  t3967 = t584 * t1560;
  t3970 = t1485 * t159 * t1486;
  t3972 = t1490 * t611;
  t3979 = 0.37760403999999999998e-3 * t1498 * t611;
  t3981 = 0.274060468e-3 * t1501 * t611;
  t3987 = 0.37760403999999999998e-3 * t581 * t1566;
  t3989 = 0.274060468e-3 * t584 * t1566;
  t3995 = t1578 * t592;
  t3997 = t1581 * t592;
  t4005 = 0.54098e-2 * t1573 * t592 + 0.54098e-2 * t607 * t1476 + 0.62934006666666666664e-3 * t3995 + 0.45676744666666666666e-3 * t3997 + 0.30451163111111111111e-3 * t3704 - 0.18270697866666666667e-3 * t3706 + t3710 - 0.18880201999999999999e-3 * t3717 - 0.137030234e-3 * t3720 - 0.37760403999999999998e-3 * t3724 - 0.274060468e-3 * t3726;
  t4024 = 0.62934006666666666664e-3 * t3732 + 0.45676744666666666666e-3 * t3735 + 0.62934006666666666664e-3 * t3737 + 0.1464264555111111111e-3 * t3739 + 0.10627455925777777777e-3 * t3741 + 0.45676744666666666666e-3 * t3743 + 0.38566398080222222223e-4 * t3745 - 0.60902326222222222221e-3 * t3750 + t3762 + t3765 + 0.41956004444444444443e-3 * t3771 - 0.83912008888888888885e-3 * t3773 - t3777 - 0.8785587330666666666e-4 * t3783 - 0.63764735554666666664e-4 * t3786 - 0.23139838848133333334e-4 * t3789 - 0.18880201999999999999e-3 * t3791 - 0.8785587330666666666e-4 * t3793 - 0.63764735554666666664e-4 * t3795 - t3799;
  t4038 = 0.54098e-2 * t1596 * t521;
  t4040 = 0.54098e-2 * t575 * t1364;
  t4042 = 0.324588e-2 * t1521 * t553;
  t4044 = 0.324588e-2 * t575 * t1362;
  t4045 = t940 * t16;
  t4047 = 0.324588e-2 * t4045 * t201;
  t4049 = 0.324588e-2 * t1596 * t519;
  t4050 = -0.162294e-2 * t3831 - 0.324588e-2 * t3833 + 0.54098e-2 * t3835 + 0.54098e-2 * t3837 - 0.72130666666666666667e-2 * t3839 + t4038 + t4040 - t4042 - t4044 - t4047 - t4049;
  tv4rho3tau2 = t3966 + 0.45676744666666666666e-3 * t3967 - 0.12586801333333333333e-3 * t3970 - 0.91353489333333333333e-4 * t3972 - 0.162294e-2 * t1493 * t611 - 0.324588e-2 * t578 * t1566 - t3979 - t3981 - 0.162294e-2 * t217 * t16 * t839 * t219 - t3987 - t3989 + t4005 + t4024 - t3802 - t3805 - 0.137030234e-3 * t3807 - 0.23139838848133333334e-4 * t3809 - 0.25173602666666666666e-3 * t3812 - 0.25173602666666666666e-3 * t3815 + t3821 + t3824 - 0.18270697866666666667e-3 * t3826 - 0.162294e-2 * t3828 + t4050;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t4053 = t1514 * t617;
  t4057 = t1485 * t48 * t171 * t99;
  t4059 = t1490 * t621;
  t4066 = 0.62934006666666666664e-3 * t1498 * t621;
  t4068 = 0.45676744666666666666e-3 * t1501 * t621;
  t4075 = 0.37760403999999999998e-3 * t1578 * t604;
  t4077 = 0.274060468e-3 * t1581 * t604;
  t4078 = t3928 * t225;
  t4080 = t3931 * t225;
  t4082 = t3934 * t225;
  t4085 = t1485 * t166 * t1528;
  t4087 = t1490 * t617;
  t4091 = -0.11569919424066666667e-4 * t4053 + 0.20978002222222222221e-3 * t4057 + 0.15225581555555555555e-3 * t4059 + 0.27049e-2 * t1493 * t621 + 0.54098e-2 * t578 * t1616 + t4066 + t4068 + 0.27049e-2 * t217 * t1554 * t620 - 0.162294e-2 * t607 * t1555 - t4075 - t4077 - 0.4392793665333333333e-4 * t4078 - 0.31882367777333333332e-4 * t4080 - 0.11569919424066666667e-4 * t4082 - 0.12586801333333333333e-3 * t4085 - 0.91353489333333333333e-4 * t4087 - 0.162294e-2 * t1493 * t617;
  t4095 = 0.37760403999999999998e-3 * t1498 * t617;
  t4097 = 0.274060468e-3 * t1501 * t617;
  t4103 = 0.37760403999999999998e-3 * t3954 * t225;
  t4105 = 0.274060468e-3 * t3957 * t225;
  t4107 = t2210 * t93 * t225;
  t4109 = t3946 * t225;
  t4112 = 0.62934006666666666664e-3 * t581 * t1616;
  t4114 = 0.45676744666666666666e-3 * t584 * t1616;
  t4115 = t1506 * t621;
  t4117 = t1509 * t621;
  t4119 = t1514 * t621;
  t4126 = 0.37760403999999999998e-3 * t581 * t1607;
  t4128 = 0.274060468e-3 * t584 * t1607;
  t4129 = t1506 * t617;
  t4131 = -0.324588e-2 * t578 * t1607 - t4095 - t4097 - 0.162294e-2 * t3949 * t225 - 0.324588e-2 * t1573 * t604 - t4103 - t4105 - 0.12586801333333333333e-3 * t4107 - 0.91353489333333333333e-4 * t4109 + t4112 + t4114 + 0.7321322775555555555e-4 * t4115 + 0.53137279628888888886e-4 * t4117 + 0.19283199040111111111e-4 * t4119 - 0.162294e-2 * t217 * t16 * t862 * t224 - t4126 - t4128 - 0.4392793665333333333e-4 * t4129;
  t4133 = t1509 * t617;
  t4144 = -0.31882367777333333332e-4 * t4133 + t3846 + t3848 - t3850 - 0.137030234e-3 * t3851 - 0.274060468e-3 * t3857 - 0.23139838848133333334e-4 * t3859 - 0.8785587330666666666e-4 * t3863 - t3866 - t3868 - 0.63764735554666666664e-4 * t3869 - t3872 - 0.18880201999999999999e-3 * t3873 - 0.23139838848133333334e-4 * t3875 - 0.18270697866666666667e-3 * t3877 - 0.25173602666666666666e-3 * t3881 + t3886;
  t4153 = 0.324588e-2 * t4045 * t209;
  t4155 = 0.324588e-2 * t1521 * t563;
  t4157 = 0.324588e-2 * t575 * t1405;
  t4159 = 0.54098e-2 * t1521 * t565;
  t4161 = 0.54098e-2 * t575 * t1407;
  t4166 = 0.324588e-2 * t1596 * t542;
  t4167 = t3888 - 0.18270697866666666667e-3 * t3889 + t3892 - 0.18880201999999999999e-3 * t3897 - 0.137030234e-3 * t3899 - 0.37760403999999999998e-3 * t3901 - 0.8785587330666666666e-4 * t3903 - 0.63764735554666666664e-4 * t3905 - 0.25173602666666666666e-3 * t3907 - t4153 - t4155 - t4157 + t4159 + t4161 - 0.162294e-2 * t3909 - 0.324588e-2 * t3911 - 0.162294e-2 * t3913 - t4166;
  tv4rho3tau3 = t4091 + t4131 + t4144 + t4167;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t4173 = t581 * t1653;
  t4175 = t584 * t1653;
  t4181 = t1578 * t611;
  t4183 = t1581 * t611;
  t4185 = t961 * t13;
  t4190 = t955 * t93;
  t4191 = t4190 * t220;
  t4193 = t955 * t13;
  t4194 = t4193 * t220;
  t4207 = -0.162294e-2 * t217 * t16 * t986 * t219 - 0.18880201999999999999e-3 * t4173 - 0.137030234e-3 * t4175 - 0.324588e-2 * t1573 * t611 - 0.324588e-2 * t607 * t1566 - 0.37760403999999999999e-3 * t4181 - 0.274060468e-3 * t4183 - 0.162294e-2 * t4185 * t220 - 0.162294e-2 * t1643 * t588 - 0.18880201999999999999e-3 * t4191 - 0.137030234e-3 * t4194 + 0.27049e-2 * t217 * t1652 * t591 + 0.54098e-2 * t607 * t1560 + 0.27049e-2 * t1643 * t592 - 0.162294e-2 * t578 * t1653 + 0.62934006666666666663e-3 * t3926 - 0.87855873306666666659e-4 * t3929;
  t4218 = -0.63764735554666666664e-4 * t3932 - 0.23139838848133333333e-4 * t3935 - 0.87855873306666666659e-4 * t3937 - 0.63764735554666666664e-4 * t3939 - 0.23139838848133333333e-4 * t3941 - 0.25173602666666666666e-3 * t3944 - 0.18270697866666666667e-3 * t3947 - t3956 - t3959 - t3963 - t3965 + 0.45676744666666666667e-3 * t3967 - 0.25173602666666666666e-3 * t3970 - 0.18270697866666666667e-3 * t3972 - t3979 - t3981 - t3987 - t3989;
  t4233 = 0.62934006666666666663e-3 * t3995 + 0.45676744666666666667e-3 * t3997 + 0.15225581555555555556e-3 * t3704 - 0.91353489333333333333e-4 * t3706 + t3710 + 0.7321322775555555555e-4 * t3739 + 0.53137279628888888887e-4 * t3741 + 0.19283199040111111112e-4 * t3745 + t3762 + t3765 + 0.20978002222222222222e-3 * t3771 - t3777 - 0.4392793665333333333e-4 * t3783 - 0.31882367777333333332e-4 * t3786 - 0.11569919424066666667e-4 * t3789 - 0.4392793665333333333e-4 * t3793 - 0.31882367777333333332e-4 * t3795;
  t4238 = t575 * t1432;
  t4240 = t1596 * t553;
  t4242 = t950 * t16;
  t4243 = t4242 * t201;
  t4245 = -t3799 - t3802 - t3805 - 0.11569919424066666667e-4 * t3809 - 0.12586801333333333333e-3 * t3812 - 0.12586801333333333333e-3 * t3815 + t3821 + t3824 - 0.91353489333333333333e-4 * t3826 - 0.162294e-2 * t4238 - 0.324588e-2 * t4240 - 0.162294e-2 * t4243 + t4038 + t4040 - t4042 - t4044 - t4047 - t4049;
  tv4rho3tau4 = t4207 + t4218 + t4233 + t4245;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t4251 = t1578 * t617;
  t4253 = t1581 * t617;
  t4259 = t1578 * t621;
  t4261 = t1581 * t621;
  t4268 = t581 * t1658;
  t4270 = t584 * t1658;
  t4277 = t581 * t1662;
  t4279 = t584 * t1662;
  t4287 = t581 * t1666;
  t4289 = t584 * t1666;
  t4291 = -0.324588e-2 * t1573 * t617 - 0.324588e-2 * t607 * t1607 - 0.37760403999999999999e-3 * t4251 - 0.274060468e-3 * t4253 + 0.54098e-2 * t1573 * t621 + 0.54098e-2 * t607 * t1616 + 0.62934006666666666665e-3 * t4259 + 0.45676744666666666666e-3 * t4261 + 0.54098e-2 * t578 * t1658 + 0.54098e-2 * t217 * t1606 * t620 + 0.62934006666666666665e-3 * t4268 + 0.45676744666666666666e-3 * t4270 - 0.72130666666666666667e-2 * t578 * t1662 - 0.72130666666666666667e-2 * t217 * t603 * t1661 - 0.83912008888888888887e-3 * t4277 - 0.60902326222222222222e-3 * t4279 - 0.162294e-2 * t578 * t1666 - 0.162294e-2 * t217 * t16 * t1004 * t224 - 0.18880201999999999999e-3 * t4287 - 0.137030234e-3 * t4289;
  t4296 = t4190 * t225;
  t4298 = t4193 * t225;
  t4310 = -t4077 - 0.87855873306666666659e-4 * t4078 - 0.63764735554666666664e-4 * t4080 - 0.23139838848133333333e-4 * t4082 - 0.25173602666666666666e-3 * t4085 - 0.18270697866666666667e-3 * t4087 - t4095 - t4097 - t4103 - t4105 - 0.25173602666666666666e-3 * t4107;
  t4323 = -0.18270697866666666667e-3 * t4109 + t4112 + t4114 + 0.1464264555111111111e-3 * t4115 + 0.10627455925777777777e-3 * t4117 + 0.38566398080222222222e-4 * t4119 - t4126 - t4128 - 0.87855873306666666659e-4 * t4129 - 0.63764735554666666664e-4 * t4133 + t3846 + t3848 - t3850 - 0.11569919424066666667e-4 * t3859 - 0.4392793665333333333e-4 * t3863 - t3866 - t3868 - 0.31882367777333333332e-4 * t3869 - t3872 - 0.11569919424066666667e-4 * t3875;
  t4331 = t575 * t1456;
  t4333 = t575 * t1452;
  t4335 = t4242 * t209;
  t4337 = t1596 * t563;
  t4339 = t1596 * t565;
  t4341 = t575 * t1454;
  t4343 = -t4155 - t4157 + t4159 + t4161 - 0.72130666666666666667e-2 * t4331 - 0.162294e-2 * t4333 - 0.162294e-2 * t4335 - 0.324588e-2 * t4337 + 0.54098e-2 * t4339 + 0.54098e-2 * t4341 - t4166;
  tv4rho3tau5 = t4291 - 0.162294e-2 * t4185 * t225 - 0.162294e-2 * t1643 * t604 - 0.18880201999999999999e-3 * t4296 - 0.137030234e-3 * t4298 - 0.23139838848133333333e-4 * t4053 + 0.41956004444444444444e-3 * t4057 + 0.30451163111111111111e-3 * t4059 + t4066 + t4068 - t4075 + t4310 + t4323 - 0.91353489333333333333e-4 * t3877 - 0.12586801333333333333e-3 * t3881 + t3886 + t3888 - 0.91353489333333333333e-4 * t3889 + t3892 - 0.4392793665333333333e-4 * t3903 - 0.31882367777333333332e-4 * t3905 - 0.12586801333333333333e-3 * t3907 - t4153 + t4343;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t4350 = t1161 * t13;
  t4369 = -0.162294e-2 * t217 * t16 * t1092 * t219 - 0.162294e-2 * t4350 * t220 - 0.486882e-2 * t1643 * t611 - 0.486882e-2 * t607 * t1653 - 0.56640605999999999997e-3 * t4173 - 0.411090702e-3 * t4175 - 0.113281212e-2 * t4181 - 0.822181404e-3 * t4183 - 0.56640605999999999997e-3 * t4191 - 0.411090702e-3 * t4194 - 0.13178380995999999999e-3 * t3929 - 0.95647103331999999996e-4 * t3932 - 0.347097582722e-4 * t3935 - 0.13178380995999999999e-3 * t3937 - 0.95647103331999999996e-4 * t3939 - 0.347097582722e-4 * t3941;
  t4377 = -0.37760403999999999999e-3 * t3944 - 0.274060468e-3 * t3947 - 0.37760403999999999999e-3 * t3970 - 0.274060468e-3 * t3972 + t3710 + t3762 + t3765 - t3777 - t3799 - t3802 - t3805 + t3821 + t3824 - 0.486882e-2 * t4238 - 0.973764e-2 * t4240 - 0.486882e-2 * t4243;
  tv4rho3tau6 = t4369 + t4377;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t4407 = -0.486882e-2 * t607 * t1666 - 0.162294e-2 * t217 * t16 * t1105 * t224 - 0.162294e-2 * t4350 * t225 - 0.486882e-2 * t1643 * t617 + 0.81147e-2 * t1643 * t621 + 0.162294e-1 * t607 * t1658 + 0.81147e-2 * t217 * t1665 * t620 - 0.216392e-1 * t607 * t1662 - 0.216392e-1 * t217 * t616 * t1661 + 0.26447911111111111111e-1 * t217 * t223 * t30 * t1115 - 0.113281212e-2 * t4251 - 0.822181404e-3 * t4253 + 0.18880201999999999999e-2 * t4259;
  t4421 = 0.137030234e-2 * t4261 + 0.18880201999999999999e-2 * t4268 + 0.137030234e-2 * t4270 - 0.25173602666666666666e-2 * t4277 - 0.18270697866666666666e-2 * t4279 - 0.56640605999999999997e-3 * t4287 - 0.411090702e-3 * t4289 - 0.56640605999999999997e-3 * t4296 - 0.411090702e-3 * t4298 - 0.347097582722e-4 * t4053 + 0.62934006666666666666e-3 * t4057 + 0.45676744666666666667e-3 * t4059 - 0.13178380995999999999e-3 * t4078;
  t4434 = -0.95647103331999999996e-4 * t4080 - 0.347097582722e-4 * t4082 - 0.37760403999999999999e-3 * t4085 - 0.274060468e-3 * t4087 - 0.37760403999999999999e-3 * t4107 - 0.274060468e-3 * t4109 + 0.21963968326666666665e-3 * t4115 + 0.15941183888666666666e-3 * t4117 + 0.57849597120333333334e-4 * t4119 - 0.13178380995999999999e-3 * t4129 - 0.95647103331999999996e-4 * t4133 + t3846 + t3848;
  t4441 = -t3850 - t3866 - t3868 - t3872 + t3886 + t3888 + t3892 - 0.216392e-1 * t4331 - 0.486882e-2 * t4333 - 0.486882e-2 * t4335 - 0.973764e-2 * t4337 + 0.162294e-1 * t4339 + 0.162294e-1 * t4341;
  tv4rho3tau7 = t4407 + t4421 + t4434 + t4441;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  tv4rho2sigma25 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  tv4rho2sigma26 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  tv4rho2sigma211 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  tv4rho2sigma212 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  tv4rho2sigma217 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  tv4rhosigma30 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  tv4rhosigma39 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  tv4rhosigma310 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  tv4rhosigma319 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  tv4sigma40 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  tv4sigma414 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

