# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_render_window import OpenGLRenderWindow


class XOpenGLRenderWindow(OpenGLRenderWindow):
    r"""
    XOpenGLRenderWindow - open_gl rendering window
    
    Superclass: OpenGLRenderWindow
    
    XOpenGLRenderWindow is a concrete implementation of the abstract
    class RenderWindow. OpenGLRenderer interfaces to the open_gl
    graphics library. Application programmers should normally use
    RenderWindow instead of the open_gl specific version.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXOpenGLRenderWindow, obj, update, **traits)
    
    current_cursor = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Change the shape of the cursor
        """
    )

    def _current_cursor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurrentCursor,
                        self.current_cursor)

    position = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 0), cols=2, desc=\
        r"""
        Set the position (x and y) of the rendering window in screen
        coordinates (in pixels). This resizes the operating system's
        view/window and redraws it.
        """
    )

    def _position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPosition,
                        self.position)

    size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 0), cols=2, desc=\
        r"""
        Set the size (width and height) of the rendering window in screen
        coordinates (in pixels). This resizes the operating system's
        view/window and redraws it.
        
        If the size has changed, this method will fire
        Command::WindowResizeEvent.
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    window_name = traits.String('Visualization Toolkit - OpenGL', enter_set=True, auto_set=False, desc=\
        r"""
        Set name of rendering window.
        """
    )

    def _window_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWindowName,
                        self.window_name)

    def _get_desired_depth(self):
        return self._vtk_obj.GetDesiredDepth()
    desired_depth = traits.Property(_get_desired_depth, desc=\
        r"""
        
        """
    )

    def _get_desired_visual_info(self):
        return wrap_vtk(self._vtk_obj.GetDesiredVisualInfo())
    desired_visual_info = traits.Property(_get_desired_visual_info, desc=\
        r"""
        
        """
    )

    def pref_full_screen(self):
        """
        pref_full_screen(self) -> None
        C++: virtual void pref_full_screen()
        Set the preferred window size to full screen.
        """
        ret = self._vtk_obj.PrefFullScreen()
        return ret
        

    def set_size_no_x_resize(self, *args):
        """
        set_size_no_x_resize(self, __a:int, __b:int) -> None
        C++: void set_size_no_x_resize(int, int)
        Specify the size of the rendering window in pixels but do not
        resize the XWindow. Useful when resizing is done interactively.
        """
        ret = self._wrap_call(self._vtk_obj.SetSizeNoXResize, *args)
        return ret

    def window_initialize(self):
        """
        window_initialize(self) -> None
        C++: virtual void window_initialize()
        Initialize the window for rendering.
        """
        ret = self._vtk_obj.WindowInitialize()
        return ret
        

    _updateable_traits_ = \
    (('borders', 'GetBorders'), ('full_screen', 'GetFullScreen'),
    ('is_picking', 'GetIsPicking'), ('line_smoothing',
    'GetLineSmoothing'), ('point_smoothing', 'GetPointSmoothing'),
    ('polygon_smoothing', 'GetPolygonSmoothing'), ('stencil_capable',
    'GetStencilCapable'), ('stereo_capable_window',
    'GetStereoCapableWindow'), ('stereo_render', 'GetStereoRender'),
    ('swap_buffers', 'GetSwapBuffers'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('double_buffer', 'GetDoubleBuffer'),
    ('erase', 'GetErase'), ('off_screen_rendering',
    'GetOffScreenRendering'), ('show_window', 'GetShowWindow'),
    ('use_off_screen_buffers', 'GetUseOffScreenBuffers'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('frame_blit_mode', 'GetFrameBlitMode'), ('stereo_type',
    'GetStereoType'), ('current_cursor', 'GetCurrentCursor'), ('position',
    'GetPosition'), ('size', 'GetSize'), ('window_name', 'GetWindowName'),
    ('global_maximum_number_of_multi_samples',
    'GetGlobalMaximumNumberOfMultiSamples'), ('abort_render',
    'GetAbortRender'), ('alpha_bit_planes', 'GetAlphaBitPlanes'),
    ('anaglyph_color_mask', 'GetAnaglyphColorMask'),
    ('anaglyph_color_saturation', 'GetAnaglyphColorSaturation'),
    ('cursor_file_name', 'GetCursorFileName'), ('desired_update_rate',
    'GetDesiredUpdateRate'), ('device_index', 'GetDeviceIndex'),
    ('in_abort_check', 'GetInAbortCheck'), ('multi_samples',
    'GetMultiSamples'), ('number_of_layers', 'GetNumberOfLayers'), ('dpi',
    'GetDPI'), ('tile_scale', 'GetTileScale'), ('tile_viewport',
    'GetTileViewport'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['borders', 'debug', 'double_buffer', 'erase', 'full_screen',
    'global_warning_display', 'is_picking', 'line_smoothing',
    'off_screen_rendering', 'point_smoothing', 'polygon_smoothing',
    'show_window', 'stencil_capable', 'stereo_capable_window',
    'stereo_render', 'swap_buffers', 'use_off_screen_buffers',
    'use_srgb_color_space', 'frame_blit_mode', 'stereo_type',
    'abort_render', 'alpha_bit_planes', 'anaglyph_color_mask',
    'anaglyph_color_saturation', 'current_cursor', 'cursor_file_name',
    'desired_update_rate', 'device_index', 'dpi',
    'global_maximum_number_of_multi_samples', 'in_abort_check',
    'multi_samples', 'number_of_layers', 'position', 'size', 'tile_scale',
    'tile_viewport', 'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XOpenGLRenderWindow, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XOpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['borders', 'double_buffer', 'erase', 'full_screen',
            'is_picking', 'line_smoothing', 'off_screen_rendering',
            'point_smoothing', 'polygon_smoothing', 'show_window',
            'stencil_capable', 'stereo_capable_window', 'stereo_render',
            'swap_buffers', 'use_off_screen_buffers', 'use_srgb_color_space'],
            ['frame_blit_mode', 'stereo_type'], ['abort_render',
            'alpha_bit_planes', 'anaglyph_color_mask',
            'anaglyph_color_saturation', 'current_cursor', 'cursor_file_name',
            'desired_update_rate', 'device_index', 'dpi',
            'global_maximum_number_of_multi_samples', 'in_abort_check',
            'multi_samples', 'number_of_layers', 'position', 'size', 'tile_scale',
            'tile_viewport', 'window_name']),
            title='Edit XOpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XOpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

