/*    
 *    MediathekView
 *    Copyright (C) 2008   W. Xaver
 *    W.Xaver[at]googlemail.com
 *    http://zdfmediathk.sourceforge.net/
 *    
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui.dialog;

import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.file.GetFile;
import mediathek.gui.HyperlinkButton;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.tool.EscapeKeyHandler;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.net.URISyntaxException;

@SuppressWarnings("serial")
public class DialogNewSet extends JDialog {
    public boolean ok = false;
    public boolean morgen = true;
    private final JFrame parent;

    public DialogNewSet(JFrame pparent) {
        super(pparent, true);
        initComponents();
        parent = pparent;
        if (parent != null) {
            setLocationRelativeTo(parent);
        }
        setTitle("Das Standardset wurde aktualisiert");
        jTextArea3.setText('\n'
                + "   Es gibt ein neues Standardset der Videoplayer\n"
                + "   für den Download und das Abspielen der Filme.\n");
        jCheckBoxMorgen.setSelected(true);
        jCheckBoxMorgen.addActionListener(e -> morgen = jCheckBoxMorgen.isSelected());

        jTextArea1.setText('\n'
                + "   Die bestehenden Einstellungen werden nicht verändert.\n"
                + "   Das neue Set wird nur angefügt und muss dann erst noch in den\n"
                + "   \"Datei->Einstellungen->Set bearbeiten\"\n"
                + "   aktiviert werden.\n");

        jTextArea2.setText('\n'
                + "   Es werden alle Programmsets (auch eigene) \n"
                + "   gelöscht und die neuen Standardsets wieder angelegt.\n"
                + '\n'
                + "   (Wenn Sie die Einstellungen nicht verändert haben\n"
                + "    ist das die Empfehlung)");
        try {
            hyperlinkButton.setAction(new UrlHyperlinkAction(pparent, Konstanten.ADRESSE_ANLEITUNG));
        } catch (URISyntaxException ignored) {
        }
        jButtonAdd.addActionListener(e -> {
            ok = true;
            beenden();
        });
        jButtonAbbrechen.addActionListener(e -> {
            ok = false;
            beenden();
        });
        jButtonReplace.addActionListener(e -> {
            int ret = JOptionPane.showConfirmDialog(parent, "Alle Sets zurücksetzen?", "Alle Sets zurücksetzen!", JOptionPane.YES_NO_OPTION);
            if (ret == JOptionPane.OK_OPTION) {
                Daten.listePset.clear();
                ok = true;
                beenden();
            }
        });
        jButtonSetHelp.setIcon(Icons.ICON_BUTTON_HELP);
        jButtonSetHelp.addActionListener(e -> new DialogHilfe(parent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_RESET_SET)).setVisible(true));

        EscapeKeyHandler.installHandler(this, () -> {
            ok = false;
            dispose();
        });

        pack();
    }

    private void beenden() {
        this.dispose();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    // Generated using JFormDesigner non-commercial license
    private void initComponents() {
        jButtonAbbrechen = new JButton();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel7 = new JLabel();
        hyperlinkButton = new HyperlinkButton();
        jCheckBoxMorgen = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        jTextArea1 = new JTextArea();
        jButtonAdd = new JButton();
        JPanel jPanel4 = new JPanel();
        jButtonReplace = new JButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        jTextArea2 = new JTextArea();
        JScrollPane jScrollPane3 = new JScrollPane();
        jTextArea3 = new JTextArea();
        jButtonSetHelp = new JButton();

        //======== this ========
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        Container contentPane = getContentPane();

        //---- jButtonAbbrechen ----
        jButtonAbbrechen.setText("Abbrechen");

        //======== jPanel1 ========
        {
            jPanel1.setBorder(new TitledBorder(""));

            //---- jLabel7 ----
            jLabel7.setText("Anleitung:");

            //---- hyperlinkButton ----
            hyperlinkButton.setText("text");

            GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
            jPanel1.setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(
                    jPanel1Layout.createParallelGroup()
                            .addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addComponent(jLabel7)
                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(hyperlinkButton, GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)
                                    .addGap(335, 335, 335))
            );
            jPanel1Layout.setVerticalGroup(
                    jPanel1Layout.createParallelGroup()
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER)
                                            .addComponent(jLabel7)
                                            .addComponent(hyperlinkButton, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .addContainerGap(11, Short.MAX_VALUE))
            );
        }

        //---- jCheckBoxMorgen ----
        jCheckBoxMorgen.setSelected(true);
        jCheckBoxMorgen.setText("Morgen wieder fragen");

        //======== jPanel3 ========
        {
            jPanel3.setBorder(new TitledBorder(null, "Entweder", TitledBorder.LEADING, TitledBorder.DEFAULT_POSITION, null, new Color(0, 102, 204)));

            //======== jScrollPane1 ========
            {

                //---- jTextArea1 ----
                jTextArea1.setEditable(false);
                jTextArea1.setColumns(20);
                jTextArea1.setRows(5);
                jScrollPane1.setViewportView(jTextArea1);
            }

            //---- jButtonAdd ----
            jButtonAdd.setText("Neue Sets hinzuf\u00fcgen");

            GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
            jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(
                    jPanel3Layout.createParallelGroup()
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addGroup(jPanel3Layout.createParallelGroup()
                                            .addComponent(jScrollPane1)
                                            .addGroup(jPanel3Layout.createSequentialGroup()
                                                    .addComponent(jButtonAdd)
                                                    .addGap(0, 0, Short.MAX_VALUE)))
                                    .addContainerGap())
            );
            jPanel3Layout.setVerticalGroup(
                    jPanel3Layout.createParallelGroup()
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addComponent(jScrollPane1, GroupLayout.DEFAULT_SIZE, 99, Short.MAX_VALUE)
                                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                    .addComponent(jButtonAdd)
                                    .addContainerGap())
            );
        }

        //======== jPanel4 ========
        {
            jPanel4.setBorder(new TitledBorder(null, "Oder", TitledBorder.LEADING, TitledBorder.DEFAULT_POSITION, null, new Color(0, 102, 204)));

            //---- jButtonReplace ----
            jButtonReplace.setText("Bestehende Sets durch die neuen ersetzen");

            //======== jScrollPane2 ========
            {

                //---- jTextArea2 ----
                jTextArea2.setEditable(false);
                jTextArea2.setColumns(20);
                jTextArea2.setRows(5);
                jScrollPane2.setViewportView(jTextArea2);
            }

            GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
            jPanel4.setLayout(jPanel4Layout);
            jPanel4Layout.setHorizontalGroup(
                    jPanel4Layout.createParallelGroup()
                            .addGroup(jPanel4Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addGroup(jPanel4Layout.createParallelGroup()
                                            .addGroup(jPanel4Layout.createSequentialGroup()
                                                    .addComponent(jButtonReplace)
                                                    .addGap(0, 243, Short.MAX_VALUE))
                                            .addComponent(jScrollPane2))
                                    .addContainerGap())
            );
            jPanel4Layout.setVerticalGroup(
                    jPanel4Layout.createParallelGroup()
                            .addGroup(jPanel4Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addComponent(jScrollPane2, GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE)
                                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                    .addComponent(jButtonReplace)
                                    .addGap(13, 13, 13))
            );
        }

        //======== jScrollPane3 ========
        {

            //---- jTextArea3 ----
            jTextArea3.setEditable(false);
            jTextArea3.setBackground(new Color(244, 244, 244));
            jTextArea3.setColumns(20);
            jTextArea3.setRows(3);
            jScrollPane3.setViewportView(jTextArea3);
        }

        //---- jButtonSetHelp ----
        jButtonSetHelp.setIcon(new ImageIcon(getClass().getResource("/mediathek/res/muster/button-help.png")));
        jButtonSetHelp.setToolTipText("Hilfe anzeigen");

        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(
                contentPaneLayout.createParallelGroup()
                        .addGroup(contentPaneLayout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(contentPaneLayout.createParallelGroup()
                                        .addComponent(jPanel1, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(jPanel3, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(jPanel4, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(jScrollPane3)
                                        .addGroup(contentPaneLayout.createSequentialGroup()
                                                .addComponent(jCheckBoxMorgen)
                                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                                .addComponent(jButtonAbbrechen)
                                                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                                .addComponent(jButtonSetHelp)))
                                .addContainerGap())
        );
        contentPaneLayout.setVerticalGroup(
                contentPaneLayout.createParallelGroup()
                        .addGroup(contentPaneLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(jPanel1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jScrollPane3, GroupLayout.PREFERRED_SIZE, 75, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jPanel3, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jPanel4, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                .addGroup(contentPaneLayout.createParallelGroup()
                                        .addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                                                .addComponent(jButtonAbbrechen)
                                                .addComponent(jCheckBoxMorgen))
                                        .addComponent(jButtonSetHelp))
                                .addContainerGap())
        );
        pack();
        setLocationRelativeTo(getOwner());
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // Generated using JFormDesigner non-commercial license
    private JButton jButtonAbbrechen;
    private HyperlinkButton hyperlinkButton;
    private JCheckBox jCheckBoxMorgen;
    private JTextArea jTextArea1;
    private JButton jButtonAdd;
    private JButton jButtonReplace;
    private JTextArea jTextArea2;
    private JTextArea jTextArea3;
    private JButton jButtonSetHelp;
    // End of variables declaration//GEN-END:variables

}
