; $Id: reflection_numbers_thms.scm 2156 2008-01-25 13:25:12Z schimans $

(display "

Begin of reflection_numbers_thms.scm

")




; SOME DEFINITIONS

(begin

; PosToNat embedds the pos into nat

(add-program-constant "PosToNat" (py "pos=>nat") 1)
(acrs
 "PosToNat One"         "Succ Zero"
 "PosToNat (SZero pos)" "NatPlus (PosToNat pos) (PosToNat pos)"
 "PosToNat (SOne  pos)" "Succ (PosToNat(SZero pos))")

; NatToPos embedds the pos into nat whereby the value increases by 1

(add-program-constant "NatToPos" (py "nat=>pos") 1)
(acrs
 "NatToPos Zero"       "One"
 "NatToPos (Succ nat)" "(NatToPos nat)+1")

) ; matches begin




; SOME PROPERTIES

(begin

(sg "pos+pos=SZero pos")
(ind)
(auto)
(assume "pos" "IH")
(ng)
(simp-with "IH")
(use "Truth-Axiom")
; Proof finished.
(arw "pos+pos" "SZero pos")


; PosPred2n
(sg "(1<pos) impb ((PosPred(SZero pos))=SOne(PosPred pos))")
(cases)
(auto)
; Proof finished.
(save "PosPred2n")
(display-theorems "PosPred2n")


; SPosPred
(sg "(1<pos) impb S(PosPred pos)=pos")
(cases)
    (use-with "Truth-Axiom")
  (ind)
    (use-with "Truth-Axiom")
(auto)
; Proof finished.
(save "SPosPred")
(display-theorems "SPosPred")


(sg "PosPred(S pos)=pos")
(ind)
(auto)
(assume "pos" "IH")
(ng)
(cut(pf"PosPred(SZero(S pos))=SOne(PosPred(S pos))"))
(simp-with  "IH")
(search)
(use-with "PosPred2n" (pt "S pos") "?")
(use "Truth-Axiom")
; Proof finshed
(arw "PosPred(S pos)" "pos")


(sg "PosPred(SZero(S pos))=SOne pos")
(assume "pos")
(use-with "PosPred2n" (pt "S pos") "?")
(use-with "Truth-Axiom")
; Proof finshed
(arw "PosPred(SZero(S pos))" "SOne pos")


(sg "PosToNat(S pos)=Succ(PosToNat pos)")
(ind)
    (use "Truth-Axiom")
  (strip)
  (use "Truth-Axiom")
(assume "pos" "IH")
(ng)
(simp "IH")
(use "Truth-Axiom")
; Proof finished.
(arw "PosToNat(S pos)" "Succ(PosToNat pos)")


(sg "NatToPos(NatPlus nat nat) = PosPred(SZero(NatToPos nat))")
(ind)
    (use-with "Truth-Axiom")
(assume "nat" "IH")
(ng)
(simp-with "IH")
(ng)
(simp-with (pf"S(PosPred(SZero(NatToPos nat)))=SZero(NatToPos nat)"))
(use "Truth-Axiom")
(use-with "SPosPred" (pt"(SZero(NatToPos nat))") "?")
(use "Truth-Axiom")
; Proof finished.
(arw "NatToPos(NatPlus nat nat)" "PosPred(SZero(NatToPos nat))")


(sg "NatToPos(PosToNat pos)=S pos")
(ind)
    (use "Truth-Axiom")
  (assume "pos" "IH")
  (ng)
  (simp-with "IH")
  (use "Truth-Axiom")
(assume "pos" "IH")
(ng)
(simp-with "IH")
(use "Truth-Axiom")
; Proof finshed
(arw "NatToPos(PosToNat pos)" "S pos")


(sg "PosPred(SZero pos)<SZero pos")
(ind)
(auto)
; Proof finshed
(arw "PosPred(SZero pos)<SZero pos" "True")


(sg "(PosPred pos<pos)=(1<pos)")
(cases)
(auto)
; Proof finshed
(arw "(PosPred pos<pos)" "(1<pos)")


(sg "(1<NatToPos nat)=(NatLt Zero nat)")
(cases)
(auto)
; Proof finshed
(arw "(1<NatToPos nat)" "(NatLt Zero nat)")


(sg "(NatLt Zero (NatPlus nat1 nat2))
   = ((NatLt Zero nat1) orb (NatLt Zero nat2))")
(cases)
(auto)
; Proof finshed
(arw "(NatLt Zero (NatPlus nat1 nat2))"
    "((NatLt Zero nat1) orb (NatLt Zero nat2))")


(sg "NatLt Zero(PosToNat pos)")
(ind)
(auto)
; Proof finshed
(arw "NatLt Zero(PosToNat pos)" "True")


(sg "S(PosPred(SZero pos))=SZero pos")
(ind)
(auto)
; Proof finshed
(arw "S(PosPred(SZero pos))" "SZero pos")


(sg "1<pos1+pos2")
(cases)
(search)
(assume "pos1")
(cases)
(auto)
(assume "pos1")
(cases)
(auto)
; Proof finshed
(arw "1<pos1+pos2" "True")


(sg "all pos1.(SZero pos1)+pos2+pos2=SZero(pos1+pos2)")
(cases)
(auto)
; Proof finshed
(arw "(SZero pos1)+pos2+pos2" "SZero(pos1+pos2)")


(sg "all pos1.(1<pos1) impb (PosPred(pos1+pos2)=(PosPred pos1)+pos2)")
(ind)
    (cases)
    (auto)
  (assume "pos2" "IH2")
  (ind)
      (use-with "Truth-Axiom")
    (assume "pos1" "IH1")
    (ng)
    (simp-with "IH2" (pt "(SZero pos1)+pos2"))
    (simp-with "IH2" (pt "(SZero pos1)"))
  (auto)
(assume "pos2" "IH2" "pos1" "1<1")
(ng)
(assert (pf"PosPred(pos1+pos2)=PosPred pos1+pos2"))
(use-with  "IH2" (pt"pos1") "?")
(use-with "1<1")
(assume "*")
(simp "<-" "*")
(inst-with-to  "IH2" (pt"pos1+pos2") "!")
(simp "<-" "!")
(drop "IH2" "1<1" "*" "!")
(inst-with-to "SPosPred" (pt"pos1+pos2+pos2")"§")
(ng)
(simp-with "§")
(use-with "Truth-Axiom")
; Proof finshed
(save "PosPredPlus")
(display-theorems "PosPredPlus")


(sg "NatToPos(NatPlus nat1 nat2)
   = PosPred((NatToPos nat1)+(NatToPos nat2))")
(ind)
    (search)
(assume "nat1" "IH" "nat2")
(ng)
(simp-with "IH" (pt "nat2"))
(use-with "SPosPred" (pt "(NatToPos nat1+NatToPos nat2)"))
; Proof finshed
(arw "NatToPos(NatPlus nat1 nat2)"
     "PosPred((NatToPos nat1)+(NatToPos nat2))")


(sg "2+pos=S(S pos)")
(cases)
(auto)
; Proof finished.
(arw  "2+pos" "S(S pos)")


(sg "all pos1.(SOne pos1)+pos2=S((pos1+pos1)+pos2)")
(cases)
(auto)
; Proof finished.
(arw "(SOne pos1)+pos2" "S((pos1+pos1)+pos2)")


(sg "all pos1.PosToNat(PosPlus pos1 pos2)
              =NatPlus (PosToNat pos1) (PosToNat pos2)")
(assert
 (pf"all pos1.
     all pos2 PosToNat(pos2+pos1)
             =NatPlus(PosToNat pos2)(PosToNat pos1)
 ->  all pos2 PosToNat(pos2+pos1+pos1)
     = NatPlus(NatPlus(PosToNat pos2)(PosToNat pos1))(PosToNat pos1)"))
(assume "pos1" "!" "pos2")
(simp-with "!" (pt"pos2+pos1"))
(simp-with "!" (pt"pos2"))
(use-with "Truth-Axiom")
(assume "*")
(ind)
(auto)
; Proof finished.
(arw "PosToNat(PosPlus pos1 pos2)"
     "NatPlus (PosToNat pos1) (PosToNat pos2)")


(sg "(NatLe(PosToNat pos)Zero)=False")
(ind)
(auto)
; Proof finished
(arw "(NatLe(PosToNat pos)Zero)" "False")


(sg "NatLe(NatPlus nat nat)(Succ Zero)=(negb(NatLt Zero nat))")
(cases)
(auto)
; Proof finished
(arw "NatLe(NatPlus nat nat)(Succ Zero)" "(negb(NatLt Zero nat))")


(sg "PosToNat(n*k)=NatTimes(PosToNat n)(PosToNat k)")
(ind)
    (search)
  (assume "n" "IH" "k")
  (ng)
  (simp "IH")
  (use-with "Truth-Axiom")
(assume "n" "IH" "k")
(ng)
(simp "IH")
(use-with "Truth-Axiom")
; Proof finished 
(arw "PosToNat(n*k)" "NatTimes(PosToNat n)(PosToNat k)")


)  ; matches begin
