<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## mermaidAPI

This is the api to be used when optionally handling the integration with the web page, instead of using the default integration provided by mermaid.js.

The core of this api is the [**render**][1] function which, given a graph
definition as text, renders the graph/diagram and returns an svg element for the graph.

It is is then up to the user of the API to make use of the svg, either insert it somewhere in the page or do something completely different.

In addition to the render function, a number of behavioral configuration options are available.

## setSiteConfig

## setSiteConfig

| Function      | Description                           | Type        | Values                                  |
| ------------- | ------------------------------------- | ----------- | --------------------------------------- |
| setSiteConfig | Sets the siteConfig to desired values | Put Request | Any Values, except ones in secure array |

**Notes:**
Sets the siteConfig. The siteConfig is a protected configuration for repeat use. Calls to reset() will reset
the currentConfig to siteConfig. Calls to reset(configApi.defaultConfig) will reset siteConfig and currentConfig
to the defaultConfig
Note: currentConfig is set in this function
\*Default value: At default, will mirror Global Config\*\*

### Parameters

-   `conf`  the base currentConfig to use as siteConfig

Returns **any** the siteConfig

## getSiteConfig

## getSiteConfig

| Function      | Description                                       | Type        | Values                            |
| ------------- | ------------------------------------------------- | ----------- | --------------------------------- |
| setSiteConfig | Returns the current siteConfig base configuration | Get Request | Returns Any Values  in siteConfig |

**Notes**:
Returns **any** values in siteConfig.

Returns **any** 

## setConfig

## setConfig

| Function      | Description                           | Type        | Values                                  |
| ------------- | ------------------------------------- | ----------- | --------------------------------------- |
| setSiteConfig | Sets the siteConfig to desired values | Put Request | Any Values, except ones in secure array |

**Notes**:
Sets the currentConfig. The parameter conf is sanitized based on the siteConfig.secure keys. Any
values found in conf with key found in siteConfig.secure will be replaced with the corresponding
siteConfig value.

### Parameters

-   `conf`  the potential currentConfig

Returns **any** the currentConfig merged with the sanitized conf

## getConfig

## getConfig

| Function  | Description               | Type        | Return Values                 |
| --------- | ------------------------- | ----------- | ----------------------------- |
| getConfig | Obtains the currentConfig | Get Request | Any Values from currentConfig |

**Notes**:
Returns **any** the currentConfig

Returns **any** the currentConfig

## sanitize

## sanitize

| Function | Description                            | Type        | Values |
| -------- | -------------------------------------- | ----------- | ------ |
| sanitize | Sets the siteConfig to desired values. | Put Request | None   |

Ensures options parameter does not attempt to override siteConfig secure keys
Note: modifies options in-place

### Parameters

-   `options`  the potential setConfig parameter

## reset

## reset

| Function | Description                  | Type        | Required | Values |
| -------- | ---------------------------- | ----------- | -------- | ------ |
| reset    | Resets currentConfig to conf | Put Request | Required | None   |

| Parameter | Description                                                   | Type       | Required | Values                                       |
| --------- | ------------------------------------------------------------- | ---------- | -------- | -------------------------------------------- |
| conf      | base set of values, which currentConfig coul be **reset** to. | Dictionary | Required | Any Values, with respect to the secure Array |

\*Notes :
(default: current siteConfig ) (optional, default `getSiteConfig()`)

### Parameters

-   `conf`  the base currentConfig to reset to (default: current siteConfig ) (optional, default `getSiteConfig()`)

## render

Function that renders an svg with a graph from a chart definition. Usage example below.

```js
mermaidAPI.initialize({
     startOnLoad:true
 });
 $(function(){
     const graphDefinition = 'graph TB\na-->b';
     const cb = function(svgGraph){
         console.log(svgGraph);
     };
     mermaidAPI.render('id1',graphDefinition,cb);
 });
```

### Parameters

-   `id`  the id of the element to be rendered
-   `_txt`  the graph definition
-   `cb`  callback which is called after rendering is finished with the svg code as inparam.
-   `container`  selector to element in which a div with the graph temporarily will be inserted. In one is
    provided a hidden div will be inserted in the body of the page instead. The element will be removed when rendering is
    completed.

## 

## mermaidAPI configuration defaults

<pre>

&lt;script>
  var config = {
    theme:'default',
    logLevel:'fatal',
    securityLevel:'strict',
    startOnLoad:true,
    arrowMarkerAbsolute:false,

    er:{
      diagramPadding:20,
      layoutDirection:'TB',
      minEntityWidth:100,
      minEntityHeight:75,
      entityPadding:15,
      stroke:'gray',
      fill:'honeydew',
      fontSize:12,
      useMaxWidth:true,
    },
    flowchart:{
      diagramPadding:8,
      htmlLabels:true,
      curve:'linear',
    },
    sequence:{
      diagramMarginX:50,
      diagramMarginY:10,
      actorMargin:50,
      width:150,
      height:65,
      boxMargin:10,
      boxTextMargin:5,
      noteMargin:10,
      messageMargin:35,
      messageAlign:'center',
      mirrorActors:true,
      bottomMarginAdj:1,
      useMaxWidth:true,
      rightAngles:false,
      showSequenceNumbers:false,
    },
    gantt:{
      titleTopMargin:25,
      barHeight:20,
      barGap:4,
      topPadding:50,
      leftPadding:75,
      gridLineStartPadding:35,
      fontSize:11,
      fontFamily:'"Open-Sans", "sans-serif"',
      numberSectionStyles:4,
      axisFormat:'%Y-%m-%d',
    }
  };
  mermaid.initialize(config);
&lt;/script>
</pre>

[1]: Setup.md?id=render
