<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Minimum Natural Logarithm

> [Natural logarithm][natural-logarithm] of the smallest **normalized** [double-precision floating-point number][ieee754].

<section class="usage">

## Usage

```javascript
var FLOAT64_MIN_LN = require( '@stdlib/constants/float64/min-ln' );
```

#### FLOAT64_MIN_LN

[Natural logarithm][natural-logarithm] of the smallest **normalized** [double-precision floating-point number][ieee754].

```javascript
var bool = ( FLOAT64_MIN_LN === -708.3964185322641 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better example -->

<!-- eslint no-undef: "error" -->

```javascript
var FLOAT64_MIN_LN = require( '@stdlib/constants/float64/min-ln' );

console.log( FLOAT64_MIN_LN );
// => -708.3964185322641
```

</section>

<!-- /.examples -->

<section class="links">

[ieee754]: http://en.wikipedia.org/wiki/IEEE_754-1985

[natural-logarithm]: https://en.wikipedia.org/wiki/Natural_logarithm

</section>

<!-- /.links -->
