!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!                                                                      *
! Copyright (C) 2017, Quan Phung                                       *
!***********************************************************************
! Load text file 2RDM generated by DICE
! Written by Quan Phung, Leuven, 2017
!                        Nagoya, 2022

subroutine dice_load2pdm(NAC,PT,CHEMROOT)

use Constants, only: Zero
use Definitions, only: wp, iwp, u6

implicit none
integer(kind=iwp), intent(in) :: NAC, CHEMROOT
real(kind=wp), intent(out) :: PT(NAC,NAC,NAC,NAC)
integer(kind=iwp) :: idx1, idx2, idx3, idx4, ierr, nact, lu
real(kind=wp) :: PTtemp
character(len=30) :: file_2rdm
character(len=10) :: rootindex
logical(kind=iwp) :: irdm
integer(kind=iwp), external :: isFreeUnit

! Check 2RDM file
write(rootindex,'(i2)') chemroot-1
file_2rdm = 'spatialRDM.'//trim(adjustl(rootindex))//'.'//trim(adjustl(rootindex))//'.txt'
file_2rdm = trim(adjustl(file_2rdm))
call f_inquire(file_2rdm,irdm)
if (.not. irdm) then
  write(u6,'(1x,a15,i3,a16)') 'DICE> Root: ',CHEMROOT,' :: No 2RDM file'
  call abend()
end if

LU = isFreeUnit(40)
call molcas_open(LU,file_2rdm)

read(LU,*) nact
if (nact /= NAC) then
  write(u6,*) 'DICE: DB> Wrong number of active orbitals'
  call abend()
end if

! Dice ignores all elements smaller than 1.0e-15
! Read until EOF
PT(:,:,:,:) = Zero
do
  read(LU,*,IOSTAT=ierr) idx1,idx2,idx3,idx4,PTtemp
  if (ierr /= 0) exit
  PT(idx1+1,idx3+1,idx4+1,idx2+1) = PTtemp
end do

close(LU)

end subroutine
