/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TextBlockGeneric
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final HColor background;
    private final HColor border;

    public TextBlockGeneric(TextBlock textBlock, HColor background, HColor border) {
        this.textBlock = textBlock;
        this.border = border;
        this.background = background;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(this.background.bg());
        ug = ug.apply(this.border);
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        ug.apply(new UStroke(2.0, 2.0, 1.0)).draw(new URectangle(dim.getWidth(), dim.getHeight()));
        this.textBlock.drawU(ug);
    }
}

