# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_ARGUMENT = "InvalidArgument"
    """Invalid argument error"""
    UNAUTHORIZED = "Unauthorized"
    """Unauthorized access error"""
    FORBIDDEN = "Forbidden"
    """Forbidden access error"""
    NOT_FOUND = "NotFound"
    """Not found error"""
    PROJECT_NOT_FOUND = "ProjectNotFound"
    """Project not found error"""
    OPERATION_NOT_FOUND = "OperationNotFound"
    """Operation not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_INDEX_NOT_FOUND = "AzureCognitiveSearchIndexNotFound"
    """Azure Cognitive Search index not found error"""
    TOO_MANY_REQUESTS = "TooManyRequests"
    """Too many requests error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    AZURE_COGNITIVE_SEARCH_INDEX_LIMIT_REACHED = "AzureCognitiveSearchIndexLimitReached"
    """Azure Cognitive Search index limit reached error"""
    INTERNAL_SERVER_ERROR = "InternalServerError"
    """Internal server error"""
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    """Service unavailable error"""
    TIMEOUT = "Timeout"
    """Timeout error"""
    QUOTA_EXCEEDED = "QuotaExceeded"
    """Quota exceeded error"""
    CONFLICT = "Conflict"
    """Conflict error"""
    WARNING = "Warning"
    """Warning error"""


class InnerErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_PARAMETER_VALUE = "InvalidParameterValue"
    """Invalid parameter value error"""
    KNOWLEDGE_BASE_NOT_FOUND = "KnowledgeBaseNotFound"
    """Knowledge base not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    EXTRACTION_FAILURE = "ExtractionFailure"
    """Extraction failure error"""
    INVALID_REQUEST_BODY_FORMAT = "InvalidRequestBodyFormat"
    """Invalid request body format error"""
    EMPTY_REQUEST = "EmptyRequest"
    """Empty request error"""
    MISSING_INPUT_DOCUMENTS = "MissingInputDocuments"
    """Missing input documents error"""
    INVALID_DOCUMENT = "InvalidDocument"
    """Invalid document error"""
    MODEL_VERSION_INCORRECT = "ModelVersionIncorrect"
    """Model version incorrect error"""
    INVALID_DOCUMENT_BATCH = "InvalidDocumentBatch"
    """Invalid document batch error"""
    UNSUPPORTED_LANGUAGE_CODE = "UnsupportedLanguageCode"
    """Unsupported language code error"""
    INVALID_COUNTRY_HINT = "InvalidCountryHint"
    """Invalid country hint error"""


class LogicalOperationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Set to 'OR' or 'AND' for using corresponding logical operation."""

    AND = "AND"
    """'AND' for using corresponding logical operation."""
    OR = "OR"
    """Set 'OR' for using corresponding logical operation."""


class MatchingPolicyFieldsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Fields to be considred for matching policy."""

    QUESTIONS = "Questions"
    """Include 'Questions' field"""
    ANSWER = "Answer"
    """Include 'Answer' field"""


class MatchingPolicyKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of matching policy to be used."""

    PREBUILT = "Prebuilt"
    """Prebuilt weights will be used for giving preference to question and answer columns when quering
    AI search"""


class RankerKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ranker to be used."""

    QUESTION_ONLY = "QuestionOnly"
    """Question only ranker."""
    DEFAULT = "Default"
    """Default ranker."""


class Scorer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of scorer to be used."""

    CLASSIC = "Classic"
    """Set this value for scoring based on classic algorithms like wordnet, tfidf, ngram etc."""
    TRANSFORMER = "Transformer"
    """Set this value for scoring based on transformer based models."""
    SEMANTIC = "Semantic"
    """Set this scorer to use AI search semantic based ranking. Semantic ranking should be configured
    for this to be used."""


class StringIndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the method used to interpret string offsets.  Defaults to Text
    Elements (Graphemes) according to Unicode v8.0.0. For additional information
    see `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_.
    """

    TEXT_ELEMENTS_V8 = "TextElements_v8"
    """Returned offset and length values will correspond to TextElements (Graphemes
    and Grapheme clusters) confirming to the Unicode 8.0.0 standard. Use this
    option if your application is written in .Net Framework or .Net Core and you
    will be using StringInfo."""
    UNICODE_CODE_POINT = "UnicodeCodePoint"
    """Returned offset and length values will correspond to Unicode code points. Use
    this option if your application is written in a language that support Unicode,
    for example Python."""
    UTF16_CODE_UNIT = "Utf16CodeUnit"
    """Returned offset and length values will correspond to UTF-16 code units. Use
    this option if your application is written in a language that support Unicode,
    for example Java, JavaScript."""
