% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_interpolate.R
\name{aw_interpolate}
\alias{aw_interpolate}
\title{Interpolate Values}
\usage{
aw_interpolate(.data, tid, source, sid, weight = "sum", output = "sf", extensive,
    intensive)
}
\arguments{
\item{.data}{A \code{sf} object that data should be interpolated to (this is referred
to as the \code{target} elsewhere in the package).}

\item{tid}{A unique identification number within \code{target}}

\item{source}{A \code{sf} object with data to be interpolated}

\item{sid}{A unique identification number within \code{source}}

\item{weight}{For \code{"extensive"} interpolations, should be either \code{"total"} or
\code{"sum"}. For \code{"intensive"} interpolations, should be \code{"sum"}. For mixed
interpolations, this will only impact the calculation of the extensive variables.}

\item{output}{One of either \code{"sf"} or \code{"tibble"}}

\item{extensive}{A vector of quoted variable names to be treated as spatially extensive
(e.g. population counts); optional if \code{intensive} is specified}

\item{intensive}{A vector of quoted variable names to be treated as spatially intensive
(e.g. population density); optional if \code{extensive} is specified}
}
\value{
A \code{sf} object or a \code{tibble} with the value or values interpolated into
    the \code{target} data.
}
\description{
This is the core function within the package for areal weighted
    interpolation. It validates both data sources before interpolating one or more
    listed values from the source data into the target data.
}
\details{
Areal weighted interpolation can be used for generating demographic
    estimates for overlapping but incongruent polygon features. It assumes that
    individual members of a population are evenly dispersed within the source features
    (an assumption not likely to hold in the real world). It also functions best
    when data are in a projected coordinate system, like the UTM coordinate system.
}
\examples{
aw_interpolate(ar_stl_wards, tid = WARD, source = ar_stl_race, sid = GEOID, weight = "sum",
    output = "sf", extensive = "TOTAL_E")

aw_interpolate(ar_stl_wards, tid = WARD, source = ar_stl_asthma, sid = GEOID, weight = "sum",
    output = "tibble", intensive = "ASTHMA")

}
\seealso{
\link{c}
}
