% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/press.R
\name{press}
\alias{press}
\title{Run setup code and benchmarks across a grid of parameters}
\usage{
press(..., .grid = NULL)
}
\arguments{
\item{...}{If named, parameters to define, if unnamed the expression to run.
Only one unnamed expression is permitted.}

\item{.grid}{A pre-built grid of values to use, typically a \link{data.frame} or
\link{tibble}. This is useful if you only want to benchmark a subset of all
possible combinations.}
}
\description{
\code{press()} is used to run \code{\link[=mark]{mark()}} across a grid of parameters and
then \emph{press} the results together.

The parameters you want to set are given as named arguments and a grid of
all possible combinations is automatically created.

The code to setup and benchmark is given by one unnamed expression (often
delimited by \verb{\\\{}).

If replicates are desired a dummy variable can be used, e.g. \code{rep = 1:5} for
replicates.
}
\examples{
# Helper function to create a simple data.frame of the specified dimensions
create_df <- function(rows, cols) {
  as.data.frame(setNames(
    replicate(cols, runif(rows, 1, 1000), simplify = FALSE),
    rep_len(c("x", letters), cols)))
}

# Run 4 data sizes across 3 samples with 2 replicates (24 total benchmarks)
press(
  rows = c(1000, 10000),
  cols = c(10, 100),
  rep = 1:2,
  {
    dat <- create_df(rows, cols)
    bench::mark(
      min_time = .05,
      bracket = dat[dat$x > 500, ],
      which = dat[which(dat$x > 500), ],
      subset = subset(dat, x > 500)
    )
  }
)
}
