% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipboard.R
\name{read_clip}
\alias{read_clip}
\title{Read clipboard}
\usage{
read_clip(allow_non_interactive = Sys.getenv("CLIPR_ALLOW", interactive()))
}
\arguments{
\item{allow_non_interactive}{By default, clipr will throw an error if run in
a non-interactive session. Set the environment variable
\code{CLIPR_ALLOW=TRUE} in order to override this behavior.}
}
\value{
A character vector with the contents of the clipboard. If the system
clipboard is empty, returns NULL
}
\description{
Read the contents of the system clipboard into a character vector.
}
\note{
\code{\link[=read_clip]{read_clip()}} will not try to guess at how to parse copied text. If
you are copying tabular data, it is suggested that you use
\code{\link[=read_clip_tbl]{read_clip_tbl()}}.
}
\examples{
\dontrun{
clip_text <- read_clip()
}

}
