% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mnist.R
\name{read_mnist}
\alias{read_mnist}
\title{Download and read the mnist dataset}
\source{
http://yann.lecun.com/exdb/mnist/
}
\usage{
read_mnist()
}
\value{
A list with two components: train and test. Each of these is a list with two components: images and labels. The images component is a
matrix with each column representing one of the 28*28 = 784 pixels. The values are integers between 0 and 255 representing grey scale. 
The labels components is a vector representing the digit shown in the image.

Note that the data is over 200MB, so the download may take several seconds depending on internet speed.
}
\description{
This function downloads the mnist training and test data from http://yann.lecun.com/exdb/mnist/
}
\examples{
# this can take several seconds, depending on internet speed.
\dontrun{
mnist <- read_mnist()
i <- 5
image(1:28, 1:28, matrix(mnist$test$images[i,], nrow=28)[ , 28:1], 
    col = gray(seq(0, 1, 0.05)), xlab = "", ylab="")
## the labels for this image is: 
mnist$test$labels[i]
}

}
\references{
Y. LeCun, L. Bottou, Y. Bengio, and P. Haffner. "Gradient-based learning applied to document recognition." Proceedings of the IEEE, 86(11):2278-2324, November 1998.
}
\author{
Samuela Pollack, \email{spollack@jimmy.harvard.edu}
}
