% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{removeSessionVariables}
\alias{removeSessionVariables}
\title{Remove variables from a client session environment}
\usage{
removeSessionVariables(varNames, sessionId = NULL)
}
\arguments{
\item{varNames}{Names of variables to remove.}

\item{sessionId}{ID of the session. If there is only one active session, this argument becomes optional.}
}
\description{
This function removes variables from the environment of a client session. It allows, for instance, to unmask
a variable with the same name from the outer app environment (see \code{\link{setEnvironment}}) for the session 
(check the example below). This function
is a wrapper around method \code{sessionVariables} of the class \code{\link{Session}}.
}
\examples{
\donttest{openPage(allowedVariables = "k", sessionVars = list(k = 10))

k <- -1
getPage()$openPage(FALSE)
id1 <- getSessionIds()[1]
id2 <- getSessionIds()[2]
removeSessionVariables("k", id1)
#this changes global 'k', since the variable is no longer masked
sendCommand("jrc.sendData('k', 1)", sessionId = id1, wait = 3)
#this doesn't affect global 'k'
sendCommand("jrc.sendData('k', 5)", sessionId = id2, wait = 3)
local_k <- getSessionVariable("k", id2)

closePage()}

}
\seealso{
\code{\link{setSessionVariables}}
}
