% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trailing_blank_lines_linter.R
\name{trailing_blank_lines_linter}
\alias{trailing_blank_lines_linter}
\title{Trailing blank lines linter}
\usage{
trailing_blank_lines_linter()
}
\description{
Check that there are no trailing blank lines in source code.
}
\examples{
# will produce lints
f <- tempfile()
cat("x <- 1\n\n", file = f)
writeLines(readChar(f, file.size(f)))
lint(
  filename = f,
  linters = trailing_blank_lines_linter()
)
unlink(f)

# okay
cat("x <- 1\n", file = f)
writeLines(readChar(f, file.size(f)))
lint(
  filename = f,
  linters = trailing_blank_lines_linter()
)
unlink(f)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=default_linters]{default}, \link[=style_linters]{style}
}
