% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{step.lmerModLmerTest}
\alias{step.lmerModLmerTest}
\alias{get_model.step_list}
\title{Backward Elimination for Linear Mixed Models}
\usage{
\method{step}{lmerModLmerTest}(
  object,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  alpha.random = 0.1,
  alpha.fixed = 0.05,
  reduce.fixed = TRUE,
  reduce.random = TRUE,
  keep,
  ...
)

\method{get_model}{step_list}(x, ...)
}
\arguments{
\item{object}{a fitted model object. For the \code{lmerModLmerTest} method
an \code{\link{lmer}} model fit (of class \code{"lmerModLmerTest"}.)}

\item{ddf}{the method for computing the denominator degrees of freedom and
F-statistics. \code{ddf="Satterthwaite"} (default) uses Satterthwaite's method;
\code{ddf="Kenward-Roger"} uses Kenward-Roger's method.}

\item{alpha.random}{alpha for random effects elimination}

\item{alpha.fixed}{alpha for fixed effects elimination}

\item{reduce.fixed}{reduce fixed effect structure? \code{TRUE} by default.}

\item{reduce.random}{reduce random effect structure? \code{TRUE} by default.}

\item{keep}{an optional character vector of fixed effect terms which should
not be considered for eliminated. Valid terms are given by
\code{attr(terms(object), "term.labels")}. Terms that are marginal to terms
in keep will also not be considered for eliminations.}

\item{...}{currently not used.}

\item{x}{a step object.}
}
\value{
\code{step} returns a list with elements \code{"random"} and
\code{"fixed"} each
containing anova-like elimination tables. The \code{"fixed"} table is
based on \code{drop1} and the \code{"random"} table is
based on \code{ranova} (a \code{drop1}-like table for random effects). Both
tables have a column \code{"Eliminated"} indicating the order in which terms
are eliminated from the model with zero (\code{0}) indicating that the term
is not eliminated from the model.

The \code{step} object also contains the final model as an attribute which
is extractable with \code{get_model(<step_object>)}.
}
\description{
Backward elimination of random-effect terms followed by backward elimination
of fixed-effect terms in linear mixed models.
}
\details{
Tests of random-effects are performed using \code{\link{ranova}} (using
\code{reduce.terms = TRUE}) and tests of fixed-effects are performed using
\code{\link[=drop1.lmerModLmerTest]{drop1}}.

The step method for \code{\link{lmer}} fits has a print method.
}
\examples{

# Fit a model to the ham dataset:
fm <- lmer(Informed.liking ~ Product*Information+
             (1|Consumer) + (1|Product:Consumer)
           + (1|Information:Consumer), data=ham)

# Backward elimination using terms with default alpha-levels:
(step_res <- step(fm))
final <- get_model(step_res)
anova(final)

\dontrun{
# Fit 'big' model:
fm <- lmer(Informed.liking ~ Product*Information*Gender*Age +
             + (1|Consumer) + (1|Consumer:Product) +
             (1|Consumer:Information), data=ham)
step_fm <- step(fm)
step_fm # Display elimination results
final_fm <- get_model(step_fm)
}

}
\seealso{
\code{\link[=drop1.lmerModLmerTest]{drop1}} for tests of marginal
fixed-effect terms and \code{\link{ranova}} for a
\code{\link[=drop1.lmerModLmerTest]{drop1}}-like table of reduction of
random-effect terms.
}
\author{
Rune Haubo B. Christensen and Alexandra Kuznetsova
}
