% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad.r
\name{str_pad}
\alias{str_pad}
\title{Pad a string.}
\usage{
str_pad(string, width, side = c("left", "right", "both"), pad = " ")
}
\arguments{
\item{string}{A character vector.}

\item{width}{Minimum width of padded strings.}

\item{side}{Side on which padding character is added (left, right or both).}

\item{pad}{Single padding character (default is a space).}
}
\value{
A character vector.
}
\description{
Vectorised over \code{string}, \code{width} and \code{pad}.
}
\examples{
rbind(
  str_pad("hadley", 30, "left"),
  str_pad("hadley", 30, "right"),
  str_pad("hadley", 30, "both")
)

# All arguments are vectorised except side
str_pad(c("a", "abc", "abcdef"), 10)
str_pad("a", c(5, 10, 20))
str_pad("a", 10, pad = c("-", "_", " "))

# Longer strings are returned unchanged
str_pad("hadley", 3)
}
\seealso{
\code{\link[=str_trim]{str_trim()}} to remove whitespace;
\code{\link[=str_trunc]{str_trunc()}} to decrease the maximum width of a string.
}
