//rpld.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2014
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_RPLD_H_
#define _RPLD_RPLD_H_

#if defined(HAVE_LIB_XML2) && defined(ROAR_TARGET_WIN32)
// to work around the broken loader for DLLs disable use of libxml here.
#undef HAVE_LIB_XML2
#endif

#include <roaraudio.h>
#include <time.h>

#include "config.h"
#include "rpldnotify.h"
#include "playlist.h"
#include "fformat.h"
#include "backend.h"
#include "playback.h"
#include "proto_simple_vio.h"
#include "proto_simple.h"
#include "proto_mpd.h"
#include "client.h"
#include "network.h"
#include "store.h"
#include "autoqueue.h"
#include "yield.h"
#include "rpldslp.h"
#include "pointer.h"
#include "plugin.h"
#include "serverinfo.h"

#define APPLICATION_NAME "RoarAudio PlayList Daemon"

#if defined(ROAR_HAVE_SETGID) && defined(ROAR_HAVE_IO_POSIX)
extern struct group   * g_grp;
#endif
#if defined(ROAR_HAVE_SETUID) && defined(ROAR_HAVE_IO_POSIX)
extern struct passwd  * g_pwd;
#endif

#ifdef ROAR_TARGET_WIN32
#define __longlong long
#define __ll       "l"
#else
#define __longlong long long
#define __ll       "ll"
#endif

void rpld_exit(void);

#endif

//ll
