/*
 * Copyright 2007 Sun Microsystems, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package com.rometools.propono.atom.server;

import javax.servlet.http.HttpServletRequest;

import com.rometools.propono.atom.server.impl.FileBasedAtomHandler;

public class TestAtomHandlerImpl extends FileBasedAtomHandler {

    public TestAtomHandlerImpl(final HttpServletRequest req, final String uploaddir) {
        super(req, uploaddir);
    }

    @Override
    public boolean validateUser(final String loginId, final String password) {
        return AtomClientServerTest.USERNAME.equals(loginId) && AtomClientServerTest.PASSWORD.equals(password);
    }
}