#/* Have curl/curl.h * HAVE_CURL_CURL_H
#/* INN parsedate function present * HAVE_INN_PARSEDATE

include(CheckIncludeFile)
include(CheckFunctionExists)


check_function_exists("getopt" HAVE_GETOPT)
check_function_exists("getopt_long" HAVE_GETOPT_LONG)
check_function_exists("gettimeofday" HAVE_GETTIMEOFDAY)
check_function_exists("gmp_version" HAVE_GMP_VERSION)
check_function_exists("gmtime_r" HAVE_GMTIME_R)
check_function_exists("isascii" HAVE_ISASCII)
check_function_exists("setjmp" HAVE_SETJMP)
check_function_exists("srandomdev" HAVE_SRANDOMDEV)
check_function_exists("strcasecmp" HAVE_STRCASECMP)
check_function_exists("stricmp" HAVE_STRICMP)
check_function_exists("timegm" HAVE_TIMEGM)
check_function_exists("vsnprintf" HAVE_VSNPRINTF)
check_function_exists("xmlCtxtUseOptions" HAVE_XMLCTXTUSEOPTIONS)
check_function_exists("xmlSAX2InternalSubset" HAVE_XMLSAX2INTERNALSUBSET)


check_include_file("dlfcn.h" HAVE_DLFCN_H)
check_include_file("errno.h" HAVE_ERRNO_H)
check_include_file("expat.h" HAVE_EXPAT_H)
check_include_file("fcntl.h" HAVE_FCNTL_H)
check_include_file("fetch.h" HAVE_FETCH_H)
check_include_file("getopt.h" HAVE_GETOPT_H)
check_include_file("gmp.h" HAVE_GMP_H)
check_include_file("inttypes.h" HAVE_INTTYPES_H)
check_include_file("libxml/HTMLparser.h" HAVE_LIBXML_HTMLPARSER_H)
check_include_file("libxml/SAX2.h" HAVE_LIBXML_SAX2_H)
check_include_file("libxml/hash.h" HAVE_LIBXML_HASH_H)
check_include_file("libxml/nanohttp.h" HAVE_LIBXML_NANOHTTP_H)
check_include_file("libxml/parser.h" HAVE_LIBXML_PARSER_H)
check_include_file("libxml/schemasinternals.h" HAVE_LIBXML_SCHEMASINTERNALS_H)
check_include_file("libxml/schemastypes.h" HAVE_LIBXML_XMLSCHEMASTYPES_H)
check_include_file("libxml/xmlschemas.h" HAVE_LIBXML_XMLSCHEMAS_H)
check_include_file("limits.h" HAVE_LIMITS_H)
check_include_file("math.h" HAVE_MATH_H)
check_include_file("memory.h" HAVE_MEMORY_H)
check_include_file("mhash.h" HAVE_MHASH_H)
check_include_file("mpfr.h" HAVE_MPFR_H)
check_include_file("regex.h" HAVE_REGEX_H)
check_include_file("setjmp.h" HAVE_SETJMP_H)
check_include_file("stdint.h" HAVE_STDINT_H)
check_include_file("stdlib.h" HAVE_STDLIB_H)
check_include_file("string.h" HAVE_STRING_H)
check_include_file("strings.h" HAVE_STRINGS_H)
check_include_file("sys/param.h" HAVE_SYS_PARAM_H)
check_include_file("sys/stat.h" HAVE_SYS_STAT_H)
check_include_file("sys/time.h" HAVE_SYS_TIME_H)
check_include_file("time.h" HAVE_TIME_H)
check_include_file("sys/types.h" HAVE_SYS_TYPES_H)
check_include_file("unistd.h" HAVE_UNISTD_H)
check_include_file("xmlparse.h" HAVE_XMLPARSE_H)

if(NOT HAVE_TIME_H)
set(HAVE_TIME_H 0)
endif(NOT HAVE_TIME_H)
if(NOT HAVE_SYS_TIME_H)
set(HAVE_SYS_TIME_H 0)
endif(NOT HAVE_SYS_TIME_H)


# need 'extern int optind' declaration? * NEED_OPTIND_DECLARATION

set(PACKAGE "rasqal")
set(PACKAGE_BUGREPORT "kde-windows@kde.org")
set(PACKAGE_NAME "rasqal")
set(PACKAGE_STRING "\"${PACKAGE} ${VERSION}\"")
set(PACKAGE_TARNAME "$PACKAGE_STRING{}")
set(PACKAGE_URL "http://windows.kde.org")
set(PACKAGE_VERSION ${VERSION})

set(HAVE_REGEX_PCRE 1) # ensured by findpcre
#set(HAVE_TM_GMTOFF 0) # no idea how to test this

# Decimal from GNU MP library 
#set(RASQAL_DECIMAL_GMP 1)

# Decimal from MPFR library 
#set(RASQAL_DECIMAL_MPFR 0)

# Decimal without a library 
#set(RASQAL_DECIMAL_NONE 0)

# Use gcrypt library for message digests 
#set(RASQAL_DIGEST_GCRYPT 0)

# Use internal routines for message digests 
set(RASQAL_DIGEST_INTERNAL 1)

# Use mhash library for message digests 
#set(RASQAL_DIGEST_MHASH 0)

# Use no message digest library 
#set(RASQAL_DIGEST_NONE 0)

# Building LAQRS query 
set(RASQAL_QUERY_LAQRS 1)

# Building RDQL query 
set(RASQAL_QUERY_RDQL 1)

# Building SPARQL query 
set(RASQAL_QUERY_SPARQL 1)

# Use no regex library 
#set(RASQAL_REGEX_NONE 0)

# Use PCRE regex library 
set(RASQAL_REGEX_PCRE 1)

# Use posix regex library 
#set(RASQAL_REGEX_POSIX 0)

# defined in win32_raptor_config.h
#set(RAPTOR_XML_LIBXML 1)
# The size of `unsigned char', as computed by sizeof. * SIZEOF_UNSIGNED_CHAR
# The size of `unsigned int', as computed by sizeof. * SIZEOF_UNSIGNED_INT
# The size of `unsigned long', as computed by sizeof. * SIZEOF_UNSIGNED_LONG
# The size of `unsigned short', as computed by sizeof. * SIZEOF_UNSIGNED_SHORT
set(STDC_HEADERS 1)

configure_file(src/rasqal-config.h.cmake ${CMAKE_BINARY_DIR}/rasqal_config.h)
add_definitions(-DHAVE_CONFIG_H)
