#/* Have curl/curl.h * HAVE_CURL_CURL_H
#/* INN parsedate function present * HAVE_INN_PARSEDATE

include(CheckIncludeFile)
include(CheckFunctionExists)
check_include_file("dlfcn.h" HAVE_DLFCN_H)
check_include_file("errno.h" HAVE_ERRNO_H)
check_include_file("expat.h" HAVE_EXPAT_H)
check_include_file("fcntl.h" HAVE_FCNTL_H)
check_include_file("fetch.h" HAVE_FETCH_H)
check_include_file("getopt.h" HAVE_GETOPT_H)
check_include_file("inttypes.h" HAVE_INTTYPES_H)
check_include_file("libxml/hash.h" HAVE_LIBXML_HASH_H)
check_include_file("libxml/HTMLparser.h" HAVE_LIBXML_HTMLPARSER_H)
check_include_file("libxml/nanohttp.h" HAVE_LIBXML_NANOHTTP_H)
check_include_file("libxml/parser.h" HAVE_LIBXML_PARSER_H)
check_include_file("libxml/SAX2.h" HAVE_LIBXML_SAX2_H)
check_include_file("libxslt/xslt.h" HAVE_LIBXSLT_XSLT_H)
check_include_file("limits.h" HAVE_LIMITS_H)
check_include_file("math.h" HAVE_MATH_H)
check_include_file("memory.h" HAVE_MEMORY_H)
check_include_file("setjmp.h" HAVE_SETJMP_H)
check_include_file("stdint.h" HAVE_STDINT_H)
check_include_file("stdlib.h" HAVE_STDLIB_H)
check_include_file("strings.h" HAVE_STRINGS_H)
check_include_file("string.h" HAVE_STRING_H)
check_include_file("sys/param.h" HAVE_SYS_PARAM_H)
check_include_file("sys/stat.h" HAVE_SYS_STAT_H)
check_include_file("sys/time.h" HAVE_SYS_TIME_H)
check_include_file("sys/types.h" HAVE_SYS_TYPES_H)
check_include_file("unistd.h" HAVE_UNISTD_H)
check_include_file("xmlparse.h" HAVE_XMLPARSE_H)

check_function_exists("getopt" HAVE_GETOPT)
check_function_exists("getopt_long" HAVE_GETOPT_LONG)
check_function_exists("gettimeofday" HAVE_GETTIMEOFDAY)
check_function_exists("isascii" HAVE_ISASCII)
check_function_exists("setjmp" HAVE_SETJMP)
check_function_exists("strcasecmp" HAVE_STRCASECMP)
check_function_exists("strtok_r" HAVE_STRTOK_R)
check_function_exists("stricmp" HAVE_STRICMP)
check_function_exists("vsnprintf" HAVE_VSNPRINTF)
check_function_exists("xmlCtxtUseOptions" HAVE_XMLCTXTUSEOPTIONS)
check_function_exists("xmlSAX2InternalSubset" HAVE_XMLSAX2INTERNALSUBSET)

# need 'extern int optind' declaration? * NEED_OPTIND_DECLARATION

set(PACKAGE "raptor2")
set(PACKAGE_BUGREPORT "kde-windows@kde.org")
set(PACKAGE_NAME "raptor2")
set(PACKAGE_STRING "\"${PACKAGE} ${VERSION}\"")
set(PACKAGE_TARNAME "$PACKAGE_STRING{}")
set(PACKAGE_URL "http://windows.kde.org")
set(PACKAGE_VERSION ${VERSION})

# does libxml struct xmlEntity have a field etype * RAPTOR_LIBXML_ENTITY_ETYPE
# does libxml struct xmlEntity have a field name_length * RAPTOR_LIBXML_ENTITY_NAME_LENGTH
# does libxml have HTML_PARSE_NONET * RAPTOR_LIBXML_HTML_PARSE_NONET
# does libxml xmlSAXHandler have externalSubset field * RAPTOR_LIBXML_XMLSAXHANDLER_EXTERNALSUBSET
# does libxml xmlSAXHandler have initialized field * RAPTOR_LIBXML_XMLSAXHANDLER_INITIALIZED
# does libxml have XML_PARSE_NONET * RAPTOR_LIBXML_XML_PARSE_NONET

set(RAPTOR_MIN_VERSION_DECIMAL ${RAPTOR_VERSION_DECIMAL})
set(RAPTOR_NFC_CHECK 1)
set(RAPTOR_PARSER_GRDDL 1)
set(RAPTOR_PARSER_GUESS 1)
set(RAPTOR_PARSER_JSON 1)
set(RAPTOR_PARSER_NQUADS 1)
set(RAPTOR_PARSER_NTRIPLES 1)
set(RAPTOR_PARSER_RDFA 1)
set(RAPTOR_PARSER_RDFXML 1)
set(RAPTOR_PARSER_RSS 1)
set(RAPTOR_PARSER_TRIG 1)
set(RAPTOR_PARSER_TURTLE 1)
set(RAPTOR_SERIALIZER_ATOM 1)
set(RAPTOR_SERIALIZER_DOT 1)
set(RAPTOR_SERIALIZER_HTML 1)
set(RAPTOR_SERIALIZER_JSON 1)
set(RAPTOR_SERIALIZER_NQUADS 1)
set(RAPTOR_SERIALIZER_NTRIPLES 1)
set(RAPTOR_SERIALIZER_RDFXML 1)
set(RAPTOR_SERIALIZER_RDFXML_ABBREV 1)
set(RAPTOR_SERIALIZER_RSS_1_0 1)
set(RAPTOR_SERIALIZER_TURTLE 1)

set(RAPTOR_WWW_LIBCURL 1)
# Have libfetch WWW library * RAPTOR_WWW_LIBFETCH
set(RAPTOR_WWW_LIBXML 1)
# No WWW library * RAPTOR_WWW_NONE
set(RAPTOR_XML_1_1 1)
set(RAPTOR_XML_EXPAT 0)
# defined in win32_raptor_config.h
#set(RAPTOR_XML_LIBXML 1)
# The size of `unsigned char', as computed by sizeof. * SIZEOF_UNSIGNED_CHAR
# The size of `unsigned int', as computed by sizeof. * SIZEOF_UNSIGNED_INT
# The size of `unsigned long', as computed by sizeof. * SIZEOF_UNSIGNED_LONG
# The size of `unsigned short', as computed by sizeof. * SIZEOF_UNSIGNED_SHORT
set(STDC_HEADERS 1)

configure_file(src/raptor_config.h.cmake ${CMAKE_BINARY_DIR}/raptor_config.h)
add_definitions(-DHAVE_CONFIG_H)
add_definitions(-DRAPTOR_PARSER_RDFA=1)
