# Try to find Libiconv functionality
# Once done this will define
#
#  LIBICONV_FOUND - system has Libiconv
#  LIBICONV_INCLUDE_DIR - Libiconv include directory
#  LIBICONV_LIBRARIES - Libraries needed to use Libiconv
#
# Copyright (c) 2010, Patrick Spendrin, <ps_ml@gmx.de>
#
# Redistribution and use is allowed according to the terms of the BSD license.

if(LIBICONV_INCLUDE_DIR AND LIBICONV_LIB_FOUND)
  set(Libiconv_FIND_QUIETLY TRUE)
endif(LIBICONV_INCLUDE_DIR AND LIBICONV_LIB_FOUND)

find_path(LIBICONV_INCLUDE_DIR iconv.h)

set(LIBICONV_LIB_FOUND FALSE)

if(LIBICONV_INCLUDE_DIR)
    find_library(LIBICONV_LIBRARIES NAMES iconv iconv2 iconv-2 libiconv libiconv2 libiconv-2 )
    if(LIBICONV_LIBRARIES)
      set(LIBICONV_LIB_FOUND TRUE)
    endif(LIBICONV_LIBRARIES)
endif(LIBICONV_INCLUDE_DIR)

# I have no idea what this is about, but it seems to be used quite often, so I add this here
set(LIBICONV_CONST const)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(Libiconv  DEFAULT_MSG  LIBICONV_LIBRARIES  LIBICONV_LIB_FOUND)

mark_as_advanced(LIBICONV_INCLUDE_DIR  LIBICONV_LIBRARIES  LIBICONV_CONST  LIBICONV_LIB_FOUND)
